#  Created byMartin.cz
#  Copyright (c) Martin Strohalm. All rights reserved.

from . values import *
from . enum import Enum

# define line styles
LINE_STYLE_CUSTOM = CUSTOM
LINE_STYLE_SOLID = SOLID
LINE_STYLE_DOTTED = DOTTED
LINE_STYLE_DASHED = DASHED
LINE_STYLE_DASHDOTTED = DASHDOTTED

LINE_STYLE = Enum(
    CUSTOM = LINE_STYLE_CUSTOM,
    SOLID = LINE_STYLE_SOLID,
    DOTTED = LINE_STYLE_DOTTED,
    DASHED = LINE_STYLE_DASHED,
    DASHDOTTED = LINE_STYLE_DASHDOTTED)

# define line caps
LINE_CAP_BUTT = BUTT
LINE_CAP_SQUARE = SQUARE
LINE_CAP_ROUND = ROUND

LINE_CAP = Enum(
    BUTT = LINE_CAP_BUTT,
    SQUARE = LINE_CAP_SQUARE,
    ROUND = LINE_CAP_ROUND)

# define line joins
LINE_JOIN_BEVEL = BEVEL
LINE_JOIN_MITER = MITER
LINE_JOIN_ROUND = ROUND

LINE_JOIN = Enum(
    BEVEL = LINE_JOIN_BEVEL,
    MITER = LINE_JOIN_MITER,
    ROUND = LINE_JOIN_ROUND)

# define line step
LINE_STEP_NONE = NONE
LINE_STEP_BEFORE = BEFORE
LINE_STEP_MIDDLE = MIDDLE
LINE_STEP_AFTER = AFTER

LINE_STEP = Enum(
    NONE = LINE_STEP_NONE,
    BEFORE = LINE_STEP_BEFORE,
    MIDDLE = LINE_STEP_MIDDLE,
    AFTER = LINE_STEP_AFTER)

# define line dash values
DASH_VALUES_DOTTED = (1, 5)
DASH_VALUES_DASHED = (5, 5)
DASH_VALUES_DASHDOTTED = (5, 5, 1, 5)

DASH_VALUES = Enum(
    DOTTED = DASH_VALUES_DOTTED,
    DASHED = DASH_VALUES_DASHED,
    DASHDOTTED = DASH_VALUES_DASHDOTTED)

# define fill style
FILL_STYLE_SOLID = SOLID
FILL_STYLE_TRANS = TRANS

FILL_STYLE = Enum(
    SOLID = FILL_STYLE_SOLID,
    TRANS = FILL_STYLE_TRANS)

# define fill rule
FILL_RULE_EVENODD = EVENODD
FILL_RULE_WINDING = WINDING

FILL_RULE = Enum(
    EVENODD = FILL_RULE_EVENODD,
    WINDING = FILL_RULE_WINDING)

# define path commands
PATH_CLOSE = 'Z'
PATH_MOVE = 'M'
PATH_LINE = 'L'
PATH_CURVE = 'C'

PATH = Enum(
    CLOSE = PATH_CLOSE,
    MOVE = PATH_MOVE,
    LINE = PATH_LINE,
    CURVE = PATH_CURVE)

# define available markers
MARKER_ASTERISK = '*'
MARKER_CIRCLE = 'o'
MARKER_CROSS = 'x'
MARKER_PLUS = '+'
MARKER_TRIANGLE = 't'
MARKER_SQUARE = 's'
MARKER_DIAMOND = 'd'
MARKER_PENTAGON = 'p'
MARKER_HEXAGON = 'h'

MARKER = Enum(
    ASTERISK = MARKER_ASTERISK,
    CIRCLE = MARKER_CIRCLE,
    CROSS = MARKER_CROSS,
    PLUS = MARKER_PLUS,
    TRIANGLE = MARKER_TRIANGLE,
    SQUARE = MARKER_SQUARE,
    DIAMOND = MARKER_DIAMOND,
    PENTAGON = MARKER_PENTAGON,
    HEXAGON = MARKER_HEXAGON)

# define available arrows
ARROW_ARC = 'c'
ARROW_BOW = ')'
ARROW_CONNECT_LINE = 'z'
ARROW_CONNECT_CURVE = 's'
ARROW_CURVE = '~'
ARROW_LINE = '-'
ARROW_RAY = '/'

ARROW = Enum(
    ARC = ARROW_ARC,
    BOW = ARROW_BOW,
    CONNECT_LINE = ARROW_CONNECT_LINE,
    CONNECT_CURVE = ARROW_CONNECT_CURVE,
    CURVE = ARROW_CURVE,
    LINE = ARROW_LINE,
    RAY = ARROW_RAY)

# define available heads
HEAD_CIRCLE = 'o'
HEAD_LINE = '|'
HEAD_NORMAL = '|>'
HEAD_NORMAL_B = '<|'
HEAD_OPEN = '>'
HEAD_OPEN_B = '<'
HEAD_VEE = '>>'
HEAD_VEE_B = '<<'

HEAD = Enum(
    CIRCLE = HEAD_CIRCLE,
    LINE = HEAD_LINE,
    NORMAL = HEAD_NORMAL,
    NORMAL_B = HEAD_NORMAL_B,
    OPEN = HEAD_OPEN,
    OPEN_B = HEAD_OPEN_B,
    VEE = HEAD_VEE,
    VEE_B = HEAD_VEE_B)
