---
title: Version 2.0.0 of ChemFuseKit released!
description: The release notes for this version.
slug: version-2-0-0-released
authors: f-aguzzi
tags: [release, chemfusekit]
hide_table_of_contents: false
---

We are proud to release a new version of `chemfusekit`: `chemfusekitv2.0.0`.

In the ongoing pursuit of a more streamlined and structured project, we're excited to share the latest updates.

The `BaseDataModel` class now serves as the standard input for all classifiers. This versatile class is further extended by `PCADataModel`, the output of the `PCA` class, and `LLDFDataModel`, the output of the `LLDF` class.

We've also introduced smart adjustments for some classifiers based on the input type. For instance, `LDA` can now autonomously infer its own number of components if its input is a `PCADataModel`. Moreover, `LR` has been enhanced to predict from all types derived from `BaseDataModel`, eliminating the need for manual feeding of PCA outputs.

Inheritance from `BaseClassifier` is a new standard for all classifiers, with their settings inheriting from `BaseSettings`. The prediction process has been moved up the class hierarchy into `BaseClassifier`. Additionally, BaseClassifier introduces a new feature for all classifiers: the ability to import and export trained models to and from files.

We believe these changes will significantly improve the usability and consistency of the project. Stay tuned for more updates!

<!-- truncate -->

## BaseDataModel

Here is a diagram showing the inheritance structure for the `BaseDataModel`:

```mermaid
classDiagram
    class BaseDataModel {
        +x_data: DataFrame
        +x_train: DataFrame
        +y: ndarray
        __init__(x_data, x_train, y)
    }

    class LLDFDataModel {
        ...
        __init__(...)
    }

    class PCADataModel {
        +array_scores: ndarray
        +components: int
        __init__(..., array_scores)
    }

    BaseDataModel *-- LLDFDataModel
    BaseDataModel *-- PCADataModel
```

## BaseClassifier and BaseSettings

Here are some diagram showing the inheritance structure for `BaseSettings` and `BaseClassifier`:

```mermaid
classDiagram
    class BaseSettings {
        +output: GraphMode
        +test_split: bool
        __init__(output, test_split)
    }

    class KNNSettings {
        ...
    }

    class LDASettings {
        ...
    }

    class LRSettings {
        ...
    }

    class PLSDASettings {
        ...
    }

    class SVMSettings {
        ...
    }

    BaseSettings *-- KNNSettings
    BaseSettings *-- LDASettings
    BaseSettings *-- LRSettings
    BaseSettings *-- PLSDASettings
    BaseSettings *-- SVMSettings 
```

```mermaid
classDiagram
    
    class BaseClassifier {
        +settings: BaseSettings
        +data: BaseDataModel
        +model: sklearn model
        __init__(settings, data)
        import_model(import_path: str)
        export_model(export_path: str)
        predict(x_data: pd.DataFrame)
    }

    class KNN {
        ...
    }

    class LDA {
        ...
    }

    class LR {
        ...
    }

    class PLSDA {
        ...
    }

    class SVM {
        ...
    }

    BaseClassifier *-- KNN
    BaseClassifier *-- LDA
    BaseClassifier *-- LR
    BaseClassifier *-- PLSDA
    BaseClassifier *-- SVM
```