# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['TopicArgs', 'Topic']

@pulumi.input_type
class TopicArgs:
    def __init__(__self__, *,
                 partitions: pulumi.Input[builtins.int],
                 replication_factor: pulumi.Input[builtins.int],
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Topic resource.
        :param pulumi.Input[builtins.int] partitions: Number of partitions.
        :param pulumi.Input[builtins.int] replication_factor: Number of replicas.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] config: A map of string k/v attributes.
        :param pulumi.Input[builtins.str] name: The name of the topic.
        """
        pulumi.set(__self__, "partitions", partitions)
        pulumi.set(__self__, "replication_factor", replication_factor)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Input[builtins.int]:
        """
        Number of partitions.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Input[builtins.int]:
        """
        Number of replicas.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "replication_factor", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of string k/v attributes.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _TopicState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partitions: Optional[pulumi.Input[builtins.int]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering Topic resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] config: A map of string k/v attributes.
        :param pulumi.Input[builtins.str] name: The name of the topic.
        :param pulumi.Input[builtins.int] partitions: Number of partitions.
        :param pulumi.Input[builtins.int] replication_factor: Number of replicas.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        A map of string k/v attributes.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of partitions.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Number of replicas.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replication_factor", value)


@pulumi.type_token("kafka:index/topic:Topic")
class Topic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partitions: Optional[pulumi.Input[builtins.int]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Create a Topic resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] config: A map of string k/v attributes.
        :param pulumi.Input[builtins.str] name: The name of the topic.
        :param pulumi.Input[builtins.int] partitions: Number of partitions.
        :param pulumi.Input[builtins.int] replication_factor: Number of replicas.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Topic resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param TopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 partitions: Optional[pulumi.Input[builtins.int]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TopicArgs.__new__(TopicArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["name"] = name
            if partitions is None and not opts.urn:
                raise TypeError("Missing required property 'partitions'")
            __props__.__dict__["partitions"] = partitions
            if replication_factor is None and not opts.urn:
                raise TypeError("Missing required property 'replication_factor'")
            __props__.__dict__["replication_factor"] = replication_factor
        super(Topic, __self__).__init__(
            'kafka:index/topic:Topic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            partitions: Optional[pulumi.Input[builtins.int]] = None,
            replication_factor: Optional[pulumi.Input[builtins.int]] = None) -> 'Topic':
        """
        Get an existing Topic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] config: A map of string k/v attributes.
        :param pulumi.Input[builtins.str] name: The name of the topic.
        :param pulumi.Input[builtins.int] partitions: Number of partitions.
        :param pulumi.Input[builtins.int] replication_factor: Number of replicas.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TopicState.__new__(_TopicState)

        __props__.__dict__["config"] = config
        __props__.__dict__["name"] = name
        __props__.__dict__["partitions"] = partitions
        __props__.__dict__["replication_factor"] = replication_factor
        return Topic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        A map of string k/v attributes.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[builtins.int]:
        """
        Number of partitions.
        """
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Output[builtins.int]:
        """
        Number of replicas.
        """
        return pulumi.get(self, "replication_factor")

