from typing import Optional

from flet.controls.base_control import control
from flet.controls.border_radius import BorderRadiusValue
from flet.controls.control import Control
from flet.controls.gradients import Gradient
from flet.controls.layout_control import LayoutControl
from flet.controls.types import BlendMode

__all__ = ["ShaderMask"]


@control("ShaderMask")
class ShaderMask(LayoutControl):
    """
    Applies a mask generated by a shader to its [`content`][(c).].

    For example, it can be used to gradually fade out the edge of a control by
    using a [`LinearGradient`][flet.] mask.

    ```python
    ft.ShaderMask(
        blend_mode=ft.BlendMode.MULTIPLY,
        shader=ft.LinearGradient(
            begin=ft.Alignment.CENTER_LEFT,
            end=ft.Alignment.CENTER_RIGHT,
            colors=[ft.Colors.WHITE, ft.Colors.BLACK],
            tile_mode=ft.GradientTileMode.CLAMP,
        ),
        content=ft.Image(
            src="https://picsum.photos/id/288/300/300",
            height=300,
            fit=ft.BoxFit.FILL,
        )
    ```
    """

    shader: Gradient
    """
    Use gradient as a shader.
    """

    content: Optional[Control] = None
    """
    The Control to which the [`shader`][(c).] is applied.
    """

    blend_mode: BlendMode = BlendMode.MODULATE
    """
    The blend mode to use when applying the shader to the
    [`content`][(c).].
    """

    border_radius: Optional[BorderRadiusValue] = None
    """
    The radius of the mask.
    """
