"""
Flet Material Icons

To generate/update this file run from the root of the repository:

```
uv run .github/scripts/generate_icons.py
```
"""

from flet.controls.icon_data import IconData

__all__ = ["Icons"]


class Icons(IconData, package_name="flet", class_name="Icons"):
    ABC = 0x10000
    ABC_OUTLINED = 0x10001
    ABC_ROUNDED = 0x10002
    ABC_SHARP = 0x10003
    AC_UNIT = 0x10004
    AC_UNIT_OUTLINED = 0x10005
    AC_UNIT_ROUNDED = 0x10006
    AC_UNIT_SHARP = 0x10007
    ACCESS_ALARM = 0x10008
    ACCESS_ALARM_OUTLINED = 0x10009
    ACCESS_ALARM_ROUNDED = 0x1000A
    ACCESS_ALARM_SHARP = 0x1000B
    ACCESS_ALARMS = 0x1000C
    ACCESS_ALARMS_OUTLINED = 0x1000D
    ACCESS_ALARMS_ROUNDED = 0x1000E
    ACCESS_ALARMS_SHARP = 0x1000F
    ACCESS_TIME = 0x10010
    ACCESS_TIME_FILLED = 0x10011
    ACCESS_TIME_FILLED_OUTLINED = 0x10012
    ACCESS_TIME_FILLED_ROUNDED = 0x10013
    ACCESS_TIME_FILLED_SHARP = 0x10014
    ACCESS_TIME_OUTLINED = 0x10015
    ACCESS_TIME_ROUNDED = 0x10016
    ACCESS_TIME_SHARP = 0x10017
    ACCESSIBILITY = 0x10018
    ACCESSIBILITY_NEW = 0x10019
    ACCESSIBILITY_NEW_OUTLINED = 0x1001A
    ACCESSIBILITY_NEW_ROUNDED = 0x1001B
    ACCESSIBILITY_NEW_SHARP = 0x1001C
    ACCESSIBILITY_OUTLINED = 0x1001D
    ACCESSIBILITY_ROUNDED = 0x1001E
    ACCESSIBILITY_SHARP = 0x1001F
    ACCESSIBLE = 0x10020
    ACCESSIBLE_FORWARD = 0x10021
    ACCESSIBLE_FORWARD_OUTLINED = 0x10022
    ACCESSIBLE_FORWARD_ROUNDED = 0x10023
    ACCESSIBLE_FORWARD_SHARP = 0x10024
    ACCESSIBLE_OUTLINED = 0x10025
    ACCESSIBLE_ROUNDED = 0x10026
    ACCESSIBLE_SHARP = 0x10027
    ACCOUNT_BALANCE = 0x10028
    ACCOUNT_BALANCE_OUTLINED = 0x10029
    ACCOUNT_BALANCE_ROUNDED = 0x1002A
    ACCOUNT_BALANCE_SHARP = 0x1002B
    ACCOUNT_BALANCE_WALLET = 0x1002C
    ACCOUNT_BALANCE_WALLET_OUTLINED = 0x1002D
    ACCOUNT_BALANCE_WALLET_ROUNDED = 0x1002E
    ACCOUNT_BALANCE_WALLET_SHARP = 0x1002F
    ACCOUNT_BOX = 0x10030
    ACCOUNT_BOX_OUTLINED = 0x10031
    ACCOUNT_BOX_ROUNDED = 0x10032
    ACCOUNT_BOX_SHARP = 0x10033
    ACCOUNT_CIRCLE = 0x10034
    ACCOUNT_CIRCLE_OUTLINED = 0x10035
    ACCOUNT_CIRCLE_ROUNDED = 0x10036
    ACCOUNT_CIRCLE_SHARP = 0x10037
    ACCOUNT_TREE = 0x10038
    ACCOUNT_TREE_OUTLINED = 0x10039
    ACCOUNT_TREE_ROUNDED = 0x1003A
    ACCOUNT_TREE_SHARP = 0x1003B
    AD_UNITS = 0x1003C
    AD_UNITS_OUTLINED = 0x1003D
    AD_UNITS_ROUNDED = 0x1003E
    AD_UNITS_SHARP = 0x1003F
    ADB = 0x10040
    ADB_OUTLINED = 0x10041
    ADB_ROUNDED = 0x10042
    ADB_SHARP = 0x10043
    ADD = 0x10044
    ADD_A_PHOTO = 0x10045
    ADD_A_PHOTO_OUTLINED = 0x10046
    ADD_A_PHOTO_ROUNDED = 0x10047
    ADD_A_PHOTO_SHARP = 0x10048
    ADD_ALARM = 0x10049
    ADD_ALARM_OUTLINED = 0x1004A
    ADD_ALARM_ROUNDED = 0x1004B
    ADD_ALARM_SHARP = 0x1004C
    ADD_ALERT = 0x1004D
    ADD_ALERT_OUTLINED = 0x1004E
    ADD_ALERT_ROUNDED = 0x1004F
    ADD_ALERT_SHARP = 0x10050
    ADD_BOX = 0x10051
    ADD_BOX_OUTLINED = 0x10052
    ADD_BOX_ROUNDED = 0x10053
    ADD_BOX_SHARP = 0x10054
    ADD_BUSINESS = 0x10055
    ADD_BUSINESS_OUTLINED = 0x10056
    ADD_BUSINESS_ROUNDED = 0x10057
    ADD_BUSINESS_SHARP = 0x10058
    ADD_CALL = 0x10059
    ADD_CARD = 0x1005A
    ADD_CARD_OUTLINED = 0x1005B
    ADD_CARD_ROUNDED = 0x1005C
    ADD_CARD_SHARP = 0x1005D
    ADD_CHART = 0x1005E
    ADD_CHART_OUTLINED = 0x1005F
    ADD_CHART_ROUNDED = 0x10060
    ADD_CHART_SHARP = 0x10061
    ADD_CIRCLE = 0x10062
    ADD_CIRCLE_OUTLINE = 0x10063
    ADD_CIRCLE_OUTLINE_OUTLINED = 0x10064
    ADD_CIRCLE_OUTLINE_ROUNDED = 0x10065
    ADD_CIRCLE_OUTLINE_SHARP = 0x10066
    ADD_CIRCLE_OUTLINED = 0x10067
    ADD_CIRCLE_ROUNDED = 0x10068
    ADD_CIRCLE_SHARP = 0x10069
    ADD_COMMENT = 0x1006A
    ADD_COMMENT_OUTLINED = 0x1006B
    ADD_COMMENT_ROUNDED = 0x1006C
    ADD_COMMENT_SHARP = 0x1006D
    ADD_HOME = 0x1006E
    ADD_HOME_OUTLINED = 0x1006F
    ADD_HOME_ROUNDED = 0x10070
    ADD_HOME_SHARP = 0x10071
    ADD_HOME_WORK = 0x10072
    ADD_HOME_WORK_OUTLINED = 0x10073
    ADD_HOME_WORK_ROUNDED = 0x10074
    ADD_HOME_WORK_SHARP = 0x10075
    ADD_IC_CALL = 0x10076
    ADD_IC_CALL_OUTLINED = 0x10077
    ADD_IC_CALL_ROUNDED = 0x10078
    ADD_IC_CALL_SHARP = 0x10079
    ADD_LINK = 0x1007A
    ADD_LINK_OUTLINED = 0x1007B
    ADD_LINK_ROUNDED = 0x1007C
    ADD_LINK_SHARP = 0x1007D
    ADD_LOCATION = 0x1007E
    ADD_LOCATION_ALT = 0x1007F
    ADD_LOCATION_ALT_OUTLINED = 0x10080
    ADD_LOCATION_ALT_ROUNDED = 0x10081
    ADD_LOCATION_ALT_SHARP = 0x10082
    ADD_LOCATION_OUTLINED = 0x10083
    ADD_LOCATION_ROUNDED = 0x10084
    ADD_LOCATION_SHARP = 0x10085
    ADD_MODERATOR = 0x10086
    ADD_MODERATOR_OUTLINED = 0x10087
    ADD_MODERATOR_ROUNDED = 0x10088
    ADD_MODERATOR_SHARP = 0x10089
    ADD_OUTLINED = 0x1008A
    ADD_PHOTO_ALTERNATE = 0x1008B
    ADD_PHOTO_ALTERNATE_OUTLINED = 0x1008C
    ADD_PHOTO_ALTERNATE_ROUNDED = 0x1008D
    ADD_PHOTO_ALTERNATE_SHARP = 0x1008E
    ADD_REACTION = 0x1008F
    ADD_REACTION_OUTLINED = 0x10090
    ADD_REACTION_ROUNDED = 0x10091
    ADD_REACTION_SHARP = 0x10092
    ADD_ROAD = 0x10093
    ADD_ROAD_OUTLINED = 0x10094
    ADD_ROAD_ROUNDED = 0x10095
    ADD_ROAD_SHARP = 0x10096
    ADD_ROUNDED = 0x10097
    ADD_SHARP = 0x10098
    ADD_SHOPPING_CART = 0x10099
    ADD_SHOPPING_CART_OUTLINED = 0x1009A
    ADD_SHOPPING_CART_ROUNDED = 0x1009B
    ADD_SHOPPING_CART_SHARP = 0x1009C
    ADD_TASK = 0x1009D
    ADD_TASK_OUTLINED = 0x1009E
    ADD_TASK_ROUNDED = 0x1009F
    ADD_TASK_SHARP = 0x100A0
    ADD_TO_DRIVE = 0x100A1
    ADD_TO_DRIVE_OUTLINED = 0x100A2
    ADD_TO_DRIVE_ROUNDED = 0x100A3
    ADD_TO_DRIVE_SHARP = 0x100A4
    ADD_TO_HOME_SCREEN = 0x100A5
    ADD_TO_HOME_SCREEN_OUTLINED = 0x100A6
    ADD_TO_HOME_SCREEN_ROUNDED = 0x100A7
    ADD_TO_HOME_SCREEN_SHARP = 0x100A8
    ADD_TO_PHOTOS = 0x100A9
    ADD_TO_PHOTOS_OUTLINED = 0x100AA
    ADD_TO_PHOTOS_ROUNDED = 0x100AB
    ADD_TO_PHOTOS_SHARP = 0x100AC
    ADD_TO_QUEUE = 0x100AD
    ADD_TO_QUEUE_OUTLINED = 0x100AE
    ADD_TO_QUEUE_ROUNDED = 0x100AF
    ADD_TO_QUEUE_SHARP = 0x100B0
    ADDCHART = 0x100B1
    ADDCHART_OUTLINED = 0x100B2
    ADDCHART_ROUNDED = 0x100B3
    ADDCHART_SHARP = 0x100B4
    ADF_SCANNER = 0x100B5
    ADF_SCANNER_OUTLINED = 0x100B6
    ADF_SCANNER_ROUNDED = 0x100B7
    ADF_SCANNER_SHARP = 0x100B8
    ADJUST = 0x100B9
    ADJUST_OUTLINED = 0x100BA
    ADJUST_ROUNDED = 0x100BB
    ADJUST_SHARP = 0x100BC
    ADMIN_PANEL_SETTINGS = 0x100BD
    ADMIN_PANEL_SETTINGS_OUTLINED = 0x100BE
    ADMIN_PANEL_SETTINGS_ROUNDED = 0x100BF
    ADMIN_PANEL_SETTINGS_SHARP = 0x100C0
    ADOBE = 0x100C1
    ADOBE_OUTLINED = 0x100C2
    ADOBE_ROUNDED = 0x100C3
    ADOBE_SHARP = 0x100C4
    ADS_CLICK = 0x100C5
    ADS_CLICK_OUTLINED = 0x100C6
    ADS_CLICK_ROUNDED = 0x100C7
    ADS_CLICK_SHARP = 0x100C8
    AGRICULTURE = 0x100C9
    AGRICULTURE_OUTLINED = 0x100CA
    AGRICULTURE_ROUNDED = 0x100CB
    AGRICULTURE_SHARP = 0x100CC
    AIR = 0x100CD
    AIR_OUTLINED = 0x100CE
    AIR_ROUNDED = 0x100CF
    AIR_SHARP = 0x100D0
    AIRLINE_SEAT_FLAT = 0x100D1
    AIRLINE_SEAT_FLAT_ANGLED = 0x100D2
    AIRLINE_SEAT_FLAT_ANGLED_OUTLINED = 0x100D3
    AIRLINE_SEAT_FLAT_ANGLED_ROUNDED = 0x100D4
    AIRLINE_SEAT_FLAT_ANGLED_SHARP = 0x100D5
    AIRLINE_SEAT_FLAT_OUTLINED = 0x100D6
    AIRLINE_SEAT_FLAT_ROUNDED = 0x100D7
    AIRLINE_SEAT_FLAT_SHARP = 0x100D8
    AIRLINE_SEAT_INDIVIDUAL_SUITE = 0x100D9
    AIRLINE_SEAT_INDIVIDUAL_SUITE_OUTLINED = 0x100DA
    AIRLINE_SEAT_INDIVIDUAL_SUITE_ROUNDED = 0x100DB
    AIRLINE_SEAT_INDIVIDUAL_SUITE_SHARP = 0x100DC
    AIRLINE_SEAT_LEGROOM_EXTRA = 0x100DD
    AIRLINE_SEAT_LEGROOM_EXTRA_OUTLINED = 0x100DE
    AIRLINE_SEAT_LEGROOM_EXTRA_ROUNDED = 0x100DF
    AIRLINE_SEAT_LEGROOM_EXTRA_SHARP = 0x100E0
    AIRLINE_SEAT_LEGROOM_NORMAL = 0x100E1
    AIRLINE_SEAT_LEGROOM_NORMAL_OUTLINED = 0x100E2
    AIRLINE_SEAT_LEGROOM_NORMAL_ROUNDED = 0x100E3
    AIRLINE_SEAT_LEGROOM_NORMAL_SHARP = 0x100E4
    AIRLINE_SEAT_LEGROOM_REDUCED = 0x100E5
    AIRLINE_SEAT_LEGROOM_REDUCED_OUTLINED = 0x100E6
    AIRLINE_SEAT_LEGROOM_REDUCED_ROUNDED = 0x100E7
    AIRLINE_SEAT_LEGROOM_REDUCED_SHARP = 0x100E8
    AIRLINE_SEAT_RECLINE_EXTRA = 0x100E9
    AIRLINE_SEAT_RECLINE_EXTRA_OUTLINED = 0x100EA
    AIRLINE_SEAT_RECLINE_EXTRA_ROUNDED = 0x100EB
    AIRLINE_SEAT_RECLINE_EXTRA_SHARP = 0x100EC
    AIRLINE_SEAT_RECLINE_NORMAL = 0x100ED
    AIRLINE_SEAT_RECLINE_NORMAL_OUTLINED = 0x100EE
    AIRLINE_SEAT_RECLINE_NORMAL_ROUNDED = 0x100EF
    AIRLINE_SEAT_RECLINE_NORMAL_SHARP = 0x100F0
    AIRLINE_STOPS = 0x100F1
    AIRLINE_STOPS_OUTLINED = 0x100F2
    AIRLINE_STOPS_ROUNDED = 0x100F3
    AIRLINE_STOPS_SHARP = 0x100F4
    AIRLINES = 0x100F5
    AIRLINES_OUTLINED = 0x100F6
    AIRLINES_ROUNDED = 0x100F7
    AIRLINES_SHARP = 0x100F8
    AIRPLANE_TICKET = 0x100F9
    AIRPLANE_TICKET_OUTLINED = 0x100FA
    AIRPLANE_TICKET_ROUNDED = 0x100FB
    AIRPLANE_TICKET_SHARP = 0x100FC
    AIRPLANEMODE_ACTIVE = 0x100FD
    AIRPLANEMODE_ACTIVE_OUTLINED = 0x100FE
    AIRPLANEMODE_ACTIVE_ROUNDED = 0x100FF
    AIRPLANEMODE_ACTIVE_SHARP = 0x10100
    AIRPLANEMODE_INACTIVE = 0x10101
    AIRPLANEMODE_INACTIVE_OUTLINED = 0x10102
    AIRPLANEMODE_INACTIVE_ROUNDED = 0x10103
    AIRPLANEMODE_INACTIVE_SHARP = 0x10104
    AIRPLANEMODE_OFF = 0x10105
    AIRPLANEMODE_OFF_OUTLINED = 0x10106
    AIRPLANEMODE_OFF_ROUNDED = 0x10107
    AIRPLANEMODE_OFF_SHARP = 0x10108
    AIRPLANEMODE_ON = 0x10109
    AIRPLANEMODE_ON_OUTLINED = 0x1010A
    AIRPLANEMODE_ON_ROUNDED = 0x1010B
    AIRPLANEMODE_ON_SHARP = 0x1010C
    AIRPLAY = 0x1010D
    AIRPLAY_OUTLINED = 0x1010E
    AIRPLAY_ROUNDED = 0x1010F
    AIRPLAY_SHARP = 0x10110
    AIRPORT_SHUTTLE = 0x10111
    AIRPORT_SHUTTLE_OUTLINED = 0x10112
    AIRPORT_SHUTTLE_ROUNDED = 0x10113
    AIRPORT_SHUTTLE_SHARP = 0x10114
    ALARM = 0x10115
    ALARM_ADD = 0x10116
    ALARM_ADD_OUTLINED = 0x10117
    ALARM_ADD_ROUNDED = 0x10118
    ALARM_ADD_SHARP = 0x10119
    ALARM_OFF = 0x1011A
    ALARM_OFF_OUTLINED = 0x1011B
    ALARM_OFF_ROUNDED = 0x1011C
    ALARM_OFF_SHARP = 0x1011D
    ALARM_ON = 0x1011E
    ALARM_ON_OUTLINED = 0x1011F
    ALARM_ON_ROUNDED = 0x10120
    ALARM_ON_SHARP = 0x10121
    ALARM_OUTLINED = 0x10122
    ALARM_ROUNDED = 0x10123
    ALARM_SHARP = 0x10124
    ALBUM = 0x10125
    ALBUM_OUTLINED = 0x10126
    ALBUM_ROUNDED = 0x10127
    ALBUM_SHARP = 0x10128
    ALIGN_HORIZONTAL_CENTER = 0x10129
    ALIGN_HORIZONTAL_CENTER_OUTLINED = 0x1012A
    ALIGN_HORIZONTAL_CENTER_ROUNDED = 0x1012B
    ALIGN_HORIZONTAL_CENTER_SHARP = 0x1012C
    ALIGN_HORIZONTAL_LEFT = 0x1012D
    ALIGN_HORIZONTAL_LEFT_OUTLINED = 0x1012E
    ALIGN_HORIZONTAL_LEFT_ROUNDED = 0x1012F
    ALIGN_HORIZONTAL_LEFT_SHARP = 0x10130
    ALIGN_HORIZONTAL_RIGHT = 0x10131
    ALIGN_HORIZONTAL_RIGHT_OUTLINED = 0x10132
    ALIGN_HORIZONTAL_RIGHT_ROUNDED = 0x10133
    ALIGN_HORIZONTAL_RIGHT_SHARP = 0x10134
    ALIGN_VERTICAL_BOTTOM = 0x10135
    ALIGN_VERTICAL_BOTTOM_OUTLINED = 0x10136
    ALIGN_VERTICAL_BOTTOM_ROUNDED = 0x10137
    ALIGN_VERTICAL_BOTTOM_SHARP = 0x10138
    ALIGN_VERTICAL_CENTER = 0x10139
    ALIGN_VERTICAL_CENTER_OUTLINED = 0x1013A
    ALIGN_VERTICAL_CENTER_ROUNDED = 0x1013B
    ALIGN_VERTICAL_CENTER_SHARP = 0x1013C
    ALIGN_VERTICAL_TOP = 0x1013D
    ALIGN_VERTICAL_TOP_OUTLINED = 0x1013E
    ALIGN_VERTICAL_TOP_ROUNDED = 0x1013F
    ALIGN_VERTICAL_TOP_SHARP = 0x10140
    ALL_INBOX = 0x10141
    ALL_INBOX_OUTLINED = 0x10142
    ALL_INBOX_ROUNDED = 0x10143
    ALL_INBOX_SHARP = 0x10144
    ALL_INCLUSIVE = 0x10145
    ALL_INCLUSIVE_OUTLINED = 0x10146
    ALL_INCLUSIVE_ROUNDED = 0x10147
    ALL_INCLUSIVE_SHARP = 0x10148
    ALL_OUT = 0x10149
    ALL_OUT_OUTLINED = 0x1014A
    ALL_OUT_ROUNDED = 0x1014B
    ALL_OUT_SHARP = 0x1014C
    ALT_ROUTE = 0x1014D
    ALT_ROUTE_OUTLINED = 0x1014E
    ALT_ROUTE_ROUNDED = 0x1014F
    ALT_ROUTE_SHARP = 0x10150
    ALTERNATE_EMAIL = 0x10151
    ALTERNATE_EMAIL_OUTLINED = 0x10152
    ALTERNATE_EMAIL_ROUNDED = 0x10153
    ALTERNATE_EMAIL_SHARP = 0x10154
    AMP_STORIES = 0x10155
    AMP_STORIES_OUTLINED = 0x10156
    AMP_STORIES_ROUNDED = 0x10157
    AMP_STORIES_SHARP = 0x10158
    ANALYTICS = 0x10159
    ANALYTICS_OUTLINED = 0x1015A
    ANALYTICS_ROUNDED = 0x1015B
    ANALYTICS_SHARP = 0x1015C
    ANCHOR = 0x1015D
    ANCHOR_OUTLINED = 0x1015E
    ANCHOR_ROUNDED = 0x1015F
    ANCHOR_SHARP = 0x10160
    ANDROID = 0x10161
    ANDROID_OUTLINED = 0x10162
    ANDROID_ROUNDED = 0x10163
    ANDROID_SHARP = 0x10164
    ANIMATION = 0x10165
    ANIMATION_OUTLINED = 0x10166
    ANIMATION_ROUNDED = 0x10167
    ANIMATION_SHARP = 0x10168
    ANNOUNCEMENT = 0x10169
    ANNOUNCEMENT_OUTLINED = 0x1016A
    ANNOUNCEMENT_ROUNDED = 0x1016B
    ANNOUNCEMENT_SHARP = 0x1016C
    AOD = 0x1016D
    AOD_OUTLINED = 0x1016E
    AOD_ROUNDED = 0x1016F
    AOD_SHARP = 0x10170
    APARTMENT = 0x10171
    APARTMENT_OUTLINED = 0x10172
    APARTMENT_ROUNDED = 0x10173
    APARTMENT_SHARP = 0x10174
    API = 0x10175
    API_OUTLINED = 0x10176
    API_ROUNDED = 0x10177
    API_SHARP = 0x10178
    APP_BLOCKING = 0x10179
    APP_BLOCKING_OUTLINED = 0x1017A
    APP_BLOCKING_ROUNDED = 0x1017B
    APP_BLOCKING_SHARP = 0x1017C
    APP_REGISTRATION = 0x1017D
    APP_REGISTRATION_OUTLINED = 0x1017E
    APP_REGISTRATION_ROUNDED = 0x1017F
    APP_REGISTRATION_SHARP = 0x10180
    APP_SETTINGS_ALT = 0x10181
    APP_SETTINGS_ALT_OUTLINED = 0x10182
    APP_SETTINGS_ALT_ROUNDED = 0x10183
    APP_SETTINGS_ALT_SHARP = 0x10184
    APP_SHORTCUT = 0x10185
    APP_SHORTCUT_OUTLINED = 0x10186
    APP_SHORTCUT_ROUNDED = 0x10187
    APP_SHORTCUT_SHARP = 0x10188
    APPLE = 0x10189
    APPLE_OUTLINED = 0x1018A
    APPLE_ROUNDED = 0x1018B
    APPLE_SHARP = 0x1018C
    APPROVAL = 0x1018D
    APPROVAL_OUTLINED = 0x1018E
    APPROVAL_ROUNDED = 0x1018F
    APPROVAL_SHARP = 0x10190
    APPS = 0x10191
    APPS_OUTAGE = 0x10192
    APPS_OUTAGE_OUTLINED = 0x10193
    APPS_OUTAGE_ROUNDED = 0x10194
    APPS_OUTAGE_SHARP = 0x10195
    APPS_OUTLINED = 0x10196
    APPS_ROUNDED = 0x10197
    APPS_SHARP = 0x10198
    ARCHITECTURE = 0x10199
    ARCHITECTURE_OUTLINED = 0x1019A
    ARCHITECTURE_ROUNDED = 0x1019B
    ARCHITECTURE_SHARP = 0x1019C
    ARCHIVE = 0x1019D
    ARCHIVE_OUTLINED = 0x1019E
    ARCHIVE_ROUNDED = 0x1019F
    ARCHIVE_SHARP = 0x101A0
    AREA_CHART = 0x101A1
    AREA_CHART_OUTLINED = 0x101A2
    AREA_CHART_ROUNDED = 0x101A3
    AREA_CHART_SHARP = 0x101A4
    ARROW_BACK = 0x101A5
    ARROW_BACK_IOS = 0x101A6
    ARROW_BACK_IOS_NEW = 0x101A7
    ARROW_BACK_IOS_NEW_OUTLINED = 0x101A8
    ARROW_BACK_IOS_NEW_ROUNDED = 0x101A9
    ARROW_BACK_IOS_NEW_SHARP = 0x101AA
    ARROW_BACK_IOS_OUTLINED = 0x101AB
    ARROW_BACK_IOS_ROUNDED = 0x101AC
    ARROW_BACK_IOS_SHARP = 0x101AD
    ARROW_BACK_OUTLINED = 0x101AE
    ARROW_BACK_ROUNDED = 0x101AF
    ARROW_BACK_SHARP = 0x101B0
    ARROW_CIRCLE_DOWN = 0x101B1
    ARROW_CIRCLE_DOWN_OUTLINED = 0x101B2
    ARROW_CIRCLE_DOWN_ROUNDED = 0x101B3
    ARROW_CIRCLE_DOWN_SHARP = 0x101B4
    ARROW_CIRCLE_LEFT = 0x101B5
    ARROW_CIRCLE_LEFT_OUTLINED = 0x101B6
    ARROW_CIRCLE_LEFT_ROUNDED = 0x101B7
    ARROW_CIRCLE_LEFT_SHARP = 0x101B8
    ARROW_CIRCLE_RIGHT = 0x101B9
    ARROW_CIRCLE_RIGHT_OUTLINED = 0x101BA
    ARROW_CIRCLE_RIGHT_ROUNDED = 0x101BB
    ARROW_CIRCLE_RIGHT_SHARP = 0x101BC
    ARROW_CIRCLE_UP = 0x101BD
    ARROW_CIRCLE_UP_OUTLINED = 0x101BE
    ARROW_CIRCLE_UP_ROUNDED = 0x101BF
    ARROW_CIRCLE_UP_SHARP = 0x101C0
    ARROW_DOWNWARD = 0x101C1
    ARROW_DOWNWARD_OUTLINED = 0x101C2
    ARROW_DOWNWARD_ROUNDED = 0x101C3
    ARROW_DOWNWARD_SHARP = 0x101C4
    ARROW_DROP_DOWN = 0x101C5
    ARROW_DROP_DOWN_CIRCLE = 0x101C6
    ARROW_DROP_DOWN_CIRCLE_OUTLINED = 0x101C7
    ARROW_DROP_DOWN_CIRCLE_ROUNDED = 0x101C8
    ARROW_DROP_DOWN_CIRCLE_SHARP = 0x101C9
    ARROW_DROP_DOWN_OUTLINED = 0x101CA
    ARROW_DROP_DOWN_ROUNDED = 0x101CB
    ARROW_DROP_DOWN_SHARP = 0x101CC
    ARROW_DROP_UP = 0x101CD
    ARROW_DROP_UP_OUTLINED = 0x101CE
    ARROW_DROP_UP_ROUNDED = 0x101CF
    ARROW_DROP_UP_SHARP = 0x101D0
    ARROW_FORWARD = 0x101D1
    ARROW_FORWARD_IOS = 0x101D2
    ARROW_FORWARD_IOS_OUTLINED = 0x101D3
    ARROW_FORWARD_IOS_ROUNDED = 0x101D4
    ARROW_FORWARD_IOS_SHARP = 0x101D5
    ARROW_FORWARD_OUTLINED = 0x101D6
    ARROW_FORWARD_ROUNDED = 0x101D7
    ARROW_FORWARD_SHARP = 0x101D8
    ARROW_LEFT = 0x101D9
    ARROW_LEFT_OUTLINED = 0x101DA
    ARROW_LEFT_ROUNDED = 0x101DB
    ARROW_LEFT_SHARP = 0x101DC
    ARROW_OUTWARD = 0x101DD
    ARROW_OUTWARD_OUTLINED = 0x101DE
    ARROW_OUTWARD_ROUNDED = 0x101DF
    ARROW_OUTWARD_SHARP = 0x101E0
    ARROW_RIGHT = 0x101E1
    ARROW_RIGHT_ALT = 0x101E2
    ARROW_RIGHT_ALT_OUTLINED = 0x101E3
    ARROW_RIGHT_ALT_ROUNDED = 0x101E4
    ARROW_RIGHT_ALT_SHARP = 0x101E5
    ARROW_RIGHT_OUTLINED = 0x101E6
    ARROW_RIGHT_ROUNDED = 0x101E7
    ARROW_RIGHT_SHARP = 0x101E8
    ARROW_UPWARD = 0x101E9
    ARROW_UPWARD_OUTLINED = 0x101EA
    ARROW_UPWARD_ROUNDED = 0x101EB
    ARROW_UPWARD_SHARP = 0x101EC
    ART_TRACK = 0x101ED
    ART_TRACK_OUTLINED = 0x101EE
    ART_TRACK_ROUNDED = 0x101EF
    ART_TRACK_SHARP = 0x101F0
    ARTICLE = 0x101F1
    ARTICLE_OUTLINED = 0x101F2
    ARTICLE_ROUNDED = 0x101F3
    ARTICLE_SHARP = 0x101F4
    ASPECT_RATIO = 0x101F5
    ASPECT_RATIO_OUTLINED = 0x101F6
    ASPECT_RATIO_ROUNDED = 0x101F7
    ASPECT_RATIO_SHARP = 0x101F8
    ASSESSMENT = 0x101F9
    ASSESSMENT_OUTLINED = 0x101FA
    ASSESSMENT_ROUNDED = 0x101FB
    ASSESSMENT_SHARP = 0x101FC
    ASSIGNMENT = 0x101FD
    ASSIGNMENT_ADD = 0x101FE
    ASSIGNMENT_IND = 0x101FF
    ASSIGNMENT_IND_OUTLINED = 0x10200
    ASSIGNMENT_IND_ROUNDED = 0x10201
    ASSIGNMENT_IND_SHARP = 0x10202
    ASSIGNMENT_LATE = 0x10203
    ASSIGNMENT_LATE_OUTLINED = 0x10204
    ASSIGNMENT_LATE_ROUNDED = 0x10205
    ASSIGNMENT_LATE_SHARP = 0x10206
    ASSIGNMENT_OUTLINED = 0x10207
    ASSIGNMENT_RETURN = 0x10208
    ASSIGNMENT_RETURN_OUTLINED = 0x10209
    ASSIGNMENT_RETURN_ROUNDED = 0x1020A
    ASSIGNMENT_RETURN_SHARP = 0x1020B
    ASSIGNMENT_RETURNED = 0x1020C
    ASSIGNMENT_RETURNED_OUTLINED = 0x1020D
    ASSIGNMENT_RETURNED_ROUNDED = 0x1020E
    ASSIGNMENT_RETURNED_SHARP = 0x1020F
    ASSIGNMENT_ROUNDED = 0x10210
    ASSIGNMENT_SHARP = 0x10211
    ASSIGNMENT_TURNED_IN = 0x10212
    ASSIGNMENT_TURNED_IN_OUTLINED = 0x10213
    ASSIGNMENT_TURNED_IN_ROUNDED = 0x10214
    ASSIGNMENT_TURNED_IN_SHARP = 0x10215
    ASSIST_WALKER = 0x10216
    ASSIST_WALKER_OUTLINED = 0x10217
    ASSIST_WALKER_ROUNDED = 0x10218
    ASSIST_WALKER_SHARP = 0x10219
    ASSISTANT = 0x1021A
    ASSISTANT_DIRECTION = 0x1021B
    ASSISTANT_DIRECTION_OUTLINED = 0x1021C
    ASSISTANT_DIRECTION_ROUNDED = 0x1021D
    ASSISTANT_DIRECTION_SHARP = 0x1021E
    ASSISTANT_NAVIGATION = 0x1021F
    ASSISTANT_OUTLINED = 0x10220
    ASSISTANT_PHOTO = 0x10221
    ASSISTANT_PHOTO_OUTLINED = 0x10222
    ASSISTANT_PHOTO_ROUNDED = 0x10223
    ASSISTANT_PHOTO_SHARP = 0x10224
    ASSISTANT_ROUNDED = 0x10225
    ASSISTANT_SHARP = 0x10226
    ASSURED_WORKLOAD = 0x10227
    ASSURED_WORKLOAD_OUTLINED = 0x10228
    ASSURED_WORKLOAD_ROUNDED = 0x10229
    ASSURED_WORKLOAD_SHARP = 0x1022A
    ATM = 0x1022B
    ATM_OUTLINED = 0x1022C
    ATM_ROUNDED = 0x1022D
    ATM_SHARP = 0x1022E
    ATTACH_EMAIL = 0x1022F
    ATTACH_EMAIL_OUTLINED = 0x10230
    ATTACH_EMAIL_ROUNDED = 0x10231
    ATTACH_EMAIL_SHARP = 0x10232
    ATTACH_FILE = 0x10233
    ATTACH_FILE_OUTLINED = 0x10234
    ATTACH_FILE_ROUNDED = 0x10235
    ATTACH_FILE_SHARP = 0x10236
    ATTACH_MONEY = 0x10237
    ATTACH_MONEY_OUTLINED = 0x10238
    ATTACH_MONEY_ROUNDED = 0x10239
    ATTACH_MONEY_SHARP = 0x1023A
    ATTACHMENT = 0x1023B
    ATTACHMENT_OUTLINED = 0x1023C
    ATTACHMENT_ROUNDED = 0x1023D
    ATTACHMENT_SHARP = 0x1023E
    ATTRACTIONS = 0x1023F
    ATTRACTIONS_OUTLINED = 0x10240
    ATTRACTIONS_ROUNDED = 0x10241
    ATTRACTIONS_SHARP = 0x10242
    ATTRIBUTION = 0x10243
    ATTRIBUTION_OUTLINED = 0x10244
    ATTRIBUTION_ROUNDED = 0x10245
    ATTRIBUTION_SHARP = 0x10246
    AUDIO_FILE = 0x10247
    AUDIO_FILE_OUTLINED = 0x10248
    AUDIO_FILE_ROUNDED = 0x10249
    AUDIO_FILE_SHARP = 0x1024A
    AUDIOTRACK = 0x1024B
    AUDIOTRACK_OUTLINED = 0x1024C
    AUDIOTRACK_ROUNDED = 0x1024D
    AUDIOTRACK_SHARP = 0x1024E
    AUTO_AWESOME = 0x1024F
    AUTO_AWESOME_MOSAIC = 0x10250
    AUTO_AWESOME_MOSAIC_OUTLINED = 0x10251
    AUTO_AWESOME_MOSAIC_ROUNDED = 0x10252
    AUTO_AWESOME_MOSAIC_SHARP = 0x10253
    AUTO_AWESOME_MOTION = 0x10254
    AUTO_AWESOME_MOTION_OUTLINED = 0x10255
    AUTO_AWESOME_MOTION_ROUNDED = 0x10256
    AUTO_AWESOME_MOTION_SHARP = 0x10257
    AUTO_AWESOME_OUTLINED = 0x10258
    AUTO_AWESOME_ROUNDED = 0x10259
    AUTO_AWESOME_SHARP = 0x1025A
    AUTO_DELETE = 0x1025B
    AUTO_DELETE_OUTLINED = 0x1025C
    AUTO_DELETE_ROUNDED = 0x1025D
    AUTO_DELETE_SHARP = 0x1025E
    AUTO_FIX_HIGH = 0x1025F
    AUTO_FIX_HIGH_OUTLINED = 0x10260
    AUTO_FIX_HIGH_ROUNDED = 0x10261
    AUTO_FIX_HIGH_SHARP = 0x10262
    AUTO_FIX_NORMAL = 0x10263
    AUTO_FIX_NORMAL_OUTLINED = 0x10264
    AUTO_FIX_NORMAL_ROUNDED = 0x10265
    AUTO_FIX_NORMAL_SHARP = 0x10266
    AUTO_FIX_OFF = 0x10267
    AUTO_FIX_OFF_OUTLINED = 0x10268
    AUTO_FIX_OFF_ROUNDED = 0x10269
    AUTO_FIX_OFF_SHARP = 0x1026A
    AUTO_GRAPH = 0x1026B
    AUTO_GRAPH_OUTLINED = 0x1026C
    AUTO_GRAPH_ROUNDED = 0x1026D
    AUTO_GRAPH_SHARP = 0x1026E
    AUTO_MODE = 0x1026F
    AUTO_MODE_OUTLINED = 0x10270
    AUTO_MODE_ROUNDED = 0x10271
    AUTO_MODE_SHARP = 0x10272
    AUTO_STORIES = 0x10273
    AUTO_STORIES_OUTLINED = 0x10274
    AUTO_STORIES_ROUNDED = 0x10275
    AUTO_STORIES_SHARP = 0x10276
    AUTOFPS_SELECT = 0x10277
    AUTOFPS_SELECT_OUTLINED = 0x10278
    AUTOFPS_SELECT_ROUNDED = 0x10279
    AUTOFPS_SELECT_SHARP = 0x1027A
    AUTORENEW = 0x1027B
    AUTORENEW_OUTLINED = 0x1027C
    AUTORENEW_ROUNDED = 0x1027D
    AUTORENEW_SHARP = 0x1027E
    AV_TIMER = 0x1027F
    AV_TIMER_OUTLINED = 0x10280
    AV_TIMER_ROUNDED = 0x10281
    AV_TIMER_SHARP = 0x10282
    BABY_CHANGING_STATION = 0x10283
    BABY_CHANGING_STATION_OUTLINED = 0x10284
    BABY_CHANGING_STATION_ROUNDED = 0x10285
    BABY_CHANGING_STATION_SHARP = 0x10286
    BACK_HAND = 0x10287
    BACK_HAND_OUTLINED = 0x10288
    BACK_HAND_ROUNDED = 0x10289
    BACK_HAND_SHARP = 0x1028A
    BACKPACK = 0x1028B
    BACKPACK_OUTLINED = 0x1028C
    BACKPACK_ROUNDED = 0x1028D
    BACKPACK_SHARP = 0x1028E
    BACKSPACE = 0x1028F
    BACKSPACE_OUTLINED = 0x10290
    BACKSPACE_ROUNDED = 0x10291
    BACKSPACE_SHARP = 0x10292
    BACKUP = 0x10293
    BACKUP_OUTLINED = 0x10294
    BACKUP_ROUNDED = 0x10295
    BACKUP_SHARP = 0x10296
    BACKUP_TABLE = 0x10297
    BACKUP_TABLE_OUTLINED = 0x10298
    BACKUP_TABLE_ROUNDED = 0x10299
    BACKUP_TABLE_SHARP = 0x1029A
    BADGE = 0x1029B
    BADGE_OUTLINED = 0x1029C
    BADGE_ROUNDED = 0x1029D
    BADGE_SHARP = 0x1029E
    BAKERY_DINING = 0x1029F
    BAKERY_DINING_OUTLINED = 0x102A0
    BAKERY_DINING_ROUNDED = 0x102A1
    BAKERY_DINING_SHARP = 0x102A2
    BALANCE = 0x102A3
    BALANCE_OUTLINED = 0x102A4
    BALANCE_ROUNDED = 0x102A5
    BALANCE_SHARP = 0x102A6
    BALCONY = 0x102A7
    BALCONY_OUTLINED = 0x102A8
    BALCONY_ROUNDED = 0x102A9
    BALCONY_SHARP = 0x102AA
    BALLOT = 0x102AB
    BALLOT_OUTLINED = 0x102AC
    BALLOT_ROUNDED = 0x102AD
    BALLOT_SHARP = 0x102AE
    BAR_CHART = 0x102AF
    BAR_CHART_OUTLINED = 0x102B0
    BAR_CHART_ROUNDED = 0x102B1
    BAR_CHART_SHARP = 0x102B2
    BARCODE_READER = 0x102B3
    BATCH_PREDICTION = 0x102B4
    BATCH_PREDICTION_OUTLINED = 0x102B5
    BATCH_PREDICTION_ROUNDED = 0x102B6
    BATCH_PREDICTION_SHARP = 0x102B7
    BATHROOM = 0x102B8
    BATHROOM_OUTLINED = 0x102B9
    BATHROOM_ROUNDED = 0x102BA
    BATHROOM_SHARP = 0x102BB
    BATHTUB = 0x102BC
    BATHTUB_OUTLINED = 0x102BD
    BATHTUB_ROUNDED = 0x102BE
    BATHTUB_SHARP = 0x102BF
    BATTERY_0_BAR = 0x102C0
    BATTERY_0_BAR_OUTLINED = 0x102C1
    BATTERY_0_BAR_ROUNDED = 0x102C2
    BATTERY_0_BAR_SHARP = 0x102C3
    BATTERY_1_BAR = 0x102C4
    BATTERY_1_BAR_OUTLINED = 0x102C5
    BATTERY_1_BAR_ROUNDED = 0x102C6
    BATTERY_1_BAR_SHARP = 0x102C7
    BATTERY_2_BAR = 0x102C8
    BATTERY_2_BAR_OUTLINED = 0x102C9
    BATTERY_2_BAR_ROUNDED = 0x102CA
    BATTERY_2_BAR_SHARP = 0x102CB
    BATTERY_3_BAR = 0x102CC
    BATTERY_3_BAR_OUTLINED = 0x102CD
    BATTERY_3_BAR_ROUNDED = 0x102CE
    BATTERY_3_BAR_SHARP = 0x102CF
    BATTERY_4_BAR = 0x102D0
    BATTERY_4_BAR_OUTLINED = 0x102D1
    BATTERY_4_BAR_ROUNDED = 0x102D2
    BATTERY_4_BAR_SHARP = 0x102D3
    BATTERY_5_BAR = 0x102D4
    BATTERY_5_BAR_OUTLINED = 0x102D5
    BATTERY_5_BAR_ROUNDED = 0x102D6
    BATTERY_5_BAR_SHARP = 0x102D7
    BATTERY_6_BAR = 0x102D8
    BATTERY_6_BAR_OUTLINED = 0x102D9
    BATTERY_6_BAR_ROUNDED = 0x102DA
    BATTERY_6_BAR_SHARP = 0x102DB
    BATTERY_ALERT = 0x102DC
    BATTERY_ALERT_OUTLINED = 0x102DD
    BATTERY_ALERT_ROUNDED = 0x102DE
    BATTERY_ALERT_SHARP = 0x102DF
    BATTERY_CHARGING_FULL = 0x102E0
    BATTERY_CHARGING_FULL_OUTLINED = 0x102E1
    BATTERY_CHARGING_FULL_ROUNDED = 0x102E2
    BATTERY_CHARGING_FULL_SHARP = 0x102E3
    BATTERY_FULL = 0x102E4
    BATTERY_FULL_OUTLINED = 0x102E5
    BATTERY_FULL_ROUNDED = 0x102E6
    BATTERY_FULL_SHARP = 0x102E7
    BATTERY_SAVER = 0x102E8
    BATTERY_SAVER_OUTLINED = 0x102E9
    BATTERY_SAVER_ROUNDED = 0x102EA
    BATTERY_SAVER_SHARP = 0x102EB
    BATTERY_STD = 0x102EC
    BATTERY_STD_OUTLINED = 0x102ED
    BATTERY_STD_ROUNDED = 0x102EE
    BATTERY_STD_SHARP = 0x102EF
    BATTERY_UNKNOWN = 0x102F0
    BATTERY_UNKNOWN_OUTLINED = 0x102F1
    BATTERY_UNKNOWN_ROUNDED = 0x102F2
    BATTERY_UNKNOWN_SHARP = 0x102F3
    BEACH_ACCESS = 0x102F4
    BEACH_ACCESS_OUTLINED = 0x102F5
    BEACH_ACCESS_ROUNDED = 0x102F6
    BEACH_ACCESS_SHARP = 0x102F7
    BED = 0x102F8
    BED_OUTLINED = 0x102F9
    BED_ROUNDED = 0x102FA
    BED_SHARP = 0x102FB
    BEDROOM_BABY = 0x102FC
    BEDROOM_BABY_OUTLINED = 0x102FD
    BEDROOM_BABY_ROUNDED = 0x102FE
    BEDROOM_BABY_SHARP = 0x102FF
    BEDROOM_CHILD = 0x10300
    BEDROOM_CHILD_OUTLINED = 0x10301
    BEDROOM_CHILD_ROUNDED = 0x10302
    BEDROOM_CHILD_SHARP = 0x10303
    BEDROOM_PARENT = 0x10304
    BEDROOM_PARENT_OUTLINED = 0x10305
    BEDROOM_PARENT_ROUNDED = 0x10306
    BEDROOM_PARENT_SHARP = 0x10307
    BEDTIME = 0x10308
    BEDTIME_OFF = 0x10309
    BEDTIME_OFF_OUTLINED = 0x1030A
    BEDTIME_OFF_ROUNDED = 0x1030B
    BEDTIME_OFF_SHARP = 0x1030C
    BEDTIME_OUTLINED = 0x1030D
    BEDTIME_ROUNDED = 0x1030E
    BEDTIME_SHARP = 0x1030F
    BEENHERE = 0x10310
    BEENHERE_OUTLINED = 0x10311
    BEENHERE_ROUNDED = 0x10312
    BEENHERE_SHARP = 0x10313
    BENTO = 0x10314
    BENTO_OUTLINED = 0x10315
    BENTO_ROUNDED = 0x10316
    BENTO_SHARP = 0x10317
    BIKE_SCOOTER = 0x10318
    BIKE_SCOOTER_OUTLINED = 0x10319
    BIKE_SCOOTER_ROUNDED = 0x1031A
    BIKE_SCOOTER_SHARP = 0x1031B
    BIOTECH = 0x1031C
    BIOTECH_OUTLINED = 0x1031D
    BIOTECH_ROUNDED = 0x1031E
    BIOTECH_SHARP = 0x1031F
    BLENDER = 0x10320
    BLENDER_OUTLINED = 0x10321
    BLENDER_ROUNDED = 0x10322
    BLENDER_SHARP = 0x10323
    BLIND = 0x10324
    BLIND_OUTLINED = 0x10325
    BLIND_ROUNDED = 0x10326
    BLIND_SHARP = 0x10327
    BLINDS = 0x10328
    BLINDS_CLOSED = 0x10329
    BLINDS_CLOSED_OUTLINED = 0x1032A
    BLINDS_CLOSED_ROUNDED = 0x1032B
    BLINDS_CLOSED_SHARP = 0x1032C
    BLINDS_OUTLINED = 0x1032D
    BLINDS_ROUNDED = 0x1032E
    BLINDS_SHARP = 0x1032F
    BLOCK = 0x10330
    BLOCK_FLIPPED = 0x10331
    BLOCK_OUTLINED = 0x10332
    BLOCK_ROUNDED = 0x10333
    BLOCK_SHARP = 0x10334
    BLOODTYPE = 0x10335
    BLOODTYPE_OUTLINED = 0x10336
    BLOODTYPE_ROUNDED = 0x10337
    BLOODTYPE_SHARP = 0x10338
    BLUETOOTH = 0x10339
    BLUETOOTH_AUDIO = 0x1033A
    BLUETOOTH_AUDIO_OUTLINED = 0x1033B
    BLUETOOTH_AUDIO_ROUNDED = 0x1033C
    BLUETOOTH_AUDIO_SHARP = 0x1033D
    BLUETOOTH_CONNECTED = 0x1033E
    BLUETOOTH_CONNECTED_OUTLINED = 0x1033F
    BLUETOOTH_CONNECTED_ROUNDED = 0x10340
    BLUETOOTH_CONNECTED_SHARP = 0x10341
    BLUETOOTH_DISABLED = 0x10342
    BLUETOOTH_DISABLED_OUTLINED = 0x10343
    BLUETOOTH_DISABLED_ROUNDED = 0x10344
    BLUETOOTH_DISABLED_SHARP = 0x10345
    BLUETOOTH_DRIVE = 0x10346
    BLUETOOTH_DRIVE_OUTLINED = 0x10347
    BLUETOOTH_DRIVE_ROUNDED = 0x10348
    BLUETOOTH_DRIVE_SHARP = 0x10349
    BLUETOOTH_OUTLINED = 0x1034A
    BLUETOOTH_ROUNDED = 0x1034B
    BLUETOOTH_SEARCHING = 0x1034C
    BLUETOOTH_SEARCHING_OUTLINED = 0x1034D
    BLUETOOTH_SEARCHING_ROUNDED = 0x1034E
    BLUETOOTH_SEARCHING_SHARP = 0x1034F
    BLUETOOTH_SHARP = 0x10350
    BLUR_CIRCULAR = 0x10351
    BLUR_CIRCULAR_OUTLINED = 0x10352
    BLUR_CIRCULAR_ROUNDED = 0x10353
    BLUR_CIRCULAR_SHARP = 0x10354
    BLUR_LINEAR = 0x10355
    BLUR_LINEAR_OUTLINED = 0x10356
    BLUR_LINEAR_ROUNDED = 0x10357
    BLUR_LINEAR_SHARP = 0x10358
    BLUR_OFF = 0x10359
    BLUR_OFF_OUTLINED = 0x1035A
    BLUR_OFF_ROUNDED = 0x1035B
    BLUR_OFF_SHARP = 0x1035C
    BLUR_ON = 0x1035D
    BLUR_ON_OUTLINED = 0x1035E
    BLUR_ON_ROUNDED = 0x1035F
    BLUR_ON_SHARP = 0x10360
    BOLT = 0x10361
    BOLT_OUTLINED = 0x10362
    BOLT_ROUNDED = 0x10363
    BOLT_SHARP = 0x10364
    BOOK = 0x10365
    BOOK_ONLINE = 0x10366
    BOOK_ONLINE_OUTLINED = 0x10367
    BOOK_ONLINE_ROUNDED = 0x10368
    BOOK_ONLINE_SHARP = 0x10369
    BOOK_OUTLINED = 0x1036A
    BOOK_ROUNDED = 0x1036B
    BOOK_SHARP = 0x1036C
    BOOKMARK = 0x1036D
    BOOKMARK_ADD = 0x1036E
    BOOKMARK_ADD_OUTLINED = 0x1036F
    BOOKMARK_ADD_ROUNDED = 0x10370
    BOOKMARK_ADD_SHARP = 0x10371
    BOOKMARK_ADDED = 0x10372
    BOOKMARK_ADDED_OUTLINED = 0x10373
    BOOKMARK_ADDED_ROUNDED = 0x10374
    BOOKMARK_ADDED_SHARP = 0x10375
    BOOKMARK_BORDER = 0x10376
    BOOKMARK_BORDER_OUTLINED = 0x10377
    BOOKMARK_BORDER_ROUNDED = 0x10378
    BOOKMARK_BORDER_SHARP = 0x10379
    BOOKMARK_OUTLINE = 0x1037A
    BOOKMARK_OUTLINE_OUTLINED = 0x1037B
    BOOKMARK_OUTLINE_ROUNDED = 0x1037C
    BOOKMARK_OUTLINE_SHARP = 0x1037D
    BOOKMARK_OUTLINED = 0x1037E
    BOOKMARK_REMOVE = 0x1037F
    BOOKMARK_REMOVE_OUTLINED = 0x10380
    BOOKMARK_REMOVE_ROUNDED = 0x10381
    BOOKMARK_REMOVE_SHARP = 0x10382
    BOOKMARK_ROUNDED = 0x10383
    BOOKMARK_SHARP = 0x10384
    BOOKMARKS = 0x10385
    BOOKMARKS_OUTLINED = 0x10386
    BOOKMARKS_ROUNDED = 0x10387
    BOOKMARKS_SHARP = 0x10388
    BORDER_ALL = 0x10389
    BORDER_ALL_OUTLINED = 0x1038A
    BORDER_ALL_ROUNDED = 0x1038B
    BORDER_ALL_SHARP = 0x1038C
    BORDER_BOTTOM = 0x1038D
    BORDER_BOTTOM_OUTLINED = 0x1038E
    BORDER_BOTTOM_ROUNDED = 0x1038F
    BORDER_BOTTOM_SHARP = 0x10390
    BORDER_CLEAR = 0x10391
    BORDER_CLEAR_OUTLINED = 0x10392
    BORDER_CLEAR_ROUNDED = 0x10393
    BORDER_CLEAR_SHARP = 0x10394
    BORDER_COLOR = 0x10395
    BORDER_COLOR_OUTLINED = 0x10396
    BORDER_COLOR_ROUNDED = 0x10397
    BORDER_COLOR_SHARP = 0x10398
    BORDER_HORIZONTAL = 0x10399
    BORDER_HORIZONTAL_OUTLINED = 0x1039A
    BORDER_HORIZONTAL_ROUNDED = 0x1039B
    BORDER_HORIZONTAL_SHARP = 0x1039C
    BORDER_INNER = 0x1039D
    BORDER_INNER_OUTLINED = 0x1039E
    BORDER_INNER_ROUNDED = 0x1039F
    BORDER_INNER_SHARP = 0x103A0
    BORDER_LEFT = 0x103A1
    BORDER_LEFT_OUTLINED = 0x103A2
    BORDER_LEFT_ROUNDED = 0x103A3
    BORDER_LEFT_SHARP = 0x103A4
    BORDER_OUTER = 0x103A5
    BORDER_OUTER_OUTLINED = 0x103A6
    BORDER_OUTER_ROUNDED = 0x103A7
    BORDER_OUTER_SHARP = 0x103A8
    BORDER_RIGHT = 0x103A9
    BORDER_RIGHT_OUTLINED = 0x103AA
    BORDER_RIGHT_ROUNDED = 0x103AB
    BORDER_RIGHT_SHARP = 0x103AC
    BORDER_STYLE = 0x103AD
    BORDER_STYLE_OUTLINED = 0x103AE
    BORDER_STYLE_ROUNDED = 0x103AF
    BORDER_STYLE_SHARP = 0x103B0
    BORDER_TOP = 0x103B1
    BORDER_TOP_OUTLINED = 0x103B2
    BORDER_TOP_ROUNDED = 0x103B3
    BORDER_TOP_SHARP = 0x103B4
    BORDER_VERTICAL = 0x103B5
    BORDER_VERTICAL_OUTLINED = 0x103B6
    BORDER_VERTICAL_ROUNDED = 0x103B7
    BORDER_VERTICAL_SHARP = 0x103B8
    BOY = 0x103B9
    BOY_OUTLINED = 0x103BA
    BOY_ROUNDED = 0x103BB
    BOY_SHARP = 0x103BC
    BRANDING_WATERMARK = 0x103BD
    BRANDING_WATERMARK_OUTLINED = 0x103BE
    BRANDING_WATERMARK_ROUNDED = 0x103BF
    BRANDING_WATERMARK_SHARP = 0x103C0
    BREAKFAST_DINING = 0x103C1
    BREAKFAST_DINING_OUTLINED = 0x103C2
    BREAKFAST_DINING_ROUNDED = 0x103C3
    BREAKFAST_DINING_SHARP = 0x103C4
    BRIGHTNESS_1 = 0x103C5
    BRIGHTNESS_1_OUTLINED = 0x103C6
    BRIGHTNESS_1_ROUNDED = 0x103C7
    BRIGHTNESS_1_SHARP = 0x103C8
    BRIGHTNESS_2 = 0x103C9
    BRIGHTNESS_2_OUTLINED = 0x103CA
    BRIGHTNESS_2_ROUNDED = 0x103CB
    BRIGHTNESS_2_SHARP = 0x103CC
    BRIGHTNESS_3 = 0x103CD
    BRIGHTNESS_3_OUTLINED = 0x103CE
    BRIGHTNESS_3_ROUNDED = 0x103CF
    BRIGHTNESS_3_SHARP = 0x103D0
    BRIGHTNESS_4 = 0x103D1
    BRIGHTNESS_4_OUTLINED = 0x103D2
    BRIGHTNESS_4_ROUNDED = 0x103D3
    BRIGHTNESS_4_SHARP = 0x103D4
    BRIGHTNESS_5 = 0x103D5
    BRIGHTNESS_5_OUTLINED = 0x103D6
    BRIGHTNESS_5_ROUNDED = 0x103D7
    BRIGHTNESS_5_SHARP = 0x103D8
    BRIGHTNESS_6 = 0x103D9
    BRIGHTNESS_6_OUTLINED = 0x103DA
    BRIGHTNESS_6_ROUNDED = 0x103DB
    BRIGHTNESS_6_SHARP = 0x103DC
    BRIGHTNESS_7 = 0x103DD
    BRIGHTNESS_7_OUTLINED = 0x103DE
    BRIGHTNESS_7_ROUNDED = 0x103DF
    BRIGHTNESS_7_SHARP = 0x103E0
    BRIGHTNESS_AUTO = 0x103E1
    BRIGHTNESS_AUTO_OUTLINED = 0x103E2
    BRIGHTNESS_AUTO_ROUNDED = 0x103E3
    BRIGHTNESS_AUTO_SHARP = 0x103E4
    BRIGHTNESS_HIGH = 0x103E5
    BRIGHTNESS_HIGH_OUTLINED = 0x103E6
    BRIGHTNESS_HIGH_ROUNDED = 0x103E7
    BRIGHTNESS_HIGH_SHARP = 0x103E8
    BRIGHTNESS_LOW = 0x103E9
    BRIGHTNESS_LOW_OUTLINED = 0x103EA
    BRIGHTNESS_LOW_ROUNDED = 0x103EB
    BRIGHTNESS_LOW_SHARP = 0x103EC
    BRIGHTNESS_MEDIUM = 0x103ED
    BRIGHTNESS_MEDIUM_OUTLINED = 0x103EE
    BRIGHTNESS_MEDIUM_ROUNDED = 0x103EF
    BRIGHTNESS_MEDIUM_SHARP = 0x103F0
    BROADCAST_ON_HOME = 0x103F1
    BROADCAST_ON_HOME_OUTLINED = 0x103F2
    BROADCAST_ON_HOME_ROUNDED = 0x103F3
    BROADCAST_ON_HOME_SHARP = 0x103F4
    BROADCAST_ON_PERSONAL = 0x103F5
    BROADCAST_ON_PERSONAL_OUTLINED = 0x103F6
    BROADCAST_ON_PERSONAL_ROUNDED = 0x103F7
    BROADCAST_ON_PERSONAL_SHARP = 0x103F8
    BROKEN_IMAGE = 0x103F9
    BROKEN_IMAGE_OUTLINED = 0x103FA
    BROKEN_IMAGE_ROUNDED = 0x103FB
    BROKEN_IMAGE_SHARP = 0x103FC
    BROWSE_GALLERY = 0x103FD
    BROWSE_GALLERY_OUTLINED = 0x103FE
    BROWSE_GALLERY_ROUNDED = 0x103FF
    BROWSE_GALLERY_SHARP = 0x10400
    BROWSER_NOT_SUPPORTED = 0x10401
    BROWSER_NOT_SUPPORTED_OUTLINED = 0x10402
    BROWSER_NOT_SUPPORTED_ROUNDED = 0x10403
    BROWSER_NOT_SUPPORTED_SHARP = 0x10404
    BROWSER_UPDATED = 0x10405
    BROWSER_UPDATED_OUTLINED = 0x10406
    BROWSER_UPDATED_ROUNDED = 0x10407
    BROWSER_UPDATED_SHARP = 0x10408
    BRUNCH_DINING = 0x10409
    BRUNCH_DINING_OUTLINED = 0x1040A
    BRUNCH_DINING_ROUNDED = 0x1040B
    BRUNCH_DINING_SHARP = 0x1040C
    BRUSH = 0x1040D
    BRUSH_OUTLINED = 0x1040E
    BRUSH_ROUNDED = 0x1040F
    BRUSH_SHARP = 0x10410
    BUBBLE_CHART = 0x10411
    BUBBLE_CHART_OUTLINED = 0x10412
    BUBBLE_CHART_ROUNDED = 0x10413
    BUBBLE_CHART_SHARP = 0x10414
    BUG_REPORT = 0x10415
    BUG_REPORT_OUTLINED = 0x10416
    BUG_REPORT_ROUNDED = 0x10417
    BUG_REPORT_SHARP = 0x10418
    BUILD = 0x10419
    BUILD_CIRCLE = 0x1041A
    BUILD_CIRCLE_OUTLINED = 0x1041B
    BUILD_CIRCLE_ROUNDED = 0x1041C
    BUILD_CIRCLE_SHARP = 0x1041D
    BUILD_OUTLINED = 0x1041E
    BUILD_ROUNDED = 0x1041F
    BUILD_SHARP = 0x10420
    BUNGALOW = 0x10421
    BUNGALOW_OUTLINED = 0x10422
    BUNGALOW_ROUNDED = 0x10423
    BUNGALOW_SHARP = 0x10424
    BURST_MODE = 0x10425
    BURST_MODE_OUTLINED = 0x10426
    BURST_MODE_ROUNDED = 0x10427
    BURST_MODE_SHARP = 0x10428
    BUS_ALERT = 0x10429
    BUS_ALERT_OUTLINED = 0x1042A
    BUS_ALERT_ROUNDED = 0x1042B
    BUS_ALERT_SHARP = 0x1042C
    BUSINESS = 0x1042D
    BUSINESS_CENTER = 0x1042E
    BUSINESS_CENTER_OUTLINED = 0x1042F
    BUSINESS_CENTER_ROUNDED = 0x10430
    BUSINESS_CENTER_SHARP = 0x10431
    BUSINESS_OUTLINED = 0x10432
    BUSINESS_ROUNDED = 0x10433
    BUSINESS_SHARP = 0x10434
    CABIN = 0x10435
    CABIN_OUTLINED = 0x10436
    CABIN_ROUNDED = 0x10437
    CABIN_SHARP = 0x10438
    CABLE = 0x10439
    CABLE_OUTLINED = 0x1043A
    CABLE_ROUNDED = 0x1043B
    CABLE_SHARP = 0x1043C
    CACHED = 0x1043D
    CACHED_OUTLINED = 0x1043E
    CACHED_ROUNDED = 0x1043F
    CACHED_SHARP = 0x10440
    CAKE = 0x10441
    CAKE_OUTLINED = 0x10442
    CAKE_ROUNDED = 0x10443
    CAKE_SHARP = 0x10444
    CALCULATE = 0x10445
    CALCULATE_OUTLINED = 0x10446
    CALCULATE_ROUNDED = 0x10447
    CALCULATE_SHARP = 0x10448
    CALENDAR_MONTH = 0x10449
    CALENDAR_MONTH_OUTLINED = 0x1044A
    CALENDAR_MONTH_ROUNDED = 0x1044B
    CALENDAR_MONTH_SHARP = 0x1044C
    CALENDAR_TODAY = 0x1044D
    CALENDAR_TODAY_OUTLINED = 0x1044E
    CALENDAR_TODAY_ROUNDED = 0x1044F
    CALENDAR_TODAY_SHARP = 0x10450
    CALENDAR_VIEW_DAY = 0x10451
    CALENDAR_VIEW_DAY_OUTLINED = 0x10452
    CALENDAR_VIEW_DAY_ROUNDED = 0x10453
    CALENDAR_VIEW_DAY_SHARP = 0x10454
    CALENDAR_VIEW_MONTH = 0x10455
    CALENDAR_VIEW_MONTH_OUTLINED = 0x10456
    CALENDAR_VIEW_MONTH_ROUNDED = 0x10457
    CALENDAR_VIEW_MONTH_SHARP = 0x10458
    CALENDAR_VIEW_WEEK = 0x10459
    CALENDAR_VIEW_WEEK_OUTLINED = 0x1045A
    CALENDAR_VIEW_WEEK_ROUNDED = 0x1045B
    CALENDAR_VIEW_WEEK_SHARP = 0x1045C
    CALL = 0x1045D
    CALL_END = 0x1045E
    CALL_END_OUTLINED = 0x1045F
    CALL_END_ROUNDED = 0x10460
    CALL_END_SHARP = 0x10461
    CALL_MADE = 0x10462
    CALL_MADE_OUTLINED = 0x10463
    CALL_MADE_ROUNDED = 0x10464
    CALL_MADE_SHARP = 0x10465
    CALL_MERGE = 0x10466
    CALL_MERGE_OUTLINED = 0x10467
    CALL_MERGE_ROUNDED = 0x10468
    CALL_MERGE_SHARP = 0x10469
    CALL_MISSED = 0x1046A
    CALL_MISSED_OUTGOING = 0x1046B
    CALL_MISSED_OUTGOING_OUTLINED = 0x1046C
    CALL_MISSED_OUTGOING_ROUNDED = 0x1046D
    CALL_MISSED_OUTGOING_SHARP = 0x1046E
    CALL_MISSED_OUTLINED = 0x1046F
    CALL_MISSED_ROUNDED = 0x10470
    CALL_MISSED_SHARP = 0x10471
    CALL_OUTLINED = 0x10472
    CALL_RECEIVED = 0x10473
    CALL_RECEIVED_OUTLINED = 0x10474
    CALL_RECEIVED_ROUNDED = 0x10475
    CALL_RECEIVED_SHARP = 0x10476
    CALL_ROUNDED = 0x10477
    CALL_SHARP = 0x10478
    CALL_SPLIT = 0x10479
    CALL_SPLIT_OUTLINED = 0x1047A
    CALL_SPLIT_ROUNDED = 0x1047B
    CALL_SPLIT_SHARP = 0x1047C
    CALL_TO_ACTION = 0x1047D
    CALL_TO_ACTION_OUTLINED = 0x1047E
    CALL_TO_ACTION_ROUNDED = 0x1047F
    CALL_TO_ACTION_SHARP = 0x10480
    CAMERA = 0x10481
    CAMERA_ALT = 0x10482
    CAMERA_ALT_OUTLINED = 0x10483
    CAMERA_ALT_ROUNDED = 0x10484
    CAMERA_ALT_SHARP = 0x10485
    CAMERA_ENHANCE = 0x10486
    CAMERA_ENHANCE_OUTLINED = 0x10487
    CAMERA_ENHANCE_ROUNDED = 0x10488
    CAMERA_ENHANCE_SHARP = 0x10489
    CAMERA_FRONT = 0x1048A
    CAMERA_FRONT_OUTLINED = 0x1048B
    CAMERA_FRONT_ROUNDED = 0x1048C
    CAMERA_FRONT_SHARP = 0x1048D
    CAMERA_INDOOR = 0x1048E
    CAMERA_INDOOR_OUTLINED = 0x1048F
    CAMERA_INDOOR_ROUNDED = 0x10490
    CAMERA_INDOOR_SHARP = 0x10491
    CAMERA_OUTDOOR = 0x10492
    CAMERA_OUTDOOR_OUTLINED = 0x10493
    CAMERA_OUTDOOR_ROUNDED = 0x10494
    CAMERA_OUTDOOR_SHARP = 0x10495
    CAMERA_OUTLINED = 0x10496
    CAMERA_REAR = 0x10497
    CAMERA_REAR_OUTLINED = 0x10498
    CAMERA_REAR_ROUNDED = 0x10499
    CAMERA_REAR_SHARP = 0x1049A
    CAMERA_ROLL = 0x1049B
    CAMERA_ROLL_OUTLINED = 0x1049C
    CAMERA_ROLL_ROUNDED = 0x1049D
    CAMERA_ROLL_SHARP = 0x1049E
    CAMERA_ROUNDED = 0x1049F
    CAMERA_SHARP = 0x104A0
    CAMERASWITCH = 0x104A1
    CAMERASWITCH_OUTLINED = 0x104A2
    CAMERASWITCH_ROUNDED = 0x104A3
    CAMERASWITCH_SHARP = 0x104A4
    CAMPAIGN = 0x104A5
    CAMPAIGN_OUTLINED = 0x104A6
    CAMPAIGN_ROUNDED = 0x104A7
    CAMPAIGN_SHARP = 0x104A8
    CANCEL = 0x104A9
    CANCEL_OUTLINED = 0x104AA
    CANCEL_PRESENTATION = 0x104AB
    CANCEL_PRESENTATION_OUTLINED = 0x104AC
    CANCEL_PRESENTATION_ROUNDED = 0x104AD
    CANCEL_PRESENTATION_SHARP = 0x104AE
    CANCEL_ROUNDED = 0x104AF
    CANCEL_SCHEDULE_SEND = 0x104B0
    CANCEL_SCHEDULE_SEND_OUTLINED = 0x104B1
    CANCEL_SCHEDULE_SEND_ROUNDED = 0x104B2
    CANCEL_SCHEDULE_SEND_SHARP = 0x104B3
    CANCEL_SHARP = 0x104B4
    CANDLESTICK_CHART = 0x104B5
    CANDLESTICK_CHART_OUTLINED = 0x104B6
    CANDLESTICK_CHART_ROUNDED = 0x104B7
    CANDLESTICK_CHART_SHARP = 0x104B8
    CAR_CRASH = 0x104B9
    CAR_CRASH_OUTLINED = 0x104BA
    CAR_CRASH_ROUNDED = 0x104BB
    CAR_CRASH_SHARP = 0x104BC
    CAR_RENTAL = 0x104BD
    CAR_RENTAL_OUTLINED = 0x104BE
    CAR_RENTAL_ROUNDED = 0x104BF
    CAR_RENTAL_SHARP = 0x104C0
    CAR_REPAIR = 0x104C1
    CAR_REPAIR_OUTLINED = 0x104C2
    CAR_REPAIR_ROUNDED = 0x104C3
    CAR_REPAIR_SHARP = 0x104C4
    CARD_GIFTCARD = 0x104C5
    CARD_GIFTCARD_OUTLINED = 0x104C6
    CARD_GIFTCARD_ROUNDED = 0x104C7
    CARD_GIFTCARD_SHARP = 0x104C8
    CARD_MEMBERSHIP = 0x104C9
    CARD_MEMBERSHIP_OUTLINED = 0x104CA
    CARD_MEMBERSHIP_ROUNDED = 0x104CB
    CARD_MEMBERSHIP_SHARP = 0x104CC
    CARD_TRAVEL = 0x104CD
    CARD_TRAVEL_OUTLINED = 0x104CE
    CARD_TRAVEL_ROUNDED = 0x104CF
    CARD_TRAVEL_SHARP = 0x104D0
    CARPENTER = 0x104D1
    CARPENTER_OUTLINED = 0x104D2
    CARPENTER_ROUNDED = 0x104D3
    CARPENTER_SHARP = 0x104D4
    CASES = 0x104D5
    CASES_OUTLINED = 0x104D6
    CASES_ROUNDED = 0x104D7
    CASES_SHARP = 0x104D8
    CASINO = 0x104D9
    CASINO_OUTLINED = 0x104DA
    CASINO_ROUNDED = 0x104DB
    CASINO_SHARP = 0x104DC
    CAST = 0x104DD
    CAST_CONNECTED = 0x104DE
    CAST_CONNECTED_OUTLINED = 0x104DF
    CAST_CONNECTED_ROUNDED = 0x104E0
    CAST_CONNECTED_SHARP = 0x104E1
    CAST_FOR_EDUCATION = 0x104E2
    CAST_FOR_EDUCATION_OUTLINED = 0x104E3
    CAST_FOR_EDUCATION_ROUNDED = 0x104E4
    CAST_FOR_EDUCATION_SHARP = 0x104E5
    CAST_OUTLINED = 0x104E6
    CAST_ROUNDED = 0x104E7
    CAST_SHARP = 0x104E8
    CASTLE = 0x104E9
    CASTLE_OUTLINED = 0x104EA
    CASTLE_ROUNDED = 0x104EB
    CASTLE_SHARP = 0x104EC
    CATCHING_POKEMON = 0x104ED
    CATCHING_POKEMON_OUTLINED = 0x104EE
    CATCHING_POKEMON_ROUNDED = 0x104EF
    CATCHING_POKEMON_SHARP = 0x104F0
    CATEGORY = 0x104F1
    CATEGORY_OUTLINED = 0x104F2
    CATEGORY_ROUNDED = 0x104F3
    CATEGORY_SHARP = 0x104F4
    CELEBRATION = 0x104F5
    CELEBRATION_OUTLINED = 0x104F6
    CELEBRATION_ROUNDED = 0x104F7
    CELEBRATION_SHARP = 0x104F8
    CELL_TOWER = 0x104F9
    CELL_TOWER_OUTLINED = 0x104FA
    CELL_TOWER_ROUNDED = 0x104FB
    CELL_TOWER_SHARP = 0x104FC
    CELL_WIFI = 0x104FD
    CELL_WIFI_OUTLINED = 0x104FE
    CELL_WIFI_ROUNDED = 0x104FF
    CELL_WIFI_SHARP = 0x10500
    CENTER_FOCUS_STRONG = 0x10501
    CENTER_FOCUS_STRONG_OUTLINED = 0x10502
    CENTER_FOCUS_STRONG_ROUNDED = 0x10503
    CENTER_FOCUS_STRONG_SHARP = 0x10504
    CENTER_FOCUS_WEAK = 0x10505
    CENTER_FOCUS_WEAK_OUTLINED = 0x10506
    CENTER_FOCUS_WEAK_ROUNDED = 0x10507
    CENTER_FOCUS_WEAK_SHARP = 0x10508
    CHAIR = 0x10509
    CHAIR_ALT = 0x1050A
    CHAIR_ALT_OUTLINED = 0x1050B
    CHAIR_ALT_ROUNDED = 0x1050C
    CHAIR_ALT_SHARP = 0x1050D
    CHAIR_OUTLINED = 0x1050E
    CHAIR_ROUNDED = 0x1050F
    CHAIR_SHARP = 0x10510
    CHALET = 0x10511
    CHALET_OUTLINED = 0x10512
    CHALET_ROUNDED = 0x10513
    CHALET_SHARP = 0x10514
    CHANGE_CIRCLE = 0x10515
    CHANGE_CIRCLE_OUTLINED = 0x10516
    CHANGE_CIRCLE_ROUNDED = 0x10517
    CHANGE_CIRCLE_SHARP = 0x10518
    CHANGE_HISTORY = 0x10519
    CHANGE_HISTORY_OUTLINED = 0x1051A
    CHANGE_HISTORY_ROUNDED = 0x1051B
    CHANGE_HISTORY_SHARP = 0x1051C
    CHARGING_STATION = 0x1051D
    CHARGING_STATION_OUTLINED = 0x1051E
    CHARGING_STATION_ROUNDED = 0x1051F
    CHARGING_STATION_SHARP = 0x10520
    CHAT = 0x10521
    CHAT_BUBBLE = 0x10522
    CHAT_BUBBLE_OUTLINE = 0x10523
    CHAT_BUBBLE_OUTLINE_OUTLINED = 0x10524
    CHAT_BUBBLE_OUTLINE_ROUNDED = 0x10525
    CHAT_BUBBLE_OUTLINE_SHARP = 0x10526
    CHAT_BUBBLE_OUTLINED = 0x10527
    CHAT_BUBBLE_ROUNDED = 0x10528
    CHAT_BUBBLE_SHARP = 0x10529
    CHAT_OUTLINED = 0x1052A
    CHAT_ROUNDED = 0x1052B
    CHAT_SHARP = 0x1052C
    CHECK = 0x1052D
    CHECK_BOX = 0x1052E
    CHECK_BOX_OUTLINE_BLANK = 0x1052F
    CHECK_BOX_OUTLINE_BLANK_OUTLINED = 0x10530
    CHECK_BOX_OUTLINE_BLANK_ROUNDED = 0x10531
    CHECK_BOX_OUTLINE_BLANK_SHARP = 0x10532
    CHECK_BOX_OUTLINED = 0x10533
    CHECK_BOX_ROUNDED = 0x10534
    CHECK_BOX_SHARP = 0x10535
    CHECK_CIRCLE = 0x10536
    CHECK_CIRCLE_OUTLINE = 0x10537
    CHECK_CIRCLE_OUTLINE_OUTLINED = 0x10538
    CHECK_CIRCLE_OUTLINE_ROUNDED = 0x10539
    CHECK_CIRCLE_OUTLINE_SHARP = 0x1053A
    CHECK_CIRCLE_OUTLINED = 0x1053B
    CHECK_CIRCLE_ROUNDED = 0x1053C
    CHECK_CIRCLE_SHARP = 0x1053D
    CHECK_OUTLINED = 0x1053E
    CHECK_ROUNDED = 0x1053F
    CHECK_SHARP = 0x10540
    CHECKLIST = 0x10541
    CHECKLIST_OUTLINED = 0x10542
    CHECKLIST_ROUNDED = 0x10543
    CHECKLIST_RTL = 0x10544
    CHECKLIST_RTL_OUTLINED = 0x10545
    CHECKLIST_RTL_ROUNDED = 0x10546
    CHECKLIST_RTL_SHARP = 0x10547
    CHECKLIST_SHARP = 0x10548
    CHECKROOM = 0x10549
    CHECKROOM_OUTLINED = 0x1054A
    CHECKROOM_ROUNDED = 0x1054B
    CHECKROOM_SHARP = 0x1054C
    CHEVRON_LEFT = 0x1054D
    CHEVRON_LEFT_OUTLINED = 0x1054E
    CHEVRON_LEFT_ROUNDED = 0x1054F
    CHEVRON_LEFT_SHARP = 0x10550
    CHEVRON_RIGHT = 0x10551
    CHEVRON_RIGHT_OUTLINED = 0x10552
    CHEVRON_RIGHT_ROUNDED = 0x10553
    CHEVRON_RIGHT_SHARP = 0x10554
    CHILD_CARE = 0x10555
    CHILD_CARE_OUTLINED = 0x10556
    CHILD_CARE_ROUNDED = 0x10557
    CHILD_CARE_SHARP = 0x10558
    CHILD_FRIENDLY = 0x10559
    CHILD_FRIENDLY_OUTLINED = 0x1055A
    CHILD_FRIENDLY_ROUNDED = 0x1055B
    CHILD_FRIENDLY_SHARP = 0x1055C
    CHROME_READER_MODE = 0x1055D
    CHROME_READER_MODE_OUTLINED = 0x1055E
    CHROME_READER_MODE_ROUNDED = 0x1055F
    CHROME_READER_MODE_SHARP = 0x10560
    CHURCH = 0x10561
    CHURCH_OUTLINED = 0x10562
    CHURCH_ROUNDED = 0x10563
    CHURCH_SHARP = 0x10564
    CIRCLE = 0x10565
    CIRCLE_NOTIFICATIONS = 0x10566
    CIRCLE_NOTIFICATIONS_OUTLINED = 0x10567
    CIRCLE_NOTIFICATIONS_ROUNDED = 0x10568
    CIRCLE_NOTIFICATIONS_SHARP = 0x10569
    CIRCLE_OUTLINED = 0x1056A
    CIRCLE_ROUNDED = 0x1056B
    CIRCLE_SHARP = 0x1056C
    CLASS_ = 0x1056D
    CLASS_OUTLINED = 0x1056E
    CLASS_ROUNDED = 0x1056F
    CLASS_SHARP = 0x10570
    CLEAN_HANDS = 0x10571
    CLEAN_HANDS_OUTLINED = 0x10572
    CLEAN_HANDS_ROUNDED = 0x10573
    CLEAN_HANDS_SHARP = 0x10574
    CLEANING_SERVICES = 0x10575
    CLEANING_SERVICES_OUTLINED = 0x10576
    CLEANING_SERVICES_ROUNDED = 0x10577
    CLEANING_SERVICES_SHARP = 0x10578
    CLEAR = 0x10579
    CLEAR_ALL = 0x1057A
    CLEAR_ALL_OUTLINED = 0x1057B
    CLEAR_ALL_ROUNDED = 0x1057C
    CLEAR_ALL_SHARP = 0x1057D
    CLEAR_OUTLINED = 0x1057E
    CLEAR_ROUNDED = 0x1057F
    CLEAR_SHARP = 0x10580
    CLOSE = 0x10581
    CLOSE_FULLSCREEN = 0x10582
    CLOSE_FULLSCREEN_OUTLINED = 0x10583
    CLOSE_FULLSCREEN_ROUNDED = 0x10584
    CLOSE_FULLSCREEN_SHARP = 0x10585
    CLOSE_OUTLINED = 0x10586
    CLOSE_ROUNDED = 0x10587
    CLOSE_SHARP = 0x10588
    CLOSED_CAPTION = 0x10589
    CLOSED_CAPTION_DISABLED = 0x1058A
    CLOSED_CAPTION_DISABLED_OUTLINED = 0x1058B
    CLOSED_CAPTION_DISABLED_ROUNDED = 0x1058C
    CLOSED_CAPTION_DISABLED_SHARP = 0x1058D
    CLOSED_CAPTION_OFF = 0x1058E
    CLOSED_CAPTION_OFF_OUTLINED = 0x1058F
    CLOSED_CAPTION_OFF_ROUNDED = 0x10590
    CLOSED_CAPTION_OFF_SHARP = 0x10591
    CLOSED_CAPTION_OUTLINED = 0x10592
    CLOSED_CAPTION_ROUNDED = 0x10593
    CLOSED_CAPTION_SHARP = 0x10594
    CLOUD = 0x10595
    CLOUD_CIRCLE = 0x10596
    CLOUD_CIRCLE_OUTLINED = 0x10597
    CLOUD_CIRCLE_ROUNDED = 0x10598
    CLOUD_CIRCLE_SHARP = 0x10599
    CLOUD_DONE = 0x1059A
    CLOUD_DONE_OUTLINED = 0x1059B
    CLOUD_DONE_ROUNDED = 0x1059C
    CLOUD_DONE_SHARP = 0x1059D
    CLOUD_DOWNLOAD = 0x1059E
    CLOUD_DOWNLOAD_OUTLINED = 0x1059F
    CLOUD_DOWNLOAD_ROUNDED = 0x105A0
    CLOUD_DOWNLOAD_SHARP = 0x105A1
    CLOUD_OFF = 0x105A2
    CLOUD_OFF_OUTLINED = 0x105A3
    CLOUD_OFF_ROUNDED = 0x105A4
    CLOUD_OFF_SHARP = 0x105A5
    CLOUD_OUTLINED = 0x105A6
    CLOUD_QUEUE = 0x105A7
    CLOUD_QUEUE_OUTLINED = 0x105A8
    CLOUD_QUEUE_ROUNDED = 0x105A9
    CLOUD_QUEUE_SHARP = 0x105AA
    CLOUD_ROUNDED = 0x105AB
    CLOUD_SHARP = 0x105AC
    CLOUD_SYNC = 0x105AD
    CLOUD_SYNC_OUTLINED = 0x105AE
    CLOUD_SYNC_ROUNDED = 0x105AF
    CLOUD_SYNC_SHARP = 0x105B0
    CLOUD_UPLOAD = 0x105B1
    CLOUD_UPLOAD_OUTLINED = 0x105B2
    CLOUD_UPLOAD_ROUNDED = 0x105B3
    CLOUD_UPLOAD_SHARP = 0x105B4
    CLOUDY_SNOWING = 0x105B5
    CO2 = 0x105B6
    CO2_OUTLINED = 0x105B7
    CO2_ROUNDED = 0x105B8
    CO2_SHARP = 0x105B9
    CO_PRESENT = 0x105BA
    CO_PRESENT_OUTLINED = 0x105BB
    CO_PRESENT_ROUNDED = 0x105BC
    CO_PRESENT_SHARP = 0x105BD
    CODE = 0x105BE
    CODE_OFF = 0x105BF
    CODE_OFF_OUTLINED = 0x105C0
    CODE_OFF_ROUNDED = 0x105C1
    CODE_OFF_SHARP = 0x105C2
    CODE_OUTLINED = 0x105C3
    CODE_ROUNDED = 0x105C4
    CODE_SHARP = 0x105C5
    COFFEE = 0x105C6
    COFFEE_MAKER = 0x105C7
    COFFEE_MAKER_OUTLINED = 0x105C8
    COFFEE_MAKER_ROUNDED = 0x105C9
    COFFEE_MAKER_SHARP = 0x105CA
    COFFEE_OUTLINED = 0x105CB
    COFFEE_ROUNDED = 0x105CC
    COFFEE_SHARP = 0x105CD
    COLLECTIONS = 0x105CE
    COLLECTIONS_BOOKMARK = 0x105CF
    COLLECTIONS_BOOKMARK_OUTLINED = 0x105D0
    COLLECTIONS_BOOKMARK_ROUNDED = 0x105D1
    COLLECTIONS_BOOKMARK_SHARP = 0x105D2
    COLLECTIONS_OUTLINED = 0x105D3
    COLLECTIONS_ROUNDED = 0x105D4
    COLLECTIONS_SHARP = 0x105D5
    COLOR_LENS = 0x105D6
    COLOR_LENS_OUTLINED = 0x105D7
    COLOR_LENS_ROUNDED = 0x105D8
    COLOR_LENS_SHARP = 0x105D9
    COLORIZE = 0x105DA
    COLORIZE_OUTLINED = 0x105DB
    COLORIZE_ROUNDED = 0x105DC
    COLORIZE_SHARP = 0x105DD
    COMMENT = 0x105DE
    COMMENT_BANK = 0x105DF
    COMMENT_BANK_OUTLINED = 0x105E0
    COMMENT_BANK_ROUNDED = 0x105E1
    COMMENT_BANK_SHARP = 0x105E2
    COMMENT_OUTLINED = 0x105E3
    COMMENT_ROUNDED = 0x105E4
    COMMENT_SHARP = 0x105E5
    COMMENTS_DISABLED = 0x105E6
    COMMENTS_DISABLED_OUTLINED = 0x105E7
    COMMENTS_DISABLED_ROUNDED = 0x105E8
    COMMENTS_DISABLED_SHARP = 0x105E9
    COMMIT = 0x105EA
    COMMIT_OUTLINED = 0x105EB
    COMMIT_ROUNDED = 0x105EC
    COMMIT_SHARP = 0x105ED
    COMMUTE = 0x105EE
    COMMUTE_OUTLINED = 0x105EF
    COMMUTE_ROUNDED = 0x105F0
    COMMUTE_SHARP = 0x105F1
    COMPARE = 0x105F2
    COMPARE_ARROWS = 0x105F3
    COMPARE_ARROWS_OUTLINED = 0x105F4
    COMPARE_ARROWS_ROUNDED = 0x105F5
    COMPARE_ARROWS_SHARP = 0x105F6
    COMPARE_OUTLINED = 0x105F7
    COMPARE_ROUNDED = 0x105F8
    COMPARE_SHARP = 0x105F9
    COMPASS_CALIBRATION = 0x105FA
    COMPASS_CALIBRATION_OUTLINED = 0x105FB
    COMPASS_CALIBRATION_ROUNDED = 0x105FC
    COMPASS_CALIBRATION_SHARP = 0x105FD
    COMPOST = 0x105FE
    COMPOST_OUTLINED = 0x105FF
    COMPOST_ROUNDED = 0x10600
    COMPOST_SHARP = 0x10601
    COMPRESS = 0x10602
    COMPRESS_OUTLINED = 0x10603
    COMPRESS_ROUNDED = 0x10604
    COMPRESS_SHARP = 0x10605
    COMPUTER = 0x10606
    COMPUTER_OUTLINED = 0x10607
    COMPUTER_ROUNDED = 0x10608
    COMPUTER_SHARP = 0x10609
    CONFIRMATION_NUM = 0x1060A
    CONFIRMATION_NUM_OUTLINED = 0x1060B
    CONFIRMATION_NUM_ROUNDED = 0x1060C
    CONFIRMATION_NUM_SHARP = 0x1060D
    CONFIRMATION_NUMBER = 0x1060E
    CONFIRMATION_NUMBER_OUTLINED = 0x1060F
    CONFIRMATION_NUMBER_ROUNDED = 0x10610
    CONFIRMATION_NUMBER_SHARP = 0x10611
    CONNECT_WITHOUT_CONTACT = 0x10612
    CONNECT_WITHOUT_CONTACT_OUTLINED = 0x10613
    CONNECT_WITHOUT_CONTACT_ROUNDED = 0x10614
    CONNECT_WITHOUT_CONTACT_SHARP = 0x10615
    CONNECTED_TV = 0x10616
    CONNECTED_TV_OUTLINED = 0x10617
    CONNECTED_TV_ROUNDED = 0x10618
    CONNECTED_TV_SHARP = 0x10619
    CONNECTING_AIRPORTS = 0x1061A
    CONNECTING_AIRPORTS_OUTLINED = 0x1061B
    CONNECTING_AIRPORTS_ROUNDED = 0x1061C
    CONNECTING_AIRPORTS_SHARP = 0x1061D
    CONSTRUCTION = 0x1061E
    CONSTRUCTION_OUTLINED = 0x1061F
    CONSTRUCTION_ROUNDED = 0x10620
    CONSTRUCTION_SHARP = 0x10621
    CONTACT_EMERGENCY = 0x10622
    CONTACT_EMERGENCY_OUTLINED = 0x10623
    CONTACT_EMERGENCY_ROUNDED = 0x10624
    CONTACT_EMERGENCY_SHARP = 0x10625
    CONTACT_MAIL = 0x10626
    CONTACT_MAIL_OUTLINED = 0x10627
    CONTACT_MAIL_ROUNDED = 0x10628
    CONTACT_MAIL_SHARP = 0x10629
    CONTACT_PAGE = 0x1062A
    CONTACT_PAGE_OUTLINED = 0x1062B
    CONTACT_PAGE_ROUNDED = 0x1062C
    CONTACT_PAGE_SHARP = 0x1062D
    CONTACT_PHONE = 0x1062E
    CONTACT_PHONE_OUTLINED = 0x1062F
    CONTACT_PHONE_ROUNDED = 0x10630
    CONTACT_PHONE_SHARP = 0x10631
    CONTACT_SUPPORT = 0x10632
    CONTACT_SUPPORT_OUTLINED = 0x10633
    CONTACT_SUPPORT_ROUNDED = 0x10634
    CONTACT_SUPPORT_SHARP = 0x10635
    CONTACTLESS = 0x10636
    CONTACTLESS_OUTLINED = 0x10637
    CONTACTLESS_ROUNDED = 0x10638
    CONTACTLESS_SHARP = 0x10639
    CONTACTS = 0x1063A
    CONTACTS_OUTLINED = 0x1063B
    CONTACTS_ROUNDED = 0x1063C
    CONTACTS_SHARP = 0x1063D
    CONTENT_COPY = 0x1063E
    CONTENT_COPY_OUTLINED = 0x1063F
    CONTENT_COPY_ROUNDED = 0x10640
    CONTENT_COPY_SHARP = 0x10641
    CONTENT_CUT = 0x10642
    CONTENT_CUT_OUTLINED = 0x10643
    CONTENT_CUT_ROUNDED = 0x10644
    CONTENT_CUT_SHARP = 0x10645
    CONTENT_PASTE = 0x10646
    CONTENT_PASTE_GO = 0x10647
    CONTENT_PASTE_GO_OUTLINED = 0x10648
    CONTENT_PASTE_GO_ROUNDED = 0x10649
    CONTENT_PASTE_GO_SHARP = 0x1064A
    CONTENT_PASTE_OFF = 0x1064B
    CONTENT_PASTE_OFF_OUTLINED = 0x1064C
    CONTENT_PASTE_OFF_ROUNDED = 0x1064D
    CONTENT_PASTE_OFF_SHARP = 0x1064E
    CONTENT_PASTE_OUTLINED = 0x1064F
    CONTENT_PASTE_ROUNDED = 0x10650
    CONTENT_PASTE_SEARCH = 0x10651
    CONTENT_PASTE_SEARCH_OUTLINED = 0x10652
    CONTENT_PASTE_SEARCH_ROUNDED = 0x10653
    CONTENT_PASTE_SEARCH_SHARP = 0x10654
    CONTENT_PASTE_SHARP = 0x10655
    CONTRAST = 0x10656
    CONTRAST_OUTLINED = 0x10657
    CONTRAST_ROUNDED = 0x10658
    CONTRAST_SHARP = 0x10659
    CONTROL_CAMERA = 0x1065A
    CONTROL_CAMERA_OUTLINED = 0x1065B
    CONTROL_CAMERA_ROUNDED = 0x1065C
    CONTROL_CAMERA_SHARP = 0x1065D
    CONTROL_POINT = 0x1065E
    CONTROL_POINT_DUPLICATE = 0x1065F
    CONTROL_POINT_DUPLICATE_OUTLINED = 0x10660
    CONTROL_POINT_DUPLICATE_ROUNDED = 0x10661
    CONTROL_POINT_DUPLICATE_SHARP = 0x10662
    CONTROL_POINT_OUTLINED = 0x10663
    CONTROL_POINT_ROUNDED = 0x10664
    CONTROL_POINT_SHARP = 0x10665
    CONVEYOR_BELT = 0x10666
    COOKIE = 0x10667
    COOKIE_OUTLINED = 0x10668
    COOKIE_ROUNDED = 0x10669
    COOKIE_SHARP = 0x1066A
    COPY = 0x1066B
    COPY_ALL = 0x1066C
    COPY_ALL_OUTLINED = 0x1066D
    COPY_ALL_ROUNDED = 0x1066E
    COPY_ALL_SHARP = 0x1066F
    COPY_OUTLINED = 0x10670
    COPY_ROUNDED = 0x10671
    COPY_SHARP = 0x10672
    COPYRIGHT = 0x10673
    COPYRIGHT_OUTLINED = 0x10674
    COPYRIGHT_ROUNDED = 0x10675
    COPYRIGHT_SHARP = 0x10676
    CORONAVIRUS = 0x10677
    CORONAVIRUS_OUTLINED = 0x10678
    CORONAVIRUS_ROUNDED = 0x10679
    CORONAVIRUS_SHARP = 0x1067A
    CORPORATE_FARE = 0x1067B
    CORPORATE_FARE_OUTLINED = 0x1067C
    CORPORATE_FARE_ROUNDED = 0x1067D
    CORPORATE_FARE_SHARP = 0x1067E
    COTTAGE = 0x1067F
    COTTAGE_OUTLINED = 0x10680
    COTTAGE_ROUNDED = 0x10681
    COTTAGE_SHARP = 0x10682
    COUNTERTOPS = 0x10683
    COUNTERTOPS_OUTLINED = 0x10684
    COUNTERTOPS_ROUNDED = 0x10685
    COUNTERTOPS_SHARP = 0x10686
    CREATE = 0x10687
    CREATE_NEW_FOLDER = 0x10688
    CREATE_NEW_FOLDER_OUTLINED = 0x10689
    CREATE_NEW_FOLDER_ROUNDED = 0x1068A
    CREATE_NEW_FOLDER_SHARP = 0x1068B
    CREATE_OUTLINED = 0x1068C
    CREATE_ROUNDED = 0x1068D
    CREATE_SHARP = 0x1068E
    CREDIT_CARD = 0x1068F
    CREDIT_CARD_OFF = 0x10690
    CREDIT_CARD_OFF_OUTLINED = 0x10691
    CREDIT_CARD_OFF_ROUNDED = 0x10692
    CREDIT_CARD_OFF_SHARP = 0x10693
    CREDIT_CARD_OUTLINED = 0x10694
    CREDIT_CARD_ROUNDED = 0x10695
    CREDIT_CARD_SHARP = 0x10696
    CREDIT_SCORE = 0x10697
    CREDIT_SCORE_OUTLINED = 0x10698
    CREDIT_SCORE_ROUNDED = 0x10699
    CREDIT_SCORE_SHARP = 0x1069A
    CRIB = 0x1069B
    CRIB_OUTLINED = 0x1069C
    CRIB_ROUNDED = 0x1069D
    CRIB_SHARP = 0x1069E
    CRISIS_ALERT = 0x1069F
    CRISIS_ALERT_OUTLINED = 0x106A0
    CRISIS_ALERT_ROUNDED = 0x106A1
    CRISIS_ALERT_SHARP = 0x106A2
    CROP = 0x106A3
    CROP_16_9 = 0x106A4
    CROP_16_9_OUTLINED = 0x106A5
    CROP_16_9_ROUNDED = 0x106A6
    CROP_16_9_SHARP = 0x106A7
    CROP_3_2 = 0x106A8
    CROP_3_2_OUTLINED = 0x106A9
    CROP_3_2_ROUNDED = 0x106AA
    CROP_3_2_SHARP = 0x106AB
    CROP_5_4 = 0x106AC
    CROP_5_4_OUTLINED = 0x106AD
    CROP_5_4_ROUNDED = 0x106AE
    CROP_5_4_SHARP = 0x106AF
    CROP_7_5 = 0x106B0
    CROP_7_5_OUTLINED = 0x106B1
    CROP_7_5_ROUNDED = 0x106B2
    CROP_7_5_SHARP = 0x106B3
    CROP_DIN = 0x106B4
    CROP_DIN_OUTLINED = 0x106B5
    CROP_DIN_ROUNDED = 0x106B6
    CROP_DIN_SHARP = 0x106B7
    CROP_FREE = 0x106B8
    CROP_FREE_OUTLINED = 0x106B9
    CROP_FREE_ROUNDED = 0x106BA
    CROP_FREE_SHARP = 0x106BB
    CROP_LANDSCAPE = 0x106BC
    CROP_LANDSCAPE_OUTLINED = 0x106BD
    CROP_LANDSCAPE_ROUNDED = 0x106BE
    CROP_LANDSCAPE_SHARP = 0x106BF
    CROP_ORIGINAL = 0x106C0
    CROP_ORIGINAL_OUTLINED = 0x106C1
    CROP_ORIGINAL_ROUNDED = 0x106C2
    CROP_ORIGINAL_SHARP = 0x106C3
    CROP_OUTLINED = 0x106C4
    CROP_PORTRAIT = 0x106C5
    CROP_PORTRAIT_OUTLINED = 0x106C6
    CROP_PORTRAIT_ROUNDED = 0x106C7
    CROP_PORTRAIT_SHARP = 0x106C8
    CROP_ROTATE = 0x106C9
    CROP_ROTATE_OUTLINED = 0x106CA
    CROP_ROTATE_ROUNDED = 0x106CB
    CROP_ROTATE_SHARP = 0x106CC
    CROP_ROUNDED = 0x106CD
    CROP_SHARP = 0x106CE
    CROP_SQUARE = 0x106CF
    CROP_SQUARE_OUTLINED = 0x106D0
    CROP_SQUARE_ROUNDED = 0x106D1
    CROP_SQUARE_SHARP = 0x106D2
    CRUELTY_FREE = 0x106D3
    CRUELTY_FREE_OUTLINED = 0x106D4
    CRUELTY_FREE_ROUNDED = 0x106D5
    CRUELTY_FREE_SHARP = 0x106D6
    CSS = 0x106D7
    CSS_OUTLINED = 0x106D8
    CSS_ROUNDED = 0x106D9
    CSS_SHARP = 0x106DA
    CURRENCY_BITCOIN = 0x106DB
    CURRENCY_BITCOIN_OUTLINED = 0x106DC
    CURRENCY_BITCOIN_ROUNDED = 0x106DD
    CURRENCY_BITCOIN_SHARP = 0x106DE
    CURRENCY_EXCHANGE = 0x106DF
    CURRENCY_EXCHANGE_OUTLINED = 0x106E0
    CURRENCY_EXCHANGE_ROUNDED = 0x106E1
    CURRENCY_EXCHANGE_SHARP = 0x106E2
    CURRENCY_FRANC = 0x106E3
    CURRENCY_FRANC_OUTLINED = 0x106E4
    CURRENCY_FRANC_ROUNDED = 0x106E5
    CURRENCY_FRANC_SHARP = 0x106E6
    CURRENCY_LIRA = 0x106E7
    CURRENCY_LIRA_OUTLINED = 0x106E8
    CURRENCY_LIRA_ROUNDED = 0x106E9
    CURRENCY_LIRA_SHARP = 0x106EA
    CURRENCY_POUND = 0x106EB
    CURRENCY_POUND_OUTLINED = 0x106EC
    CURRENCY_POUND_ROUNDED = 0x106ED
    CURRENCY_POUND_SHARP = 0x106EE
    CURRENCY_RUBLE = 0x106EF
    CURRENCY_RUBLE_OUTLINED = 0x106F0
    CURRENCY_RUBLE_ROUNDED = 0x106F1
    CURRENCY_RUBLE_SHARP = 0x106F2
    CURRENCY_RUPEE = 0x106F3
    CURRENCY_RUPEE_OUTLINED = 0x106F4
    CURRENCY_RUPEE_ROUNDED = 0x106F5
    CURRENCY_RUPEE_SHARP = 0x106F6
    CURRENCY_YEN = 0x106F7
    CURRENCY_YEN_OUTLINED = 0x106F8
    CURRENCY_YEN_ROUNDED = 0x106F9
    CURRENCY_YEN_SHARP = 0x106FA
    CURRENCY_YUAN = 0x106FB
    CURRENCY_YUAN_OUTLINED = 0x106FC
    CURRENCY_YUAN_ROUNDED = 0x106FD
    CURRENCY_YUAN_SHARP = 0x106FE
    CURTAINS = 0x106FF
    CURTAINS_CLOSED = 0x10700
    CURTAINS_CLOSED_OUTLINED = 0x10701
    CURTAINS_CLOSED_ROUNDED = 0x10702
    CURTAINS_CLOSED_SHARP = 0x10703
    CURTAINS_OUTLINED = 0x10704
    CURTAINS_ROUNDED = 0x10705
    CURTAINS_SHARP = 0x10706
    CUT = 0x10707
    CUT_OUTLINED = 0x10708
    CUT_ROUNDED = 0x10709
    CUT_SHARP = 0x1070A
    CYCLONE = 0x1070B
    CYCLONE_OUTLINED = 0x1070C
    CYCLONE_ROUNDED = 0x1070D
    CYCLONE_SHARP = 0x1070E
    DANGEROUS = 0x1070F
    DANGEROUS_OUTLINED = 0x10710
    DANGEROUS_ROUNDED = 0x10711
    DANGEROUS_SHARP = 0x10712
    DARK_MODE = 0x10713
    DARK_MODE_OUTLINED = 0x10714
    DARK_MODE_ROUNDED = 0x10715
    DARK_MODE_SHARP = 0x10716
    DASHBOARD = 0x10717
    DASHBOARD_CUSTOMIZE = 0x10718
    DASHBOARD_CUSTOMIZE_OUTLINED = 0x10719
    DASHBOARD_CUSTOMIZE_ROUNDED = 0x1071A
    DASHBOARD_CUSTOMIZE_SHARP = 0x1071B
    DASHBOARD_OUTLINED = 0x1071C
    DASHBOARD_ROUNDED = 0x1071D
    DASHBOARD_SHARP = 0x1071E
    DATA_ARRAY = 0x1071F
    DATA_ARRAY_OUTLINED = 0x10720
    DATA_ARRAY_ROUNDED = 0x10721
    DATA_ARRAY_SHARP = 0x10722
    DATA_EXPLORATION = 0x10723
    DATA_EXPLORATION_OUTLINED = 0x10724
    DATA_EXPLORATION_ROUNDED = 0x10725
    DATA_EXPLORATION_SHARP = 0x10726
    DATA_OBJECT = 0x10727
    DATA_OBJECT_OUTLINED = 0x10728
    DATA_OBJECT_ROUNDED = 0x10729
    DATA_OBJECT_SHARP = 0x1072A
    DATA_SAVER_OFF = 0x1072B
    DATA_SAVER_OFF_OUTLINED = 0x1072C
    DATA_SAVER_OFF_ROUNDED = 0x1072D
    DATA_SAVER_OFF_SHARP = 0x1072E
    DATA_SAVER_ON = 0x1072F
    DATA_SAVER_ON_OUTLINED = 0x10730
    DATA_SAVER_ON_ROUNDED = 0x10731
    DATA_SAVER_ON_SHARP = 0x10732
    DATA_THRESHOLDING = 0x10733
    DATA_THRESHOLDING_OUTLINED = 0x10734
    DATA_THRESHOLDING_ROUNDED = 0x10735
    DATA_THRESHOLDING_SHARP = 0x10736
    DATA_USAGE = 0x10737
    DATA_USAGE_OUTLINED = 0x10738
    DATA_USAGE_ROUNDED = 0x10739
    DATA_USAGE_SHARP = 0x1073A
    DATASET = 0x1073B
    DATASET_LINKED = 0x1073C
    DATASET_LINKED_OUTLINED = 0x1073D
    DATASET_LINKED_ROUNDED = 0x1073E
    DATASET_LINKED_SHARP = 0x1073F
    DATASET_OUTLINED = 0x10740
    DATASET_ROUNDED = 0x10741
    DATASET_SHARP = 0x10742
    DATE_RANGE = 0x10743
    DATE_RANGE_OUTLINED = 0x10744
    DATE_RANGE_ROUNDED = 0x10745
    DATE_RANGE_SHARP = 0x10746
    DEBLUR = 0x10747
    DEBLUR_OUTLINED = 0x10748
    DEBLUR_ROUNDED = 0x10749
    DEBLUR_SHARP = 0x1074A
    DECK = 0x1074B
    DECK_OUTLINED = 0x1074C
    DECK_ROUNDED = 0x1074D
    DECK_SHARP = 0x1074E
    DEHAZE = 0x1074F
    DEHAZE_OUTLINED = 0x10750
    DEHAZE_ROUNDED = 0x10751
    DEHAZE_SHARP = 0x10752
    DELETE = 0x10753
    DELETE_FOREVER = 0x10754
    DELETE_FOREVER_OUTLINED = 0x10755
    DELETE_FOREVER_ROUNDED = 0x10756
    DELETE_FOREVER_SHARP = 0x10757
    DELETE_OUTLINE = 0x10758
    DELETE_OUTLINE_OUTLINED = 0x10759
    DELETE_OUTLINE_ROUNDED = 0x1075A
    DELETE_OUTLINE_SHARP = 0x1075B
    DELETE_OUTLINED = 0x1075C
    DELETE_ROUNDED = 0x1075D
    DELETE_SHARP = 0x1075E
    DELETE_SWEEP = 0x1075F
    DELETE_SWEEP_OUTLINED = 0x10760
    DELETE_SWEEP_ROUNDED = 0x10761
    DELETE_SWEEP_SHARP = 0x10762
    DELIVERY_DINING = 0x10763
    DELIVERY_DINING_OUTLINED = 0x10764
    DELIVERY_DINING_ROUNDED = 0x10765
    DELIVERY_DINING_SHARP = 0x10766
    DENSITY_LARGE = 0x10767
    DENSITY_LARGE_OUTLINED = 0x10768
    DENSITY_LARGE_ROUNDED = 0x10769
    DENSITY_LARGE_SHARP = 0x1076A
    DENSITY_MEDIUM = 0x1076B
    DENSITY_MEDIUM_OUTLINED = 0x1076C
    DENSITY_MEDIUM_ROUNDED = 0x1076D
    DENSITY_MEDIUM_SHARP = 0x1076E
    DENSITY_SMALL = 0x1076F
    DENSITY_SMALL_OUTLINED = 0x10770
    DENSITY_SMALL_ROUNDED = 0x10771
    DENSITY_SMALL_SHARP = 0x10772
    DEPARTURE_BOARD = 0x10773
    DEPARTURE_BOARD_OUTLINED = 0x10774
    DEPARTURE_BOARD_ROUNDED = 0x10775
    DEPARTURE_BOARD_SHARP = 0x10776
    DESCRIPTION = 0x10777
    DESCRIPTION_OUTLINED = 0x10778
    DESCRIPTION_ROUNDED = 0x10779
    DESCRIPTION_SHARP = 0x1077A
    DESELECT = 0x1077B
    DESELECT_OUTLINED = 0x1077C
    DESELECT_ROUNDED = 0x1077D
    DESELECT_SHARP = 0x1077E
    DESIGN_SERVICES = 0x1077F
    DESIGN_SERVICES_OUTLINED = 0x10780
    DESIGN_SERVICES_ROUNDED = 0x10781
    DESIGN_SERVICES_SHARP = 0x10782
    DESK = 0x10783
    DESK_OUTLINED = 0x10784
    DESK_ROUNDED = 0x10785
    DESK_SHARP = 0x10786
    DESKTOP_ACCESS_DISABLED = 0x10787
    DESKTOP_ACCESS_DISABLED_OUTLINED = 0x10788
    DESKTOP_ACCESS_DISABLED_ROUNDED = 0x10789
    DESKTOP_ACCESS_DISABLED_SHARP = 0x1078A
    DESKTOP_MAC = 0x1078B
    DESKTOP_MAC_OUTLINED = 0x1078C
    DESKTOP_MAC_ROUNDED = 0x1078D
    DESKTOP_MAC_SHARP = 0x1078E
    DESKTOP_WINDOWS = 0x1078F
    DESKTOP_WINDOWS_OUTLINED = 0x10790
    DESKTOP_WINDOWS_ROUNDED = 0x10791
    DESKTOP_WINDOWS_SHARP = 0x10792
    DETAILS = 0x10793
    DETAILS_OUTLINED = 0x10794
    DETAILS_ROUNDED = 0x10795
    DETAILS_SHARP = 0x10796
    DEVELOPER_BOARD = 0x10797
    DEVELOPER_BOARD_OFF = 0x10798
    DEVELOPER_BOARD_OFF_OUTLINED = 0x10799
    DEVELOPER_BOARD_OFF_ROUNDED = 0x1079A
    DEVELOPER_BOARD_OFF_SHARP = 0x1079B
    DEVELOPER_BOARD_OUTLINED = 0x1079C
    DEVELOPER_BOARD_ROUNDED = 0x1079D
    DEVELOPER_BOARD_SHARP = 0x1079E
    DEVELOPER_MODE = 0x1079F
    DEVELOPER_MODE_OUTLINED = 0x107A0
    DEVELOPER_MODE_ROUNDED = 0x107A1
    DEVELOPER_MODE_SHARP = 0x107A2
    DEVICE_HUB = 0x107A3
    DEVICE_HUB_OUTLINED = 0x107A4
    DEVICE_HUB_ROUNDED = 0x107A5
    DEVICE_HUB_SHARP = 0x107A6
    DEVICE_THERMOSTAT = 0x107A7
    DEVICE_THERMOSTAT_OUTLINED = 0x107A8
    DEVICE_THERMOSTAT_ROUNDED = 0x107A9
    DEVICE_THERMOSTAT_SHARP = 0x107AA
    DEVICE_UNKNOWN = 0x107AB
    DEVICE_UNKNOWN_OUTLINED = 0x107AC
    DEVICE_UNKNOWN_ROUNDED = 0x107AD
    DEVICE_UNKNOWN_SHARP = 0x107AE
    DEVICES = 0x107AF
    DEVICES_FOLD = 0x107B0
    DEVICES_FOLD_OUTLINED = 0x107B1
    DEVICES_FOLD_ROUNDED = 0x107B2
    DEVICES_FOLD_SHARP = 0x107B3
    DEVICES_OTHER = 0x107B4
    DEVICES_OTHER_OUTLINED = 0x107B5
    DEVICES_OTHER_ROUNDED = 0x107B6
    DEVICES_OTHER_SHARP = 0x107B7
    DEVICES_OUTLINED = 0x107B8
    DEVICES_ROUNDED = 0x107B9
    DEVICES_SHARP = 0x107BA
    DEW_POINT = 0x107BB
    DIALER_SIP = 0x107BC
    DIALER_SIP_OUTLINED = 0x107BD
    DIALER_SIP_ROUNDED = 0x107BE
    DIALER_SIP_SHARP = 0x107BF
    DIALPAD = 0x107C0
    DIALPAD_OUTLINED = 0x107C1
    DIALPAD_ROUNDED = 0x107C2
    DIALPAD_SHARP = 0x107C3
    DIAMOND = 0x107C4
    DIAMOND_OUTLINED = 0x107C5
    DIAMOND_ROUNDED = 0x107C6
    DIAMOND_SHARP = 0x107C7
    DIFFERENCE = 0x107C8
    DIFFERENCE_OUTLINED = 0x107C9
    DIFFERENCE_ROUNDED = 0x107CA
    DIFFERENCE_SHARP = 0x107CB
    DINING = 0x107CC
    DINING_OUTLINED = 0x107CD
    DINING_ROUNDED = 0x107CE
    DINING_SHARP = 0x107CF
    DINNER_DINING = 0x107D0
    DINNER_DINING_OUTLINED = 0x107D1
    DINNER_DINING_ROUNDED = 0x107D2
    DINNER_DINING_SHARP = 0x107D3
    DIRECTIONS = 0x107D4
    DIRECTIONS_BIKE = 0x107D5
    DIRECTIONS_BIKE_OUTLINED = 0x107D6
    DIRECTIONS_BIKE_ROUNDED = 0x107D7
    DIRECTIONS_BIKE_SHARP = 0x107D8
    DIRECTIONS_BOAT = 0x107D9
    DIRECTIONS_BOAT_FILLED = 0x107DA
    DIRECTIONS_BOAT_FILLED_OUTLINED = 0x107DB
    DIRECTIONS_BOAT_FILLED_ROUNDED = 0x107DC
    DIRECTIONS_BOAT_FILLED_SHARP = 0x107DD
    DIRECTIONS_BOAT_OUTLINED = 0x107DE
    DIRECTIONS_BOAT_ROUNDED = 0x107DF
    DIRECTIONS_BOAT_SHARP = 0x107E0
    DIRECTIONS_BUS = 0x107E1
    DIRECTIONS_BUS_FILLED = 0x107E2
    DIRECTIONS_BUS_FILLED_OUTLINED = 0x107E3
    DIRECTIONS_BUS_FILLED_ROUNDED = 0x107E4
    DIRECTIONS_BUS_FILLED_SHARP = 0x107E5
    DIRECTIONS_BUS_OUTLINED = 0x107E6
    DIRECTIONS_BUS_ROUNDED = 0x107E7
    DIRECTIONS_BUS_SHARP = 0x107E8
    DIRECTIONS_CAR = 0x107E9
    DIRECTIONS_CAR_FILLED = 0x107EA
    DIRECTIONS_CAR_FILLED_OUTLINED = 0x107EB
    DIRECTIONS_CAR_FILLED_ROUNDED = 0x107EC
    DIRECTIONS_CAR_FILLED_SHARP = 0x107ED
    DIRECTIONS_CAR_OUTLINED = 0x107EE
    DIRECTIONS_CAR_ROUNDED = 0x107EF
    DIRECTIONS_CAR_SHARP = 0x107F0
    DIRECTIONS_FERRY = 0x107F1
    DIRECTIONS_FERRY_OUTLINED = 0x107F2
    DIRECTIONS_FERRY_ROUNDED = 0x107F3
    DIRECTIONS_FERRY_SHARP = 0x107F4
    DIRECTIONS_OFF = 0x107F5
    DIRECTIONS_OFF_OUTLINED = 0x107F6
    DIRECTIONS_OFF_ROUNDED = 0x107F7
    DIRECTIONS_OFF_SHARP = 0x107F8
    DIRECTIONS_OUTLINED = 0x107F9
    DIRECTIONS_RAILWAY = 0x107FA
    DIRECTIONS_RAILWAY_FILLED = 0x107FB
    DIRECTIONS_RAILWAY_FILLED_OUTLINED = 0x107FC
    DIRECTIONS_RAILWAY_FILLED_ROUNDED = 0x107FD
    DIRECTIONS_RAILWAY_FILLED_SHARP = 0x107FE
    DIRECTIONS_RAILWAY_OUTLINED = 0x107FF
    DIRECTIONS_RAILWAY_ROUNDED = 0x10800
    DIRECTIONS_RAILWAY_SHARP = 0x10801
    DIRECTIONS_ROUNDED = 0x10802
    DIRECTIONS_RUN = 0x10803
    DIRECTIONS_RUN_OUTLINED = 0x10804
    DIRECTIONS_RUN_ROUNDED = 0x10805
    DIRECTIONS_RUN_SHARP = 0x10806
    DIRECTIONS_SHARP = 0x10807
    DIRECTIONS_SUBWAY = 0x10808
    DIRECTIONS_SUBWAY_FILLED = 0x10809
    DIRECTIONS_SUBWAY_FILLED_OUTLINED = 0x1080A
    DIRECTIONS_SUBWAY_FILLED_ROUNDED = 0x1080B
    DIRECTIONS_SUBWAY_FILLED_SHARP = 0x1080C
    DIRECTIONS_SUBWAY_OUTLINED = 0x1080D
    DIRECTIONS_SUBWAY_ROUNDED = 0x1080E
    DIRECTIONS_SUBWAY_SHARP = 0x1080F
    DIRECTIONS_TRAIN = 0x10810
    DIRECTIONS_TRAIN_OUTLINED = 0x10811
    DIRECTIONS_TRAIN_ROUNDED = 0x10812
    DIRECTIONS_TRAIN_SHARP = 0x10813
    DIRECTIONS_TRANSIT = 0x10814
    DIRECTIONS_TRANSIT_FILLED = 0x10815
    DIRECTIONS_TRANSIT_FILLED_OUTLINED = 0x10816
    DIRECTIONS_TRANSIT_FILLED_ROUNDED = 0x10817
    DIRECTIONS_TRANSIT_FILLED_SHARP = 0x10818
    DIRECTIONS_TRANSIT_OUTLINED = 0x10819
    DIRECTIONS_TRANSIT_ROUNDED = 0x1081A
    DIRECTIONS_TRANSIT_SHARP = 0x1081B
    DIRECTIONS_WALK = 0x1081C
    DIRECTIONS_WALK_OUTLINED = 0x1081D
    DIRECTIONS_WALK_ROUNDED = 0x1081E
    DIRECTIONS_WALK_SHARP = 0x1081F
    DIRTY_LENS = 0x10820
    DIRTY_LENS_OUTLINED = 0x10821
    DIRTY_LENS_ROUNDED = 0x10822
    DIRTY_LENS_SHARP = 0x10823
    DISABLED_BY_DEFAULT = 0x10824
    DISABLED_BY_DEFAULT_OUTLINED = 0x10825
    DISABLED_BY_DEFAULT_ROUNDED = 0x10826
    DISABLED_BY_DEFAULT_SHARP = 0x10827
    DISABLED_VISIBLE = 0x10828
    DISABLED_VISIBLE_OUTLINED = 0x10829
    DISABLED_VISIBLE_ROUNDED = 0x1082A
    DISABLED_VISIBLE_SHARP = 0x1082B
    DISC_FULL = 0x1082C
    DISC_FULL_OUTLINED = 0x1082D
    DISC_FULL_ROUNDED = 0x1082E
    DISC_FULL_SHARP = 0x1082F
    DISCORD = 0x10830
    DISCORD_OUTLINED = 0x10831
    DISCORD_ROUNDED = 0x10832
    DISCORD_SHARP = 0x10833
    DISCOUNT = 0x10834
    DISCOUNT_OUTLINED = 0x10835
    DISCOUNT_ROUNDED = 0x10836
    DISCOUNT_SHARP = 0x10837
    DISPLAY_SETTINGS = 0x10838
    DISPLAY_SETTINGS_OUTLINED = 0x10839
    DISPLAY_SETTINGS_ROUNDED = 0x1083A
    DISPLAY_SETTINGS_SHARP = 0x1083B
    DIVERSITY_1 = 0x1083C
    DIVERSITY_1_OUTLINED = 0x1083D
    DIVERSITY_1_ROUNDED = 0x1083E
    DIVERSITY_1_SHARP = 0x1083F
    DIVERSITY_2 = 0x10840
    DIVERSITY_2_OUTLINED = 0x10841
    DIVERSITY_2_ROUNDED = 0x10842
    DIVERSITY_2_SHARP = 0x10843
    DIVERSITY_3 = 0x10844
    DIVERSITY_3_OUTLINED = 0x10845
    DIVERSITY_3_ROUNDED = 0x10846
    DIVERSITY_3_SHARP = 0x10847
    DND_FORWARDSLASH = 0x10848
    DND_FORWARDSLASH_OUTLINED = 0x10849
    DND_FORWARDSLASH_ROUNDED = 0x1084A
    DND_FORWARDSLASH_SHARP = 0x1084B
    DNS = 0x1084C
    DNS_OUTLINED = 0x1084D
    DNS_ROUNDED = 0x1084E
    DNS_SHARP = 0x1084F
    DO_DISTURB = 0x10850
    DO_DISTURB_ALT = 0x10851
    DO_DISTURB_ALT_OUTLINED = 0x10852
    DO_DISTURB_ALT_ROUNDED = 0x10853
    DO_DISTURB_ALT_SHARP = 0x10854
    DO_DISTURB_OFF = 0x10855
    DO_DISTURB_OFF_OUTLINED = 0x10856
    DO_DISTURB_OFF_ROUNDED = 0x10857
    DO_DISTURB_OFF_SHARP = 0x10858
    DO_DISTURB_ON = 0x10859
    DO_DISTURB_ON_OUTLINED = 0x1085A
    DO_DISTURB_ON_ROUNDED = 0x1085B
    DO_DISTURB_ON_SHARP = 0x1085C
    DO_DISTURB_OUTLINED = 0x1085D
    DO_DISTURB_ROUNDED = 0x1085E
    DO_DISTURB_SHARP = 0x1085F
    DO_NOT_DISTURB = 0x10860
    DO_NOT_DISTURB_ALT = 0x10861
    DO_NOT_DISTURB_ALT_OUTLINED = 0x10862
    DO_NOT_DISTURB_ALT_ROUNDED = 0x10863
    DO_NOT_DISTURB_ALT_SHARP = 0x10864
    DO_NOT_DISTURB_OFF = 0x10865
    DO_NOT_DISTURB_OFF_OUTLINED = 0x10866
    DO_NOT_DISTURB_OFF_ROUNDED = 0x10867
    DO_NOT_DISTURB_OFF_SHARP = 0x10868
    DO_NOT_DISTURB_ON = 0x10869
    DO_NOT_DISTURB_ON_OUTLINED = 0x1086A
    DO_NOT_DISTURB_ON_ROUNDED = 0x1086B
    DO_NOT_DISTURB_ON_SHARP = 0x1086C
    DO_NOT_DISTURB_ON_TOTAL_SILENCE = 0x1086D
    DO_NOT_DISTURB_ON_TOTAL_SILENCE_OUTLINED = 0x1086E
    DO_NOT_DISTURB_ON_TOTAL_SILENCE_ROUNDED = 0x1086F
    DO_NOT_DISTURB_ON_TOTAL_SILENCE_SHARP = 0x10870
    DO_NOT_DISTURB_OUTLINED = 0x10871
    DO_NOT_DISTURB_ROUNDED = 0x10872
    DO_NOT_DISTURB_SHARP = 0x10873
    DO_NOT_STEP = 0x10874
    DO_NOT_STEP_OUTLINED = 0x10875
    DO_NOT_STEP_ROUNDED = 0x10876
    DO_NOT_STEP_SHARP = 0x10877
    DO_NOT_TOUCH = 0x10878
    DO_NOT_TOUCH_OUTLINED = 0x10879
    DO_NOT_TOUCH_ROUNDED = 0x1087A
    DO_NOT_TOUCH_SHARP = 0x1087B
    DOCK = 0x1087C
    DOCK_OUTLINED = 0x1087D
    DOCK_ROUNDED = 0x1087E
    DOCK_SHARP = 0x1087F
    DOCUMENT_SCANNER = 0x10880
    DOCUMENT_SCANNER_OUTLINED = 0x10881
    DOCUMENT_SCANNER_ROUNDED = 0x10882
    DOCUMENT_SCANNER_SHARP = 0x10883
    DOMAIN = 0x10884
    DOMAIN_ADD = 0x10885
    DOMAIN_ADD_OUTLINED = 0x10886
    DOMAIN_ADD_ROUNDED = 0x10887
    DOMAIN_ADD_SHARP = 0x10888
    DOMAIN_DISABLED = 0x10889
    DOMAIN_DISABLED_OUTLINED = 0x1088A
    DOMAIN_DISABLED_ROUNDED = 0x1088B
    DOMAIN_DISABLED_SHARP = 0x1088C
    DOMAIN_OUTLINED = 0x1088D
    DOMAIN_ROUNDED = 0x1088E
    DOMAIN_SHARP = 0x1088F
    DOMAIN_VERIFICATION = 0x10890
    DOMAIN_VERIFICATION_OUTLINED = 0x10891
    DOMAIN_VERIFICATION_ROUNDED = 0x10892
    DOMAIN_VERIFICATION_SHARP = 0x10893
    DONE = 0x10894
    DONE_ALL = 0x10895
    DONE_ALL_OUTLINED = 0x10896
    DONE_ALL_ROUNDED = 0x10897
    DONE_ALL_SHARP = 0x10898
    DONE_OUTLINE = 0x10899
    DONE_OUTLINE_OUTLINED = 0x1089A
    DONE_OUTLINE_ROUNDED = 0x1089B
    DONE_OUTLINE_SHARP = 0x1089C
    DONE_OUTLINED = 0x1089D
    DONE_ROUNDED = 0x1089E
    DONE_SHARP = 0x1089F
    DONUT_LARGE = 0x108A0
    DONUT_LARGE_OUTLINED = 0x108A1
    DONUT_LARGE_ROUNDED = 0x108A2
    DONUT_LARGE_SHARP = 0x108A3
    DONUT_SMALL = 0x108A4
    DONUT_SMALL_OUTLINED = 0x108A5
    DONUT_SMALL_ROUNDED = 0x108A6
    DONUT_SMALL_SHARP = 0x108A7
    DOOR_BACK_DOOR = 0x108A8
    DOOR_BACK_DOOR_OUTLINED = 0x108A9
    DOOR_BACK_DOOR_ROUNDED = 0x108AA
    DOOR_BACK_DOOR_SHARP = 0x108AB
    DOOR_FRONT_DOOR = 0x108AC
    DOOR_FRONT_DOOR_OUTLINED = 0x108AD
    DOOR_FRONT_DOOR_ROUNDED = 0x108AE
    DOOR_FRONT_DOOR_SHARP = 0x108AF
    DOOR_SLIDING = 0x108B0
    DOOR_SLIDING_OUTLINED = 0x108B1
    DOOR_SLIDING_ROUNDED = 0x108B2
    DOOR_SLIDING_SHARP = 0x108B3
    DOORBELL = 0x108B4
    DOORBELL_OUTLINED = 0x108B5
    DOORBELL_ROUNDED = 0x108B6
    DOORBELL_SHARP = 0x108B7
    DOUBLE_ARROW = 0x108B8
    DOUBLE_ARROW_OUTLINED = 0x108B9
    DOUBLE_ARROW_ROUNDED = 0x108BA
    DOUBLE_ARROW_SHARP = 0x108BB
    DOWNHILL_SKIING = 0x108BC
    DOWNHILL_SKIING_OUTLINED = 0x108BD
    DOWNHILL_SKIING_ROUNDED = 0x108BE
    DOWNHILL_SKIING_SHARP = 0x108BF
    DOWNLOAD = 0x108C0
    DOWNLOAD_DONE = 0x108C1
    DOWNLOAD_DONE_OUTLINED = 0x108C2
    DOWNLOAD_DONE_ROUNDED = 0x108C3
    DOWNLOAD_DONE_SHARP = 0x108C4
    DOWNLOAD_FOR_OFFLINE = 0x108C5
    DOWNLOAD_FOR_OFFLINE_OUTLINED = 0x108C6
    DOWNLOAD_FOR_OFFLINE_ROUNDED = 0x108C7
    DOWNLOAD_FOR_OFFLINE_SHARP = 0x108C8
    DOWNLOAD_OUTLINED = 0x108C9
    DOWNLOAD_ROUNDED = 0x108CA
    DOWNLOAD_SHARP = 0x108CB
    DOWNLOADING = 0x108CC
    DOWNLOADING_OUTLINED = 0x108CD
    DOWNLOADING_ROUNDED = 0x108CE
    DOWNLOADING_SHARP = 0x108CF
    DRAFTS = 0x108D0
    DRAFTS_OUTLINED = 0x108D1
    DRAFTS_ROUNDED = 0x108D2
    DRAFTS_SHARP = 0x108D3
    DRAG_HANDLE = 0x108D4
    DRAG_HANDLE_OUTLINED = 0x108D5
    DRAG_HANDLE_ROUNDED = 0x108D6
    DRAG_HANDLE_SHARP = 0x108D7
    DRAG_INDICATOR = 0x108D8
    DRAG_INDICATOR_OUTLINED = 0x108D9
    DRAG_INDICATOR_ROUNDED = 0x108DA
    DRAG_INDICATOR_SHARP = 0x108DB
    DRAW = 0x108DC
    DRAW_OUTLINED = 0x108DD
    DRAW_ROUNDED = 0x108DE
    DRAW_SHARP = 0x108DF
    DRIVE_ETA = 0x108E0
    DRIVE_ETA_OUTLINED = 0x108E1
    DRIVE_ETA_ROUNDED = 0x108E2
    DRIVE_ETA_SHARP = 0x108E3
    DRIVE_FILE_MOVE = 0x108E4
    DRIVE_FILE_MOVE_OUTLINE = 0x108E5
    DRIVE_FILE_MOVE_OUTLINED = 0x108E6
    DRIVE_FILE_MOVE_ROUNDED = 0x108E7
    DRIVE_FILE_MOVE_RTL = 0x108E8
    DRIVE_FILE_MOVE_RTL_OUTLINED = 0x108E9
    DRIVE_FILE_MOVE_RTL_ROUNDED = 0x108EA
    DRIVE_FILE_MOVE_RTL_SHARP = 0x108EB
    DRIVE_FILE_MOVE_SHARP = 0x108EC
    DRIVE_FILE_RENAME_OUTLINE = 0x108ED
    DRIVE_FILE_RENAME_OUTLINE_OUTLINED = 0x108EE
    DRIVE_FILE_RENAME_OUTLINE_ROUNDED = 0x108EF
    DRIVE_FILE_RENAME_OUTLINE_SHARP = 0x108F0
    DRIVE_FOLDER_UPLOAD = 0x108F1
    DRIVE_FOLDER_UPLOAD_OUTLINED = 0x108F2
    DRIVE_FOLDER_UPLOAD_ROUNDED = 0x108F3
    DRIVE_FOLDER_UPLOAD_SHARP = 0x108F4
    DRY = 0x108F5
    DRY_CLEANING = 0x108F6
    DRY_CLEANING_OUTLINED = 0x108F7
    DRY_CLEANING_ROUNDED = 0x108F8
    DRY_CLEANING_SHARP = 0x108F9
    DRY_OUTLINED = 0x108FA
    DRY_ROUNDED = 0x108FB
    DRY_SHARP = 0x108FC
    DUO = 0x108FD
    DUO_OUTLINED = 0x108FE
    DUO_ROUNDED = 0x108FF
    DUO_SHARP = 0x10900
    DVR = 0x10901
    DVR_OUTLINED = 0x10902
    DVR_ROUNDED = 0x10903
    DVR_SHARP = 0x10904
    DYNAMIC_FEED = 0x10905
    DYNAMIC_FEED_OUTLINED = 0x10906
    DYNAMIC_FEED_ROUNDED = 0x10907
    DYNAMIC_FEED_SHARP = 0x10908
    DYNAMIC_FORM = 0x10909
    DYNAMIC_FORM_OUTLINED = 0x1090A
    DYNAMIC_FORM_ROUNDED = 0x1090B
    DYNAMIC_FORM_SHARP = 0x1090C
    E_MOBILEDATA = 0x1090D
    E_MOBILEDATA_OUTLINED = 0x1090E
    E_MOBILEDATA_ROUNDED = 0x1090F
    E_MOBILEDATA_SHARP = 0x10910
    EARBUDS = 0x10911
    EARBUDS_BATTERY = 0x10912
    EARBUDS_BATTERY_OUTLINED = 0x10913
    EARBUDS_BATTERY_ROUNDED = 0x10914
    EARBUDS_BATTERY_SHARP = 0x10915
    EARBUDS_OUTLINED = 0x10916
    EARBUDS_ROUNDED = 0x10917
    EARBUDS_SHARP = 0x10918
    EAST = 0x10919
    EAST_OUTLINED = 0x1091A
    EAST_ROUNDED = 0x1091B
    EAST_SHARP = 0x1091C
    ECO = 0x1091D
    ECO_OUTLINED = 0x1091E
    ECO_ROUNDED = 0x1091F
    ECO_SHARP = 0x10920
    EDGESENSOR_HIGH = 0x10921
    EDGESENSOR_HIGH_OUTLINED = 0x10922
    EDGESENSOR_HIGH_ROUNDED = 0x10923
    EDGESENSOR_HIGH_SHARP = 0x10924
    EDGESENSOR_LOW = 0x10925
    EDGESENSOR_LOW_OUTLINED = 0x10926
    EDGESENSOR_LOW_ROUNDED = 0x10927
    EDGESENSOR_LOW_SHARP = 0x10928
    EDIT = 0x10929
    EDIT_ATTRIBUTES = 0x1092A
    EDIT_ATTRIBUTES_OUTLINED = 0x1092B
    EDIT_ATTRIBUTES_ROUNDED = 0x1092C
    EDIT_ATTRIBUTES_SHARP = 0x1092D
    EDIT_CALENDAR = 0x1092E
    EDIT_CALENDAR_OUTLINED = 0x1092F
    EDIT_CALENDAR_ROUNDED = 0x10930
    EDIT_CALENDAR_SHARP = 0x10931
    EDIT_DOCUMENT = 0x10932
    EDIT_LOCATION = 0x10933
    EDIT_LOCATION_ALT = 0x10934
    EDIT_LOCATION_ALT_OUTLINED = 0x10935
    EDIT_LOCATION_ALT_ROUNDED = 0x10936
    EDIT_LOCATION_ALT_SHARP = 0x10937
    EDIT_LOCATION_OUTLINED = 0x10938
    EDIT_LOCATION_ROUNDED = 0x10939
    EDIT_LOCATION_SHARP = 0x1093A
    EDIT_NOTE = 0x1093B
    EDIT_NOTE_OUTLINED = 0x1093C
    EDIT_NOTE_ROUNDED = 0x1093D
    EDIT_NOTE_SHARP = 0x1093E
    EDIT_NOTIFICATIONS = 0x1093F
    EDIT_NOTIFICATIONS_OUTLINED = 0x10940
    EDIT_NOTIFICATIONS_ROUNDED = 0x10941
    EDIT_NOTIFICATIONS_SHARP = 0x10942
    EDIT_OFF = 0x10943
    EDIT_OFF_OUTLINED = 0x10944
    EDIT_OFF_ROUNDED = 0x10945
    EDIT_OFF_SHARP = 0x10946
    EDIT_OUTLINED = 0x10947
    EDIT_ROAD = 0x10948
    EDIT_ROAD_OUTLINED = 0x10949
    EDIT_ROAD_ROUNDED = 0x1094A
    EDIT_ROAD_SHARP = 0x1094B
    EDIT_ROUNDED = 0x1094C
    EDIT_SHARP = 0x1094D
    EDIT_SQUARE = 0x1094E
    EGG = 0x1094F
    EGG_ALT = 0x10950
    EGG_ALT_OUTLINED = 0x10951
    EGG_ALT_ROUNDED = 0x10952
    EGG_ALT_SHARP = 0x10953
    EGG_OUTLINED = 0x10954
    EGG_ROUNDED = 0x10955
    EGG_SHARP = 0x10956
    EIGHT_K = 0x10957
    EIGHT_K_OUTLINED = 0x10958
    EIGHT_K_PLUS = 0x10959
    EIGHT_K_PLUS_OUTLINED = 0x1095A
    EIGHT_K_PLUS_ROUNDED = 0x1095B
    EIGHT_K_PLUS_SHARP = 0x1095C
    EIGHT_K_ROUNDED = 0x1095D
    EIGHT_K_SHARP = 0x1095E
    EIGHT_MP = 0x1095F
    EIGHT_MP_OUTLINED = 0x10960
    EIGHT_MP_ROUNDED = 0x10961
    EIGHT_MP_SHARP = 0x10962
    EIGHTEEN_MP = 0x10963
    EIGHTEEN_MP_OUTLINED = 0x10964
    EIGHTEEN_MP_ROUNDED = 0x10965
    EIGHTEEN_MP_SHARP = 0x10966
    EIGHTEEN_UP_RATING = 0x10967
    EIGHTEEN_UP_RATING_OUTLINED = 0x10968
    EIGHTEEN_UP_RATING_ROUNDED = 0x10969
    EIGHTEEN_UP_RATING_SHARP = 0x1096A
    EJECT = 0x1096B
    EJECT_OUTLINED = 0x1096C
    EJECT_ROUNDED = 0x1096D
    EJECT_SHARP = 0x1096E
    ELDERLY = 0x1096F
    ELDERLY_OUTLINED = 0x10970
    ELDERLY_ROUNDED = 0x10971
    ELDERLY_SHARP = 0x10972
    ELDERLY_WOMAN = 0x10973
    ELDERLY_WOMAN_OUTLINED = 0x10974
    ELDERLY_WOMAN_ROUNDED = 0x10975
    ELDERLY_WOMAN_SHARP = 0x10976
    ELECTRIC_BIKE = 0x10977
    ELECTRIC_BIKE_OUTLINED = 0x10978
    ELECTRIC_BIKE_ROUNDED = 0x10979
    ELECTRIC_BIKE_SHARP = 0x1097A
    ELECTRIC_BOLT = 0x1097B
    ELECTRIC_BOLT_OUTLINED = 0x1097C
    ELECTRIC_BOLT_ROUNDED = 0x1097D
    ELECTRIC_BOLT_SHARP = 0x1097E
    ELECTRIC_CAR = 0x1097F
    ELECTRIC_CAR_OUTLINED = 0x10980
    ELECTRIC_CAR_ROUNDED = 0x10981
    ELECTRIC_CAR_SHARP = 0x10982
    ELECTRIC_METER = 0x10983
    ELECTRIC_METER_OUTLINED = 0x10984
    ELECTRIC_METER_ROUNDED = 0x10985
    ELECTRIC_METER_SHARP = 0x10986
    ELECTRIC_MOPED = 0x10987
    ELECTRIC_MOPED_OUTLINED = 0x10988
    ELECTRIC_MOPED_ROUNDED = 0x10989
    ELECTRIC_MOPED_SHARP = 0x1098A
    ELECTRIC_RICKSHAW = 0x1098B
    ELECTRIC_RICKSHAW_OUTLINED = 0x1098C
    ELECTRIC_RICKSHAW_ROUNDED = 0x1098D
    ELECTRIC_RICKSHAW_SHARP = 0x1098E
    ELECTRIC_SCOOTER = 0x1098F
    ELECTRIC_SCOOTER_OUTLINED = 0x10990
    ELECTRIC_SCOOTER_ROUNDED = 0x10991
    ELECTRIC_SCOOTER_SHARP = 0x10992
    ELECTRICAL_SERVICES = 0x10993
    ELECTRICAL_SERVICES_OUTLINED = 0x10994
    ELECTRICAL_SERVICES_ROUNDED = 0x10995
    ELECTRICAL_SERVICES_SHARP = 0x10996
    ELEVATOR = 0x10997
    ELEVATOR_OUTLINED = 0x10998
    ELEVATOR_ROUNDED = 0x10999
    ELEVATOR_SHARP = 0x1099A
    ELEVEN_MP = 0x1099B
    ELEVEN_MP_OUTLINED = 0x1099C
    ELEVEN_MP_ROUNDED = 0x1099D
    ELEVEN_MP_SHARP = 0x1099E
    EMAIL = 0x1099F
    EMAIL_OUTLINED = 0x109A0
    EMAIL_ROUNDED = 0x109A1
    EMAIL_SHARP = 0x109A2
    EMERGENCY = 0x109A3
    EMERGENCY_OUTLINED = 0x109A4
    EMERGENCY_RECORDING = 0x109A5
    EMERGENCY_RECORDING_OUTLINED = 0x109A6
    EMERGENCY_RECORDING_ROUNDED = 0x109A7
    EMERGENCY_RECORDING_SHARP = 0x109A8
    EMERGENCY_ROUNDED = 0x109A9
    EMERGENCY_SHARE = 0x109AA
    EMERGENCY_SHARE_OUTLINED = 0x109AB
    EMERGENCY_SHARE_ROUNDED = 0x109AC
    EMERGENCY_SHARE_SHARP = 0x109AD
    EMERGENCY_SHARP = 0x109AE
    EMOJI_EMOTIONS = 0x109AF
    EMOJI_EMOTIONS_OUTLINED = 0x109B0
    EMOJI_EMOTIONS_ROUNDED = 0x109B1
    EMOJI_EMOTIONS_SHARP = 0x109B2
    EMOJI_EVENTS = 0x109B3
    EMOJI_EVENTS_OUTLINED = 0x109B4
    EMOJI_EVENTS_ROUNDED = 0x109B5
    EMOJI_EVENTS_SHARP = 0x109B6
    EMOJI_FLAGS = 0x109B7
    EMOJI_FLAGS_OUTLINED = 0x109B8
    EMOJI_FLAGS_ROUNDED = 0x109B9
    EMOJI_FLAGS_SHARP = 0x109BA
    EMOJI_FOOD_BEVERAGE = 0x109BB
    EMOJI_FOOD_BEVERAGE_OUTLINED = 0x109BC
    EMOJI_FOOD_BEVERAGE_ROUNDED = 0x109BD
    EMOJI_FOOD_BEVERAGE_SHARP = 0x109BE
    EMOJI_NATURE = 0x109BF
    EMOJI_NATURE_OUTLINED = 0x109C0
    EMOJI_NATURE_ROUNDED = 0x109C1
    EMOJI_NATURE_SHARP = 0x109C2
    EMOJI_OBJECTS = 0x109C3
    EMOJI_OBJECTS_OUTLINED = 0x109C4
    EMOJI_OBJECTS_ROUNDED = 0x109C5
    EMOJI_OBJECTS_SHARP = 0x109C6
    EMOJI_PEOPLE = 0x109C7
    EMOJI_PEOPLE_OUTLINED = 0x109C8
    EMOJI_PEOPLE_ROUNDED = 0x109C9
    EMOJI_PEOPLE_SHARP = 0x109CA
    EMOJI_SYMBOLS = 0x109CB
    EMOJI_SYMBOLS_OUTLINED = 0x109CC
    EMOJI_SYMBOLS_ROUNDED = 0x109CD
    EMOJI_SYMBOLS_SHARP = 0x109CE
    EMOJI_TRANSPORTATION = 0x109CF
    EMOJI_TRANSPORTATION_OUTLINED = 0x109D0
    EMOJI_TRANSPORTATION_ROUNDED = 0x109D1
    EMOJI_TRANSPORTATION_SHARP = 0x109D2
    ENERGY_SAVINGS_LEAF = 0x109D3
    ENERGY_SAVINGS_LEAF_OUTLINED = 0x109D4
    ENERGY_SAVINGS_LEAF_ROUNDED = 0x109D5
    ENERGY_SAVINGS_LEAF_SHARP = 0x109D6
    ENGINEERING = 0x109D7
    ENGINEERING_OUTLINED = 0x109D8
    ENGINEERING_ROUNDED = 0x109D9
    ENGINEERING_SHARP = 0x109DA
    ENHANCE_PHOTO_TRANSLATE = 0x109DB
    ENHANCE_PHOTO_TRANSLATE_OUTLINED = 0x109DC
    ENHANCE_PHOTO_TRANSLATE_ROUNDED = 0x109DD
    ENHANCE_PHOTO_TRANSLATE_SHARP = 0x109DE
    ENHANCED_ENCRYPTION = 0x109DF
    ENHANCED_ENCRYPTION_OUTLINED = 0x109E0
    ENHANCED_ENCRYPTION_ROUNDED = 0x109E1
    ENHANCED_ENCRYPTION_SHARP = 0x109E2
    EQUALIZER = 0x109E3
    EQUALIZER_OUTLINED = 0x109E4
    EQUALIZER_ROUNDED = 0x109E5
    EQUALIZER_SHARP = 0x109E6
    ERROR = 0x109E7
    ERROR_OUTLINE = 0x109E8
    ERROR_OUTLINE_OUTLINED = 0x109E9
    ERROR_OUTLINE_ROUNDED = 0x109EA
    ERROR_OUTLINE_SHARP = 0x109EB
    ERROR_OUTLINED = 0x109EC
    ERROR_ROUNDED = 0x109ED
    ERROR_SHARP = 0x109EE
    ESCALATOR = 0x109EF
    ESCALATOR_OUTLINED = 0x109F0
    ESCALATOR_ROUNDED = 0x109F1
    ESCALATOR_SHARP = 0x109F2
    ESCALATOR_WARNING = 0x109F3
    ESCALATOR_WARNING_OUTLINED = 0x109F4
    ESCALATOR_WARNING_ROUNDED = 0x109F5
    ESCALATOR_WARNING_SHARP = 0x109F6
    EURO = 0x109F7
    EURO_OUTLINED = 0x109F8
    EURO_ROUNDED = 0x109F9
    EURO_SHARP = 0x109FA
    EURO_SYMBOL = 0x109FB
    EURO_SYMBOL_OUTLINED = 0x109FC
    EURO_SYMBOL_ROUNDED = 0x109FD
    EURO_SYMBOL_SHARP = 0x109FE
    EV_STATION = 0x109FF
    EV_STATION_OUTLINED = 0x10A00
    EV_STATION_ROUNDED = 0x10A01
    EV_STATION_SHARP = 0x10A02
    EVENT = 0x10A03
    EVENT_AVAILABLE = 0x10A04
    EVENT_AVAILABLE_OUTLINED = 0x10A05
    EVENT_AVAILABLE_ROUNDED = 0x10A06
    EVENT_AVAILABLE_SHARP = 0x10A07
    EVENT_BUSY = 0x10A08
    EVENT_BUSY_OUTLINED = 0x10A09
    EVENT_BUSY_ROUNDED = 0x10A0A
    EVENT_BUSY_SHARP = 0x10A0B
    EVENT_NOTE = 0x10A0C
    EVENT_NOTE_OUTLINED = 0x10A0D
    EVENT_NOTE_ROUNDED = 0x10A0E
    EVENT_NOTE_SHARP = 0x10A0F
    EVENT_OUTLINED = 0x10A10
    EVENT_REPEAT = 0x10A11
    EVENT_REPEAT_OUTLINED = 0x10A12
    EVENT_REPEAT_ROUNDED = 0x10A13
    EVENT_REPEAT_SHARP = 0x10A14
    EVENT_ROUNDED = 0x10A15
    EVENT_SEAT = 0x10A16
    EVENT_SEAT_OUTLINED = 0x10A17
    EVENT_SEAT_ROUNDED = 0x10A18
    EVENT_SEAT_SHARP = 0x10A19
    EVENT_SHARP = 0x10A1A
    EXIT_TO_APP = 0x10A1B
    EXIT_TO_APP_OUTLINED = 0x10A1C
    EXIT_TO_APP_ROUNDED = 0x10A1D
    EXIT_TO_APP_SHARP = 0x10A1E
    EXPAND = 0x10A1F
    EXPAND_CIRCLE_DOWN = 0x10A20
    EXPAND_CIRCLE_DOWN_OUTLINED = 0x10A21
    EXPAND_CIRCLE_DOWN_ROUNDED = 0x10A22
    EXPAND_CIRCLE_DOWN_SHARP = 0x10A23
    EXPAND_LESS = 0x10A24
    EXPAND_LESS_OUTLINED = 0x10A25
    EXPAND_LESS_ROUNDED = 0x10A26
    EXPAND_LESS_SHARP = 0x10A27
    EXPAND_MORE = 0x10A28
    EXPAND_MORE_OUTLINED = 0x10A29
    EXPAND_MORE_ROUNDED = 0x10A2A
    EXPAND_MORE_SHARP = 0x10A2B
    EXPAND_OUTLINED = 0x10A2C
    EXPAND_ROUNDED = 0x10A2D
    EXPAND_SHARP = 0x10A2E
    EXPLICIT = 0x10A2F
    EXPLICIT_OUTLINED = 0x10A30
    EXPLICIT_ROUNDED = 0x10A31
    EXPLICIT_SHARP = 0x10A32
    EXPLORE = 0x10A33
    EXPLORE_OFF = 0x10A34
    EXPLORE_OFF_OUTLINED = 0x10A35
    EXPLORE_OFF_ROUNDED = 0x10A36
    EXPLORE_OFF_SHARP = 0x10A37
    EXPLORE_OUTLINED = 0x10A38
    EXPLORE_ROUNDED = 0x10A39
    EXPLORE_SHARP = 0x10A3A
    EXPOSURE = 0x10A3B
    EXPOSURE_MINUS_1 = 0x10A3C
    EXPOSURE_MINUS_1_OUTLINED = 0x10A3D
    EXPOSURE_MINUS_1_ROUNDED = 0x10A3E
    EXPOSURE_MINUS_1_SHARP = 0x10A3F
    EXPOSURE_MINUS_2 = 0x10A40
    EXPOSURE_MINUS_2_OUTLINED = 0x10A41
    EXPOSURE_MINUS_2_ROUNDED = 0x10A42
    EXPOSURE_MINUS_2_SHARP = 0x10A43
    EXPOSURE_NEG_1 = 0x10A44
    EXPOSURE_NEG_1_OUTLINED = 0x10A45
    EXPOSURE_NEG_1_ROUNDED = 0x10A46
    EXPOSURE_NEG_1_SHARP = 0x10A47
    EXPOSURE_NEG_2 = 0x10A48
    EXPOSURE_NEG_2_OUTLINED = 0x10A49
    EXPOSURE_NEG_2_ROUNDED = 0x10A4A
    EXPOSURE_NEG_2_SHARP = 0x10A4B
    EXPOSURE_OUTLINED = 0x10A4C
    EXPOSURE_PLUS_1 = 0x10A4D
    EXPOSURE_PLUS_1_OUTLINED = 0x10A4E
    EXPOSURE_PLUS_1_ROUNDED = 0x10A4F
    EXPOSURE_PLUS_1_SHARP = 0x10A50
    EXPOSURE_PLUS_2 = 0x10A51
    EXPOSURE_PLUS_2_OUTLINED = 0x10A52
    EXPOSURE_PLUS_2_ROUNDED = 0x10A53
    EXPOSURE_PLUS_2_SHARP = 0x10A54
    EXPOSURE_ROUNDED = 0x10A55
    EXPOSURE_SHARP = 0x10A56
    EXPOSURE_ZERO = 0x10A57
    EXPOSURE_ZERO_OUTLINED = 0x10A58
    EXPOSURE_ZERO_ROUNDED = 0x10A59
    EXPOSURE_ZERO_SHARP = 0x10A5A
    EXTENSION = 0x10A5B
    EXTENSION_OFF = 0x10A5C
    EXTENSION_OFF_OUTLINED = 0x10A5D
    EXTENSION_OFF_ROUNDED = 0x10A5E
    EXTENSION_OFF_SHARP = 0x10A5F
    EXTENSION_OUTLINED = 0x10A60
    EXTENSION_ROUNDED = 0x10A61
    EXTENSION_SHARP = 0x10A62
    FACE = 0x10A63
    FACE_2 = 0x10A64
    FACE_2_OUTLINED = 0x10A65
    FACE_2_ROUNDED = 0x10A66
    FACE_2_SHARP = 0x10A67
    FACE_3 = 0x10A68
    FACE_3_OUTLINED = 0x10A69
    FACE_3_ROUNDED = 0x10A6A
    FACE_3_SHARP = 0x10A6B
    FACE_4 = 0x10A6C
    FACE_4_OUTLINED = 0x10A6D
    FACE_4_ROUNDED = 0x10A6E
    FACE_4_SHARP = 0x10A6F
    FACE_5 = 0x10A70
    FACE_5_OUTLINED = 0x10A71
    FACE_5_ROUNDED = 0x10A72
    FACE_5_SHARP = 0x10A73
    FACE_6 = 0x10A74
    FACE_6_OUTLINED = 0x10A75
    FACE_6_ROUNDED = 0x10A76
    FACE_6_SHARP = 0x10A77
    FACE_OUTLINED = 0x10A78
    FACE_RETOUCHING_NATURAL = 0x10A79
    FACE_RETOUCHING_NATURAL_OUTLINED = 0x10A7A
    FACE_RETOUCHING_NATURAL_ROUNDED = 0x10A7B
    FACE_RETOUCHING_NATURAL_SHARP = 0x10A7C
    FACE_RETOUCHING_OFF = 0x10A7D
    FACE_RETOUCHING_OFF_OUTLINED = 0x10A7E
    FACE_RETOUCHING_OFF_ROUNDED = 0x10A7F
    FACE_RETOUCHING_OFF_SHARP = 0x10A80
    FACE_ROUNDED = 0x10A81
    FACE_SHARP = 0x10A82
    FACE_UNLOCK_OUTLINED = 0x10A83
    FACE_UNLOCK_ROUNDED = 0x10A84
    FACE_UNLOCK_SHARP = 0x10A85
    FACEBOOK = 0x10A86
    FACEBOOK_OUTLINED = 0x10A87
    FACEBOOK_ROUNDED = 0x10A88
    FACEBOOK_SHARP = 0x10A89
    FACT_CHECK = 0x10A8A
    FACT_CHECK_OUTLINED = 0x10A8B
    FACT_CHECK_ROUNDED = 0x10A8C
    FACT_CHECK_SHARP = 0x10A8D
    FACTORY = 0x10A8E
    FACTORY_OUTLINED = 0x10A8F
    FACTORY_ROUNDED = 0x10A90
    FACTORY_SHARP = 0x10A91
    FAMILY_RESTROOM = 0x10A92
    FAMILY_RESTROOM_OUTLINED = 0x10A93
    FAMILY_RESTROOM_ROUNDED = 0x10A94
    FAMILY_RESTROOM_SHARP = 0x10A95
    FAST_FORWARD = 0x10A96
    FAST_FORWARD_OUTLINED = 0x10A97
    FAST_FORWARD_ROUNDED = 0x10A98
    FAST_FORWARD_SHARP = 0x10A99
    FAST_REWIND = 0x10A9A
    FAST_REWIND_OUTLINED = 0x10A9B
    FAST_REWIND_ROUNDED = 0x10A9C
    FAST_REWIND_SHARP = 0x10A9D
    FASTFOOD = 0x10A9E
    FASTFOOD_OUTLINED = 0x10A9F
    FASTFOOD_ROUNDED = 0x10AA0
    FASTFOOD_SHARP = 0x10AA1
    FAVORITE = 0x10AA2
    FAVORITE_BORDER = 0x10AA3
    FAVORITE_BORDER_OUTLINED = 0x10AA4
    FAVORITE_BORDER_ROUNDED = 0x10AA5
    FAVORITE_BORDER_SHARP = 0x10AA6
    FAVORITE_OUTLINE = 0x10AA7
    FAVORITE_OUTLINE_OUTLINED = 0x10AA8
    FAVORITE_OUTLINE_ROUNDED = 0x10AA9
    FAVORITE_OUTLINE_SHARP = 0x10AAA
    FAVORITE_OUTLINED = 0x10AAB
    FAVORITE_ROUNDED = 0x10AAC
    FAVORITE_SHARP = 0x10AAD
    FAX = 0x10AAE
    FAX_OUTLINED = 0x10AAF
    FAX_ROUNDED = 0x10AB0
    FAX_SHARP = 0x10AB1
    FEATURED_PLAY_LIST = 0x10AB2
    FEATURED_PLAY_LIST_OUTLINED = 0x10AB3
    FEATURED_PLAY_LIST_ROUNDED = 0x10AB4
    FEATURED_PLAY_LIST_SHARP = 0x10AB5
    FEATURED_VIDEO = 0x10AB6
    FEATURED_VIDEO_OUTLINED = 0x10AB7
    FEATURED_VIDEO_ROUNDED = 0x10AB8
    FEATURED_VIDEO_SHARP = 0x10AB9
    FEED = 0x10ABA
    FEED_OUTLINED = 0x10ABB
    FEED_ROUNDED = 0x10ABC
    FEED_SHARP = 0x10ABD
    FEEDBACK = 0x10ABE
    FEEDBACK_OUTLINED = 0x10ABF
    FEEDBACK_ROUNDED = 0x10AC0
    FEEDBACK_SHARP = 0x10AC1
    FEMALE = 0x10AC2
    FEMALE_OUTLINED = 0x10AC3
    FEMALE_ROUNDED = 0x10AC4
    FEMALE_SHARP = 0x10AC5
    FENCE = 0x10AC6
    FENCE_OUTLINED = 0x10AC7
    FENCE_ROUNDED = 0x10AC8
    FENCE_SHARP = 0x10AC9
    FESTIVAL = 0x10ACA
    FESTIVAL_OUTLINED = 0x10ACB
    FESTIVAL_ROUNDED = 0x10ACC
    FESTIVAL_SHARP = 0x10ACD
    FIBER_DVR = 0x10ACE
    FIBER_DVR_OUTLINED = 0x10ACF
    FIBER_DVR_ROUNDED = 0x10AD0
    FIBER_DVR_SHARP = 0x10AD1
    FIBER_MANUAL_RECORD = 0x10AD2
    FIBER_MANUAL_RECORD_OUTLINED = 0x10AD3
    FIBER_MANUAL_RECORD_ROUNDED = 0x10AD4
    FIBER_MANUAL_RECORD_SHARP = 0x10AD5
    FIBER_NEW = 0x10AD6
    FIBER_NEW_OUTLINED = 0x10AD7
    FIBER_NEW_ROUNDED = 0x10AD8
    FIBER_NEW_SHARP = 0x10AD9
    FIBER_PIN = 0x10ADA
    FIBER_PIN_OUTLINED = 0x10ADB
    FIBER_PIN_ROUNDED = 0x10ADC
    FIBER_PIN_SHARP = 0x10ADD
    FIBER_SMART_RECORD = 0x10ADE
    FIBER_SMART_RECORD_OUTLINED = 0x10ADF
    FIBER_SMART_RECORD_ROUNDED = 0x10AE0
    FIBER_SMART_RECORD_SHARP = 0x10AE1
    FIFTEEN_MP = 0x10AE2
    FIFTEEN_MP_OUTLINED = 0x10AE3
    FIFTEEN_MP_ROUNDED = 0x10AE4
    FIFTEEN_MP_SHARP = 0x10AE5
    FILE_COPY = 0x10AE6
    FILE_COPY_OUTLINED = 0x10AE7
    FILE_COPY_ROUNDED = 0x10AE8
    FILE_COPY_SHARP = 0x10AE9
    FILE_DOWNLOAD = 0x10AEA
    FILE_DOWNLOAD_DONE = 0x10AEB
    FILE_DOWNLOAD_DONE_OUTLINED = 0x10AEC
    FILE_DOWNLOAD_DONE_ROUNDED = 0x10AED
    FILE_DOWNLOAD_DONE_SHARP = 0x10AEE
    FILE_DOWNLOAD_OFF = 0x10AEF
    FILE_DOWNLOAD_OFF_OUTLINED = 0x10AF0
    FILE_DOWNLOAD_OFF_ROUNDED = 0x10AF1
    FILE_DOWNLOAD_OFF_SHARP = 0x10AF2
    FILE_DOWNLOAD_OUTLINED = 0x10AF3
    FILE_DOWNLOAD_ROUNDED = 0x10AF4
    FILE_DOWNLOAD_SHARP = 0x10AF5
    FILE_OPEN = 0x10AF6
    FILE_OPEN_OUTLINED = 0x10AF7
    FILE_OPEN_ROUNDED = 0x10AF8
    FILE_OPEN_SHARP = 0x10AF9
    FILE_PRESENT = 0x10AFA
    FILE_PRESENT_OUTLINED = 0x10AFB
    FILE_PRESENT_ROUNDED = 0x10AFC
    FILE_PRESENT_SHARP = 0x10AFD
    FILE_UPLOAD = 0x10AFE
    FILE_UPLOAD_OFF = 0x10AFF
    FILE_UPLOAD_OUTLINED = 0x10B00
    FILE_UPLOAD_ROUNDED = 0x10B01
    FILE_UPLOAD_SHARP = 0x10B02
    FILTER = 0x10B03
    FILTER_1 = 0x10B04
    FILTER_1_OUTLINED = 0x10B05
    FILTER_1_ROUNDED = 0x10B06
    FILTER_1_SHARP = 0x10B07
    FILTER_2 = 0x10B08
    FILTER_2_OUTLINED = 0x10B09
    FILTER_2_ROUNDED = 0x10B0A
    FILTER_2_SHARP = 0x10B0B
    FILTER_3 = 0x10B0C
    FILTER_3_OUTLINED = 0x10B0D
    FILTER_3_ROUNDED = 0x10B0E
    FILTER_3_SHARP = 0x10B0F
    FILTER_4 = 0x10B10
    FILTER_4_OUTLINED = 0x10B11
    FILTER_4_ROUNDED = 0x10B12
    FILTER_4_SHARP = 0x10B13
    FILTER_5 = 0x10B14
    FILTER_5_OUTLINED = 0x10B15
    FILTER_5_ROUNDED = 0x10B16
    FILTER_5_SHARP = 0x10B17
    FILTER_6 = 0x10B18
    FILTER_6_OUTLINED = 0x10B19
    FILTER_6_ROUNDED = 0x10B1A
    FILTER_6_SHARP = 0x10B1B
    FILTER_7 = 0x10B1C
    FILTER_7_OUTLINED = 0x10B1D
    FILTER_7_ROUNDED = 0x10B1E
    FILTER_7_SHARP = 0x10B1F
    FILTER_8 = 0x10B20
    FILTER_8_OUTLINED = 0x10B21
    FILTER_8_ROUNDED = 0x10B22
    FILTER_8_SHARP = 0x10B23
    FILTER_9 = 0x10B24
    FILTER_9_OUTLINED = 0x10B25
    FILTER_9_PLUS = 0x10B26
    FILTER_9_PLUS_OUTLINED = 0x10B27
    FILTER_9_PLUS_ROUNDED = 0x10B28
    FILTER_9_PLUS_SHARP = 0x10B29
    FILTER_9_ROUNDED = 0x10B2A
    FILTER_9_SHARP = 0x10B2B
    FILTER_ALT = 0x10B2C
    FILTER_ALT_OFF = 0x10B2D
    FILTER_ALT_OFF_OUTLINED = 0x10B2E
    FILTER_ALT_OFF_ROUNDED = 0x10B2F
    FILTER_ALT_OFF_SHARP = 0x10B30
    FILTER_ALT_OUTLINED = 0x10B31
    FILTER_ALT_ROUNDED = 0x10B32
    FILTER_ALT_SHARP = 0x10B33
    FILTER_B_AND_W = 0x10B34
    FILTER_B_AND_W_OUTLINED = 0x10B35
    FILTER_B_AND_W_ROUNDED = 0x10B36
    FILTER_B_AND_W_SHARP = 0x10B37
    FILTER_CENTER_FOCUS = 0x10B38
    FILTER_CENTER_FOCUS_OUTLINED = 0x10B39
    FILTER_CENTER_FOCUS_ROUNDED = 0x10B3A
    FILTER_CENTER_FOCUS_SHARP = 0x10B3B
    FILTER_DRAMA = 0x10B3C
    FILTER_DRAMA_OUTLINED = 0x10B3D
    FILTER_DRAMA_ROUNDED = 0x10B3E
    FILTER_DRAMA_SHARP = 0x10B3F
    FILTER_FRAMES = 0x10B40
    FILTER_FRAMES_OUTLINED = 0x10B41
    FILTER_FRAMES_ROUNDED = 0x10B42
    FILTER_FRAMES_SHARP = 0x10B43
    FILTER_HDR = 0x10B44
    FILTER_HDR_OUTLINED = 0x10B45
    FILTER_HDR_ROUNDED = 0x10B46
    FILTER_HDR_SHARP = 0x10B47
    FILTER_LIST = 0x10B48
    FILTER_LIST_ALT = 0x10B49
    FILTER_LIST_OFF = 0x10B4A
    FILTER_LIST_OFF_OUTLINED = 0x10B4B
    FILTER_LIST_OFF_ROUNDED = 0x10B4C
    FILTER_LIST_OFF_SHARP = 0x10B4D
    FILTER_LIST_OUTLINED = 0x10B4E
    FILTER_LIST_ROUNDED = 0x10B4F
    FILTER_LIST_SHARP = 0x10B50
    FILTER_NONE = 0x10B51
    FILTER_NONE_OUTLINED = 0x10B52
    FILTER_NONE_ROUNDED = 0x10B53
    FILTER_NONE_SHARP = 0x10B54
    FILTER_OUTLINED = 0x10B55
    FILTER_ROUNDED = 0x10B56
    FILTER_SHARP = 0x10B57
    FILTER_TILT_SHIFT = 0x10B58
    FILTER_TILT_SHIFT_OUTLINED = 0x10B59
    FILTER_TILT_SHIFT_ROUNDED = 0x10B5A
    FILTER_TILT_SHIFT_SHARP = 0x10B5B
    FILTER_VINTAGE = 0x10B5C
    FILTER_VINTAGE_OUTLINED = 0x10B5D
    FILTER_VINTAGE_ROUNDED = 0x10B5E
    FILTER_VINTAGE_SHARP = 0x10B5F
    FIND_IN_PAGE = 0x10B60
    FIND_IN_PAGE_OUTLINED = 0x10B61
    FIND_IN_PAGE_ROUNDED = 0x10B62
    FIND_IN_PAGE_SHARP = 0x10B63
    FIND_REPLACE = 0x10B64
    FIND_REPLACE_OUTLINED = 0x10B65
    FIND_REPLACE_ROUNDED = 0x10B66
    FIND_REPLACE_SHARP = 0x10B67
    FINGERPRINT = 0x10B68
    FINGERPRINT_OUTLINED = 0x10B69
    FINGERPRINT_ROUNDED = 0x10B6A
    FINGERPRINT_SHARP = 0x10B6B
    FIRE_EXTINGUISHER = 0x10B6C
    FIRE_EXTINGUISHER_OUTLINED = 0x10B6D
    FIRE_EXTINGUISHER_ROUNDED = 0x10B6E
    FIRE_EXTINGUISHER_SHARP = 0x10B6F
    FIRE_HYDRANT = 0x10B70
    FIRE_HYDRANT_ALT = 0x10B71
    FIRE_HYDRANT_ALT_OUTLINED = 0x10B72
    FIRE_HYDRANT_ALT_ROUNDED = 0x10B73
    FIRE_HYDRANT_ALT_SHARP = 0x10B74
    FIRE_TRUCK = 0x10B75
    FIRE_TRUCK_OUTLINED = 0x10B76
    FIRE_TRUCK_ROUNDED = 0x10B77
    FIRE_TRUCK_SHARP = 0x10B78
    FIREPLACE = 0x10B79
    FIREPLACE_OUTLINED = 0x10B7A
    FIREPLACE_ROUNDED = 0x10B7B
    FIREPLACE_SHARP = 0x10B7C
    FIRST_PAGE = 0x10B7D
    FIRST_PAGE_OUTLINED = 0x10B7E
    FIRST_PAGE_ROUNDED = 0x10B7F
    FIRST_PAGE_SHARP = 0x10B80
    FIT_SCREEN = 0x10B81
    FIT_SCREEN_OUTLINED = 0x10B82
    FIT_SCREEN_ROUNDED = 0x10B83
    FIT_SCREEN_SHARP = 0x10B84
    FITBIT = 0x10B85
    FITBIT_OUTLINED = 0x10B86
    FITBIT_ROUNDED = 0x10B87
    FITBIT_SHARP = 0x10B88
    FITNESS_CENTER = 0x10B89
    FITNESS_CENTER_OUTLINED = 0x10B8A
    FITNESS_CENTER_ROUNDED = 0x10B8B
    FITNESS_CENTER_SHARP = 0x10B8C
    FIVE_G = 0x10B8D
    FIVE_G_OUTLINED = 0x10B8E
    FIVE_G_ROUNDED = 0x10B8F
    FIVE_G_SHARP = 0x10B90
    FIVE_K = 0x10B91
    FIVE_K_OUTLINED = 0x10B92
    FIVE_K_PLUS = 0x10B93
    FIVE_K_PLUS_OUTLINED = 0x10B94
    FIVE_K_PLUS_ROUNDED = 0x10B95
    FIVE_K_PLUS_SHARP = 0x10B96
    FIVE_K_ROUNDED = 0x10B97
    FIVE_K_SHARP = 0x10B98
    FIVE_MP = 0x10B99
    FIVE_MP_OUTLINED = 0x10B9A
    FIVE_MP_ROUNDED = 0x10B9B
    FIVE_MP_SHARP = 0x10B9C
    FLAG = 0x10B9D
    FLAG_CIRCLE = 0x10B9E
    FLAG_CIRCLE_OUTLINED = 0x10B9F
    FLAG_CIRCLE_ROUNDED = 0x10BA0
    FLAG_CIRCLE_SHARP = 0x10BA1
    FLAG_OUTLINED = 0x10BA2
    FLAG_ROUNDED = 0x10BA3
    FLAG_SHARP = 0x10BA4
    FLAKY = 0x10BA5
    FLAKY_OUTLINED = 0x10BA6
    FLAKY_ROUNDED = 0x10BA7
    FLAKY_SHARP = 0x10BA8
    FLARE = 0x10BA9
    FLARE_OUTLINED = 0x10BAA
    FLARE_ROUNDED = 0x10BAB
    FLARE_SHARP = 0x10BAC
    FLASH_AUTO = 0x10BAD
    FLASH_AUTO_OUTLINED = 0x10BAE
    FLASH_AUTO_ROUNDED = 0x10BAF
    FLASH_AUTO_SHARP = 0x10BB0
    FLASH_OFF = 0x10BB1
    FLASH_OFF_OUTLINED = 0x10BB2
    FLASH_OFF_ROUNDED = 0x10BB3
    FLASH_OFF_SHARP = 0x10BB4
    FLASH_ON = 0x10BB5
    FLASH_ON_OUTLINED = 0x10BB6
    FLASH_ON_ROUNDED = 0x10BB7
    FLASH_ON_SHARP = 0x10BB8
    FLASHLIGHT_OFF = 0x10BB9
    FLASHLIGHT_OFF_OUTLINED = 0x10BBA
    FLASHLIGHT_OFF_ROUNDED = 0x10BBB
    FLASHLIGHT_OFF_SHARP = 0x10BBC
    FLASHLIGHT_ON = 0x10BBD
    FLASHLIGHT_ON_OUTLINED = 0x10BBE
    FLASHLIGHT_ON_ROUNDED = 0x10BBF
    FLASHLIGHT_ON_SHARP = 0x10BC0
    FLATWARE = 0x10BC1
    FLATWARE_OUTLINED = 0x10BC2
    FLATWARE_ROUNDED = 0x10BC3
    FLATWARE_SHARP = 0x10BC4
    FLIGHT = 0x10BC5
    FLIGHT_CLASS = 0x10BC6
    FLIGHT_CLASS_OUTLINED = 0x10BC7
    FLIGHT_CLASS_ROUNDED = 0x10BC8
    FLIGHT_CLASS_SHARP = 0x10BC9
    FLIGHT_LAND = 0x10BCA
    FLIGHT_LAND_OUTLINED = 0x10BCB
    FLIGHT_LAND_ROUNDED = 0x10BCC
    FLIGHT_LAND_SHARP = 0x10BCD
    FLIGHT_OUTLINED = 0x10BCE
    FLIGHT_ROUNDED = 0x10BCF
    FLIGHT_SHARP = 0x10BD0
    FLIGHT_TAKEOFF = 0x10BD1
    FLIGHT_TAKEOFF_OUTLINED = 0x10BD2
    FLIGHT_TAKEOFF_ROUNDED = 0x10BD3
    FLIGHT_TAKEOFF_SHARP = 0x10BD4
    FLIP = 0x10BD5
    FLIP_CAMERA_ANDROID = 0x10BD6
    FLIP_CAMERA_ANDROID_OUTLINED = 0x10BD7
    FLIP_CAMERA_ANDROID_ROUNDED = 0x10BD8
    FLIP_CAMERA_ANDROID_SHARP = 0x10BD9
    FLIP_CAMERA_IOS = 0x10BDA
    FLIP_CAMERA_IOS_OUTLINED = 0x10BDB
    FLIP_CAMERA_IOS_ROUNDED = 0x10BDC
    FLIP_CAMERA_IOS_SHARP = 0x10BDD
    FLIP_OUTLINED = 0x10BDE
    FLIP_ROUNDED = 0x10BDF
    FLIP_SHARP = 0x10BE0
    FLIP_TO_BACK = 0x10BE1
    FLIP_TO_BACK_OUTLINED = 0x10BE2
    FLIP_TO_BACK_ROUNDED = 0x10BE3
    FLIP_TO_BACK_SHARP = 0x10BE4
    FLIP_TO_FRONT = 0x10BE5
    FLIP_TO_FRONT_OUTLINED = 0x10BE6
    FLIP_TO_FRONT_ROUNDED = 0x10BE7
    FLIP_TO_FRONT_SHARP = 0x10BE8
    FLOOD = 0x10BE9
    FLOOD_OUTLINED = 0x10BEA
    FLOOD_ROUNDED = 0x10BEB
    FLOOD_SHARP = 0x10BEC
    FLOURESCENT = 0x10BED
    FLOURESCENT_OUTLINED = 0x10BEE
    FLOURESCENT_ROUNDED = 0x10BEF
    FLOURESCENT_SHARP = 0x10BF0
    FLUORESCENT = 0x10BF1
    FLUORESCENT_OUTLINED = 0x10BF2
    FLUORESCENT_ROUNDED = 0x10BF3
    FLUORESCENT_SHARP = 0x10BF4
    FLUTTER_DASH = 0x10BF5
    FLUTTER_DASH_OUTLINED = 0x10BF6
    FLUTTER_DASH_ROUNDED = 0x10BF7
    FLUTTER_DASH_SHARP = 0x10BF8
    FMD_BAD = 0x10BF9
    FMD_BAD_OUTLINED = 0x10BFA
    FMD_BAD_ROUNDED = 0x10BFB
    FMD_BAD_SHARP = 0x10BFC
    FMD_GOOD = 0x10BFD
    FMD_GOOD_OUTLINED = 0x10BFE
    FMD_GOOD_ROUNDED = 0x10BFF
    FMD_GOOD_SHARP = 0x10C00
    FOGGY = 0x10C01
    FOLDER = 0x10C02
    FOLDER_COPY = 0x10C03
    FOLDER_COPY_OUTLINED = 0x10C04
    FOLDER_COPY_ROUNDED = 0x10C05
    FOLDER_COPY_SHARP = 0x10C06
    FOLDER_DELETE = 0x10C07
    FOLDER_DELETE_OUTLINED = 0x10C08
    FOLDER_DELETE_ROUNDED = 0x10C09
    FOLDER_DELETE_SHARP = 0x10C0A
    FOLDER_OFF = 0x10C0B
    FOLDER_OFF_OUTLINED = 0x10C0C
    FOLDER_OFF_ROUNDED = 0x10C0D
    FOLDER_OFF_SHARP = 0x10C0E
    FOLDER_OPEN = 0x10C0F
    FOLDER_OPEN_OUTLINED = 0x10C10
    FOLDER_OPEN_ROUNDED = 0x10C11
    FOLDER_OPEN_SHARP = 0x10C12
    FOLDER_OUTLINED = 0x10C13
    FOLDER_ROUNDED = 0x10C14
    FOLDER_SHARED = 0x10C15
    FOLDER_SHARED_OUTLINED = 0x10C16
    FOLDER_SHARED_ROUNDED = 0x10C17
    FOLDER_SHARED_SHARP = 0x10C18
    FOLDER_SHARP = 0x10C19
    FOLDER_SPECIAL = 0x10C1A
    FOLDER_SPECIAL_OUTLINED = 0x10C1B
    FOLDER_SPECIAL_ROUNDED = 0x10C1C
    FOLDER_SPECIAL_SHARP = 0x10C1D
    FOLDER_ZIP = 0x10C1E
    FOLDER_ZIP_OUTLINED = 0x10C1F
    FOLDER_ZIP_ROUNDED = 0x10C20
    FOLDER_ZIP_SHARP = 0x10C21
    FOLLOW_THE_SIGNS = 0x10C22
    FOLLOW_THE_SIGNS_OUTLINED = 0x10C23
    FOLLOW_THE_SIGNS_ROUNDED = 0x10C24
    FOLLOW_THE_SIGNS_SHARP = 0x10C25
    FONT_DOWNLOAD = 0x10C26
    FONT_DOWNLOAD_OFF = 0x10C27
    FONT_DOWNLOAD_OFF_OUTLINED = 0x10C28
    FONT_DOWNLOAD_OFF_ROUNDED = 0x10C29
    FONT_DOWNLOAD_OFF_SHARP = 0x10C2A
    FONT_DOWNLOAD_OUTLINED = 0x10C2B
    FONT_DOWNLOAD_ROUNDED = 0x10C2C
    FONT_DOWNLOAD_SHARP = 0x10C2D
    FOOD_BANK = 0x10C2E
    FOOD_BANK_OUTLINED = 0x10C2F
    FOOD_BANK_ROUNDED = 0x10C30
    FOOD_BANK_SHARP = 0x10C31
    FOREST = 0x10C32
    FOREST_OUTLINED = 0x10C33
    FOREST_ROUNDED = 0x10C34
    FOREST_SHARP = 0x10C35
    FORK_LEFT = 0x10C36
    FORK_LEFT_OUTLINED = 0x10C37
    FORK_LEFT_ROUNDED = 0x10C38
    FORK_LEFT_SHARP = 0x10C39
    FORK_RIGHT = 0x10C3A
    FORK_RIGHT_OUTLINED = 0x10C3B
    FORK_RIGHT_ROUNDED = 0x10C3C
    FORK_RIGHT_SHARP = 0x10C3D
    FORKLIFT = 0x10C3E
    FORMAT_ALIGN_CENTER = 0x10C3F
    FORMAT_ALIGN_CENTER_OUTLINED = 0x10C40
    FORMAT_ALIGN_CENTER_ROUNDED = 0x10C41
    FORMAT_ALIGN_CENTER_SHARP = 0x10C42
    FORMAT_ALIGN_JUSTIFY = 0x10C43
    FORMAT_ALIGN_JUSTIFY_OUTLINED = 0x10C44
    FORMAT_ALIGN_JUSTIFY_ROUNDED = 0x10C45
    FORMAT_ALIGN_JUSTIFY_SHARP = 0x10C46
    FORMAT_ALIGN_LEFT = 0x10C47
    FORMAT_ALIGN_LEFT_OUTLINED = 0x10C48
    FORMAT_ALIGN_LEFT_ROUNDED = 0x10C49
    FORMAT_ALIGN_LEFT_SHARP = 0x10C4A
    FORMAT_ALIGN_RIGHT = 0x10C4B
    FORMAT_ALIGN_RIGHT_OUTLINED = 0x10C4C
    FORMAT_ALIGN_RIGHT_ROUNDED = 0x10C4D
    FORMAT_ALIGN_RIGHT_SHARP = 0x10C4E
    FORMAT_BOLD = 0x10C4F
    FORMAT_BOLD_OUTLINED = 0x10C50
    FORMAT_BOLD_ROUNDED = 0x10C51
    FORMAT_BOLD_SHARP = 0x10C52
    FORMAT_CLEAR = 0x10C53
    FORMAT_CLEAR_OUTLINED = 0x10C54
    FORMAT_CLEAR_ROUNDED = 0x10C55
    FORMAT_CLEAR_SHARP = 0x10C56
    FORMAT_COLOR_FILL = 0x10C57
    FORMAT_COLOR_FILL_OUTLINED = 0x10C58
    FORMAT_COLOR_FILL_ROUNDED = 0x10C59
    FORMAT_COLOR_FILL_SHARP = 0x10C5A
    FORMAT_COLOR_RESET = 0x10C5B
    FORMAT_COLOR_RESET_OUTLINED = 0x10C5C
    FORMAT_COLOR_RESET_ROUNDED = 0x10C5D
    FORMAT_COLOR_RESET_SHARP = 0x10C5E
    FORMAT_COLOR_TEXT = 0x10C5F
    FORMAT_COLOR_TEXT_OUTLINED = 0x10C60
    FORMAT_COLOR_TEXT_ROUNDED = 0x10C61
    FORMAT_COLOR_TEXT_SHARP = 0x10C62
    FORMAT_INDENT_DECREASE = 0x10C63
    FORMAT_INDENT_DECREASE_OUTLINED = 0x10C64
    FORMAT_INDENT_DECREASE_ROUNDED = 0x10C65
    FORMAT_INDENT_DECREASE_SHARP = 0x10C66
    FORMAT_INDENT_INCREASE = 0x10C67
    FORMAT_INDENT_INCREASE_OUTLINED = 0x10C68
    FORMAT_INDENT_INCREASE_ROUNDED = 0x10C69
    FORMAT_INDENT_INCREASE_SHARP = 0x10C6A
    FORMAT_ITALIC = 0x10C6B
    FORMAT_ITALIC_OUTLINED = 0x10C6C
    FORMAT_ITALIC_ROUNDED = 0x10C6D
    FORMAT_ITALIC_SHARP = 0x10C6E
    FORMAT_LINE_SPACING = 0x10C6F
    FORMAT_LINE_SPACING_OUTLINED = 0x10C70
    FORMAT_LINE_SPACING_ROUNDED = 0x10C71
    FORMAT_LINE_SPACING_SHARP = 0x10C72
    FORMAT_LIST_BULLETED = 0x10C73
    FORMAT_LIST_BULLETED_ADD = 0x10C74
    FORMAT_LIST_BULLETED_OUTLINED = 0x10C75
    FORMAT_LIST_BULLETED_ROUNDED = 0x10C76
    FORMAT_LIST_BULLETED_SHARP = 0x10C77
    FORMAT_LIST_NUMBERED = 0x10C78
    FORMAT_LIST_NUMBERED_OUTLINED = 0x10C79
    FORMAT_LIST_NUMBERED_ROUNDED = 0x10C7A
    FORMAT_LIST_NUMBERED_RTL = 0x10C7B
    FORMAT_LIST_NUMBERED_RTL_OUTLINED = 0x10C7C
    FORMAT_LIST_NUMBERED_RTL_ROUNDED = 0x10C7D
    FORMAT_LIST_NUMBERED_RTL_SHARP = 0x10C7E
    FORMAT_LIST_NUMBERED_SHARP = 0x10C7F
    FORMAT_OVERLINE = 0x10C80
    FORMAT_OVERLINE_OUTLINED = 0x10C81
    FORMAT_OVERLINE_ROUNDED = 0x10C82
    FORMAT_OVERLINE_SHARP = 0x10C83
    FORMAT_PAINT = 0x10C84
    FORMAT_PAINT_OUTLINED = 0x10C85
    FORMAT_PAINT_ROUNDED = 0x10C86
    FORMAT_PAINT_SHARP = 0x10C87
    FORMAT_QUOTE = 0x10C88
    FORMAT_QUOTE_OUTLINED = 0x10C89
    FORMAT_QUOTE_ROUNDED = 0x10C8A
    FORMAT_QUOTE_SHARP = 0x10C8B
    FORMAT_SHAPES = 0x10C8C
    FORMAT_SHAPES_OUTLINED = 0x10C8D
    FORMAT_SHAPES_ROUNDED = 0x10C8E
    FORMAT_SHAPES_SHARP = 0x10C8F
    FORMAT_SIZE = 0x10C90
    FORMAT_SIZE_OUTLINED = 0x10C91
    FORMAT_SIZE_ROUNDED = 0x10C92
    FORMAT_SIZE_SHARP = 0x10C93
    FORMAT_STRIKETHROUGH = 0x10C94
    FORMAT_STRIKETHROUGH_OUTLINED = 0x10C95
    FORMAT_STRIKETHROUGH_ROUNDED = 0x10C96
    FORMAT_STRIKETHROUGH_SHARP = 0x10C97
    FORMAT_TEXTDIRECTION_L_TO_R = 0x10C98
    FORMAT_TEXTDIRECTION_L_TO_R_OUTLINED = 0x10C99
    FORMAT_TEXTDIRECTION_L_TO_R_ROUNDED = 0x10C9A
    FORMAT_TEXTDIRECTION_L_TO_R_SHARP = 0x10C9B
    FORMAT_TEXTDIRECTION_R_TO_L = 0x10C9C
    FORMAT_TEXTDIRECTION_R_TO_L_OUTLINED = 0x10C9D
    FORMAT_TEXTDIRECTION_R_TO_L_ROUNDED = 0x10C9E
    FORMAT_TEXTDIRECTION_R_TO_L_SHARP = 0x10C9F
    FORMAT_UNDERLINE = 0x10CA0
    FORMAT_UNDERLINE_OUTLINED = 0x10CA1
    FORMAT_UNDERLINE_ROUNDED = 0x10CA2
    FORMAT_UNDERLINE_SHARP = 0x10CA3
    FORMAT_UNDERLINED = 0x10CA4
    FORMAT_UNDERLINED_OUTLINED = 0x10CA5
    FORMAT_UNDERLINED_ROUNDED = 0x10CA6
    FORMAT_UNDERLINED_SHARP = 0x10CA7
    FORT = 0x10CA8
    FORT_OUTLINED = 0x10CA9
    FORT_ROUNDED = 0x10CAA
    FORT_SHARP = 0x10CAB
    FORUM = 0x10CAC
    FORUM_OUTLINED = 0x10CAD
    FORUM_ROUNDED = 0x10CAE
    FORUM_SHARP = 0x10CAF
    FORWARD = 0x10CB0
    FORWARD_10 = 0x10CB1
    FORWARD_10_OUTLINED = 0x10CB2
    FORWARD_10_ROUNDED = 0x10CB3
    FORWARD_10_SHARP = 0x10CB4
    FORWARD_30 = 0x10CB5
    FORWARD_30_OUTLINED = 0x10CB6
    FORWARD_30_ROUNDED = 0x10CB7
    FORWARD_30_SHARP = 0x10CB8
    FORWARD_5 = 0x10CB9
    FORWARD_5_OUTLINED = 0x10CBA
    FORWARD_5_ROUNDED = 0x10CBB
    FORWARD_5_SHARP = 0x10CBC
    FORWARD_OUTLINED = 0x10CBD
    FORWARD_ROUNDED = 0x10CBE
    FORWARD_SHARP = 0x10CBF
    FORWARD_TO_INBOX = 0x10CC0
    FORWARD_TO_INBOX_OUTLINED = 0x10CC1
    FORWARD_TO_INBOX_ROUNDED = 0x10CC2
    FORWARD_TO_INBOX_SHARP = 0x10CC3
    FOUNDATION = 0x10CC4
    FOUNDATION_OUTLINED = 0x10CC5
    FOUNDATION_ROUNDED = 0x10CC6
    FOUNDATION_SHARP = 0x10CC7
    FOUR_G_MOBILEDATA = 0x10CC8
    FOUR_G_MOBILEDATA_OUTLINED = 0x10CC9
    FOUR_G_MOBILEDATA_ROUNDED = 0x10CCA
    FOUR_G_MOBILEDATA_SHARP = 0x10CCB
    FOUR_G_PLUS_MOBILEDATA = 0x10CCC
    FOUR_G_PLUS_MOBILEDATA_OUTLINED = 0x10CCD
    FOUR_G_PLUS_MOBILEDATA_ROUNDED = 0x10CCE
    FOUR_G_PLUS_MOBILEDATA_SHARP = 0x10CCF
    FOUR_K = 0x10CD0
    FOUR_K_OUTLINED = 0x10CD1
    FOUR_K_PLUS = 0x10CD2
    FOUR_K_PLUS_OUTLINED = 0x10CD3
    FOUR_K_PLUS_ROUNDED = 0x10CD4
    FOUR_K_PLUS_SHARP = 0x10CD5
    FOUR_K_ROUNDED = 0x10CD6
    FOUR_K_SHARP = 0x10CD7
    FOUR_MP = 0x10CD8
    FOUR_MP_OUTLINED = 0x10CD9
    FOUR_MP_ROUNDED = 0x10CDA
    FOUR_MP_SHARP = 0x10CDB
    FOURTEEN_MP = 0x10CDC
    FOURTEEN_MP_OUTLINED = 0x10CDD
    FOURTEEN_MP_ROUNDED = 0x10CDE
    FOURTEEN_MP_SHARP = 0x10CDF
    FREE_BREAKFAST = 0x10CE0
    FREE_BREAKFAST_OUTLINED = 0x10CE1
    FREE_BREAKFAST_ROUNDED = 0x10CE2
    FREE_BREAKFAST_SHARP = 0x10CE3
    FREE_CANCELLATION = 0x10CE4
    FREE_CANCELLATION_OUTLINED = 0x10CE5
    FREE_CANCELLATION_ROUNDED = 0x10CE6
    FREE_CANCELLATION_SHARP = 0x10CE7
    FRONT_HAND = 0x10CE8
    FRONT_HAND_OUTLINED = 0x10CE9
    FRONT_HAND_ROUNDED = 0x10CEA
    FRONT_HAND_SHARP = 0x10CEB
    FRONT_LOADER = 0x10CEC
    FULLSCREEN = 0x10CED
    FULLSCREEN_EXIT = 0x10CEE
    FULLSCREEN_EXIT_OUTLINED = 0x10CEF
    FULLSCREEN_EXIT_ROUNDED = 0x10CF0
    FULLSCREEN_EXIT_SHARP = 0x10CF1
    FULLSCREEN_OUTLINED = 0x10CF2
    FULLSCREEN_ROUNDED = 0x10CF3
    FULLSCREEN_SHARP = 0x10CF4
    FUNCTIONS = 0x10CF5
    FUNCTIONS_OUTLINED = 0x10CF6
    FUNCTIONS_ROUNDED = 0x10CF7
    FUNCTIONS_SHARP = 0x10CF8
    G_MOBILEDATA = 0x10CF9
    G_MOBILEDATA_OUTLINED = 0x10CFA
    G_MOBILEDATA_ROUNDED = 0x10CFB
    G_MOBILEDATA_SHARP = 0x10CFC
    G_TRANSLATE = 0x10CFD
    G_TRANSLATE_OUTLINED = 0x10CFE
    G_TRANSLATE_ROUNDED = 0x10CFF
    G_TRANSLATE_SHARP = 0x10D00
    GAMEPAD = 0x10D01
    GAMEPAD_OUTLINED = 0x10D02
    GAMEPAD_ROUNDED = 0x10D03
    GAMEPAD_SHARP = 0x10D04
    GAMES = 0x10D05
    GAMES_OUTLINED = 0x10D06
    GAMES_ROUNDED = 0x10D07
    GAMES_SHARP = 0x10D08
    GARAGE = 0x10D09
    GARAGE_OUTLINED = 0x10D0A
    GARAGE_ROUNDED = 0x10D0B
    GARAGE_SHARP = 0x10D0C
    GAS_METER = 0x10D0D
    GAS_METER_OUTLINED = 0x10D0E
    GAS_METER_ROUNDED = 0x10D0F
    GAS_METER_SHARP = 0x10D10
    GAVEL = 0x10D11
    GAVEL_OUTLINED = 0x10D12
    GAVEL_ROUNDED = 0x10D13
    GAVEL_SHARP = 0x10D14
    GENERATING_TOKENS = 0x10D15
    GENERATING_TOKENS_OUTLINED = 0x10D16
    GENERATING_TOKENS_ROUNDED = 0x10D17
    GENERATING_TOKENS_SHARP = 0x10D18
    GESTURE = 0x10D19
    GESTURE_OUTLINED = 0x10D1A
    GESTURE_ROUNDED = 0x10D1B
    GESTURE_SHARP = 0x10D1C
    GET_APP = 0x10D1D
    GET_APP_OUTLINED = 0x10D1E
    GET_APP_ROUNDED = 0x10D1F
    GET_APP_SHARP = 0x10D20
    GIF = 0x10D21
    GIF_BOX = 0x10D22
    GIF_BOX_OUTLINED = 0x10D23
    GIF_BOX_ROUNDED = 0x10D24
    GIF_BOX_SHARP = 0x10D25
    GIF_OUTLINED = 0x10D26
    GIF_ROUNDED = 0x10D27
    GIF_SHARP = 0x10D28
    GIRL = 0x10D29
    GIRL_OUTLINED = 0x10D2A
    GIRL_ROUNDED = 0x10D2B
    GIRL_SHARP = 0x10D2C
    GITE = 0x10D2D
    GITE_OUTLINED = 0x10D2E
    GITE_ROUNDED = 0x10D2F
    GITE_SHARP = 0x10D30
    GOLF_COURSE = 0x10D31
    GOLF_COURSE_OUTLINED = 0x10D32
    GOLF_COURSE_ROUNDED = 0x10D33
    GOLF_COURSE_SHARP = 0x10D34
    GPP_BAD = 0x10D35
    GPP_BAD_OUTLINED = 0x10D36
    GPP_BAD_ROUNDED = 0x10D37
    GPP_BAD_SHARP = 0x10D38
    GPP_GOOD = 0x10D39
    GPP_GOOD_OUTLINED = 0x10D3A
    GPP_GOOD_ROUNDED = 0x10D3B
    GPP_GOOD_SHARP = 0x10D3C
    GPP_MAYBE = 0x10D3D
    GPP_MAYBE_OUTLINED = 0x10D3E
    GPP_MAYBE_ROUNDED = 0x10D3F
    GPP_MAYBE_SHARP = 0x10D40
    GPS_FIXED = 0x10D41
    GPS_FIXED_OUTLINED = 0x10D42
    GPS_FIXED_ROUNDED = 0x10D43
    GPS_FIXED_SHARP = 0x10D44
    GPS_NOT_FIXED = 0x10D45
    GPS_NOT_FIXED_OUTLINED = 0x10D46
    GPS_NOT_FIXED_ROUNDED = 0x10D47
    GPS_NOT_FIXED_SHARP = 0x10D48
    GPS_OFF = 0x10D49
    GPS_OFF_OUTLINED = 0x10D4A
    GPS_OFF_ROUNDED = 0x10D4B
    GPS_OFF_SHARP = 0x10D4C
    GRADE = 0x10D4D
    GRADE_OUTLINED = 0x10D4E
    GRADE_ROUNDED = 0x10D4F
    GRADE_SHARP = 0x10D50
    GRADIENT = 0x10D51
    GRADIENT_OUTLINED = 0x10D52
    GRADIENT_ROUNDED = 0x10D53
    GRADIENT_SHARP = 0x10D54
    GRADING = 0x10D55
    GRADING_OUTLINED = 0x10D56
    GRADING_ROUNDED = 0x10D57
    GRADING_SHARP = 0x10D58
    GRAIN = 0x10D59
    GRAIN_OUTLINED = 0x10D5A
    GRAIN_ROUNDED = 0x10D5B
    GRAIN_SHARP = 0x10D5C
    GRAPHIC_EQ = 0x10D5D
    GRAPHIC_EQ_OUTLINED = 0x10D5E
    GRAPHIC_EQ_ROUNDED = 0x10D5F
    GRAPHIC_EQ_SHARP = 0x10D60
    GRASS = 0x10D61
    GRASS_OUTLINED = 0x10D62
    GRASS_ROUNDED = 0x10D63
    GRASS_SHARP = 0x10D64
    GRID_3X3 = 0x10D65
    GRID_3X3_OUTLINED = 0x10D66
    GRID_3X3_ROUNDED = 0x10D67
    GRID_3X3_SHARP = 0x10D68
    GRID_4X4 = 0x10D69
    GRID_4X4_OUTLINED = 0x10D6A
    GRID_4X4_ROUNDED = 0x10D6B
    GRID_4X4_SHARP = 0x10D6C
    GRID_GOLDENRATIO = 0x10D6D
    GRID_GOLDENRATIO_OUTLINED = 0x10D6E
    GRID_GOLDENRATIO_ROUNDED = 0x10D6F
    GRID_GOLDENRATIO_SHARP = 0x10D70
    GRID_OFF = 0x10D71
    GRID_OFF_OUTLINED = 0x10D72
    GRID_OFF_ROUNDED = 0x10D73
    GRID_OFF_SHARP = 0x10D74
    GRID_ON = 0x10D75
    GRID_ON_OUTLINED = 0x10D76
    GRID_ON_ROUNDED = 0x10D77
    GRID_ON_SHARP = 0x10D78
    GRID_VIEW = 0x10D79
    GRID_VIEW_OUTLINED = 0x10D7A
    GRID_VIEW_ROUNDED = 0x10D7B
    GRID_VIEW_SHARP = 0x10D7C
    GROUP = 0x10D7D
    GROUP_ADD = 0x10D7E
    GROUP_ADD_OUTLINED = 0x10D7F
    GROUP_ADD_ROUNDED = 0x10D80
    GROUP_ADD_SHARP = 0x10D81
    GROUP_OFF = 0x10D82
    GROUP_OFF_OUTLINED = 0x10D83
    GROUP_OFF_ROUNDED = 0x10D84
    GROUP_OFF_SHARP = 0x10D85
    GROUP_OUTLINED = 0x10D86
    GROUP_REMOVE = 0x10D87
    GROUP_REMOVE_OUTLINED = 0x10D88
    GROUP_REMOVE_ROUNDED = 0x10D89
    GROUP_REMOVE_SHARP = 0x10D8A
    GROUP_ROUNDED = 0x10D8B
    GROUP_SHARP = 0x10D8C
    GROUP_WORK = 0x10D8D
    GROUP_WORK_OUTLINED = 0x10D8E
    GROUP_WORK_ROUNDED = 0x10D8F
    GROUP_WORK_SHARP = 0x10D90
    GROUPS = 0x10D91
    GROUPS_2 = 0x10D92
    GROUPS_2_OUTLINED = 0x10D93
    GROUPS_2_ROUNDED = 0x10D94
    GROUPS_2_SHARP = 0x10D95
    GROUPS_3 = 0x10D96
    GROUPS_3_OUTLINED = 0x10D97
    GROUPS_3_ROUNDED = 0x10D98
    GROUPS_3_SHARP = 0x10D99
    GROUPS_OUTLINED = 0x10D9A
    GROUPS_ROUNDED = 0x10D9B
    GROUPS_SHARP = 0x10D9C
    H_MOBILEDATA = 0x10D9D
    H_MOBILEDATA_OUTLINED = 0x10D9E
    H_MOBILEDATA_ROUNDED = 0x10D9F
    H_MOBILEDATA_SHARP = 0x10DA0
    H_PLUS_MOBILEDATA = 0x10DA1
    H_PLUS_MOBILEDATA_OUTLINED = 0x10DA2
    H_PLUS_MOBILEDATA_ROUNDED = 0x10DA3
    H_PLUS_MOBILEDATA_SHARP = 0x10DA4
    HAIL = 0x10DA5
    HAIL_OUTLINED = 0x10DA6
    HAIL_ROUNDED = 0x10DA7
    HAIL_SHARP = 0x10DA8
    HANDSHAKE = 0x10DA9
    HANDSHAKE_OUTLINED = 0x10DAA
    HANDSHAKE_ROUNDED = 0x10DAB
    HANDSHAKE_SHARP = 0x10DAC
    HANDYMAN = 0x10DAD
    HANDYMAN_OUTLINED = 0x10DAE
    HANDYMAN_ROUNDED = 0x10DAF
    HANDYMAN_SHARP = 0x10DB0
    HARDWARE = 0x10DB1
    HARDWARE_OUTLINED = 0x10DB2
    HARDWARE_ROUNDED = 0x10DB3
    HARDWARE_SHARP = 0x10DB4
    HD = 0x10DB5
    HD_OUTLINED = 0x10DB6
    HD_ROUNDED = 0x10DB7
    HD_SHARP = 0x10DB8
    HDR_AUTO = 0x10DB9
    HDR_AUTO_OUTLINED = 0x10DBA
    HDR_AUTO_ROUNDED = 0x10DBB
    HDR_AUTO_SELECT = 0x10DBC
    HDR_AUTO_SELECT_OUTLINED = 0x10DBD
    HDR_AUTO_SELECT_ROUNDED = 0x10DBE
    HDR_AUTO_SELECT_SHARP = 0x10DBF
    HDR_AUTO_SHARP = 0x10DC0
    HDR_ENHANCED_SELECT = 0x10DC1
    HDR_ENHANCED_SELECT_OUTLINED = 0x10DC2
    HDR_ENHANCED_SELECT_ROUNDED = 0x10DC3
    HDR_ENHANCED_SELECT_SHARP = 0x10DC4
    HDR_OFF = 0x10DC5
    HDR_OFF_OUTLINED = 0x10DC6
    HDR_OFF_ROUNDED = 0x10DC7
    HDR_OFF_SELECT = 0x10DC8
    HDR_OFF_SELECT_OUTLINED = 0x10DC9
    HDR_OFF_SELECT_ROUNDED = 0x10DCA
    HDR_OFF_SELECT_SHARP = 0x10DCB
    HDR_OFF_SHARP = 0x10DCC
    HDR_ON = 0x10DCD
    HDR_ON_OUTLINED = 0x10DCE
    HDR_ON_ROUNDED = 0x10DCF
    HDR_ON_SELECT = 0x10DD0
    HDR_ON_SELECT_OUTLINED = 0x10DD1
    HDR_ON_SELECT_ROUNDED = 0x10DD2
    HDR_ON_SELECT_SHARP = 0x10DD3
    HDR_ON_SHARP = 0x10DD4
    HDR_PLUS = 0x10DD5
    HDR_PLUS_OUTLINED = 0x10DD6
    HDR_PLUS_ROUNDED = 0x10DD7
    HDR_PLUS_SHARP = 0x10DD8
    HDR_STRONG = 0x10DD9
    HDR_STRONG_OUTLINED = 0x10DDA
    HDR_STRONG_ROUNDED = 0x10DDB
    HDR_STRONG_SHARP = 0x10DDC
    HDR_WEAK = 0x10DDD
    HDR_WEAK_OUTLINED = 0x10DDE
    HDR_WEAK_ROUNDED = 0x10DDF
    HDR_WEAK_SHARP = 0x10DE0
    HEADPHONES = 0x10DE1
    HEADPHONES_BATTERY = 0x10DE2
    HEADPHONES_BATTERY_OUTLINED = 0x10DE3
    HEADPHONES_BATTERY_ROUNDED = 0x10DE4
    HEADPHONES_BATTERY_SHARP = 0x10DE5
    HEADPHONES_OUTLINED = 0x10DE6
    HEADPHONES_ROUNDED = 0x10DE7
    HEADPHONES_SHARP = 0x10DE8
    HEADSET = 0x10DE9
    HEADSET_MIC = 0x10DEA
    HEADSET_MIC_OUTLINED = 0x10DEB
    HEADSET_MIC_ROUNDED = 0x10DEC
    HEADSET_MIC_SHARP = 0x10DED
    HEADSET_OFF = 0x10DEE
    HEADSET_OFF_OUTLINED = 0x10DEF
    HEADSET_OFF_ROUNDED = 0x10DF0
    HEADSET_OFF_SHARP = 0x10DF1
    HEADSET_OUTLINED = 0x10DF2
    HEADSET_ROUNDED = 0x10DF3
    HEADSET_SHARP = 0x10DF4
    HEALING = 0x10DF5
    HEALING_OUTLINED = 0x10DF6
    HEALING_ROUNDED = 0x10DF7
    HEALING_SHARP = 0x10DF8
    HEALTH_AND_SAFETY = 0x10DF9
    HEALTH_AND_SAFETY_OUTLINED = 0x10DFA
    HEALTH_AND_SAFETY_ROUNDED = 0x10DFB
    HEALTH_AND_SAFETY_SHARP = 0x10DFC
    HEARING = 0x10DFD
    HEARING_DISABLED = 0x10DFE
    HEARING_DISABLED_OUTLINED = 0x10DFF
    HEARING_DISABLED_ROUNDED = 0x10E00
    HEARING_DISABLED_SHARP = 0x10E01
    HEARING_OUTLINED = 0x10E02
    HEARING_ROUNDED = 0x10E03
    HEARING_SHARP = 0x10E04
    HEART_BROKEN = 0x10E05
    HEART_BROKEN_OUTLINED = 0x10E06
    HEART_BROKEN_ROUNDED = 0x10E07
    HEART_BROKEN_SHARP = 0x10E08
    HEAT_PUMP = 0x10E09
    HEAT_PUMP_OUTLINED = 0x10E0A
    HEAT_PUMP_ROUNDED = 0x10E0B
    HEAT_PUMP_SHARP = 0x10E0C
    HEIGHT = 0x10E0D
    HEIGHT_OUTLINED = 0x10E0E
    HEIGHT_ROUNDED = 0x10E0F
    HEIGHT_SHARP = 0x10E10
    HELP = 0x10E11
    HELP_CENTER = 0x10E12
    HELP_CENTER_OUTLINED = 0x10E13
    HELP_CENTER_ROUNDED = 0x10E14
    HELP_CENTER_SHARP = 0x10E15
    HELP_OUTLINE = 0x10E16
    HELP_OUTLINE_OUTLINED = 0x10E17
    HELP_OUTLINE_ROUNDED = 0x10E18
    HELP_OUTLINE_SHARP = 0x10E19
    HELP_OUTLINED = 0x10E1A
    HELP_ROUNDED = 0x10E1B
    HELP_SHARP = 0x10E1C
    HEVC = 0x10E1D
    HEVC_OUTLINED = 0x10E1E
    HEVC_ROUNDED = 0x10E1F
    HEVC_SHARP = 0x10E20
    HEXAGON = 0x10E21
    HEXAGON_OUTLINED = 0x10E22
    HEXAGON_ROUNDED = 0x10E23
    HEXAGON_SHARP = 0x10E24
    HIDE_IMAGE = 0x10E25
    HIDE_IMAGE_OUTLINED = 0x10E26
    HIDE_IMAGE_ROUNDED = 0x10E27
    HIDE_IMAGE_SHARP = 0x10E28
    HIDE_SOURCE = 0x10E29
    HIDE_SOURCE_OUTLINED = 0x10E2A
    HIDE_SOURCE_ROUNDED = 0x10E2B
    HIDE_SOURCE_SHARP = 0x10E2C
    HIGH_QUALITY = 0x10E2D
    HIGH_QUALITY_OUTLINED = 0x10E2E
    HIGH_QUALITY_ROUNDED = 0x10E2F
    HIGH_QUALITY_SHARP = 0x10E30
    HIGHLIGHT = 0x10E31
    HIGHLIGHT_ALT = 0x10E32
    HIGHLIGHT_ALT_OUTLINED = 0x10E33
    HIGHLIGHT_ALT_ROUNDED = 0x10E34
    HIGHLIGHT_ALT_SHARP = 0x10E35
    HIGHLIGHT_OFF = 0x10E36
    HIGHLIGHT_OFF_OUTLINED = 0x10E37
    HIGHLIGHT_OFF_ROUNDED = 0x10E38
    HIGHLIGHT_OFF_SHARP = 0x10E39
    HIGHLIGHT_OUTLINED = 0x10E3A
    HIGHLIGHT_REMOVE = 0x10E3B
    HIGHLIGHT_REMOVE_OUTLINED = 0x10E3C
    HIGHLIGHT_REMOVE_ROUNDED = 0x10E3D
    HIGHLIGHT_REMOVE_SHARP = 0x10E3E
    HIGHLIGHT_ROUNDED = 0x10E3F
    HIGHLIGHT_SHARP = 0x10E40
    HIKING = 0x10E41
    HIKING_OUTLINED = 0x10E42
    HIKING_ROUNDED = 0x10E43
    HIKING_SHARP = 0x10E44
    HISTORY = 0x10E45
    HISTORY_EDU = 0x10E46
    HISTORY_EDU_OUTLINED = 0x10E47
    HISTORY_EDU_ROUNDED = 0x10E48
    HISTORY_EDU_SHARP = 0x10E49
    HISTORY_OUTLINED = 0x10E4A
    HISTORY_ROUNDED = 0x10E4B
    HISTORY_SHARP = 0x10E4C
    HISTORY_TOGGLE_OFF = 0x10E4D
    HISTORY_TOGGLE_OFF_OUTLINED = 0x10E4E
    HISTORY_TOGGLE_OFF_ROUNDED = 0x10E4F
    HISTORY_TOGGLE_OFF_SHARP = 0x10E50
    HIVE = 0x10E51
    HIVE_OUTLINED = 0x10E52
    HIVE_ROUNDED = 0x10E53
    HIVE_SHARP = 0x10E54
    HLS = 0x10E55
    HLS_OFF = 0x10E56
    HLS_OFF_OUTLINED = 0x10E57
    HLS_OFF_ROUNDED = 0x10E58
    HLS_OFF_SHARP = 0x10E59
    HLS_OUTLINED = 0x10E5A
    HLS_ROUNDED = 0x10E5B
    HLS_SHARP = 0x10E5C
    HOLIDAY_VILLAGE = 0x10E5D
    HOLIDAY_VILLAGE_OUTLINED = 0x10E5E
    HOLIDAY_VILLAGE_ROUNDED = 0x10E5F
    HOLIDAY_VILLAGE_SHARP = 0x10E60
    HOME = 0x10E61
    HOME_FILLED = 0x10E62
    HOME_MAX = 0x10E63
    HOME_MAX_OUTLINED = 0x10E64
    HOME_MAX_ROUNDED = 0x10E65
    HOME_MAX_SHARP = 0x10E66
    HOME_MINI = 0x10E67
    HOME_MINI_OUTLINED = 0x10E68
    HOME_MINI_ROUNDED = 0x10E69
    HOME_MINI_SHARP = 0x10E6A
    HOME_OUTLINED = 0x10E6B
    HOME_REPAIR_SERVICE = 0x10E6C
    HOME_REPAIR_SERVICE_OUTLINED = 0x10E6D
    HOME_REPAIR_SERVICE_ROUNDED = 0x10E6E
    HOME_REPAIR_SERVICE_SHARP = 0x10E6F
    HOME_ROUNDED = 0x10E70
    HOME_SHARP = 0x10E71
    HOME_WORK = 0x10E72
    HOME_WORK_OUTLINED = 0x10E73
    HOME_WORK_ROUNDED = 0x10E74
    HOME_WORK_SHARP = 0x10E75
    HORIZONTAL_DISTRIBUTE = 0x10E76
    HORIZONTAL_DISTRIBUTE_OUTLINED = 0x10E77
    HORIZONTAL_DISTRIBUTE_ROUNDED = 0x10E78
    HORIZONTAL_DISTRIBUTE_SHARP = 0x10E79
    HORIZONTAL_RULE = 0x10E7A
    HORIZONTAL_RULE_OUTLINED = 0x10E7B
    HORIZONTAL_RULE_ROUNDED = 0x10E7C
    HORIZONTAL_RULE_SHARP = 0x10E7D
    HORIZONTAL_SPLIT = 0x10E7E
    HORIZONTAL_SPLIT_OUTLINED = 0x10E7F
    HORIZONTAL_SPLIT_ROUNDED = 0x10E80
    HORIZONTAL_SPLIT_SHARP = 0x10E81
    HOT_TUB = 0x10E82
    HOT_TUB_OUTLINED = 0x10E83
    HOT_TUB_ROUNDED = 0x10E84
    HOT_TUB_SHARP = 0x10E85
    HOTEL = 0x10E86
    HOTEL_CLASS = 0x10E87
    HOTEL_CLASS_OUTLINED = 0x10E88
    HOTEL_CLASS_ROUNDED = 0x10E89
    HOTEL_CLASS_SHARP = 0x10E8A
    HOTEL_OUTLINED = 0x10E8B
    HOTEL_ROUNDED = 0x10E8C
    HOTEL_SHARP = 0x10E8D
    HOURGLASS_BOTTOM = 0x10E8E
    HOURGLASS_BOTTOM_OUTLINED = 0x10E8F
    HOURGLASS_BOTTOM_ROUNDED = 0x10E90
    HOURGLASS_BOTTOM_SHARP = 0x10E91
    HOURGLASS_DISABLED = 0x10E92
    HOURGLASS_DISABLED_OUTLINED = 0x10E93
    HOURGLASS_DISABLED_ROUNDED = 0x10E94
    HOURGLASS_DISABLED_SHARP = 0x10E95
    HOURGLASS_EMPTY = 0x10E96
    HOURGLASS_EMPTY_OUTLINED = 0x10E97
    HOURGLASS_EMPTY_ROUNDED = 0x10E98
    HOURGLASS_EMPTY_SHARP = 0x10E99
    HOURGLASS_FULL = 0x10E9A
    HOURGLASS_FULL_OUTLINED = 0x10E9B
    HOURGLASS_FULL_ROUNDED = 0x10E9C
    HOURGLASS_FULL_SHARP = 0x10E9D
    HOURGLASS_TOP = 0x10E9E
    HOURGLASS_TOP_OUTLINED = 0x10E9F
    HOURGLASS_TOP_ROUNDED = 0x10EA0
    HOURGLASS_TOP_SHARP = 0x10EA1
    HOUSE = 0x10EA2
    HOUSE_OUTLINED = 0x10EA3
    HOUSE_ROUNDED = 0x10EA4
    HOUSE_SHARP = 0x10EA5
    HOUSE_SIDING = 0x10EA6
    HOUSE_SIDING_OUTLINED = 0x10EA7
    HOUSE_SIDING_ROUNDED = 0x10EA8
    HOUSE_SIDING_SHARP = 0x10EA9
    HOUSEBOAT = 0x10EAA
    HOUSEBOAT_OUTLINED = 0x10EAB
    HOUSEBOAT_ROUNDED = 0x10EAC
    HOUSEBOAT_SHARP = 0x10EAD
    HOW_TO_REG = 0x10EAE
    HOW_TO_REG_OUTLINED = 0x10EAF
    HOW_TO_REG_ROUNDED = 0x10EB0
    HOW_TO_REG_SHARP = 0x10EB1
    HOW_TO_VOTE = 0x10EB2
    HOW_TO_VOTE_OUTLINED = 0x10EB3
    HOW_TO_VOTE_ROUNDED = 0x10EB4
    HOW_TO_VOTE_SHARP = 0x10EB5
    HTML = 0x10EB6
    HTML_OUTLINED = 0x10EB7
    HTML_ROUNDED = 0x10EB8
    HTML_SHARP = 0x10EB9
    HTTP = 0x10EBA
    HTTP_OUTLINED = 0x10EBB
    HTTP_ROUNDED = 0x10EBC
    HTTP_SHARP = 0x10EBD
    HTTPS = 0x10EBE
    HTTPS_OUTLINED = 0x10EBF
    HTTPS_ROUNDED = 0x10EC0
    HTTPS_SHARP = 0x10EC1
    HUB = 0x10EC2
    HUB_OUTLINED = 0x10EC3
    HUB_ROUNDED = 0x10EC4
    HUB_SHARP = 0x10EC5
    HVAC = 0x10EC6
    HVAC_OUTLINED = 0x10EC7
    HVAC_ROUNDED = 0x10EC8
    HVAC_SHARP = 0x10EC9
    ICE_SKATING = 0x10ECA
    ICE_SKATING_OUTLINED = 0x10ECB
    ICE_SKATING_ROUNDED = 0x10ECC
    ICE_SKATING_SHARP = 0x10ECD
    ICECREAM = 0x10ECE
    ICECREAM_OUTLINED = 0x10ECF
    ICECREAM_ROUNDED = 0x10ED0
    ICECREAM_SHARP = 0x10ED1
    IMAGE = 0x10ED2
    IMAGE_ASPECT_RATIO = 0x10ED3
    IMAGE_ASPECT_RATIO_OUTLINED = 0x10ED4
    IMAGE_ASPECT_RATIO_ROUNDED = 0x10ED5
    IMAGE_ASPECT_RATIO_SHARP = 0x10ED6
    IMAGE_NOT_SUPPORTED = 0x10ED7
    IMAGE_NOT_SUPPORTED_OUTLINED = 0x10ED8
    IMAGE_NOT_SUPPORTED_ROUNDED = 0x10ED9
    IMAGE_NOT_SUPPORTED_SHARP = 0x10EDA
    IMAGE_OUTLINED = 0x10EDB
    IMAGE_ROUNDED = 0x10EDC
    IMAGE_SEARCH = 0x10EDD
    IMAGE_SEARCH_OUTLINED = 0x10EDE
    IMAGE_SEARCH_ROUNDED = 0x10EDF
    IMAGE_SEARCH_SHARP = 0x10EE0
    IMAGE_SHARP = 0x10EE1
    IMAGESEARCH_ROLLER = 0x10EE2
    IMAGESEARCH_ROLLER_OUTLINED = 0x10EE3
    IMAGESEARCH_ROLLER_ROUNDED = 0x10EE4
    IMAGESEARCH_ROLLER_SHARP = 0x10EE5
    IMPORT_CONTACTS = 0x10EE6
    IMPORT_CONTACTS_OUTLINED = 0x10EE7
    IMPORT_CONTACTS_ROUNDED = 0x10EE8
    IMPORT_CONTACTS_SHARP = 0x10EE9
    IMPORT_EXPORT = 0x10EEA
    IMPORT_EXPORT_OUTLINED = 0x10EEB
    IMPORT_EXPORT_ROUNDED = 0x10EEC
    IMPORT_EXPORT_SHARP = 0x10EED
    IMPORTANT_DEVICES = 0x10EEE
    IMPORTANT_DEVICES_OUTLINED = 0x10EEF
    IMPORTANT_DEVICES_ROUNDED = 0x10EF0
    IMPORTANT_DEVICES_SHARP = 0x10EF1
    INBOX = 0x10EF2
    INBOX_OUTLINED = 0x10EF3
    INBOX_ROUNDED = 0x10EF4
    INBOX_SHARP = 0x10EF5
    INCOMPLETE_CIRCLE = 0x10EF6
    INCOMPLETE_CIRCLE_OUTLINED = 0x10EF7
    INCOMPLETE_CIRCLE_ROUNDED = 0x10EF8
    INCOMPLETE_CIRCLE_SHARP = 0x10EF9
    INDETERMINATE_CHECK_BOX = 0x10EFA
    INDETERMINATE_CHECK_BOX_OUTLINED = 0x10EFB
    INDETERMINATE_CHECK_BOX_ROUNDED = 0x10EFC
    INDETERMINATE_CHECK_BOX_SHARP = 0x10EFD
    INFO = 0x10EFE
    INFO_OUTLINE = 0x10EFF
    INFO_OUTLINE_ROUNDED = 0x10F00
    INFO_OUTLINE_SHARP = 0x10F01
    INFO_OUTLINED = 0x10F02
    INFO_ROUNDED = 0x10F03
    INFO_SHARP = 0x10F04
    INPUT = 0x10F05
    INPUT_OUTLINED = 0x10F06
    INPUT_ROUNDED = 0x10F07
    INPUT_SHARP = 0x10F08
    INSERT_CHART = 0x10F09
    INSERT_CHART_OUTLINED = 0x10F0A
    INSERT_CHART_OUTLINED_OUTLINED = 0x10F0B
    INSERT_CHART_OUTLINED_ROUNDED = 0x10F0C
    INSERT_CHART_OUTLINED_SHARP = 0x10F0D
    INSERT_CHART_ROUNDED = 0x10F0E
    INSERT_CHART_SHARP = 0x10F0F
    INSERT_COMMENT = 0x10F10
    INSERT_COMMENT_OUTLINED = 0x10F11
    INSERT_COMMENT_ROUNDED = 0x10F12
    INSERT_COMMENT_SHARP = 0x10F13
    INSERT_DRIVE_FILE = 0x10F14
    INSERT_DRIVE_FILE_OUTLINED = 0x10F15
    INSERT_DRIVE_FILE_ROUNDED = 0x10F16
    INSERT_DRIVE_FILE_SHARP = 0x10F17
    INSERT_EMOTICON = 0x10F18
    INSERT_EMOTICON_OUTLINED = 0x10F19
    INSERT_EMOTICON_ROUNDED = 0x10F1A
    INSERT_EMOTICON_SHARP = 0x10F1B
    INSERT_INVITATION = 0x10F1C
    INSERT_INVITATION_OUTLINED = 0x10F1D
    INSERT_INVITATION_ROUNDED = 0x10F1E
    INSERT_INVITATION_SHARP = 0x10F1F
    INSERT_LINK = 0x10F20
    INSERT_LINK_OUTLINED = 0x10F21
    INSERT_LINK_ROUNDED = 0x10F22
    INSERT_LINK_SHARP = 0x10F23
    INSERT_PAGE_BREAK = 0x10F24
    INSERT_PAGE_BREAK_OUTLINED = 0x10F25
    INSERT_PAGE_BREAK_ROUNDED = 0x10F26
    INSERT_PAGE_BREAK_SHARP = 0x10F27
    INSERT_PHOTO = 0x10F28
    INSERT_PHOTO_OUTLINED = 0x10F29
    INSERT_PHOTO_ROUNDED = 0x10F2A
    INSERT_PHOTO_SHARP = 0x10F2B
    INSIGHTS = 0x10F2C
    INSIGHTS_OUTLINED = 0x10F2D
    INSIGHTS_ROUNDED = 0x10F2E
    INSIGHTS_SHARP = 0x10F2F
    INSTALL_DESKTOP = 0x10F30
    INSTALL_DESKTOP_OUTLINED = 0x10F31
    INSTALL_DESKTOP_ROUNDED = 0x10F32
    INSTALL_DESKTOP_SHARP = 0x10F33
    INSTALL_MOBILE = 0x10F34
    INSTALL_MOBILE_OUTLINED = 0x10F35
    INSTALL_MOBILE_ROUNDED = 0x10F36
    INSTALL_MOBILE_SHARP = 0x10F37
    INTEGRATION_INSTRUCTIONS = 0x10F38
    INTEGRATION_INSTRUCTIONS_OUTLINED = 0x10F39
    INTEGRATION_INSTRUCTIONS_ROUNDED = 0x10F3A
    INTEGRATION_INSTRUCTIONS_SHARP = 0x10F3B
    INTERESTS = 0x10F3C
    INTERESTS_OUTLINED = 0x10F3D
    INTERESTS_ROUNDED = 0x10F3E
    INTERESTS_SHARP = 0x10F3F
    INTERPRETER_MODE = 0x10F40
    INTERPRETER_MODE_OUTLINED = 0x10F41
    INTERPRETER_MODE_ROUNDED = 0x10F42
    INTERPRETER_MODE_SHARP = 0x10F43
    INVENTORY = 0x10F44
    INVENTORY_2 = 0x10F45
    INVENTORY_2_OUTLINED = 0x10F46
    INVENTORY_2_ROUNDED = 0x10F47
    INVENTORY_2_SHARP = 0x10F48
    INVENTORY_OUTLINED = 0x10F49
    INVENTORY_ROUNDED = 0x10F4A
    INVENTORY_SHARP = 0x10F4B
    INVERT_COLORS = 0x10F4C
    INVERT_COLORS_OFF = 0x10F4D
    INVERT_COLORS_OFF_OUTLINED = 0x10F4E
    INVERT_COLORS_OFF_ROUNDED = 0x10F4F
    INVERT_COLORS_OFF_SHARP = 0x10F50
    INVERT_COLORS_ON = 0x10F51
    INVERT_COLORS_ON_OUTLINED = 0x10F52
    INVERT_COLORS_ON_ROUNDED = 0x10F53
    INVERT_COLORS_ON_SHARP = 0x10F54
    INVERT_COLORS_OUTLINED = 0x10F55
    INVERT_COLORS_ROUNDED = 0x10F56
    INVERT_COLORS_SHARP = 0x10F57
    IOS_SHARE = 0x10F58
    IOS_SHARE_OUTLINED = 0x10F59
    IOS_SHARE_ROUNDED = 0x10F5A
    IOS_SHARE_SHARP = 0x10F5B
    IRON = 0x10F5C
    IRON_OUTLINED = 0x10F5D
    IRON_ROUNDED = 0x10F5E
    IRON_SHARP = 0x10F5F
    ISO = 0x10F60
    ISO_OUTLINED = 0x10F61
    ISO_ROUNDED = 0x10F62
    ISO_SHARP = 0x10F63
    JAVASCRIPT = 0x10F64
    JAVASCRIPT_OUTLINED = 0x10F65
    JAVASCRIPT_ROUNDED = 0x10F66
    JAVASCRIPT_SHARP = 0x10F67
    JOIN_FULL = 0x10F68
    JOIN_FULL_OUTLINED = 0x10F69
    JOIN_FULL_ROUNDED = 0x10F6A
    JOIN_FULL_SHARP = 0x10F6B
    JOIN_INNER = 0x10F6C
    JOIN_INNER_OUTLINED = 0x10F6D
    JOIN_INNER_ROUNDED = 0x10F6E
    JOIN_INNER_SHARP = 0x10F6F
    JOIN_LEFT = 0x10F70
    JOIN_LEFT_OUTLINED = 0x10F71
    JOIN_LEFT_ROUNDED = 0x10F72
    JOIN_LEFT_SHARP = 0x10F73
    JOIN_RIGHT = 0x10F74
    JOIN_RIGHT_OUTLINED = 0x10F75
    JOIN_RIGHT_ROUNDED = 0x10F76
    JOIN_RIGHT_SHARP = 0x10F77
    KAYAKING = 0x10F78
    KAYAKING_OUTLINED = 0x10F79
    KAYAKING_ROUNDED = 0x10F7A
    KAYAKING_SHARP = 0x10F7B
    KEBAB_DINING = 0x10F7C
    KEBAB_DINING_OUTLINED = 0x10F7D
    KEBAB_DINING_ROUNDED = 0x10F7E
    KEBAB_DINING_SHARP = 0x10F7F
    KEY = 0x10F80
    KEY_OFF = 0x10F81
    KEY_OFF_OUTLINED = 0x10F82
    KEY_OFF_ROUNDED = 0x10F83
    KEY_OFF_SHARP = 0x10F84
    KEY_OUTLINED = 0x10F85
    KEY_ROUNDED = 0x10F86
    KEY_SHARP = 0x10F87
    KEYBOARD = 0x10F88
    KEYBOARD_ALT = 0x10F89
    KEYBOARD_ALT_OUTLINED = 0x10F8A
    KEYBOARD_ALT_ROUNDED = 0x10F8B
    KEYBOARD_ALT_SHARP = 0x10F8C
    KEYBOARD_ARROW_DOWN = 0x10F8D
    KEYBOARD_ARROW_DOWN_OUTLINED = 0x10F8E
    KEYBOARD_ARROW_DOWN_ROUNDED = 0x10F8F
    KEYBOARD_ARROW_DOWN_SHARP = 0x10F90
    KEYBOARD_ARROW_LEFT = 0x10F91
    KEYBOARD_ARROW_LEFT_OUTLINED = 0x10F92
    KEYBOARD_ARROW_LEFT_ROUNDED = 0x10F93
    KEYBOARD_ARROW_LEFT_SHARP = 0x10F94
    KEYBOARD_ARROW_RIGHT = 0x10F95
    KEYBOARD_ARROW_RIGHT_OUTLINED = 0x10F96
    KEYBOARD_ARROW_RIGHT_ROUNDED = 0x10F97
    KEYBOARD_ARROW_RIGHT_SHARP = 0x10F98
    KEYBOARD_ARROW_UP = 0x10F99
    KEYBOARD_ARROW_UP_OUTLINED = 0x10F9A
    KEYBOARD_ARROW_UP_ROUNDED = 0x10F9B
    KEYBOARD_ARROW_UP_SHARP = 0x10F9C
    KEYBOARD_BACKSPACE = 0x10F9D
    KEYBOARD_BACKSPACE_OUTLINED = 0x10F9E
    KEYBOARD_BACKSPACE_ROUNDED = 0x10F9F
    KEYBOARD_BACKSPACE_SHARP = 0x10FA0
    KEYBOARD_CAPSLOCK = 0x10FA1
    KEYBOARD_CAPSLOCK_OUTLINED = 0x10FA2
    KEYBOARD_CAPSLOCK_ROUNDED = 0x10FA3
    KEYBOARD_CAPSLOCK_SHARP = 0x10FA4
    KEYBOARD_COMMAND_KEY = 0x10FA5
    KEYBOARD_COMMAND_KEY_OUTLINED = 0x10FA6
    KEYBOARD_COMMAND_KEY_ROUNDED = 0x10FA7
    KEYBOARD_COMMAND_KEY_SHARP = 0x10FA8
    KEYBOARD_CONTROL = 0x10FA9
    KEYBOARD_CONTROL_KEY = 0x10FAA
    KEYBOARD_CONTROL_KEY_OUTLINED = 0x10FAB
    KEYBOARD_CONTROL_KEY_ROUNDED = 0x10FAC
    KEYBOARD_CONTROL_KEY_SHARP = 0x10FAD
    KEYBOARD_CONTROL_OUTLINED = 0x10FAE
    KEYBOARD_CONTROL_ROUNDED = 0x10FAF
    KEYBOARD_CONTROL_SHARP = 0x10FB0
    KEYBOARD_DOUBLE_ARROW_DOWN = 0x10FB1
    KEYBOARD_DOUBLE_ARROW_DOWN_OUTLINED = 0x10FB2
    KEYBOARD_DOUBLE_ARROW_DOWN_ROUNDED = 0x10FB3
    KEYBOARD_DOUBLE_ARROW_DOWN_SHARP = 0x10FB4
    KEYBOARD_DOUBLE_ARROW_LEFT = 0x10FB5
    KEYBOARD_DOUBLE_ARROW_LEFT_OUTLINED = 0x10FB6
    KEYBOARD_DOUBLE_ARROW_LEFT_ROUNDED = 0x10FB7
    KEYBOARD_DOUBLE_ARROW_LEFT_SHARP = 0x10FB8
    KEYBOARD_DOUBLE_ARROW_RIGHT = 0x10FB9
    KEYBOARD_DOUBLE_ARROW_RIGHT_OUTLINED = 0x10FBA
    KEYBOARD_DOUBLE_ARROW_RIGHT_ROUNDED = 0x10FBB
    KEYBOARD_DOUBLE_ARROW_RIGHT_SHARP = 0x10FBC
    KEYBOARD_DOUBLE_ARROW_UP = 0x10FBD
    KEYBOARD_DOUBLE_ARROW_UP_OUTLINED = 0x10FBE
    KEYBOARD_DOUBLE_ARROW_UP_ROUNDED = 0x10FBF
    KEYBOARD_DOUBLE_ARROW_UP_SHARP = 0x10FC0
    KEYBOARD_HIDE = 0x10FC1
    KEYBOARD_HIDE_OUTLINED = 0x10FC2
    KEYBOARD_HIDE_ROUNDED = 0x10FC3
    KEYBOARD_HIDE_SHARP = 0x10FC4
    KEYBOARD_OPTION_KEY = 0x10FC5
    KEYBOARD_OPTION_KEY_OUTLINED = 0x10FC6
    KEYBOARD_OPTION_KEY_ROUNDED = 0x10FC7
    KEYBOARD_OPTION_KEY_SHARP = 0x10FC8
    KEYBOARD_OUTLINED = 0x10FC9
    KEYBOARD_RETURN = 0x10FCA
    KEYBOARD_RETURN_OUTLINED = 0x10FCB
    KEYBOARD_RETURN_ROUNDED = 0x10FCC
    KEYBOARD_RETURN_SHARP = 0x10FCD
    KEYBOARD_ROUNDED = 0x10FCE
    KEYBOARD_SHARP = 0x10FCF
    KEYBOARD_TAB = 0x10FD0
    KEYBOARD_TAB_OUTLINED = 0x10FD1
    KEYBOARD_TAB_ROUNDED = 0x10FD2
    KEYBOARD_TAB_SHARP = 0x10FD3
    KEYBOARD_VOICE = 0x10FD4
    KEYBOARD_VOICE_OUTLINED = 0x10FD5
    KEYBOARD_VOICE_ROUNDED = 0x10FD6
    KEYBOARD_VOICE_SHARP = 0x10FD7
    KING_BED = 0x10FD8
    KING_BED_OUTLINED = 0x10FD9
    KING_BED_ROUNDED = 0x10FDA
    KING_BED_SHARP = 0x10FDB
    KITCHEN = 0x10FDC
    KITCHEN_OUTLINED = 0x10FDD
    KITCHEN_ROUNDED = 0x10FDE
    KITCHEN_SHARP = 0x10FDF
    KITESURFING = 0x10FE0
    KITESURFING_OUTLINED = 0x10FE1
    KITESURFING_ROUNDED = 0x10FE2
    KITESURFING_SHARP = 0x10FE3
    LABEL = 0x10FE4
    LABEL_IMPORTANT = 0x10FE5
    LABEL_IMPORTANT_OUTLINE = 0x10FE6
    LABEL_IMPORTANT_OUTLINE_ROUNDED = 0x10FE7
    LABEL_IMPORTANT_OUTLINE_SHARP = 0x10FE8
    LABEL_IMPORTANT_OUTLINED = 0x10FE9
    LABEL_IMPORTANT_ROUNDED = 0x10FEA
    LABEL_IMPORTANT_SHARP = 0x10FEB
    LABEL_OFF = 0x10FEC
    LABEL_OFF_OUTLINED = 0x10FED
    LABEL_OFF_ROUNDED = 0x10FEE
    LABEL_OFF_SHARP = 0x10FEF
    LABEL_OUTLINE = 0x10FF0
    LABEL_OUTLINE_ROUNDED = 0x10FF1
    LABEL_OUTLINE_SHARP = 0x10FF2
    LABEL_OUTLINED = 0x10FF3
    LABEL_ROUNDED = 0x10FF4
    LABEL_SHARP = 0x10FF5
    LAN = 0x10FF6
    LAN_OUTLINED = 0x10FF7
    LAN_ROUNDED = 0x10FF8
    LAN_SHARP = 0x10FF9
    LANDSCAPE = 0x10FFA
    LANDSCAPE_OUTLINED = 0x10FFB
    LANDSCAPE_ROUNDED = 0x10FFC
    LANDSCAPE_SHARP = 0x10FFD
    LANDSLIDE = 0x10FFE
    LANDSLIDE_OUTLINED = 0x10FFF
    LANDSLIDE_ROUNDED = 0x11000
    LANDSLIDE_SHARP = 0x11001
    LANGUAGE = 0x11002
    LANGUAGE_OUTLINED = 0x11003
    LANGUAGE_ROUNDED = 0x11004
    LANGUAGE_SHARP = 0x11005
    LAPTOP = 0x11006
    LAPTOP_CHROMEBOOK = 0x11007
    LAPTOP_CHROMEBOOK_OUTLINED = 0x11008
    LAPTOP_CHROMEBOOK_ROUNDED = 0x11009
    LAPTOP_CHROMEBOOK_SHARP = 0x1100A
    LAPTOP_MAC = 0x1100B
    LAPTOP_MAC_OUTLINED = 0x1100C
    LAPTOP_MAC_ROUNDED = 0x1100D
    LAPTOP_MAC_SHARP = 0x1100E
    LAPTOP_OUTLINED = 0x1100F
    LAPTOP_ROUNDED = 0x11010
    LAPTOP_SHARP = 0x11011
    LAPTOP_WINDOWS = 0x11012
    LAPTOP_WINDOWS_OUTLINED = 0x11013
    LAPTOP_WINDOWS_ROUNDED = 0x11014
    LAPTOP_WINDOWS_SHARP = 0x11015
    LAST_PAGE = 0x11016
    LAST_PAGE_OUTLINED = 0x11017
    LAST_PAGE_ROUNDED = 0x11018
    LAST_PAGE_SHARP = 0x11019
    LAUNCH = 0x1101A
    LAUNCH_OUTLINED = 0x1101B
    LAUNCH_ROUNDED = 0x1101C
    LAUNCH_SHARP = 0x1101D
    LAYERS = 0x1101E
    LAYERS_CLEAR = 0x1101F
    LAYERS_CLEAR_OUTLINED = 0x11020
    LAYERS_CLEAR_ROUNDED = 0x11021
    LAYERS_CLEAR_SHARP = 0x11022
    LAYERS_OUTLINED = 0x11023
    LAYERS_ROUNDED = 0x11024
    LAYERS_SHARP = 0x11025
    LEADERBOARD = 0x11026
    LEADERBOARD_OUTLINED = 0x11027
    LEADERBOARD_ROUNDED = 0x11028
    LEADERBOARD_SHARP = 0x11029
    LEAK_ADD = 0x1102A
    LEAK_ADD_OUTLINED = 0x1102B
    LEAK_ADD_ROUNDED = 0x1102C
    LEAK_ADD_SHARP = 0x1102D
    LEAK_REMOVE = 0x1102E
    LEAK_REMOVE_OUTLINED = 0x1102F
    LEAK_REMOVE_ROUNDED = 0x11030
    LEAK_REMOVE_SHARP = 0x11031
    LEAVE_BAGS_AT_HOME = 0x11032
    LEAVE_BAGS_AT_HOME_OUTLINED = 0x11033
    LEAVE_BAGS_AT_HOME_ROUNDED = 0x11034
    LEAVE_BAGS_AT_HOME_SHARP = 0x11035
    LEGEND_TOGGLE = 0x11036
    LEGEND_TOGGLE_OUTLINED = 0x11037
    LEGEND_TOGGLE_ROUNDED = 0x11038
    LEGEND_TOGGLE_SHARP = 0x11039
    LENS = 0x1103A
    LENS_BLUR = 0x1103B
    LENS_BLUR_OUTLINED = 0x1103C
    LENS_BLUR_ROUNDED = 0x1103D
    LENS_BLUR_SHARP = 0x1103E
    LENS_OUTLINED = 0x1103F
    LENS_ROUNDED = 0x11040
    LENS_SHARP = 0x11041
    LIBRARY_ADD = 0x11042
    LIBRARY_ADD_CHECK = 0x11043
    LIBRARY_ADD_CHECK_OUTLINED = 0x11044
    LIBRARY_ADD_CHECK_ROUNDED = 0x11045
    LIBRARY_ADD_CHECK_SHARP = 0x11046
    LIBRARY_ADD_OUTLINED = 0x11047
    LIBRARY_ADD_ROUNDED = 0x11048
    LIBRARY_ADD_SHARP = 0x11049
    LIBRARY_BOOKS = 0x1104A
    LIBRARY_BOOKS_OUTLINED = 0x1104B
    LIBRARY_BOOKS_ROUNDED = 0x1104C
    LIBRARY_BOOKS_SHARP = 0x1104D
    LIBRARY_MUSIC = 0x1104E
    LIBRARY_MUSIC_OUTLINED = 0x1104F
    LIBRARY_MUSIC_ROUNDED = 0x11050
    LIBRARY_MUSIC_SHARP = 0x11051
    LIGHT = 0x11052
    LIGHT_MODE = 0x11053
    LIGHT_MODE_OUTLINED = 0x11054
    LIGHT_MODE_ROUNDED = 0x11055
    LIGHT_MODE_SHARP = 0x11056
    LIGHT_OUTLINED = 0x11057
    LIGHT_ROUNDED = 0x11058
    LIGHT_SHARP = 0x11059
    LIGHTBULB = 0x1105A
    LIGHTBULB_CIRCLE = 0x1105B
    LIGHTBULB_CIRCLE_OUTLINED = 0x1105C
    LIGHTBULB_CIRCLE_ROUNDED = 0x1105D
    LIGHTBULB_CIRCLE_SHARP = 0x1105E
    LIGHTBULB_OUTLINE = 0x1105F
    LIGHTBULB_OUTLINE_ROUNDED = 0x11060
    LIGHTBULB_OUTLINE_SHARP = 0x11061
    LIGHTBULB_OUTLINED = 0x11062
    LIGHTBULB_ROUNDED = 0x11063
    LIGHTBULB_SHARP = 0x11064
    LINE_AXIS = 0x11065
    LINE_AXIS_OUTLINED = 0x11066
    LINE_AXIS_ROUNDED = 0x11067
    LINE_AXIS_SHARP = 0x11068
    LINE_STYLE = 0x11069
    LINE_STYLE_OUTLINED = 0x1106A
    LINE_STYLE_ROUNDED = 0x1106B
    LINE_STYLE_SHARP = 0x1106C
    LINE_WEIGHT = 0x1106D
    LINE_WEIGHT_OUTLINED = 0x1106E
    LINE_WEIGHT_ROUNDED = 0x1106F
    LINE_WEIGHT_SHARP = 0x11070
    LINEAR_SCALE = 0x11071
    LINEAR_SCALE_OUTLINED = 0x11072
    LINEAR_SCALE_ROUNDED = 0x11073
    LINEAR_SCALE_SHARP = 0x11074
    LINK = 0x11075
    LINK_OFF = 0x11076
    LINK_OFF_OUTLINED = 0x11077
    LINK_OFF_ROUNDED = 0x11078
    LINK_OFF_SHARP = 0x11079
    LINK_OUTLINED = 0x1107A
    LINK_ROUNDED = 0x1107B
    LINK_SHARP = 0x1107C
    LINKED_CAMERA = 0x1107D
    LINKED_CAMERA_OUTLINED = 0x1107E
    LINKED_CAMERA_ROUNDED = 0x1107F
    LINKED_CAMERA_SHARP = 0x11080
    LIQUOR = 0x11081
    LIQUOR_OUTLINED = 0x11082
    LIQUOR_ROUNDED = 0x11083
    LIQUOR_SHARP = 0x11084
    LIST = 0x11085
    LIST_ALT = 0x11086
    LIST_ALT_OUTLINED = 0x11087
    LIST_ALT_ROUNDED = 0x11088
    LIST_ALT_SHARP = 0x11089
    LIST_OUTLINED = 0x1108A
    LIST_ROUNDED = 0x1108B
    LIST_SHARP = 0x1108C
    LIVE_HELP = 0x1108D
    LIVE_HELP_OUTLINED = 0x1108E
    LIVE_HELP_ROUNDED = 0x1108F
    LIVE_HELP_SHARP = 0x11090
    LIVE_TV = 0x11091
    LIVE_TV_OUTLINED = 0x11092
    LIVE_TV_ROUNDED = 0x11093
    LIVE_TV_SHARP = 0x11094
    LIVING = 0x11095
    LIVING_OUTLINED = 0x11096
    LIVING_ROUNDED = 0x11097
    LIVING_SHARP = 0x11098
    LOCAL_ACTIVITY = 0x11099
    LOCAL_ACTIVITY_OUTLINED = 0x1109A
    LOCAL_ACTIVITY_ROUNDED = 0x1109B
    LOCAL_ACTIVITY_SHARP = 0x1109C
    LOCAL_AIRPORT = 0x1109D
    LOCAL_AIRPORT_OUTLINED = 0x1109E
    LOCAL_AIRPORT_ROUNDED = 0x1109F
    LOCAL_AIRPORT_SHARP = 0x110A0
    LOCAL_ATM = 0x110A1
    LOCAL_ATM_OUTLINED = 0x110A2
    LOCAL_ATM_ROUNDED = 0x110A3
    LOCAL_ATM_SHARP = 0x110A4
    LOCAL_ATTRACTION = 0x110A5
    LOCAL_ATTRACTION_OUTLINED = 0x110A6
    LOCAL_ATTRACTION_ROUNDED = 0x110A7
    LOCAL_ATTRACTION_SHARP = 0x110A8
    LOCAL_BAR = 0x110A9
    LOCAL_BAR_OUTLINED = 0x110AA
    LOCAL_BAR_ROUNDED = 0x110AB
    LOCAL_BAR_SHARP = 0x110AC
    LOCAL_CAFE = 0x110AD
    LOCAL_CAFE_OUTLINED = 0x110AE
    LOCAL_CAFE_ROUNDED = 0x110AF
    LOCAL_CAFE_SHARP = 0x110B0
    LOCAL_CAR_WASH = 0x110B1
    LOCAL_CAR_WASH_OUTLINED = 0x110B2
    LOCAL_CAR_WASH_ROUNDED = 0x110B3
    LOCAL_CAR_WASH_SHARP = 0x110B4
    LOCAL_CONVENIENCE_STORE = 0x110B5
    LOCAL_CONVENIENCE_STORE_OUTLINED = 0x110B6
    LOCAL_CONVENIENCE_STORE_ROUNDED = 0x110B7
    LOCAL_CONVENIENCE_STORE_SHARP = 0x110B8
    LOCAL_DINING = 0x110B9
    LOCAL_DINING_OUTLINED = 0x110BA
    LOCAL_DINING_ROUNDED = 0x110BB
    LOCAL_DINING_SHARP = 0x110BC
    LOCAL_DRINK = 0x110BD
    LOCAL_DRINK_OUTLINED = 0x110BE
    LOCAL_DRINK_ROUNDED = 0x110BF
    LOCAL_DRINK_SHARP = 0x110C0
    LOCAL_FIRE_DEPARTMENT = 0x110C1
    LOCAL_FIRE_DEPARTMENT_OUTLINED = 0x110C2
    LOCAL_FIRE_DEPARTMENT_ROUNDED = 0x110C3
    LOCAL_FIRE_DEPARTMENT_SHARP = 0x110C4
    LOCAL_FLORIST = 0x110C5
    LOCAL_FLORIST_OUTLINED = 0x110C6
    LOCAL_FLORIST_ROUNDED = 0x110C7
    LOCAL_FLORIST_SHARP = 0x110C8
    LOCAL_GAS_STATION = 0x110C9
    LOCAL_GAS_STATION_OUTLINED = 0x110CA
    LOCAL_GAS_STATION_ROUNDED = 0x110CB
    LOCAL_GAS_STATION_SHARP = 0x110CC
    LOCAL_GROCERY_STORE = 0x110CD
    LOCAL_GROCERY_STORE_OUTLINED = 0x110CE
    LOCAL_GROCERY_STORE_ROUNDED = 0x110CF
    LOCAL_GROCERY_STORE_SHARP = 0x110D0
    LOCAL_HOSPITAL = 0x110D1
    LOCAL_HOSPITAL_OUTLINED = 0x110D2
    LOCAL_HOSPITAL_ROUNDED = 0x110D3
    LOCAL_HOSPITAL_SHARP = 0x110D4
    LOCAL_HOTEL = 0x110D5
    LOCAL_HOTEL_OUTLINED = 0x110D6
    LOCAL_HOTEL_ROUNDED = 0x110D7
    LOCAL_HOTEL_SHARP = 0x110D8
    LOCAL_LAUNDRY_SERVICE = 0x110D9
    LOCAL_LAUNDRY_SERVICE_OUTLINED = 0x110DA
    LOCAL_LAUNDRY_SERVICE_ROUNDED = 0x110DB
    LOCAL_LAUNDRY_SERVICE_SHARP = 0x110DC
    LOCAL_LIBRARY = 0x110DD
    LOCAL_LIBRARY_OUTLINED = 0x110DE
    LOCAL_LIBRARY_ROUNDED = 0x110DF
    LOCAL_LIBRARY_SHARP = 0x110E0
    LOCAL_MALL = 0x110E1
    LOCAL_MALL_OUTLINED = 0x110E2
    LOCAL_MALL_ROUNDED = 0x110E3
    LOCAL_MALL_SHARP = 0x110E4
    LOCAL_MOVIES = 0x110E5
    LOCAL_MOVIES_OUTLINED = 0x110E6
    LOCAL_MOVIES_ROUNDED = 0x110E7
    LOCAL_MOVIES_SHARP = 0x110E8
    LOCAL_OFFER = 0x110E9
    LOCAL_OFFER_OUTLINED = 0x110EA
    LOCAL_OFFER_ROUNDED = 0x110EB
    LOCAL_OFFER_SHARP = 0x110EC
    LOCAL_PARKING = 0x110ED
    LOCAL_PARKING_OUTLINED = 0x110EE
    LOCAL_PARKING_ROUNDED = 0x110EF
    LOCAL_PARKING_SHARP = 0x110F0
    LOCAL_PHARMACY = 0x110F1
    LOCAL_PHARMACY_OUTLINED = 0x110F2
    LOCAL_PHARMACY_ROUNDED = 0x110F3
    LOCAL_PHARMACY_SHARP = 0x110F4
    LOCAL_PHONE = 0x110F5
    LOCAL_PHONE_OUTLINED = 0x110F6
    LOCAL_PHONE_ROUNDED = 0x110F7
    LOCAL_PHONE_SHARP = 0x110F8
    LOCAL_PIZZA = 0x110F9
    LOCAL_PIZZA_OUTLINED = 0x110FA
    LOCAL_PIZZA_ROUNDED = 0x110FB
    LOCAL_PIZZA_SHARP = 0x110FC
    LOCAL_PLAY = 0x110FD
    LOCAL_PLAY_OUTLINED = 0x110FE
    LOCAL_PLAY_ROUNDED = 0x110FF
    LOCAL_PLAY_SHARP = 0x11100
    LOCAL_POLICE = 0x11101
    LOCAL_POLICE_OUTLINED = 0x11102
    LOCAL_POLICE_ROUNDED = 0x11103
    LOCAL_POLICE_SHARP = 0x11104
    LOCAL_POST_OFFICE = 0x11105
    LOCAL_POST_OFFICE_OUTLINED = 0x11106
    LOCAL_POST_OFFICE_ROUNDED = 0x11107
    LOCAL_POST_OFFICE_SHARP = 0x11108
    LOCAL_PRINT_SHOP = 0x11109
    LOCAL_PRINT_SHOP_OUTLINED = 0x1110A
    LOCAL_PRINT_SHOP_ROUNDED = 0x1110B
    LOCAL_PRINT_SHOP_SHARP = 0x1110C
    LOCAL_PRINTSHOP = 0x1110D
    LOCAL_PRINTSHOP_OUTLINED = 0x1110E
    LOCAL_PRINTSHOP_ROUNDED = 0x1110F
    LOCAL_PRINTSHOP_SHARP = 0x11110
    LOCAL_RESTAURANT = 0x11111
    LOCAL_RESTAURANT_OUTLINED = 0x11112
    LOCAL_RESTAURANT_ROUNDED = 0x11113
    LOCAL_RESTAURANT_SHARP = 0x11114
    LOCAL_SEE = 0x11115
    LOCAL_SEE_OUTLINED = 0x11116
    LOCAL_SEE_ROUNDED = 0x11117
    LOCAL_SEE_SHARP = 0x11118
    LOCAL_SHIPPING = 0x11119
    LOCAL_SHIPPING_OUTLINED = 0x1111A
    LOCAL_SHIPPING_ROUNDED = 0x1111B
    LOCAL_SHIPPING_SHARP = 0x1111C
    LOCAL_TAXI = 0x1111D
    LOCAL_TAXI_OUTLINED = 0x1111E
    LOCAL_TAXI_ROUNDED = 0x1111F
    LOCAL_TAXI_SHARP = 0x11120
    LOCATION_CITY = 0x11121
    LOCATION_CITY_OUTLINED = 0x11122
    LOCATION_CITY_ROUNDED = 0x11123
    LOCATION_CITY_SHARP = 0x11124
    LOCATION_DISABLED = 0x11125
    LOCATION_DISABLED_OUTLINED = 0x11126
    LOCATION_DISABLED_ROUNDED = 0x11127
    LOCATION_DISABLED_SHARP = 0x11128
    LOCATION_HISTORY = 0x11129
    LOCATION_HISTORY_OUTLINED = 0x1112A
    LOCATION_HISTORY_ROUNDED = 0x1112B
    LOCATION_HISTORY_SHARP = 0x1112C
    LOCATION_OFF = 0x1112D
    LOCATION_OFF_OUTLINED = 0x1112E
    LOCATION_OFF_ROUNDED = 0x1112F
    LOCATION_OFF_SHARP = 0x11130
    LOCATION_ON = 0x11131
    LOCATION_ON_OUTLINED = 0x11132
    LOCATION_ON_ROUNDED = 0x11133
    LOCATION_ON_SHARP = 0x11134
    LOCATION_PIN = 0x11135
    LOCATION_SEARCHING = 0x11136
    LOCATION_SEARCHING_OUTLINED = 0x11137
    LOCATION_SEARCHING_ROUNDED = 0x11138
    LOCATION_SEARCHING_SHARP = 0x11139
    LOCK = 0x1113A
    LOCK_CLOCK = 0x1113B
    LOCK_CLOCK_OUTLINED = 0x1113C
    LOCK_CLOCK_ROUNDED = 0x1113D
    LOCK_CLOCK_SHARP = 0x1113E
    LOCK_OPEN = 0x1113F
    LOCK_OPEN_OUTLINED = 0x11140
    LOCK_OPEN_ROUNDED = 0x11141
    LOCK_OPEN_SHARP = 0x11142
    LOCK_OUTLINE = 0x11143
    LOCK_OUTLINE_ROUNDED = 0x11144
    LOCK_OUTLINE_SHARP = 0x11145
    LOCK_OUTLINED = 0x11146
    LOCK_PERSON = 0x11147
    LOCK_PERSON_OUTLINED = 0x11148
    LOCK_PERSON_ROUNDED = 0x11149
    LOCK_PERSON_SHARP = 0x1114A
    LOCK_RESET = 0x1114B
    LOCK_RESET_OUTLINED = 0x1114C
    LOCK_RESET_ROUNDED = 0x1114D
    LOCK_RESET_SHARP = 0x1114E
    LOCK_ROUNDED = 0x1114F
    LOCK_SHARP = 0x11150
    LOGIN = 0x11151
    LOGIN_OUTLINED = 0x11152
    LOGIN_ROUNDED = 0x11153
    LOGIN_SHARP = 0x11154
    LOGO_DEV = 0x11155
    LOGO_DEV_OUTLINED = 0x11156
    LOGO_DEV_ROUNDED = 0x11157
    LOGO_DEV_SHARP = 0x11158
    LOGOUT = 0x11159
    LOGOUT_OUTLINED = 0x1115A
    LOGOUT_ROUNDED = 0x1115B
    LOGOUT_SHARP = 0x1115C
    LOOKS = 0x1115D
    LOOKS_3 = 0x1115E
    LOOKS_3_OUTLINED = 0x1115F
    LOOKS_3_ROUNDED = 0x11160
    LOOKS_3_SHARP = 0x11161
    LOOKS_4 = 0x11162
    LOOKS_4_OUTLINED = 0x11163
    LOOKS_4_ROUNDED = 0x11164
    LOOKS_4_SHARP = 0x11165
    LOOKS_5 = 0x11166
    LOOKS_5_OUTLINED = 0x11167
    LOOKS_5_ROUNDED = 0x11168
    LOOKS_5_SHARP = 0x11169
    LOOKS_6 = 0x1116A
    LOOKS_6_OUTLINED = 0x1116B
    LOOKS_6_ROUNDED = 0x1116C
    LOOKS_6_SHARP = 0x1116D
    LOOKS_ONE = 0x1116E
    LOOKS_ONE_OUTLINED = 0x1116F
    LOOKS_ONE_ROUNDED = 0x11170
    LOOKS_ONE_SHARP = 0x11171
    LOOKS_OUTLINED = 0x11172
    LOOKS_ROUNDED = 0x11173
    LOOKS_SHARP = 0x11174
    LOOKS_TWO = 0x11175
    LOOKS_TWO_OUTLINED = 0x11176
    LOOKS_TWO_ROUNDED = 0x11177
    LOOKS_TWO_SHARP = 0x11178
    LOOP = 0x11179
    LOOP_OUTLINED = 0x1117A
    LOOP_ROUNDED = 0x1117B
    LOOP_SHARP = 0x1117C
    LOUPE = 0x1117D
    LOUPE_OUTLINED = 0x1117E
    LOUPE_ROUNDED = 0x1117F
    LOUPE_SHARP = 0x11180
    LOW_PRIORITY = 0x11181
    LOW_PRIORITY_OUTLINED = 0x11182
    LOW_PRIORITY_ROUNDED = 0x11183
    LOW_PRIORITY_SHARP = 0x11184
    LOYALTY = 0x11185
    LOYALTY_OUTLINED = 0x11186
    LOYALTY_ROUNDED = 0x11187
    LOYALTY_SHARP = 0x11188
    LTE_MOBILEDATA = 0x11189
    LTE_MOBILEDATA_OUTLINED = 0x1118A
    LTE_MOBILEDATA_ROUNDED = 0x1118B
    LTE_MOBILEDATA_SHARP = 0x1118C
    LTE_PLUS_MOBILEDATA = 0x1118D
    LTE_PLUS_MOBILEDATA_OUTLINED = 0x1118E
    LTE_PLUS_MOBILEDATA_ROUNDED = 0x1118F
    LTE_PLUS_MOBILEDATA_SHARP = 0x11190
    LUGGAGE = 0x11191
    LUGGAGE_OUTLINED = 0x11192
    LUGGAGE_ROUNDED = 0x11193
    LUGGAGE_SHARP = 0x11194
    LUNCH_DINING = 0x11195
    LUNCH_DINING_OUTLINED = 0x11196
    LUNCH_DINING_ROUNDED = 0x11197
    LUNCH_DINING_SHARP = 0x11198
    LYRICS = 0x11199
    LYRICS_OUTLINED = 0x1119A
    LYRICS_ROUNDED = 0x1119B
    LYRICS_SHARP = 0x1119C
    MACRO_OFF = 0x1119D
    MACRO_OFF_OUTLINED = 0x1119E
    MACRO_OFF_ROUNDED = 0x1119F
    MACRO_OFF_SHARP = 0x111A0
    MAIL = 0x111A1
    MAIL_LOCK = 0x111A2
    MAIL_LOCK_OUTLINED = 0x111A3
    MAIL_LOCK_ROUNDED = 0x111A4
    MAIL_LOCK_SHARP = 0x111A5
    MAIL_OUTLINE = 0x111A6
    MAIL_OUTLINE_OUTLINED = 0x111A7
    MAIL_OUTLINE_ROUNDED = 0x111A8
    MAIL_OUTLINE_SHARP = 0x111A9
    MAIL_OUTLINED = 0x111AA
    MAIL_ROUNDED = 0x111AB
    MAIL_SHARP = 0x111AC
    MALE = 0x111AD
    MALE_OUTLINED = 0x111AE
    MALE_ROUNDED = 0x111AF
    MALE_SHARP = 0x111B0
    MAN = 0x111B1
    MAN_2 = 0x111B2
    MAN_2_OUTLINED = 0x111B3
    MAN_2_ROUNDED = 0x111B4
    MAN_2_SHARP = 0x111B5
    MAN_3 = 0x111B6
    MAN_3_OUTLINED = 0x111B7
    MAN_3_ROUNDED = 0x111B8
    MAN_3_SHARP = 0x111B9
    MAN_4 = 0x111BA
    MAN_4_OUTLINED = 0x111BB
    MAN_4_ROUNDED = 0x111BC
    MAN_4_SHARP = 0x111BD
    MAN_OUTLINED = 0x111BE
    MAN_ROUNDED = 0x111BF
    MAN_SHARP = 0x111C0
    MANAGE_ACCOUNTS = 0x111C1
    MANAGE_ACCOUNTS_OUTLINED = 0x111C2
    MANAGE_ACCOUNTS_ROUNDED = 0x111C3
    MANAGE_ACCOUNTS_SHARP = 0x111C4
    MANAGE_HISTORY = 0x111C5
    MANAGE_HISTORY_OUTLINED = 0x111C6
    MANAGE_HISTORY_ROUNDED = 0x111C7
    MANAGE_HISTORY_SHARP = 0x111C8
    MANAGE_SEARCH = 0x111C9
    MANAGE_SEARCH_OUTLINED = 0x111CA
    MANAGE_SEARCH_ROUNDED = 0x111CB
    MANAGE_SEARCH_SHARP = 0x111CC
    MAP = 0x111CD
    MAP_OUTLINED = 0x111CE
    MAP_ROUNDED = 0x111CF
    MAP_SHARP = 0x111D0
    MAPS_HOME_WORK = 0x111D1
    MAPS_HOME_WORK_OUTLINED = 0x111D2
    MAPS_HOME_WORK_ROUNDED = 0x111D3
    MAPS_HOME_WORK_SHARP = 0x111D4
    MAPS_UGC = 0x111D5
    MAPS_UGC_OUTLINED = 0x111D6
    MAPS_UGC_ROUNDED = 0x111D7
    MAPS_UGC_SHARP = 0x111D8
    MARGIN = 0x111D9
    MARGIN_OUTLINED = 0x111DA
    MARGIN_ROUNDED = 0x111DB
    MARGIN_SHARP = 0x111DC
    MARK_AS_UNREAD = 0x111DD
    MARK_AS_UNREAD_OUTLINED = 0x111DE
    MARK_AS_UNREAD_ROUNDED = 0x111DF
    MARK_AS_UNREAD_SHARP = 0x111E0
    MARK_CHAT_READ = 0x111E1
    MARK_CHAT_READ_OUTLINED = 0x111E2
    MARK_CHAT_READ_ROUNDED = 0x111E3
    MARK_CHAT_READ_SHARP = 0x111E4
    MARK_CHAT_UNREAD = 0x111E5
    MARK_CHAT_UNREAD_OUTLINED = 0x111E6
    MARK_CHAT_UNREAD_ROUNDED = 0x111E7
    MARK_CHAT_UNREAD_SHARP = 0x111E8
    MARK_EMAIL_READ = 0x111E9
    MARK_EMAIL_READ_OUTLINED = 0x111EA
    MARK_EMAIL_READ_ROUNDED = 0x111EB
    MARK_EMAIL_READ_SHARP = 0x111EC
    MARK_EMAIL_UNREAD = 0x111ED
    MARK_EMAIL_UNREAD_OUTLINED = 0x111EE
    MARK_EMAIL_UNREAD_ROUNDED = 0x111EF
    MARK_EMAIL_UNREAD_SHARP = 0x111F0
    MARK_UNREAD_CHAT_ALT = 0x111F1
    MARK_UNREAD_CHAT_ALT_OUTLINED = 0x111F2
    MARK_UNREAD_CHAT_ALT_ROUNDED = 0x111F3
    MARK_UNREAD_CHAT_ALT_SHARP = 0x111F4
    MARKUNREAD = 0x111F5
    MARKUNREAD_MAILBOX = 0x111F6
    MARKUNREAD_MAILBOX_OUTLINED = 0x111F7
    MARKUNREAD_MAILBOX_ROUNDED = 0x111F8
    MARKUNREAD_MAILBOX_SHARP = 0x111F9
    MARKUNREAD_OUTLINED = 0x111FA
    MARKUNREAD_ROUNDED = 0x111FB
    MARKUNREAD_SHARP = 0x111FC
    MASKS = 0x111FD
    MASKS_OUTLINED = 0x111FE
    MASKS_ROUNDED = 0x111FF
    MASKS_SHARP = 0x11200
    MAXIMIZE = 0x11201
    MAXIMIZE_OUTLINED = 0x11202
    MAXIMIZE_ROUNDED = 0x11203
    MAXIMIZE_SHARP = 0x11204
    MEDIA_BLUETOOTH_OFF = 0x11205
    MEDIA_BLUETOOTH_OFF_OUTLINED = 0x11206
    MEDIA_BLUETOOTH_OFF_ROUNDED = 0x11207
    MEDIA_BLUETOOTH_OFF_SHARP = 0x11208
    MEDIA_BLUETOOTH_ON = 0x11209
    MEDIA_BLUETOOTH_ON_OUTLINED = 0x1120A
    MEDIA_BLUETOOTH_ON_ROUNDED = 0x1120B
    MEDIA_BLUETOOTH_ON_SHARP = 0x1120C
    MEDIATION = 0x1120D
    MEDIATION_OUTLINED = 0x1120E
    MEDIATION_ROUNDED = 0x1120F
    MEDIATION_SHARP = 0x11210
    MEDICAL_INFORMATION = 0x11211
    MEDICAL_INFORMATION_OUTLINED = 0x11212
    MEDICAL_INFORMATION_ROUNDED = 0x11213
    MEDICAL_INFORMATION_SHARP = 0x11214
    MEDICAL_SERVICES = 0x11215
    MEDICAL_SERVICES_OUTLINED = 0x11216
    MEDICAL_SERVICES_ROUNDED = 0x11217
    MEDICAL_SERVICES_SHARP = 0x11218
    MEDICATION = 0x11219
    MEDICATION_LIQUID = 0x1121A
    MEDICATION_LIQUID_OUTLINED = 0x1121B
    MEDICATION_LIQUID_ROUNDED = 0x1121C
    MEDICATION_LIQUID_SHARP = 0x1121D
    MEDICATION_OUTLINED = 0x1121E
    MEDICATION_ROUNDED = 0x1121F
    MEDICATION_SHARP = 0x11220
    MEETING_ROOM = 0x11221
    MEETING_ROOM_OUTLINED = 0x11222
    MEETING_ROOM_ROUNDED = 0x11223
    MEETING_ROOM_SHARP = 0x11224
    MEMORY = 0x11225
    MEMORY_OUTLINED = 0x11226
    MEMORY_ROUNDED = 0x11227
    MEMORY_SHARP = 0x11228
    MENU = 0x11229
    MENU_BOOK = 0x1122A
    MENU_BOOK_OUTLINED = 0x1122B
    MENU_BOOK_ROUNDED = 0x1122C
    MENU_BOOK_SHARP = 0x1122D
    MENU_OPEN = 0x1122E
    MENU_OPEN_OUTLINED = 0x1122F
    MENU_OPEN_ROUNDED = 0x11230
    MENU_OPEN_SHARP = 0x11231
    MENU_OUTLINED = 0x11232
    MENU_ROUNDED = 0x11233
    MENU_SHARP = 0x11234
    MERGE = 0x11235
    MERGE_OUTLINED = 0x11236
    MERGE_ROUNDED = 0x11237
    MERGE_SHARP = 0x11238
    MERGE_TYPE = 0x11239
    MERGE_TYPE_OUTLINED = 0x1123A
    MERGE_TYPE_ROUNDED = 0x1123B
    MERGE_TYPE_SHARP = 0x1123C
    MESSAGE = 0x1123D
    MESSAGE_OUTLINED = 0x1123E
    MESSAGE_ROUNDED = 0x1123F
    MESSAGE_SHARP = 0x11240
    MESSENGER = 0x11241
    MESSENGER_OUTLINE = 0x11242
    MESSENGER_OUTLINE_OUTLINED = 0x11243
    MESSENGER_OUTLINE_ROUNDED = 0x11244
    MESSENGER_OUTLINE_SHARP = 0x11245
    MESSENGER_OUTLINED = 0x11246
    MESSENGER_ROUNDED = 0x11247
    MESSENGER_SHARP = 0x11248
    MIC = 0x11249
    MIC_EXTERNAL_OFF = 0x1124A
    MIC_EXTERNAL_OFF_OUTLINED = 0x1124B
    MIC_EXTERNAL_OFF_ROUNDED = 0x1124C
    MIC_EXTERNAL_OFF_SHARP = 0x1124D
    MIC_EXTERNAL_ON = 0x1124E
    MIC_EXTERNAL_ON_OUTLINED = 0x1124F
    MIC_EXTERNAL_ON_ROUNDED = 0x11250
    MIC_EXTERNAL_ON_SHARP = 0x11251
    MIC_NONE = 0x11252
    MIC_NONE_OUTLINED = 0x11253
    MIC_NONE_ROUNDED = 0x11254
    MIC_NONE_SHARP = 0x11255
    MIC_OFF = 0x11256
    MIC_OFF_OUTLINED = 0x11257
    MIC_OFF_ROUNDED = 0x11258
    MIC_OFF_SHARP = 0x11259
    MIC_OUTLINED = 0x1125A
    MIC_ROUNDED = 0x1125B
    MIC_SHARP = 0x1125C
    MICROWAVE = 0x1125D
    MICROWAVE_OUTLINED = 0x1125E
    MICROWAVE_ROUNDED = 0x1125F
    MICROWAVE_SHARP = 0x11260
    MILITARY_TECH = 0x11261
    MILITARY_TECH_OUTLINED = 0x11262
    MILITARY_TECH_ROUNDED = 0x11263
    MILITARY_TECH_SHARP = 0x11264
    MINIMIZE = 0x11265
    MINIMIZE_OUTLINED = 0x11266
    MINIMIZE_ROUNDED = 0x11267
    MINIMIZE_SHARP = 0x11268
    MINOR_CRASH = 0x11269
    MINOR_CRASH_OUTLINED = 0x1126A
    MINOR_CRASH_ROUNDED = 0x1126B
    MINOR_CRASH_SHARP = 0x1126C
    MISCELLANEOUS_SERVICES = 0x1126D
    MISCELLANEOUS_SERVICES_OUTLINED = 0x1126E
    MISCELLANEOUS_SERVICES_ROUNDED = 0x1126F
    MISCELLANEOUS_SERVICES_SHARP = 0x11270
    MISSED_VIDEO_CALL = 0x11271
    MISSED_VIDEO_CALL_OUTLINED = 0x11272
    MISSED_VIDEO_CALL_ROUNDED = 0x11273
    MISSED_VIDEO_CALL_SHARP = 0x11274
    MMS = 0x11275
    MMS_OUTLINED = 0x11276
    MMS_ROUNDED = 0x11277
    MMS_SHARP = 0x11278
    MOBILE_FRIENDLY = 0x11279
    MOBILE_FRIENDLY_OUTLINED = 0x1127A
    MOBILE_FRIENDLY_ROUNDED = 0x1127B
    MOBILE_FRIENDLY_SHARP = 0x1127C
    MOBILE_OFF = 0x1127D
    MOBILE_OFF_OUTLINED = 0x1127E
    MOBILE_OFF_ROUNDED = 0x1127F
    MOBILE_OFF_SHARP = 0x11280
    MOBILE_SCREEN_SHARE = 0x11281
    MOBILE_SCREEN_SHARE_OUTLINED = 0x11282
    MOBILE_SCREEN_SHARE_ROUNDED = 0x11283
    MOBILE_SCREEN_SHARE_SHARP = 0x11284
    MOBILEDATA_OFF = 0x11285
    MOBILEDATA_OFF_OUTLINED = 0x11286
    MOBILEDATA_OFF_ROUNDED = 0x11287
    MOBILEDATA_OFF_SHARP = 0x11288
    MODE = 0x11289
    MODE_COMMENT = 0x1128A
    MODE_COMMENT_OUTLINED = 0x1128B
    MODE_COMMENT_ROUNDED = 0x1128C
    MODE_COMMENT_SHARP = 0x1128D
    MODE_EDIT = 0x1128E
    MODE_EDIT_OUTLINE = 0x1128F
    MODE_EDIT_OUTLINE_OUTLINED = 0x11290
    MODE_EDIT_OUTLINE_ROUNDED = 0x11291
    MODE_EDIT_OUTLINE_SHARP = 0x11292
    MODE_EDIT_OUTLINED = 0x11293
    MODE_EDIT_ROUNDED = 0x11294
    MODE_EDIT_SHARP = 0x11295
    MODE_FAN_OFF = 0x11296
    MODE_FAN_OFF_OUTLINED = 0x11297
    MODE_FAN_OFF_ROUNDED = 0x11298
    MODE_FAN_OFF_SHARP = 0x11299
    MODE_NIGHT = 0x1129A
    MODE_NIGHT_OUTLINED = 0x1129B
    MODE_NIGHT_ROUNDED = 0x1129C
    MODE_NIGHT_SHARP = 0x1129D
    MODE_OF_TRAVEL = 0x1129E
    MODE_OF_TRAVEL_OUTLINED = 0x1129F
    MODE_OF_TRAVEL_ROUNDED = 0x112A0
    MODE_OF_TRAVEL_SHARP = 0x112A1
    MODE_OUTLINED = 0x112A2
    MODE_ROUNDED = 0x112A3
    MODE_SHARP = 0x112A4
    MODE_STANDBY = 0x112A5
    MODE_STANDBY_OUTLINED = 0x112A6
    MODE_STANDBY_ROUNDED = 0x112A7
    MODE_STANDBY_SHARP = 0x112A8
    MODEL_TRAINING = 0x112A9
    MODEL_TRAINING_OUTLINED = 0x112AA
    MODEL_TRAINING_ROUNDED = 0x112AB
    MODEL_TRAINING_SHARP = 0x112AC
    MONETIZATION_ON = 0x112AD
    MONETIZATION_ON_OUTLINED = 0x112AE
    MONETIZATION_ON_ROUNDED = 0x112AF
    MONETIZATION_ON_SHARP = 0x112B0
    MONEY = 0x112B1
    MONEY_OFF = 0x112B2
    MONEY_OFF_CSRED = 0x112B3
    MONEY_OFF_CSRED_OUTLINED = 0x112B4
    MONEY_OFF_CSRED_ROUNDED = 0x112B5
    MONEY_OFF_CSRED_SHARP = 0x112B6
    MONEY_OFF_OUTLINED = 0x112B7
    MONEY_OFF_ROUNDED = 0x112B8
    MONEY_OFF_SHARP = 0x112B9
    MONEY_OUTLINED = 0x112BA
    MONEY_ROUNDED = 0x112BB
    MONEY_SHARP = 0x112BC
    MONITOR = 0x112BD
    MONITOR_HEART = 0x112BE
    MONITOR_HEART_OUTLINED = 0x112BF
    MONITOR_HEART_ROUNDED = 0x112C0
    MONITOR_HEART_SHARP = 0x112C1
    MONITOR_OUTLINED = 0x112C2
    MONITOR_ROUNDED = 0x112C3
    MONITOR_SHARP = 0x112C4
    MONITOR_WEIGHT = 0x112C5
    MONITOR_WEIGHT_OUTLINED = 0x112C6
    MONITOR_WEIGHT_ROUNDED = 0x112C7
    MONITOR_WEIGHT_SHARP = 0x112C8
    MONOCHROME_PHOTOS = 0x112C9
    MONOCHROME_PHOTOS_OUTLINED = 0x112CA
    MONOCHROME_PHOTOS_ROUNDED = 0x112CB
    MONOCHROME_PHOTOS_SHARP = 0x112CC
    MOOD = 0x112CD
    MOOD_BAD = 0x112CE
    MOOD_BAD_OUTLINED = 0x112CF
    MOOD_BAD_ROUNDED = 0x112D0
    MOOD_BAD_SHARP = 0x112D1
    MOOD_OUTLINED = 0x112D2
    MOOD_ROUNDED = 0x112D3
    MOOD_SHARP = 0x112D4
    MOPED = 0x112D5
    MOPED_OUTLINED = 0x112D6
    MOPED_ROUNDED = 0x112D7
    MOPED_SHARP = 0x112D8
    MORE = 0x112D9
    MORE_HORIZ = 0x112DA
    MORE_HORIZ_OUTLINED = 0x112DB
    MORE_HORIZ_ROUNDED = 0x112DC
    MORE_HORIZ_SHARP = 0x112DD
    MORE_OUTLINED = 0x112DE
    MORE_ROUNDED = 0x112DF
    MORE_SHARP = 0x112E0
    MORE_TIME = 0x112E1
    MORE_TIME_OUTLINED = 0x112E2
    MORE_TIME_ROUNDED = 0x112E3
    MORE_TIME_SHARP = 0x112E4
    MORE_VERT = 0x112E5
    MORE_VERT_OUTLINED = 0x112E6
    MORE_VERT_ROUNDED = 0x112E7
    MORE_VERT_SHARP = 0x112E8
    MOSQUE = 0x112E9
    MOSQUE_OUTLINED = 0x112EA
    MOSQUE_ROUNDED = 0x112EB
    MOSQUE_SHARP = 0x112EC
    MOTION_PHOTOS_AUTO = 0x112ED
    MOTION_PHOTOS_AUTO_OUTLINED = 0x112EE
    MOTION_PHOTOS_AUTO_ROUNDED = 0x112EF
    MOTION_PHOTOS_AUTO_SHARP = 0x112F0
    MOTION_PHOTOS_OFF = 0x112F1
    MOTION_PHOTOS_OFF_OUTLINED = 0x112F2
    MOTION_PHOTOS_OFF_ROUNDED = 0x112F3
    MOTION_PHOTOS_OFF_SHARP = 0x112F4
    MOTION_PHOTOS_ON = 0x112F5
    MOTION_PHOTOS_ON_OUTLINED = 0x112F6
    MOTION_PHOTOS_ON_ROUNDED = 0x112F7
    MOTION_PHOTOS_ON_SHARP = 0x112F8
    MOTION_PHOTOS_PAUSE = 0x112F9
    MOTION_PHOTOS_PAUSE_OUTLINED = 0x112FA
    MOTION_PHOTOS_PAUSE_ROUNDED = 0x112FB
    MOTION_PHOTOS_PAUSE_SHARP = 0x112FC
    MOTION_PHOTOS_PAUSED = 0x112FD
    MOTION_PHOTOS_PAUSED_OUTLINED = 0x112FE
    MOTION_PHOTOS_PAUSED_ROUNDED = 0x112FF
    MOTION_PHOTOS_PAUSED_SHARP = 0x11300
    MOTORCYCLE = 0x11301
    MOTORCYCLE_OUTLINED = 0x11302
    MOTORCYCLE_ROUNDED = 0x11303
    MOTORCYCLE_SHARP = 0x11304
    MOUSE = 0x11305
    MOUSE_OUTLINED = 0x11306
    MOUSE_ROUNDED = 0x11307
    MOUSE_SHARP = 0x11308
    MOVE_DOWN = 0x11309
    MOVE_DOWN_OUTLINED = 0x1130A
    MOVE_DOWN_ROUNDED = 0x1130B
    MOVE_DOWN_SHARP = 0x1130C
    MOVE_TO_INBOX = 0x1130D
    MOVE_TO_INBOX_OUTLINED = 0x1130E
    MOVE_TO_INBOX_ROUNDED = 0x1130F
    MOVE_TO_INBOX_SHARP = 0x11310
    MOVE_UP = 0x11311
    MOVE_UP_OUTLINED = 0x11312
    MOVE_UP_ROUNDED = 0x11313
    MOVE_UP_SHARP = 0x11314
    MOVIE = 0x11315
    MOVIE_CREATION = 0x11316
    MOVIE_CREATION_OUTLINED = 0x11317
    MOVIE_CREATION_ROUNDED = 0x11318
    MOVIE_CREATION_SHARP = 0x11319
    MOVIE_EDIT = 0x1131A
    MOVIE_FILTER = 0x1131B
    MOVIE_FILTER_OUTLINED = 0x1131C
    MOVIE_FILTER_ROUNDED = 0x1131D
    MOVIE_FILTER_SHARP = 0x1131E
    MOVIE_OUTLINED = 0x1131F
    MOVIE_ROUNDED = 0x11320
    MOVIE_SHARP = 0x11321
    MOVING = 0x11322
    MOVING_OUTLINED = 0x11323
    MOVING_ROUNDED = 0x11324
    MOVING_SHARP = 0x11325
    MP = 0x11326
    MP_OUTLINED = 0x11327
    MP_ROUNDED = 0x11328
    MP_SHARP = 0x11329
    MULTILINE_CHART = 0x1132A
    MULTILINE_CHART_OUTLINED = 0x1132B
    MULTILINE_CHART_ROUNDED = 0x1132C
    MULTILINE_CHART_SHARP = 0x1132D
    MULTIPLE_STOP = 0x1132E
    MULTIPLE_STOP_OUTLINED = 0x1132F
    MULTIPLE_STOP_ROUNDED = 0x11330
    MULTIPLE_STOP_SHARP = 0x11331
    MULTITRACK_AUDIO = 0x11332
    MULTITRACK_AUDIO_OUTLINED = 0x11333
    MULTITRACK_AUDIO_ROUNDED = 0x11334
    MULTITRACK_AUDIO_SHARP = 0x11335
    MUSEUM = 0x11336
    MUSEUM_OUTLINED = 0x11337
    MUSEUM_ROUNDED = 0x11338
    MUSEUM_SHARP = 0x11339
    MUSIC_NOTE = 0x1133A
    MUSIC_NOTE_OUTLINED = 0x1133B
    MUSIC_NOTE_ROUNDED = 0x1133C
    MUSIC_NOTE_SHARP = 0x1133D
    MUSIC_OFF = 0x1133E
    MUSIC_OFF_OUTLINED = 0x1133F
    MUSIC_OFF_ROUNDED = 0x11340
    MUSIC_OFF_SHARP = 0x11341
    MUSIC_VIDEO = 0x11342
    MUSIC_VIDEO_OUTLINED = 0x11343
    MUSIC_VIDEO_ROUNDED = 0x11344
    MUSIC_VIDEO_SHARP = 0x11345
    MY_LIBRARY_ADD = 0x11346
    MY_LIBRARY_ADD_OUTLINED = 0x11347
    MY_LIBRARY_ADD_ROUNDED = 0x11348
    MY_LIBRARY_ADD_SHARP = 0x11349
    MY_LIBRARY_BOOKS = 0x1134A
    MY_LIBRARY_BOOKS_OUTLINED = 0x1134B
    MY_LIBRARY_BOOKS_ROUNDED = 0x1134C
    MY_LIBRARY_BOOKS_SHARP = 0x1134D
    MY_LIBRARY_MUSIC = 0x1134E
    MY_LIBRARY_MUSIC_OUTLINED = 0x1134F
    MY_LIBRARY_MUSIC_ROUNDED = 0x11350
    MY_LIBRARY_MUSIC_SHARP = 0x11351
    MY_LOCATION = 0x11352
    MY_LOCATION_OUTLINED = 0x11353
    MY_LOCATION_ROUNDED = 0x11354
    MY_LOCATION_SHARP = 0x11355
    NAT = 0x11356
    NAT_OUTLINED = 0x11357
    NAT_ROUNDED = 0x11358
    NAT_SHARP = 0x11359
    NATURE = 0x1135A
    NATURE_OUTLINED = 0x1135B
    NATURE_PEOPLE = 0x1135C
    NATURE_PEOPLE_OUTLINED = 0x1135D
    NATURE_PEOPLE_ROUNDED = 0x1135E
    NATURE_PEOPLE_SHARP = 0x1135F
    NATURE_ROUNDED = 0x11360
    NATURE_SHARP = 0x11361
    NAVIGATE_BEFORE = 0x11362
    NAVIGATE_BEFORE_OUTLINED = 0x11363
    NAVIGATE_BEFORE_ROUNDED = 0x11364
    NAVIGATE_BEFORE_SHARP = 0x11365
    NAVIGATE_NEXT = 0x11366
    NAVIGATE_NEXT_OUTLINED = 0x11367
    NAVIGATE_NEXT_ROUNDED = 0x11368
    NAVIGATE_NEXT_SHARP = 0x11369
    NAVIGATION = 0x1136A
    NAVIGATION_OUTLINED = 0x1136B
    NAVIGATION_ROUNDED = 0x1136C
    NAVIGATION_SHARP = 0x1136D
    NEAR_ME = 0x1136E
    NEAR_ME_DISABLED = 0x1136F
    NEAR_ME_DISABLED_OUTLINED = 0x11370
    NEAR_ME_DISABLED_ROUNDED = 0x11371
    NEAR_ME_DISABLED_SHARP = 0x11372
    NEAR_ME_OUTLINED = 0x11373
    NEAR_ME_ROUNDED = 0x11374
    NEAR_ME_SHARP = 0x11375
    NEARBY_ERROR = 0x11376
    NEARBY_ERROR_OUTLINED = 0x11377
    NEARBY_ERROR_ROUNDED = 0x11378
    NEARBY_ERROR_SHARP = 0x11379
    NEARBY_OFF = 0x1137A
    NEARBY_OFF_OUTLINED = 0x1137B
    NEARBY_OFF_ROUNDED = 0x1137C
    NEARBY_OFF_SHARP = 0x1137D
    NEST_CAM_WIRED_STAND = 0x1137E
    NEST_CAM_WIRED_STAND_OUTLINED = 0x1137F
    NEST_CAM_WIRED_STAND_ROUNDED = 0x11380
    NEST_CAM_WIRED_STAND_SHARP = 0x11381
    NETWORK_CELL = 0x11382
    NETWORK_CELL_OUTLINED = 0x11383
    NETWORK_CELL_ROUNDED = 0x11384
    NETWORK_CELL_SHARP = 0x11385
    NETWORK_CHECK = 0x11386
    NETWORK_CHECK_OUTLINED = 0x11387
    NETWORK_CHECK_ROUNDED = 0x11388
    NETWORK_CHECK_SHARP = 0x11389
    NETWORK_LOCKED = 0x1138A
    NETWORK_LOCKED_OUTLINED = 0x1138B
    NETWORK_LOCKED_ROUNDED = 0x1138C
    NETWORK_LOCKED_SHARP = 0x1138D
    NETWORK_PING = 0x1138E
    NETWORK_PING_OUTLINED = 0x1138F
    NETWORK_PING_ROUNDED = 0x11390
    NETWORK_PING_SHARP = 0x11391
    NETWORK_WIFI = 0x11392
    NETWORK_WIFI_1_BAR = 0x11393
    NETWORK_WIFI_1_BAR_OUTLINED = 0x11394
    NETWORK_WIFI_1_BAR_ROUNDED = 0x11395
    NETWORK_WIFI_1_BAR_SHARP = 0x11396
    NETWORK_WIFI_2_BAR = 0x11397
    NETWORK_WIFI_2_BAR_OUTLINED = 0x11398
    NETWORK_WIFI_2_BAR_ROUNDED = 0x11399
    NETWORK_WIFI_2_BAR_SHARP = 0x1139A
    NETWORK_WIFI_3_BAR = 0x1139B
    NETWORK_WIFI_3_BAR_OUTLINED = 0x1139C
    NETWORK_WIFI_3_BAR_ROUNDED = 0x1139D
    NETWORK_WIFI_3_BAR_SHARP = 0x1139E
    NETWORK_WIFI_OUTLINED = 0x1139F
    NETWORK_WIFI_ROUNDED = 0x113A0
    NETWORK_WIFI_SHARP = 0x113A1
    NEW_LABEL = 0x113A2
    NEW_LABEL_OUTLINED = 0x113A3
    NEW_LABEL_ROUNDED = 0x113A4
    NEW_LABEL_SHARP = 0x113A5
    NEW_RELEASES = 0x113A6
    NEW_RELEASES_OUTLINED = 0x113A7
    NEW_RELEASES_ROUNDED = 0x113A8
    NEW_RELEASES_SHARP = 0x113A9
    NEWSPAPER = 0x113AA
    NEWSPAPER_OUTLINED = 0x113AB
    NEWSPAPER_ROUNDED = 0x113AC
    NEWSPAPER_SHARP = 0x113AD
    NEXT_PLAN = 0x113AE
    NEXT_PLAN_OUTLINED = 0x113AF
    NEXT_PLAN_ROUNDED = 0x113B0
    NEXT_PLAN_SHARP = 0x113B1
    NEXT_WEEK = 0x113B2
    NEXT_WEEK_OUTLINED = 0x113B3
    NEXT_WEEK_ROUNDED = 0x113B4
    NEXT_WEEK_SHARP = 0x113B5
    NFC = 0x113B6
    NFC_OUTLINED = 0x113B7
    NFC_ROUNDED = 0x113B8
    NFC_SHARP = 0x113B9
    NIGHT_SHELTER = 0x113BA
    NIGHT_SHELTER_OUTLINED = 0x113BB
    NIGHT_SHELTER_ROUNDED = 0x113BC
    NIGHT_SHELTER_SHARP = 0x113BD
    NIGHTLIFE = 0x113BE
    NIGHTLIFE_OUTLINED = 0x113BF
    NIGHTLIFE_ROUNDED = 0x113C0
    NIGHTLIFE_SHARP = 0x113C1
    NIGHTLIGHT = 0x113C2
    NIGHTLIGHT_OUTLINED = 0x113C3
    NIGHTLIGHT_ROUND = 0x113C4
    NIGHTLIGHT_ROUND_OUTLINED = 0x113C5
    NIGHTLIGHT_ROUND_ROUNDED = 0x113C6
    NIGHTLIGHT_ROUND_SHARP = 0x113C7
    NIGHTLIGHT_ROUNDED = 0x113C8
    NIGHTLIGHT_SHARP = 0x113C9
    NIGHTS_STAY = 0x113CA
    NIGHTS_STAY_OUTLINED = 0x113CB
    NIGHTS_STAY_ROUNDED = 0x113CC
    NIGHTS_STAY_SHARP = 0x113CD
    NINE_K = 0x113CE
    NINE_K_OUTLINED = 0x113CF
    NINE_K_PLUS = 0x113D0
    NINE_K_PLUS_OUTLINED = 0x113D1
    NINE_K_PLUS_ROUNDED = 0x113D2
    NINE_K_PLUS_SHARP = 0x113D3
    NINE_K_ROUNDED = 0x113D4
    NINE_K_SHARP = 0x113D5
    NINE_MP = 0x113D6
    NINE_MP_OUTLINED = 0x113D7
    NINE_MP_ROUNDED = 0x113D8
    NINE_MP_SHARP = 0x113D9
    NINETEEN_MP = 0x113DA
    NINETEEN_MP_OUTLINED = 0x113DB
    NINETEEN_MP_ROUNDED = 0x113DC
    NINETEEN_MP_SHARP = 0x113DD
    NO_ACCOUNTS = 0x113DE
    NO_ACCOUNTS_OUTLINED = 0x113DF
    NO_ACCOUNTS_ROUNDED = 0x113E0
    NO_ACCOUNTS_SHARP = 0x113E1
    NO_ADULT_CONTENT = 0x113E2
    NO_ADULT_CONTENT_OUTLINED = 0x113E3
    NO_ADULT_CONTENT_ROUNDED = 0x113E4
    NO_ADULT_CONTENT_SHARP = 0x113E5
    NO_BACKPACK = 0x113E6
    NO_BACKPACK_OUTLINED = 0x113E7
    NO_BACKPACK_ROUNDED = 0x113E8
    NO_BACKPACK_SHARP = 0x113E9
    NO_CELL = 0x113EA
    NO_CELL_OUTLINED = 0x113EB
    NO_CELL_ROUNDED = 0x113EC
    NO_CELL_SHARP = 0x113ED
    NO_CRASH = 0x113EE
    NO_CRASH_OUTLINED = 0x113EF
    NO_CRASH_ROUNDED = 0x113F0
    NO_CRASH_SHARP = 0x113F1
    NO_DRINKS = 0x113F2
    NO_DRINKS_OUTLINED = 0x113F3
    NO_DRINKS_ROUNDED = 0x113F4
    NO_DRINKS_SHARP = 0x113F5
    NO_ENCRYPTION = 0x113F6
    NO_ENCRYPTION_GMAILERRORRED = 0x113F7
    NO_ENCRYPTION_GMAILERRORRED_OUTLINED = 0x113F8
    NO_ENCRYPTION_GMAILERRORRED_ROUNDED = 0x113F9
    NO_ENCRYPTION_GMAILERRORRED_SHARP = 0x113FA
    NO_ENCRYPTION_OUTLINED = 0x113FB
    NO_ENCRYPTION_ROUNDED = 0x113FC
    NO_ENCRYPTION_SHARP = 0x113FD
    NO_FLASH = 0x113FE
    NO_FLASH_OUTLINED = 0x113FF
    NO_FLASH_ROUNDED = 0x11400
    NO_FLASH_SHARP = 0x11401
    NO_FOOD = 0x11402
    NO_FOOD_OUTLINED = 0x11403
    NO_FOOD_ROUNDED = 0x11404
    NO_FOOD_SHARP = 0x11405
    NO_LUGGAGE = 0x11406
    NO_LUGGAGE_OUTLINED = 0x11407
    NO_LUGGAGE_ROUNDED = 0x11408
    NO_LUGGAGE_SHARP = 0x11409
    NO_MEALS = 0x1140A
    NO_MEALS_OULINE = 0x1140B
    NO_MEALS_OUTLINED = 0x1140C
    NO_MEALS_ROUNDED = 0x1140D
    NO_MEALS_SHARP = 0x1140E
    NO_MEETING_ROOM = 0x1140F
    NO_MEETING_ROOM_OUTLINED = 0x11410
    NO_MEETING_ROOM_ROUNDED = 0x11411
    NO_MEETING_ROOM_SHARP = 0x11412
    NO_PHOTOGRAPHY = 0x11413
    NO_PHOTOGRAPHY_OUTLINED = 0x11414
    NO_PHOTOGRAPHY_ROUNDED = 0x11415
    NO_PHOTOGRAPHY_SHARP = 0x11416
    NO_SIM = 0x11417
    NO_SIM_OUTLINED = 0x11418
    NO_SIM_ROUNDED = 0x11419
    NO_SIM_SHARP = 0x1141A
    NO_STROLLER = 0x1141B
    NO_STROLLER_OUTLINED = 0x1141C
    NO_STROLLER_ROUNDED = 0x1141D
    NO_STROLLER_SHARP = 0x1141E
    NO_TRANSFER = 0x1141F
    NO_TRANSFER_OUTLINED = 0x11420
    NO_TRANSFER_ROUNDED = 0x11421
    NO_TRANSFER_SHARP = 0x11422
    NOISE_AWARE = 0x11423
    NOISE_AWARE_OUTLINED = 0x11424
    NOISE_AWARE_ROUNDED = 0x11425
    NOISE_AWARE_SHARP = 0x11426
    NOISE_CONTROL_OFF = 0x11427
    NOISE_CONTROL_OFF_OUTLINED = 0x11428
    NOISE_CONTROL_OFF_ROUNDED = 0x11429
    NOISE_CONTROL_OFF_SHARP = 0x1142A
    NORDIC_WALKING = 0x1142B
    NORDIC_WALKING_OUTLINED = 0x1142C
    NORDIC_WALKING_ROUNDED = 0x1142D
    NORDIC_WALKING_SHARP = 0x1142E
    NORTH = 0x1142F
    NORTH_EAST = 0x11430
    NORTH_EAST_OUTLINED = 0x11431
    NORTH_EAST_ROUNDED = 0x11432
    NORTH_EAST_SHARP = 0x11433
    NORTH_OUTLINED = 0x11434
    NORTH_ROUNDED = 0x11435
    NORTH_SHARP = 0x11436
    NORTH_WEST = 0x11437
    NORTH_WEST_OUTLINED = 0x11438
    NORTH_WEST_ROUNDED = 0x11439
    NORTH_WEST_SHARP = 0x1143A
    NOT_ACCESSIBLE = 0x1143B
    NOT_ACCESSIBLE_OUTLINED = 0x1143C
    NOT_ACCESSIBLE_ROUNDED = 0x1143D
    NOT_ACCESSIBLE_SHARP = 0x1143E
    NOT_INTERESTED = 0x1143F
    NOT_INTERESTED_OUTLINED = 0x11440
    NOT_INTERESTED_ROUNDED = 0x11441
    NOT_INTERESTED_SHARP = 0x11442
    NOT_LISTED_LOCATION = 0x11443
    NOT_LISTED_LOCATION_OUTLINED = 0x11444
    NOT_LISTED_LOCATION_ROUNDED = 0x11445
    NOT_LISTED_LOCATION_SHARP = 0x11446
    NOT_STARTED = 0x11447
    NOT_STARTED_OUTLINED = 0x11448
    NOT_STARTED_ROUNDED = 0x11449
    NOT_STARTED_SHARP = 0x1144A
    NOTE = 0x1144B
    NOTE_ADD = 0x1144C
    NOTE_ADD_OUTLINED = 0x1144D
    NOTE_ADD_ROUNDED = 0x1144E
    NOTE_ADD_SHARP = 0x1144F
    NOTE_ALT = 0x11450
    NOTE_ALT_OUTLINED = 0x11451
    NOTE_ALT_ROUNDED = 0x11452
    NOTE_ALT_SHARP = 0x11453
    NOTE_OUTLINED = 0x11454
    NOTE_ROUNDED = 0x11455
    NOTE_SHARP = 0x11456
    NOTES = 0x11457
    NOTES_OUTLINED = 0x11458
    NOTES_ROUNDED = 0x11459
    NOTES_SHARP = 0x1145A
    NOTIFICATION_ADD = 0x1145B
    NOTIFICATION_ADD_OUTLINED = 0x1145C
    NOTIFICATION_ADD_ROUNDED = 0x1145D
    NOTIFICATION_ADD_SHARP = 0x1145E
    NOTIFICATION_IMPORTANT = 0x1145F
    NOTIFICATION_IMPORTANT_OUTLINED = 0x11460
    NOTIFICATION_IMPORTANT_ROUNDED = 0x11461
    NOTIFICATION_IMPORTANT_SHARP = 0x11462
    NOTIFICATIONS = 0x11463
    NOTIFICATIONS_ACTIVE = 0x11464
    NOTIFICATIONS_ACTIVE_OUTLINED = 0x11465
    NOTIFICATIONS_ACTIVE_ROUNDED = 0x11466
    NOTIFICATIONS_ACTIVE_SHARP = 0x11467
    NOTIFICATIONS_NONE = 0x11468
    NOTIFICATIONS_NONE_OUTLINED = 0x11469
    NOTIFICATIONS_NONE_ROUNDED = 0x1146A
    NOTIFICATIONS_NONE_SHARP = 0x1146B
    NOTIFICATIONS_OFF = 0x1146C
    NOTIFICATIONS_OFF_OUTLINED = 0x1146D
    NOTIFICATIONS_OFF_ROUNDED = 0x1146E
    NOTIFICATIONS_OFF_SHARP = 0x1146F
    NOTIFICATIONS_ON = 0x11470
    NOTIFICATIONS_ON_OUTLINED = 0x11471
    NOTIFICATIONS_ON_ROUNDED = 0x11472
    NOTIFICATIONS_ON_SHARP = 0x11473
    NOTIFICATIONS_OUTLINED = 0x11474
    NOTIFICATIONS_PAUSED = 0x11475
    NOTIFICATIONS_PAUSED_OUTLINED = 0x11476
    NOTIFICATIONS_PAUSED_ROUNDED = 0x11477
    NOTIFICATIONS_PAUSED_SHARP = 0x11478
    NOTIFICATIONS_ROUNDED = 0x11479
    NOTIFICATIONS_SHARP = 0x1147A
    NOW_WALLPAPER = 0x1147B
    NOW_WALLPAPER_OUTLINED = 0x1147C
    NOW_WALLPAPER_ROUNDED = 0x1147D
    NOW_WALLPAPER_SHARP = 0x1147E
    NOW_WIDGETS = 0x1147F
    NOW_WIDGETS_OUTLINED = 0x11480
    NOW_WIDGETS_ROUNDED = 0x11481
    NOW_WIDGETS_SHARP = 0x11482
    NUMBERS = 0x11483
    NUMBERS_OUTLINED = 0x11484
    NUMBERS_ROUNDED = 0x11485
    NUMBERS_SHARP = 0x11486
    OFFLINE_BOLT = 0x11487
    OFFLINE_BOLT_OUTLINED = 0x11488
    OFFLINE_BOLT_ROUNDED = 0x11489
    OFFLINE_BOLT_SHARP = 0x1148A
    OFFLINE_PIN = 0x1148B
    OFFLINE_PIN_OUTLINED = 0x1148C
    OFFLINE_PIN_ROUNDED = 0x1148D
    OFFLINE_PIN_SHARP = 0x1148E
    OFFLINE_SHARE = 0x1148F
    OFFLINE_SHARE_OUTLINED = 0x11490
    OFFLINE_SHARE_ROUNDED = 0x11491
    OFFLINE_SHARE_SHARP = 0x11492
    OIL_BARREL = 0x11493
    OIL_BARREL_OUTLINED = 0x11494
    OIL_BARREL_ROUNDED = 0x11495
    OIL_BARREL_SHARP = 0x11496
    ON_DEVICE_TRAINING = 0x11497
    ON_DEVICE_TRAINING_OUTLINED = 0x11498
    ON_DEVICE_TRAINING_ROUNDED = 0x11499
    ON_DEVICE_TRAINING_SHARP = 0x1149A
    ONDEMAND_VIDEO = 0x1149B
    ONDEMAND_VIDEO_OUTLINED = 0x1149C
    ONDEMAND_VIDEO_ROUNDED = 0x1149D
    ONDEMAND_VIDEO_SHARP = 0x1149E
    ONE_K = 0x1149F
    ONE_K_OUTLINED = 0x114A0
    ONE_K_PLUS = 0x114A1
    ONE_K_PLUS_OUTLINED = 0x114A2
    ONE_K_PLUS_ROUNDED = 0x114A3
    ONE_K_PLUS_SHARP = 0x114A4
    ONE_K_ROUNDED = 0x114A5
    ONE_K_SHARP = 0x114A6
    ONE_X_MOBILEDATA = 0x114A7
    ONE_X_MOBILEDATA_OUTLINED = 0x114A8
    ONE_X_MOBILEDATA_ROUNDED = 0x114A9
    ONE_X_MOBILEDATA_SHARP = 0x114AA
    ONETWOTHREE = 0x114AB
    ONETWOTHREE_OUTLINED = 0x114AC
    ONETWOTHREE_ROUNDED = 0x114AD
    ONETWOTHREE_SHARP = 0x114AE
    ONLINE_PREDICTION = 0x114AF
    ONLINE_PREDICTION_OUTLINED = 0x114B0
    ONLINE_PREDICTION_ROUNDED = 0x114B1
    ONLINE_PREDICTION_SHARP = 0x114B2
    OPACITY = 0x114B3
    OPACITY_OUTLINED = 0x114B4
    OPACITY_ROUNDED = 0x114B5
    OPACITY_SHARP = 0x114B6
    OPEN_IN_BROWSER = 0x114B7
    OPEN_IN_BROWSER_OUTLINED = 0x114B8
    OPEN_IN_BROWSER_ROUNDED = 0x114B9
    OPEN_IN_BROWSER_SHARP = 0x114BA
    OPEN_IN_FULL = 0x114BB
    OPEN_IN_FULL_OUTLINED = 0x114BC
    OPEN_IN_FULL_ROUNDED = 0x114BD
    OPEN_IN_FULL_SHARP = 0x114BE
    OPEN_IN_NEW = 0x114BF
    OPEN_IN_NEW_OFF = 0x114C0
    OPEN_IN_NEW_OFF_OUTLINED = 0x114C1
    OPEN_IN_NEW_OFF_ROUNDED = 0x114C2
    OPEN_IN_NEW_OFF_SHARP = 0x114C3
    OPEN_IN_NEW_OUTLINED = 0x114C4
    OPEN_IN_NEW_ROUNDED = 0x114C5
    OPEN_IN_NEW_SHARP = 0x114C6
    OPEN_WITH = 0x114C7
    OPEN_WITH_OUTLINED = 0x114C8
    OPEN_WITH_ROUNDED = 0x114C9
    OPEN_WITH_SHARP = 0x114CA
    OTHER_HOUSES = 0x114CB
    OTHER_HOUSES_OUTLINED = 0x114CC
    OTHER_HOUSES_ROUNDED = 0x114CD
    OTHER_HOUSES_SHARP = 0x114CE
    OUTBOND = 0x114CF
    OUTBOND_OUTLINED = 0x114D0
    OUTBOND_ROUNDED = 0x114D1
    OUTBOND_SHARP = 0x114D2
    OUTBOUND = 0x114D3
    OUTBOUND_OUTLINED = 0x114D4
    OUTBOUND_ROUNDED = 0x114D5
    OUTBOUND_SHARP = 0x114D6
    OUTBOX = 0x114D7
    OUTBOX_OUTLINED = 0x114D8
    OUTBOX_ROUNDED = 0x114D9
    OUTBOX_SHARP = 0x114DA
    OUTDOOR_GRILL = 0x114DB
    OUTDOOR_GRILL_OUTLINED = 0x114DC
    OUTDOOR_GRILL_ROUNDED = 0x114DD
    OUTDOOR_GRILL_SHARP = 0x114DE
    OUTGOING_MAIL = 0x114DF
    OUTLET = 0x114E0
    OUTLET_OUTLINED = 0x114E1
    OUTLET_ROUNDED = 0x114E2
    OUTLET_SHARP = 0x114E3
    OUTLINED_FLAG = 0x114E4
    OUTLINED_FLAG_OUTLINED = 0x114E5
    OUTLINED_FLAG_ROUNDED = 0x114E6
    OUTLINED_FLAG_SHARP = 0x114E7
    OUTPUT = 0x114E8
    OUTPUT_OUTLINED = 0x114E9
    OUTPUT_ROUNDED = 0x114EA
    OUTPUT_SHARP = 0x114EB
    PADDING = 0x114EC
    PADDING_OUTLINED = 0x114ED
    PADDING_ROUNDED = 0x114EE
    PADDING_SHARP = 0x114EF
    PAGES = 0x114F0
    PAGES_OUTLINED = 0x114F1
    PAGES_ROUNDED = 0x114F2
    PAGES_SHARP = 0x114F3
    PAGEVIEW = 0x114F4
    PAGEVIEW_OUTLINED = 0x114F5
    PAGEVIEW_ROUNDED = 0x114F6
    PAGEVIEW_SHARP = 0x114F7
    PAID = 0x114F8
    PAID_OUTLINED = 0x114F9
    PAID_ROUNDED = 0x114FA
    PAID_SHARP = 0x114FB
    PALETTE = 0x114FC
    PALETTE_OUTLINED = 0x114FD
    PALETTE_ROUNDED = 0x114FE
    PALETTE_SHARP = 0x114FF
    PALLET = 0x11500
    PAN_TOOL = 0x11501
    PAN_TOOL_ALT = 0x11502
    PAN_TOOL_ALT_OUTLINED = 0x11503
    PAN_TOOL_ALT_ROUNDED = 0x11504
    PAN_TOOL_ALT_SHARP = 0x11505
    PAN_TOOL_OUTLINED = 0x11506
    PAN_TOOL_ROUNDED = 0x11507
    PAN_TOOL_SHARP = 0x11508
    PANORAMA = 0x11509
    PANORAMA_FISH_EYE = 0x1150A
    PANORAMA_FISH_EYE_OUTLINED = 0x1150B
    PANORAMA_FISH_EYE_ROUNDED = 0x1150C
    PANORAMA_FISH_EYE_SHARP = 0x1150D
    PANORAMA_FISHEYE = 0x1150E
    PANORAMA_FISHEYE_OUTLINED = 0x1150F
    PANORAMA_FISHEYE_ROUNDED = 0x11510
    PANORAMA_FISHEYE_SHARP = 0x11511
    PANORAMA_HORIZONTAL = 0x11512
    PANORAMA_HORIZONTAL_OUTLINED = 0x11513
    PANORAMA_HORIZONTAL_ROUNDED = 0x11514
    PANORAMA_HORIZONTAL_SELECT = 0x11515
    PANORAMA_HORIZONTAL_SELECT_OUTLINED = 0x11516
    PANORAMA_HORIZONTAL_SELECT_ROUNDED = 0x11517
    PANORAMA_HORIZONTAL_SELECT_SHARP = 0x11518
    PANORAMA_HORIZONTAL_SHARP = 0x11519
    PANORAMA_OUTLINED = 0x1151A
    PANORAMA_PHOTOSPHERE = 0x1151B
    PANORAMA_PHOTOSPHERE_OUTLINED = 0x1151C
    PANORAMA_PHOTOSPHERE_ROUNDED = 0x1151D
    PANORAMA_PHOTOSPHERE_SELECT = 0x1151E
    PANORAMA_PHOTOSPHERE_SELECT_OUTLINED = 0x1151F
    PANORAMA_PHOTOSPHERE_SELECT_ROUNDED = 0x11520
    PANORAMA_PHOTOSPHERE_SELECT_SHARP = 0x11521
    PANORAMA_PHOTOSPHERE_SHARP = 0x11522
    PANORAMA_ROUNDED = 0x11523
    PANORAMA_SHARP = 0x11524
    PANORAMA_VERTICAL = 0x11525
    PANORAMA_VERTICAL_OUTLINED = 0x11526
    PANORAMA_VERTICAL_ROUNDED = 0x11527
    PANORAMA_VERTICAL_SELECT = 0x11528
    PANORAMA_VERTICAL_SELECT_OUTLINED = 0x11529
    PANORAMA_VERTICAL_SELECT_ROUNDED = 0x1152A
    PANORAMA_VERTICAL_SELECT_SHARP = 0x1152B
    PANORAMA_VERTICAL_SHARP = 0x1152C
    PANORAMA_WIDE_ANGLE = 0x1152D
    PANORAMA_WIDE_ANGLE_OUTLINED = 0x1152E
    PANORAMA_WIDE_ANGLE_ROUNDED = 0x1152F
    PANORAMA_WIDE_ANGLE_SELECT = 0x11530
    PANORAMA_WIDE_ANGLE_SELECT_OUTLINED = 0x11531
    PANORAMA_WIDE_ANGLE_SELECT_ROUNDED = 0x11532
    PANORAMA_WIDE_ANGLE_SELECT_SHARP = 0x11533
    PANORAMA_WIDE_ANGLE_SHARP = 0x11534
    PARAGLIDING = 0x11535
    PARAGLIDING_OUTLINED = 0x11536
    PARAGLIDING_ROUNDED = 0x11537
    PARAGLIDING_SHARP = 0x11538
    PARK = 0x11539
    PARK_OUTLINED = 0x1153A
    PARK_ROUNDED = 0x1153B
    PARK_SHARP = 0x1153C
    PARTY_MODE = 0x1153D
    PARTY_MODE_OUTLINED = 0x1153E
    PARTY_MODE_ROUNDED = 0x1153F
    PARTY_MODE_SHARP = 0x11540
    PASSWORD = 0x11541
    PASSWORD_OUTLINED = 0x11542
    PASSWORD_ROUNDED = 0x11543
    PASSWORD_SHARP = 0x11544
    PASTE = 0x11545
    PASTE_OUTLINED = 0x11546
    PASTE_ROUNDED = 0x11547
    PASTE_SHARP = 0x11548
    PATTERN = 0x11549
    PATTERN_OUTLINED = 0x1154A
    PATTERN_ROUNDED = 0x1154B
    PATTERN_SHARP = 0x1154C
    PAUSE = 0x1154D
    PAUSE_CIRCLE = 0x1154E
    PAUSE_CIRCLE_FILLED = 0x1154F
    PAUSE_CIRCLE_FILLED_OUTLINED = 0x11550
    PAUSE_CIRCLE_FILLED_ROUNDED = 0x11551
    PAUSE_CIRCLE_FILLED_SHARP = 0x11552
    PAUSE_CIRCLE_OUTLINE = 0x11553
    PAUSE_CIRCLE_OUTLINE_OUTLINED = 0x11554
    PAUSE_CIRCLE_OUTLINE_ROUNDED = 0x11555
    PAUSE_CIRCLE_OUTLINE_SHARP = 0x11556
    PAUSE_CIRCLE_OUTLINED = 0x11557
    PAUSE_CIRCLE_ROUNDED = 0x11558
    PAUSE_CIRCLE_SHARP = 0x11559
    PAUSE_OUTLINED = 0x1155A
    PAUSE_PRESENTATION = 0x1155B
    PAUSE_PRESENTATION_OUTLINED = 0x1155C
    PAUSE_PRESENTATION_ROUNDED = 0x1155D
    PAUSE_PRESENTATION_SHARP = 0x1155E
    PAUSE_ROUNDED = 0x1155F
    PAUSE_SHARP = 0x11560
    PAYMENT = 0x11561
    PAYMENT_OUTLINED = 0x11562
    PAYMENT_ROUNDED = 0x11563
    PAYMENT_SHARP = 0x11564
    PAYMENTS = 0x11565
    PAYMENTS_OUTLINED = 0x11566
    PAYMENTS_ROUNDED = 0x11567
    PAYMENTS_SHARP = 0x11568
    PAYPAL = 0x11569
    PAYPAL_OUTLINED = 0x1156A
    PAYPAL_ROUNDED = 0x1156B
    PAYPAL_SHARP = 0x1156C
    PEDAL_BIKE = 0x1156D
    PEDAL_BIKE_OUTLINED = 0x1156E
    PEDAL_BIKE_ROUNDED = 0x1156F
    PEDAL_BIKE_SHARP = 0x11570
    PENDING = 0x11571
    PENDING_ACTIONS = 0x11572
    PENDING_ACTIONS_OUTLINED = 0x11573
    PENDING_ACTIONS_ROUNDED = 0x11574
    PENDING_ACTIONS_SHARP = 0x11575
    PENDING_OUTLINED = 0x11576
    PENDING_ROUNDED = 0x11577
    PENDING_SHARP = 0x11578
    PENTAGON = 0x11579
    PENTAGON_OUTLINED = 0x1157A
    PENTAGON_ROUNDED = 0x1157B
    PENTAGON_SHARP = 0x1157C
    PEOPLE = 0x1157D
    PEOPLE_ALT = 0x1157E
    PEOPLE_ALT_OUTLINED = 0x1157F
    PEOPLE_ALT_ROUNDED = 0x11580
    PEOPLE_ALT_SHARP = 0x11581
    PEOPLE_OUTLINE = 0x11582
    PEOPLE_OUTLINE_OUTLINED = 0x11583
    PEOPLE_OUTLINE_ROUNDED = 0x11584
    PEOPLE_OUTLINE_SHARP = 0x11585
    PEOPLE_OUTLINED = 0x11586
    PEOPLE_ROUNDED = 0x11587
    PEOPLE_SHARP = 0x11588
    PERCENT = 0x11589
    PERCENT_OUTLINED = 0x1158A
    PERCENT_ROUNDED = 0x1158B
    PERCENT_SHARP = 0x1158C
    PERM_CAMERA_MIC = 0x1158D
    PERM_CAMERA_MIC_OUTLINED = 0x1158E
    PERM_CAMERA_MIC_ROUNDED = 0x1158F
    PERM_CAMERA_MIC_SHARP = 0x11590
    PERM_CONTACT_CAL = 0x11591
    PERM_CONTACT_CAL_OUTLINED = 0x11592
    PERM_CONTACT_CAL_ROUNDED = 0x11593
    PERM_CONTACT_CAL_SHARP = 0x11594
    PERM_CONTACT_CALENDAR = 0x11595
    PERM_CONTACT_CALENDAR_OUTLINED = 0x11596
    PERM_CONTACT_CALENDAR_ROUNDED = 0x11597
    PERM_CONTACT_CALENDAR_SHARP = 0x11598
    PERM_DATA_SETTING = 0x11599
    PERM_DATA_SETTING_OUTLINED = 0x1159A
    PERM_DATA_SETTING_ROUNDED = 0x1159B
    PERM_DATA_SETTING_SHARP = 0x1159C
    PERM_DEVICE_INFO = 0x1159D
    PERM_DEVICE_INFO_OUTLINED = 0x1159E
    PERM_DEVICE_INFO_ROUNDED = 0x1159F
    PERM_DEVICE_INFO_SHARP = 0x115A0
    PERM_DEVICE_INFORMATION = 0x115A1
    PERM_DEVICE_INFORMATION_OUTLINED = 0x115A2
    PERM_DEVICE_INFORMATION_ROUNDED = 0x115A3
    PERM_DEVICE_INFORMATION_SHARP = 0x115A4
    PERM_IDENTITY = 0x115A5
    PERM_IDENTITY_OUTLINED = 0x115A6
    PERM_IDENTITY_ROUNDED = 0x115A7
    PERM_IDENTITY_SHARP = 0x115A8
    PERM_MEDIA = 0x115A9
    PERM_MEDIA_OUTLINED = 0x115AA
    PERM_MEDIA_ROUNDED = 0x115AB
    PERM_MEDIA_SHARP = 0x115AC
    PERM_PHONE_MSG = 0x115AD
    PERM_PHONE_MSG_OUTLINED = 0x115AE
    PERM_PHONE_MSG_ROUNDED = 0x115AF
    PERM_PHONE_MSG_SHARP = 0x115B0
    PERM_SCAN_WIFI = 0x115B1
    PERM_SCAN_WIFI_OUTLINED = 0x115B2
    PERM_SCAN_WIFI_ROUNDED = 0x115B3
    PERM_SCAN_WIFI_SHARP = 0x115B4
    PERSON = 0x115B5
    PERSON_2 = 0x115B6
    PERSON_2_OUTLINED = 0x115B7
    PERSON_2_ROUNDED = 0x115B8
    PERSON_2_SHARP = 0x115B9
    PERSON_3 = 0x115BA
    PERSON_3_OUTLINED = 0x115BB
    PERSON_3_ROUNDED = 0x115BC
    PERSON_3_SHARP = 0x115BD
    PERSON_4 = 0x115BE
    PERSON_4_OUTLINED = 0x115BF
    PERSON_4_ROUNDED = 0x115C0
    PERSON_4_SHARP = 0x115C1
    PERSON_ADD = 0x115C2
    PERSON_ADD_ALT = 0x115C3
    PERSON_ADD_ALT_1 = 0x115C4
    PERSON_ADD_ALT_1_OUTLINED = 0x115C5
    PERSON_ADD_ALT_1_ROUNDED = 0x115C6
    PERSON_ADD_ALT_1_SHARP = 0x115C7
    PERSON_ADD_ALT_OUTLINED = 0x115C8
    PERSON_ADD_ALT_ROUNDED = 0x115C9
    PERSON_ADD_ALT_SHARP = 0x115CA
    PERSON_ADD_DISABLED = 0x115CB
    PERSON_ADD_DISABLED_OUTLINED = 0x115CC
    PERSON_ADD_DISABLED_ROUNDED = 0x115CD
    PERSON_ADD_DISABLED_SHARP = 0x115CE
    PERSON_ADD_OUTLINED = 0x115CF
    PERSON_ADD_ROUNDED = 0x115D0
    PERSON_ADD_SHARP = 0x115D1
    PERSON_OFF = 0x115D2
    PERSON_OFF_OUTLINED = 0x115D3
    PERSON_OFF_ROUNDED = 0x115D4
    PERSON_OFF_SHARP = 0x115D5
    PERSON_OUTLINE = 0x115D6
    PERSON_OUTLINE_OUTLINED = 0x115D7
    PERSON_OUTLINE_ROUNDED = 0x115D8
    PERSON_OUTLINE_SHARP = 0x115D9
    PERSON_OUTLINED = 0x115DA
    PERSON_PIN = 0x115DB
    PERSON_PIN_CIRCLE = 0x115DC
    PERSON_PIN_CIRCLE_OUTLINED = 0x115DD
    PERSON_PIN_CIRCLE_ROUNDED = 0x115DE
    PERSON_PIN_CIRCLE_SHARP = 0x115DF
    PERSON_PIN_OUTLINED = 0x115E0
    PERSON_PIN_ROUNDED = 0x115E1
    PERSON_PIN_SHARP = 0x115E2
    PERSON_REMOVE = 0x115E3
    PERSON_REMOVE_ALT_1 = 0x115E4
    PERSON_REMOVE_ALT_1_OUTLINED = 0x115E5
    PERSON_REMOVE_ALT_1_ROUNDED = 0x115E6
    PERSON_REMOVE_ALT_1_SHARP = 0x115E7
    PERSON_REMOVE_OUTLINED = 0x115E8
    PERSON_REMOVE_ROUNDED = 0x115E9
    PERSON_REMOVE_SHARP = 0x115EA
    PERSON_ROUNDED = 0x115EB
    PERSON_SEARCH = 0x115EC
    PERSON_SEARCH_OUTLINED = 0x115ED
    PERSON_SEARCH_ROUNDED = 0x115EE
    PERSON_SEARCH_SHARP = 0x115EF
    PERSON_SHARP = 0x115F0
    PERSONAL_INJURY = 0x115F1
    PERSONAL_INJURY_OUTLINED = 0x115F2
    PERSONAL_INJURY_ROUNDED = 0x115F3
    PERSONAL_INJURY_SHARP = 0x115F4
    PERSONAL_VIDEO = 0x115F5
    PERSONAL_VIDEO_OUTLINED = 0x115F6
    PERSONAL_VIDEO_ROUNDED = 0x115F7
    PERSONAL_VIDEO_SHARP = 0x115F8
    PEST_CONTROL = 0x115F9
    PEST_CONTROL_OUTLINED = 0x115FA
    PEST_CONTROL_RODENT = 0x115FB
    PEST_CONTROL_RODENT_OUTLINED = 0x115FC
    PEST_CONTROL_RODENT_ROUNDED = 0x115FD
    PEST_CONTROL_RODENT_SHARP = 0x115FE
    PEST_CONTROL_ROUNDED = 0x115FF
    PEST_CONTROL_SHARP = 0x11600
    PETS = 0x11601
    PETS_OUTLINED = 0x11602
    PETS_ROUNDED = 0x11603
    PETS_SHARP = 0x11604
    PHISHING = 0x11605
    PHISHING_OUTLINED = 0x11606
    PHISHING_ROUNDED = 0x11607
    PHISHING_SHARP = 0x11608
    PHONE = 0x11609
    PHONE_ANDROID = 0x1160A
    PHONE_ANDROID_OUTLINED = 0x1160B
    PHONE_ANDROID_ROUNDED = 0x1160C
    PHONE_ANDROID_SHARP = 0x1160D
    PHONE_BLUETOOTH_SPEAKER = 0x1160E
    PHONE_BLUETOOTH_SPEAKER_OUTLINED = 0x1160F
    PHONE_BLUETOOTH_SPEAKER_ROUNDED = 0x11610
    PHONE_BLUETOOTH_SPEAKER_SHARP = 0x11611
    PHONE_CALLBACK = 0x11612
    PHONE_CALLBACK_OUTLINED = 0x11613
    PHONE_CALLBACK_ROUNDED = 0x11614
    PHONE_CALLBACK_SHARP = 0x11615
    PHONE_DISABLED = 0x11616
    PHONE_DISABLED_OUTLINED = 0x11617
    PHONE_DISABLED_ROUNDED = 0x11618
    PHONE_DISABLED_SHARP = 0x11619
    PHONE_ENABLED = 0x1161A
    PHONE_ENABLED_OUTLINED = 0x1161B
    PHONE_ENABLED_ROUNDED = 0x1161C
    PHONE_ENABLED_SHARP = 0x1161D
    PHONE_FORWARDED = 0x1161E
    PHONE_FORWARDED_OUTLINED = 0x1161F
    PHONE_FORWARDED_ROUNDED = 0x11620
    PHONE_FORWARDED_SHARP = 0x11621
    PHONE_IN_TALK = 0x11622
    PHONE_IN_TALK_OUTLINED = 0x11623
    PHONE_IN_TALK_ROUNDED = 0x11624
    PHONE_IN_TALK_SHARP = 0x11625
    PHONE_IPHONE = 0x11626
    PHONE_IPHONE_OUTLINED = 0x11627
    PHONE_IPHONE_ROUNDED = 0x11628
    PHONE_IPHONE_SHARP = 0x11629
    PHONE_LOCKED = 0x1162A
    PHONE_LOCKED_OUTLINED = 0x1162B
    PHONE_LOCKED_ROUNDED = 0x1162C
    PHONE_LOCKED_SHARP = 0x1162D
    PHONE_MISSED = 0x1162E
    PHONE_MISSED_OUTLINED = 0x1162F
    PHONE_MISSED_ROUNDED = 0x11630
    PHONE_MISSED_SHARP = 0x11631
    PHONE_OUTLINED = 0x11632
    PHONE_PAUSED = 0x11633
    PHONE_PAUSED_OUTLINED = 0x11634
    PHONE_PAUSED_ROUNDED = 0x11635
    PHONE_PAUSED_SHARP = 0x11636
    PHONE_ROUNDED = 0x11637
    PHONE_SHARP = 0x11638
    PHONELINK = 0x11639
    PHONELINK_ERASE = 0x1163A
    PHONELINK_ERASE_OUTLINED = 0x1163B
    PHONELINK_ERASE_ROUNDED = 0x1163C
    PHONELINK_ERASE_SHARP = 0x1163D
    PHONELINK_LOCK = 0x1163E
    PHONELINK_LOCK_OUTLINED = 0x1163F
    PHONELINK_LOCK_ROUNDED = 0x11640
    PHONELINK_LOCK_SHARP = 0x11641
    PHONELINK_OFF = 0x11642
    PHONELINK_OFF_OUTLINED = 0x11643
    PHONELINK_OFF_ROUNDED = 0x11644
    PHONELINK_OFF_SHARP = 0x11645
    PHONELINK_OUTLINED = 0x11646
    PHONELINK_RING = 0x11647
    PHONELINK_RING_OUTLINED = 0x11648
    PHONELINK_RING_ROUNDED = 0x11649
    PHONELINK_RING_SHARP = 0x1164A
    PHONELINK_ROUNDED = 0x1164B
    PHONELINK_SETUP = 0x1164C
    PHONELINK_SETUP_OUTLINED = 0x1164D
    PHONELINK_SETUP_ROUNDED = 0x1164E
    PHONELINK_SETUP_SHARP = 0x1164F
    PHONELINK_SHARP = 0x11650
    PHOTO = 0x11651
    PHOTO_ALBUM = 0x11652
    PHOTO_ALBUM_OUTLINED = 0x11653
    PHOTO_ALBUM_ROUNDED = 0x11654
    PHOTO_ALBUM_SHARP = 0x11655
    PHOTO_CAMERA = 0x11656
    PHOTO_CAMERA_BACK = 0x11657
    PHOTO_CAMERA_BACK_OUTLINED = 0x11658
    PHOTO_CAMERA_BACK_ROUNDED = 0x11659
    PHOTO_CAMERA_BACK_SHARP = 0x1165A
    PHOTO_CAMERA_FRONT = 0x1165B
    PHOTO_CAMERA_FRONT_OUTLINED = 0x1165C
    PHOTO_CAMERA_FRONT_ROUNDED = 0x1165D
    PHOTO_CAMERA_FRONT_SHARP = 0x1165E
    PHOTO_CAMERA_OUTLINED = 0x1165F
    PHOTO_CAMERA_ROUNDED = 0x11660
    PHOTO_CAMERA_SHARP = 0x11661
    PHOTO_FILTER = 0x11662
    PHOTO_FILTER_OUTLINED = 0x11663
    PHOTO_FILTER_ROUNDED = 0x11664
    PHOTO_FILTER_SHARP = 0x11665
    PHOTO_LIBRARY = 0x11666
    PHOTO_LIBRARY_OUTLINED = 0x11667
    PHOTO_LIBRARY_ROUNDED = 0x11668
    PHOTO_LIBRARY_SHARP = 0x11669
    PHOTO_OUTLINED = 0x1166A
    PHOTO_ROUNDED = 0x1166B
    PHOTO_SHARP = 0x1166C
    PHOTO_SIZE_SELECT_ACTUAL = 0x1166D
    PHOTO_SIZE_SELECT_ACTUAL_OUTLINED = 0x1166E
    PHOTO_SIZE_SELECT_ACTUAL_ROUNDED = 0x1166F
    PHOTO_SIZE_SELECT_ACTUAL_SHARP = 0x11670
    PHOTO_SIZE_SELECT_LARGE = 0x11671
    PHOTO_SIZE_SELECT_LARGE_OUTLINED = 0x11672
    PHOTO_SIZE_SELECT_LARGE_ROUNDED = 0x11673
    PHOTO_SIZE_SELECT_LARGE_SHARP = 0x11674
    PHOTO_SIZE_SELECT_SMALL = 0x11675
    PHOTO_SIZE_SELECT_SMALL_OUTLINED = 0x11676
    PHOTO_SIZE_SELECT_SMALL_ROUNDED = 0x11677
    PHOTO_SIZE_SELECT_SMALL_SHARP = 0x11678
    PHP = 0x11679
    PHP_OUTLINED = 0x1167A
    PHP_ROUNDED = 0x1167B
    PHP_SHARP = 0x1167C
    PIANO = 0x1167D
    PIANO_OFF = 0x1167E
    PIANO_OFF_OUTLINED = 0x1167F
    PIANO_OFF_ROUNDED = 0x11680
    PIANO_OFF_SHARP = 0x11681
    PIANO_OUTLINED = 0x11682
    PIANO_ROUNDED = 0x11683
    PIANO_SHARP = 0x11684
    PICTURE_AS_PDF = 0x11685
    PICTURE_AS_PDF_OUTLINED = 0x11686
    PICTURE_AS_PDF_ROUNDED = 0x11687
    PICTURE_AS_PDF_SHARP = 0x11688
    PICTURE_IN_PICTURE = 0x11689
    PICTURE_IN_PICTURE_ALT = 0x1168A
    PICTURE_IN_PICTURE_ALT_OUTLINED = 0x1168B
    PICTURE_IN_PICTURE_ALT_ROUNDED = 0x1168C
    PICTURE_IN_PICTURE_ALT_SHARP = 0x1168D
    PICTURE_IN_PICTURE_OUTLINED = 0x1168E
    PICTURE_IN_PICTURE_ROUNDED = 0x1168F
    PICTURE_IN_PICTURE_SHARP = 0x11690
    PIE_CHART = 0x11691
    PIE_CHART_OUTLINE = 0x11692
    PIE_CHART_OUTLINE_OUTLINED = 0x11693
    PIE_CHART_OUTLINE_ROUNDED = 0x11694
    PIE_CHART_OUTLINE_SHARP = 0x11695
    PIE_CHART_ROUNDED = 0x11696
    PIE_CHART_SHARP = 0x11697
    PIN = 0x11698
    PIN_DROP = 0x11699
    PIN_DROP_OUTLINED = 0x1169A
    PIN_DROP_ROUNDED = 0x1169B
    PIN_DROP_SHARP = 0x1169C
    PIN_END = 0x1169D
    PIN_END_OUTLINED = 0x1169E
    PIN_END_ROUNDED = 0x1169F
    PIN_END_SHARP = 0x116A0
    PIN_INVOKE = 0x116A1
    PIN_INVOKE_OUTLINED = 0x116A2
    PIN_INVOKE_ROUNDED = 0x116A3
    PIN_INVOKE_SHARP = 0x116A4
    PIN_OUTLINED = 0x116A5
    PIN_ROUNDED = 0x116A6
    PIN_SHARP = 0x116A7
    PINCH = 0x116A8
    PINCH_OUTLINED = 0x116A9
    PINCH_ROUNDED = 0x116AA
    PINCH_SHARP = 0x116AB
    PIVOT_TABLE_CHART = 0x116AC
    PIVOT_TABLE_CHART_OUTLINED = 0x116AD
    PIVOT_TABLE_CHART_ROUNDED = 0x116AE
    PIVOT_TABLE_CHART_SHARP = 0x116AF
    PIX = 0x116B0
    PIX_OUTLINED = 0x116B1
    PIX_ROUNDED = 0x116B2
    PIX_SHARP = 0x116B3
    PLACE = 0x116B4
    PLACE_OUTLINED = 0x116B5
    PLACE_ROUNDED = 0x116B6
    PLACE_SHARP = 0x116B7
    PLAGIARISM = 0x116B8
    PLAGIARISM_OUTLINED = 0x116B9
    PLAGIARISM_ROUNDED = 0x116BA
    PLAGIARISM_SHARP = 0x116BB
    PLAY_ARROW = 0x116BC
    PLAY_ARROW_OUTLINED = 0x116BD
    PLAY_ARROW_ROUNDED = 0x116BE
    PLAY_ARROW_SHARP = 0x116BF
    PLAY_CIRCLE = 0x116C0
    PLAY_CIRCLE_FILL = 0x116C1
    PLAY_CIRCLE_FILL_OUTLINED = 0x116C2
    PLAY_CIRCLE_FILL_ROUNDED = 0x116C3
    PLAY_CIRCLE_FILL_SHARP = 0x116C4
    PLAY_CIRCLE_FILLED = 0x116C5
    PLAY_CIRCLE_FILLED_OUTLINED = 0x116C6
    PLAY_CIRCLE_FILLED_ROUNDED = 0x116C7
    PLAY_CIRCLE_FILLED_SHARP = 0x116C8
    PLAY_CIRCLE_OUTLINE = 0x116C9
    PLAY_CIRCLE_OUTLINE_OUTLINED = 0x116CA
    PLAY_CIRCLE_OUTLINE_ROUNDED = 0x116CB
    PLAY_CIRCLE_OUTLINE_SHARP = 0x116CC
    PLAY_CIRCLE_OUTLINED = 0x116CD
    PLAY_CIRCLE_ROUNDED = 0x116CE
    PLAY_CIRCLE_SHARP = 0x116CF
    PLAY_DISABLED = 0x116D0
    PLAY_DISABLED_OUTLINED = 0x116D1
    PLAY_DISABLED_ROUNDED = 0x116D2
    PLAY_DISABLED_SHARP = 0x116D3
    PLAY_FOR_WORK = 0x116D4
    PLAY_FOR_WORK_OUTLINED = 0x116D5
    PLAY_FOR_WORK_ROUNDED = 0x116D6
    PLAY_FOR_WORK_SHARP = 0x116D7
    PLAY_LESSON = 0x116D8
    PLAY_LESSON_OUTLINED = 0x116D9
    PLAY_LESSON_ROUNDED = 0x116DA
    PLAY_LESSON_SHARP = 0x116DB
    PLAYLIST_ADD = 0x116DC
    PLAYLIST_ADD_CHECK = 0x116DD
    PLAYLIST_ADD_CHECK_CIRCLE = 0x116DE
    PLAYLIST_ADD_CHECK_CIRCLE_OUTLINED = 0x116DF
    PLAYLIST_ADD_CHECK_CIRCLE_ROUNDED = 0x116E0
    PLAYLIST_ADD_CHECK_CIRCLE_SHARP = 0x116E1
    PLAYLIST_ADD_CHECK_OUTLINED = 0x116E2
    PLAYLIST_ADD_CHECK_ROUNDED = 0x116E3
    PLAYLIST_ADD_CHECK_SHARP = 0x116E4
    PLAYLIST_ADD_CIRCLE = 0x116E5
    PLAYLIST_ADD_CIRCLE_OUTLINED = 0x116E6
    PLAYLIST_ADD_CIRCLE_ROUNDED = 0x116E7
    PLAYLIST_ADD_CIRCLE_SHARP = 0x116E8
    PLAYLIST_ADD_OUTLINED = 0x116E9
    PLAYLIST_ADD_ROUNDED = 0x116EA
    PLAYLIST_ADD_SHARP = 0x116EB
    PLAYLIST_PLAY = 0x116EC
    PLAYLIST_PLAY_OUTLINED = 0x116ED
    PLAYLIST_PLAY_ROUNDED = 0x116EE
    PLAYLIST_PLAY_SHARP = 0x116EF
    PLAYLIST_REMOVE = 0x116F0
    PLAYLIST_REMOVE_OUTLINED = 0x116F1
    PLAYLIST_REMOVE_ROUNDED = 0x116F2
    PLAYLIST_REMOVE_SHARP = 0x116F3
    PLUMBING = 0x116F4
    PLUMBING_OUTLINED = 0x116F5
    PLUMBING_ROUNDED = 0x116F6
    PLUMBING_SHARP = 0x116F7
    PLUS_ONE = 0x116F8
    PLUS_ONE_OUTLINED = 0x116F9
    PLUS_ONE_ROUNDED = 0x116FA
    PLUS_ONE_SHARP = 0x116FB
    PODCASTS = 0x116FC
    PODCASTS_OUTLINED = 0x116FD
    PODCASTS_ROUNDED = 0x116FE
    PODCASTS_SHARP = 0x116FF
    POINT_OF_SALE = 0x11700
    POINT_OF_SALE_OUTLINED = 0x11701
    POINT_OF_SALE_ROUNDED = 0x11702
    POINT_OF_SALE_SHARP = 0x11703
    POLICY = 0x11704
    POLICY_OUTLINED = 0x11705
    POLICY_ROUNDED = 0x11706
    POLICY_SHARP = 0x11707
    POLL = 0x11708
    POLL_OUTLINED = 0x11709
    POLL_ROUNDED = 0x1170A
    POLL_SHARP = 0x1170B
    POLYLINE = 0x1170C
    POLYLINE_OUTLINED = 0x1170D
    POLYLINE_ROUNDED = 0x1170E
    POLYLINE_SHARP = 0x1170F
    POLYMER = 0x11710
    POLYMER_OUTLINED = 0x11711
    POLYMER_ROUNDED = 0x11712
    POLYMER_SHARP = 0x11713
    POOL = 0x11714
    POOL_OUTLINED = 0x11715
    POOL_ROUNDED = 0x11716
    POOL_SHARP = 0x11717
    PORTABLE_WIFI_OFF = 0x11718
    PORTABLE_WIFI_OFF_OUTLINED = 0x11719
    PORTABLE_WIFI_OFF_ROUNDED = 0x1171A
    PORTABLE_WIFI_OFF_SHARP = 0x1171B
    PORTRAIT = 0x1171C
    PORTRAIT_OUTLINED = 0x1171D
    PORTRAIT_ROUNDED = 0x1171E
    PORTRAIT_SHARP = 0x1171F
    POST_ADD = 0x11720
    POST_ADD_OUTLINED = 0x11721
    POST_ADD_ROUNDED = 0x11722
    POST_ADD_SHARP = 0x11723
    POWER = 0x11724
    POWER_INPUT = 0x11725
    POWER_INPUT_OUTLINED = 0x11726
    POWER_INPUT_ROUNDED = 0x11727
    POWER_INPUT_SHARP = 0x11728
    POWER_OFF = 0x11729
    POWER_OFF_OUTLINED = 0x1172A
    POWER_OFF_ROUNDED = 0x1172B
    POWER_OFF_SHARP = 0x1172C
    POWER_OUTLINED = 0x1172D
    POWER_ROUNDED = 0x1172E
    POWER_SETTINGS_NEW = 0x1172F
    POWER_SETTINGS_NEW_OUTLINED = 0x11730
    POWER_SETTINGS_NEW_ROUNDED = 0x11731
    POWER_SETTINGS_NEW_SHARP = 0x11732
    POWER_SHARP = 0x11733
    PRECISION_MANUFACTURING = 0x11734
    PRECISION_MANUFACTURING_OUTLINED = 0x11735
    PRECISION_MANUFACTURING_ROUNDED = 0x11736
    PRECISION_MANUFACTURING_SHARP = 0x11737
    PREGNANT_WOMAN = 0x11738
    PREGNANT_WOMAN_OUTLINED = 0x11739
    PREGNANT_WOMAN_ROUNDED = 0x1173A
    PREGNANT_WOMAN_SHARP = 0x1173B
    PRESENT_TO_ALL = 0x1173C
    PRESENT_TO_ALL_OUTLINED = 0x1173D
    PRESENT_TO_ALL_ROUNDED = 0x1173E
    PRESENT_TO_ALL_SHARP = 0x1173F
    PREVIEW = 0x11740
    PREVIEW_OUTLINED = 0x11741
    PREVIEW_ROUNDED = 0x11742
    PREVIEW_SHARP = 0x11743
    PRICE_CHANGE = 0x11744
    PRICE_CHANGE_OUTLINED = 0x11745
    PRICE_CHANGE_ROUNDED = 0x11746
    PRICE_CHANGE_SHARP = 0x11747
    PRICE_CHECK = 0x11748
    PRICE_CHECK_OUTLINED = 0x11749
    PRICE_CHECK_ROUNDED = 0x1174A
    PRICE_CHECK_SHARP = 0x1174B
    PRINT = 0x1174C
    PRINT_DISABLED = 0x1174D
    PRINT_DISABLED_OUTLINED = 0x1174E
    PRINT_DISABLED_ROUNDED = 0x1174F
    PRINT_DISABLED_SHARP = 0x11750
    PRINT_OUTLINED = 0x11751
    PRINT_ROUNDED = 0x11752
    PRINT_SHARP = 0x11753
    PRIORITY_HIGH = 0x11754
    PRIORITY_HIGH_OUTLINED = 0x11755
    PRIORITY_HIGH_ROUNDED = 0x11756
    PRIORITY_HIGH_SHARP = 0x11757
    PRIVACY_TIP = 0x11758
    PRIVACY_TIP_OUTLINED = 0x11759
    PRIVACY_TIP_ROUNDED = 0x1175A
    PRIVACY_TIP_SHARP = 0x1175B
    PRIVATE_CONNECTIVITY = 0x1175C
    PRIVATE_CONNECTIVITY_OUTLINED = 0x1175D
    PRIVATE_CONNECTIVITY_ROUNDED = 0x1175E
    PRIVATE_CONNECTIVITY_SHARP = 0x1175F
    PRODUCTION_QUANTITY_LIMITS = 0x11760
    PRODUCTION_QUANTITY_LIMITS_OUTLINED = 0x11761
    PRODUCTION_QUANTITY_LIMITS_ROUNDED = 0x11762
    PRODUCTION_QUANTITY_LIMITS_SHARP = 0x11763
    PROPANE = 0x11764
    PROPANE_OUTLINED = 0x11765
    PROPANE_ROUNDED = 0x11766
    PROPANE_SHARP = 0x11767
    PROPANE_TANK = 0x11768
    PROPANE_TANK_OUTLINED = 0x11769
    PROPANE_TANK_ROUNDED = 0x1176A
    PROPANE_TANK_SHARP = 0x1176B
    PSYCHOLOGY = 0x1176C
    PSYCHOLOGY_ALT = 0x1176D
    PSYCHOLOGY_ALT_OUTLINED = 0x1176E
    PSYCHOLOGY_ALT_ROUNDED = 0x1176F
    PSYCHOLOGY_ALT_SHARP = 0x11770
    PSYCHOLOGY_OUTLINED = 0x11771
    PSYCHOLOGY_ROUNDED = 0x11772
    PSYCHOLOGY_SHARP = 0x11773
    PUBLIC = 0x11774
    PUBLIC_OFF = 0x11775
    PUBLIC_OFF_OUTLINED = 0x11776
    PUBLIC_OFF_ROUNDED = 0x11777
    PUBLIC_OFF_SHARP = 0x11778
    PUBLIC_OUTLINED = 0x11779
    PUBLIC_ROUNDED = 0x1177A
    PUBLIC_SHARP = 0x1177B
    PUBLISH = 0x1177C
    PUBLISH_OUTLINED = 0x1177D
    PUBLISH_ROUNDED = 0x1177E
    PUBLISH_SHARP = 0x1177F
    PUBLISHED_WITH_CHANGES = 0x11780
    PUBLISHED_WITH_CHANGES_OUTLINED = 0x11781
    PUBLISHED_WITH_CHANGES_ROUNDED = 0x11782
    PUBLISHED_WITH_CHANGES_SHARP = 0x11783
    PUNCH_CLOCK = 0x11784
    PUNCH_CLOCK_OUTLINED = 0x11785
    PUNCH_CLOCK_ROUNDED = 0x11786
    PUNCH_CLOCK_SHARP = 0x11787
    PUSH_PIN = 0x11788
    PUSH_PIN_OUTLINED = 0x11789
    PUSH_PIN_ROUNDED = 0x1178A
    PUSH_PIN_SHARP = 0x1178B
    QR_CODE = 0x1178C
    QR_CODE_2 = 0x1178D
    QR_CODE_2_OUTLINED = 0x1178E
    QR_CODE_2_ROUNDED = 0x1178F
    QR_CODE_2_SHARP = 0x11790
    QR_CODE_OUTLINED = 0x11791
    QR_CODE_ROUNDED = 0x11792
    QR_CODE_SCANNER = 0x11793
    QR_CODE_SCANNER_OUTLINED = 0x11794
    QR_CODE_SCANNER_ROUNDED = 0x11795
    QR_CODE_SCANNER_SHARP = 0x11796
    QR_CODE_SHARP = 0x11797
    QUERY_BUILDER = 0x11798
    QUERY_BUILDER_OUTLINED = 0x11799
    QUERY_BUILDER_ROUNDED = 0x1179A
    QUERY_BUILDER_SHARP = 0x1179B
    QUERY_STATS = 0x1179C
    QUERY_STATS_OUTLINED = 0x1179D
    QUERY_STATS_ROUNDED = 0x1179E
    QUERY_STATS_SHARP = 0x1179F
    QUESTION_ANSWER = 0x117A0
    QUESTION_ANSWER_OUTLINED = 0x117A1
    QUESTION_ANSWER_ROUNDED = 0x117A2
    QUESTION_ANSWER_SHARP = 0x117A3
    QUESTION_MARK = 0x117A4
    QUESTION_MARK_OUTLINED = 0x117A5
    QUESTION_MARK_ROUNDED = 0x117A6
    QUESTION_MARK_SHARP = 0x117A7
    QUEUE = 0x117A8
    QUEUE_MUSIC = 0x117A9
    QUEUE_MUSIC_OUTLINED = 0x117AA
    QUEUE_MUSIC_ROUNDED = 0x117AB
    QUEUE_MUSIC_SHARP = 0x117AC
    QUEUE_OUTLINED = 0x117AD
    QUEUE_PLAY_NEXT = 0x117AE
    QUEUE_PLAY_NEXT_OUTLINED = 0x117AF
    QUEUE_PLAY_NEXT_ROUNDED = 0x117B0
    QUEUE_PLAY_NEXT_SHARP = 0x117B1
    QUEUE_ROUNDED = 0x117B2
    QUEUE_SHARP = 0x117B3
    QUICK_CONTACTS_DIALER = 0x117B4
    QUICK_CONTACTS_DIALER_OUTLINED = 0x117B5
    QUICK_CONTACTS_DIALER_ROUNDED = 0x117B6
    QUICK_CONTACTS_DIALER_SHARP = 0x117B7
    QUICK_CONTACTS_MAIL = 0x117B8
    QUICK_CONTACTS_MAIL_OUTLINED = 0x117B9
    QUICK_CONTACTS_MAIL_ROUNDED = 0x117BA
    QUICK_CONTACTS_MAIL_SHARP = 0x117BB
    QUICKREPLY = 0x117BC
    QUICKREPLY_OUTLINED = 0x117BD
    QUICKREPLY_ROUNDED = 0x117BE
    QUICKREPLY_SHARP = 0x117BF
    QUIZ = 0x117C0
    QUIZ_OUTLINED = 0x117C1
    QUIZ_ROUNDED = 0x117C2
    QUIZ_SHARP = 0x117C3
    QUORA = 0x117C4
    QUORA_OUTLINED = 0x117C5
    QUORA_ROUNDED = 0x117C6
    QUORA_SHARP = 0x117C7
    R_MOBILEDATA = 0x117C8
    R_MOBILEDATA_OUTLINED = 0x117C9
    R_MOBILEDATA_ROUNDED = 0x117CA
    R_MOBILEDATA_SHARP = 0x117CB
    RADAR = 0x117CC
    RADAR_OUTLINED = 0x117CD
    RADAR_ROUNDED = 0x117CE
    RADAR_SHARP = 0x117CF
    RADIO = 0x117D0
    RADIO_BUTTON_CHECKED = 0x117D1
    RADIO_BUTTON_CHECKED_OUTLINED = 0x117D2
    RADIO_BUTTON_CHECKED_ROUNDED = 0x117D3
    RADIO_BUTTON_CHECKED_SHARP = 0x117D4
    RADIO_BUTTON_OFF = 0x117D5
    RADIO_BUTTON_OFF_OUTLINED = 0x117D6
    RADIO_BUTTON_OFF_ROUNDED = 0x117D7
    RADIO_BUTTON_OFF_SHARP = 0x117D8
    RADIO_BUTTON_ON = 0x117D9
    RADIO_BUTTON_ON_OUTLINED = 0x117DA
    RADIO_BUTTON_ON_ROUNDED = 0x117DB
    RADIO_BUTTON_ON_SHARP = 0x117DC
    RADIO_BUTTON_UNCHECKED = 0x117DD
    RADIO_BUTTON_UNCHECKED_OUTLINED = 0x117DE
    RADIO_BUTTON_UNCHECKED_ROUNDED = 0x117DF
    RADIO_BUTTON_UNCHECKED_SHARP = 0x117E0
    RADIO_OUTLINED = 0x117E1
    RADIO_ROUNDED = 0x117E2
    RADIO_SHARP = 0x117E3
    RAILWAY_ALERT = 0x117E4
    RAILWAY_ALERT_OUTLINED = 0x117E5
    RAILWAY_ALERT_ROUNDED = 0x117E6
    RAILWAY_ALERT_SHARP = 0x117E7
    RAMEN_DINING = 0x117E8
    RAMEN_DINING_OUTLINED = 0x117E9
    RAMEN_DINING_ROUNDED = 0x117EA
    RAMEN_DINING_SHARP = 0x117EB
    RAMP_LEFT = 0x117EC
    RAMP_LEFT_OUTLINED = 0x117ED
    RAMP_LEFT_ROUNDED = 0x117EE
    RAMP_LEFT_SHARP = 0x117EF
    RAMP_RIGHT = 0x117F0
    RAMP_RIGHT_OUTLINED = 0x117F1
    RAMP_RIGHT_ROUNDED = 0x117F2
    RAMP_RIGHT_SHARP = 0x117F3
    RATE_REVIEW = 0x117F4
    RATE_REVIEW_OUTLINED = 0x117F5
    RATE_REVIEW_ROUNDED = 0x117F6
    RATE_REVIEW_SHARP = 0x117F7
    RAW_OFF = 0x117F8
    RAW_OFF_OUTLINED = 0x117F9
    RAW_OFF_ROUNDED = 0x117FA
    RAW_OFF_SHARP = 0x117FB
    RAW_ON = 0x117FC
    RAW_ON_OUTLINED = 0x117FD
    RAW_ON_ROUNDED = 0x117FE
    RAW_ON_SHARP = 0x117FF
    READ_MORE = 0x11800
    READ_MORE_OUTLINED = 0x11801
    READ_MORE_ROUNDED = 0x11802
    READ_MORE_SHARP = 0x11803
    REAL_ESTATE_AGENT = 0x11804
    REAL_ESTATE_AGENT_OUTLINED = 0x11805
    REAL_ESTATE_AGENT_ROUNDED = 0x11806
    REAL_ESTATE_AGENT_SHARP = 0x11807
    REBASE_EDIT = 0x11808
    RECEIPT = 0x11809
    RECEIPT_LONG = 0x1180A
    RECEIPT_LONG_OUTLINED = 0x1180B
    RECEIPT_LONG_ROUNDED = 0x1180C
    RECEIPT_LONG_SHARP = 0x1180D
    RECEIPT_OUTLINED = 0x1180E
    RECEIPT_ROUNDED = 0x1180F
    RECEIPT_SHARP = 0x11810
    RECENT_ACTORS = 0x11811
    RECENT_ACTORS_OUTLINED = 0x11812
    RECENT_ACTORS_ROUNDED = 0x11813
    RECENT_ACTORS_SHARP = 0x11814
    RECOMMEND = 0x11815
    RECOMMEND_OUTLINED = 0x11816
    RECOMMEND_ROUNDED = 0x11817
    RECOMMEND_SHARP = 0x11818
    RECORD_VOICE_OVER = 0x11819
    RECORD_VOICE_OVER_OUTLINED = 0x1181A
    RECORD_VOICE_OVER_ROUNDED = 0x1181B
    RECORD_VOICE_OVER_SHARP = 0x1181C
    RECTANGLE = 0x1181D
    RECTANGLE_OUTLINED = 0x1181E
    RECTANGLE_ROUNDED = 0x1181F
    RECTANGLE_SHARP = 0x11820
    RECYCLING = 0x11821
    RECYCLING_OUTLINED = 0x11822
    RECYCLING_ROUNDED = 0x11823
    RECYCLING_SHARP = 0x11824
    REDDIT = 0x11825
    REDDIT_OUTLINED = 0x11826
    REDDIT_ROUNDED = 0x11827
    REDDIT_SHARP = 0x11828
    REDEEM = 0x11829
    REDEEM_OUTLINED = 0x1182A
    REDEEM_ROUNDED = 0x1182B
    REDEEM_SHARP = 0x1182C
    REDO = 0x1182D
    REDO_OUTLINED = 0x1182E
    REDO_ROUNDED = 0x1182F
    REDO_SHARP = 0x11830
    REDUCE_CAPACITY = 0x11831
    REDUCE_CAPACITY_OUTLINED = 0x11832
    REDUCE_CAPACITY_ROUNDED = 0x11833
    REDUCE_CAPACITY_SHARP = 0x11834
    REFRESH = 0x11835
    REFRESH_OUTLINED = 0x11836
    REFRESH_ROUNDED = 0x11837
    REFRESH_SHARP = 0x11838
    REMEMBER_ME = 0x11839
    REMEMBER_ME_OUTLINED = 0x1183A
    REMEMBER_ME_ROUNDED = 0x1183B
    REMEMBER_ME_SHARP = 0x1183C
    REMOVE = 0x1183D
    REMOVE_CIRCLE = 0x1183E
    REMOVE_CIRCLE_OUTLINE = 0x1183F
    REMOVE_CIRCLE_OUTLINE_OUTLINED = 0x11840
    REMOVE_CIRCLE_OUTLINE_ROUNDED = 0x11841
    REMOVE_CIRCLE_OUTLINE_SHARP = 0x11842
    REMOVE_CIRCLE_OUTLINED = 0x11843
    REMOVE_CIRCLE_ROUNDED = 0x11844
    REMOVE_CIRCLE_SHARP = 0x11845
    REMOVE_DONE = 0x11846
    REMOVE_DONE_OUTLINED = 0x11847
    REMOVE_DONE_ROUNDED = 0x11848
    REMOVE_DONE_SHARP = 0x11849
    REMOVE_FROM_QUEUE = 0x1184A
    REMOVE_FROM_QUEUE_OUTLINED = 0x1184B
    REMOVE_FROM_QUEUE_ROUNDED = 0x1184C
    REMOVE_FROM_QUEUE_SHARP = 0x1184D
    REMOVE_MODERATOR = 0x1184E
    REMOVE_MODERATOR_OUTLINED = 0x1184F
    REMOVE_MODERATOR_ROUNDED = 0x11850
    REMOVE_MODERATOR_SHARP = 0x11851
    REMOVE_OUTLINED = 0x11852
    REMOVE_RED_EYE = 0x11853
    REMOVE_RED_EYE_OUTLINED = 0x11854
    REMOVE_RED_EYE_ROUNDED = 0x11855
    REMOVE_RED_EYE_SHARP = 0x11856
    REMOVE_ROAD = 0x11857
    REMOVE_ROAD_OUTLINED = 0x11858
    REMOVE_ROAD_ROUNDED = 0x11859
    REMOVE_ROAD_SHARP = 0x1185A
    REMOVE_ROUNDED = 0x1185B
    REMOVE_SHARP = 0x1185C
    REMOVE_SHOPPING_CART = 0x1185D
    REMOVE_SHOPPING_CART_OUTLINED = 0x1185E
    REMOVE_SHOPPING_CART_ROUNDED = 0x1185F
    REMOVE_SHOPPING_CART_SHARP = 0x11860
    REORDER = 0x11861
    REORDER_OUTLINED = 0x11862
    REORDER_ROUNDED = 0x11863
    REORDER_SHARP = 0x11864
    REPARTITION = 0x11865
    REPARTITION_OUTLINED = 0x11866
    REPARTITION_ROUNDED = 0x11867
    REPARTITION_SHARP = 0x11868
    REPEAT = 0x11869
    REPEAT_ON = 0x1186A
    REPEAT_ON_OUTLINED = 0x1186B
    REPEAT_ON_ROUNDED = 0x1186C
    REPEAT_ON_SHARP = 0x1186D
    REPEAT_ONE = 0x1186E
    REPEAT_ONE_ON = 0x1186F
    REPEAT_ONE_ON_OUTLINED = 0x11870
    REPEAT_ONE_ON_ROUNDED = 0x11871
    REPEAT_ONE_ON_SHARP = 0x11872
    REPEAT_ONE_OUTLINED = 0x11873
    REPEAT_ONE_ROUNDED = 0x11874
    REPEAT_ONE_SHARP = 0x11875
    REPEAT_OUTLINED = 0x11876
    REPEAT_ROUNDED = 0x11877
    REPEAT_SHARP = 0x11878
    REPLAY = 0x11879
    REPLAY_10 = 0x1187A
    REPLAY_10_OUTLINED = 0x1187B
    REPLAY_10_ROUNDED = 0x1187C
    REPLAY_10_SHARP = 0x1187D
    REPLAY_30 = 0x1187E
    REPLAY_30_OUTLINED = 0x1187F
    REPLAY_30_ROUNDED = 0x11880
    REPLAY_30_SHARP = 0x11881
    REPLAY_5 = 0x11882
    REPLAY_5_OUTLINED = 0x11883
    REPLAY_5_ROUNDED = 0x11884
    REPLAY_5_SHARP = 0x11885
    REPLAY_CIRCLE_FILLED = 0x11886
    REPLAY_CIRCLE_FILLED_OUTLINED = 0x11887
    REPLAY_CIRCLE_FILLED_ROUNDED = 0x11888
    REPLAY_CIRCLE_FILLED_SHARP = 0x11889
    REPLAY_OUTLINED = 0x1188A
    REPLAY_ROUNDED = 0x1188B
    REPLAY_SHARP = 0x1188C
    REPLY = 0x1188D
    REPLY_ALL = 0x1188E
    REPLY_ALL_OUTLINED = 0x1188F
    REPLY_ALL_ROUNDED = 0x11890
    REPLY_ALL_SHARP = 0x11891
    REPLY_OUTLINED = 0x11892
    REPLY_ROUNDED = 0x11893
    REPLY_SHARP = 0x11894
    REPORT = 0x11895
    REPORT_GMAILERRORRED = 0x11896
    REPORT_GMAILERRORRED_OUTLINED = 0x11897
    REPORT_GMAILERRORRED_ROUNDED = 0x11898
    REPORT_GMAILERRORRED_SHARP = 0x11899
    REPORT_OFF = 0x1189A
    REPORT_OFF_OUTLINED = 0x1189B
    REPORT_OFF_ROUNDED = 0x1189C
    REPORT_OFF_SHARP = 0x1189D
    REPORT_OUTLINED = 0x1189E
    REPORT_PROBLEM = 0x1189F
    REPORT_PROBLEM_OUTLINED = 0x118A0
    REPORT_PROBLEM_ROUNDED = 0x118A1
    REPORT_PROBLEM_SHARP = 0x118A2
    REPORT_ROUNDED = 0x118A3
    REPORT_SHARP = 0x118A4
    REQUEST_PAGE = 0x118A5
    REQUEST_PAGE_OUTLINED = 0x118A6
    REQUEST_PAGE_ROUNDED = 0x118A7
    REQUEST_PAGE_SHARP = 0x118A8
    REQUEST_QUOTE = 0x118A9
    REQUEST_QUOTE_OUTLINED = 0x118AA
    REQUEST_QUOTE_ROUNDED = 0x118AB
    REQUEST_QUOTE_SHARP = 0x118AC
    RESET_TV = 0x118AD
    RESET_TV_OUTLINED = 0x118AE
    RESET_TV_ROUNDED = 0x118AF
    RESET_TV_SHARP = 0x118B0
    RESTART_ALT = 0x118B1
    RESTART_ALT_OUTLINED = 0x118B2
    RESTART_ALT_ROUNDED = 0x118B3
    RESTART_ALT_SHARP = 0x118B4
    RESTAURANT = 0x118B5
    RESTAURANT_MENU = 0x118B6
    RESTAURANT_MENU_OUTLINED = 0x118B7
    RESTAURANT_MENU_ROUNDED = 0x118B8
    RESTAURANT_MENU_SHARP = 0x118B9
    RESTAURANT_OUTLINED = 0x118BA
    RESTAURANT_ROUNDED = 0x118BB
    RESTAURANT_SHARP = 0x118BC
    RESTORE = 0x118BD
    RESTORE_FROM_TRASH = 0x118BE
    RESTORE_FROM_TRASH_OUTLINED = 0x118BF
    RESTORE_FROM_TRASH_ROUNDED = 0x118C0
    RESTORE_FROM_TRASH_SHARP = 0x118C1
    RESTORE_OUTLINED = 0x118C2
    RESTORE_PAGE = 0x118C3
    RESTORE_PAGE_OUTLINED = 0x118C4
    RESTORE_PAGE_ROUNDED = 0x118C5
    RESTORE_PAGE_SHARP = 0x118C6
    RESTORE_ROUNDED = 0x118C7
    RESTORE_SHARP = 0x118C8
    REVIEWS = 0x118C9
    REVIEWS_OUTLINED = 0x118CA
    REVIEWS_ROUNDED = 0x118CB
    REVIEWS_SHARP = 0x118CC
    RICE_BOWL = 0x118CD
    RICE_BOWL_OUTLINED = 0x118CE
    RICE_BOWL_ROUNDED = 0x118CF
    RICE_BOWL_SHARP = 0x118D0
    RING_VOLUME = 0x118D1
    RING_VOLUME_OUTLINED = 0x118D2
    RING_VOLUME_ROUNDED = 0x118D3
    RING_VOLUME_SHARP = 0x118D4
    ROCKET = 0x118D5
    ROCKET_LAUNCH = 0x118D6
    ROCKET_LAUNCH_OUTLINED = 0x118D7
    ROCKET_LAUNCH_ROUNDED = 0x118D8
    ROCKET_LAUNCH_SHARP = 0x118D9
    ROCKET_OUTLINED = 0x118DA
    ROCKET_ROUNDED = 0x118DB
    ROCKET_SHARP = 0x118DC
    ROLLER_SHADES = 0x118DD
    ROLLER_SHADES_CLOSED = 0x118DE
    ROLLER_SHADES_CLOSED_OUTLINED = 0x118DF
    ROLLER_SHADES_CLOSED_ROUNDED = 0x118E0
    ROLLER_SHADES_CLOSED_SHARP = 0x118E1
    ROLLER_SHADES_OUTLINED = 0x118E2
    ROLLER_SHADES_ROUNDED = 0x118E3
    ROLLER_SHADES_SHARP = 0x118E4
    ROLLER_SKATING = 0x118E5
    ROLLER_SKATING_OUTLINED = 0x118E6
    ROLLER_SKATING_ROUNDED = 0x118E7
    ROLLER_SKATING_SHARP = 0x118E8
    ROOFING = 0x118E9
    ROOFING_OUTLINED = 0x118EA
    ROOFING_ROUNDED = 0x118EB
    ROOFING_SHARP = 0x118EC
    ROOM = 0x118ED
    ROOM_OUTLINED = 0x118EE
    ROOM_PREFERENCES = 0x118EF
    ROOM_PREFERENCES_OUTLINED = 0x118F0
    ROOM_PREFERENCES_ROUNDED = 0x118F1
    ROOM_PREFERENCES_SHARP = 0x118F2
    ROOM_ROUNDED = 0x118F3
    ROOM_SERVICE = 0x118F4
    ROOM_SERVICE_OUTLINED = 0x118F5
    ROOM_SERVICE_ROUNDED = 0x118F6
    ROOM_SERVICE_SHARP = 0x118F7
    ROOM_SHARP = 0x118F8
    ROTATE_90_DEGREES_CCW = 0x118F9
    ROTATE_90_DEGREES_CCW_OUTLINED = 0x118FA
    ROTATE_90_DEGREES_CCW_ROUNDED = 0x118FB
    ROTATE_90_DEGREES_CCW_SHARP = 0x118FC
    ROTATE_90_DEGREES_CW = 0x118FD
    ROTATE_90_DEGREES_CW_OUTLINED = 0x118FE
    ROTATE_90_DEGREES_CW_ROUNDED = 0x118FF
    ROTATE_90_DEGREES_CW_SHARP = 0x11900
    ROTATE_LEFT = 0x11901
    ROTATE_LEFT_OUTLINED = 0x11902
    ROTATE_LEFT_ROUNDED = 0x11903
    ROTATE_LEFT_SHARP = 0x11904
    ROTATE_RIGHT = 0x11905
    ROTATE_RIGHT_OUTLINED = 0x11906
    ROTATE_RIGHT_ROUNDED = 0x11907
    ROTATE_RIGHT_SHARP = 0x11908
    ROUNDABOUT_LEFT = 0x11909
    ROUNDABOUT_LEFT_OUTLINED = 0x1190A
    ROUNDABOUT_LEFT_ROUNDED = 0x1190B
    ROUNDABOUT_LEFT_SHARP = 0x1190C
    ROUNDABOUT_RIGHT = 0x1190D
    ROUNDABOUT_RIGHT_OUTLINED = 0x1190E
    ROUNDABOUT_RIGHT_ROUNDED = 0x1190F
    ROUNDABOUT_RIGHT_SHARP = 0x11910
    ROUNDED_CORNER = 0x11911
    ROUNDED_CORNER_OUTLINED = 0x11912
    ROUNDED_CORNER_ROUNDED = 0x11913
    ROUNDED_CORNER_SHARP = 0x11914
    ROUTE = 0x11915
    ROUTE_OUTLINED = 0x11916
    ROUTE_ROUNDED = 0x11917
    ROUTE_SHARP = 0x11918
    ROUTER = 0x11919
    ROUTER_OUTLINED = 0x1191A
    ROUTER_ROUNDED = 0x1191B
    ROUTER_SHARP = 0x1191C
    ROWING = 0x1191D
    ROWING_OUTLINED = 0x1191E
    ROWING_ROUNDED = 0x1191F
    ROWING_SHARP = 0x11920
    RSS_FEED = 0x11921
    RSS_FEED_OUTLINED = 0x11922
    RSS_FEED_ROUNDED = 0x11923
    RSS_FEED_SHARP = 0x11924
    RSVP = 0x11925
    RSVP_OUTLINED = 0x11926
    RSVP_ROUNDED = 0x11927
    RSVP_SHARP = 0x11928
    RTT = 0x11929
    RTT_OUTLINED = 0x1192A
    RTT_ROUNDED = 0x1192B
    RTT_SHARP = 0x1192C
    RULE = 0x1192D
    RULE_FOLDER = 0x1192E
    RULE_FOLDER_OUTLINED = 0x1192F
    RULE_FOLDER_ROUNDED = 0x11930
    RULE_FOLDER_SHARP = 0x11931
    RULE_OUTLINED = 0x11932
    RULE_ROUNDED = 0x11933
    RULE_SHARP = 0x11934
    RUN_CIRCLE = 0x11935
    RUN_CIRCLE_OUTLINED = 0x11936
    RUN_CIRCLE_ROUNDED = 0x11937
    RUN_CIRCLE_SHARP = 0x11938
    RUNNING_WITH_ERRORS = 0x11939
    RUNNING_WITH_ERRORS_OUTLINED = 0x1193A
    RUNNING_WITH_ERRORS_ROUNDED = 0x1193B
    RUNNING_WITH_ERRORS_SHARP = 0x1193C
    RV_HOOKUP = 0x1193D
    RV_HOOKUP_OUTLINED = 0x1193E
    RV_HOOKUP_ROUNDED = 0x1193F
    RV_HOOKUP_SHARP = 0x11940
    SAFETY_CHECK = 0x11941
    SAFETY_CHECK_OUTLINED = 0x11942
    SAFETY_CHECK_ROUNDED = 0x11943
    SAFETY_CHECK_SHARP = 0x11944
    SAFETY_DIVIDER = 0x11945
    SAFETY_DIVIDER_OUTLINED = 0x11946
    SAFETY_DIVIDER_ROUNDED = 0x11947
    SAFETY_DIVIDER_SHARP = 0x11948
    SAILING = 0x11949
    SAILING_OUTLINED = 0x1194A
    SAILING_ROUNDED = 0x1194B
    SAILING_SHARP = 0x1194C
    SANITIZER = 0x1194D
    SANITIZER_OUTLINED = 0x1194E
    SANITIZER_ROUNDED = 0x1194F
    SANITIZER_SHARP = 0x11950
    SATELLITE = 0x11951
    SATELLITE_ALT = 0x11952
    SATELLITE_ALT_OUTLINED = 0x11953
    SATELLITE_ALT_ROUNDED = 0x11954
    SATELLITE_ALT_SHARP = 0x11955
    SATELLITE_OUTLINED = 0x11956
    SATELLITE_ROUNDED = 0x11957
    SATELLITE_SHARP = 0x11958
    SAVE = 0x11959
    SAVE_ALT = 0x1195A
    SAVE_ALT_OUTLINED = 0x1195B
    SAVE_ALT_ROUNDED = 0x1195C
    SAVE_ALT_SHARP = 0x1195D
    SAVE_AS = 0x1195E
    SAVE_AS_OUTLINED = 0x1195F
    SAVE_AS_ROUNDED = 0x11960
    SAVE_AS_SHARP = 0x11961
    SAVE_OUTLINED = 0x11962
    SAVE_ROUNDED = 0x11963
    SAVE_SHARP = 0x11964
    SAVED_SEARCH = 0x11965
    SAVED_SEARCH_OUTLINED = 0x11966
    SAVED_SEARCH_ROUNDED = 0x11967
    SAVED_SEARCH_SHARP = 0x11968
    SAVINGS = 0x11969
    SAVINGS_OUTLINED = 0x1196A
    SAVINGS_ROUNDED = 0x1196B
    SAVINGS_SHARP = 0x1196C
    SCALE = 0x1196D
    SCALE_OUTLINED = 0x1196E
    SCALE_ROUNDED = 0x1196F
    SCALE_SHARP = 0x11970
    SCANNER = 0x11971
    SCANNER_OUTLINED = 0x11972
    SCANNER_ROUNDED = 0x11973
    SCANNER_SHARP = 0x11974
    SCATTER_PLOT = 0x11975
    SCATTER_PLOT_OUTLINED = 0x11976
    SCATTER_PLOT_ROUNDED = 0x11977
    SCATTER_PLOT_SHARP = 0x11978
    SCHEDULE = 0x11979
    SCHEDULE_OUTLINED = 0x1197A
    SCHEDULE_ROUNDED = 0x1197B
    SCHEDULE_SEND = 0x1197C
    SCHEDULE_SEND_OUTLINED = 0x1197D
    SCHEDULE_SEND_ROUNDED = 0x1197E
    SCHEDULE_SEND_SHARP = 0x1197F
    SCHEDULE_SHARP = 0x11980
    SCHEMA = 0x11981
    SCHEMA_OUTLINED = 0x11982
    SCHEMA_ROUNDED = 0x11983
    SCHEMA_SHARP = 0x11984
    SCHOOL = 0x11985
    SCHOOL_OUTLINED = 0x11986
    SCHOOL_ROUNDED = 0x11987
    SCHOOL_SHARP = 0x11988
    SCIENCE = 0x11989
    SCIENCE_OUTLINED = 0x1198A
    SCIENCE_ROUNDED = 0x1198B
    SCIENCE_SHARP = 0x1198C
    SCORE = 0x1198D
    SCORE_OUTLINED = 0x1198E
    SCORE_ROUNDED = 0x1198F
    SCORE_SHARP = 0x11990
    SCOREBOARD = 0x11991
    SCOREBOARD_OUTLINED = 0x11992
    SCOREBOARD_ROUNDED = 0x11993
    SCOREBOARD_SHARP = 0x11994
    SCREEN_LOCK_LANDSCAPE = 0x11995
    SCREEN_LOCK_LANDSCAPE_OUTLINED = 0x11996
    SCREEN_LOCK_LANDSCAPE_ROUNDED = 0x11997
    SCREEN_LOCK_LANDSCAPE_SHARP = 0x11998
    SCREEN_LOCK_PORTRAIT = 0x11999
    SCREEN_LOCK_PORTRAIT_OUTLINED = 0x1199A
    SCREEN_LOCK_PORTRAIT_ROUNDED = 0x1199B
    SCREEN_LOCK_PORTRAIT_SHARP = 0x1199C
    SCREEN_LOCK_ROTATION = 0x1199D
    SCREEN_LOCK_ROTATION_OUTLINED = 0x1199E
    SCREEN_LOCK_ROTATION_ROUNDED = 0x1199F
    SCREEN_LOCK_ROTATION_SHARP = 0x119A0
    SCREEN_ROTATION = 0x119A1
    SCREEN_ROTATION_ALT = 0x119A2
    SCREEN_ROTATION_ALT_OUTLINED = 0x119A3
    SCREEN_ROTATION_ALT_ROUNDED = 0x119A4
    SCREEN_ROTATION_ALT_SHARP = 0x119A5
    SCREEN_ROTATION_OUTLINED = 0x119A6
    SCREEN_ROTATION_ROUNDED = 0x119A7
    SCREEN_ROTATION_SHARP = 0x119A8
    SCREEN_SEARCH_DESKTOP = 0x119A9
    SCREEN_SEARCH_DESKTOP_OUTLINED = 0x119AA
    SCREEN_SEARCH_DESKTOP_ROUNDED = 0x119AB
    SCREEN_SEARCH_DESKTOP_SHARP = 0x119AC
    SCREEN_SHARE = 0x119AD
    SCREEN_SHARE_OUTLINED = 0x119AE
    SCREEN_SHARE_ROUNDED = 0x119AF
    SCREEN_SHARE_SHARP = 0x119B0
    SCREENSHOT = 0x119B1
    SCREENSHOT_MONITOR = 0x119B2
    SCREENSHOT_MONITOR_OUTLINED = 0x119B3
    SCREENSHOT_MONITOR_ROUNDED = 0x119B4
    SCREENSHOT_MONITOR_SHARP = 0x119B5
    SCREENSHOT_OUTLINED = 0x119B6
    SCREENSHOT_ROUNDED = 0x119B7
    SCREENSHOT_SHARP = 0x119B8
    SCUBA_DIVING = 0x119B9
    SCUBA_DIVING_OUTLINED = 0x119BA
    SCUBA_DIVING_ROUNDED = 0x119BB
    SCUBA_DIVING_SHARP = 0x119BC
    SD = 0x119BD
    SD_CARD = 0x119BE
    SD_CARD_ALERT = 0x119BF
    SD_CARD_ALERT_OUTLINED = 0x119C0
    SD_CARD_ALERT_ROUNDED = 0x119C1
    SD_CARD_ALERT_SHARP = 0x119C2
    SD_CARD_OUTLINED = 0x119C3
    SD_CARD_ROUNDED = 0x119C4
    SD_CARD_SHARP = 0x119C5
    SD_OUTLINED = 0x119C6
    SD_ROUNDED = 0x119C7
    SD_SHARP = 0x119C8
    SD_STORAGE = 0x119C9
    SD_STORAGE_OUTLINED = 0x119CA
    SD_STORAGE_ROUNDED = 0x119CB
    SD_STORAGE_SHARP = 0x119CC
    SEARCH = 0x119CD
    SEARCH_OFF = 0x119CE
    SEARCH_OFF_OUTLINED = 0x119CF
    SEARCH_OFF_ROUNDED = 0x119D0
    SEARCH_OFF_SHARP = 0x119D1
    SEARCH_OUTLINED = 0x119D2
    SEARCH_ROUNDED = 0x119D3
    SEARCH_SHARP = 0x119D4
    SECURITY = 0x119D5
    SECURITY_OUTLINED = 0x119D6
    SECURITY_ROUNDED = 0x119D7
    SECURITY_SHARP = 0x119D8
    SECURITY_UPDATE = 0x119D9
    SECURITY_UPDATE_GOOD = 0x119DA
    SECURITY_UPDATE_GOOD_OUTLINED = 0x119DB
    SECURITY_UPDATE_GOOD_ROUNDED = 0x119DC
    SECURITY_UPDATE_GOOD_SHARP = 0x119DD
    SECURITY_UPDATE_OUTLINED = 0x119DE
    SECURITY_UPDATE_ROUNDED = 0x119DF
    SECURITY_UPDATE_SHARP = 0x119E0
    SECURITY_UPDATE_WARNING = 0x119E1
    SECURITY_UPDATE_WARNING_OUTLINED = 0x119E2
    SECURITY_UPDATE_WARNING_ROUNDED = 0x119E3
    SECURITY_UPDATE_WARNING_SHARP = 0x119E4
    SEGMENT = 0x119E5
    SEGMENT_OUTLINED = 0x119E6
    SEGMENT_ROUNDED = 0x119E7
    SEGMENT_SHARP = 0x119E8
    SELECT_ALL = 0x119E9
    SELECT_ALL_OUTLINED = 0x119EA
    SELECT_ALL_ROUNDED = 0x119EB
    SELECT_ALL_SHARP = 0x119EC
    SELF_IMPROVEMENT = 0x119ED
    SELF_IMPROVEMENT_OUTLINED = 0x119EE
    SELF_IMPROVEMENT_ROUNDED = 0x119EF
    SELF_IMPROVEMENT_SHARP = 0x119F0
    SELL = 0x119F1
    SELL_OUTLINED = 0x119F2
    SELL_ROUNDED = 0x119F3
    SELL_SHARP = 0x119F4
    SEND = 0x119F5
    SEND_AND_ARCHIVE = 0x119F6
    SEND_AND_ARCHIVE_OUTLINED = 0x119F7
    SEND_AND_ARCHIVE_ROUNDED = 0x119F8
    SEND_AND_ARCHIVE_SHARP = 0x119F9
    SEND_OUTLINED = 0x119FA
    SEND_ROUNDED = 0x119FB
    SEND_SHARP = 0x119FC
    SEND_TIME_EXTENSION = 0x119FD
    SEND_TIME_EXTENSION_OUTLINED = 0x119FE
    SEND_TIME_EXTENSION_ROUNDED = 0x119FF
    SEND_TIME_EXTENSION_SHARP = 0x11A00
    SEND_TO_MOBILE = 0x11A01
    SEND_TO_MOBILE_OUTLINED = 0x11A02
    SEND_TO_MOBILE_ROUNDED = 0x11A03
    SEND_TO_MOBILE_SHARP = 0x11A04
    SENSOR_DOOR = 0x11A05
    SENSOR_DOOR_OUTLINED = 0x11A06
    SENSOR_DOOR_ROUNDED = 0x11A07
    SENSOR_DOOR_SHARP = 0x11A08
    SENSOR_OCCUPIED = 0x11A09
    SENSOR_OCCUPIED_OUTLINED = 0x11A0A
    SENSOR_OCCUPIED_ROUNDED = 0x11A0B
    SENSOR_OCCUPIED_SHARP = 0x11A0C
    SENSOR_WINDOW = 0x11A0D
    SENSOR_WINDOW_OUTLINED = 0x11A0E
    SENSOR_WINDOW_ROUNDED = 0x11A0F
    SENSOR_WINDOW_SHARP = 0x11A10
    SENSORS = 0x11A11
    SENSORS_OFF = 0x11A12
    SENSORS_OFF_OUTLINED = 0x11A13
    SENSORS_OFF_ROUNDED = 0x11A14
    SENSORS_OFF_SHARP = 0x11A15
    SENSORS_OUTLINED = 0x11A16
    SENSORS_ROUNDED = 0x11A17
    SENSORS_SHARP = 0x11A18
    SENTIMENT_DISSATISFIED = 0x11A19
    SENTIMENT_DISSATISFIED_OUTLINED = 0x11A1A
    SENTIMENT_DISSATISFIED_ROUNDED = 0x11A1B
    SENTIMENT_DISSATISFIED_SHARP = 0x11A1C
    SENTIMENT_NEUTRAL = 0x11A1D
    SENTIMENT_NEUTRAL_OUTLINED = 0x11A1E
    SENTIMENT_NEUTRAL_ROUNDED = 0x11A1F
    SENTIMENT_NEUTRAL_SHARP = 0x11A20
    SENTIMENT_SATISFIED = 0x11A21
    SENTIMENT_SATISFIED_ALT = 0x11A22
    SENTIMENT_SATISFIED_ALT_OUTLINED = 0x11A23
    SENTIMENT_SATISFIED_ALT_ROUNDED = 0x11A24
    SENTIMENT_SATISFIED_ALT_SHARP = 0x11A25
    SENTIMENT_SATISFIED_OUTLINED = 0x11A26
    SENTIMENT_SATISFIED_ROUNDED = 0x11A27
    SENTIMENT_SATISFIED_SHARP = 0x11A28
    SENTIMENT_VERY_DISSATISFIED = 0x11A29
    SENTIMENT_VERY_DISSATISFIED_OUTLINED = 0x11A2A
    SENTIMENT_VERY_DISSATISFIED_ROUNDED = 0x11A2B
    SENTIMENT_VERY_DISSATISFIED_SHARP = 0x11A2C
    SENTIMENT_VERY_SATISFIED = 0x11A2D
    SENTIMENT_VERY_SATISFIED_OUTLINED = 0x11A2E
    SENTIMENT_VERY_SATISFIED_ROUNDED = 0x11A2F
    SENTIMENT_VERY_SATISFIED_SHARP = 0x11A30
    SET_MEAL = 0x11A31
    SET_MEAL_OUTLINED = 0x11A32
    SET_MEAL_ROUNDED = 0x11A33
    SET_MEAL_SHARP = 0x11A34
    SETTINGS = 0x11A35
    SETTINGS_ACCESSIBILITY = 0x11A36
    SETTINGS_ACCESSIBILITY_OUTLINED = 0x11A37
    SETTINGS_ACCESSIBILITY_ROUNDED = 0x11A38
    SETTINGS_ACCESSIBILITY_SHARP = 0x11A39
    SETTINGS_APPLICATIONS = 0x11A3A
    SETTINGS_APPLICATIONS_OUTLINED = 0x11A3B
    SETTINGS_APPLICATIONS_ROUNDED = 0x11A3C
    SETTINGS_APPLICATIONS_SHARP = 0x11A3D
    SETTINGS_BACKUP_RESTORE = 0x11A3E
    SETTINGS_BACKUP_RESTORE_OUTLINED = 0x11A3F
    SETTINGS_BACKUP_RESTORE_ROUNDED = 0x11A40
    SETTINGS_BACKUP_RESTORE_SHARP = 0x11A41
    SETTINGS_BLUETOOTH = 0x11A42
    SETTINGS_BLUETOOTH_OUTLINED = 0x11A43
    SETTINGS_BLUETOOTH_ROUNDED = 0x11A44
    SETTINGS_BLUETOOTH_SHARP = 0x11A45
    SETTINGS_BRIGHTNESS = 0x11A46
    SETTINGS_BRIGHTNESS_OUTLINED = 0x11A47
    SETTINGS_BRIGHTNESS_ROUNDED = 0x11A48
    SETTINGS_BRIGHTNESS_SHARP = 0x11A49
    SETTINGS_CELL = 0x11A4A
    SETTINGS_CELL_OUTLINED = 0x11A4B
    SETTINGS_CELL_ROUNDED = 0x11A4C
    SETTINGS_CELL_SHARP = 0x11A4D
    SETTINGS_DISPLAY = 0x11A4E
    SETTINGS_DISPLAY_OUTLINED = 0x11A4F
    SETTINGS_DISPLAY_ROUNDED = 0x11A50
    SETTINGS_DISPLAY_SHARP = 0x11A51
    SETTINGS_ETHERNET = 0x11A52
    SETTINGS_ETHERNET_OUTLINED = 0x11A53
    SETTINGS_ETHERNET_ROUNDED = 0x11A54
    SETTINGS_ETHERNET_SHARP = 0x11A55
    SETTINGS_INPUT_ANTENNA = 0x11A56
    SETTINGS_INPUT_ANTENNA_OUTLINED = 0x11A57
    SETTINGS_INPUT_ANTENNA_ROUNDED = 0x11A58
    SETTINGS_INPUT_ANTENNA_SHARP = 0x11A59
    SETTINGS_INPUT_COMPONENT = 0x11A5A
    SETTINGS_INPUT_COMPONENT_OUTLINED = 0x11A5B
    SETTINGS_INPUT_COMPONENT_ROUNDED = 0x11A5C
    SETTINGS_INPUT_COMPONENT_SHARP = 0x11A5D
    SETTINGS_INPUT_COMPOSITE = 0x11A5E
    SETTINGS_INPUT_COMPOSITE_OUTLINED = 0x11A5F
    SETTINGS_INPUT_COMPOSITE_ROUNDED = 0x11A60
    SETTINGS_INPUT_COMPOSITE_SHARP = 0x11A61
    SETTINGS_INPUT_HDMI = 0x11A62
    SETTINGS_INPUT_HDMI_OUTLINED = 0x11A63
    SETTINGS_INPUT_HDMI_ROUNDED = 0x11A64
    SETTINGS_INPUT_HDMI_SHARP = 0x11A65
    SETTINGS_INPUT_SVIDEO = 0x11A66
    SETTINGS_INPUT_SVIDEO_OUTLINED = 0x11A67
    SETTINGS_INPUT_SVIDEO_ROUNDED = 0x11A68
    SETTINGS_INPUT_SVIDEO_SHARP = 0x11A69
    SETTINGS_OUTLINED = 0x11A6A
    SETTINGS_OVERSCAN = 0x11A6B
    SETTINGS_OVERSCAN_OUTLINED = 0x11A6C
    SETTINGS_OVERSCAN_ROUNDED = 0x11A6D
    SETTINGS_OVERSCAN_SHARP = 0x11A6E
    SETTINGS_PHONE = 0x11A6F
    SETTINGS_PHONE_OUTLINED = 0x11A70
    SETTINGS_PHONE_ROUNDED = 0x11A71
    SETTINGS_PHONE_SHARP = 0x11A72
    SETTINGS_POWER = 0x11A73
    SETTINGS_POWER_OUTLINED = 0x11A74
    SETTINGS_POWER_ROUNDED = 0x11A75
    SETTINGS_POWER_SHARP = 0x11A76
    SETTINGS_REMOTE = 0x11A77
    SETTINGS_REMOTE_OUTLINED = 0x11A78
    SETTINGS_REMOTE_ROUNDED = 0x11A79
    SETTINGS_REMOTE_SHARP = 0x11A7A
    SETTINGS_ROUNDED = 0x11A7B
    SETTINGS_SHARP = 0x11A7C
    SETTINGS_SUGGEST = 0x11A7D
    SETTINGS_SUGGEST_OUTLINED = 0x11A7E
    SETTINGS_SUGGEST_ROUNDED = 0x11A7F
    SETTINGS_SUGGEST_SHARP = 0x11A80
    SETTINGS_SYSTEM_DAYDREAM = 0x11A81
    SETTINGS_SYSTEM_DAYDREAM_OUTLINED = 0x11A82
    SETTINGS_SYSTEM_DAYDREAM_ROUNDED = 0x11A83
    SETTINGS_SYSTEM_DAYDREAM_SHARP = 0x11A84
    SETTINGS_VOICE = 0x11A85
    SETTINGS_VOICE_OUTLINED = 0x11A86
    SETTINGS_VOICE_ROUNDED = 0x11A87
    SETTINGS_VOICE_SHARP = 0x11A88
    SEVEN_K = 0x11A89
    SEVEN_K_OUTLINED = 0x11A8A
    SEVEN_K_PLUS = 0x11A8B
    SEVEN_K_PLUS_OUTLINED = 0x11A8C
    SEVEN_K_PLUS_ROUNDED = 0x11A8D
    SEVEN_K_PLUS_SHARP = 0x11A8E
    SEVEN_K_ROUNDED = 0x11A8F
    SEVEN_K_SHARP = 0x11A90
    SEVEN_MP = 0x11A91
    SEVEN_MP_OUTLINED = 0x11A92
    SEVEN_MP_ROUNDED = 0x11A93
    SEVEN_MP_SHARP = 0x11A94
    SEVENTEEN_MP = 0x11A95
    SEVENTEEN_MP_OUTLINED = 0x11A96
    SEVENTEEN_MP_ROUNDED = 0x11A97
    SEVENTEEN_MP_SHARP = 0x11A98
    SEVERE_COLD = 0x11A99
    SEVERE_COLD_OUTLINED = 0x11A9A
    SEVERE_COLD_ROUNDED = 0x11A9B
    SEVERE_COLD_SHARP = 0x11A9C
    SHAPE_LINE = 0x11A9D
    SHAPE_LINE_OUTLINED = 0x11A9E
    SHAPE_LINE_ROUNDED = 0x11A9F
    SHAPE_LINE_SHARP = 0x11AA0
    SHARE = 0x11AA1
    SHARE_ARRIVAL_TIME = 0x11AA2
    SHARE_ARRIVAL_TIME_OUTLINED = 0x11AA3
    SHARE_ARRIVAL_TIME_ROUNDED = 0x11AA4
    SHARE_ARRIVAL_TIME_SHARP = 0x11AA5
    SHARE_LOCATION = 0x11AA6
    SHARE_LOCATION_OUTLINED = 0x11AA7
    SHARE_LOCATION_ROUNDED = 0x11AA8
    SHARE_LOCATION_SHARP = 0x11AA9
    SHARE_OUTLINED = 0x11AAA
    SHARE_ROUNDED = 0x11AAB
    SHARE_SHARP = 0x11AAC
    SHELVES = 0x11AAD
    SHIELD = 0x11AAE
    SHIELD_MOON = 0x11AAF
    SHIELD_MOON_OUTLINED = 0x11AB0
    SHIELD_MOON_ROUNDED = 0x11AB1
    SHIELD_MOON_SHARP = 0x11AB2
    SHIELD_OUTLINED = 0x11AB3
    SHIELD_ROUNDED = 0x11AB4
    SHIELD_SHARP = 0x11AB5
    SHOP = 0x11AB6
    SHOP_2 = 0x11AB7
    SHOP_2_OUTLINED = 0x11AB8
    SHOP_2_ROUNDED = 0x11AB9
    SHOP_2_SHARP = 0x11ABA
    SHOP_OUTLINED = 0x11ABB
    SHOP_ROUNDED = 0x11ABC
    SHOP_SHARP = 0x11ABD
    SHOP_TWO = 0x11ABE
    SHOP_TWO_OUTLINED = 0x11ABF
    SHOP_TWO_ROUNDED = 0x11AC0
    SHOP_TWO_SHARP = 0x11AC1
    SHOPIFY = 0x11AC2
    SHOPIFY_OUTLINED = 0x11AC3
    SHOPIFY_ROUNDED = 0x11AC4
    SHOPIFY_SHARP = 0x11AC5
    SHOPPING_BAG = 0x11AC6
    SHOPPING_BAG_OUTLINED = 0x11AC7
    SHOPPING_BAG_ROUNDED = 0x11AC8
    SHOPPING_BAG_SHARP = 0x11AC9
    SHOPPING_BASKET = 0x11ACA
    SHOPPING_BASKET_OUTLINED = 0x11ACB
    SHOPPING_BASKET_ROUNDED = 0x11ACC
    SHOPPING_BASKET_SHARP = 0x11ACD
    SHOPPING_CART = 0x11ACE
    SHOPPING_CART_CHECKOUT = 0x11ACF
    SHOPPING_CART_CHECKOUT_OUTLINED = 0x11AD0
    SHOPPING_CART_CHECKOUT_ROUNDED = 0x11AD1
    SHOPPING_CART_CHECKOUT_SHARP = 0x11AD2
    SHOPPING_CART_OUTLINED = 0x11AD3
    SHOPPING_CART_ROUNDED = 0x11AD4
    SHOPPING_CART_SHARP = 0x11AD5
    SHORT_TEXT = 0x11AD6
    SHORT_TEXT_OUTLINED = 0x11AD7
    SHORT_TEXT_ROUNDED = 0x11AD8
    SHORT_TEXT_SHARP = 0x11AD9
    SHORTCUT = 0x11ADA
    SHORTCUT_OUTLINED = 0x11ADB
    SHORTCUT_ROUNDED = 0x11ADC
    SHORTCUT_SHARP = 0x11ADD
    SHOW_CHART = 0x11ADE
    SHOW_CHART_OUTLINED = 0x11ADF
    SHOW_CHART_ROUNDED = 0x11AE0
    SHOW_CHART_SHARP = 0x11AE1
    SHOWER = 0x11AE2
    SHOWER_OUTLINED = 0x11AE3
    SHOWER_ROUNDED = 0x11AE4
    SHOWER_SHARP = 0x11AE5
    SHUFFLE = 0x11AE6
    SHUFFLE_ON = 0x11AE7
    SHUFFLE_ON_OUTLINED = 0x11AE8
    SHUFFLE_ON_ROUNDED = 0x11AE9
    SHUFFLE_ON_SHARP = 0x11AEA
    SHUFFLE_OUTLINED = 0x11AEB
    SHUFFLE_ROUNDED = 0x11AEC
    SHUFFLE_SHARP = 0x11AED
    SHUTTER_SPEED = 0x11AEE
    SHUTTER_SPEED_OUTLINED = 0x11AEF
    SHUTTER_SPEED_ROUNDED = 0x11AF0
    SHUTTER_SPEED_SHARP = 0x11AF1
    SICK = 0x11AF2
    SICK_OUTLINED = 0x11AF3
    SICK_ROUNDED = 0x11AF4
    SICK_SHARP = 0x11AF5
    SIGN_LANGUAGE = 0x11AF6
    SIGN_LANGUAGE_OUTLINED = 0x11AF7
    SIGN_LANGUAGE_ROUNDED = 0x11AF8
    SIGN_LANGUAGE_SHARP = 0x11AF9
    SIGNAL_CELLULAR_0_BAR = 0x11AFA
    SIGNAL_CELLULAR_0_BAR_OUTLINED = 0x11AFB
    SIGNAL_CELLULAR_0_BAR_ROUNDED = 0x11AFC
    SIGNAL_CELLULAR_0_BAR_SHARP = 0x11AFD
    SIGNAL_CELLULAR_4_BAR = 0x11AFE
    SIGNAL_CELLULAR_4_BAR_OUTLINED = 0x11AFF
    SIGNAL_CELLULAR_4_BAR_ROUNDED = 0x11B00
    SIGNAL_CELLULAR_4_BAR_SHARP = 0x11B01
    SIGNAL_CELLULAR_ALT = 0x11B02
    SIGNAL_CELLULAR_ALT_1_BAR = 0x11B03
    SIGNAL_CELLULAR_ALT_1_BAR_OUTLINED = 0x11B04
    SIGNAL_CELLULAR_ALT_1_BAR_ROUNDED = 0x11B05
    SIGNAL_CELLULAR_ALT_1_BAR_SHARP = 0x11B06
    SIGNAL_CELLULAR_ALT_2_BAR = 0x11B07
    SIGNAL_CELLULAR_ALT_2_BAR_OUTLINED = 0x11B08
    SIGNAL_CELLULAR_ALT_2_BAR_ROUNDED = 0x11B09
    SIGNAL_CELLULAR_ALT_2_BAR_SHARP = 0x11B0A
    SIGNAL_CELLULAR_ALT_OUTLINED = 0x11B0B
    SIGNAL_CELLULAR_ALT_ROUNDED = 0x11B0C
    SIGNAL_CELLULAR_ALT_SHARP = 0x11B0D
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_0_BAR = 0x11B0E
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_0_BAR_OUTLINED = 0x11B0F
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_0_BAR_ROUNDED = 0x11B10
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_0_BAR_SHARP = 0x11B11
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR = 0x11B12
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR_OUTLINED = 0x11B13
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR_ROUNDED = 0x11B14
    SIGNAL_CELLULAR_CONNECTED_NO_INTERNET_4_BAR_SHARP = 0x11B15
    SIGNAL_CELLULAR_NO_SIM = 0x11B16
    SIGNAL_CELLULAR_NO_SIM_OUTLINED = 0x11B17
    SIGNAL_CELLULAR_NO_SIM_ROUNDED = 0x11B18
    SIGNAL_CELLULAR_NO_SIM_SHARP = 0x11B19
    SIGNAL_CELLULAR_NODATA = 0x11B1A
    SIGNAL_CELLULAR_NODATA_OUTLINED = 0x11B1B
    SIGNAL_CELLULAR_NODATA_ROUNDED = 0x11B1C
    SIGNAL_CELLULAR_NODATA_SHARP = 0x11B1D
    SIGNAL_CELLULAR_NULL = 0x11B1E
    SIGNAL_CELLULAR_NULL_OUTLINED = 0x11B1F
    SIGNAL_CELLULAR_NULL_ROUNDED = 0x11B20
    SIGNAL_CELLULAR_NULL_SHARP = 0x11B21
    SIGNAL_CELLULAR_OFF = 0x11B22
    SIGNAL_CELLULAR_OFF_OUTLINED = 0x11B23
    SIGNAL_CELLULAR_OFF_ROUNDED = 0x11B24
    SIGNAL_CELLULAR_OFF_SHARP = 0x11B25
    SIGNAL_WIFI_0_BAR = 0x11B26
    SIGNAL_WIFI_0_BAR_OUTLINED = 0x11B27
    SIGNAL_WIFI_0_BAR_ROUNDED = 0x11B28
    SIGNAL_WIFI_0_BAR_SHARP = 0x11B29
    SIGNAL_WIFI_4_BAR = 0x11B2A
    SIGNAL_WIFI_4_BAR_LOCK = 0x11B2B
    SIGNAL_WIFI_4_BAR_LOCK_OUTLINED = 0x11B2C
    SIGNAL_WIFI_4_BAR_LOCK_ROUNDED = 0x11B2D
    SIGNAL_WIFI_4_BAR_LOCK_SHARP = 0x11B2E
    SIGNAL_WIFI_4_BAR_OUTLINED = 0x11B2F
    SIGNAL_WIFI_4_BAR_ROUNDED = 0x11B30
    SIGNAL_WIFI_4_BAR_SHARP = 0x11B31
    SIGNAL_WIFI_BAD = 0x11B32
    SIGNAL_WIFI_BAD_OUTLINED = 0x11B33
    SIGNAL_WIFI_BAD_ROUNDED = 0x11B34
    SIGNAL_WIFI_BAD_SHARP = 0x11B35
    SIGNAL_WIFI_CONNECTED_NO_INTERNET_4 = 0x11B36
    SIGNAL_WIFI_CONNECTED_NO_INTERNET_4_OUTLINED = 0x11B37
    SIGNAL_WIFI_CONNECTED_NO_INTERNET_4_ROUNDED = 0x11B38
    SIGNAL_WIFI_CONNECTED_NO_INTERNET_4_SHARP = 0x11B39
    SIGNAL_WIFI_OFF = 0x11B3A
    SIGNAL_WIFI_OFF_OUTLINED = 0x11B3B
    SIGNAL_WIFI_OFF_ROUNDED = 0x11B3C
    SIGNAL_WIFI_OFF_SHARP = 0x11B3D
    SIGNAL_WIFI_STATUSBAR_4_BAR = 0x11B3E
    SIGNAL_WIFI_STATUSBAR_4_BAR_OUTLINED = 0x11B3F
    SIGNAL_WIFI_STATUSBAR_4_BAR_ROUNDED = 0x11B40
    SIGNAL_WIFI_STATUSBAR_4_BAR_SHARP = 0x11B41
    SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_4 = 0x11B42
    SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_4_OUTLINED = 0x11B43
    SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_4_ROUNDED = 0x11B44
    SIGNAL_WIFI_STATUSBAR_CONNECTED_NO_INTERNET_4_SHARP = 0x11B45
    SIGNAL_WIFI_STATUSBAR_NULL = 0x11B46
    SIGNAL_WIFI_STATUSBAR_NULL_OUTLINED = 0x11B47
    SIGNAL_WIFI_STATUSBAR_NULL_ROUNDED = 0x11B48
    SIGNAL_WIFI_STATUSBAR_NULL_SHARP = 0x11B49
    SIGNPOST = 0x11B4A
    SIGNPOST_OUTLINED = 0x11B4B
    SIGNPOST_ROUNDED = 0x11B4C
    SIGNPOST_SHARP = 0x11B4D
    SIM_CARD = 0x11B4E
    SIM_CARD_ALERT = 0x11B4F
    SIM_CARD_ALERT_OUTLINED = 0x11B50
    SIM_CARD_ALERT_ROUNDED = 0x11B51
    SIM_CARD_ALERT_SHARP = 0x11B52
    SIM_CARD_DOWNLOAD = 0x11B53
    SIM_CARD_DOWNLOAD_OUTLINED = 0x11B54
    SIM_CARD_DOWNLOAD_ROUNDED = 0x11B55
    SIM_CARD_DOWNLOAD_SHARP = 0x11B56
    SIM_CARD_OUTLINED = 0x11B57
    SIM_CARD_ROUNDED = 0x11B58
    SIM_CARD_SHARP = 0x11B59
    SINGLE_BED = 0x11B5A
    SINGLE_BED_OUTLINED = 0x11B5B
    SINGLE_BED_ROUNDED = 0x11B5C
    SINGLE_BED_SHARP = 0x11B5D
    SIP = 0x11B5E
    SIP_OUTLINED = 0x11B5F
    SIP_ROUNDED = 0x11B60
    SIP_SHARP = 0x11B61
    SIX_FT_APART = 0x11B62
    SIX_FT_APART_OUTLINED = 0x11B63
    SIX_FT_APART_ROUNDED = 0x11B64
    SIX_FT_APART_SHARP = 0x11B65
    SIX_K = 0x11B66
    SIX_K_OUTLINED = 0x11B67
    SIX_K_PLUS = 0x11B68
    SIX_K_PLUS_OUTLINED = 0x11B69
    SIX_K_PLUS_ROUNDED = 0x11B6A
    SIX_K_PLUS_SHARP = 0x11B6B
    SIX_K_ROUNDED = 0x11B6C
    SIX_K_SHARP = 0x11B6D
    SIX_MP = 0x11B6E
    SIX_MP_OUTLINED = 0x11B6F
    SIX_MP_ROUNDED = 0x11B70
    SIX_MP_SHARP = 0x11B71
    SIXTEEN_MP = 0x11B72
    SIXTEEN_MP_OUTLINED = 0x11B73
    SIXTEEN_MP_ROUNDED = 0x11B74
    SIXTEEN_MP_SHARP = 0x11B75
    SIXTY_FPS = 0x11B76
    SIXTY_FPS_OUTLINED = 0x11B77
    SIXTY_FPS_ROUNDED = 0x11B78
    SIXTY_FPS_SELECT = 0x11B79
    SIXTY_FPS_SELECT_OUTLINED = 0x11B7A
    SIXTY_FPS_SELECT_ROUNDED = 0x11B7B
    SIXTY_FPS_SELECT_SHARP = 0x11B7C
    SIXTY_FPS_SHARP = 0x11B7D
    SKATEBOARDING = 0x11B7E
    SKATEBOARDING_OUTLINED = 0x11B7F
    SKATEBOARDING_ROUNDED = 0x11B80
    SKATEBOARDING_SHARP = 0x11B81
    SKIP_NEXT = 0x11B82
    SKIP_NEXT_OUTLINED = 0x11B83
    SKIP_NEXT_ROUNDED = 0x11B84
    SKIP_NEXT_SHARP = 0x11B85
    SKIP_PREVIOUS = 0x11B86
    SKIP_PREVIOUS_OUTLINED = 0x11B87
    SKIP_PREVIOUS_ROUNDED = 0x11B88
    SKIP_PREVIOUS_SHARP = 0x11B89
    SLEDDING = 0x11B8A
    SLEDDING_OUTLINED = 0x11B8B
    SLEDDING_ROUNDED = 0x11B8C
    SLEDDING_SHARP = 0x11B8D
    SLIDESHOW = 0x11B8E
    SLIDESHOW_OUTLINED = 0x11B8F
    SLIDESHOW_ROUNDED = 0x11B90
    SLIDESHOW_SHARP = 0x11B91
    SLOW_MOTION_VIDEO = 0x11B92
    SLOW_MOTION_VIDEO_OUTLINED = 0x11B93
    SLOW_MOTION_VIDEO_ROUNDED = 0x11B94
    SLOW_MOTION_VIDEO_SHARP = 0x11B95
    SMART_BUTTON = 0x11B96
    SMART_BUTTON_OUTLINED = 0x11B97
    SMART_BUTTON_ROUNDED = 0x11B98
    SMART_BUTTON_SHARP = 0x11B99
    SMART_DISPLAY = 0x11B9A
    SMART_DISPLAY_OUTLINED = 0x11B9B
    SMART_DISPLAY_ROUNDED = 0x11B9C
    SMART_DISPLAY_SHARP = 0x11B9D
    SMART_SCREEN = 0x11B9E
    SMART_SCREEN_OUTLINED = 0x11B9F
    SMART_SCREEN_ROUNDED = 0x11BA0
    SMART_SCREEN_SHARP = 0x11BA1
    SMART_TOY = 0x11BA2
    SMART_TOY_OUTLINED = 0x11BA3
    SMART_TOY_ROUNDED = 0x11BA4
    SMART_TOY_SHARP = 0x11BA5
    SMARTPHONE = 0x11BA6
    SMARTPHONE_OUTLINED = 0x11BA7
    SMARTPHONE_ROUNDED = 0x11BA8
    SMARTPHONE_SHARP = 0x11BA9
    SMOKE_FREE = 0x11BAA
    SMOKE_FREE_OUTLINED = 0x11BAB
    SMOKE_FREE_ROUNDED = 0x11BAC
    SMOKE_FREE_SHARP = 0x11BAD
    SMOKING_ROOMS = 0x11BAE
    SMOKING_ROOMS_OUTLINED = 0x11BAF
    SMOKING_ROOMS_ROUNDED = 0x11BB0
    SMOKING_ROOMS_SHARP = 0x11BB1
    SMS = 0x11BB2
    SMS_FAILED = 0x11BB3
    SMS_FAILED_OUTLINED = 0x11BB4
    SMS_FAILED_ROUNDED = 0x11BB5
    SMS_FAILED_SHARP = 0x11BB6
    SMS_OUTLINED = 0x11BB7
    SMS_ROUNDED = 0x11BB8
    SMS_SHARP = 0x11BB9
    SNAPCHAT = 0x11BBA
    SNAPCHAT_OUTLINED = 0x11BBB
    SNAPCHAT_ROUNDED = 0x11BBC
    SNAPCHAT_SHARP = 0x11BBD
    SNIPPET_FOLDER = 0x11BBE
    SNIPPET_FOLDER_OUTLINED = 0x11BBF
    SNIPPET_FOLDER_ROUNDED = 0x11BC0
    SNIPPET_FOLDER_SHARP = 0x11BC1
    SNOOZE = 0x11BC2
    SNOOZE_OUTLINED = 0x11BC3
    SNOOZE_ROUNDED = 0x11BC4
    SNOOZE_SHARP = 0x11BC5
    SNOWBOARDING = 0x11BC6
    SNOWBOARDING_OUTLINED = 0x11BC7
    SNOWBOARDING_ROUNDED = 0x11BC8
    SNOWBOARDING_SHARP = 0x11BC9
    SNOWING = 0x11BCA
    SNOWMOBILE = 0x11BCB
    SNOWMOBILE_OUTLINED = 0x11BCC
    SNOWMOBILE_ROUNDED = 0x11BCD
    SNOWMOBILE_SHARP = 0x11BCE
    SNOWSHOEING = 0x11BCF
    SNOWSHOEING_OUTLINED = 0x11BD0
    SNOWSHOEING_ROUNDED = 0x11BD1
    SNOWSHOEING_SHARP = 0x11BD2
    SOAP = 0x11BD3
    SOAP_OUTLINED = 0x11BD4
    SOAP_ROUNDED = 0x11BD5
    SOAP_SHARP = 0x11BD6
    SOCIAL_DISTANCE = 0x11BD7
    SOCIAL_DISTANCE_OUTLINED = 0x11BD8
    SOCIAL_DISTANCE_ROUNDED = 0x11BD9
    SOCIAL_DISTANCE_SHARP = 0x11BDA
    SOLAR_POWER = 0x11BDB
    SOLAR_POWER_OUTLINED = 0x11BDC
    SOLAR_POWER_ROUNDED = 0x11BDD
    SOLAR_POWER_SHARP = 0x11BDE
    SORT = 0x11BDF
    SORT_BY_ALPHA = 0x11BE0
    SORT_BY_ALPHA_OUTLINED = 0x11BE1
    SORT_BY_ALPHA_ROUNDED = 0x11BE2
    SORT_BY_ALPHA_SHARP = 0x11BE3
    SORT_OUTLINED = 0x11BE4
    SORT_ROUNDED = 0x11BE5
    SORT_SHARP = 0x11BE6
    SOS = 0x11BE7
    SOS_OUTLINED = 0x11BE8
    SOS_ROUNDED = 0x11BE9
    SOS_SHARP = 0x11BEA
    SOUP_KITCHEN = 0x11BEB
    SOUP_KITCHEN_OUTLINED = 0x11BEC
    SOUP_KITCHEN_ROUNDED = 0x11BED
    SOUP_KITCHEN_SHARP = 0x11BEE
    SOURCE = 0x11BEF
    SOURCE_OUTLINED = 0x11BF0
    SOURCE_ROUNDED = 0x11BF1
    SOURCE_SHARP = 0x11BF2
    SOUTH = 0x11BF3
    SOUTH_AMERICA = 0x11BF4
    SOUTH_AMERICA_OUTLINED = 0x11BF5
    SOUTH_AMERICA_ROUNDED = 0x11BF6
    SOUTH_AMERICA_SHARP = 0x11BF7
    SOUTH_EAST = 0x11BF8
    SOUTH_EAST_OUTLINED = 0x11BF9
    SOUTH_EAST_ROUNDED = 0x11BFA
    SOUTH_EAST_SHARP = 0x11BFB
    SOUTH_OUTLINED = 0x11BFC
    SOUTH_ROUNDED = 0x11BFD
    SOUTH_SHARP = 0x11BFE
    SOUTH_WEST = 0x11BFF
    SOUTH_WEST_OUTLINED = 0x11C00
    SOUTH_WEST_ROUNDED = 0x11C01
    SOUTH_WEST_SHARP = 0x11C02
    SPA = 0x11C03
    SPA_OUTLINED = 0x11C04
    SPA_ROUNDED = 0x11C05
    SPA_SHARP = 0x11C06
    SPACE_BAR = 0x11C07
    SPACE_BAR_OUTLINED = 0x11C08
    SPACE_BAR_ROUNDED = 0x11C09
    SPACE_BAR_SHARP = 0x11C0A
    SPACE_DASHBOARD = 0x11C0B
    SPACE_DASHBOARD_OUTLINED = 0x11C0C
    SPACE_DASHBOARD_ROUNDED = 0x11C0D
    SPACE_DASHBOARD_SHARP = 0x11C0E
    SPATIAL_AUDIO = 0x11C0F
    SPATIAL_AUDIO_OFF = 0x11C10
    SPATIAL_AUDIO_OFF_OUTLINED = 0x11C11
    SPATIAL_AUDIO_OFF_ROUNDED = 0x11C12
    SPATIAL_AUDIO_OFF_SHARP = 0x11C13
    SPATIAL_AUDIO_OUTLINED = 0x11C14
    SPATIAL_AUDIO_ROUNDED = 0x11C15
    SPATIAL_AUDIO_SHARP = 0x11C16
    SPATIAL_TRACKING = 0x11C17
    SPATIAL_TRACKING_OUTLINED = 0x11C18
    SPATIAL_TRACKING_ROUNDED = 0x11C19
    SPATIAL_TRACKING_SHARP = 0x11C1A
    SPEAKER = 0x11C1B
    SPEAKER_GROUP = 0x11C1C
    SPEAKER_GROUP_OUTLINED = 0x11C1D
    SPEAKER_GROUP_ROUNDED = 0x11C1E
    SPEAKER_GROUP_SHARP = 0x11C1F
    SPEAKER_NOTES = 0x11C20
    SPEAKER_NOTES_OFF = 0x11C21
    SPEAKER_NOTES_OFF_OUTLINED = 0x11C22
    SPEAKER_NOTES_OFF_ROUNDED = 0x11C23
    SPEAKER_NOTES_OFF_SHARP = 0x11C24
    SPEAKER_NOTES_OUTLINED = 0x11C25
    SPEAKER_NOTES_ROUNDED = 0x11C26
    SPEAKER_NOTES_SHARP = 0x11C27
    SPEAKER_OUTLINED = 0x11C28
    SPEAKER_PHONE = 0x11C29
    SPEAKER_PHONE_OUTLINED = 0x11C2A
    SPEAKER_PHONE_ROUNDED = 0x11C2B
    SPEAKER_PHONE_SHARP = 0x11C2C
    SPEAKER_ROUNDED = 0x11C2D
    SPEAKER_SHARP = 0x11C2E
    SPEED = 0x11C2F
    SPEED_OUTLINED = 0x11C30
    SPEED_ROUNDED = 0x11C31
    SPEED_SHARP = 0x11C32
    SPELLCHECK = 0x11C33
    SPELLCHECK_OUTLINED = 0x11C34
    SPELLCHECK_ROUNDED = 0x11C35
    SPELLCHECK_SHARP = 0x11C36
    SPLITSCREEN = 0x11C37
    SPLITSCREEN_OUTLINED = 0x11C38
    SPLITSCREEN_ROUNDED = 0x11C39
    SPLITSCREEN_SHARP = 0x11C3A
    SPOKE = 0x11C3B
    SPOKE_OUTLINED = 0x11C3C
    SPOKE_ROUNDED = 0x11C3D
    SPOKE_SHARP = 0x11C3E
    SPORTS = 0x11C3F
    SPORTS_BAR = 0x11C40
    SPORTS_BAR_OUTLINED = 0x11C41
    SPORTS_BAR_ROUNDED = 0x11C42
    SPORTS_BAR_SHARP = 0x11C43
    SPORTS_BASEBALL = 0x11C44
    SPORTS_BASEBALL_OUTLINED = 0x11C45
    SPORTS_BASEBALL_ROUNDED = 0x11C46
    SPORTS_BASEBALL_SHARP = 0x11C47
    SPORTS_BASKETBALL = 0x11C48
    SPORTS_BASKETBALL_OUTLINED = 0x11C49
    SPORTS_BASKETBALL_ROUNDED = 0x11C4A
    SPORTS_BASKETBALL_SHARP = 0x11C4B
    SPORTS_CRICKET = 0x11C4C
    SPORTS_CRICKET_OUTLINED = 0x11C4D
    SPORTS_CRICKET_ROUNDED = 0x11C4E
    SPORTS_CRICKET_SHARP = 0x11C4F
    SPORTS_ESPORTS = 0x11C50
    SPORTS_ESPORTS_OUTLINED = 0x11C51
    SPORTS_ESPORTS_ROUNDED = 0x11C52
    SPORTS_ESPORTS_SHARP = 0x11C53
    SPORTS_FOOTBALL = 0x11C54
    SPORTS_FOOTBALL_OUTLINED = 0x11C55
    SPORTS_FOOTBALL_ROUNDED = 0x11C56
    SPORTS_FOOTBALL_SHARP = 0x11C57
    SPORTS_GOLF = 0x11C58
    SPORTS_GOLF_OUTLINED = 0x11C59
    SPORTS_GOLF_ROUNDED = 0x11C5A
    SPORTS_GOLF_SHARP = 0x11C5B
    SPORTS_GYMNASTICS = 0x11C5C
    SPORTS_GYMNASTICS_OUTLINED = 0x11C5D
    SPORTS_GYMNASTICS_ROUNDED = 0x11C5E
    SPORTS_GYMNASTICS_SHARP = 0x11C5F
    SPORTS_HANDBALL = 0x11C60
    SPORTS_HANDBALL_OUTLINED = 0x11C61
    SPORTS_HANDBALL_ROUNDED = 0x11C62
    SPORTS_HANDBALL_SHARP = 0x11C63
    SPORTS_HOCKEY = 0x11C64
    SPORTS_HOCKEY_OUTLINED = 0x11C65
    SPORTS_HOCKEY_ROUNDED = 0x11C66
    SPORTS_HOCKEY_SHARP = 0x11C67
    SPORTS_KABADDI = 0x11C68
    SPORTS_KABADDI_OUTLINED = 0x11C69
    SPORTS_KABADDI_ROUNDED = 0x11C6A
    SPORTS_KABADDI_SHARP = 0x11C6B
    SPORTS_MARTIAL_ARTS = 0x11C6C
    SPORTS_MARTIAL_ARTS_OUTLINED = 0x11C6D
    SPORTS_MARTIAL_ARTS_ROUNDED = 0x11C6E
    SPORTS_MARTIAL_ARTS_SHARP = 0x11C6F
    SPORTS_MMA = 0x11C70
    SPORTS_MMA_OUTLINED = 0x11C71
    SPORTS_MMA_ROUNDED = 0x11C72
    SPORTS_MMA_SHARP = 0x11C73
    SPORTS_MOTORSPORTS = 0x11C74
    SPORTS_MOTORSPORTS_OUTLINED = 0x11C75
    SPORTS_MOTORSPORTS_ROUNDED = 0x11C76
    SPORTS_MOTORSPORTS_SHARP = 0x11C77
    SPORTS_OUTLINED = 0x11C78
    SPORTS_ROUNDED = 0x11C79
    SPORTS_RUGBY = 0x11C7A
    SPORTS_RUGBY_OUTLINED = 0x11C7B
    SPORTS_RUGBY_ROUNDED = 0x11C7C
    SPORTS_RUGBY_SHARP = 0x11C7D
    SPORTS_SCORE = 0x11C7E
    SPORTS_SCORE_OUTLINED = 0x11C7F
    SPORTS_SCORE_ROUNDED = 0x11C80
    SPORTS_SCORE_SHARP = 0x11C81
    SPORTS_SHARP = 0x11C82
    SPORTS_SOCCER = 0x11C83
    SPORTS_SOCCER_OUTLINED = 0x11C84
    SPORTS_SOCCER_ROUNDED = 0x11C85
    SPORTS_SOCCER_SHARP = 0x11C86
    SPORTS_TENNIS = 0x11C87
    SPORTS_TENNIS_OUTLINED = 0x11C88
    SPORTS_TENNIS_ROUNDED = 0x11C89
    SPORTS_TENNIS_SHARP = 0x11C8A
    SPORTS_VOLLEYBALL = 0x11C8B
    SPORTS_VOLLEYBALL_OUTLINED = 0x11C8C
    SPORTS_VOLLEYBALL_ROUNDED = 0x11C8D
    SPORTS_VOLLEYBALL_SHARP = 0x11C8E
    SQUARE = 0x11C8F
    SQUARE_FOOT = 0x11C90
    SQUARE_FOOT_OUTLINED = 0x11C91
    SQUARE_FOOT_ROUNDED = 0x11C92
    SQUARE_FOOT_SHARP = 0x11C93
    SQUARE_OUTLINED = 0x11C94
    SQUARE_ROUNDED = 0x11C95
    SQUARE_SHARP = 0x11C96
    SSID_CHART = 0x11C97
    SSID_CHART_OUTLINED = 0x11C98
    SSID_CHART_ROUNDED = 0x11C99
    SSID_CHART_SHARP = 0x11C9A
    STACKED_BAR_CHART = 0x11C9B
    STACKED_BAR_CHART_OUTLINED = 0x11C9C
    STACKED_BAR_CHART_ROUNDED = 0x11C9D
    STACKED_BAR_CHART_SHARP = 0x11C9E
    STACKED_LINE_CHART = 0x11C9F
    STACKED_LINE_CHART_OUTLINED = 0x11CA0
    STACKED_LINE_CHART_ROUNDED = 0x11CA1
    STACKED_LINE_CHART_SHARP = 0x11CA2
    STADIUM = 0x11CA3
    STADIUM_OUTLINED = 0x11CA4
    STADIUM_ROUNDED = 0x11CA5
    STADIUM_SHARP = 0x11CA6
    STAIRS = 0x11CA7
    STAIRS_OUTLINED = 0x11CA8
    STAIRS_ROUNDED = 0x11CA9
    STAIRS_SHARP = 0x11CAA
    STAR = 0x11CAB
    STAR_BORDER = 0x11CAC
    STAR_BORDER_OUTLINED = 0x11CAD
    STAR_BORDER_PURPLE500 = 0x11CAE
    STAR_BORDER_PURPLE500_OUTLINED = 0x11CAF
    STAR_BORDER_PURPLE500_ROUNDED = 0x11CB0
    STAR_BORDER_PURPLE500_SHARP = 0x11CB1
    STAR_BORDER_ROUNDED = 0x11CB2
    STAR_BORDER_SHARP = 0x11CB3
    STAR_HALF = 0x11CB4
    STAR_HALF_OUTLINED = 0x11CB5
    STAR_HALF_ROUNDED = 0x11CB6
    STAR_HALF_SHARP = 0x11CB7
    STAR_OUTLINE = 0x11CB8
    STAR_OUTLINE_OUTLINED = 0x11CB9
    STAR_OUTLINE_ROUNDED = 0x11CBA
    STAR_OUTLINE_SHARP = 0x11CBB
    STAR_OUTLINED = 0x11CBC
    STAR_PURPLE500 = 0x11CBD
    STAR_PURPLE500_OUTLINED = 0x11CBE
    STAR_PURPLE500_ROUNDED = 0x11CBF
    STAR_PURPLE500_SHARP = 0x11CC0
    STAR_RATE = 0x11CC1
    STAR_RATE_OUTLINED = 0x11CC2
    STAR_RATE_ROUNDED = 0x11CC3
    STAR_RATE_SHARP = 0x11CC4
    STAR_ROUNDED = 0x11CC5
    STAR_SHARP = 0x11CC6
    STARS = 0x11CC7
    STARS_OUTLINED = 0x11CC8
    STARS_ROUNDED = 0x11CC9
    STARS_SHARP = 0x11CCA
    START = 0x11CCB
    START_OUTLINED = 0x11CCC
    START_ROUNDED = 0x11CCD
    START_SHARP = 0x11CCE
    STAY_CURRENT_LANDSCAPE = 0x11CCF
    STAY_CURRENT_LANDSCAPE_OUTLINED = 0x11CD0
    STAY_CURRENT_LANDSCAPE_ROUNDED = 0x11CD1
    STAY_CURRENT_LANDSCAPE_SHARP = 0x11CD2
    STAY_CURRENT_PORTRAIT = 0x11CD3
    STAY_CURRENT_PORTRAIT_OUTLINED = 0x11CD4
    STAY_CURRENT_PORTRAIT_ROUNDED = 0x11CD5
    STAY_CURRENT_PORTRAIT_SHARP = 0x11CD6
    STAY_PRIMARY_LANDSCAPE = 0x11CD7
    STAY_PRIMARY_LANDSCAPE_OUTLINED = 0x11CD8
    STAY_PRIMARY_LANDSCAPE_ROUNDED = 0x11CD9
    STAY_PRIMARY_LANDSCAPE_SHARP = 0x11CDA
    STAY_PRIMARY_PORTRAIT = 0x11CDB
    STAY_PRIMARY_PORTRAIT_OUTLINED = 0x11CDC
    STAY_PRIMARY_PORTRAIT_ROUNDED = 0x11CDD
    STAY_PRIMARY_PORTRAIT_SHARP = 0x11CDE
    STICKY_NOTE_2 = 0x11CDF
    STICKY_NOTE_2_OUTLINED = 0x11CE0
    STICKY_NOTE_2_ROUNDED = 0x11CE1
    STICKY_NOTE_2_SHARP = 0x11CE2
    STOP = 0x11CE3
    STOP_CIRCLE = 0x11CE4
    STOP_CIRCLE_OUTLINED = 0x11CE5
    STOP_CIRCLE_ROUNDED = 0x11CE6
    STOP_CIRCLE_SHARP = 0x11CE7
    STOP_OUTLINED = 0x11CE8
    STOP_ROUNDED = 0x11CE9
    STOP_SCREEN_SHARE = 0x11CEA
    STOP_SCREEN_SHARE_OUTLINED = 0x11CEB
    STOP_SCREEN_SHARE_ROUNDED = 0x11CEC
    STOP_SCREEN_SHARE_SHARP = 0x11CED
    STOP_SHARP = 0x11CEE
    STORAGE = 0x11CEF
    STORAGE_OUTLINED = 0x11CF0
    STORAGE_ROUNDED = 0x11CF1
    STORAGE_SHARP = 0x11CF2
    STORE = 0x11CF3
    STORE_MALL_DIRECTORY = 0x11CF4
    STORE_MALL_DIRECTORY_OUTLINED = 0x11CF5
    STORE_MALL_DIRECTORY_ROUNDED = 0x11CF6
    STORE_MALL_DIRECTORY_SHARP = 0x11CF7
    STORE_OUTLINED = 0x11CF8
    STORE_ROUNDED = 0x11CF9
    STORE_SHARP = 0x11CFA
    STOREFRONT = 0x11CFB
    STOREFRONT_OUTLINED = 0x11CFC
    STOREFRONT_ROUNDED = 0x11CFD
    STOREFRONT_SHARP = 0x11CFE
    STORM = 0x11CFF
    STORM_OUTLINED = 0x11D00
    STORM_ROUNDED = 0x11D01
    STORM_SHARP = 0x11D02
    STRAIGHT = 0x11D03
    STRAIGHT_OUTLINED = 0x11D04
    STRAIGHT_ROUNDED = 0x11D05
    STRAIGHT_SHARP = 0x11D06
    STRAIGHTEN = 0x11D07
    STRAIGHTEN_OUTLINED = 0x11D08
    STRAIGHTEN_ROUNDED = 0x11D09
    STRAIGHTEN_SHARP = 0x11D0A
    STREAM = 0x11D0B
    STREAM_OUTLINED = 0x11D0C
    STREAM_ROUNDED = 0x11D0D
    STREAM_SHARP = 0x11D0E
    STREETVIEW = 0x11D0F
    STREETVIEW_OUTLINED = 0x11D10
    STREETVIEW_ROUNDED = 0x11D11
    STREETVIEW_SHARP = 0x11D12
    STRIKETHROUGH_S = 0x11D13
    STRIKETHROUGH_S_OUTLINED = 0x11D14
    STRIKETHROUGH_S_ROUNDED = 0x11D15
    STRIKETHROUGH_S_SHARP = 0x11D16
    STROLLER = 0x11D17
    STROLLER_OUTLINED = 0x11D18
    STROLLER_ROUNDED = 0x11D19
    STROLLER_SHARP = 0x11D1A
    STYLE = 0x11D1B
    STYLE_OUTLINED = 0x11D1C
    STYLE_ROUNDED = 0x11D1D
    STYLE_SHARP = 0x11D1E
    SUBDIRECTORY_ARROW_LEFT = 0x11D1F
    SUBDIRECTORY_ARROW_LEFT_OUTLINED = 0x11D20
    SUBDIRECTORY_ARROW_LEFT_ROUNDED = 0x11D21
    SUBDIRECTORY_ARROW_LEFT_SHARP = 0x11D22
    SUBDIRECTORY_ARROW_RIGHT = 0x11D23
    SUBDIRECTORY_ARROW_RIGHT_OUTLINED = 0x11D24
    SUBDIRECTORY_ARROW_RIGHT_ROUNDED = 0x11D25
    SUBDIRECTORY_ARROW_RIGHT_SHARP = 0x11D26
    SUBJECT = 0x11D27
    SUBJECT_OUTLINED = 0x11D28
    SUBJECT_ROUNDED = 0x11D29
    SUBJECT_SHARP = 0x11D2A
    SUBSCRIPT = 0x11D2B
    SUBSCRIPT_OUTLINED = 0x11D2C
    SUBSCRIPT_ROUNDED = 0x11D2D
    SUBSCRIPT_SHARP = 0x11D2E
    SUBSCRIPTIONS = 0x11D2F
    SUBSCRIPTIONS_OUTLINED = 0x11D30
    SUBSCRIPTIONS_ROUNDED = 0x11D31
    SUBSCRIPTIONS_SHARP = 0x11D32
    SUBTITLES = 0x11D33
    SUBTITLES_OFF = 0x11D34
    SUBTITLES_OFF_OUTLINED = 0x11D35
    SUBTITLES_OFF_ROUNDED = 0x11D36
    SUBTITLES_OFF_SHARP = 0x11D37
    SUBTITLES_OUTLINED = 0x11D38
    SUBTITLES_ROUNDED = 0x11D39
    SUBTITLES_SHARP = 0x11D3A
    SUBWAY = 0x11D3B
    SUBWAY_OUTLINED = 0x11D3C
    SUBWAY_ROUNDED = 0x11D3D
    SUBWAY_SHARP = 0x11D3E
    SUMMARIZE = 0x11D3F
    SUMMARIZE_OUTLINED = 0x11D40
    SUMMARIZE_ROUNDED = 0x11D41
    SUMMARIZE_SHARP = 0x11D42
    SUNNY = 0x11D43
    SUNNY_SNOWING = 0x11D44
    SUPERSCRIPT = 0x11D45
    SUPERSCRIPT_OUTLINED = 0x11D46
    SUPERSCRIPT_ROUNDED = 0x11D47
    SUPERSCRIPT_SHARP = 0x11D48
    SUPERVISED_USER_CIRCLE = 0x11D49
    SUPERVISED_USER_CIRCLE_OUTLINED = 0x11D4A
    SUPERVISED_USER_CIRCLE_ROUNDED = 0x11D4B
    SUPERVISED_USER_CIRCLE_SHARP = 0x11D4C
    SUPERVISOR_ACCOUNT = 0x11D4D
    SUPERVISOR_ACCOUNT_OUTLINED = 0x11D4E
    SUPERVISOR_ACCOUNT_ROUNDED = 0x11D4F
    SUPERVISOR_ACCOUNT_SHARP = 0x11D50
    SUPPORT = 0x11D51
    SUPPORT_AGENT = 0x11D52
    SUPPORT_AGENT_OUTLINED = 0x11D53
    SUPPORT_AGENT_ROUNDED = 0x11D54
    SUPPORT_AGENT_SHARP = 0x11D55
    SUPPORT_OUTLINED = 0x11D56
    SUPPORT_ROUNDED = 0x11D57
    SUPPORT_SHARP = 0x11D58
    SURFING = 0x11D59
    SURFING_OUTLINED = 0x11D5A
    SURFING_ROUNDED = 0x11D5B
    SURFING_SHARP = 0x11D5C
    SURROUND_SOUND = 0x11D5D
    SURROUND_SOUND_OUTLINED = 0x11D5E
    SURROUND_SOUND_ROUNDED = 0x11D5F
    SURROUND_SOUND_SHARP = 0x11D60
    SWAP_CALLS = 0x11D61
    SWAP_CALLS_OUTLINED = 0x11D62
    SWAP_CALLS_ROUNDED = 0x11D63
    SWAP_CALLS_SHARP = 0x11D64
    SWAP_HORIZ = 0x11D65
    SWAP_HORIZ_OUTLINED = 0x11D66
    SWAP_HORIZ_ROUNDED = 0x11D67
    SWAP_HORIZ_SHARP = 0x11D68
    SWAP_HORIZONTAL_CIRCLE = 0x11D69
    SWAP_HORIZONTAL_CIRCLE_OUTLINED = 0x11D6A
    SWAP_HORIZONTAL_CIRCLE_ROUNDED = 0x11D6B
    SWAP_HORIZONTAL_CIRCLE_SHARP = 0x11D6C
    SWAP_VERT = 0x11D6D
    SWAP_VERT_CIRCLE = 0x11D6E
    SWAP_VERT_CIRCLE_OUTLINED = 0x11D6F
    SWAP_VERT_CIRCLE_ROUNDED = 0x11D70
    SWAP_VERT_CIRCLE_SHARP = 0x11D71
    SWAP_VERT_OUTLINED = 0x11D72
    SWAP_VERT_ROUNDED = 0x11D73
    SWAP_VERT_SHARP = 0x11D74
    SWAP_VERTICAL_CIRCLE = 0x11D75
    SWAP_VERTICAL_CIRCLE_OUTLINED = 0x11D76
    SWAP_VERTICAL_CIRCLE_ROUNDED = 0x11D77
    SWAP_VERTICAL_CIRCLE_SHARP = 0x11D78
    SWIPE = 0x11D79
    SWIPE_DOWN = 0x11D7A
    SWIPE_DOWN_ALT = 0x11D7B
    SWIPE_DOWN_ALT_OUTLINED = 0x11D7C
    SWIPE_DOWN_ALT_ROUNDED = 0x11D7D
    SWIPE_DOWN_ALT_SHARP = 0x11D7E
    SWIPE_DOWN_OUTLINED = 0x11D7F
    SWIPE_DOWN_ROUNDED = 0x11D80
    SWIPE_DOWN_SHARP = 0x11D81
    SWIPE_LEFT = 0x11D82
    SWIPE_LEFT_ALT = 0x11D83
    SWIPE_LEFT_ALT_OUTLINED = 0x11D84
    SWIPE_LEFT_ALT_ROUNDED = 0x11D85
    SWIPE_LEFT_ALT_SHARP = 0x11D86
    SWIPE_LEFT_OUTLINED = 0x11D87
    SWIPE_LEFT_ROUNDED = 0x11D88
    SWIPE_LEFT_SHARP = 0x11D89
    SWIPE_OUTLINED = 0x11D8A
    SWIPE_RIGHT = 0x11D8B
    SWIPE_RIGHT_ALT = 0x11D8C
    SWIPE_RIGHT_ALT_OUTLINED = 0x11D8D
    SWIPE_RIGHT_ALT_ROUNDED = 0x11D8E
    SWIPE_RIGHT_ALT_SHARP = 0x11D8F
    SWIPE_RIGHT_OUTLINED = 0x11D90
    SWIPE_RIGHT_ROUNDED = 0x11D91
    SWIPE_RIGHT_SHARP = 0x11D92
    SWIPE_ROUNDED = 0x11D93
    SWIPE_SHARP = 0x11D94
    SWIPE_UP = 0x11D95
    SWIPE_UP_ALT = 0x11D96
    SWIPE_UP_ALT_OUTLINED = 0x11D97
    SWIPE_UP_ALT_ROUNDED = 0x11D98
    SWIPE_UP_ALT_SHARP = 0x11D99
    SWIPE_UP_OUTLINED = 0x11D9A
    SWIPE_UP_ROUNDED = 0x11D9B
    SWIPE_UP_SHARP = 0x11D9C
    SWIPE_VERTICAL = 0x11D9D
    SWIPE_VERTICAL_OUTLINED = 0x11D9E
    SWIPE_VERTICAL_ROUNDED = 0x11D9F
    SWIPE_VERTICAL_SHARP = 0x11DA0
    SWITCH_ACCESS_SHORTCUT = 0x11DA1
    SWITCH_ACCESS_SHORTCUT_ADD = 0x11DA2
    SWITCH_ACCESS_SHORTCUT_ADD_OUTLINED = 0x11DA3
    SWITCH_ACCESS_SHORTCUT_ADD_ROUNDED = 0x11DA4
    SWITCH_ACCESS_SHORTCUT_ADD_SHARP = 0x11DA5
    SWITCH_ACCESS_SHORTCUT_OUTLINED = 0x11DA6
    SWITCH_ACCESS_SHORTCUT_ROUNDED = 0x11DA7
    SWITCH_ACCESS_SHORTCUT_SHARP = 0x11DA8
    SWITCH_ACCOUNT = 0x11DA9
    SWITCH_ACCOUNT_OUTLINED = 0x11DAA
    SWITCH_ACCOUNT_ROUNDED = 0x11DAB
    SWITCH_ACCOUNT_SHARP = 0x11DAC
    SWITCH_CAMERA = 0x11DAD
    SWITCH_CAMERA_OUTLINED = 0x11DAE
    SWITCH_CAMERA_ROUNDED = 0x11DAF
    SWITCH_CAMERA_SHARP = 0x11DB0
    SWITCH_LEFT = 0x11DB1
    SWITCH_LEFT_OUTLINED = 0x11DB2
    SWITCH_LEFT_ROUNDED = 0x11DB3
    SWITCH_LEFT_SHARP = 0x11DB4
    SWITCH_RIGHT = 0x11DB5
    SWITCH_RIGHT_OUTLINED = 0x11DB6
    SWITCH_RIGHT_ROUNDED = 0x11DB7
    SWITCH_RIGHT_SHARP = 0x11DB8
    SWITCH_VIDEO = 0x11DB9
    SWITCH_VIDEO_OUTLINED = 0x11DBA
    SWITCH_VIDEO_ROUNDED = 0x11DBB
    SWITCH_VIDEO_SHARP = 0x11DBC
    SYNAGOGUE = 0x11DBD
    SYNAGOGUE_OUTLINED = 0x11DBE
    SYNAGOGUE_ROUNDED = 0x11DBF
    SYNAGOGUE_SHARP = 0x11DC0
    SYNC = 0x11DC1
    SYNC_ALT = 0x11DC2
    SYNC_ALT_OUTLINED = 0x11DC3
    SYNC_ALT_ROUNDED = 0x11DC4
    SYNC_ALT_SHARP = 0x11DC5
    SYNC_DISABLED = 0x11DC6
    SYNC_DISABLED_OUTLINED = 0x11DC7
    SYNC_DISABLED_ROUNDED = 0x11DC8
    SYNC_DISABLED_SHARP = 0x11DC9
    SYNC_LOCK = 0x11DCA
    SYNC_LOCK_OUTLINED = 0x11DCB
    SYNC_LOCK_ROUNDED = 0x11DCC
    SYNC_LOCK_SHARP = 0x11DCD
    SYNC_OUTLINED = 0x11DCE
    SYNC_PROBLEM = 0x11DCF
    SYNC_PROBLEM_OUTLINED = 0x11DD0
    SYNC_PROBLEM_ROUNDED = 0x11DD1
    SYNC_PROBLEM_SHARP = 0x11DD2
    SYNC_ROUNDED = 0x11DD3
    SYNC_SHARP = 0x11DD4
    SYSTEM_SECURITY_UPDATE = 0x11DD5
    SYSTEM_SECURITY_UPDATE_GOOD = 0x11DD6
    SYSTEM_SECURITY_UPDATE_GOOD_OUTLINED = 0x11DD7
    SYSTEM_SECURITY_UPDATE_GOOD_ROUNDED = 0x11DD8
    SYSTEM_SECURITY_UPDATE_GOOD_SHARP = 0x11DD9
    SYSTEM_SECURITY_UPDATE_OUTLINED = 0x11DDA
    SYSTEM_SECURITY_UPDATE_ROUNDED = 0x11DDB
    SYSTEM_SECURITY_UPDATE_SHARP = 0x11DDC
    SYSTEM_SECURITY_UPDATE_WARNING = 0x11DDD
    SYSTEM_SECURITY_UPDATE_WARNING_OUTLINED = 0x11DDE
    SYSTEM_SECURITY_UPDATE_WARNING_ROUNDED = 0x11DDF
    SYSTEM_SECURITY_UPDATE_WARNING_SHARP = 0x11DE0
    SYSTEM_UPDATE = 0x11DE1
    SYSTEM_UPDATE_ALT = 0x11DE2
    SYSTEM_UPDATE_ALT_OUTLINED = 0x11DE3
    SYSTEM_UPDATE_ALT_ROUNDED = 0x11DE4
    SYSTEM_UPDATE_ALT_SHARP = 0x11DE5
    SYSTEM_UPDATE_OUTLINED = 0x11DE6
    SYSTEM_UPDATE_ROUNDED = 0x11DE7
    SYSTEM_UPDATE_SHARP = 0x11DE8
    SYSTEM_UPDATE_TV = 0x11DE9
    SYSTEM_UPDATE_TV_OUTLINED = 0x11DEA
    SYSTEM_UPDATE_TV_ROUNDED = 0x11DEB
    SYSTEM_UPDATE_TV_SHARP = 0x11DEC
    TAB = 0x11DED
    TAB_OUTLINED = 0x11DEE
    TAB_ROUNDED = 0x11DEF
    TAB_SHARP = 0x11DF0
    TAB_UNSELECTED = 0x11DF1
    TAB_UNSELECTED_OUTLINED = 0x11DF2
    TAB_UNSELECTED_ROUNDED = 0x11DF3
    TAB_UNSELECTED_SHARP = 0x11DF4
    TABLE_BAR = 0x11DF5
    TABLE_BAR_OUTLINED = 0x11DF6
    TABLE_BAR_ROUNDED = 0x11DF7
    TABLE_BAR_SHARP = 0x11DF8
    TABLE_CHART = 0x11DF9
    TABLE_CHART_OUTLINED = 0x11DFA
    TABLE_CHART_ROUNDED = 0x11DFB
    TABLE_CHART_SHARP = 0x11DFC
    TABLE_RESTAURANT = 0x11DFD
    TABLE_RESTAURANT_OUTLINED = 0x11DFE
    TABLE_RESTAURANT_ROUNDED = 0x11DFF
    TABLE_RESTAURANT_SHARP = 0x11E00
    TABLE_ROWS = 0x11E01
    TABLE_ROWS_OUTLINED = 0x11E02
    TABLE_ROWS_ROUNDED = 0x11E03
    TABLE_ROWS_SHARP = 0x11E04
    TABLE_VIEW = 0x11E05
    TABLE_VIEW_OUTLINED = 0x11E06
    TABLE_VIEW_ROUNDED = 0x11E07
    TABLE_VIEW_SHARP = 0x11E08
    TABLET = 0x11E09
    TABLET_ANDROID = 0x11E0A
    TABLET_ANDROID_OUTLINED = 0x11E0B
    TABLET_ANDROID_ROUNDED = 0x11E0C
    TABLET_ANDROID_SHARP = 0x11E0D
    TABLET_MAC = 0x11E0E
    TABLET_MAC_OUTLINED = 0x11E0F
    TABLET_MAC_ROUNDED = 0x11E10
    TABLET_MAC_SHARP = 0x11E11
    TABLET_OUTLINED = 0x11E12
    TABLET_ROUNDED = 0x11E13
    TABLET_SHARP = 0x11E14
    TAG = 0x11E15
    TAG_FACES = 0x11E16
    TAG_FACES_OUTLINED = 0x11E17
    TAG_FACES_ROUNDED = 0x11E18
    TAG_FACES_SHARP = 0x11E19
    TAG_OUTLINED = 0x11E1A
    TAG_ROUNDED = 0x11E1B
    TAG_SHARP = 0x11E1C
    TAKEOUT_DINING = 0x11E1D
    TAKEOUT_DINING_OUTLINED = 0x11E1E
    TAKEOUT_DINING_ROUNDED = 0x11E1F
    TAKEOUT_DINING_SHARP = 0x11E20
    TAP_AND_PLAY = 0x11E21
    TAP_AND_PLAY_OUTLINED = 0x11E22
    TAP_AND_PLAY_ROUNDED = 0x11E23
    TAP_AND_PLAY_SHARP = 0x11E24
    TAPAS = 0x11E25
    TAPAS_OUTLINED = 0x11E26
    TAPAS_ROUNDED = 0x11E27
    TAPAS_SHARP = 0x11E28
    TASK = 0x11E29
    TASK_ALT = 0x11E2A
    TASK_ALT_OUTLINED = 0x11E2B
    TASK_ALT_ROUNDED = 0x11E2C
    TASK_ALT_SHARP = 0x11E2D
    TASK_OUTLINED = 0x11E2E
    TASK_ROUNDED = 0x11E2F
    TASK_SHARP = 0x11E30
    TAXI_ALERT = 0x11E31
    TAXI_ALERT_OUTLINED = 0x11E32
    TAXI_ALERT_ROUNDED = 0x11E33
    TAXI_ALERT_SHARP = 0x11E34
    TELEGRAM = 0x11E35
    TELEGRAM_OUTLINED = 0x11E36
    TELEGRAM_ROUNDED = 0x11E37
    TELEGRAM_SHARP = 0x11E38
    TEMPLE_BUDDHIST = 0x11E39
    TEMPLE_BUDDHIST_OUTLINED = 0x11E3A
    TEMPLE_BUDDHIST_ROUNDED = 0x11E3B
    TEMPLE_BUDDHIST_SHARP = 0x11E3C
    TEMPLE_HINDU = 0x11E3D
    TEMPLE_HINDU_OUTLINED = 0x11E3E
    TEMPLE_HINDU_ROUNDED = 0x11E3F
    TEMPLE_HINDU_SHARP = 0x11E40
    TEN_K = 0x11E41
    TEN_K_OUTLINED = 0x11E42
    TEN_K_ROUNDED = 0x11E43
    TEN_K_SHARP = 0x11E44
    TEN_MP = 0x11E45
    TEN_MP_OUTLINED = 0x11E46
    TEN_MP_ROUNDED = 0x11E47
    TEN_MP_SHARP = 0x11E48
    TERMINAL = 0x11E49
    TERMINAL_OUTLINED = 0x11E4A
    TERMINAL_ROUNDED = 0x11E4B
    TERMINAL_SHARP = 0x11E4C
    TERRAIN = 0x11E4D
    TERRAIN_OUTLINED = 0x11E4E
    TERRAIN_ROUNDED = 0x11E4F
    TERRAIN_SHARP = 0x11E50
    TEXT_DECREASE = 0x11E51
    TEXT_DECREASE_OUTLINED = 0x11E52
    TEXT_DECREASE_ROUNDED = 0x11E53
    TEXT_DECREASE_SHARP = 0x11E54
    TEXT_FIELDS = 0x11E55
    TEXT_FIELDS_OUTLINED = 0x11E56
    TEXT_FIELDS_ROUNDED = 0x11E57
    TEXT_FIELDS_SHARP = 0x11E58
    TEXT_FORMAT = 0x11E59
    TEXT_FORMAT_OUTLINED = 0x11E5A
    TEXT_FORMAT_ROUNDED = 0x11E5B
    TEXT_FORMAT_SHARP = 0x11E5C
    TEXT_INCREASE = 0x11E5D
    TEXT_INCREASE_OUTLINED = 0x11E5E
    TEXT_INCREASE_ROUNDED = 0x11E5F
    TEXT_INCREASE_SHARP = 0x11E60
    TEXT_ROTATE_UP = 0x11E61
    TEXT_ROTATE_UP_OUTLINED = 0x11E62
    TEXT_ROTATE_UP_ROUNDED = 0x11E63
    TEXT_ROTATE_UP_SHARP = 0x11E64
    TEXT_ROTATE_VERTICAL = 0x11E65
    TEXT_ROTATE_VERTICAL_OUTLINED = 0x11E66
    TEXT_ROTATE_VERTICAL_ROUNDED = 0x11E67
    TEXT_ROTATE_VERTICAL_SHARP = 0x11E68
    TEXT_ROTATION_ANGLEDOWN = 0x11E69
    TEXT_ROTATION_ANGLEDOWN_OUTLINED = 0x11E6A
    TEXT_ROTATION_ANGLEDOWN_ROUNDED = 0x11E6B
    TEXT_ROTATION_ANGLEDOWN_SHARP = 0x11E6C
    TEXT_ROTATION_ANGLEUP = 0x11E6D
    TEXT_ROTATION_ANGLEUP_OUTLINED = 0x11E6E
    TEXT_ROTATION_ANGLEUP_ROUNDED = 0x11E6F
    TEXT_ROTATION_ANGLEUP_SHARP = 0x11E70
    TEXT_ROTATION_DOWN = 0x11E71
    TEXT_ROTATION_DOWN_OUTLINED = 0x11E72
    TEXT_ROTATION_DOWN_ROUNDED = 0x11E73
    TEXT_ROTATION_DOWN_SHARP = 0x11E74
    TEXT_ROTATION_NONE = 0x11E75
    TEXT_ROTATION_NONE_OUTLINED = 0x11E76
    TEXT_ROTATION_NONE_ROUNDED = 0x11E77
    TEXT_ROTATION_NONE_SHARP = 0x11E78
    TEXT_SNIPPET = 0x11E79
    TEXT_SNIPPET_OUTLINED = 0x11E7A
    TEXT_SNIPPET_ROUNDED = 0x11E7B
    TEXT_SNIPPET_SHARP = 0x11E7C
    TEXTSMS = 0x11E7D
    TEXTSMS_OUTLINED = 0x11E7E
    TEXTSMS_ROUNDED = 0x11E7F
    TEXTSMS_SHARP = 0x11E80
    TEXTURE = 0x11E81
    TEXTURE_OUTLINED = 0x11E82
    TEXTURE_ROUNDED = 0x11E83
    TEXTURE_SHARP = 0x11E84
    THEATER_COMEDY = 0x11E85
    THEATER_COMEDY_OUTLINED = 0x11E86
    THEATER_COMEDY_ROUNDED = 0x11E87
    THEATER_COMEDY_SHARP = 0x11E88
    THEATERS = 0x11E89
    THEATERS_OUTLINED = 0x11E8A
    THEATERS_ROUNDED = 0x11E8B
    THEATERS_SHARP = 0x11E8C
    THERMOSTAT = 0x11E8D
    THERMOSTAT_AUTO = 0x11E8E
    THERMOSTAT_AUTO_OUTLINED = 0x11E8F
    THERMOSTAT_AUTO_ROUNDED = 0x11E90
    THERMOSTAT_AUTO_SHARP = 0x11E91
    THERMOSTAT_OUTLINED = 0x11E92
    THERMOSTAT_ROUNDED = 0x11E93
    THERMOSTAT_SHARP = 0x11E94
    THIRTEEN_MP = 0x11E95
    THIRTEEN_MP_OUTLINED = 0x11E96
    THIRTEEN_MP_ROUNDED = 0x11E97
    THIRTEEN_MP_SHARP = 0x11E98
    THIRTY_FPS = 0x11E99
    THIRTY_FPS_OUTLINED = 0x11E9A
    THIRTY_FPS_ROUNDED = 0x11E9B
    THIRTY_FPS_SELECT = 0x11E9C
    THIRTY_FPS_SELECT_OUTLINED = 0x11E9D
    THIRTY_FPS_SELECT_ROUNDED = 0x11E9E
    THIRTY_FPS_SELECT_SHARP = 0x11E9F
    THIRTY_FPS_SHARP = 0x11EA0
    THREE_G_MOBILEDATA = 0x11EA1
    THREE_G_MOBILEDATA_OUTLINED = 0x11EA2
    THREE_G_MOBILEDATA_ROUNDED = 0x11EA3
    THREE_G_MOBILEDATA_SHARP = 0x11EA4
    THREE_K = 0x11EA5
    THREE_K_OUTLINED = 0x11EA6
    THREE_K_PLUS = 0x11EA7
    THREE_K_PLUS_OUTLINED = 0x11EA8
    THREE_K_PLUS_ROUNDED = 0x11EA9
    THREE_K_PLUS_SHARP = 0x11EAA
    THREE_K_ROUNDED = 0x11EAB
    THREE_K_SHARP = 0x11EAC
    THREE_MP = 0x11EAD
    THREE_MP_OUTLINED = 0x11EAE
    THREE_MP_ROUNDED = 0x11EAF
    THREE_MP_SHARP = 0x11EB0
    THREE_P = 0x11EB1
    THREE_P_OUTLINED = 0x11EB2
    THREE_P_ROUNDED = 0x11EB3
    THREE_P_SHARP = 0x11EB4
    THREED_ROTATION = 0x11EB5
    THREED_ROTATION_OUTLINED = 0x11EB6
    THREED_ROTATION_ROUNDED = 0x11EB7
    THREED_ROTATION_SHARP = 0x11EB8
    THREESIXTY = 0x11EB9
    THREESIXTY_OUTLINED = 0x11EBA
    THREESIXTY_ROUNDED = 0x11EBB
    THREESIXTY_SHARP = 0x11EBC
    THUMB_DOWN = 0x11EBD
    THUMB_DOWN_ALT = 0x11EBE
    THUMB_DOWN_ALT_OUTLINED = 0x11EBF
    THUMB_DOWN_ALT_ROUNDED = 0x11EC0
    THUMB_DOWN_ALT_SHARP = 0x11EC1
    THUMB_DOWN_OFF_ALT = 0x11EC2
    THUMB_DOWN_OFF_ALT_OUTLINED = 0x11EC3
    THUMB_DOWN_OFF_ALT_ROUNDED = 0x11EC4
    THUMB_DOWN_OFF_ALT_SHARP = 0x11EC5
    THUMB_DOWN_OUTLINED = 0x11EC6
    THUMB_DOWN_ROUNDED = 0x11EC7
    THUMB_DOWN_SHARP = 0x11EC8
    THUMB_UP = 0x11EC9
    THUMB_UP_ALT = 0x11ECA
    THUMB_UP_ALT_OUTLINED = 0x11ECB
    THUMB_UP_ALT_ROUNDED = 0x11ECC
    THUMB_UP_ALT_SHARP = 0x11ECD
    THUMB_UP_OFF_ALT = 0x11ECE
    THUMB_UP_OFF_ALT_OUTLINED = 0x11ECF
    THUMB_UP_OFF_ALT_ROUNDED = 0x11ED0
    THUMB_UP_OFF_ALT_SHARP = 0x11ED1
    THUMB_UP_OUTLINED = 0x11ED2
    THUMB_UP_ROUNDED = 0x11ED3
    THUMB_UP_SHARP = 0x11ED4
    THUMBS_UP_DOWN = 0x11ED5
    THUMBS_UP_DOWN_OUTLINED = 0x11ED6
    THUMBS_UP_DOWN_ROUNDED = 0x11ED7
    THUMBS_UP_DOWN_SHARP = 0x11ED8
    THUNDERSTORM = 0x11ED9
    THUNDERSTORM_OUTLINED = 0x11EDA
    THUNDERSTORM_ROUNDED = 0x11EDB
    THUNDERSTORM_SHARP = 0x11EDC
    TIKTOK = 0x11EDD
    TIKTOK_OUTLINED = 0x11EDE
    TIKTOK_ROUNDED = 0x11EDF
    TIKTOK_SHARP = 0x11EE0
    TIME_TO_LEAVE = 0x11EE1
    TIME_TO_LEAVE_OUTLINED = 0x11EE2
    TIME_TO_LEAVE_ROUNDED = 0x11EE3
    TIME_TO_LEAVE_SHARP = 0x11EE4
    TIMELAPSE = 0x11EE5
    TIMELAPSE_OUTLINED = 0x11EE6
    TIMELAPSE_ROUNDED = 0x11EE7
    TIMELAPSE_SHARP = 0x11EE8
    TIMELINE = 0x11EE9
    TIMELINE_OUTLINED = 0x11EEA
    TIMELINE_ROUNDED = 0x11EEB
    TIMELINE_SHARP = 0x11EEC
    TIMER = 0x11EED
    TIMER_10 = 0x11EEE
    TIMER_10_OUTLINED = 0x11EEF
    TIMER_10_ROUNDED = 0x11EF0
    TIMER_10_SELECT = 0x11EF1
    TIMER_10_SELECT_OUTLINED = 0x11EF2
    TIMER_10_SELECT_ROUNDED = 0x11EF3
    TIMER_10_SELECT_SHARP = 0x11EF4
    TIMER_10_SHARP = 0x11EF5
    TIMER_3 = 0x11EF6
    TIMER_3_OUTLINED = 0x11EF7
    TIMER_3_ROUNDED = 0x11EF8
    TIMER_3_SELECT = 0x11EF9
    TIMER_3_SELECT_OUTLINED = 0x11EFA
    TIMER_3_SELECT_ROUNDED = 0x11EFB
    TIMER_3_SELECT_SHARP = 0x11EFC
    TIMER_3_SHARP = 0x11EFD
    TIMER_OFF = 0x11EFE
    TIMER_OFF_OUTLINED = 0x11EFF
    TIMER_OFF_ROUNDED = 0x11F00
    TIMER_OFF_SHARP = 0x11F01
    TIMER_OUTLINED = 0x11F02
    TIMER_ROUNDED = 0x11F03
    TIMER_SHARP = 0x11F04
    TIPS_AND_UPDATES = 0x11F05
    TIPS_AND_UPDATES_OUTLINED = 0x11F06
    TIPS_AND_UPDATES_ROUNDED = 0x11F07
    TIPS_AND_UPDATES_SHARP = 0x11F08
    TIRE_REPAIR = 0x11F09
    TIRE_REPAIR_OUTLINED = 0x11F0A
    TIRE_REPAIR_ROUNDED = 0x11F0B
    TIRE_REPAIR_SHARP = 0x11F0C
    TITLE = 0x11F0D
    TITLE_OUTLINED = 0x11F0E
    TITLE_ROUNDED = 0x11F0F
    TITLE_SHARP = 0x11F10
    TOC = 0x11F11
    TOC_OUTLINED = 0x11F12
    TOC_ROUNDED = 0x11F13
    TOC_SHARP = 0x11F14
    TODAY = 0x11F15
    TODAY_OUTLINED = 0x11F16
    TODAY_ROUNDED = 0x11F17
    TODAY_SHARP = 0x11F18
    TOGGLE_OFF = 0x11F19
    TOGGLE_OFF_OUTLINED = 0x11F1A
    TOGGLE_OFF_ROUNDED = 0x11F1B
    TOGGLE_OFF_SHARP = 0x11F1C
    TOGGLE_ON = 0x11F1D
    TOGGLE_ON_OUTLINED = 0x11F1E
    TOGGLE_ON_ROUNDED = 0x11F1F
    TOGGLE_ON_SHARP = 0x11F20
    TOKEN = 0x11F21
    TOKEN_OUTLINED = 0x11F22
    TOKEN_ROUNDED = 0x11F23
    TOKEN_SHARP = 0x11F24
    TOLL = 0x11F25
    TOLL_OUTLINED = 0x11F26
    TOLL_ROUNDED = 0x11F27
    TOLL_SHARP = 0x11F28
    TONALITY = 0x11F29
    TONALITY_OUTLINED = 0x11F2A
    TONALITY_ROUNDED = 0x11F2B
    TONALITY_SHARP = 0x11F2C
    TOPIC = 0x11F2D
    TOPIC_OUTLINED = 0x11F2E
    TOPIC_ROUNDED = 0x11F2F
    TOPIC_SHARP = 0x11F30
    TORNADO = 0x11F31
    TORNADO_OUTLINED = 0x11F32
    TORNADO_ROUNDED = 0x11F33
    TORNADO_SHARP = 0x11F34
    TOUCH_APP = 0x11F35
    TOUCH_APP_OUTLINED = 0x11F36
    TOUCH_APP_ROUNDED = 0x11F37
    TOUCH_APP_SHARP = 0x11F38
    TOUR = 0x11F39
    TOUR_OUTLINED = 0x11F3A
    TOUR_ROUNDED = 0x11F3B
    TOUR_SHARP = 0x11F3C
    TOYS = 0x11F3D
    TOYS_OUTLINED = 0x11F3E
    TOYS_ROUNDED = 0x11F3F
    TOYS_SHARP = 0x11F40
    TRACK_CHANGES = 0x11F41
    TRACK_CHANGES_OUTLINED = 0x11F42
    TRACK_CHANGES_ROUNDED = 0x11F43
    TRACK_CHANGES_SHARP = 0x11F44
    TRAFFIC = 0x11F45
    TRAFFIC_OUTLINED = 0x11F46
    TRAFFIC_ROUNDED = 0x11F47
    TRAFFIC_SHARP = 0x11F48
    TRAIN = 0x11F49
    TRAIN_OUTLINED = 0x11F4A
    TRAIN_ROUNDED = 0x11F4B
    TRAIN_SHARP = 0x11F4C
    TRAM = 0x11F4D
    TRAM_OUTLINED = 0x11F4E
    TRAM_ROUNDED = 0x11F4F
    TRAM_SHARP = 0x11F50
    TRANSCRIBE = 0x11F51
    TRANSCRIBE_OUTLINED = 0x11F52
    TRANSCRIBE_ROUNDED = 0x11F53
    TRANSCRIBE_SHARP = 0x11F54
    TRANSFER_WITHIN_A_STATION = 0x11F55
    TRANSFER_WITHIN_A_STATION_OUTLINED = 0x11F56
    TRANSFER_WITHIN_A_STATION_ROUNDED = 0x11F57
    TRANSFER_WITHIN_A_STATION_SHARP = 0x11F58
    TRANSFORM = 0x11F59
    TRANSFORM_OUTLINED = 0x11F5A
    TRANSFORM_ROUNDED = 0x11F5B
    TRANSFORM_SHARP = 0x11F5C
    TRANSGENDER = 0x11F5D
    TRANSGENDER_OUTLINED = 0x11F5E
    TRANSGENDER_ROUNDED = 0x11F5F
    TRANSGENDER_SHARP = 0x11F60
    TRANSIT_ENTEREXIT = 0x11F61
    TRANSIT_ENTEREXIT_OUTLINED = 0x11F62
    TRANSIT_ENTEREXIT_ROUNDED = 0x11F63
    TRANSIT_ENTEREXIT_SHARP = 0x11F64
    TRANSLATE = 0x11F65
    TRANSLATE_OUTLINED = 0x11F66
    TRANSLATE_ROUNDED = 0x11F67
    TRANSLATE_SHARP = 0x11F68
    TRAVEL_EXPLORE = 0x11F69
    TRAVEL_EXPLORE_OUTLINED = 0x11F6A
    TRAVEL_EXPLORE_ROUNDED = 0x11F6B
    TRAVEL_EXPLORE_SHARP = 0x11F6C
    TRENDING_DOWN = 0x11F6D
    TRENDING_DOWN_OUTLINED = 0x11F6E
    TRENDING_DOWN_ROUNDED = 0x11F6F
    TRENDING_DOWN_SHARP = 0x11F70
    TRENDING_FLAT = 0x11F71
    TRENDING_FLAT_OUTLINED = 0x11F72
    TRENDING_FLAT_ROUNDED = 0x11F73
    TRENDING_FLAT_SHARP = 0x11F74
    TRENDING_NEUTRAL = 0x11F75
    TRENDING_NEUTRAL_OUTLINED = 0x11F76
    TRENDING_NEUTRAL_ROUNDED = 0x11F77
    TRENDING_NEUTRAL_SHARP = 0x11F78
    TRENDING_UP = 0x11F79
    TRENDING_UP_OUTLINED = 0x11F7A
    TRENDING_UP_ROUNDED = 0x11F7B
    TRENDING_UP_SHARP = 0x11F7C
    TRIP_ORIGIN = 0x11F7D
    TRIP_ORIGIN_OUTLINED = 0x11F7E
    TRIP_ORIGIN_ROUNDED = 0x11F7F
    TRIP_ORIGIN_SHARP = 0x11F80
    TROLLEY = 0x11F81
    TROUBLESHOOT = 0x11F82
    TROUBLESHOOT_OUTLINED = 0x11F83
    TROUBLESHOOT_ROUNDED = 0x11F84
    TROUBLESHOOT_SHARP = 0x11F85
    TRY_SMS_STAR = 0x11F86
    TRY_SMS_STAR_OUTLINED = 0x11F87
    TRY_SMS_STAR_ROUNDED = 0x11F88
    TRY_SMS_STAR_SHARP = 0x11F89
    TSUNAMI = 0x11F8A
    TSUNAMI_OUTLINED = 0x11F8B
    TSUNAMI_ROUNDED = 0x11F8C
    TSUNAMI_SHARP = 0x11F8D
    TTY = 0x11F8E
    TTY_OUTLINED = 0x11F8F
    TTY_ROUNDED = 0x11F90
    TTY_SHARP = 0x11F91
    TUNE = 0x11F92
    TUNE_OUTLINED = 0x11F93
    TUNE_ROUNDED = 0x11F94
    TUNE_SHARP = 0x11F95
    TUNGSTEN = 0x11F96
    TUNGSTEN_OUTLINED = 0x11F97
    TUNGSTEN_ROUNDED = 0x11F98
    TUNGSTEN_SHARP = 0x11F99
    TURN_LEFT = 0x11F9A
    TURN_LEFT_OUTLINED = 0x11F9B
    TURN_LEFT_ROUNDED = 0x11F9C
    TURN_LEFT_SHARP = 0x11F9D
    TURN_RIGHT = 0x11F9E
    TURN_RIGHT_OUTLINED = 0x11F9F
    TURN_RIGHT_ROUNDED = 0x11FA0
    TURN_RIGHT_SHARP = 0x11FA1
    TURN_SHARP_LEFT = 0x11FA2
    TURN_SHARP_LEFT_OUTLINED = 0x11FA3
    TURN_SHARP_LEFT_ROUNDED = 0x11FA4
    TURN_SHARP_LEFT_SHARP = 0x11FA5
    TURN_SHARP_RIGHT = 0x11FA6
    TURN_SHARP_RIGHT_OUTLINED = 0x11FA7
    TURN_SHARP_RIGHT_ROUNDED = 0x11FA8
    TURN_SHARP_RIGHT_SHARP = 0x11FA9
    TURN_SLIGHT_LEFT = 0x11FAA
    TURN_SLIGHT_LEFT_OUTLINED = 0x11FAB
    TURN_SLIGHT_LEFT_ROUNDED = 0x11FAC
    TURN_SLIGHT_LEFT_SHARP = 0x11FAD
    TURN_SLIGHT_RIGHT = 0x11FAE
    TURN_SLIGHT_RIGHT_OUTLINED = 0x11FAF
    TURN_SLIGHT_RIGHT_ROUNDED = 0x11FB0
    TURN_SLIGHT_RIGHT_SHARP = 0x11FB1
    TURNED_IN = 0x11FB2
    TURNED_IN_NOT = 0x11FB3
    TURNED_IN_NOT_OUTLINED = 0x11FB4
    TURNED_IN_NOT_ROUNDED = 0x11FB5
    TURNED_IN_NOT_SHARP = 0x11FB6
    TURNED_IN_OUTLINED = 0x11FB7
    TURNED_IN_ROUNDED = 0x11FB8
    TURNED_IN_SHARP = 0x11FB9
    TV = 0x11FBA
    TV_OFF = 0x11FBB
    TV_OFF_OUTLINED = 0x11FBC
    TV_OFF_ROUNDED = 0x11FBD
    TV_OFF_SHARP = 0x11FBE
    TV_OUTLINED = 0x11FBF
    TV_ROUNDED = 0x11FC0
    TV_SHARP = 0x11FC1
    TWELVE_MP = 0x11FC2
    TWELVE_MP_OUTLINED = 0x11FC3
    TWELVE_MP_ROUNDED = 0x11FC4
    TWELVE_MP_SHARP = 0x11FC5
    TWENTY_FOUR_MP = 0x11FC6
    TWENTY_FOUR_MP_OUTLINED = 0x11FC7
    TWENTY_FOUR_MP_ROUNDED = 0x11FC8
    TWENTY_FOUR_MP_SHARP = 0x11FC9
    TWENTY_MP = 0x11FCA
    TWENTY_MP_OUTLINED = 0x11FCB
    TWENTY_MP_ROUNDED = 0x11FCC
    TWENTY_MP_SHARP = 0x11FCD
    TWENTY_ONE_MP = 0x11FCE
    TWENTY_ONE_MP_OUTLINED = 0x11FCF
    TWENTY_ONE_MP_ROUNDED = 0x11FD0
    TWENTY_ONE_MP_SHARP = 0x11FD1
    TWENTY_THREE_MP = 0x11FD2
    TWENTY_THREE_MP_OUTLINED = 0x11FD3
    TWENTY_THREE_MP_ROUNDED = 0x11FD4
    TWENTY_THREE_MP_SHARP = 0x11FD5
    TWENTY_TWO_MP = 0x11FD6
    TWENTY_TWO_MP_OUTLINED = 0x11FD7
    TWENTY_TWO_MP_ROUNDED = 0x11FD8
    TWENTY_TWO_MP_SHARP = 0x11FD9
    TWO_K = 0x11FDA
    TWO_K_OUTLINED = 0x11FDB
    TWO_K_PLUS = 0x11FDC
    TWO_K_PLUS_OUTLINED = 0x11FDD
    TWO_K_PLUS_ROUNDED = 0x11FDE
    TWO_K_PLUS_SHARP = 0x11FDF
    TWO_K_ROUNDED = 0x11FE0
    TWO_K_SHARP = 0x11FE1
    TWO_MP = 0x11FE2
    TWO_MP_OUTLINED = 0x11FE3
    TWO_MP_ROUNDED = 0x11FE4
    TWO_MP_SHARP = 0x11FE5
    TWO_WHEELER = 0x11FE6
    TWO_WHEELER_OUTLINED = 0x11FE7
    TWO_WHEELER_ROUNDED = 0x11FE8
    TWO_WHEELER_SHARP = 0x11FE9
    TYPE_SPECIMEN = 0x11FEA
    TYPE_SPECIMEN_OUTLINED = 0x11FEB
    TYPE_SPECIMEN_ROUNDED = 0x11FEC
    TYPE_SPECIMEN_SHARP = 0x11FED
    U_TURN_LEFT = 0x11FEE
    U_TURN_LEFT_OUTLINED = 0x11FEF
    U_TURN_LEFT_ROUNDED = 0x11FF0
    U_TURN_LEFT_SHARP = 0x11FF1
    U_TURN_RIGHT = 0x11FF2
    U_TURN_RIGHT_OUTLINED = 0x11FF3
    U_TURN_RIGHT_ROUNDED = 0x11FF4
    U_TURN_RIGHT_SHARP = 0x11FF5
    UMBRELLA = 0x11FF6
    UMBRELLA_OUTLINED = 0x11FF7
    UMBRELLA_ROUNDED = 0x11FF8
    UMBRELLA_SHARP = 0x11FF9
    UNARCHIVE = 0x11FFA
    UNARCHIVE_OUTLINED = 0x11FFB
    UNARCHIVE_ROUNDED = 0x11FFC
    UNARCHIVE_SHARP = 0x11FFD
    UNDO = 0x11FFE
    UNDO_OUTLINED = 0x11FFF
    UNDO_ROUNDED = 0x12000
    UNDO_SHARP = 0x12001
    UNFOLD_LESS = 0x12002
    UNFOLD_LESS_DOUBLE = 0x12003
    UNFOLD_LESS_DOUBLE_OUTLINED = 0x12004
    UNFOLD_LESS_DOUBLE_ROUNDED = 0x12005
    UNFOLD_LESS_DOUBLE_SHARP = 0x12006
    UNFOLD_LESS_OUTLINED = 0x12007
    UNFOLD_LESS_ROUNDED = 0x12008
    UNFOLD_LESS_SHARP = 0x12009
    UNFOLD_MORE = 0x1200A
    UNFOLD_MORE_DOUBLE = 0x1200B
    UNFOLD_MORE_DOUBLE_OUTLINED = 0x1200C
    UNFOLD_MORE_DOUBLE_ROUNDED = 0x1200D
    UNFOLD_MORE_DOUBLE_SHARP = 0x1200E
    UNFOLD_MORE_OUTLINED = 0x1200F
    UNFOLD_MORE_ROUNDED = 0x12010
    UNFOLD_MORE_SHARP = 0x12011
    UNPUBLISHED = 0x12012
    UNPUBLISHED_OUTLINED = 0x12013
    UNPUBLISHED_ROUNDED = 0x12014
    UNPUBLISHED_SHARP = 0x12015
    UNSUBSCRIBE = 0x12016
    UNSUBSCRIBE_OUTLINED = 0x12017
    UNSUBSCRIBE_ROUNDED = 0x12018
    UNSUBSCRIBE_SHARP = 0x12019
    UPCOMING = 0x1201A
    UPCOMING_OUTLINED = 0x1201B
    UPCOMING_ROUNDED = 0x1201C
    UPCOMING_SHARP = 0x1201D
    UPDATE = 0x1201E
    UPDATE_DISABLED = 0x1201F
    UPDATE_DISABLED_OUTLINED = 0x12020
    UPDATE_DISABLED_ROUNDED = 0x12021
    UPDATE_DISABLED_SHARP = 0x12022
    UPDATE_OUTLINED = 0x12023
    UPDATE_ROUNDED = 0x12024
    UPDATE_SHARP = 0x12025
    UPGRADE = 0x12026
    UPGRADE_OUTLINED = 0x12027
    UPGRADE_ROUNDED = 0x12028
    UPGRADE_SHARP = 0x12029
    UPLOAD = 0x1202A
    UPLOAD_FILE = 0x1202B
    UPLOAD_FILE_OUTLINED = 0x1202C
    UPLOAD_FILE_ROUNDED = 0x1202D
    UPLOAD_FILE_SHARP = 0x1202E
    UPLOAD_OUTLINED = 0x1202F
    UPLOAD_ROUNDED = 0x12030
    UPLOAD_SHARP = 0x12031
    USB = 0x12032
    USB_OFF = 0x12033
    USB_OFF_OUTLINED = 0x12034
    USB_OFF_ROUNDED = 0x12035
    USB_OFF_SHARP = 0x12036
    USB_OUTLINED = 0x12037
    USB_ROUNDED = 0x12038
    USB_SHARP = 0x12039
    VACCINES = 0x1203A
    VACCINES_OUTLINED = 0x1203B
    VACCINES_ROUNDED = 0x1203C
    VACCINES_SHARP = 0x1203D
    VAPE_FREE = 0x1203E
    VAPE_FREE_OUTLINED = 0x1203F
    VAPE_FREE_ROUNDED = 0x12040
    VAPE_FREE_SHARP = 0x12041
    VAPING_ROOMS = 0x12042
    VAPING_ROOMS_OUTLINED = 0x12043
    VAPING_ROOMS_ROUNDED = 0x12044
    VAPING_ROOMS_SHARP = 0x12045
    VERIFIED = 0x12046
    VERIFIED_OUTLINED = 0x12047
    VERIFIED_ROUNDED = 0x12048
    VERIFIED_SHARP = 0x12049
    VERIFIED_USER = 0x1204A
    VERIFIED_USER_OUTLINED = 0x1204B
    VERIFIED_USER_ROUNDED = 0x1204C
    VERIFIED_USER_SHARP = 0x1204D
    VERTICAL_ALIGN_BOTTOM = 0x1204E
    VERTICAL_ALIGN_BOTTOM_OUTLINED = 0x1204F
    VERTICAL_ALIGN_BOTTOM_ROUNDED = 0x12050
    VERTICAL_ALIGN_BOTTOM_SHARP = 0x12051
    VERTICAL_ALIGN_CENTER = 0x12052
    VERTICAL_ALIGN_CENTER_OUTLINED = 0x12053
    VERTICAL_ALIGN_CENTER_ROUNDED = 0x12054
    VERTICAL_ALIGN_CENTER_SHARP = 0x12055
    VERTICAL_ALIGN_TOP = 0x12056
    VERTICAL_ALIGN_TOP_OUTLINED = 0x12057
    VERTICAL_ALIGN_TOP_ROUNDED = 0x12058
    VERTICAL_ALIGN_TOP_SHARP = 0x12059
    VERTICAL_DISTRIBUTE = 0x1205A
    VERTICAL_DISTRIBUTE_OUTLINED = 0x1205B
    VERTICAL_DISTRIBUTE_ROUNDED = 0x1205C
    VERTICAL_DISTRIBUTE_SHARP = 0x1205D
    VERTICAL_SHADES = 0x1205E
    VERTICAL_SHADES_CLOSED = 0x1205F
    VERTICAL_SHADES_CLOSED_OUTLINED = 0x12060
    VERTICAL_SHADES_CLOSED_ROUNDED = 0x12061
    VERTICAL_SHADES_CLOSED_SHARP = 0x12062
    VERTICAL_SHADES_OUTLINED = 0x12063
    VERTICAL_SHADES_ROUNDED = 0x12064
    VERTICAL_SHADES_SHARP = 0x12065
    VERTICAL_SPLIT = 0x12066
    VERTICAL_SPLIT_OUTLINED = 0x12067
    VERTICAL_SPLIT_ROUNDED = 0x12068
    VERTICAL_SPLIT_SHARP = 0x12069
    VIBRATION = 0x1206A
    VIBRATION_OUTLINED = 0x1206B
    VIBRATION_ROUNDED = 0x1206C
    VIBRATION_SHARP = 0x1206D
    VIDEO_CALL = 0x1206E
    VIDEO_CALL_OUTLINED = 0x1206F
    VIDEO_CALL_ROUNDED = 0x12070
    VIDEO_CALL_SHARP = 0x12071
    VIDEO_CAMERA_BACK = 0x12072
    VIDEO_CAMERA_BACK_OUTLINED = 0x12073
    VIDEO_CAMERA_BACK_ROUNDED = 0x12074
    VIDEO_CAMERA_BACK_SHARP = 0x12075
    VIDEO_CAMERA_FRONT = 0x12076
    VIDEO_CAMERA_FRONT_OUTLINED = 0x12077
    VIDEO_CAMERA_FRONT_ROUNDED = 0x12078
    VIDEO_CAMERA_FRONT_SHARP = 0x12079
    VIDEO_CHAT = 0x1207A
    VIDEO_CHAT_OUTLINED = 0x1207B
    VIDEO_CHAT_ROUNDED = 0x1207C
    VIDEO_CHAT_SHARP = 0x1207D
    VIDEO_COLLECTION = 0x1207E
    VIDEO_COLLECTION_OUTLINED = 0x1207F
    VIDEO_COLLECTION_ROUNDED = 0x12080
    VIDEO_COLLECTION_SHARP = 0x12081
    VIDEO_FILE = 0x12082
    VIDEO_FILE_OUTLINED = 0x12083
    VIDEO_FILE_ROUNDED = 0x12084
    VIDEO_FILE_SHARP = 0x12085
    VIDEO_LABEL = 0x12086
    VIDEO_LABEL_OUTLINED = 0x12087
    VIDEO_LABEL_ROUNDED = 0x12088
    VIDEO_LABEL_SHARP = 0x12089
    VIDEO_LIBRARY = 0x1208A
    VIDEO_LIBRARY_OUTLINED = 0x1208B
    VIDEO_LIBRARY_ROUNDED = 0x1208C
    VIDEO_LIBRARY_SHARP = 0x1208D
    VIDEO_SETTINGS = 0x1208E
    VIDEO_SETTINGS_OUTLINED = 0x1208F
    VIDEO_SETTINGS_ROUNDED = 0x12090
    VIDEO_SETTINGS_SHARP = 0x12091
    VIDEO_STABLE = 0x12092
    VIDEO_STABLE_OUTLINED = 0x12093
    VIDEO_STABLE_ROUNDED = 0x12094
    VIDEO_STABLE_SHARP = 0x12095
    VIDEOCAM = 0x12096
    VIDEOCAM_OFF = 0x12097
    VIDEOCAM_OFF_OUTLINED = 0x12098
    VIDEOCAM_OFF_ROUNDED = 0x12099
    VIDEOCAM_OFF_SHARP = 0x1209A
    VIDEOCAM_OUTLINED = 0x1209B
    VIDEOCAM_ROUNDED = 0x1209C
    VIDEOCAM_SHARP = 0x1209D
    VIDEOGAME_ASSET = 0x1209E
    VIDEOGAME_ASSET_OFF = 0x1209F
    VIDEOGAME_ASSET_OFF_OUTLINED = 0x120A0
    VIDEOGAME_ASSET_OFF_ROUNDED = 0x120A1
    VIDEOGAME_ASSET_OFF_SHARP = 0x120A2
    VIDEOGAME_ASSET_OUTLINED = 0x120A3
    VIDEOGAME_ASSET_ROUNDED = 0x120A4
    VIDEOGAME_ASSET_SHARP = 0x120A5
    VIEW_AGENDA = 0x120A6
    VIEW_AGENDA_OUTLINED = 0x120A7
    VIEW_AGENDA_ROUNDED = 0x120A8
    VIEW_AGENDA_SHARP = 0x120A9
    VIEW_ARRAY = 0x120AA
    VIEW_ARRAY_OUTLINED = 0x120AB
    VIEW_ARRAY_ROUNDED = 0x120AC
    VIEW_ARRAY_SHARP = 0x120AD
    VIEW_CAROUSEL = 0x120AE
    VIEW_CAROUSEL_OUTLINED = 0x120AF
    VIEW_CAROUSEL_ROUNDED = 0x120B0
    VIEW_CAROUSEL_SHARP = 0x120B1
    VIEW_COLUMN = 0x120B2
    VIEW_COLUMN_OUTLINED = 0x120B3
    VIEW_COLUMN_ROUNDED = 0x120B4
    VIEW_COLUMN_SHARP = 0x120B5
    VIEW_COMFORTABLE = 0x120B6
    VIEW_COMFORTABLE_OUTLINED = 0x120B7
    VIEW_COMFORTABLE_ROUNDED = 0x120B8
    VIEW_COMFORTABLE_SHARP = 0x120B9
    VIEW_COMFY = 0x120BA
    VIEW_COMFY_ALT = 0x120BB
    VIEW_COMFY_ALT_OUTLINED = 0x120BC
    VIEW_COMFY_ALT_ROUNDED = 0x120BD
    VIEW_COMFY_ALT_SHARP = 0x120BE
    VIEW_COMFY_OUTLINED = 0x120BF
    VIEW_COMFY_ROUNDED = 0x120C0
    VIEW_COMFY_SHARP = 0x120C1
    VIEW_COMPACT = 0x120C2
    VIEW_COMPACT_ALT = 0x120C3
    VIEW_COMPACT_ALT_OUTLINED = 0x120C4
    VIEW_COMPACT_ALT_ROUNDED = 0x120C5
    VIEW_COMPACT_ALT_SHARP = 0x120C6
    VIEW_COMPACT_OUTLINED = 0x120C7
    VIEW_COMPACT_ROUNDED = 0x120C8
    VIEW_COMPACT_SHARP = 0x120C9
    VIEW_COZY = 0x120CA
    VIEW_COZY_OUTLINED = 0x120CB
    VIEW_COZY_ROUNDED = 0x120CC
    VIEW_COZY_SHARP = 0x120CD
    VIEW_DAY = 0x120CE
    VIEW_DAY_OUTLINED = 0x120CF
    VIEW_DAY_ROUNDED = 0x120D0
    VIEW_DAY_SHARP = 0x120D1
    VIEW_HEADLINE = 0x120D2
    VIEW_HEADLINE_OUTLINED = 0x120D3
    VIEW_HEADLINE_ROUNDED = 0x120D4
    VIEW_HEADLINE_SHARP = 0x120D5
    VIEW_IN_AR = 0x120D6
    VIEW_IN_AR_OUTLINED = 0x120D7
    VIEW_IN_AR_ROUNDED = 0x120D8
    VIEW_IN_AR_SHARP = 0x120D9
    VIEW_KANBAN = 0x120DA
    VIEW_KANBAN_OUTLINED = 0x120DB
    VIEW_KANBAN_ROUNDED = 0x120DC
    VIEW_KANBAN_SHARP = 0x120DD
    VIEW_LIST = 0x120DE
    VIEW_LIST_OUTLINED = 0x120DF
    VIEW_LIST_ROUNDED = 0x120E0
    VIEW_LIST_SHARP = 0x120E1
    VIEW_MODULE = 0x120E2
    VIEW_MODULE_OUTLINED = 0x120E3
    VIEW_MODULE_ROUNDED = 0x120E4
    VIEW_MODULE_SHARP = 0x120E5
    VIEW_QUILT = 0x120E6
    VIEW_QUILT_OUTLINED = 0x120E7
    VIEW_QUILT_ROUNDED = 0x120E8
    VIEW_QUILT_SHARP = 0x120E9
    VIEW_SIDEBAR = 0x120EA
    VIEW_SIDEBAR_OUTLINED = 0x120EB
    VIEW_SIDEBAR_ROUNDED = 0x120EC
    VIEW_SIDEBAR_SHARP = 0x120ED
    VIEW_STREAM = 0x120EE
    VIEW_STREAM_OUTLINED = 0x120EF
    VIEW_STREAM_ROUNDED = 0x120F0
    VIEW_STREAM_SHARP = 0x120F1
    VIEW_TIMELINE = 0x120F2
    VIEW_TIMELINE_OUTLINED = 0x120F3
    VIEW_TIMELINE_ROUNDED = 0x120F4
    VIEW_TIMELINE_SHARP = 0x120F5
    VIEW_WEEK = 0x120F6
    VIEW_WEEK_OUTLINED = 0x120F7
    VIEW_WEEK_ROUNDED = 0x120F8
    VIEW_WEEK_SHARP = 0x120F9
    VIGNETTE = 0x120FA
    VIGNETTE_OUTLINED = 0x120FB
    VIGNETTE_ROUNDED = 0x120FC
    VIGNETTE_SHARP = 0x120FD
    VILLA = 0x120FE
    VILLA_OUTLINED = 0x120FF
    VILLA_ROUNDED = 0x12100
    VILLA_SHARP = 0x12101
    VISIBILITY = 0x12102
    VISIBILITY_OFF = 0x12103
    VISIBILITY_OFF_OUTLINED = 0x12104
    VISIBILITY_OFF_ROUNDED = 0x12105
    VISIBILITY_OFF_SHARP = 0x12106
    VISIBILITY_OUTLINED = 0x12107
    VISIBILITY_ROUNDED = 0x12108
    VISIBILITY_SHARP = 0x12109
    VOICE_CHAT = 0x1210A
    VOICE_CHAT_OUTLINED = 0x1210B
    VOICE_CHAT_ROUNDED = 0x1210C
    VOICE_CHAT_SHARP = 0x1210D
    VOICE_OVER_OFF = 0x1210E
    VOICE_OVER_OFF_OUTLINED = 0x1210F
    VOICE_OVER_OFF_ROUNDED = 0x12110
    VOICE_OVER_OFF_SHARP = 0x12111
    VOICEMAIL = 0x12112
    VOICEMAIL_OUTLINED = 0x12113
    VOICEMAIL_ROUNDED = 0x12114
    VOICEMAIL_SHARP = 0x12115
    VOLCANO = 0x12116
    VOLCANO_OUTLINED = 0x12117
    VOLCANO_ROUNDED = 0x12118
    VOLCANO_SHARP = 0x12119
    VOLUME_DOWN = 0x1211A
    VOLUME_DOWN_ALT = 0x1211B
    VOLUME_DOWN_OUTLINED = 0x1211C
    VOLUME_DOWN_ROUNDED = 0x1211D
    VOLUME_DOWN_SHARP = 0x1211E
    VOLUME_MUTE = 0x1211F
    VOLUME_MUTE_OUTLINED = 0x12120
    VOLUME_MUTE_ROUNDED = 0x12121
    VOLUME_MUTE_SHARP = 0x12122
    VOLUME_OFF = 0x12123
    VOLUME_OFF_OUTLINED = 0x12124
    VOLUME_OFF_ROUNDED = 0x12125
    VOLUME_OFF_SHARP = 0x12126
    VOLUME_UP = 0x12127
    VOLUME_UP_OUTLINED = 0x12128
    VOLUME_UP_ROUNDED = 0x12129
    VOLUME_UP_SHARP = 0x1212A
    VOLUNTEER_ACTIVISM = 0x1212B
    VOLUNTEER_ACTIVISM_OUTLINED = 0x1212C
    VOLUNTEER_ACTIVISM_ROUNDED = 0x1212D
    VOLUNTEER_ACTIVISM_SHARP = 0x1212E
    VPN_KEY = 0x1212F
    VPN_KEY_OFF = 0x12130
    VPN_KEY_OFF_OUTLINED = 0x12131
    VPN_KEY_OFF_ROUNDED = 0x12132
    VPN_KEY_OFF_SHARP = 0x12133
    VPN_KEY_OUTLINED = 0x12134
    VPN_KEY_ROUNDED = 0x12135
    VPN_KEY_SHARP = 0x12136
    VPN_LOCK = 0x12137
    VPN_LOCK_OUTLINED = 0x12138
    VPN_LOCK_ROUNDED = 0x12139
    VPN_LOCK_SHARP = 0x1213A
    VRPANO = 0x1213B
    VRPANO_OUTLINED = 0x1213C
    VRPANO_ROUNDED = 0x1213D
    VRPANO_SHARP = 0x1213E
    WALLET = 0x1213F
    WALLET_GIFTCARD = 0x12140
    WALLET_GIFTCARD_OUTLINED = 0x12141
    WALLET_GIFTCARD_ROUNDED = 0x12142
    WALLET_GIFTCARD_SHARP = 0x12143
    WALLET_MEMBERSHIP = 0x12144
    WALLET_MEMBERSHIP_OUTLINED = 0x12145
    WALLET_MEMBERSHIP_ROUNDED = 0x12146
    WALLET_MEMBERSHIP_SHARP = 0x12147
    WALLET_OUTLINED = 0x12148
    WALLET_ROUNDED = 0x12149
    WALLET_SHARP = 0x1214A
    WALLET_TRAVEL = 0x1214B
    WALLET_TRAVEL_OUTLINED = 0x1214C
    WALLET_TRAVEL_ROUNDED = 0x1214D
    WALLET_TRAVEL_SHARP = 0x1214E
    WALLPAPER = 0x1214F
    WALLPAPER_OUTLINED = 0x12150
    WALLPAPER_ROUNDED = 0x12151
    WALLPAPER_SHARP = 0x12152
    WAREHOUSE = 0x12153
    WAREHOUSE_OUTLINED = 0x12154
    WAREHOUSE_ROUNDED = 0x12155
    WAREHOUSE_SHARP = 0x12156
    WARNING = 0x12157
    WARNING_AMBER = 0x12158
    WARNING_AMBER_OUTLINED = 0x12159
    WARNING_AMBER_ROUNDED = 0x1215A
    WARNING_AMBER_SHARP = 0x1215B
    WARNING_OUTLINED = 0x1215C
    WARNING_ROUNDED = 0x1215D
    WARNING_SHARP = 0x1215E
    WASH = 0x1215F
    WASH_OUTLINED = 0x12160
    WASH_ROUNDED = 0x12161
    WASH_SHARP = 0x12162
    WATCH = 0x12163
    WATCH_LATER = 0x12164
    WATCH_LATER_OUTLINED = 0x12165
    WATCH_LATER_ROUNDED = 0x12166
    WATCH_LATER_SHARP = 0x12167
    WATCH_OFF = 0x12168
    WATCH_OFF_OUTLINED = 0x12169
    WATCH_OFF_ROUNDED = 0x1216A
    WATCH_OFF_SHARP = 0x1216B
    WATCH_OUTLINED = 0x1216C
    WATCH_ROUNDED = 0x1216D
    WATCH_SHARP = 0x1216E
    WATER = 0x1216F
    WATER_DAMAGE = 0x12170
    WATER_DAMAGE_OUTLINED = 0x12171
    WATER_DAMAGE_ROUNDED = 0x12172
    WATER_DAMAGE_SHARP = 0x12173
    WATER_DROP = 0x12174
    WATER_DROP_OUTLINED = 0x12175
    WATER_DROP_ROUNDED = 0x12176
    WATER_DROP_SHARP = 0x12177
    WATER_OUTLINED = 0x12178
    WATER_ROUNDED = 0x12179
    WATER_SHARP = 0x1217A
    WATERFALL_CHART = 0x1217B
    WATERFALL_CHART_OUTLINED = 0x1217C
    WATERFALL_CHART_ROUNDED = 0x1217D
    WATERFALL_CHART_SHARP = 0x1217E
    WAVES = 0x1217F
    WAVES_OUTLINED = 0x12180
    WAVES_ROUNDED = 0x12181
    WAVES_SHARP = 0x12182
    WAVING_HAND = 0x12183
    WAVING_HAND_OUTLINED = 0x12184
    WAVING_HAND_ROUNDED = 0x12185
    WAVING_HAND_SHARP = 0x12186
    WB_AUTO = 0x12187
    WB_AUTO_OUTLINED = 0x12188
    WB_AUTO_ROUNDED = 0x12189
    WB_AUTO_SHARP = 0x1218A
    WB_CLOUDY = 0x1218B
    WB_CLOUDY_OUTLINED = 0x1218C
    WB_CLOUDY_ROUNDED = 0x1218D
    WB_CLOUDY_SHARP = 0x1218E
    WB_INCANDESCENT = 0x1218F
    WB_INCANDESCENT_OUTLINED = 0x12190
    WB_INCANDESCENT_ROUNDED = 0x12191
    WB_INCANDESCENT_SHARP = 0x12192
    WB_IRIDESCENT = 0x12193
    WB_IRIDESCENT_OUTLINED = 0x12194
    WB_IRIDESCENT_ROUNDED = 0x12195
    WB_IRIDESCENT_SHARP = 0x12196
    WB_SHADE = 0x12197
    WB_SHADE_OUTLINED = 0x12198
    WB_SHADE_ROUNDED = 0x12199
    WB_SHADE_SHARP = 0x1219A
    WB_SUNNY = 0x1219B
    WB_SUNNY_OUTLINED = 0x1219C
    WB_SUNNY_ROUNDED = 0x1219D
    WB_SUNNY_SHARP = 0x1219E
    WB_TWIGHLIGHT = 0x1219F
    WB_TWILIGHT = 0x121A0
    WB_TWILIGHT_OUTLINED = 0x121A1
    WB_TWILIGHT_ROUNDED = 0x121A2
    WB_TWILIGHT_SHARP = 0x121A3
    WC = 0x121A4
    WC_OUTLINED = 0x121A5
    WC_ROUNDED = 0x121A6
    WC_SHARP = 0x121A7
    WEB = 0x121A8
    WEB_ASSET = 0x121A9
    WEB_ASSET_OFF = 0x121AA
    WEB_ASSET_OFF_OUTLINED = 0x121AB
    WEB_ASSET_OFF_ROUNDED = 0x121AC
    WEB_ASSET_OFF_SHARP = 0x121AD
    WEB_ASSET_OUTLINED = 0x121AE
    WEB_ASSET_ROUNDED = 0x121AF
    WEB_ASSET_SHARP = 0x121B0
    WEB_OUTLINED = 0x121B1
    WEB_ROUNDED = 0x121B2
    WEB_SHARP = 0x121B3
    WEB_STORIES = 0x121B4
    WEB_STORIES_OUTLINED = 0x121B5
    WEB_STORIES_ROUNDED = 0x121B6
    WEB_STORIES_SHARP = 0x121B7
    WEBHOOK = 0x121B8
    WEBHOOK_OUTLINED = 0x121B9
    WEBHOOK_ROUNDED = 0x121BA
    WEBHOOK_SHARP = 0x121BB
    WECHAT = 0x121BC
    WECHAT_OUTLINED = 0x121BD
    WECHAT_ROUNDED = 0x121BE
    WECHAT_SHARP = 0x121BF
    WEEKEND = 0x121C0
    WEEKEND_OUTLINED = 0x121C1
    WEEKEND_ROUNDED = 0x121C2
    WEEKEND_SHARP = 0x121C3
    WEST = 0x121C4
    WEST_OUTLINED = 0x121C5
    WEST_ROUNDED = 0x121C6
    WEST_SHARP = 0x121C7
    WHATSHOT = 0x121C8
    WHATSHOT_OUTLINED = 0x121C9
    WHATSHOT_ROUNDED = 0x121CA
    WHATSHOT_SHARP = 0x121CB
    WHEELCHAIR_PICKUP = 0x121CC
    WHEELCHAIR_PICKUP_OUTLINED = 0x121CD
    WHEELCHAIR_PICKUP_ROUNDED = 0x121CE
    WHEELCHAIR_PICKUP_SHARP = 0x121CF
    WHERE_TO_VOTE = 0x121D0
    WHERE_TO_VOTE_OUTLINED = 0x121D1
    WHERE_TO_VOTE_ROUNDED = 0x121D2
    WHERE_TO_VOTE_SHARP = 0x121D3
    WIDGETS = 0x121D4
    WIDGETS_OUTLINED = 0x121D5
    WIDGETS_ROUNDED = 0x121D6
    WIDGETS_SHARP = 0x121D7
    WIDTH_FULL = 0x121D8
    WIDTH_FULL_OUTLINED = 0x121D9
    WIDTH_FULL_ROUNDED = 0x121DA
    WIDTH_FULL_SHARP = 0x121DB
    WIDTH_NORMAL = 0x121DC
    WIDTH_NORMAL_OUTLINED = 0x121DD
    WIDTH_NORMAL_ROUNDED = 0x121DE
    WIDTH_NORMAL_SHARP = 0x121DF
    WIDTH_WIDE = 0x121E0
    WIDTH_WIDE_OUTLINED = 0x121E1
    WIDTH_WIDE_ROUNDED = 0x121E2
    WIDTH_WIDE_SHARP = 0x121E3
    WIFI = 0x121E4
    WIFI_1_BAR = 0x121E5
    WIFI_1_BAR_OUTLINED = 0x121E6
    WIFI_1_BAR_ROUNDED = 0x121E7
    WIFI_1_BAR_SHARP = 0x121E8
    WIFI_2_BAR = 0x121E9
    WIFI_2_BAR_OUTLINED = 0x121EA
    WIFI_2_BAR_ROUNDED = 0x121EB
    WIFI_2_BAR_SHARP = 0x121EC
    WIFI_CALLING = 0x121ED
    WIFI_CALLING_3 = 0x121EE
    WIFI_CALLING_3_OUTLINED = 0x121EF
    WIFI_CALLING_3_ROUNDED = 0x121F0
    WIFI_CALLING_3_SHARP = 0x121F1
    WIFI_CALLING_OUTLINED = 0x121F2
    WIFI_CALLING_ROUNDED = 0x121F3
    WIFI_CALLING_SHARP = 0x121F4
    WIFI_CHANNEL = 0x121F5
    WIFI_CHANNEL_OUTLINED = 0x121F6
    WIFI_CHANNEL_ROUNDED = 0x121F7
    WIFI_CHANNEL_SHARP = 0x121F8
    WIFI_FIND = 0x121F9
    WIFI_FIND_OUTLINED = 0x121FA
    WIFI_FIND_ROUNDED = 0x121FB
    WIFI_FIND_SHARP = 0x121FC
    WIFI_LOCK = 0x121FD
    WIFI_LOCK_OUTLINED = 0x121FE
    WIFI_LOCK_ROUNDED = 0x121FF
    WIFI_LOCK_SHARP = 0x12200
    WIFI_OFF = 0x12201
    WIFI_OFF_OUTLINED = 0x12202
    WIFI_OFF_ROUNDED = 0x12203
    WIFI_OFF_SHARP = 0x12204
    WIFI_OUTLINED = 0x12205
    WIFI_PASSWORD = 0x12206
    WIFI_PASSWORD_OUTLINED = 0x12207
    WIFI_PASSWORD_ROUNDED = 0x12208
    WIFI_PASSWORD_SHARP = 0x12209
    WIFI_PROTECTED_SETUP = 0x1220A
    WIFI_PROTECTED_SETUP_OUTLINED = 0x1220B
    WIFI_PROTECTED_SETUP_ROUNDED = 0x1220C
    WIFI_PROTECTED_SETUP_SHARP = 0x1220D
    WIFI_ROUNDED = 0x1220E
    WIFI_SHARP = 0x1220F
    WIFI_TETHERING = 0x12210
    WIFI_TETHERING_ERROR = 0x12211
    WIFI_TETHERING_ERROR_OUTLINED = 0x12212
    WIFI_TETHERING_ERROR_ROUNDED = 0x12213
    WIFI_TETHERING_ERROR_ROUNDED_OUTLINED = 0x12214
    WIFI_TETHERING_ERROR_ROUNDED_ROUNDED = 0x12215
    WIFI_TETHERING_ERROR_ROUNDED_SHARP = 0x12216
    WIFI_TETHERING_ERROR_SHARP = 0x12217
    WIFI_TETHERING_OFF = 0x12218
    WIFI_TETHERING_OFF_OUTLINED = 0x12219
    WIFI_TETHERING_OFF_ROUNDED = 0x1221A
    WIFI_TETHERING_OFF_SHARP = 0x1221B
    WIFI_TETHERING_OUTLINED = 0x1221C
    WIFI_TETHERING_ROUNDED = 0x1221D
    WIFI_TETHERING_SHARP = 0x1221E
    WIND_POWER = 0x1221F
    WIND_POWER_OUTLINED = 0x12220
    WIND_POWER_ROUNDED = 0x12221
    WIND_POWER_SHARP = 0x12222
    WINDOW = 0x12223
    WINDOW_OUTLINED = 0x12224
    WINDOW_ROUNDED = 0x12225
    WINDOW_SHARP = 0x12226
    WINE_BAR = 0x12227
    WINE_BAR_OUTLINED = 0x12228
    WINE_BAR_ROUNDED = 0x12229
    WINE_BAR_SHARP = 0x1222A
    WOMAN = 0x1222B
    WOMAN_2 = 0x1222C
    WOMAN_2_OUTLINED = 0x1222D
    WOMAN_2_ROUNDED = 0x1222E
    WOMAN_2_SHARP = 0x1222F
    WOMAN_OUTLINED = 0x12230
    WOMAN_ROUNDED = 0x12231
    WOMAN_SHARP = 0x12232
    WOO_COMMERCE = 0x12233
    WOO_COMMERCE_OUTLINED = 0x12234
    WOO_COMMERCE_ROUNDED = 0x12235
    WOO_COMMERCE_SHARP = 0x12236
    WORDPRESS = 0x12237
    WORDPRESS_OUTLINED = 0x12238
    WORDPRESS_ROUNDED = 0x12239
    WORDPRESS_SHARP = 0x1223A
    WORK = 0x1223B
    WORK_HISTORY = 0x1223C
    WORK_HISTORY_OUTLINED = 0x1223D
    WORK_HISTORY_ROUNDED = 0x1223E
    WORK_HISTORY_SHARP = 0x1223F
    WORK_OFF = 0x12240
    WORK_OFF_OUTLINED = 0x12241
    WORK_OFF_ROUNDED = 0x12242
    WORK_OFF_SHARP = 0x12243
    WORK_OUTLINE = 0x12244
    WORK_OUTLINE_OUTLINED = 0x12245
    WORK_OUTLINE_ROUNDED = 0x12246
    WORK_OUTLINE_SHARP = 0x12247
    WORK_OUTLINED = 0x12248
    WORK_ROUNDED = 0x12249
    WORK_SHARP = 0x1224A
    WORKSPACE_PREMIUM = 0x1224B
    WORKSPACE_PREMIUM_OUTLINED = 0x1224C
    WORKSPACE_PREMIUM_ROUNDED = 0x1224D
    WORKSPACE_PREMIUM_SHARP = 0x1224E
    WORKSPACES = 0x1224F
    WORKSPACES_FILLED = 0x12250
    WORKSPACES_OUTLINE = 0x12251
    WORKSPACES_OUTLINED = 0x12252
    WORKSPACES_ROUNDED = 0x12253
    WORKSPACES_SHARP = 0x12254
    WRAP_TEXT = 0x12255
    WRAP_TEXT_OUTLINED = 0x12256
    WRAP_TEXT_ROUNDED = 0x12257
    WRAP_TEXT_SHARP = 0x12258
    WRONG_LOCATION = 0x12259
    WRONG_LOCATION_OUTLINED = 0x1225A
    WRONG_LOCATION_ROUNDED = 0x1225B
    WRONG_LOCATION_SHARP = 0x1225C
    WYSIWYG = 0x1225D
    WYSIWYG_OUTLINED = 0x1225E
    WYSIWYG_ROUNDED = 0x1225F
    WYSIWYG_SHARP = 0x12260
    YARD = 0x12261
    YARD_OUTLINED = 0x12262
    YARD_ROUNDED = 0x12263
    YARD_SHARP = 0x12264
    YOUTUBE_SEARCHED_FOR = 0x12265
    YOUTUBE_SEARCHED_FOR_OUTLINED = 0x12266
    YOUTUBE_SEARCHED_FOR_ROUNDED = 0x12267
    YOUTUBE_SEARCHED_FOR_SHARP = 0x12268
    ZOOM_IN = 0x12269
    ZOOM_IN_MAP = 0x1226A
    ZOOM_IN_MAP_OUTLINED = 0x1226B
    ZOOM_IN_MAP_ROUNDED = 0x1226C
    ZOOM_IN_MAP_SHARP = 0x1226D
    ZOOM_IN_OUTLINED = 0x1226E
    ZOOM_IN_ROUNDED = 0x1226F
    ZOOM_IN_SHARP = 0x12270
    ZOOM_OUT = 0x12271
    ZOOM_OUT_MAP = 0x12272
    ZOOM_OUT_MAP_OUTLINED = 0x12273
    ZOOM_OUT_MAP_ROUNDED = 0x12274
    ZOOM_OUT_MAP_SHARP = 0x12275
    ZOOM_OUT_OUTLINED = 0x12276
    ZOOM_OUT_ROUNDED = 0x12277
    ZOOM_OUT_SHARP = 0x12278
