# coding: utf-8

"""
AskUI Workspaces API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The version of the OpenAPI document: 0.1.30
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictBool,
    StrictStr,
    field_validator,
)
from typing_extensions import Annotated, Self

from askui.tools.askui.askui_workspaces.models.email_agent_trigger_update import (
    EmailAgentTriggerUpdate,
)


class AgentUpdateCommand(BaseModel):
    """
    AgentUpdateCommand
    """  # noqa: E501

    name: Optional[Annotated[str, Field(strict=True)]] = Field(
        default=None,
        description="The name of the agent. The name must only contain the following characters: a-z, A-Z, 0-9, -, _, and space. The name must not be empty. The name must start and end with a letter or a number. The name must not be longer than 64 characters.",
    )
    description: Optional[Annotated[str, Field(strict=True, max_length=1024)]] = ""
    status: Optional[StrictStr] = None
    email_trigger: Optional[EmailAgentTriggerUpdate] = Field(
        default=None, alias="emailTrigger"
    )
    auto_confirm: Optional[StrictBool] = Field(default=None, alias="autoConfirm")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "name",
        "description",
        "status",
        "emailTrigger",
        "autoConfirm",
    ]

    @field_validator("name")
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^[a-zA-Z0-9]([a-zA-Z0-9-_.+ ]{0,62}[a-zA-Z0-9])?$", value):
            raise ValueError(
                r"must validate the regular expression /^[a-zA-Z0-9]([a-zA-Z0-9-_.+ ]{0,62}[a-zA-Z0-9])?$/"
            )
        return value

    @field_validator("status")
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(["ACTIVE", "ARCHIVED"]):
            raise ValueError("must be one of enum values ('ACTIVE', 'ARCHIVED')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of AgentUpdateCommand from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of email_trigger
        if self.email_trigger:
            _dict["emailTrigger"] = self.email_trigger.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if name (nullable) is None
        # and model_fields_set contains the field
        if self.name is None and "name" in self.model_fields_set:
            _dict["name"] = None

        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict["description"] = None

        # set to None if status (nullable) is None
        # and model_fields_set contains the field
        if self.status is None and "status" in self.model_fields_set:
            _dict["status"] = None

        # set to None if email_trigger (nullable) is None
        # and model_fields_set contains the field
        if self.email_trigger is None and "email_trigger" in self.model_fields_set:
            _dict["emailTrigger"] = None

        # set to None if auto_confirm (nullable) is None
        # and model_fields_set contains the field
        if self.auto_confirm is None and "auto_confirm" in self.model_fields_set:
            _dict["autoConfirm"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of AgentUpdateCommand from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "name": obj.get("name"),
                "description": obj.get("description")
                if obj.get("description") is not None
                else "",
                "status": obj.get("status"),
                "emailTrigger": EmailAgentTriggerUpdate.from_dict(obj["emailTrigger"])
                if obj.get("emailTrigger") is not None
                else None,
                "autoConfirm": obj.get("autoConfirm"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
