# Granttpy

## When you want to make a Gantt chart look nice for a grant or whatever

![Example Gantt chart](https://raw.githubusercontent.com/dannys4/granttpy/main/examples/example.png)

## Installation

You can install directly from this repository via

```bash
pip install grantt
```

As a side-note, we recommend installing with [`uv`](https://docs.astral.sh/uv/) using

```bash
uv pip install grantt
```

## Example

After `grantt` is installed, copy the script from [here](https://github.com/dannys4/granttpy/blob/main/examples/ex.py) into `ex.py` and run `python ex.py` (or `python3` depending on your installation).

## Basic instructions

Making a Gantt chart is as easy as making different `grantt.Element`s, the parent class for all the different things on the chart. Type `help(grantt.Element)` to see the fields for the constructor: most of them should be self-explanatory, but here are a few notes on the more cryptic fields.

- `zorder_delta`: how much precedent the element should have when displaying on top of (or behind) other objects
- `level_increment`: The chart is generated by starting from the top and moving down. Every time that an element with a nonzero increment is added, the following elements are below it vertically. If you have two elements overlapping vertically, try increasing the `level_increment` of one.
- `textalignment`: takes `left`, `right`, or `center`.
- Any `color`s (i.e., `color` or `textcolor`) take in any argument that MPL would (e.g., `k` for black or `#FF0000` for red, etc).

### `grantt.Span`

A `grantt.Span` just spans an amount of time, generally acting as a divider between two vertically adjacent sections. It has a start and end date as well as an adjustable edge height for the prongs on the sides.

### `grantt.Period`

A `grantt.Period` also spans an amount of time, but acts more as a time period that one might work on a task. These are represented by thicker lines; therefore, you may be interested in changing `lw`, the linewidth of the element.

### `grantt.Event`

A `grantt.Event` is a point in time that something happens with no duration---think milestone or deadline. Along with choosing the `date` of the deadline, you can customize the `marker` and its `markersize` (which will need to be done based on the aspect ratio and scaling of the figure).

## Defaults

There are several defaults that you can customize using `Gantt.set_X`, where `X` is the option.

- `marker`: default marker for `grantt.Event` elements
- `markersize`: default markersize for `grantt.Event` elements
- `linewidth`: default linewidth for `grantt.Period` elements
- `textcolor`: default textcolor for all elements
- `span_edge_height`: default height of the edge brackets for `grantt.Span` elements
- `luminance_threshold`: the threshold for automatically switching between white and black text in `grantt.Period` elements based on their color.
