"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmCircleCi = void 0;
const projen_1 = require("projen");
class NpmCircleCi extends projen_1.circleci.Circleci {
    constructor(project) {
        super(project, {
            jobs: [
                {
                    identifier: 'build',
                    resourceClass: projen_1.circleci.ResourceClass.SMALL,
                    docker: [
                        {
                            image: 'cimg/node:lts',
                        },
                    ],
                    steps: [
                        'checkout',
                        {
                            run: {
                                name: 'Install dependencies',
                                command: 'yarn install --check-files',
                            },
                        },
                        {
                            run: { name: 'build', command: 'npx projen build' },
                        },
                        {
                            run: {
                                name: 'Find mutations',
                                command: `git add .
git diff --staged --patch --exit-code > .repo.patch || echo "export SELF_MUTATION_HAPPENED=true" >> $BASH_ENV`,
                            },
                        },
                    ],
                },
            ],
            workflows: [
                {
                    identifier: 'build',
                    jobs: [
                        {
                            identifier: 'build',
                        },
                    ],
                },
            ],
        });
    }
}
exports.NpmCircleCi = NpmCircleCi;
//# sourceMappingURL=data:application/json;base64,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