"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Readme = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
const section_1 = require("./elements/section");
class Readme extends projen_1.FileBase {
    constructor(project, options = {}) {
        super(project, 'README.md', {});
        this.sections = [];
        this.description = options.description;
    }
    addSection(title, body) {
        this.sections.push(new section_1.Section({ title, body }));
    }
    synthesizeContent(_) {
        let content = `# ${this.project.name}\n\n`;
        content = content.concat(this.description ? `${this.description}\n\n` : '');
        return content.concat(this.sections.map((s) => s.synth()).join('\n\n'));
    }
}
exports.Readme = Readme;
_a = JSII_RTTI_SYMBOL_1;
Readme[_a] = { fqn: "projen-modules.Readme", version: "1.0.162" };
//# sourceMappingURL=data:application/json;base64,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