"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NpmPackage = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const projen_1 = require("projen");
const circleci_1 = require("../../circleci");
const codeowners_1 = require("../../components/github/codeowners");
const pull_request_template_1 = require("../../components/github/pull-request-template");
const readme_1 = require("../../components/readme");
const merge_options_1 = require("../../utils/merge-options");
function getOptions(options) {
    const { name } = options;
    const defaults = {
        name,
        defaultReleaseBranch: 'main',
        githubOptions: {
            workflows: false,
        },
        gitignore: ['.npmrc', '.vscode'],
        pullRequestTemplateContents: pull_request_template_1.DEFAULT_PULL_REQUEST_TEMPLATE,
        projenrcTs: true,
    };
    return (0, merge_options_1.mergeOptions)(defaults, options);
}
/**
 * A NPM/node package in TypeScript
 *
 *
 * @pjid npm-package
 */
class NpmPackage extends projen_1.typescript.TypeScriptProject {
    constructor(options) {
        const mergedOptions = getOptions(options);
        super({
            ...mergedOptions,
        });
        new codeowners_1.CodeOwners(this, mergedOptions.codeOwners);
        new circleci_1.NpmCircleCi(this);
        this.readme = new readme_1.Readme(this, {
            description: mergedOptions.readme?.description,
        });
        this.readme.addSection('Getting Started', '```sh\nyarn install\nnpx projen build\n```');
        if (this.autoMerge) {
            this.github?.mergify?.addRule({
                name: 'Automatic approval for projen upgrade pull requests',
                conditions: [
                    'author=endor-projen[bot]',
                    ...(this.buildWorkflow?.buildJobIds?.map((id) => `status-success=${id}`) ?? []),
                ],
                actions: {
                    review: {
                        type: 'APPROVE',
                        message: 'Automatically approving projen upgrade',
                    },
                },
            });
            this.github?.mergify?.addRule({
                name: 'Assign PR when check fails',
                conditions: ['#check-failure > 0'],
                actions: {
                    assign: {
                        add_users: ['daveshepherd'],
                    },
                },
            });
        }
    }
}
exports.NpmPackage = NpmPackage;
_a = JSII_RTTI_SYMBOL_1;
NpmPackage[_a] = { fqn: "projen-modules.NpmPackage", version: "1.0.162" };
__exportStar(require("./npm-package-options"), exports);
//# sourceMappingURL=data:application/json;base64,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