"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeOptions = mergeOptions;
const isObject = (obj) => obj && typeof obj === 'object';
/**
 * Performs a deep merge of objects and returns new object. Does not modify
 * objects (immutable) and merges arrays via concatenation.
 *
 * @param  objects - Objects to merge
 * @returns  New object with merged key/values
 */
function mergeOptions(defaults, options) {
    return [defaults, options].reduce((prev, obj) => {
        if (obj === undefined) {
            return prev;
        }
        const result = { ...prev };
        Object.keys(obj).forEach((key) => {
            const pVal = prev[key];
            const oVal = obj[key];
            if (Array.isArray(pVal) && Array.isArray(oVal)) {
                result[key] = [...pVal, ...oVal];
            }
            else if (isObject(pVal) && isObject(oVal)) {
                result[key] = mergeOptions(pVal, oVal);
            }
            else {
                result[key] = oVal;
            }
        });
        return result;
    }, {});
}
//# sourceMappingURL=data:application/json;base64,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