''' programming languages of xlizard '''

from .zig import ZigReader
from .clike import CLikeReader
from .erlang import ErlangReader
from .java import JavaReader
from .javascript import JavaScriptReader
from .kotlin import KotlinReader
from .python import PythonReader
from .objc import ObjCReader
from .ttcn import TTCNReader
from .swift import SwiftReader
from .ruby import RubyReader
from .csharp import CSharpReader
from .php import PHPReader
from .scala import ScalaReader
from .gdscript import GDScriptReader
from .go import GoReader
from .lua import LuaReader
from .rust import RustReader
from .typescript import TypeScriptReader
from .fortran import FortranReader
from .solidity import SolidityReader
from .jsx import JSXReader
from .tsx import TSXReader
from .vue import VueReader
from .perl import PerlReader

__all__ = ['languages', 'get_reader_for']


def languages():
    return [
        CLikeReader,
        JavaReader,
        CSharpReader,
        JavaScriptReader,
        PythonReader,
        ObjCReader,
        TTCNReader,
        RubyReader,
        PHPReader,
        SwiftReader,
        ScalaReader,
        GDScriptReader,
        GoReader,
        LuaReader,
        RustReader,
        TypeScriptReader,
        FortranReader,
        KotlinReader,
        SolidityReader,
        ErlangReader,
        ZigReader,
        JSXReader,
        TSXReader,
        VueReader,
        PerlReader,
    ]


def get_reader_for(filename):
    """Находит подходящий Reader для файла"""
    for lan in languages():
        if lan.match_filename(filename):
            return lan