# mypy-boto3-securityhub

[![PyPI - mypy-boto3-securityhub](https://img.shields.io/pypi/v/mypy-boto3-securityhub.svg?color=blue)](https://pypi.org/project/mypy-boto3-securityhub)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-securityhub.svg?color=blue)](https://pypi.org/project/mypy-boto3-securityhub)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.SecurityHub 1.17.3](https://boto3.amazonaws.com/v1/documentation/api/1.17.3/reference/services/securityhub.html#SecurityHub) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.4.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-securityhub](#mypy-boto3-securityhub)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `SecurityHub` service.

```bash
python -m pip install boto3-stubs[securityhub]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[securityhub]` in your environment: `python -m pip install 'boto3-stubs[securityhub]'`

Both type checking and auto-complete should work for `SecurityHub` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[securityhub]` in your environment: `python -m pip install 'boto3-stubs[securityhub]'`

Both type checking and auto-complete should work for `SecurityHub` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[securityhub]` in your environment: `python -m pip install 'boto3-stubs[securityhub]'`
- Run `mypy` as usual

Type checking should work for `SecurityHub` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[securityhub]` in your environment: `python -m pip install 'boto3-stubs[securityhub]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `SecurityHub` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`SecurityHubClient` provides annotations for `boto3.client("securityhub")`.

```python
import boto3

from mypy_boto3_securityhub import SecurityHubClient

client: SecurityHubClient = boto3.client("securityhub")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SecurityHubClient = session.client("securityhub")
```

### Paginators annotations

`mypy_boto3_securityhub.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_securityhub import SecurityHubClient
from mypy_boto3_securityhub.paginator import (
    GetEnabledStandardsPaginator,
    GetFindingsPaginator,
    GetInsightsPaginator,
    ListEnabledProductsForImportPaginator,
    ListInvitationsPaginator,
    ListMembersPaginator,
)

client: SecurityHubClient = boto3.client("securityhub")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_enabled_standards_paginator: GetEnabledStandardsPaginator = client.get_paginator("get_enabled_standards")
get_findings_paginator: GetFindingsPaginator = client.get_paginator("get_findings")
get_insights_paginator: GetInsightsPaginator = client.get_paginator("get_insights")
list_enabled_products_for_import_paginator: ListEnabledProductsForImportPaginator = client.get_paginator("list_enabled_products_for_import")
list_invitations_paginator: ListInvitationsPaginator = client.get_paginator("list_invitations")
list_members_paginator: ListMembersPaginator = client.get_paginator("list_members")
```







### Typed dictionations

`mypy_boto3_securityhub.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_securityhub.type_defs import (
    ActionLocalIpDetailsTypeDef,
    ActionLocalPortDetailsTypeDef,
    ActionRemoteIpDetailsTypeDef,
    ActionRemotePortDetailsTypeDef,
    ActionTargetTypeDef,
    ActionTypeDef,
    AdminAccountTypeDef,
    AvailabilityZoneTypeDef,
    AwsApiCallActionDomainDetailsTypeDef,
    AwsApiCallActionTypeDef,
    AwsApiGatewayAccessLogSettingsTypeDef,
    AwsApiGatewayCanarySettingsTypeDef,
    AwsApiGatewayEndpointConfigurationTypeDef,
    AwsApiGatewayMethodSettingsTypeDef,
    AwsApiGatewayRestApiDetailsTypeDef,
    AwsApiGatewayStageDetailsTypeDef,
    AwsApiGatewayV2ApiDetailsTypeDef,
    AwsApiGatewayV2RouteSettingsTypeDef,
    AwsApiGatewayV2StageDetailsTypeDef,
    AwsAutoScalingAutoScalingGroupDetailsTypeDef,
    AwsCertificateManagerCertificateDetailsTypeDef,
    AwsCertificateManagerCertificateDomainValidationOptionTypeDef,
    AwsCertificateManagerCertificateExtendedKeyUsageTypeDef,
    AwsCertificateManagerCertificateKeyUsageTypeDef,
    AwsCertificateManagerCertificateOptionsTypeDef,
    AwsCertificateManagerCertificateRenewalSummaryTypeDef,
    AwsCertificateManagerCertificateResourceRecordTypeDef,
    AwsCloudFrontDistributionCacheBehaviorTypeDef,
    AwsCloudFrontDistributionCacheBehaviorsTypeDef,
    AwsCloudFrontDistributionDefaultCacheBehaviorTypeDef,
    AwsCloudFrontDistributionDetailsTypeDef,
    AwsCloudFrontDistributionLoggingTypeDef,
    AwsCloudFrontDistributionOriginGroupFailoverStatusCodesTypeDef,
    AwsCloudFrontDistributionOriginGroupFailoverTypeDef,
    AwsCloudFrontDistributionOriginGroupTypeDef,
    AwsCloudFrontDistributionOriginGroupsTypeDef,
    AwsCloudFrontDistributionOriginItemTypeDef,
    AwsCloudFrontDistributionOriginS3OriginConfigTypeDef,
    AwsCloudFrontDistributionOriginsTypeDef,
    AwsCloudTrailTrailDetailsTypeDef,
    AwsCodeBuildProjectDetailsTypeDef,
    AwsCodeBuildProjectEnvironmentRegistryCredentialTypeDef,
    AwsCodeBuildProjectEnvironmentTypeDef,
    AwsCodeBuildProjectSourceTypeDef,
    AwsCodeBuildProjectVpcConfigTypeDef,
    AwsCorsConfigurationTypeDef,
    AwsDynamoDbTableAttributeDefinitionTypeDef,
    AwsDynamoDbTableBillingModeSummaryTypeDef,
    AwsDynamoDbTableDetailsTypeDef,
    AwsDynamoDbTableGlobalSecondaryIndexTypeDef,
    AwsDynamoDbTableKeySchemaTypeDef,
    AwsDynamoDbTableLocalSecondaryIndexTypeDef,
    AwsDynamoDbTableProjectionTypeDef,
    AwsDynamoDbTableProvisionedThroughputOverrideTypeDef,
    AwsDynamoDbTableProvisionedThroughputTypeDef,
    AwsDynamoDbTableReplicaGlobalSecondaryIndexTypeDef,
    AwsDynamoDbTableReplicaTypeDef,
    AwsDynamoDbTableRestoreSummaryTypeDef,
    AwsDynamoDbTableSseDescriptionTypeDef,
    AwsDynamoDbTableStreamSpecificationTypeDef,
    AwsEc2EipDetailsTypeDef,
    AwsEc2InstanceDetailsTypeDef,
    AwsEc2NetworkInterfaceAttachmentTypeDef,
    AwsEc2NetworkInterfaceDetailsTypeDef,
    AwsEc2NetworkInterfaceIpV6AddressDetailTypeDef,
    AwsEc2NetworkInterfacePrivateIpAddressDetailTypeDef,
    AwsEc2NetworkInterfaceSecurityGroupTypeDef,
    AwsEc2SecurityGroupDetailsTypeDef,
    AwsEc2SecurityGroupIpPermissionTypeDef,
    AwsEc2SecurityGroupIpRangeTypeDef,
    AwsEc2SecurityGroupIpv6RangeTypeDef,
    AwsEc2SecurityGroupPrefixListIdTypeDef,
    AwsEc2SecurityGroupUserIdGroupPairTypeDef,
    AwsEc2VolumeAttachmentTypeDef,
    AwsEc2VolumeDetailsTypeDef,
    AwsEc2VpcDetailsTypeDef,
    AwsElasticsearchDomainDetailsTypeDef,
    AwsElasticsearchDomainDomainEndpointOptionsTypeDef,
    AwsElasticsearchDomainEncryptionAtRestOptionsTypeDef,
    AwsElasticsearchDomainNodeToNodeEncryptionOptionsTypeDef,
    AwsElasticsearchDomainVPCOptionsTypeDef,
    AwsElbAppCookieStickinessPolicyTypeDef,
    AwsElbLbCookieStickinessPolicyTypeDef,
    AwsElbLoadBalancerAccessLogTypeDef,
    AwsElbLoadBalancerAttributesTypeDef,
    AwsElbLoadBalancerBackendServerDescriptionTypeDef,
    AwsElbLoadBalancerConnectionDrainingTypeDef,
    AwsElbLoadBalancerConnectionSettingsTypeDef,
    AwsElbLoadBalancerCrossZoneLoadBalancingTypeDef,
    AwsElbLoadBalancerDetailsTypeDef,
    AwsElbLoadBalancerHealthCheckTypeDef,
    AwsElbLoadBalancerInstanceTypeDef,
    AwsElbLoadBalancerListenerDescriptionTypeDef,
    AwsElbLoadBalancerListenerTypeDef,
    AwsElbLoadBalancerPoliciesTypeDef,
    AwsElbLoadBalancerSourceSecurityGroupTypeDef,
    AwsElbv2LoadBalancerDetailsTypeDef,
    AwsIamAccessKeyDetailsTypeDef,
    AwsIamAccessKeySessionContextAttributesTypeDef,
    AwsIamAccessKeySessionContextSessionIssuerTypeDef,
    AwsIamAccessKeySessionContextTypeDef,
    AwsIamAttachedManagedPolicyTypeDef,
    AwsIamGroupDetailsTypeDef,
    AwsIamGroupPolicyTypeDef,
    AwsIamInstanceProfileRoleTypeDef,
    AwsIamInstanceProfileTypeDef,
    AwsIamPermissionsBoundaryTypeDef,
    AwsIamPolicyDetailsTypeDef,
    AwsIamPolicyVersionTypeDef,
    AwsIamRoleDetailsTypeDef,
    AwsIamRolePolicyTypeDef,
    AwsIamUserDetailsTypeDef,
    AwsIamUserPolicyTypeDef,
    AwsKmsKeyDetailsTypeDef,
    AwsLambdaFunctionCodeTypeDef,
    AwsLambdaFunctionDeadLetterConfigTypeDef,
    AwsLambdaFunctionDetailsTypeDef,
    AwsLambdaFunctionEnvironmentErrorTypeDef,
    AwsLambdaFunctionEnvironmentTypeDef,
    AwsLambdaFunctionLayerTypeDef,
    AwsLambdaFunctionTracingConfigTypeDef,
    AwsLambdaFunctionVpcConfigTypeDef,
    AwsLambdaLayerVersionDetailsTypeDef,
    AwsRdsDbClusterAssociatedRoleTypeDef,
    AwsRdsDbClusterDetailsTypeDef,
    AwsRdsDbClusterMemberTypeDef,
    AwsRdsDbClusterOptionGroupMembershipTypeDef,
    AwsRdsDbClusterSnapshotDetailsTypeDef,
    AwsRdsDbDomainMembershipTypeDef,
    AwsRdsDbInstanceAssociatedRoleTypeDef,
    AwsRdsDbInstanceDetailsTypeDef,
    AwsRdsDbInstanceEndpointTypeDef,
    AwsRdsDbInstanceVpcSecurityGroupTypeDef,
    AwsRdsDbOptionGroupMembershipTypeDef,
    AwsRdsDbParameterGroupTypeDef,
    AwsRdsDbPendingModifiedValuesTypeDef,
    AwsRdsDbProcessorFeatureTypeDef,
    AwsRdsDbSnapshotDetailsTypeDef,
    AwsRdsDbStatusInfoTypeDef,
    AwsRdsDbSubnetGroupSubnetAvailabilityZoneTypeDef,
    AwsRdsDbSubnetGroupSubnetTypeDef,
    AwsRdsDbSubnetGroupTypeDef,
    AwsRdsPendingCloudWatchLogsExportsTypeDef,
    AwsRedshiftClusterClusterNodeTypeDef,
    AwsRedshiftClusterClusterParameterGroupTypeDef,
    AwsRedshiftClusterClusterParameterStatusTypeDef,
    AwsRedshiftClusterClusterSecurityGroupTypeDef,
    AwsRedshiftClusterClusterSnapshotCopyStatusTypeDef,
    AwsRedshiftClusterDeferredMaintenanceWindowTypeDef,
    AwsRedshiftClusterDetailsTypeDef,
    AwsRedshiftClusterElasticIpStatusTypeDef,
    AwsRedshiftClusterEndpointTypeDef,
    AwsRedshiftClusterHsmStatusTypeDef,
    AwsRedshiftClusterIamRoleTypeDef,
    AwsRedshiftClusterPendingModifiedValuesTypeDef,
    AwsRedshiftClusterResizeInfoTypeDef,
    AwsRedshiftClusterRestoreStatusTypeDef,
    AwsRedshiftClusterVpcSecurityGroupTypeDef,
    AwsS3BucketDetailsTypeDef,
    AwsS3BucketServerSideEncryptionByDefaultTypeDef,
    AwsS3BucketServerSideEncryptionConfigurationTypeDef,
    AwsS3BucketServerSideEncryptionRuleTypeDef,
    AwsS3ObjectDetailsTypeDef,
    AwsSecretsManagerSecretDetailsTypeDef,
    AwsSecretsManagerSecretRotationRulesTypeDef,
    AwsSecurityFindingFiltersTypeDef,
    AwsSecurityFindingIdentifierTypeDef,
    AwsSecurityFindingTypeDef,
    AwsSnsTopicDetailsTypeDef,
    AwsSnsTopicSubscriptionTypeDef,
    AwsSqsQueueDetailsTypeDef,
    AwsSsmComplianceSummaryTypeDef,
    AwsSsmPatchComplianceDetailsTypeDef,
    AwsSsmPatchTypeDef,
    AwsWafWebAclDetailsTypeDef,
    AwsWafWebAclRuleTypeDef,
    BatchUpdateFindingsUnprocessedFindingTypeDef,
    CidrBlockAssociationTypeDef,
    CityTypeDef,
    ComplianceTypeDef,
    ContainerDetailsTypeDef,
    CountryTypeDef,
    CvssTypeDef,
    DateFilterTypeDef,
    DateRangeTypeDef,
    DnsRequestActionTypeDef,
    GeoLocationTypeDef,
    ImportFindingsErrorTypeDef,
    InsightResultValueTypeDef,
    InsightResultsTypeDef,
    InsightTypeDef,
    InvitationTypeDef,
    IpFilterTypeDef,
    IpOrganizationDetailsTypeDef,
    Ipv6CidrBlockAssociationTypeDef,
    KeywordFilterTypeDef,
    LoadBalancerStateTypeDef,
    MalwareTypeDef,
    MapFilterTypeDef,
    MemberTypeDef,
    NetworkConnectionActionTypeDef,
    NetworkHeaderTypeDef,
    NetworkPathComponentDetailsTypeDef,
    NetworkPathComponentTypeDef,
    NetworkTypeDef,
    NoteTypeDef,
    NumberFilterTypeDef,
    PatchSummaryTypeDef,
    PortProbeActionTypeDef,
    PortProbeDetailTypeDef,
    PortRangeTypeDef,
    ProcessDetailsTypeDef,
    ProductTypeDef,
    RecommendationTypeDef,
    RelatedFindingTypeDef,
    RemediationTypeDef,
    ResourceDetailsTypeDef,
    ResourceTypeDef,
    ResultTypeDef,
    SeverityTypeDef,
    SoftwarePackageTypeDef,
    StandardTypeDef,
    StandardsControlTypeDef,
    StandardsSubscriptionTypeDef,
    StatusReasonTypeDef,
    StringFilterTypeDef,
    ThreatIntelIndicatorTypeDef,
    VulnerabilityTypeDef,
    VulnerabilityVendorTypeDef,
    WafActionTypeDef,
    WafExcludedRuleTypeDef,
    WafOverrideActionTypeDef,
    WorkflowTypeDef,
    AccountDetailsTypeDef,
    BatchDisableStandardsResponseTypeDef,
    BatchEnableStandardsResponseTypeDef,
    BatchImportFindingsResponseTypeDef,
    BatchUpdateFindingsResponseTypeDef,
    CreateActionTargetResponseTypeDef,
    CreateInsightResponseTypeDef,
    CreateMembersResponseTypeDef,
    DeclineInvitationsResponseTypeDef,
    DeleteActionTargetResponseTypeDef,
    DeleteInsightResponseTypeDef,
    DeleteInvitationsResponseTypeDef,
    DeleteMembersResponseTypeDef,
    DescribeActionTargetsResponseTypeDef,
    DescribeHubResponseTypeDef,
    DescribeOrganizationConfigurationResponseTypeDef,
    DescribeProductsResponseTypeDef,
    DescribeStandardsControlsResponseTypeDef,
    DescribeStandardsResponseTypeDef,
    EnableImportFindingsForProductResponseTypeDef,
    GetEnabledStandardsResponseTypeDef,
    GetFindingsResponseTypeDef,
    GetInsightResultsResponseTypeDef,
    GetInsightsResponseTypeDef,
    GetInvitationsCountResponseTypeDef,
    GetMasterAccountResponseTypeDef,
    GetMembersResponseTypeDef,
    InviteMembersResponseTypeDef,
    ListEnabledProductsForImportResponseTypeDef,
    ListInvitationsResponseTypeDef,
    ListMembersResponseTypeDef,
    ListOrganizationAdminAccountsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    NoteUpdateTypeDef,
    PaginatorConfigTypeDef,
    SeverityUpdateTypeDef,
    SortCriterionTypeDef,
    StandardsSubscriptionRequestTypeDef,
    WorkflowUpdateTypeDef,
)

def get_structure() -> ActionLocalIpDetailsTypeDef:
    return {
      ...
    }
```
