# Get Started

First of all, make sure you have TALLY_API_KEY in your ENV variables and load it.

``` python
from src.core.client import TallyClient
from dotenv import load_dotenv

load_dotenv()
tallyc = TallyClient()
```

Next you can query Tally according to their docs.

### User
```python 
# Get current user informations 
tallyc.users.get()
```

### Forms
```python 
form_id = 'XYZ'
sub_id = 'ABC'

# List all forms 
tallyc.forms.list()

# retrieve specific form 
tallyc.forms.retrieve(form_id)
    
# List all form's questions 
tallyc.forms.form_questions(form_id)
    
# List all form's submissions
tallyc.forms.list_submissions(form_id)
    
# retrieve specific form's sumbmission
tallyc.forms.retrieve_submission(form_id, sub_id)  
```

