from tally.core.resources import UsersResource, FormResources
from os import environ
import requests


class TallyClient:
    def __init__(self, api_key=None, base_url="https://api.tally.so"):
        self.base_url = base_url
        self.session = requests.Session()

        if api_key is None:
            try:
                api_key = environ.get("TALLY_API_KEY")
            except KeyError:
                raise Exception(
                    "you must set TALLY_API_KEY environment variable or either pass api_key to client object")

        self.session.headers.update({"Authorization": f"Bearer {api_key}"})

        # Initialize resource handlers
        self.users = UsersResource(self)
        self.forms = FormResources(self)

    def _request(self, method, url, **kwargs):
        """Central request method with error handling"""
        request_url = f"{self.base_url}/{url}"
        response = self.session.request(
            method, request_url, **kwargs)
        # TODO: Handle errors, rate limits, etc.
        return response.json()
