# Generated by Django 4.2.17 on 2025-01-22 07:34
# flake8: noqa

import django.contrib.auth.models
import django.contrib.auth.validators
import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models

import pfx.pfxcore.fields
import pfx.pfxcore.models.cache_mixins
import pfx.pfxcore.models.not_null_fields
import pfx.pfxcore.models.pfx_models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='Author',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(max_length=30, verbose_name='First Name')),
                ('last_name', models.CharField(max_length=30, verbose_name='Last Name')),
                ('slug', models.SlugField(unique=True, verbose_name='Slug')),
                ('gender', models.CharField(choices=[('male', 'Male'), ('female', 'Female')], default='male', max_length=10, verbose_name='Gender')),
                ('science_fiction', models.BooleanField(default=False, verbose_name='Science Fiction')),
                ('created_at', models.DateField(auto_now_add=True, verbose_name='Created at')),
                ('create_comment', pfx.pfxcore.models.not_null_fields.NotNullCharField(blank=True, max_length=255, verbose_name='Create comment')),
                ('update_comment', pfx.pfxcore.models.not_null_fields.NotNullCharField(blank=True, max_length=255, verbose_name='Update comment')),
                ('website', pfx.pfxcore.models.not_null_fields.NotNullURLField(blank=True, max_length=255, verbose_name='Website')),
            ],
            options={
                'verbose_name': 'Author',
                'verbose_name_plural': 'Authors',
                'ordering': ['last_name', 'first_name', 'pk'],
                'permissions': [('can_customize_author', 'Can customize author')],
            },
            bases=(pfx.pfxcore.models.cache_mixins.CacheableMixin, pfx.pfxcore.models.pfx_models.JSONReprMixin, models.Model),
        ),
        migrations.CreateModel(
            name='BookType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=30, verbose_name='Name')),
                ('slug', models.SlugField(verbose_name='Slug')),
            ],
            options={
                'verbose_name': 'Book Type',
                'verbose_name_plural': 'Book Types',
            },
            bases=(pfx.pfxcore.models.cache_mixins.CacheDependsMixin, pfx.pfxcore.models.pfx_models.PFXModelMixin, models.Model),
        ),
        migrations.CreateModel(
            name='Book',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('pub_date', models.DateField(verbose_name='Pub Date')),
                ('created_at', models.DateField(auto_now_add=True, verbose_name='Created at')),
                ('pages', models.IntegerField(blank=True, null=True, verbose_name='Pages')),
                ('rating', models.FloatField(blank=True, null=True, verbose_name='Rating')),
                ('reference', models.CharField(blank=True, max_length=30, null=True, verbose_name='Reference')),
                ('cover', pfx.pfxcore.fields.MediaField(blank=True, default=dict, max_length=255, verbose_name='Cover')),
                ('read_time', pfx.pfxcore.fields.MinutesDurationField(blank=True, null=True, verbose_name='Read Time')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, related_name='books', to='tests.author', verbose_name='Author')),
                ('type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='books', to='tests.booktype', verbose_name='Book Type')),
            ],
            options={
                'verbose_name': 'Book',
                'verbose_name_plural': 'Books',
            },
            bases=(pfx.pfxcore.models.cache_mixins.CacheDependsMixin, pfx.pfxcore.models.pfx_models.PFXModelMixin, models.Model),
        ),
        migrations.AddField(
            model_name='author',
            name='types',
            field=models.ManyToManyField(related_name='authors', to='tests.booktype', verbose_name='Types'),
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=150, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('otp_secret_token', models.CharField(blank=True, max_length=32, null=True, unique=True, verbose_name='OTP secret token')),
                ('otp_secret_token_tmp', models.CharField(blank=True, max_length=32, null=True, verbose_name='Temporary OTP secret token')),
                ('hotp_count', models.IntegerField(default=0, verbose_name='HOTP count')),
                ('hotp_expiry', models.DateTimeField(default=django.utils.timezone.now, verbose_name='HOTP expiry')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
            },
            bases=(pfx.pfxcore.models.cache_mixins.CacheableMixin, pfx.pfxcore.models.pfx_models.PFXModelMixin, models.Model),
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.AddConstraint(
            model_name='book',
            constraint=pfx.pfxcore.models.pfx_models.UniqueConstraint(fields=('author', 'name'), message='%(name)s already exists for %(author)s', name='book_unique_author_and_name'),
        ),
    ]
