# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iparapheur_internal.models.media_type import MediaType
from iparapheur_internal.models.validated_signature_information import ValidatedSignatureInformation
from typing import Optional, Set
from typing_extensions import Self

class DetachedSignature(BaseModel):
    """
    DetachedSignature
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    content_length: Optional[StrictInt] = Field(default=None, alias="contentLength")
    media_type: Optional[MediaType] = Field(default=None, alias="mediaType")
    target_document_id: Optional[StrictStr] = Field(default=None, alias="targetDocumentId")
    target_task_id: Optional[StrictStr] = Field(default=None, alias="targetTaskId")
    signature_info: Optional[ValidatedSignatureInformation] = Field(default=None, alias="signatureInfo")
    __properties: ClassVar[List[str]] = ["id", "name", "contentLength", "mediaType", "targetDocumentId", "targetTaskId", "signatureInfo"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DetachedSignature from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of media_type
        if self.media_type:
            _dict['mediaType'] = self.media_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of signature_info
        if self.signature_info:
            _dict['signatureInfo'] = self.signature_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DetachedSignature from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "contentLength": obj.get("contentLength"),
            "mediaType": MediaType.from_dict(obj["mediaType"]) if obj.get("mediaType") is not None else None,
            "targetDocumentId": obj.get("targetDocumentId"),
            "targetTaskId": obj.get("targetTaskId"),
            "signatureInfo": ValidatedSignatureInformation.from_dict(obj["signatureInfo"]) if obj.get("signatureInfo") is not None else None
        })
        return _obj


