# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iparapheur_internal.models.detached_signature import DetachedSignature
from iparapheur_internal.models.media_type import MediaType
from iparapheur_internal.models.page_info import PageInfo
from iparapheur_internal.models.pdf_signature_position import PdfSignaturePosition
from iparapheur_internal.models.signature_placement import SignaturePlacement
from iparapheur_internal.models.validated_signature_information import ValidatedSignatureInformation
from typing import Optional, Set
from typing_extensions import Self

class SignatureProof(BaseModel):
    """
    SignatureProof
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    index: Optional[StrictInt] = None
    page_count: Optional[StrictInt] = Field(default=None, alias="pageCount")
    content_length: Optional[StrictInt] = Field(default=None, alias="contentLength")
    media_type: Optional[MediaType] = Field(default=None, alias="mediaType")
    pages_properties: Optional[Dict[str, PageInfo]] = Field(default=None, alias="pagesProperties")
    pdf_visual_id: Optional[StrictStr] = Field(default=None, alias="pdfVisualId")
    signature_placement_annotations: Optional[List[SignaturePlacement]] = Field(default=None, alias="signaturePlacementAnnotations")
    signature_tags: Optional[Dict[str, PdfSignaturePosition]] = Field(default=None, alias="signatureTags")
    seal_tags: Optional[Dict[str, PdfSignaturePosition]] = Field(default=None, alias="sealTags")
    detached_signatures: Optional[List[DetachedSignature]] = Field(default=None, alias="detachedSignatures")
    embedded_signature_infos: Optional[List[ValidatedSignatureInformation]] = Field(default=None, alias="embeddedSignatureInfos")
    proof_target_task_id: Optional[StrictStr] = Field(default=None, alias="proofTargetTaskId")
    error_message: Optional[StrictStr] = Field(default=None, alias="errorMessage")
    internal: Optional[StrictBool] = None
    signature_proof: Optional[StrictBool] = Field(default=None, alias="signatureProof")
    deletable: Optional[StrictBool] = None
    is_main_document: Optional[StrictBool] = Field(default=None, alias="isMainDocument")
    __properties: ClassVar[List[str]] = ["id", "name", "index", "pageCount", "contentLength", "mediaType", "pagesProperties", "pdfVisualId", "signaturePlacementAnnotations", "signatureTags", "sealTags", "detachedSignatures", "embeddedSignatureInfos", "proofTargetTaskId", "errorMessage", "internal", "signatureProof", "deletable", "isMainDocument"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SignatureProof from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of media_type
        if self.media_type:
            _dict['mediaType'] = self.media_type.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in pages_properties (dict)
        _field_dict = {}
        if self.pages_properties:
            for _key_pages_properties in self.pages_properties:
                if self.pages_properties[_key_pages_properties]:
                    _field_dict[_key_pages_properties] = self.pages_properties[_key_pages_properties].to_dict()
            _dict['pagesProperties'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in signature_placement_annotations (list)
        _items = []
        if self.signature_placement_annotations:
            for _item_signature_placement_annotations in self.signature_placement_annotations:
                if _item_signature_placement_annotations:
                    _items.append(_item_signature_placement_annotations.to_dict())
            _dict['signaturePlacementAnnotations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each value in signature_tags (dict)
        _field_dict = {}
        if self.signature_tags:
            for _key_signature_tags in self.signature_tags:
                if self.signature_tags[_key_signature_tags]:
                    _field_dict[_key_signature_tags] = self.signature_tags[_key_signature_tags].to_dict()
            _dict['signatureTags'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in seal_tags (dict)
        _field_dict = {}
        if self.seal_tags:
            for _key_seal_tags in self.seal_tags:
                if self.seal_tags[_key_seal_tags]:
                    _field_dict[_key_seal_tags] = self.seal_tags[_key_seal_tags].to_dict()
            _dict['sealTags'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each item in detached_signatures (list)
        _items = []
        if self.detached_signatures:
            for _item_detached_signatures in self.detached_signatures:
                if _item_detached_signatures:
                    _items.append(_item_detached_signatures.to_dict())
            _dict['detachedSignatures'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in embedded_signature_infos (list)
        _items = []
        if self.embedded_signature_infos:
            for _item_embedded_signature_infos in self.embedded_signature_infos:
                if _item_embedded_signature_infos:
                    _items.append(_item_embedded_signature_infos.to_dict())
            _dict['embeddedSignatureInfos'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SignatureProof from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "index": obj.get("index"),
            "pageCount": obj.get("pageCount"),
            "contentLength": obj.get("contentLength"),
            "mediaType": MediaType.from_dict(obj["mediaType"]) if obj.get("mediaType") is not None else None,
            "pagesProperties": dict(
                (_k, PageInfo.from_dict(_v))
                for _k, _v in obj["pagesProperties"].items()
            )
            if obj.get("pagesProperties") is not None
            else None,
            "pdfVisualId": obj.get("pdfVisualId"),
            "signaturePlacementAnnotations": [SignaturePlacement.from_dict(_item) for _item in obj["signaturePlacementAnnotations"]] if obj.get("signaturePlacementAnnotations") is not None else None,
            "signatureTags": dict(
                (_k, PdfSignaturePosition.from_dict(_v))
                for _k, _v in obj["signatureTags"].items()
            )
            if obj.get("signatureTags") is not None
            else None,
            "sealTags": dict(
                (_k, PdfSignaturePosition.from_dict(_v))
                for _k, _v in obj["sealTags"].items()
            )
            if obj.get("sealTags") is not None
            else None,
            "detachedSignatures": [DetachedSignature.from_dict(_item) for _item in obj["detachedSignatures"]] if obj.get("detachedSignatures") is not None else None,
            "embeddedSignatureInfos": [ValidatedSignatureInformation.from_dict(_item) for _item in obj["embeddedSignatureInfos"]] if obj.get("embeddedSignatureInfos") is not None else None,
            "proofTargetTaskId": obj.get("proofTargetTaskId"),
            "errorMessage": obj.get("errorMessage"),
            "internal": obj.get("internal"),
            "signatureProof": obj.get("signatureProof"),
            "deletable": obj.get("deletable"),
            "isMainDocument": obj.get("isMainDocument")
        })
        return _obj


