# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iparapheur_internal.models.external_signature_config import ExternalSignatureConfig
from iparapheur_internal.models.subtype_layer import SubtypeLayer
from iparapheur_internal.models.subtype_metadata import SubtypeMetadata
from typing import Optional, Set
from typing_extensions import Self

class Subtype(BaseModel):
    """
    Subtype
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    creation_workflow_id: Optional[StrictStr] = Field(default=None, alias="creationWorkflowId")
    validation_workflow_id: Optional[StrictStr] = Field(default=None, alias="validationWorkflowId")
    workflow_selection_script: Optional[StrictStr] = Field(default=None, alias="workflowSelectionScript")
    annotations_allowed: Optional[StrictBool] = Field(default=None, alias="annotationsAllowed")
    external_signature_automatic: Optional[StrictBool] = Field(default=None, alias="externalSignatureAutomatic")
    secure_mail_server_id: Optional[StrictInt] = Field(default=None, alias="secureMailServerId")
    seal_certificate_id: Optional[StrictStr] = Field(default=None, alias="sealCertificateId")
    external_signature_config: Optional[ExternalSignatureConfig] = Field(default=None, alias="externalSignatureConfig")
    subtype_metadata_list: Optional[List[SubtypeMetadata]] = Field(default=None, alias="subtypeMetadataList")
    subtype_layers: Optional[List[SubtypeLayer]] = Field(default=None, alias="subtypeLayers")
    creation_permitted_desk_ids: Optional[List[StrictStr]] = Field(default=None, alias="creationPermittedDeskIds")
    filterable_by_desk_ids: Optional[List[StrictStr]] = Field(default=None, alias="filterableByDeskIds")
    multi_documents: Optional[StrictBool] = Field(default=None, alias="multiDocuments")
    annexe_included: Optional[StrictBool] = Field(default=None, alias="annexeIncluded")
    digital_signature_mandatory: Optional[StrictBool] = Field(default=None, alias="digitalSignatureMandatory")
    reading_mandatory: Optional[StrictBool] = Field(default=None, alias="readingMandatory")
    seal_automatic: Optional[StrictBool] = Field(default=None, alias="sealAutomatic")
    __properties: ClassVar[List[str]] = ["id", "name", "description", "creationWorkflowId", "validationWorkflowId", "workflowSelectionScript", "annotationsAllowed", "externalSignatureAutomatic", "secureMailServerId", "sealCertificateId", "externalSignatureConfig", "subtypeMetadataList", "subtypeLayers", "creationPermittedDeskIds", "filterableByDeskIds", "multiDocuments", "annexeIncluded", "digitalSignatureMandatory", "readingMandatory", "sealAutomatic"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Subtype from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of external_signature_config
        if self.external_signature_config:
            _dict['externalSignatureConfig'] = self.external_signature_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in subtype_metadata_list (list)
        _items = []
        if self.subtype_metadata_list:
            for _item_subtype_metadata_list in self.subtype_metadata_list:
                if _item_subtype_metadata_list:
                    _items.append(_item_subtype_metadata_list.to_dict())
            _dict['subtypeMetadataList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in subtype_layers (list)
        _items = []
        if self.subtype_layers:
            for _item_subtype_layers in self.subtype_layers:
                if _item_subtype_layers:
                    _items.append(_item_subtype_layers.to_dict())
            _dict['subtypeLayers'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Subtype from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "creationWorkflowId": obj.get("creationWorkflowId"),
            "validationWorkflowId": obj.get("validationWorkflowId"),
            "workflowSelectionScript": obj.get("workflowSelectionScript"),
            "annotationsAllowed": obj.get("annotationsAllowed"),
            "externalSignatureAutomatic": obj.get("externalSignatureAutomatic"),
            "secureMailServerId": obj.get("secureMailServerId"),
            "sealCertificateId": obj.get("sealCertificateId"),
            "externalSignatureConfig": ExternalSignatureConfig.from_dict(obj["externalSignatureConfig"]) if obj.get("externalSignatureConfig") is not None else None,
            "subtypeMetadataList": [SubtypeMetadata.from_dict(_item) for _item in obj["subtypeMetadataList"]] if obj.get("subtypeMetadataList") is not None else None,
            "subtypeLayers": [SubtypeLayer.from_dict(_item) for _item in obj["subtypeLayers"]] if obj.get("subtypeLayers") is not None else None,
            "creationPermittedDeskIds": obj.get("creationPermittedDeskIds"),
            "filterableByDeskIds": obj.get("filterableByDeskIds"),
            "multiDocuments": obj.get("multiDocuments"),
            "annexeIncluded": obj.get("annexeIncluded"),
            "digitalSignatureMandatory": obj.get("digitalSignatureMandatory"),
            "readingMandatory": obj.get("readingMandatory"),
            "sealAutomatic": obj.get("sealAutomatic")
        })
        return _obj


