# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from iparapheur_internal.models.action import Action
from iparapheur_internal.models.desk_representation import DeskRepresentation
from iparapheur_internal.models.external_state import ExternalState
from iparapheur_internal.models.state import State
from iparapheur_internal.models.user_representation import UserRepresentation
from typing import Optional, Set
from typing_extensions import Self

class Task(BaseModel):
    """
    Task
    """ # noqa: E501
    id: Optional[StrictStr] = None
    metadata: Optional[Dict[str, StrictStr]] = None
    action: Optional[Action] = None
    performed_action: Optional[Action] = Field(default=None, alias="performedAction")
    external_state: Optional[ExternalState] = Field(default=None, alias="externalState")
    state: Optional[State] = None
    desks: Optional[List[DeskRepresentation]] = None
    delegated_by_desk: Optional[DeskRepresentation] = Field(default=None, alias="delegatedByDesk")
    user: Optional[UserRepresentation] = None
    read_by_user_ids: Optional[List[StrictStr]] = Field(default=None, alias="readByUserIds")
    public_certificate_base64: Optional[StrictStr] = Field(default=None, alias="publicCertificateBase64")
    external_signature_procedure_id: Optional[StrictStr] = Field(default=None, alias="externalSignatureProcedureId")
    begin_date: Optional[datetime] = Field(default=None, alias="beginDate")
    var_date: Optional[datetime] = Field(default=None, alias="date")
    draft_creation_date: Optional[datetime] = Field(default=None, alias="draftCreationDate")
    public_annotation: Optional[StrictStr] = Field(default=None, alias="publicAnnotation")
    private_annotation: Optional[StrictStr] = Field(default=None, alias="privateAnnotation")
    notified_desks: Optional[List[DeskRepresentation]] = Field(default=None, alias="notifiedDesks")
    workflow_index: Optional[StrictInt] = Field(default=None, alias="workflowIndex")
    step_index: Optional[StrictInt] = Field(default=None, alias="stepIndex")
    mandatory_validation_metadata: Optional[List[StrictStr]] = Field(default=None, alias="mandatoryValidationMetadata")
    mandatory_rejection_metadata: Optional[List[StrictStr]] = Field(default=None, alias="mandatoryRejectionMetadata")
    instance_name: Optional[StrictStr] = Field(default=None, alias="instanceName")
    read_by_current_user: Optional[StrictBool] = Field(default=None, alias="readByCurrentUser")
    __properties: ClassVar[List[str]] = ["id", "metadata", "action", "performedAction", "externalState", "state", "desks", "delegatedByDesk", "user", "readByUserIds", "publicCertificateBase64", "externalSignatureProcedureId", "beginDate", "date", "draftCreationDate", "publicAnnotation", "privateAnnotation", "notifiedDesks", "workflowIndex", "stepIndex", "mandatoryValidationMetadata", "mandatoryRejectionMetadata", "instanceName", "readByCurrentUser"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Task from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in desks (list)
        _items = []
        if self.desks:
            for _item_desks in self.desks:
                if _item_desks:
                    _items.append(_item_desks.to_dict())
            _dict['desks'] = _items
        # override the default output from pydantic by calling `to_dict()` of delegated_by_desk
        if self.delegated_by_desk:
            _dict['delegatedByDesk'] = self.delegated_by_desk.to_dict()
        # override the default output from pydantic by calling `to_dict()` of user
        if self.user:
            _dict['user'] = self.user.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in notified_desks (list)
        _items = []
        if self.notified_desks:
            for _item_notified_desks in self.notified_desks:
                if _item_notified_desks:
                    _items.append(_item_notified_desks.to_dict())
            _dict['notifiedDesks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Task from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "metadata": obj.get("metadata"),
            "action": obj.get("action"),
            "performedAction": obj.get("performedAction"),
            "externalState": obj.get("externalState"),
            "state": obj.get("state"),
            "desks": [DeskRepresentation.from_dict(_item) for _item in obj["desks"]] if obj.get("desks") is not None else None,
            "delegatedByDesk": DeskRepresentation.from_dict(obj["delegatedByDesk"]) if obj.get("delegatedByDesk") is not None else None,
            "user": UserRepresentation.from_dict(obj["user"]) if obj.get("user") is not None else None,
            "readByUserIds": obj.get("readByUserIds"),
            "publicCertificateBase64": obj.get("publicCertificateBase64"),
            "externalSignatureProcedureId": obj.get("externalSignatureProcedureId"),
            "beginDate": obj.get("beginDate"),
            "date": obj.get("date"),
            "draftCreationDate": obj.get("draftCreationDate"),
            "publicAnnotation": obj.get("publicAnnotation"),
            "privateAnnotation": obj.get("privateAnnotation"),
            "notifiedDesks": [DeskRepresentation.from_dict(_item) for _item in obj["notifiedDesks"]] if obj.get("notifiedDesks") is not None else None,
            "workflowIndex": obj.get("workflowIndex"),
            "stepIndex": obj.get("stepIndex"),
            "mandatoryValidationMetadata": obj.get("mandatoryValidationMetadata"),
            "mandatoryRejectionMetadata": obj.get("mandatoryRejectionMetadata"),
            "instanceName": obj.get("instanceName"),
            "readByCurrentUser": obj.get("readByCurrentUser")
        })
        return _obj


