# coding: utf-8

"""
    iparapheur

    iparapheur v5.x main core application.  The main link between every sub-services, integrating business code logic. 

    The version of the OpenAPI document: DEVELOP
    Contact: iparapheur@libriciel.coop
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from iparapheur_internal.models.template_info import TemplateInfo
from typing import Optional, Set
from typing_extensions import Self

class TenantDto(BaseModel):
    """
    TenantDto
    """ # noqa: E501
    id: Optional[StrictStr] = None
    name: Annotated[str, Field(min_length=2, strict=True, max_length=255)]
    template_info_map: Optional[Dict[str, TemplateInfo]] = Field(default=None, alias="templateInfoMap")
    zip_code: Optional[StrictStr] = Field(default=None, alias="zipCode")
    desk_limit: Optional[Annotated[int, Field(le=250000, strict=True)]] = Field(default=None, alias="deskLimit")
    user_limit: Optional[Annotated[int, Field(le=50000, strict=True)]] = Field(default=None, alias="userLimit")
    workflow_limit: Optional[Annotated[int, Field(le=50000, strict=True)]] = Field(default=None, alias="workflowLimit")
    type_limit: Optional[Annotated[int, Field(le=50000, strict=True)]] = Field(default=None, alias="typeLimit")
    subtype_limit: Optional[Annotated[int, Field(le=50000, strict=True)]] = Field(default=None, alias="subtypeLimit")
    folder_limit: Optional[Annotated[int, Field(le=1000000, strict=True)]] = Field(default=None, alias="folderLimit")
    metadata_limit: Optional[Annotated[int, Field(le=50000, strict=True)]] = Field(default=None, alias="metadataLimit")
    layer_limit: Optional[Annotated[int, Field(le=50000, strict=True)]] = Field(default=None, alias="layerLimit")
    __properties: ClassVar[List[str]] = ["id", "name", "templateInfoMap", "zipCode", "deskLimit", "userLimit", "workflowLimit", "typeLimit", "subtypeLimit", "folderLimit", "metadataLimit", "layerLimit"]

    @field_validator('name')
    def name_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"^[^\r\n ]*$", value):
            raise ValueError(r"must validate the regular expression /^[^\r\n ]*$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TenantDto from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "id",
            "template_info_map",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in template_info_map (dict)
        _field_dict = {}
        if self.template_info_map:
            for _key_template_info_map in self.template_info_map:
                if self.template_info_map[_key_template_info_map]:
                    _field_dict[_key_template_info_map] = self.template_info_map[_key_template_info_map].to_dict()
            _dict['templateInfoMap'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TenantDto from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "templateInfoMap": dict(
                (_k, TemplateInfo.from_dict(_v))
                for _k, _v in obj["templateInfoMap"].items()
            )
            if obj.get("templateInfoMap") is not None
            else None,
            "zipCode": obj.get("zipCode"),
            "deskLimit": obj.get("deskLimit"),
            "userLimit": obj.get("userLimit"),
            "workflowLimit": obj.get("workflowLimit"),
            "typeLimit": obj.get("typeLimit"),
            "subtypeLimit": obj.get("subtypeLimit"),
            "folderLimit": obj.get("folderLimit"),
            "metadataLimit": obj.get("metadataLimit"),
            "layerLimit": obj.get("layerLimit")
        })
        return _obj


