// This file is autogenerated. Do not modify
package httpapi

import (
	"net/http"

	"github.com/gorilla/mux"
)

// Route defines the parameters for an api endpoint.
type Route struct {
	Name    string
	Method  string
	Path    string
	Handler http.HandlerFunc
}

// Controller creates a set of HTTP routes.
type HttpController interface {
	Routes() []Route
}

// AppendRoutes appends the routes of one or more Controllers to a mux.Router.
// If a nil router is passed, a new router will be created here.
func AppendRoutes(router *mux.Router, controllers ...HttpController) *mux.Router {
	if router == nil {
		router = mux.NewRouter()
	}

	for _, controller := range controllers {
		for _, route := range controller.Routes() {
			router.
				Methods(route.Method).
				Path(route.Path).
				Name(route.Name).
				Handler(route.Handler)
		}
	}
	return router
}
