"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChatbotFlow = exports.ChatbotFlowProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const appflow_generated_1 = require("./appflow.generated");
Object.defineProperty(exports, "ChatbotFlowProperty", { enumerable: true, get: function () { return appflow_generated_1.RosChatbotFlow; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::AppFlow::ChatbotFlow`.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosChatbotFlow`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-appflow-chatbotflow
 */
class ChatbotFlow extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosChatbotFlow = new appflow_generated_1.RosChatbotFlow(this, id, {
            flowConfig: props.flowConfig,
            chatbotId: props.chatbotId,
            flowName: props.flowName,
            flowType: props.flowType,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosChatbotFlow;
        this.attrChatbotFlowId = rosChatbotFlow.attrChatbotFlowId;
    }
}
exports.ChatbotFlow = ChatbotFlow;
//# sourceMappingURL=data:application/json;base64,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