# Generated by Django 5.2 on 2025-05-26 08:53
import django.db.models.deletion
import taggit.managers
import utilities.json
from django.db import migrations
from django.db import models


class Migration(migrations.Migration):
    dependencies = [
        ("extras", "0128_tableconfig"),
        ("ipfabric_netbox", "0001_initial_squashed_0013_switch_to_branching_plugin"),
    ]

    operations = [
        migrations.CreateModel(
            name="IPFabricTransformMapGroup",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True, primary_key=True, serialize=False
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "custom_field_data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=utilities.json.CustomFieldJSONEncoder,
                    ),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                ("description", models.TextField(blank=True, null=True)),
                (
                    "tags",
                    taggit.managers.TaggableManager(
                        through="extras.TaggedItem", to="extras.Tag"
                    ),
                ),
            ],
            options={
                "verbose_name": "IP Fabric Transform Map Group",
                "verbose_name_plural": "IP Fabric Transform Map Groups",
            },
        ),
        migrations.AddField(
            model_name="ipfabrictransformmap",
            name="group",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="transform_maps",
                to="ipfabric_netbox.ipfabrictransformmapgroup",
            ),
        ),
        migrations.AlterField(
            model_name="ipfabrictransformmap",
            name="name",
            field=models.CharField(max_length=100),
        ),
    ]
