# pymcdc

A Python package to analyze and verify MC/DC (Modified Condition/Decision Coverage) criteria.

V 0.1.1 - add option `--cover` to manually set requeriment as covered/not covered

V 0.1.3 - allows source file and test file to be in different directories

V 0.2 - do some bug fixes.

V 0.2.1 - 'Don't care' conditions are shown in the requirements lists.

## Installation

```bash
pip install pymcdc
```

## 🚀 How to Use

Analyzes the file `foo.py` and displays the condition combinations that must be satisfied for each decision.
```bash
python -m pymcdc foo.py
```


Executes `foo.py` and shows which MC/DC combinations were covered.
```bash
python -m pymcdc --run foo.py
```


Executes `foo.py` with arguments `['bar', '1972']` and shows which MC/DC combinations were covered.
```bash
python -m pymcdc --run --args "bar 1972" foo.py
```


Cumulatively runs `foo.py` and displays the MC/DC combinations covered across multiple runs.
```bash
python -m pymcdc --run --append foo.py
```

Runs `foo.py` using the test cases defined in `test_foo.py`.  
The `--unittest` argument can be used multiple times. The `--append` option is also supported here.
```bash
python -m pymcdc --unittest test_foo.py foo.py
python -m pymcdc --unittest tests/test_foo.py src/foo.py

```

Sets requirement 1 of decision (5,5) as covered and requirement 3 of decision (18,5) as not covered.
```bash
python -m pymcdc --cover +5 5 1 -18 5 3 foo.py
```


### 🔍 Example

```bash
python3 -m pymcdc isleap.py
```

```
Line number: (5, 5)
Decicion: a < 1 or a > 9999
Combinations to be covered: 
    | Result.   a < 1    a > 9999   Cover. 
-------------------------------------------
  1 |  False    False     False     False  
  2 |   True    True       ----     False  
  3 |   True    False      True     False  


Covered 0 out of 3 requirements in 1 decisions (0%)
	      
Run time: 0.00052 
```


```bash
python3 -m pymcdc --run isleap.py
```

```
Line number: (5, 5)
Decicion: a < 1 or a > 9999
Combinations to be covered: 
    | Result.   a < 1    a > 9999   Cover. 
-------------------------------------------
  1 |  False    False     False      True  
  2 |   True    True       ----     False  
  3 |   True    False      True      True  


Covered 2 out of 3 requirements in 1 decisions (66%)
```

```bash
python3 -m pymcdc --unittest test_isleap.py isleap.py
```

```
.
----------------------------------------------------------------------
Ran 1 test in 0.000s

OK

Line number: (5, 5)
Decicion: a < 1 or a > 9999
Combinations to be covered: 
    | Result.   a < 1    a > 9999   Cover. 
-------------------------------------------
  1 |  False    False     False     False  
  2 |   True    True       ----     False  
  3 |   True    False      True      True  


Covered 1 out of 3 requirements in 1 decisions (33%)
```

You can also use multiple `--path <folder path>` to include this folder in the `sys.path` variable for the interpreter. In this way, imports will also be searched in these folders.

The symbol '----' is used to indicate that the value for that part of the requirement does not matter in the verification. This is due to the language's decision evaluation strategy (short-circuiting).


## 📝 Notes

1. The number of MC/DC requirements for a decision with `n` conditions is not always `n+1`. It can be slightly larger due to limitations in the computation algorithm.
2. For decisions with more than 15 conditions, the analysis may take a few minutes. This is only done once when using the `--append` option.

## 👤 Author

**Marcio Delamaro**

## 📄 License

MIT

## 🤝 Contributions

Feel free to open issues or submit pull requests!
