# tartex

[![PyPI - Version](https://img.shields.io/pypi/v/tartex.svg)](https://pypi.org/project/tartex)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/tartex.svg)](https://pypi.org/project/tartex)
[![Hatch project](https://img.shields.io/badge/%F0%9F%A5%9A-Hatch-4051b5.svg)](https://github.com/pypa/hatch)

> 🧵 Minimal, reproducible tarballs for your LaTeX projects.

TarTeX is a command-line utility to generate a tarball containing **all and
only** the source files needed to (re)compile your LaTeX project elsewhere.

It aims to produce [arXiv](https://arxiv.org) and journal-ready bundles with zero clutter.

**Table of Contents**

- [Features](#features)
- [Installation](#installation)
- [Usage](#usage)
- [Typical Workflows](#typical-workflows)
- [License](#license)
- [Similar utilities](#similar-utilities)

## Features

- 📦 Produces compact, reproducible tarballs with a minimal list of files
- ✨ Compatible with [arXiv](https://arxiv.org) and most journal submission rules
- 💨 Fast: caches list of dependencies and avoids re-compilation unless necessary or forced
- 📸 Git integration: snapshot files into tarball directly from Git revision (`--git-rev`)
- 🔍 Auto-detects re-compilation processing mode (pdf/ps) from project
- 🔏 Leaves your LaTeX project directory unchanged
- 🕵️ Optional check to ensure final tarball contains all necessary files
- 🖇️ Supports shell completions for bash, zsh, and fish

## Installation

> __Note__: If re-compilation of sources is required (cache file not generated
> or accessible), or is explicitly requested (`-F`/`--force-recompile`),
> you must have `latexmk` and `pdflatex`, as well as a full LaTeX env installed
> to allow compilation of your LaTeX project. TarTeX does not include any
> system-wide files, such as standard TeX style files, classes, etc. in the tar
> file. This is also required for the check options (`--check`/`--only-check`).

### Using pipx

This is the easy way to install tagged releases.

```console
pipx install tartex
```

### From GitHub sources:

Compile using [hatch](https://hatch.pypa.io/latest/) to generate a wheel,
which may be then installed using `pipx` as follows:

```console
git clone https://github.com/badshah400/tartex.git
cd tartex
hatch build
pipx install ./dist/*.whl
```

## Usage

Supported OS: Potentially cross-platform, but tested _only_ on Linux for now.

```console
usage: tartex [OPTIONS] FILENAME

Build a tarball including all source files needed to compile your LaTeX project
(version 0.10.3).

positional arguments:
  FILENAME                 input file name [.fls|.tex] (with/without extension)

common options:
  -h, --help               show this help message and exit
  -V, --version            print tartex version and exit
  -c, --check              Check if tarball has all files needed for compiling
  -C, --only-check         Only check and print detailed report; no tarball
  -g, --git-rev=[REV]      add git tree files at revision REV (default: HEAD)
  -l, --list, --dry-run    print list of files to include and quit
  -o, --output=NAME[.EXT]  output tar filename; 'EXT' sets re-compression mode,
                           if one of 'bz2', 'gz' (default), or 'xz'
  --overwrite              overwrite output tarball if necessary
  -p, --packages           add used (La)TeX package names as json file
  -s, --summary            print a summary at the end
  -v, --verbose            increase log verbosity (-v, -vv, etc.)

options for additional file inclusion/exclusion in tar:
  -a, --add="PATTERNs"     include additional files matching glob PATTERN;
                           separate multiple PATTERNs using commas
  -b, --bib                find and add bib file to tarball
  --with-pdf               add existing/generated final output PDF
  -x, --excl="PATTERNs"    exclude file names matching PATTERNS

options for latexmk processing (ignored for 'git-rev'):
  -F, --force-recompile    force (La)TeX re-compile; cache use/update disabled
  --latexmk-tex=TEXMODE    force latexmk processing mode; TEXMODE is one of:
                           dvi, lualatex, luatex, pdf, pdflua, ps, xdv, xelatex

options for tar re-compression (mutually conflicting); over-rides .EXT in '-o':
  -j, --bzip2              bzip2 (.bz2) re-compression
  -J, --xz                 lzma (.xz) re-compression
  -z, --gzip               gzip (.gz) re-compression

options for shell TAB completion:
  --completion             print shell completion guides for tartex
  --bash-completions       install bash completions for tartex
  --fish-completions       install fish completions for tartex
  --zsh-completions        install zsh completions for tartex
```

> __Note__: If the main input file specified on the cmdline has an extension
> '.fls', previously generated by, say `latex -record` or `latexmk`, then
> `tartex` will directly use that to determine which input files to include in
> the tarball.  Otherwise, `tartex` will recompile your project using `latexmk`
> in a temporary dir and use the `.fls` file generated there to determine
> necessary dependencies.  To be precise, recompilation will invoke:
>
> ```console
> latexmk -f -<texmode> -cd -outdir=<tmpdir> -interaction=nonstopmode filename
> ```
>
> `texmode` is one of `pdf` or `ps` by default, as detemined from the contents of
> the source dir. It may be overridden by the `--latexmk-tex` option.

### Using with `--git-rev`

When you specify a Git revision (via `--git-rev`), tartex _only_ includes files
that are tracked by Git at _that revision_. This means:

- Files ignored by `.gitignore` (e.g. `*.aux`, `*.log`, build artifacts, temp files)
  are automatically excluded, since they are not tracked by Git.
- No re-compilation of TeX sources (unless using one of the `check` options).
- No checking or updating of cache file, otherwise used to track input file changes.
- No need to maintain a separate exclude list.
- Output tarball reflects the exact state of the project at the chosen revision,
  ensuring reproducibility.
- Unless the output tar filename is explicitly specified by the user (via
  `-o`/`--output`), a git short-ref or tag-id will be appended to it. For example,
  `main-git.a97023f.tar.gz` corresponding to a git rev short-ref of `a97023f`. If
  the specified revision points to a tag, the tarfile is named `main-<TAG>.tar.gz`. 

> __Note__: When running without `--git-rev`, tartex applies its own LaTeX-aware
> exclusion rules (e.g. skipping `.aux`, `.log`, `.fdb_latexmk`), to avoid including
> transient build files in your archive.

## Typical workflows

### Current Draft vs. Git Revision

TarTeX can be used in two different workflows, based on how you manage your
LaTeX project. By default, TarTeX archives your project at the **current
draft** level as it appears in the source dir.  This is useful when your files
are not version controlled, or you simply want to tar (and send?) your source
files at their current — potentially uncommitted — git state.

If, instead, your LaTeX project is version controlled using Git, and have a
clean working tree, you can generate a tarball of files in your git tree as
they would have appeared at a specific revision. In this case, you can target a
**Git revision** by specifying `--git-rev=[REV]` as an option to TarTeX. `REV`
defaults to `HEAD` if left unspecified. This will generate a tarball including
all source files tracked by git (`git ls-tree -r`) and append a meaningful tag,
indicative of the revision, to the final tar filename. This is useful, for
instance, when you are close to a version for submission and tagging your git
repository meaningfully; using TarTeX will produce tarballs with names like
`foo-v0.9.tar.gz` and `bar-v1.0.tar.gz` for projects at git tags `v0.9` and
`v1.0` respectively. Within the same project, this is also useful to tar
two different snapshots to send to your collaborators, for instance, to extract
and run [`latexdiff`](https://ctan.org/pkg/latexdiff) on them.

The table below highlights the key differences:

| Feature               | Current Draft (default)               | Git Revision (`--git-rev`)            |
|-----------------------|---------------------------------------|---------------------------------------|
| **Source of files**   | Your working directory                | A specific Git commit, tag, or branch |
| **Uncommitted changes** | **Included**                        | **Ignored**                           |
| **Reproducibility**   | Depends on current state              | Guaranteed (historical snapshot)      |
| **Typical use cases** | Submitting latest draft, sharing with collaborators | Packaging for journal submission, archiving published versions |
| **Command example**   | `tartex main.tex` → `main.tar.gz`     | `tartex main.tex --git-rev v1.2` → `main-v1.2.tar.gz` |


## License

`tartex` is distributed under the terms of the [MIT](https://spdx.org/licenses/MIT.html) license.

## Similar utilities

* [bundledoc](https://ctan.org/tex-archive/support/bundledoc) is a
  post-processor for the `snapshot` package that bundles together all the
  classes, packages and files needed to build a given LaTeX document.

## Acknowledgment and AI usage disclosure

Some features, like the `--git-rev` option — but **no actual code itself** —
were motivated by discussions with [Gemini AI](https://gemini.google.com).
