# Copyright 2023-2025 Geoffrey R. Scheller
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""
Pythonic FP namespace projects
==============================

Empty module pythonic_fp.name_claim to claim the pythonic-fp name for
theses PyPI pythonic-fp namespace projects:

+----------------+---------------------------+---------------------------+
| Name           | PyPI Project              | Python Module             |
+================+===========================+===========================+
| Booleans       | pythonic-fp-booleans      | pythonic_fp.booleans      |
+----------------+---------------------------+---------------------------+
| Circular Array | pythonic-fp-circulararray | pythonic_fp.circulararray |
+----------------+---------------------------+---------------------------+
| Containers     | pythonic-fp-containers    | pythonic_fp.containers    |
+----------------+---------------------------+---------------------------+
| FP Tools       | pythonic-fp-fptools       | pythonic_fp.fptools       |
+----------------+---------------------------+---------------------------+
| Gadgets        | pythonic-fp-gadgets       | pythonic_fp.gadgets       |
+----------------+---------------------------+---------------------------+
| Iterables      | pythonic-fp-iterables     | pythonic_fp.iterables     |
+----------------+---------------------------+---------------------------+
| Sentinels      | pythonic-fp-sentinels     | pythonic_fp.sentinels     |
+----------------+---------------------------+---------------------------+
| Splitends      | pythonic-fp-splitends     | pythonic_fp.splitends     |
+----------------+---------------------------+---------------------------+

"""

__author__ = 'Geoffrey R. Scheller'
__copyright__ = 'Copyright (c) 2023-2025 Geoffrey R. Scheller'
__license__ = 'Apache License 2.0'
