# Generated by Django 5.2.7 on 2025-11-13 19:04

import django.db.models.deletion
import mojo.models.rest
import uuid
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('account', '0023_rename_account_geo_is_mobi_8a7c2e_idx_account_geo_is_mobi_06bfa8_idx_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='Passkey',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.TextField(help_text='Base64url encoded AttestedCredentialData payload.')),
                ('credential_id', models.CharField(max_length=255, unique=True)),
                ('rp_id', models.CharField(db_index=True, max_length=255)),
                ('is_enabled', models.BooleanField(db_index=True, default=True)),
                ('sign_count', models.BigIntegerField(default=0)),
                ('transports', models.JSONField(blank=True, default=list)),
                ('friendly_name', models.CharField(blank=True, max_length=255, null=True)),
                ('attestation_format', models.CharField(blank=True, max_length=64, null=True)),
                ('aaguid', models.CharField(blank=True, max_length=36, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('modified', models.DateTimeField(auto_now=True)),
                ('last_used', models.DateTimeField(blank=True, default=None, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='passkeys', to=settings.AUTH_USER_MODEL)),
            ],
            bases=(mojo.models.rest.MojoModel, models.Model),
        ),
        migrations.CreateModel(
            name='PasskeyChallenge',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('purpose', models.CharField(choices=[('register', 'Register'), ('authenticate', 'Authenticate')], max_length=16)),
                ('state', models.JSONField()),
                ('challenge', models.CharField(max_length=255)),
                ('rp_id', models.CharField(max_length=255)),
                ('origin', models.CharField(max_length=255)),
                ('authenticator_options', models.JSONField(blank=True, null=True)),
                ('created', models.DateTimeField(auto_now_add=True)),
                ('expires_at', models.DateTimeField()),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='passkey_challenges', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'indexes': [models.Index(fields=['purpose', 'expires_at'], name='account_pas_purpose_4a1332_idx'), models.Index(fields=['rp_id', 'purpose'], name='account_pas_rp_id_afd100_idx')],
            },
        ),
    ]
