"""
NANP Area Code to State/Region/Province Mapping
Comprehensive mapping of area codes to their geographic locations.

Source: North American Numbering Plan Administrator (NANPA)
Last Updated: January 2025
"""

# Area code to state/region/province mapping
AREA_CODE_MAPPING = {
    # 200s
    201: {'state': 'NJ', 'region': 'North Jersey', 'country': 'US'},
    202: {'state': 'DC', 'region': 'Washington, D.C.', 'country': 'US'},
    203: {'state': 'CT', 'region': 'Southwest Connecticut', 'country': 'US'},
    204: {'state': 'MB', 'region': 'Manitoba', 'country': 'CA'},
    205: {'state': 'AL', 'region': 'Central/West Alabama', 'country': 'US'},
    206: {'state': 'WA', 'region': 'Seattle', 'country': 'US'},
    207: {'state': 'ME', 'region': 'Maine', 'country': 'US'},
    208: {'state': 'ID', 'region': 'Idaho', 'country': 'US'},
    209: {'state': 'CA', 'region': 'Central California', 'country': 'US'},
    210: {'state': 'TX', 'region': 'San Antonio', 'country': 'US'},
    212: {'state': 'NY', 'region': 'Manhattan', 'country': 'US'},
    213: {'state': 'CA', 'region': 'Los Angeles', 'country': 'US'},
    214: {'state': 'TX', 'region': 'Dallas', 'country': 'US'},
    215: {'state': 'PA', 'region': 'Philadelphia', 'country': 'US'},
    216: {'state': 'OH', 'region': 'Cleveland', 'country': 'US'},
    217: {'state': 'IL', 'region': 'Central Illinois', 'country': 'US'},
    218: {'state': 'MN', 'region': 'Northern Minnesota', 'country': 'US'},
    219: {'state': 'IN', 'region': 'Northwest Indiana', 'country': 'US'},
    220: {'state': 'OH', 'region': 'Central/Southeast Ohio', 'country': 'US'},
    223: {'state': 'PA', 'region': 'South-Central Pennsylvania', 'country': 'US'},
    224: {'state': 'IL', 'region': 'Chicago suburbs', 'country': 'US'},
    225: {'state': 'LA', 'region': 'Baton Rouge', 'country': 'US'},
    226: {'state': 'ON', 'region': 'Southwest Ontario', 'country': 'CA'},
    227: {'state': 'MD', 'region': 'Western Maryland', 'country': 'US'},
    228: {'state': 'MS', 'region': 'Gulf Coast Mississippi', 'country': 'US'},
    229: {'state': 'GA', 'region': 'Southwest Georgia', 'country': 'US'},
    231: {'state': 'MI', 'region': 'Northwest Michigan', 'country': 'US'},
    234: {'state': 'OH', 'region': 'Northeast Ohio', 'country': 'US'},
    235: {'state': 'MO', 'region': 'Eastern Missouri', 'country': 'US'},
    236: {'state': 'BC', 'region': 'British Columbia', 'country': 'CA'},
    239: {'state': 'FL', 'region': 'Southwest Florida', 'country': 'US'},
    240: {'state': 'MD', 'region': 'Western Maryland', 'country': 'US'},
    242: {'state': 'BS', 'region': 'Bahamas', 'country': 'BS'},
    246: {'state': 'BB', 'region': 'Barbados', 'country': 'BB'},
    248: {'state': 'MI', 'region': 'Oakland County', 'country': 'US'},
    249: {'state': 'ON', 'region': 'Northeast Ontario', 'country': 'CA'},
    250: {'state': 'BC', 'region': 'British Columbia', 'country': 'CA'},
    251: {'state': 'AL', 'region': 'Southwest Alabama', 'country': 'US'},
    252: {'state': 'NC', 'region': 'Eastern North Carolina', 'country': 'US'},
    253: {'state': 'WA', 'region': 'Tacoma', 'country': 'US'},
    254: {'state': 'TX', 'region': 'Waco', 'country': 'US'},
    256: {'state': 'AL', 'region': 'North/East Alabama', 'country': 'US'},
    257: {'state': 'BC', 'region': 'British Columbia', 'country': 'CA'},
    260: {'state': 'IN', 'region': 'Northeast Indiana', 'country': 'US'},
    262: {'state': 'WI', 'region': 'Southeast Wisconsin', 'country': 'US'},
    263: {'state': 'QC', 'region': 'Montreal metro', 'country': 'CA'},
    264: {'state': 'AI', 'region': 'Anguilla', 'country': 'AI'},
    267: {'state': 'PA', 'region': 'Philadelphia', 'country': 'US'},
    268: {'state': 'AG', 'region': 'Antigua and Barbuda', 'country': 'AG'},
    269: {'state': 'MI', 'region': 'Southwest Michigan', 'country': 'US'},
    270: {'state': 'KY', 'region': 'Western Kentucky', 'country': 'US'},
    272: {'state': 'PA', 'region': 'Northeast Pennsylvania', 'country': 'US'},
    274: {'state': 'WI', 'region': 'Eastern Wisconsin', 'country': 'US'},
    276: {'state': 'VA', 'region': 'Southwest Virginia', 'country': 'US'},
    279: {'state': 'CA', 'region': 'Sacramento', 'country': 'US'},
    281: {'state': 'TX', 'region': 'Houston', 'country': 'US'},
    283: {'state': 'OH', 'region': 'Cincinnati', 'country': 'US'},
    284: {'state': 'VG', 'region': 'British Virgin Islands', 'country': 'VG'},
    289: {'state': 'ON', 'region': 'Golden Horseshoe', 'country': 'CA'},

    # 300s
    301: {'state': 'MD', 'region': 'Western Maryland', 'country': 'US'},
    302: {'state': 'DE', 'region': 'Delaware', 'country': 'US'},
    303: {'state': 'CO', 'region': 'Denver', 'country': 'US'},
    304: {'state': 'WV', 'region': 'West Virginia', 'country': 'US'},
    305: {'state': 'FL', 'region': 'Miami', 'country': 'US'},
    306: {'state': 'SK', 'region': 'Saskatchewan', 'country': 'CA'},
    307: {'state': 'WY', 'region': 'Wyoming', 'country': 'US'},
    308: {'state': 'NE', 'region': 'Western Nebraska', 'country': 'US'},
    309: {'state': 'IL', 'region': 'West-Central Illinois', 'country': 'US'},
    310: {'state': 'CA', 'region': 'West Los Angeles', 'country': 'US'},
    312: {'state': 'IL', 'region': 'Downtown Chicago', 'country': 'US'},
    313: {'state': 'MI', 'region': 'Detroit', 'country': 'US'},
    314: {'state': 'MO', 'region': 'St. Louis', 'country': 'US'},
    315: {'state': 'NY', 'region': 'Syracuse', 'country': 'US'},
    316: {'state': 'KS', 'region': 'Wichita', 'country': 'US'},
    317: {'state': 'IN', 'region': 'Indianapolis', 'country': 'US'},
    318: {'state': 'LA', 'region': 'Northern Louisiana', 'country': 'US'},
    319: {'state': 'IA', 'region': 'Eastern Iowa', 'country': 'US'},
    320: {'state': 'MN', 'region': 'Central Minnesota', 'country': 'US'},
    321: {'state': 'FL', 'region': 'Orlando', 'country': 'US'},
    323: {'state': 'CA', 'region': 'Los Angeles', 'country': 'US'},
    324: {'state': 'FL', 'region': 'Jacksonville', 'country': 'US'},
    325: {'state': 'TX', 'region': 'Abilene', 'country': 'US'},
    326: {'state': 'OH', 'region': 'Dayton', 'country': 'US'},
    327: {'state': 'AR', 'region': 'Central/South Arkansas', 'country': 'US'},
    329: {'state': 'NY', 'region': 'Hudson Valley', 'country': 'US'},
    330: {'state': 'OH', 'region': 'Akron/Youngstown', 'country': 'US'},
    331: {'state': 'IL', 'region': 'Chicago suburbs', 'country': 'US'},
    332: {'state': 'NY', 'region': 'Manhattan', 'country': 'US'},
    334: {'state': 'AL', 'region': 'Southeast Alabama', 'country': 'US'},
    336: {'state': 'NC', 'region': 'Piedmont Triad', 'country': 'US'},
    337: {'state': 'LA', 'region': 'Southwest Louisiana', 'country': 'US'},
    339: {'state': 'MA', 'region': 'East-Central Massachusetts', 'country': 'US'},
    340: {'state': 'VI', 'region': 'U.S. Virgin Islands', 'country': 'VI'},
    341: {'state': 'CA', 'region': 'East Bay', 'country': 'US'},
    343: {'state': 'ON', 'region': 'Ottawa', 'country': 'CA'},
    345: {'state': 'KY', 'region': 'Cayman Islands', 'country': 'KY'},
    346: {'state': 'TX', 'region': 'Houston', 'country': 'US'},
    347: {'state': 'NY', 'region': 'NYC (Bronx, Brooklyn, Queens, Staten Island)', 'country': 'US'},
    350: {'state': 'CA', 'region': 'Central California', 'country': 'US'},
    351: {'state': 'MA', 'region': 'Northeast Massachusetts', 'country': 'US'},
    352: {'state': 'FL', 'region': 'Central Florida', 'country': 'US'},
    353: {'state': 'WI', 'region': 'Southwest Wisconsin', 'country': 'US'},
    354: {'state': 'QC', 'region': 'Montreal metro', 'country': 'CA'},
    357: {'state': 'CA', 'region': 'Fresno', 'country': 'US'},
    360: {'state': 'WA', 'region': 'Western Washington', 'country': 'US'},
    361: {'state': 'TX', 'region': 'Corpus Christi', 'country': 'US'},
    363: {'state': 'NY', 'region': 'Nassau County', 'country': 'US'},
    364: {'state': 'KY', 'region': 'Western Kentucky', 'country': 'US'},
    365: {'state': 'ON', 'region': 'Golden Horseshoe', 'country': 'CA'},
    367: {'state': 'QC', 'region': 'Quebec City', 'country': 'CA'},
    368: {'state': 'AB', 'region': 'Alberta', 'country': 'CA'},
    369: {'state': 'CA', 'region': 'Northwest California', 'country': 'US'},

    # 400s
    401: {'state': 'RI', 'region': 'Rhode Island', 'country': 'US'},
    402: {'state': 'NE', 'region': 'Eastern Nebraska', 'country': 'US'},
    403: {'state': 'AB', 'region': 'Southern Alberta', 'country': 'CA'},
    404: {'state': 'GA', 'region': 'Atlanta', 'country': 'US'},
    405: {'state': 'OK', 'region': 'Central Oklahoma', 'country': 'US'},
    406: {'state': 'MT', 'region': 'Montana', 'country': 'US'},
    407: {'state': 'FL', 'region': 'Orlando', 'country': 'US'},
    408: {'state': 'CA', 'region': 'San Jose', 'country': 'US'},
    409: {'state': 'TX', 'region': 'Southeast Texas', 'country': 'US'},
    410: {'state': 'MD', 'region': 'Baltimore', 'country': 'US'},
    412: {'state': 'PA', 'region': 'Pittsburgh', 'country': 'US'},
    413: {'state': 'MA', 'region': 'Western Massachusetts', 'country': 'US'},
    414: {'state': 'WI', 'region': 'Milwaukee', 'country': 'US'},
    415: {'state': 'CA', 'region': 'San Francisco', 'country': 'US'},
    416: {'state': 'ON', 'region': 'Toronto', 'country': 'CA'},
    417: {'state': 'MO', 'region': 'Southwest Missouri', 'country': 'US'},
    418: {'state': 'QC', 'region': 'Quebec City', 'country': 'CA'},
    419: {'state': 'OH', 'region': 'Toledo', 'country': 'US'},
    423: {'state': 'TN', 'region': 'East Tennessee', 'country': 'US'},
    424: {'state': 'CA', 'region': 'West Los Angeles', 'country': 'US'},
    425: {'state': 'WA', 'region': 'Seattle suburbs', 'country': 'US'},
    428: {'state': 'NB', 'region': 'New Brunswick', 'country': 'CA'},
    430: {'state': 'TX', 'region': 'Northeast Texas', 'country': 'US'},
    431: {'state': 'MB', 'region': 'Manitoba', 'country': 'CA'},
    432: {'state': 'TX', 'region': 'West Texas', 'country': 'US'},
    434: {'state': 'VA', 'region': 'South-Central Virginia', 'country': 'US'},
    435: {'state': 'UT', 'region': 'Utah (outside Salt Lake City)', 'country': 'US'},
    436: {'state': 'OH', 'region': 'Cleveland', 'country': 'US'},
    437: {'state': 'ON', 'region': 'Toronto', 'country': 'CA'},
    438: {'state': 'QC', 'region': 'Montreal', 'country': 'CA'},
    440: {'state': 'OH', 'region': 'Cleveland suburbs', 'country': 'US'},
    441: {'state': 'BM', 'region': 'Bermuda', 'country': 'BM'},
    442: {'state': 'CA', 'region': 'Southeast California', 'country': 'US'},
    443: {'state': 'MD', 'region': 'Baltimore', 'country': 'US'},
    445: {'state': 'PA', 'region': 'Philadelphia', 'country': 'US'},
    447: {'state': 'IL', 'region': 'Central Illinois', 'country': 'US'},
    448: {'state': 'FL', 'region': 'Florida Panhandle', 'country': 'US'},
    450: {'state': 'QC', 'region': 'South of Montreal', 'country': 'CA'},
    457: {'state': 'LA', 'region': 'Northern Louisiana', 'country': 'US'},
    458: {'state': 'OR', 'region': 'Oregon (non-Portland)', 'country': 'US'},
    463: {'state': 'IN', 'region': 'Indianapolis', 'country': 'US'},
    464: {'state': 'IL', 'region': 'Chicago suburbs', 'country': 'US'},
    468: {'state': 'QC', 'region': 'Western Quebec', 'country': 'CA'},
    469: {'state': 'TX', 'region': 'Dallas', 'country': 'US'},
    470: {'state': 'GA', 'region': 'Metro Atlanta', 'country': 'US'},
    472: {'state': 'NC', 'region': 'Southeast North Carolina', 'country': 'US'},
    473: {'state': 'GD', 'region': 'Grenada', 'country': 'GD'},
    474: {'state': 'SK', 'region': 'Saskatchewan', 'country': 'CA'},
    475: {'state': 'CT', 'region': 'Southwest Connecticut', 'country': 'US'},
    478: {'state': 'GA', 'region': 'Central Georgia', 'country': 'US'},
    479: {'state': 'AR', 'region': 'Northwest Arkansas', 'country': 'US'},
    480: {'state': 'AZ', 'region': 'Phoenix metro', 'country': 'US'},
    484: {'state': 'PA', 'region': 'Southeast Pennsylvania', 'country': 'US'},

    # 500s
    501: {'state': 'AR', 'region': 'Central Arkansas', 'country': 'US'},
    502: {'state': 'KY', 'region': 'Louisville', 'country': 'US'},
    503: {'state': 'OR', 'region': 'Portland', 'country': 'US'},
    504: {'state': 'LA', 'region': 'New Orleans', 'country': 'US'},
    505: {'state': 'NM', 'region': 'New Mexico', 'country': 'US'},
    506: {'state': 'NB', 'region': 'New Brunswick', 'country': 'CA'},
    507: {'state': 'MN', 'region': 'Southern Minnesota', 'country': 'US'},
    508: {'state': 'MA', 'region': 'Southeast Massachusetts', 'country': 'US'},
    509: {'state': 'WA', 'region': 'Eastern Washington', 'country': 'US'},
    510: {'state': 'CA', 'region': 'East Bay', 'country': 'US'},
    512: {'state': 'TX', 'region': 'Austin', 'country': 'US'},
    513: {'state': 'OH', 'region': 'Cincinnati', 'country': 'US'},
    514: {'state': 'QC', 'region': 'Montreal', 'country': 'CA'},
    515: {'state': 'IA', 'region': 'Central Iowa', 'country': 'US'},
    516: {'state': 'NY', 'region': 'Nassau County', 'country': 'US'},
    517: {'state': 'MI', 'region': 'South-Central Michigan', 'country': 'US'},
    518: {'state': 'NY', 'region': 'Northeast New York', 'country': 'US'},
    519: {'state': 'ON', 'region': 'Southwest Ontario', 'country': 'CA'},

    # 600s
    601: {'state': 'MS', 'region': 'Central Mississippi', 'country': 'US'},
    602: {'state': 'AZ', 'region': 'Phoenix', 'country': 'US'},
    603: {'state': 'NH', 'region': 'New Hampshire', 'country': 'US'},
    604: {'state': 'BC', 'region': 'Lower Mainland', 'country': 'CA'},
    605: {'state': 'SD', 'region': 'South Dakota', 'country': 'US'},
    606: {'state': 'KY', 'region': 'Eastern Kentucky', 'country': 'US'},
    607: {'state': 'NY', 'region': 'Southern New York', 'country': 'US'},
    608: {'state': 'WI', 'region': 'Southwest Wisconsin', 'country': 'US'},
    609: {'state': 'NJ', 'region': 'South Jersey', 'country': 'US'},
    610: {'state': 'PA', 'region': 'Southeast Pennsylvania', 'country': 'US'},
    612: {'state': 'MN', 'region': 'Minneapolis', 'country': 'US'},
    613: {'state': 'ON', 'region': 'Ottawa', 'country': 'CA'},
    614: {'state': 'OH', 'region': 'Columbus', 'country': 'US'},
    615: {'state': 'TN', 'region': 'Nashville', 'country': 'US'},
    616: {'state': 'MI', 'region': 'Grand Rapids', 'country': 'US'},
    617: {'state': 'MA', 'region': 'Boston', 'country': 'US'},
    618: {'state': 'IL', 'region': 'Southern Illinois', 'country': 'US'},
    619: {'state': 'CA', 'region': 'San Diego', 'country': 'US'},
    620: {'state': 'KS', 'region': 'Southern Kansas', 'country': 'US'},
    621: {'state': 'NC', 'region': 'North Carolina', 'country': 'US'},
    623: {'state': 'AZ', 'region': 'Phoenix suburbs', 'country': 'US'},
    626: {'state': 'CA', 'region': 'San Gabriel Valley', 'country': 'US'},
    628: {'state': 'CA', 'region': 'San Francisco', 'country': 'US'},
    629: {'state': 'TN', 'region': 'Nashville', 'country': 'US'},
    630: {'state': 'IL', 'region': 'Chicago western suburbs', 'country': 'US'},
    631: {'state': 'NY', 'region': 'Suffolk County', 'country': 'US'},
    636: {'state': 'MO', 'region': 'St. Louis suburbs', 'country': 'US'},
    639: {'state': 'SK', 'region': 'Saskatchewan', 'country': 'CA'},
    641: {'state': 'IA', 'region': 'Central Iowa', 'country': 'US'},
    645: {'state': 'NY', 'region': 'Manhattan', 'country': 'US'},
    647: {'state': 'ON', 'region': 'Toronto', 'country': 'CA'},
    650: {'state': 'CA', 'region': 'San Mateo County', 'country': 'US'},
    659: {'state': 'AL', 'region': 'North Alabama', 'country': 'US'},
    661: {'state': 'CA', 'region': 'Bakersfield', 'country': 'US'},
    662: {'state': 'MS', 'region': 'North Mississippi', 'country': 'US'},
    667: {'state': 'MD', 'region': 'Baltimore', 'country': 'US'},
    669: {'state': 'CA', 'region': 'San Jose', 'country': 'US'},
    670: {'state': 'MP', 'region': 'Northern Mariana Islands', 'country': 'MP'},
    671: {'state': 'GU', 'region': 'Guam', 'country': 'GU'},
    672: {'state': 'BC', 'region': 'British Columbia', 'country': 'CA'},
    673: {'state': 'BC', 'region': 'British Columbia', 'country': 'CA'},
    678: {'state': 'GA', 'region': 'Metro Atlanta', 'country': 'US'},
    679: {'state': 'MI', 'region': 'Detroit', 'country': 'US'},
    680: {'state': 'NY', 'region': 'Syracuse', 'country': 'US'},
    681: {'state': 'WV', 'region': 'West Virginia', 'country': 'US'},
    682: {'state': 'TX', 'region': 'Fort Worth', 'country': 'US'},
    683: {'state': 'ON', 'region': 'Ottawa', 'country': 'CA'},
    684: {'state': 'AS', 'region': 'American Samoa', 'country': 'AS'},
    689: {'state': 'FL', 'region': 'Central Florida', 'country': 'US'},

    # 700s
    701: {'state': 'ND', 'region': 'North Dakota', 'country': 'US'},
    702: {'state': 'NV', 'region': 'Las Vegas', 'country': 'US'},
    703: {'state': 'VA', 'region': 'Northern Virginia', 'country': 'US'},
    704: {'state': 'NC', 'region': 'Charlotte', 'country': 'US'},
    705: {'state': 'ON', 'region': 'Northern Ontario', 'country': 'CA'},
    706: {'state': 'GA', 'region': 'North Georgia', 'country': 'US'},
    707: {'state': 'CA', 'region': 'Northwest California', 'country': 'US'},
    708: {'state': 'IL', 'region': 'Chicago suburbs', 'country': 'US'},
    709: {'state': 'NL', 'region': 'Newfoundland and Labrador', 'country': 'CA'},
    712: {'state': 'IA', 'region': 'Western Iowa', 'country': 'US'},
    713: {'state': 'TX', 'region': 'Houston', 'country': 'US'},
    714: {'state': 'CA', 'region': 'Orange County', 'country': 'US'},
    715: {'state': 'WI', 'region': 'Northern Wisconsin', 'country': 'US'},
    716: {'state': 'NY', 'region': 'Buffalo', 'country': 'US'},
    717: {'state': 'PA', 'region': 'South-Central Pennsylvania', 'country': 'US'},
    718: {'state': 'NY', 'region': 'NYC (Bronx, Brooklyn, Queens, Staten Island)', 'country': 'US'},
    719: {'state': 'CO', 'region': 'Colorado Springs', 'country': 'US'},
    720: {'state': 'CO', 'region': 'Denver', 'country': 'US'},
    721: {'state': 'SX', 'region': 'Sint Maarten', 'country': 'SX'},
    724: {'state': 'PA', 'region': 'Southwest Pennsylvania', 'country': 'US'},
    725: {'state': 'NV', 'region': 'Las Vegas', 'country': 'US'},
    726: {'state': 'TX', 'region': 'San Antonio', 'country': 'US'},
    727: {'state': 'FL', 'region': 'St. Petersburg', 'country': 'US'},
    728: {'state': 'FL', 'region': 'Central Florida', 'country': 'US'},
    729: {'state': 'MS', 'region': 'North Mississippi', 'country': 'US'},
    731: {'state': 'TN', 'region': 'West Tennessee', 'country': 'US'},
    732: {'state': 'NJ', 'region': 'Central New Jersey', 'country': 'US'},
    734: {'state': 'MI', 'region': 'Southeast Michigan', 'country': 'US'},
    737: {'state': 'TX', 'region': 'Austin', 'country': 'US'},
    738: {'state': 'AB', 'region': 'Alberta', 'country': 'CA'},
    740: {'state': 'OH', 'region': 'Southeast Ohio', 'country': 'US'},
    742: {'state': 'ON', 'region': 'Southwest Ontario', 'country': 'CA'},
    743: {'state': 'NC', 'region': 'Piedmont Triad', 'country': 'US'},
    747: {'state': 'CA', 'region': 'San Fernando Valley', 'country': 'US'},
    751: {'state': 'RI', 'region': 'Rhode Island', 'country': 'US'},
    752: {'state': 'CA', 'region': 'Central California', 'country': 'US'},
    753: {'state': 'ON', 'region': 'Ottawa', 'country': 'CA'},
    754: {'state': 'FL', 'region': 'Broward County', 'country': 'US'},
    757: {'state': 'VA', 'region': 'Tidewater Virginia', 'country': 'US'},
    760: {'state': 'CA', 'region': 'North San Diego County', 'country': 'US'},
    762: {'state': 'GA', 'region': 'North Georgia', 'country': 'US'},
    763: {'state': 'MN', 'region': 'Minneapolis suburbs', 'country': 'US'},
    765: {'state': 'IN', 'region': 'Central Indiana', 'country': 'US'},
    770: {'state': 'GA', 'region': 'Atlanta suburbs', 'country': 'US'},
    771: {'state': 'DC', 'region': 'Washington, D.C.', 'country': 'US'},
    772: {'state': 'FL', 'region': 'Treasure Coast', 'country': 'US'},
    773: {'state': 'IL', 'region': 'Chicago', 'country': 'US'},
    774: {'state': 'MA', 'region': 'Southeast Massachusetts', 'country': 'US'},
    775: {'state': 'NV', 'region': 'Northern Nevada', 'country': 'US'},
    778: {'state': 'BC', 'region': 'British Columbia', 'country': 'CA'},
    779: {'state': 'IL', 'region': 'Northern Illinois', 'country': 'US'},
    781: {'state': 'MA', 'region': 'Greater Boston', 'country': 'US'},
    782: {'state': 'NS', 'region': 'Nova Scotia', 'country': 'CA'},
    785: {'state': 'KS', 'region': 'Northern Kansas', 'country': 'US'},
    786: {'state': 'FL', 'region': 'Miami', 'country': 'US'},

    # 800s
    801: {'state': 'UT', 'region': 'Salt Lake City', 'country': 'US'},
    802: {'state': 'VT', 'region': 'Vermont', 'country': 'US'},
    803: {'state': 'SC', 'region': 'Central South Carolina', 'country': 'US'},
    804: {'state': 'VA', 'region': 'Central Virginia', 'country': 'US'},
    805: {'state': 'CA', 'region': 'Central California Coast', 'country': 'US'},
    806: {'state': 'TX', 'region': 'Panhandle Texas', 'country': 'US'},
    807: {'state': 'ON', 'region': 'Northwest Ontario', 'country': 'CA'},
    808: {'state': 'HI', 'region': 'Hawaii', 'country': 'US'},
    810: {'state': 'MI', 'region': 'Southeast Michigan', 'country': 'US'},
    812: {'state': 'IN', 'region': 'Southern Indiana', 'country': 'US'},
    813: {'state': 'FL', 'region': 'Tampa', 'country': 'US'},
    814: {'state': 'PA', 'region': 'Northwest Pennsylvania', 'country': 'US'},
    815: {'state': 'IL', 'region': 'Northern Illinois', 'country': 'US'},
    816: {'state': 'MO', 'region': 'Kansas City', 'country': 'US'},
    817: {'state': 'TX', 'region': 'Fort Worth', 'country': 'US'},
    818: {'state': 'CA', 'region': 'San Fernando Valley', 'country': 'US'},
    819: {'state': 'QC', 'region': 'Western Quebec', 'country': 'CA'},
    825: {'state': 'AB', 'region': 'Alberta', 'country': 'CA'},
    828: {'state': 'NC', 'region': 'Western North Carolina', 'country': 'US'},
    830: {'state': 'TX', 'region': 'Southwest Texas', 'country': 'US'},
    831: {'state': 'CA', 'region': 'Monterey Bay', 'country': 'US'},
    832: {'state': 'TX', 'region': 'Houston', 'country': 'US'},
    835: {'state': 'PA', 'region': 'Southeast Pennsylvania', 'country': 'US'},
    838: {'state': 'NY', 'region': 'Hudson Valley', 'country': 'US'},
    839: {'state': 'SC', 'region': 'Central South Carolina', 'country': 'US'},
    840: {'state': 'CA', 'region': 'Sacramento', 'country': 'US'},
    843: {'state': 'SC', 'region': 'Coastal South Carolina', 'country': 'US'},
    845: {'state': 'NY', 'region': 'Hudson Valley', 'country': 'US'},
    847: {'state': 'IL', 'region': 'Chicago northern suburbs', 'country': 'US'},
    848: {'state': 'NJ', 'region': 'Central New Jersey', 'country': 'US'},
    850: {'state': 'FL', 'region': 'Florida Panhandle', 'country': 'US'},
    854: {'state': 'SC', 'region': 'Coastal South Carolina', 'country': 'US'},
    856: {'state': 'NJ', 'region': 'South Jersey', 'country': 'US'},
    857: {'state': 'MA', 'region': 'Boston', 'country': 'US'},
    858: {'state': 'CA', 'region': 'San Diego', 'country': 'US'},
    859: {'state': 'KY', 'region': 'Lexington', 'country': 'US'},
    860: {'state': 'CT', 'region': 'Connecticut', 'country': 'US'},
    862: {'state': 'NJ', 'region': 'North Jersey', 'country': 'US'},
    863: {'state': 'FL', 'region': 'Central Florida', 'country': 'US'},
    864: {'state': 'SC', 'region': 'Upstate South Carolina', 'country': 'US'},
    865: {'state': 'TN', 'region': 'Knoxville', 'country': 'US'},
    867: {'state': 'YT/NT/NU', 'region': 'Yukon/Northwest Territories/Nunavut', 'country': 'CA'},
    870: {'state': 'AR', 'region': 'Eastern Arkansas', 'country': 'US'},
    872: {'state': 'IL', 'region': 'Downtown Chicago', 'country': 'US'},
    873: {'state': 'QC', 'region': 'Quebec City', 'country': 'CA'},
    878: {'state': 'PA', 'region': 'Pittsburgh', 'country': 'US'},

    # 900s
    901: {'state': 'TN', 'region': 'Memphis', 'country': 'US'},
    902: {'state': 'NS/PE', 'region': 'Nova Scotia/Prince Edward Island', 'country': 'CA'},
    903: {'state': 'TX', 'region': 'Northeast Texas', 'country': 'US'},
    904: {'state': 'FL', 'region': 'Jacksonville', 'country': 'US'},
    905: {'state': 'ON', 'region': 'Golden Horseshoe', 'country': 'CA'},
    906: {'state': 'MI', 'region': 'Upper Peninsula', 'country': 'US'},
    907: {'state': 'AK', 'region': 'Alaska', 'country': 'US'},
    908: {'state': 'NJ', 'region': 'Central New Jersey', 'country': 'US'},
    909: {'state': 'CA', 'region': 'Inland Empire', 'country': 'US'},
    910: {'state': 'NC', 'region': 'Southeast North Carolina', 'country': 'US'},
    912: {'state': 'GA', 'region': 'Southeast Georgia', 'country': 'US'},
    913: {'state': 'KS', 'region': 'Kansas City metro', 'country': 'US'},
    914: {'state': 'NY', 'region': 'Westchester County', 'country': 'US'},
    915: {'state': 'TX', 'region': 'El Paso', 'country': 'US'},
    916: {'state': 'CA', 'region': 'Sacramento', 'country': 'US'},
    917: {'state': 'NY', 'region': 'New York City', 'country': 'US'},
    918: {'state': 'OK', 'region': 'Tulsa', 'country': 'US'},
    919: {'state': 'NC', 'region': 'Research Triangle', 'country': 'US'},
    920: {'state': 'WI', 'region': 'Northeast Wisconsin', 'country': 'US'},
    925: {'state': 'CA', 'region': 'Contra Costa County', 'country': 'US'},
    928: {'state': 'AZ', 'region': 'Northern Arizona', 'country': 'US'},
    929: {'state': 'NY', 'region': 'Queens/Bronx', 'country': 'US'},
    930: {'state': 'IN', 'region': 'Southwest Indiana', 'country': 'US'},
    931: {'state': 'TN', 'region': 'Middle Tennessee', 'country': 'US'},
    934: {'state': 'NY', 'region': 'Nassau/Suffolk Counties', 'country': 'US'},
    936: {'state': 'TX', 'region': 'East Texas', 'country': 'US'},
    937: {'state': 'OH', 'region': 'Southwest Ohio', 'country': 'US'},
    938: {'state': 'AL', 'region': 'North Alabama', 'country': 'US'},
    940: {'state': 'TX', 'region': 'North Texas', 'country': 'US'},
    941: {'state': 'FL', 'region': 'Southwest Florida', 'country': 'US'},
    942: {'state': 'AB', 'region': 'Alberta', 'country': 'CA'},
    945: {'state': 'TX', 'region': 'Dallas metro', 'country': 'US'},
    947: {'state': 'MI', 'region': 'Detroit metro', 'country': 'US'},
    949: {'state': 'CA', 'region': 'Orange County', 'country': 'US'},
    951: {'state': 'CA', 'region': 'Riverside/San Bernardino', 'country': 'US'},
    952: {'state': 'MN', 'region': 'Minneapolis southern suburbs', 'country': 'US'},
    954: {'state': 'FL', 'region': 'Broward County', 'country': 'US'},
    956: {'state': 'TX', 'region': 'South Texas', 'country': 'US'},
    959: {'state': 'CT', 'region': 'Connecticut', 'country': 'US'},
    970: {'state': 'CO', 'region': 'Northern Colorado', 'country': 'US'},
    971: {'state': 'OR', 'region': 'Portland', 'country': 'US'},
    972: {'state': 'TX', 'region': 'Dallas', 'country': 'US'},
    973: {'state': 'NJ', 'region': 'North Jersey', 'country': 'US'},
    978: {'state': 'MA', 'region': 'Northeast Massachusetts', 'country': 'US'},
    979: {'state': 'TX', 'region': 'Bryan/College Station', 'country': 'US'},
    980: {'state': 'NC', 'region': 'Charlotte', 'country': 'US'},
    983: {'state': 'CO', 'region': 'Denver', 'country': 'US'},
    984: {'state': 'NC', 'region': 'Research Triangle', 'country': 'US'},
    985: {'state': 'LA', 'region': 'Southeast Louisiana', 'country': 'US'},
    986: {'state': 'ID', 'region': 'Idaho', 'country': 'US'},
    989: {'state': 'MI', 'region': 'Central Michigan', 'country': 'US'},
}


def get_location_info(area_code):
    """
    Get geographic location information for an area code.

    Args:
        area_code: 3-digit area code (int or str)

    Returns:
        dict or None: {
            'state': str (2-letter state/province code),
            'region': str (descriptive region name),
            'country': str (2-letter country code: US, CA, etc.)
        }
    """
    try:
        code = int(area_code)
        return AREA_CODE_MAPPING.get(code)
    except (ValueError, TypeError):
        return None
