# MD007 - Keep list indentation consistent

## What this rule does

Ensures nested list items are indented with exactly 2 spaces per level for consistent formatting.

## Why this matters

- **Readability**: Consistent indentation makes nested lists easy to scan and understand
- **Professional appearance**: Well-formatted lists look polished and organized
- **Tool compatibility**: Many Markdown tools expect 2-space indentation for proper rendering
- **Team consistency**: Standard indentation prevents formatting conflicts in shared documents

## Examples

### ✅ Correct

```markdown
* Chapter 1
  * Section 1.1
    * Subsection 1.1.1
    * Subsection 1.1.2
  * Section 1.2
* Chapter 2
  * Section 2.1
```

### ❌ Incorrect

<!-- rumdl-disable MD007 -->

```markdown
* Chapter 1
   * Section 1.1 (3 spaces - too many!)
      * Subsection 1.1.1 (6 spaces)
 * Section 1.2 (1 space - too few!)
* Chapter 2
    * Section 2.1 (4 spaces - inconsistent)

```

<!-- rumdl-enable MD007 -->

### 🔧 Fixed

```markdown
* Chapter 1
  * Section 1.1
    * Subsection 1.1.1
  * Section 1.2
* Chapter 2
  * Section 2.1
```

## Configuration

```yaml
MD007:
  indent: 2               # Number of spaces per indentation level (default: 2)
  start_indented: false   # Allow first level lists to start indented (default: false)
  start_indent: 2         # Number of spaces for first level when start_indented is true (default: 2)
```

### Configuration options explained

- `indent`: The number of spaces to use for each level of list nesting
- `start_indented`: When `true`, allows the first level of lists to be indented instead of starting at column 0
- `start_indent`: When `start_indented` is `true`, this specifies how many spaces the first level should be indented

### Example with start_indented: true

```yaml
MD007:
  indent: 2
  start_indented: true
  start_indent: 4
```

With this configuration, the following is valid:

```markdown
Some paragraph text.

    * First level item (4 spaces indent)
      * Second level item (6 spaces total: 4 + 2)
        * Third level item (8 spaces total: 4 + 2 + 2)
    * Another first level item
```

## Automatic fixes

This rule automatically adjusts the indentation of nested list items to use exactly 2 spaces (or your configured value) per nesting level.

## Learn more

- [Lists in Markdown](https://www.markdownguide.org/basic-syntax/#lists-1) - How to create well-formatted lists
- [CommonMark specification](https://spec.commonmark.org/0.31.2/#list-items) - Technical details about list formatting

## Related rules

- [MD004](md004.md) - Use consistent markers for unordered lists
- [MD005](md005.md) - Keep list indentation consistent
- [MD006](md006.md) - Start lists at the beginning of the line
