# MD053 - Remove unused link definitions

## What this rule does

Finds link and image reference definitions that aren't used anywhere in your document and removes them to keep your content clean.

## Why this matters

- **Reduces clutter**: Unused definitions make documents harder to maintain
- **Prevents confusion**: Developers might wonder why certain definitions exist
- **Improves readability**: Less scrolling through unused references at the bottom of files
- **Easier maintenance**: Fewer references to check when updating links

## Examples

### ✅ Correct

```markdown
# My Document

Check out [our website][site] and view the [documentation][docs].

See our ![company logo][logo] for branding guidelines.

[site]: https://example.com
[docs]: https://docs.example.com
[logo]: /images/logo.png
```

### ❌ Incorrect

```markdown
# My Document

Check out [our website](https://example.com) directly.

[site]: https://example.com
[docs]: https://docs.example.com
[unused]: https://old.example.com
[legacy]: https://legacy.example.com
```

### 🔧 Fixed

```markdown
# My Document

Check out [our website](https://example.com) directly.
```

## Configuration

```yaml
MD053:
  ignored_definitions: []  # List of reference names to keep even if unused
```

### Example with ignored definitions

```yaml
MD053:
  ignored_definitions: ["todo", "draft", "template"]
```

This keeps reference definitions with names like "todo", "draft", or "template" even if they're not currently used.

## Automatic fixes

This rule can automatically fix issues by:

- Removing entire lines containing unused reference definitions
- Preserving any definitions listed in `ignored_definitions`
- Cleaning up extra blank lines left behind

## Learn more

- [Markdown Guide: Reference-style Links](https://www.markdownguide.org/basic-syntax/#reference-style-links)
- [CommonMark: Link reference definitions](https://spec.commonmark.org/0.31.2/#link-reference-definitions)

## Related rules

- [MD052 - Fix broken reference links and images](md052.md)
- [MD054 - Use consistent link and image style](md054.md)
- [MD042 - Ensure links have content](md042.md)
