# MD058 - Add blank lines around tables

## What this rule does

Ensures tables have blank lines before and after them for better readability and proper rendering.

## Why this matters

- **Clear visual separation**: Tables stand out better with surrounding space
- **Parser compatibility**: Some Markdown parsers require blank lines to recognize tables
- **Improved readability**: Easier to scan documents and find information
- **Consistent formatting**: Maintains uniform spacing throughout documents

## Examples

### ✅ Correct

```markdown
Here's our team structure:

| Name    | Department | Role      |
| ------- | ---------- | --------- |
| Alice   | Sales      | Manager   |
| Bob     | IT         | Developer |

As you can see, we have a diverse team.
```

### ❌ Incorrect

```markdown
Here's our team structure:
| Name    | Department | Role      |
| ------- | ---------- | --------- |
| Alice   | Sales      | Manager   |
| Bob     | IT         | Developer |
As you can see, we have a diverse team.
```

### 🔧 Fixed

```markdown
Here's our team structure:

| Name    | Department | Role      |
| ------- | ---------- | --------- |
| Alice   | Sales      | Manager   |
| Bob     | IT         | Developer |

As you can see, we have a diverse team.
```

## Configuration

```yaml
MD058:
  minimum_before: 1  # Blank lines before table
  minimum_after: 1   # Blank lines after table
```

### Examples with different settings

```yaml
MD058:
  minimum_before: 2  # Require 2 blank lines before
  minimum_after: 1   # Require 1 blank line after
```

## Automatic fixes

This rule can automatically fix issues by:

- Adding blank lines before tables (unless at document start)
- Adding blank lines after tables (unless at document end)
- Adding the exact number of blank lines specified in configuration

## Learn more

- [Markdown Guide: Tables](https://www.markdownguide.org/extended-syntax/#tables)
- [GitHub Flavored Markdown: Tables](https://github.github.com/gfm/#tables-extension-)

## Related rules

- [MD055 - Keep table formatting consistent](md055.md)
- [MD056 - Keep table column count consistent](md056.md)
