# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IntegrationTagFilterArgs', 'IntegrationTagFilter']

@pulumi.input_type
class IntegrationTagFilterArgs:
    def __init__(__self__, *,
                 account_id: pulumi.Input[_builtins.str],
                 namespace: pulumi.Input[_builtins.str],
                 tag_filter_str: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a IntegrationTagFilter resource.
        :param pulumi.Input[_builtins.str] account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[_builtins.str] namespace: The namespace associated with the tag filter entry. Valid values are `elb`, `application_elb`, `sqs`, `rds`, `custom`, `network_elb`, `lambda`, `step_functions`.
        :param pulumi.Input[_builtins.str] tag_filter_str: The tag filter string.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "tag_filter_str", tag_filter_str)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Your AWS Account ID without dashes.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[_builtins.str]:
        """
        The namespace associated with the tag filter entry. Valid values are `elb`, `application_elb`, `sqs`, `rds`, `custom`, `network_elb`, `lambda`, `step_functions`.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="tagFilterStr")
    def tag_filter_str(self) -> pulumi.Input[_builtins.str]:
        """
        The tag filter string.
        """
        return pulumi.get(self, "tag_filter_str")

    @tag_filter_str.setter
    def tag_filter_str(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "tag_filter_str", value)


@pulumi.input_type
class _IntegrationTagFilterState:
    def __init__(__self__, *,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_filter_str: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IntegrationTagFilter resources.
        :param pulumi.Input[_builtins.str] account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[_builtins.str] namespace: The namespace associated with the tag filter entry. Valid values are `elb`, `application_elb`, `sqs`, `rds`, `custom`, `network_elb`, `lambda`, `step_functions`.
        :param pulumi.Input[_builtins.str] tag_filter_str: The tag filter string.
        """
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if tag_filter_str is not None:
            pulumi.set(__self__, "tag_filter_str", tag_filter_str)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Your AWS Account ID without dashes.
        """
        return pulumi.get(self, "account_id")

    @account_id.setter
    def account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_id", value)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace associated with the tag filter entry. Valid values are `elb`, `application_elb`, `sqs`, `rds`, `custom`, `network_elb`, `lambda`, `step_functions`.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namespace", value)

    @_builtins.property
    @pulumi.getter(name="tagFilterStr")
    def tag_filter_str(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tag filter string.
        """
        return pulumi.get(self, "tag_filter_str")

    @tag_filter_str.setter
    def tag_filter_str(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tag_filter_str", value)


@pulumi.type_token("datadog:aws/integrationTagFilter:IntegrationTagFilter")
class IntegrationTagFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_filter_str: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        !>This resource is deprecated - use the `aws.IntegrationAccount` resource instead.

        Provides a Datadog AWS tag filter resource. This can be used to create and manage Datadog AWS tag filters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a new Datadog - Amazon Web Services integration tag filter
        foo = datadog.aws.IntegrationTagFilter("foo",
            account_id="123456789010",
            namespace="sqs",
            tag_filter_str="key:value")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Amazon Web Services log filter resource can be imported using their account ID and namespace separated with a colon (:).

        ```sh
        $ pulumi import datadog:aws/integrationTagFilter:IntegrationTagFilter foo ${account_id}:${namespace}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[_builtins.str] namespace: The namespace associated with the tag filter entry. Valid values are `elb`, `application_elb`, `sqs`, `rds`, `custom`, `network_elb`, `lambda`, `step_functions`.
        :param pulumi.Input[_builtins.str] tag_filter_str: The tag filter string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationTagFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !>This resource is deprecated - use the `aws.IntegrationAccount` resource instead.

        Provides a Datadog AWS tag filter resource. This can be used to create and manage Datadog AWS tag filters.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Create a new Datadog - Amazon Web Services integration tag filter
        foo = datadog.aws.IntegrationTagFilter("foo",
            account_id="123456789010",
            namespace="sqs",
            tag_filter_str="key:value")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        Amazon Web Services log filter resource can be imported using their account ID and namespace separated with a colon (:).

        ```sh
        $ pulumi import datadog:aws/integrationTagFilter:IntegrationTagFilter foo ${account_id}:${namespace}
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationTagFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationTagFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 namespace: Optional[pulumi.Input[_builtins.str]] = None,
                 tag_filter_str: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationTagFilterArgs.__new__(IntegrationTagFilterArgs)

            if account_id is None and not opts.urn:
                raise TypeError("Missing required property 'account_id'")
            __props__.__dict__["account_id"] = account_id
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            if tag_filter_str is None and not opts.urn:
                raise TypeError("Missing required property 'tag_filter_str'")
            __props__.__dict__["tag_filter_str"] = tag_filter_str
        super(IntegrationTagFilter, __self__).__init__(
            'datadog:aws/integrationTagFilter:IntegrationTagFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_id: Optional[pulumi.Input[_builtins.str]] = None,
            namespace: Optional[pulumi.Input[_builtins.str]] = None,
            tag_filter_str: Optional[pulumi.Input[_builtins.str]] = None) -> 'IntegrationTagFilter':
        """
        Get an existing IntegrationTagFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_id: Your AWS Account ID without dashes.
        :param pulumi.Input[_builtins.str] namespace: The namespace associated with the tag filter entry. Valid values are `elb`, `application_elb`, `sqs`, `rds`, `custom`, `network_elb`, `lambda`, `step_functions`.
        :param pulumi.Input[_builtins.str] tag_filter_str: The tag filter string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationTagFilterState.__new__(_IntegrationTagFilterState)

        __props__.__dict__["account_id"] = account_id
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["tag_filter_str"] = tag_filter_str
        return IntegrationTagFilter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> pulumi.Output[_builtins.str]:
        """
        Your AWS Account ID without dashes.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace associated with the tag filter entry. Valid values are `elb`, `application_elb`, `sqs`, `rds`, `custom`, `network_elb`, `lambda`, `step_functions`.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="tagFilterStr")
    def tag_filter_str(self) -> pulumi.Output[_builtins.str]:
        """
        The tag filter string.
        """
        return pulumi.get(self, "tag_filter_str")

