# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetServiceLevelObjectiveResult',
    'AwaitableGetServiceLevelObjectiveResult',
    'get_service_level_objective',
    'get_service_level_objective_output',
]

@pulumi.output_type
class GetServiceLevelObjectiveResult:
    """
    A collection of values returned by getServiceLevelObjective.
    """
    def __init__(__self__, description=None, id=None, metrics_query=None, name=None, name_query=None, queries=None, tags_query=None, target_threshold=None, timeframe=None, type=None, warning_threshold=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metrics_query and not isinstance(metrics_query, str):
            raise TypeError("Expected argument 'metrics_query' to be a str")
        pulumi.set(__self__, "metrics_query", metrics_query)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_query and not isinstance(name_query, str):
            raise TypeError("Expected argument 'name_query' to be a str")
        pulumi.set(__self__, "name_query", name_query)
        if queries and not isinstance(queries, list):
            raise TypeError("Expected argument 'queries' to be a list")
        pulumi.set(__self__, "queries", queries)
        if tags_query and not isinstance(tags_query, str):
            raise TypeError("Expected argument 'tags_query' to be a str")
        pulumi.set(__self__, "tags_query", tags_query)
        if target_threshold and not isinstance(target_threshold, float):
            raise TypeError("Expected argument 'target_threshold' to be a float")
        pulumi.set(__self__, "target_threshold", target_threshold)
        if timeframe and not isinstance(timeframe, str):
            raise TypeError("Expected argument 'timeframe' to be a str")
        pulumi.set(__self__, "timeframe", timeframe)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if warning_threshold and not isinstance(warning_threshold, float):
            raise TypeError("Expected argument 'warning_threshold' to be a float")
        pulumi.set(__self__, "warning_threshold", warning_threshold)

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the service level objective.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        A SLO ID to limit the search.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="metricsQuery")
    def metrics_query(self) -> Optional[_builtins.str]:
        """
        Filter results based on SLO numerator and denominator.
        """
        return pulumi.get(self, "metrics_query")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the Datadog service level objective
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nameQuery")
    def name_query(self) -> Optional[_builtins.str]:
        """
        Filter results based on SLO names.
        """
        return pulumi.get(self, "name_query")

    @_builtins.property
    @pulumi.getter
    def queries(self) -> Sequence['outputs.GetServiceLevelObjectiveQueryResult']:
        """
        The metric query of good / total events
        """
        return pulumi.get(self, "queries")

    @_builtins.property
    @pulumi.getter(name="tagsQuery")
    def tags_query(self) -> Optional[_builtins.str]:
        """
        Filter results based on a single SLO tag.
        """
        return pulumi.get(self, "tags_query")

    @_builtins.property
    @pulumi.getter(name="targetThreshold")
    def target_threshold(self) -> _builtins.float:
        """
        The primary target threshold of the service level objective.
        """
        return pulumi.get(self, "target_threshold")

    @_builtins.property
    @pulumi.getter
    def timeframe(self) -> _builtins.str:
        """
        The primary timeframe of the service level objective.
        """
        return pulumi.get(self, "timeframe")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the service level objective. The mapping from these types to the types found in the Datadog Web UI can be found in the Datadog API [documentation page](https://docs.datadoghq.com/api/v1/service-level-objectives/#create-a-slo-object). Available values are: `metric` and `monitor`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="warningThreshold")
    def warning_threshold(self) -> _builtins.float:
        """
        The primary warning threshold of the service level objective.
        """
        return pulumi.get(self, "warning_threshold")


class AwaitableGetServiceLevelObjectiveResult(GetServiceLevelObjectiveResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceLevelObjectiveResult(
            description=self.description,
            id=self.id,
            metrics_query=self.metrics_query,
            name=self.name,
            name_query=self.name_query,
            queries=self.queries,
            tags_query=self.tags_query,
            target_threshold=self.target_threshold,
            timeframe=self.timeframe,
            type=self.type,
            warning_threshold=self.warning_threshold)


def get_service_level_objective(id: Optional[_builtins.str] = None,
                                metrics_query: Optional[_builtins.str] = None,
                                name_query: Optional[_builtins.str] = None,
                                tags_query: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceLevelObjectiveResult:
    """
    Use this data source to retrieve information about an existing SLO for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_service_level_objective(name_query="My test SLO",
        tags_query="foo:bar")
    api_slo = datadog.get_service_level_objective(id=api["outputs"]["slo"])
    ```


    :param _builtins.str id: A SLO ID to limit the search.
    :param _builtins.str metrics_query: Filter results based on SLO numerator and denominator.
    :param _builtins.str name_query: Filter results based on SLO names.
    :param _builtins.str tags_query: Filter results based on a single SLO tag.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['metricsQuery'] = metrics_query
    __args__['nameQuery'] = name_query
    __args__['tagsQuery'] = tags_query
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('datadog:index/getServiceLevelObjective:getServiceLevelObjective', __args__, opts=opts, typ=GetServiceLevelObjectiveResult).value

    return AwaitableGetServiceLevelObjectiveResult(
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        metrics_query=pulumi.get(__ret__, 'metrics_query'),
        name=pulumi.get(__ret__, 'name'),
        name_query=pulumi.get(__ret__, 'name_query'),
        queries=pulumi.get(__ret__, 'queries'),
        tags_query=pulumi.get(__ret__, 'tags_query'),
        target_threshold=pulumi.get(__ret__, 'target_threshold'),
        timeframe=pulumi.get(__ret__, 'timeframe'),
        type=pulumi.get(__ret__, 'type'),
        warning_threshold=pulumi.get(__ret__, 'warning_threshold'))
def get_service_level_objective_output(id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       metrics_query: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       name_query: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       tags_query: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServiceLevelObjectiveResult]:
    """
    Use this data source to retrieve information about an existing SLO for use in other resources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_datadog as datadog

    test = datadog.get_service_level_objective(name_query="My test SLO",
        tags_query="foo:bar")
    api_slo = datadog.get_service_level_objective(id=api["outputs"]["slo"])
    ```


    :param _builtins.str id: A SLO ID to limit the search.
    :param _builtins.str metrics_query: Filter results based on SLO numerator and denominator.
    :param _builtins.str name_query: Filter results based on SLO names.
    :param _builtins.str tags_query: Filter results based on a single SLO tag.
    """
    __args__ = dict()
    __args__['id'] = id
    __args__['metricsQuery'] = metrics_query
    __args__['nameQuery'] = name_query
    __args__['tagsQuery'] = tags_query
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('datadog:index/getServiceLevelObjective:getServiceLevelObjective', __args__, opts=opts, typ=GetServiceLevelObjectiveResult)
    return __ret__.apply(lambda __response__: GetServiceLevelObjectiveResult(
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        metrics_query=pulumi.get(__response__, 'metrics_query'),
        name=pulumi.get(__response__, 'name'),
        name_query=pulumi.get(__response__, 'name_query'),
        queries=pulumi.get(__response__, 'queries'),
        tags_query=pulumi.get(__response__, 'tags_query'),
        target_threshold=pulumi.get(__response__, 'target_threshold'),
        timeframe=pulumi.get(__response__, 'timeframe'),
        type=pulumi.get(__response__, 'type'),
        warning_threshold=pulumi.get(__response__, 'warning_threshold')))
