# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PowerpackArgs', 'Powerpack']

@pulumi.input_type
class PowerpackArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 layout: Optional[pulumi.Input['PowerpackLayoutArgs']] = None,
                 live_span: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 show_title: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template_variables: Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackTemplateVariableArgs']]]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackWidgetArgs']]]] = None):
        """
        The set of arguments for constructing a Powerpack resource.
        :param pulumi.Input[_builtins.str] description: The description of the powerpack.
        :param pulumi.Input['PowerpackLayoutArgs'] layout: The layout of the powerpack on a free-form dashboard.
        :param pulumi.Input[_builtins.str] live_span: The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `week_to_date`, `month_to_date`, `1y`, `alert`.
        :param pulumi.Input[_builtins.str] name: The name for the powerpack.
        :param pulumi.Input[_builtins.bool] show_title: Whether or not title should be displayed in the powerpack.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to identify this powerpack.
        :param pulumi.Input[Sequence[pulumi.Input['PowerpackTemplateVariableArgs']]] template_variables: The list of template variables for this powerpack.
        :param pulumi.Input[Sequence[pulumi.Input['PowerpackWidgetArgs']]] widgets: The list of widgets to display in the powerpack.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if layout is not None:
            pulumi.set(__self__, "layout", layout)
        if live_span is not None:
            pulumi.set(__self__, "live_span", live_span)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if show_title is not None:
            pulumi.set(__self__, "show_title", show_title)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_variables is not None:
            pulumi.set(__self__, "template_variables", template_variables)
        if widgets is not None:
            pulumi.set(__self__, "widgets", widgets)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the powerpack.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def layout(self) -> Optional[pulumi.Input['PowerpackLayoutArgs']]:
        """
        The layout of the powerpack on a free-form dashboard.
        """
        return pulumi.get(self, "layout")

    @layout.setter
    def layout(self, value: Optional[pulumi.Input['PowerpackLayoutArgs']]):
        pulumi.set(self, "layout", value)

    @_builtins.property
    @pulumi.getter(name="liveSpan")
    def live_span(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `week_to_date`, `month_to_date`, `1y`, `alert`.
        """
        return pulumi.get(self, "live_span")

    @live_span.setter
    def live_span(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "live_span", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the powerpack.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="showTitle")
    def show_title(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not title should be displayed in the powerpack.
        """
        return pulumi.get(self, "show_title")

    @show_title.setter
    def show_title(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_title", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags to identify this powerpack.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateVariables")
    def template_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackTemplateVariableArgs']]]]:
        """
        The list of template variables for this powerpack.
        """
        return pulumi.get(self, "template_variables")

    @template_variables.setter
    def template_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackTemplateVariableArgs']]]]):
        pulumi.set(self, "template_variables", value)

    @_builtins.property
    @pulumi.getter
    def widgets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackWidgetArgs']]]]:
        """
        The list of widgets to display in the powerpack.
        """
        return pulumi.get(self, "widgets")

    @widgets.setter
    def widgets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackWidgetArgs']]]]):
        pulumi.set(self, "widgets", value)


@pulumi.input_type
class _PowerpackState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 layout: Optional[pulumi.Input['PowerpackLayoutArgs']] = None,
                 live_span: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 show_title: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template_variables: Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackTemplateVariableArgs']]]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackWidgetArgs']]]] = None):
        """
        Input properties used for looking up and filtering Powerpack resources.
        :param pulumi.Input[_builtins.str] description: The description of the powerpack.
        :param pulumi.Input['PowerpackLayoutArgs'] layout: The layout of the powerpack on a free-form dashboard.
        :param pulumi.Input[_builtins.str] live_span: The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `week_to_date`, `month_to_date`, `1y`, `alert`.
        :param pulumi.Input[_builtins.str] name: The name for the powerpack.
        :param pulumi.Input[_builtins.bool] show_title: Whether or not title should be displayed in the powerpack.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to identify this powerpack.
        :param pulumi.Input[Sequence[pulumi.Input['PowerpackTemplateVariableArgs']]] template_variables: The list of template variables for this powerpack.
        :param pulumi.Input[Sequence[pulumi.Input['PowerpackWidgetArgs']]] widgets: The list of widgets to display in the powerpack.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if layout is not None:
            pulumi.set(__self__, "layout", layout)
        if live_span is not None:
            pulumi.set(__self__, "live_span", live_span)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if show_title is not None:
            pulumi.set(__self__, "show_title", show_title)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if template_variables is not None:
            pulumi.set(__self__, "template_variables", template_variables)
        if widgets is not None:
            pulumi.set(__self__, "widgets", widgets)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the powerpack.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def layout(self) -> Optional[pulumi.Input['PowerpackLayoutArgs']]:
        """
        The layout of the powerpack on a free-form dashboard.
        """
        return pulumi.get(self, "layout")

    @layout.setter
    def layout(self, value: Optional[pulumi.Input['PowerpackLayoutArgs']]):
        pulumi.set(self, "layout", value)

    @_builtins.property
    @pulumi.getter(name="liveSpan")
    def live_span(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `week_to_date`, `month_to_date`, `1y`, `alert`.
        """
        return pulumi.get(self, "live_span")

    @live_span.setter
    def live_span(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "live_span", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name for the powerpack.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="showTitle")
    def show_title(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not title should be displayed in the powerpack.
        """
        return pulumi.get(self, "show_title")

    @show_title.setter
    def show_title(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "show_title", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags to identify this powerpack.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="templateVariables")
    def template_variables(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackTemplateVariableArgs']]]]:
        """
        The list of template variables for this powerpack.
        """
        return pulumi.get(self, "template_variables")

    @template_variables.setter
    def template_variables(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackTemplateVariableArgs']]]]):
        pulumi.set(self, "template_variables", value)

    @_builtins.property
    @pulumi.getter
    def widgets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackWidgetArgs']]]]:
        """
        The list of widgets to display in the powerpack.
        """
        return pulumi.get(self, "widgets")

    @widgets.setter
    def widgets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PowerpackWidgetArgs']]]]):
        pulumi.set(self, "widgets", value)


@pulumi.type_token("datadog:index/powerpack:Powerpack")
class Powerpack(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 layout: Optional[pulumi.Input[Union['PowerpackLayoutArgs', 'PowerpackLayoutArgsDict']]] = None,
                 live_span: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 show_title: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PowerpackTemplateVariableArgs', 'PowerpackTemplateVariableArgsDict']]]]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PowerpackWidgetArgs', 'PowerpackWidgetArgsDict']]]]] = None,
                 __props__=None):
        """
        Provides a Datadog powerpack resource. This can be used to create and manage Datadog powerpacks.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Manage Datadog Powerpacks
        foo = datadog.Powerpack("foo",
            description="Created using the Datadog provider in terraform",
            live_span="4h",
            layout={
                "height": 10,
                "width": 3,
                "x": 1,
                "y": 0,
            },
            template_variables=[{
                "defaults": ["defaults"],
                "name": "datacenter",
            }],
            widgets=[{
                "event_stream_definition": {
                    "query": "*",
                    "event_size": "l",
                    "title": "Widget Title",
                    "title_size": "16",
                    "title_align": "right",
                },
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/powerpack:Powerpack foo 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the powerpack.
        :param pulumi.Input[Union['PowerpackLayoutArgs', 'PowerpackLayoutArgsDict']] layout: The layout of the powerpack on a free-form dashboard.
        :param pulumi.Input[_builtins.str] live_span: The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `week_to_date`, `month_to_date`, `1y`, `alert`.
        :param pulumi.Input[_builtins.str] name: The name for the powerpack.
        :param pulumi.Input[_builtins.bool] show_title: Whether or not title should be displayed in the powerpack.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to identify this powerpack.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PowerpackTemplateVariableArgs', 'PowerpackTemplateVariableArgsDict']]]] template_variables: The list of template variables for this powerpack.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PowerpackWidgetArgs', 'PowerpackWidgetArgsDict']]]] widgets: The list of widgets to display in the powerpack.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[PowerpackArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog powerpack resource. This can be used to create and manage Datadog powerpacks.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_datadog as datadog

        # Manage Datadog Powerpacks
        foo = datadog.Powerpack("foo",
            description="Created using the Datadog provider in terraform",
            live_span="4h",
            layout={
                "height": 10,
                "width": 3,
                "x": 1,
                "y": 0,
            },
            template_variables=[{
                "defaults": ["defaults"],
                "name": "datacenter",
            }],
            widgets=[{
                "event_stream_definition": {
                    "query": "*",
                    "event_size": "l",
                    "title": "Widget Title",
                    "title_size": "16",
                    "title_align": "right",
                },
            }])
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/powerpack:Powerpack foo 11111111-2222-3333-4444-555555555555
        ```

        :param str resource_name: The name of the resource.
        :param PowerpackArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PowerpackArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 layout: Optional[pulumi.Input[Union['PowerpackLayoutArgs', 'PowerpackLayoutArgsDict']]] = None,
                 live_span: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 show_title: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 template_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PowerpackTemplateVariableArgs', 'PowerpackTemplateVariableArgsDict']]]]] = None,
                 widgets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PowerpackWidgetArgs', 'PowerpackWidgetArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PowerpackArgs.__new__(PowerpackArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["layout"] = layout
            __props__.__dict__["live_span"] = live_span
            __props__.__dict__["name"] = name
            __props__.__dict__["show_title"] = show_title
            __props__.__dict__["tags"] = tags
            __props__.__dict__["template_variables"] = template_variables
            __props__.__dict__["widgets"] = widgets
        super(Powerpack, __self__).__init__(
            'datadog:index/powerpack:Powerpack',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            layout: Optional[pulumi.Input[Union['PowerpackLayoutArgs', 'PowerpackLayoutArgsDict']]] = None,
            live_span: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            show_title: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            template_variables: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PowerpackTemplateVariableArgs', 'PowerpackTemplateVariableArgsDict']]]]] = None,
            widgets: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PowerpackWidgetArgs', 'PowerpackWidgetArgsDict']]]]] = None) -> 'Powerpack':
        """
        Get an existing Powerpack resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the powerpack.
        :param pulumi.Input[Union['PowerpackLayoutArgs', 'PowerpackLayoutArgsDict']] layout: The layout of the powerpack on a free-form dashboard.
        :param pulumi.Input[_builtins.str] live_span: The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `week_to_date`, `month_to_date`, `1y`, `alert`.
        :param pulumi.Input[_builtins.str] name: The name for the powerpack.
        :param pulumi.Input[_builtins.bool] show_title: Whether or not title should be displayed in the powerpack.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: List of tags to identify this powerpack.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PowerpackTemplateVariableArgs', 'PowerpackTemplateVariableArgsDict']]]] template_variables: The list of template variables for this powerpack.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PowerpackWidgetArgs', 'PowerpackWidgetArgsDict']]]] widgets: The list of widgets to display in the powerpack.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PowerpackState.__new__(_PowerpackState)

        __props__.__dict__["description"] = description
        __props__.__dict__["layout"] = layout
        __props__.__dict__["live_span"] = live_span
        __props__.__dict__["name"] = name
        __props__.__dict__["show_title"] = show_title
        __props__.__dict__["tags"] = tags
        __props__.__dict__["template_variables"] = template_variables
        __props__.__dict__["widgets"] = widgets
        return Powerpack(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the powerpack.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def layout(self) -> pulumi.Output['outputs.PowerpackLayout']:
        """
        The layout of the powerpack on a free-form dashboard.
        """
        return pulumi.get(self, "layout")

    @_builtins.property
    @pulumi.getter(name="liveSpan")
    def live_span(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The timeframe to use when displaying the widget. Valid values are `1m`, `5m`, `10m`, `15m`, `30m`, `1h`, `4h`, `1d`, `2d`, `1w`, `1mo`, `3mo`, `6mo`, `week_to_date`, `month_to_date`, `1y`, `alert`.
        """
        return pulumi.get(self, "live_span")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name for the powerpack.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="showTitle")
    def show_title(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether or not title should be displayed in the powerpack.
        """
        return pulumi.get(self, "show_title")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags to identify this powerpack.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="templateVariables")
    def template_variables(self) -> pulumi.Output[Optional[Sequence['outputs.PowerpackTemplateVariable']]]:
        """
        The list of template variables for this powerpack.
        """
        return pulumi.get(self, "template_variables")

    @_builtins.property
    @pulumi.getter
    def widgets(self) -> pulumi.Output[Optional[Sequence['outputs.PowerpackWidget']]]:
        """
        The list of widgets to display in the powerpack.
        """
        return pulumi.get(self, "widgets")

