# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityNotificationRuleArgs', 'SecurityNotificationRule']

@pulumi.input_type
class SecurityNotificationRuleArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 targets: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 selectors: Optional[pulumi.Input['SecurityNotificationRuleSelectorsArgs']] = None,
                 time_aggregation: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a SecurityNotificationRule resource.
        :param pulumi.Input[_builtins.str] name: The name of the rule (must be unique).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] targets: The list of handle targets for the notifications. A target must be prefixed with an @. It can be an email address (@bob@email.com), or any installed integration. For example, a Slack recipient (@slack-ops), or a Teams recipient (@teams-ops).
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the rule is enabled. Defaults to `true`.
        :param pulumi.Input['SecurityNotificationRuleSelectorsArgs'] selectors: Defines selectors to filter security issues that generate notifications.
        :param pulumi.Input[_builtins.int] time_aggregation: Specifies the time period, in seconds, used to aggregate the notification. Defaults to `0`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "targets", targets)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if time_aggregation is not None:
            pulumi.set(__self__, "time_aggregation", time_aggregation)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the rule (must be unique).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of handle targets for the notifications. A target must be prefixed with an @. It can be an email address (@bob@email.com), or any installed integration. For example, a Slack recipient (@slack-ops), or a Teams recipient (@teams-ops).
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "targets", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the rule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input['SecurityNotificationRuleSelectorsArgs']]:
        """
        Defines selectors to filter security issues that generate notifications.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input['SecurityNotificationRuleSelectorsArgs']]):
        pulumi.set(self, "selectors", value)

    @_builtins.property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the time period, in seconds, used to aggregate the notification. Defaults to `0`.
        """
        return pulumi.get(self, "time_aggregation")

    @time_aggregation.setter
    def time_aggregation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_aggregation", value)


@pulumi.input_type
class _SecurityNotificationRuleState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.int]] = None,
                 created_by_handle: Optional[pulumi.Input[_builtins.str]] = None,
                 created_by_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 modified_at: Optional[pulumi.Input[_builtins.int]] = None,
                 modified_by_handle: Optional[pulumi.Input[_builtins.str]] = None,
                 modified_by_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 selectors: Optional[pulumi.Input['SecurityNotificationRuleSelectorsArgs']] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_aggregation: Optional[pulumi.Input[_builtins.int]] = None,
                 version: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering SecurityNotificationRule resources.
        :param pulumi.Input[_builtins.int] created_at: Indicates when this rule was created.
        :param pulumi.Input[_builtins.str] created_by_handle: The handle of the rule creator.
        :param pulumi.Input[_builtins.str] created_by_name: The name of the rule creator.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the rule is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.int] modified_at: Indicates when this rule was last modified.
        :param pulumi.Input[_builtins.str] modified_by_handle: The handle of the rule last modifier.
        :param pulumi.Input[_builtins.str] modified_by_name: The name of the rule last modifier.
        :param pulumi.Input[_builtins.str] name: The name of the rule (must be unique).
        :param pulumi.Input['SecurityNotificationRuleSelectorsArgs'] selectors: Defines selectors to filter security issues that generate notifications.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] targets: The list of handle targets for the notifications. A target must be prefixed with an @. It can be an email address (@bob@email.com), or any installed integration. For example, a Slack recipient (@slack-ops), or a Teams recipient (@teams-ops).
        :param pulumi.Input[_builtins.int] time_aggregation: Specifies the time period, in seconds, used to aggregate the notification. Defaults to `0`.
        :param pulumi.Input[_builtins.int] version: The rule version (incremented at each update).
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by_handle is not None:
            pulumi.set(__self__, "created_by_handle", created_by_handle)
        if created_by_name is not None:
            pulumi.set(__self__, "created_by_name", created_by_name)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if modified_at is not None:
            pulumi.set(__self__, "modified_at", modified_at)
        if modified_by_handle is not None:
            pulumi.set(__self__, "modified_by_handle", modified_by_handle)
        if modified_by_name is not None:
            pulumi.set(__self__, "modified_by_name", modified_by_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if selectors is not None:
            pulumi.set(__self__, "selectors", selectors)
        if targets is not None:
            pulumi.set(__self__, "targets", targets)
        if time_aggregation is not None:
            pulumi.set(__self__, "time_aggregation", time_aggregation)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates when this rule was created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="createdByHandle")
    def created_by_handle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The handle of the rule creator.
        """
        return pulumi.get(self, "created_by_handle")

    @created_by_handle.setter
    def created_by_handle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by_handle", value)

    @_builtins.property
    @pulumi.getter(name="createdByName")
    def created_by_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule creator.
        """
        return pulumi.get(self, "created_by_name")

    @created_by_name.setter
    def created_by_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_by_name", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the rule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates when this rule was last modified.
        """
        return pulumi.get(self, "modified_at")

    @modified_at.setter
    def modified_at(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "modified_at", value)

    @_builtins.property
    @pulumi.getter(name="modifiedByHandle")
    def modified_by_handle(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The handle of the rule last modifier.
        """
        return pulumi.get(self, "modified_by_handle")

    @modified_by_handle.setter
    def modified_by_handle(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_by_handle", value)

    @_builtins.property
    @pulumi.getter(name="modifiedByName")
    def modified_by_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule last modifier.
        """
        return pulumi.get(self, "modified_by_name")

    @modified_by_name.setter
    def modified_by_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "modified_by_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the rule (must be unique).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def selectors(self) -> Optional[pulumi.Input['SecurityNotificationRuleSelectorsArgs']]:
        """
        Defines selectors to filter security issues that generate notifications.
        """
        return pulumi.get(self, "selectors")

    @selectors.setter
    def selectors(self, value: Optional[pulumi.Input['SecurityNotificationRuleSelectorsArgs']]):
        pulumi.set(self, "selectors", value)

    @_builtins.property
    @pulumi.getter
    def targets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of handle targets for the notifications. A target must be prefixed with an @. It can be an email address (@bob@email.com), or any installed integration. For example, a Slack recipient (@slack-ops), or a Teams recipient (@teams-ops).
        """
        return pulumi.get(self, "targets")

    @targets.setter
    def targets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "targets", value)

    @_builtins.property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the time period, in seconds, used to aggregate the notification. Defaults to `0`.
        """
        return pulumi.get(self, "time_aggregation")

    @time_aggregation.setter
    def time_aggregation(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "time_aggregation", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rule version (incremented at each update).
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "version", value)


@pulumi.type_token("datadog:index/securityNotificationRule:SecurityNotificationRule")
class SecurityNotificationRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 selectors: Optional[pulumi.Input[Union['SecurityNotificationRuleSelectorsArgs', 'SecurityNotificationRuleSelectorsArgsDict']]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_aggregation: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Provides a Datadog Security Monitoring Notification Rule API resource for creating and managing Datadog security notification rules.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/securityNotificationRule:SecurityNotificationRule signal_rule yq9-t9l-bso
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the rule is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.str] name: The name of the rule (must be unique).
        :param pulumi.Input[Union['SecurityNotificationRuleSelectorsArgs', 'SecurityNotificationRuleSelectorsArgsDict']] selectors: Defines selectors to filter security issues that generate notifications.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] targets: The list of handle targets for the notifications. A target must be prefixed with an @. It can be an email address (@bob@email.com), or any installed integration. For example, a Slack recipient (@slack-ops), or a Teams recipient (@teams-ops).
        :param pulumi.Input[_builtins.int] time_aggregation: Specifies the time period, in seconds, used to aggregate the notification. Defaults to `0`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityNotificationRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Datadog Security Monitoring Notification Rule API resource for creating and managing Datadog security notification rules.

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import datadog:index/securityNotificationRule:SecurityNotificationRule signal_rule yq9-t9l-bso
        ```

        :param str resource_name: The name of the resource.
        :param SecurityNotificationRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityNotificationRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 selectors: Optional[pulumi.Input[Union['SecurityNotificationRuleSelectorsArgs', 'SecurityNotificationRuleSelectorsArgsDict']]] = None,
                 targets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 time_aggregation: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityNotificationRuleArgs.__new__(SecurityNotificationRuleArgs)

            __props__.__dict__["enabled"] = enabled
            if name is None and not opts.urn:
                raise TypeError("Missing required property 'name'")
            __props__.__dict__["name"] = name
            __props__.__dict__["selectors"] = selectors
            if targets is None and not opts.urn:
                raise TypeError("Missing required property 'targets'")
            __props__.__dict__["targets"] = targets
            __props__.__dict__["time_aggregation"] = time_aggregation
            __props__.__dict__["created_at"] = None
            __props__.__dict__["created_by_handle"] = None
            __props__.__dict__["created_by_name"] = None
            __props__.__dict__["modified_at"] = None
            __props__.__dict__["modified_by_handle"] = None
            __props__.__dict__["modified_by_name"] = None
            __props__.__dict__["version"] = None
        super(SecurityNotificationRule, __self__).__init__(
            'datadog:index/securityNotificationRule:SecurityNotificationRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.int]] = None,
            created_by_handle: Optional[pulumi.Input[_builtins.str]] = None,
            created_by_name: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            modified_at: Optional[pulumi.Input[_builtins.int]] = None,
            modified_by_handle: Optional[pulumi.Input[_builtins.str]] = None,
            modified_by_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            selectors: Optional[pulumi.Input[Union['SecurityNotificationRuleSelectorsArgs', 'SecurityNotificationRuleSelectorsArgsDict']]] = None,
            targets: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            time_aggregation: Optional[pulumi.Input[_builtins.int]] = None,
            version: Optional[pulumi.Input[_builtins.int]] = None) -> 'SecurityNotificationRule':
        """
        Get an existing SecurityNotificationRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] created_at: Indicates when this rule was created.
        :param pulumi.Input[_builtins.str] created_by_handle: The handle of the rule creator.
        :param pulumi.Input[_builtins.str] created_by_name: The name of the rule creator.
        :param pulumi.Input[_builtins.bool] enabled: Indicates whether the rule is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.int] modified_at: Indicates when this rule was last modified.
        :param pulumi.Input[_builtins.str] modified_by_handle: The handle of the rule last modifier.
        :param pulumi.Input[_builtins.str] modified_by_name: The name of the rule last modifier.
        :param pulumi.Input[_builtins.str] name: The name of the rule (must be unique).
        :param pulumi.Input[Union['SecurityNotificationRuleSelectorsArgs', 'SecurityNotificationRuleSelectorsArgsDict']] selectors: Defines selectors to filter security issues that generate notifications.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] targets: The list of handle targets for the notifications. A target must be prefixed with an @. It can be an email address (@bob@email.com), or any installed integration. For example, a Slack recipient (@slack-ops), or a Teams recipient (@teams-ops).
        :param pulumi.Input[_builtins.int] time_aggregation: Specifies the time period, in seconds, used to aggregate the notification. Defaults to `0`.
        :param pulumi.Input[_builtins.int] version: The rule version (incremented at each update).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityNotificationRuleState.__new__(_SecurityNotificationRuleState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["created_by_handle"] = created_by_handle
        __props__.__dict__["created_by_name"] = created_by_name
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["modified_at"] = modified_at
        __props__.__dict__["modified_by_handle"] = modified_by_handle
        __props__.__dict__["modified_by_name"] = modified_by_name
        __props__.__dict__["name"] = name
        __props__.__dict__["selectors"] = selectors
        __props__.__dict__["targets"] = targets
        __props__.__dict__["time_aggregation"] = time_aggregation
        __props__.__dict__["version"] = version
        return SecurityNotificationRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates when this rule was created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="createdByHandle")
    def created_by_handle(self) -> pulumi.Output[_builtins.str]:
        """
        The handle of the rule creator.
        """
        return pulumi.get(self, "created_by_handle")

    @_builtins.property
    @pulumi.getter(name="createdByName")
    def created_by_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the rule creator.
        """
        return pulumi.get(self, "created_by_name")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the rule is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="modifiedAt")
    def modified_at(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates when this rule was last modified.
        """
        return pulumi.get(self, "modified_at")

    @_builtins.property
    @pulumi.getter(name="modifiedByHandle")
    def modified_by_handle(self) -> pulumi.Output[_builtins.str]:
        """
        The handle of the rule last modifier.
        """
        return pulumi.get(self, "modified_by_handle")

    @_builtins.property
    @pulumi.getter(name="modifiedByName")
    def modified_by_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the rule last modifier.
        """
        return pulumi.get(self, "modified_by_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the rule (must be unique).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def selectors(self) -> pulumi.Output[Optional['outputs.SecurityNotificationRuleSelectors']]:
        """
        Defines selectors to filter security issues that generate notifications.
        """
        return pulumi.get(self, "selectors")

    @_builtins.property
    @pulumi.getter
    def targets(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of handle targets for the notifications. A target must be prefixed with an @. It can be an email address (@bob@email.com), or any installed integration. For example, a Slack recipient (@slack-ops), or a Teams recipient (@teams-ops).
        """
        return pulumi.get(self, "targets")

    @_builtins.property
    @pulumi.getter(name="timeAggregation")
    def time_aggregation(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the time period, in seconds, used to aggregate the notification. Defaults to `0`.
        """
        return pulumi.get(self, "time_aggregation")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.int]:
        """
        The rule version (incremented at each update).
        """
        return pulumi.get(self, "version")

