"""Auto-generated circled or squared character transliterator.

Replace circled or squared characters with their corresponding templates.
"""
from collections.abc import Iterable
from typing import Literal

from ..chars import Char

__all__ = ["Transliterator"]

# Generated mapping data: char -> [rendering, type_abbrev, is_emoji]
CIRCLED_OR_SQUARED_MAPPINGS: dict[str, tuple[str, Literal["c", "s"], bool]] = {
    "\xa9": ("C", "c", False),
    "\u2117": ("P", "c", False),
    "\u2460": ("1", "c", False),
    "\u2461": ("2", "c", False),
    "\u2462": ("3", "c", False),
    "\u2463": ("4", "c", False),
    "\u2464": ("5", "c", False),
    "\u2465": ("6", "c", False),
    "\u2466": ("7", "c", False),
    "\u2467": ("8", "c", False),
    "\u2468": ("9", "c", False),
    "\u2469": ("10", "c", False),
    "\u246a": ("11", "c", False),
    "\u246b": ("12", "c", False),
    "\u246c": ("13", "c", False),
    "\u246d": ("14", "c", False),
    "\u246e": ("15", "c", False),
    "\u246f": ("16", "c", False),
    "\u2470": ("17", "c", False),
    "\u2471": ("18", "c", False),
    "\u2472": ("19", "c", False),
    "\u2473": ("20", "c", False),
    "\u24b6": ("A", "c", False),
    "\u24b7": ("B", "c", False),
    "\u24b8": ("C", "c", False),
    "\u24b9": ("D", "c", False),
    "\u24ba": ("E", "c", False),
    "\u24bb": ("F", "c", False),
    "\u24bc": ("G", "c", False),
    "\u24bd": ("H", "c", False),
    "\u24be": ("I", "c", False),
    "\u24bf": ("J", "c", False),
    "\u24c0": ("K", "c", False),
    "\u24c1": ("L", "c", False),
    "\u24c2": ("M", "c", False),
    "\u24c3": ("N", "c", False),
    "\u24c4": ("O", "c", False),
    "\u24c5": ("P", "c", False),
    "\u24c6": ("Q", "c", False),
    "\u24c7": ("R", "c", False),
    "\u24c8": ("S", "c", False),
    "\u24c9": ("T", "c", False),
    "\u24ca": ("U", "c", False),
    "\u24cb": ("V", "c", False),
    "\u24cc": ("W", "c", False),
    "\u24cd": ("X", "c", False),
    "\u24ce": ("Y", "c", False),
    "\u24cf": ("Z", "c", False),
    "\u24d0": ("a", "c", False),
    "\u24d1": ("b", "c", False),
    "\u24d2": ("c", "c", False),
    "\u24d3": ("d", "c", False),
    "\u24d4": ("e", "c", False),
    "\u24d5": ("f", "c", False),
    "\u24d6": ("g", "c", False),
    "\u24d7": ("h", "c", False),
    "\u24d8": ("i", "c", False),
    "\u24d9": ("j", "c", False),
    "\u24da": ("k", "c", False),
    "\u24db": ("l", "c", False),
    "\u24dc": ("m", "c", False),
    "\u24dd": ("n", "c", False),
    "\u24de": ("o", "c", False),
    "\u24df": ("p", "c", False),
    "\u24e0": ("q", "c", False),
    "\u24e1": ("r", "c", False),
    "\u24e2": ("s", "c", False),
    "\u24e3": ("t", "c", False),
    "\u24e4": ("u", "c", False),
    "\u24e5": ("v", "c", False),
    "\u24e6": ("w", "c", False),
    "\u24e7": ("x", "c", False),
    "\u24e8": ("y", "c", False),
    "\u24e9": ("z", "c", False),
    "\u24ea": ("0", "c", False),
    "\u24eb": ("11", "c", False),
    "\u24ec": ("12", "c", False),
    "\u24ed": ("13", "c", False),
    "\u24ee": ("14", "c", False),
    "\u24ef": ("15", "c", False),
    "\u24f0": ("16", "c", False),
    "\u24f1": ("17", "c", False),
    "\u24f2": ("18", "c", False),
    "\u24f3": ("19", "c", False),
    "\u24f4": ("20", "c", False),
    "\u24f5": ("1", "c", False),
    "\u24f6": ("2", "c", False),
    "\u24f7": ("3", "c", False),
    "\u24f8": ("4", "c", False),
    "\u24f9": ("5", "c", False),
    "\u24fa": ("6", "c", False),
    "\u24fb": ("7", "c", False),
    "\u24fc": ("8", "c", False),
    "\u24fd": ("9", "c", False),
    "\u24fe": ("10", "c", False),
    "\u24ff": ("0", "c", False),
    "\u2776": ("1", "c", False),
    "\u2777": ("2", "c", False),
    "\u2778": ("3", "c", False),
    "\u2779": ("4", "c", False),
    "\u277a": ("5", "c", False),
    "\u277b": ("6", "c", False),
    "\u277c": ("7", "c", False),
    "\u277d": ("8", "c", False),
    "\u277e": ("9", "c", False),
    "\u277f": ("10", "c", False),
    "\u2780": ("1", "c", False),
    "\u2781": ("2", "c", False),
    "\u2782": ("3", "c", False),
    "\u2783": ("4", "c", False),
    "\u2784": ("5", "c", False),
    "\u2785": ("6", "c", False),
    "\u2786": ("7", "c", False),
    "\u2787": ("8", "c", False),
    "\u2788": ("9", "c", False),
    "\u2789": ("10", "c", False),
    "\u278a": ("1", "c", False),
    "\u278b": ("2", "c", False),
    "\u278c": ("3", "c", False),
    "\u278d": ("4", "c", False),
    "\u278e": ("5", "c", False),
    "\u278f": ("6", "c", False),
    "\u2790": ("7", "c", False),
    "\u2791": ("8", "c", False),
    "\u2792": ("9", "c", False),
    "\u2793": ("10", "c", False),
    "\u3036": ("〒", "c", False),
    "\u3244": ("問", "c", False),
    "\u3245": ("幼", "c", False),
    "\u3246": ("文", "c", False),
    "\u3247": ("箏", "c", False),
    "\u3248": ("10", "c", False),
    "\u3251": ("21", "c", False),
    "\u3252": ("22", "c", False),
    "\u3253": ("23", "c", False),
    "\u3254": ("24", "c", False),
    "\u3255": ("25", "c", False),
    "\u3256": ("26", "c", False),
    "\u3257": ("27", "c", False),
    "\u3258": ("28", "c", False),
    "\u3259": ("29", "c", False),
    "\u325a": ("30", "c", False),
    "\u325b": ("31", "c", False),
    "\u325c": ("32", "c", False),
    "\u325d": ("33", "c", False),
    "\u325e": ("34", "c", False),
    "\u325f": ("35", "c", False),
    "\u3280": ("一", "c", False),
    "\u3281": ("二", "c", False),
    "\u3282": ("三", "c", False),
    "\u3283": ("四", "c", False),
    "\u3284": ("五", "c", False),
    "\u3285": ("六", "c", False),
    "\u3286": ("七", "c", False),
    "\u3287": ("八", "c", False),
    "\u3288": ("九", "c", False),
    "\u3289": ("十", "c", False),
    "\u328a": ("月", "c", False),
    "\u328b": ("火", "c", False),
    "\u328c": ("水", "c", False),
    "\u328d": ("木", "c", False),
    "\u328e": ("金", "c", False),
    "\u328f": ("土", "c", False),
    "\u3290": ("日", "c", False),
    "\u3291": ("株", "c", False),
    "\u3292": ("有", "c", False),
    "\u3293": ("社", "c", False),
    "\u3294": ("名", "c", False),
    "\u3295": ("特", "c", False),
    "\u3296": ("財", "c", False),
    "\u3297": ("祝", "c", False),
    "\u3298": ("労", "c", False),
    "\u3299": ("秘", "c", False),
    "\u329a": ("男", "c", False),
    "\u329b": ("女", "c", False),
    "\u329c": ("適", "c", False),
    "\u329d": ("優", "c", False),
    "\u329e": ("印", "c", False),
    "\u329f": ("注", "c", False),
    "\u32a0": ("項", "c", False),
    "\u32a1": ("休", "c", False),
    "\u32a2": ("写", "c", False),
    "\u32a3": ("正", "c", False),
    "\u32a4": ("上", "c", False),
    "\u32a5": ("中", "c", False),
    "\u32a6": ("下", "c", False),
    "\u32a7": ("左", "c", False),
    "\u32a8": ("右", "c", False),
    "\u32a9": ("医", "c", False),
    "\u32aa": ("宗", "c", False),
    "\u32ab": ("学", "c", False),
    "\u32ac": ("監", "c", False),
    "\u32ad": ("企", "c", False),
    "\u32ae": ("資", "c", False),
    "\u32af": ("協", "c", False),
    "\u32b0": ("夜", "c", False),
    "\u32b1": ("36", "c", False),
    "\u32b2": ("37", "c", False),
    "\u32b3": ("38", "c", False),
    "\u32b4": ("39", "c", False),
    "\u32b5": ("40", "c", False),
    "\u32b6": ("41", "c", False),
    "\u32b7": ("42", "c", False),
    "\u32b8": ("43", "c", False),
    "\u32b9": ("44", "c", False),
    "\u32ba": ("45", "c", False),
    "\u32bb": ("46", "c", False),
    "\u32bc": ("47", "c", False),
    "\u32bd": ("48", "c", False),
    "\u32be": ("49", "c", False),
    "\u32bf": ("50", "c", False),
    "\u32d0": ("ア", "c", False),
    "\u32d1": ("イ", "c", False),
    "\u32d2": ("ウ", "c", False),
    "\u32d3": ("エ", "c", False),
    "\u32d4": ("オ", "c", False),
    "\u32d5": ("カ", "c", False),
    "\u32d6": ("キ", "c", False),
    "\u32d7": ("ク", "c", False),
    "\u32d8": ("ケ", "c", False),
    "\u32d9": ("コ", "c", False),
    "\u32da": ("サ", "c", False),
    "\u32db": ("シ", "c", False),
    "\u32dc": ("ス", "c", False),
    "\u32dd": ("セ", "c", False),
    "\u32de": ("ソ", "c", False),
    "\u32df": ("タ", "c", False),
    "\u32e0": ("チ", "c", False),
    "\u32e1": ("ツ", "c", False),
    "\u32e2": ("テ", "c", False),
    "\u32e3": ("ト", "c", False),
    "\u32e4": ("ナ", "c", False),
    "\u32e5": ("ニ", "c", False),
    "\u32e6": ("ヌ", "c", False),
    "\u32e7": ("ネ", "c", False),
    "\u32e8": ("ノ", "c", False),
    "\u32e9": ("ハ", "c", False),
    "\u32ea": ("ヒ", "c", False),
    "\u32eb": ("フ", "c", False),
    "\u32ec": ("ヘ", "c", False),
    "\u32ed": ("ホ", "c", False),
    "\u32ee": ("マ", "c", False),
    "\u32ef": ("ミ", "c", False),
    "\u32f0": ("ム", "c", False),
    "\u32f1": ("メ", "c", False),
    "\u32f2": ("モ", "c", False),
    "\u32f3": ("ヤ", "c", False),
    "\u32f4": ("ユ", "c", False),
    "\u32f5": ("ヨ", "c", False),
    "\u32f6": ("ラ", "c", False),
    "\u32f7": ("リ", "c", False),
    "\u32f8": ("ル", "c", False),
    "\u32f9": ("レ", "c", False),
    "\u32fa": ("ロ", "c", False),
    "\u32fb": ("ワ", "c", False),
    "\u32fc": ("ヰ", "c", False),
    "\u32fd": ("ヱ", "c", False),
    "\u32fe": ("ヲ", "c", False),
    "\U0001f10b": ("0", "c", False),
    "\U0001f10c": ("0", "c", False),
    "\U0001f12b": ("C", "c", False),
    "\U0001f12c": ("R", "c", False),
    "\U0001f12d": ("CD", "c", False),
    "\U0001f12e": ("WZ", "c", False),
    "\U0001f130": ("A", "s", False),
    "\U0001f131": ("B", "s", False),
    "\U0001f132": ("C", "s", False),
    "\U0001f133": ("D", "s", False),
    "\U0001f134": ("E", "s", False),
    "\U0001f135": ("F", "s", False),
    "\U0001f136": ("G", "s", False),
    "\U0001f137": ("H", "s", False),
    "\U0001f138": ("I", "s", False),
    "\U0001f139": ("J", "s", False),
    "\U0001f13a": ("K", "s", False),
    "\U0001f13b": ("L", "s", False),
    "\U0001f13c": ("M", "s", False),
    "\U0001f13d": ("N", "s", False),
    "\U0001f13e": ("O", "s", False),
    "\U0001f13f": ("P", "s", False),
    "\U0001f140": ("Q", "s", False),
    "\U0001f141": ("R", "s", False),
    "\U0001f142": ("S", "s", False),
    "\U0001f143": ("T", "s", False),
    "\U0001f144": ("U", "s", False),
    "\U0001f145": ("V", "s", False),
    "\U0001f146": ("W", "s", False),
    "\U0001f147": ("X", "s", False),
    "\U0001f148": ("Y", "s", False),
    "\U0001f149": ("Z", "s", False),
    "\U0001f14a": ("HV", "s", False),
    "\U0001f14b": ("MV", "s", False),
    "\U0001f14c": ("SD", "s", False),
    "\U0001f14d": ("SS", "s", False),
    "\U0001f14e": ("PPV", "s", False),
    "\U0001f14f": ("WC", "s", False),
    "\U0001f150": ("A", "c", False),
    "\U0001f151": ("B", "c", False),
    "\U0001f152": ("C", "c", False),
    "\U0001f153": ("D", "c", False),
    "\U0001f154": ("E", "c", False),
    "\U0001f155": ("F", "c", False),
    "\U0001f156": ("G", "c", False),
    "\U0001f157": ("H", "c", False),
    "\U0001f158": ("I", "c", False),
    "\U0001f159": ("J", "c", False),
    "\U0001f15a": ("K", "c", False),
    "\U0001f15b": ("L", "c", False),
    "\U0001f15c": ("M", "c", False),
    "\U0001f15d": ("N", "c", False),
    "\U0001f15e": ("O", "c", False),
    "\U0001f15f": ("P", "c", False),
    "\U0001f160": ("Q", "c", False),
    "\U0001f161": ("R", "c", False),
    "\U0001f162": ("S", "c", False),
    "\U0001f163": ("T", "c", False),
    "\U0001f164": ("U", "c", False),
    "\U0001f165": ("V", "c", False),
    "\U0001f166": ("W", "c", False),
    "\U0001f167": ("X", "c", False),
    "\U0001f168": ("Y", "c", False),
    "\U0001f169": ("Z", "c", False),
    "\U0001f170": ("A", "s", False),
    "\U0001f171": ("B", "s", False),
    "\U0001f172": ("C", "s", False),
    "\U0001f173": ("D", "s", False),
    "\U0001f174": ("E", "s", False),
    "\U0001f175": ("F", "s", False),
    "\U0001f176": ("G", "s", False),
    "\U0001f177": ("H", "s", False),
    "\U0001f178": ("I", "s", False),
    "\U0001f179": ("J", "s", False),
    "\U0001f17a": ("K", "s", False),
    "\U0001f17b": ("L", "s", False),
    "\U0001f17c": ("M", "s", False),
    "\U0001f17d": ("N", "s", False),
    "\U0001f17e": ("O", "s", False),
    "\U0001f17f": ("P", "s", False),
    "\U0001f180": ("Q", "s", False),
    "\U0001f181": ("R", "s", False),
    "\U0001f182": ("S", "s", False),
    "\U0001f183": ("T", "s", False),
    "\U0001f184": ("U", "s", False),
    "\U0001f185": ("V", "s", False),
    "\U0001f186": ("W", "s", False),
    "\U0001f187": ("X", "s", False),
    "\U0001f188": ("Y", "s", False),
    "\U0001f189": ("Z", "s", False),
    "\U0001f18b": ("IC", "s", False),
    "\U0001f18c": ("PA", "s", False),
    "\U0001f18d": ("SA", "s", False),
    "\U0001f18e": ("AB", "s", True),
    "\U0001f18f": ("WC", "s", False),
    "\U0001f190": ("DJ", "s", False),
    "\U0001f191": ("CL", "s", True),
    "\U0001f192": ("COOL", "s", True),
    "\U0001f193": ("FREE", "s", True),
    "\U0001f194": ("ID", "s", True),
    "\U0001f195": ("NEW", "s", True),
    "\U0001f196": ("NG", "s", True),
    "\U0001f197": ("OK", "s", True),
    "\U0001f198": ("SOS", "s", True),
    "\U0001f199": ("UP!", "s", True),
    "\U0001f19a": ("VS", "s", True),
    "\U0001f19b": ("3D", "s", False),
    "\U0001f19c": ("2ndScr", "s", False),
    "\U0001f19d": ("2K", "s", False),
    "\U0001f19e": ("4K", "s", False),
    "\U0001f19f": ("8K", "s", False),
    "\U0001f1a0": ("5.1", "s", False),
    "\U0001f1a1": ("7.1", "s", False),
    "\U0001f1a2": ("22.2", "s", False),
    "\U0001f1a3": ("60P", "s", False),
    "\U0001f1a4": ("120P", "s", False),
    "\U0001f1a5": ("d", "s", False),
    "\U0001f1a6": ("HC", "s", False),
    "\U0001f1a7": ("HDR", "s", False),
    "\U0001f1a8": ("Hi-Res", "s", False),
    "\U0001f1a9": ("Lossless", "s", False),
    "\U0001f1aa": ("SHV", "s", False),
    "\U0001f1ab": ("UHD", "s", False),
    "\U0001f1ac": ("VOD", "s", False),
    "\U0001f1ad": ("M", "c", False),
    "\U0001f1e6": ("A", "s", False),
    "\U0001f1e7": ("B", "s", False),
    "\U0001f1e8": ("C", "s", False),
    "\U0001f1e9": ("D", "s", False),
    "\U0001f1ea": ("E", "s", False),
    "\U0001f1eb": ("F", "s", False),
    "\U0001f1ec": ("G", "s", False),
    "\U0001f1ed": ("H", "s", False),
    "\U0001f1ee": ("I", "s", False),
    "\U0001f1ef": ("J", "s", False),
    "\U0001f1f0": ("K", "s", False),
    "\U0001f1f1": ("L", "s", False),
    "\U0001f1f2": ("M", "s", False),
    "\U0001f1f3": ("N", "s", False),
    "\U0001f1f4": ("O", "s", False),
    "\U0001f1f5": ("P", "s", False),
    "\U0001f1f6": ("Q", "s", False),
    "\U0001f1f7": ("R", "s", False),
    "\U0001f1f8": ("S", "s", False),
    "\U0001f1f9": ("T", "s", False),
    "\U0001f1fa": ("U", "s", False),
    "\U0001f1fb": ("V", "s", False),
    "\U0001f1fc": ("W", "s", False),
    "\U0001f1fd": ("X", "s", False),
    "\U0001f1fe": ("Y", "s", False),
    "\U0001f1ff": ("Z", "s", False),
    "\U0001f6be": ("WC", "s", True),
    "\U0001f200": ("ほか", "s", False),
    "\U0001f201": ("ココ", "s", True),
    "\U0001f202": ("サ", "s", False),
    "\U0001f210": ("手", "s", False),
    "\U0001f211": ("字", "s", False),
    "\U0001f212": ("双", "s", False),
    "\U0001f213": ("デ", "s", False),
    "\U0001f214": ("二", "s", False),
    "\U0001f215": ("多", "s", False),
    "\U0001f216": ("解", "s", False),
    "\U0001f217": ("天", "s", False),
    "\U0001f218": ("交", "s", False),
    "\U0001f219": ("映", "s", False),
    "\U0001f21a": ("無", "s", True),
    "\U0001f21b": ("料", "s", False),
    "\U0001f21c": ("前", "s", False),
    "\U0001f21d": ("後", "s", False),
    "\U0001f21e": ("再", "s", False),
    "\U0001f21f": ("新", "s", False),
    "\U0001f220": ("初", "s", False),
    "\U0001f221": ("終", "s", False),
    "\U0001f222": ("生", "s", False),
    "\U0001f223": ("販", "s", False),
    "\U0001f224": ("声", "s", False),
    "\U0001f225": ("吹", "s", False),
    "\U0001f226": ("演", "s", False),
    "\U0001f227": ("投", "s", False),
    "\U0001f228": ("捕", "s", False),
    "\U0001f229": ("一", "s", False),
    "\U0001f22a": ("三", "s", False),
    "\U0001f22b": ("遊", "s", False),
    "\U0001f22c": ("左", "s", False),
    "\U0001f22d": ("中", "s", False),
    "\U0001f22e": ("右", "s", False),
    "\U0001f22f": ("指", "s", True),
    "\U0001f230": ("走", "s", False),
    "\U0001f231": ("打", "s", False),
    "\U0001f232": ("禁", "s", True),
    "\U0001f233": ("空", "s", True),
    "\U0001f234": ("合", "s", True),
    "\U0001f235": ("満", "s", True),
    "\U0001f236": ("有", "s", True),
    "\U0001f237": ("月", "s", False),
    "\U0001f238": ("申", "s", True),
    "\U0001f239": ("割", "s", True),
    "\U0001f23a": ("営", "s", True),
    "\U0001f23b": ("配", "s", False),
    "\U0001f250": ("得", "c", True),
    "\U0001f251": ("可", "c", True),
}


class Transliterator:
    """Transliterator for circled or squared characters.

    Replace circled or squared characters with their corresponding templates.
    """

    templates: dict[Literal["c", "s"], str]
    """Templates for circle and square formatting."""

    include_emojis: bool
    """Whether to include emojis in the transliteration."""

    def __init__(
        self, *,
        templates: dict[Literal["circle", "square"], str] | None = None,
        include_emojis: bool = False,
    ) -> None:
        """Initialize the transliterator with options.

        :param options: Configuration options
        """
        self.include_emojis = include_emojis
        c = templates.get("circle") if templates else None
        s = templates.get("square") if templates else None
        self.templates = {
            "c": "(?)" if c is None else c,
            "s": "[?]" if s is None else s,
        }

    def __call__(self, input_chars: Iterable[Char]) -> Iterable[Char]:
        """Replace circled or squared characters with their corresponding templates."""
        offset = 0
        for char in input_chars:
            mapping = CIRCLED_OR_SQUARED_MAPPINGS.get(char.c)
            if mapping is not None and (not mapping[2] or self.include_emojis):
                rendering, type_abbrev, _ = mapping
                template = self.templates[type_abbrev]
                replacement = template.replace("?", rendering)
                for replacement_char in replacement:
                    yield Char(c=replacement_char, offset=offset, source=char)
                    offset += len(replacement_char)
            else:
                yield char.with_offset(offset)
                offset += len(char.c)
