"""Auto-generated mathematical_alphanumerics transliterator.

Replace mathematical alphanumeric symbols with plain characters.
"""
from collections.abc import Iterable
from typing import Any

from ..chars import Char

__all__ = ["Transliterator"]

# Generated mapping data
MATHEMATICAL_ALPHANUMERICS_MAPPINGS = {
    "\u2102": "C",
    "\u210a": "g",
    "\u210b": "H",
    "\u210c": "H",
    "\u210e": "h",
    "\u2110": "I",
    "\u2111": "I",
    "\u2113": "l",
    "\u2115": "N",
    "\u2119": "P",
    "\u211a": "Q",
    "\u211b": "R",
    "\u211c": "R",
    "\u2124": "Z",
    "\u2126": "\u03a9",
    "\u212a": "K",
    "\u212c": "B",
    "\u212d": "C",
    "\u212f": "e",
    "\u2130": "E",
    "\u2131": "F",
    "\u2133": "M",
    "\u2134": "o",
    "\u213c": "\u03c0",
    "\u213d": "\u03b3",
    "\u213e": "\u0393",
    "\u213f": "\u03a0",
    "\u2140": "\u03a3",
    "\u2211": "\u03a3",
    "\u2145": "D",
    "\u2146": "d",
    "\u2147": "e",
    "\u2148": "i",
    "\u2149": "j",
    "\U0001d400": "A",
    "\U0001d401": "B",
    "\U0001d402": "C",
    "\U0001d403": "D",
    "\U0001d404": "E",
    "\U0001d405": "F",
    "\U0001d406": "G",
    "\U0001d407": "H",
    "\U0001d408": "I",
    "\U0001d409": "J",
    "\U0001d40a": "K",
    "\U0001d40b": "L",
    "\U0001d40c": "M",
    "\U0001d40d": "N",
    "\U0001d40e": "O",
    "\U0001d40f": "P",
    "\U0001d410": "Q",
    "\U0001d411": "R",
    "\U0001d412": "S",
    "\U0001d413": "T",
    "\U0001d414": "U",
    "\U0001d415": "V",
    "\U0001d416": "W",
    "\U0001d417": "X",
    "\U0001d418": "Y",
    "\U0001d419": "Z",
    "\U0001d434": "A",
    "\U0001d435": "B",
    "\U0001d436": "C",
    "\U0001d437": "D",
    "\U0001d438": "E",
    "\U0001d439": "F",
    "\U0001d43a": "G",
    "\U0001d43b": "H",
    "\U0001d43c": "I",
    "\U0001d43d": "J",
    "\U0001d43e": "K",
    "\U0001d43f": "L",
    "\U0001d440": "M",
    "\U0001d441": "N",
    "\U0001d442": "O",
    "\U0001d443": "P",
    "\U0001d444": "Q",
    "\U0001d445": "R",
    "\U0001d446": "S",
    "\U0001d447": "T",
    "\U0001d448": "U",
    "\U0001d449": "V",
    "\U0001d44a": "W",
    "\U0001d44b": "X",
    "\U0001d44c": "Y",
    "\U0001d44d": "Z",
    "\U0001d468": "A",
    "\U0001d469": "B",
    "\U0001d46a": "C",
    "\U0001d46b": "D",
    "\U0001d46c": "E",
    "\U0001d46d": "F",
    "\U0001d46e": "G",
    "\U0001d46f": "H",
    "\U0001d470": "I",
    "\U0001d471": "J",
    "\U0001d472": "K",
    "\U0001d473": "L",
    "\U0001d474": "M",
    "\U0001d475": "N",
    "\U0001d476": "O",
    "\U0001d477": "P",
    "\U0001d478": "Q",
    "\U0001d479": "R",
    "\U0001d47a": "S",
    "\U0001d47b": "T",
    "\U0001d47c": "U",
    "\U0001d47d": "V",
    "\U0001d47e": "W",
    "\U0001d47f": "X",
    "\U0001d480": "Y",
    "\U0001d481": "Z",
    "\U0001d5a0": "A",
    "\U0001d5a1": "B",
    "\U0001d5a2": "C",
    "\U0001d5a3": "D",
    "\U0001d5a4": "E",
    "\U0001d5a5": "F",
    "\U0001d5a6": "G",
    "\U0001d5a7": "H",
    "\U0001d5a8": "I",
    "\U0001d5a9": "J",
    "\U0001d5aa": "K",
    "\U0001d5ab": "L",
    "\U0001d5ac": "M",
    "\U0001d5ad": "N",
    "\U0001d5ae": "O",
    "\U0001d5af": "P",
    "\U0001d5b0": "Q",
    "\U0001d5b1": "R",
    "\U0001d5b2": "S",
    "\U0001d5b3": "T",
    "\U0001d5b4": "U",
    "\U0001d5b5": "V",
    "\U0001d5b6": "W",
    "\U0001d5b7": "X",
    "\U0001d5b8": "Y",
    "\U0001d5b9": "Z",
    "\U0001d5d4": "A",
    "\U0001d5d5": "B",
    "\U0001d5d6": "C",
    "\U0001d5d7": "D",
    "\U0001d5d8": "E",
    "\U0001d5d9": "F",
    "\U0001d5da": "G",
    "\U0001d5db": "H",
    "\U0001d5dc": "I",
    "\U0001d5dd": "J",
    "\U0001d5de": "K",
    "\U0001d5df": "L",
    "\U0001d5e0": "M",
    "\U0001d5e1": "N",
    "\U0001d5e2": "O",
    "\U0001d5e3": "P",
    "\U0001d5e4": "Q",
    "\U0001d5e5": "R",
    "\U0001d5e6": "S",
    "\U0001d5e7": "T",
    "\U0001d5e8": "U",
    "\U0001d5e9": "V",
    "\U0001d5ea": "W",
    "\U0001d5eb": "X",
    "\U0001d5ec": "Y",
    "\U0001d5ed": "Z",
    "\U0001d608": "A",
    "\U0001d609": "B",
    "\U0001d60a": "C",
    "\U0001d60b": "D",
    "\U0001d60c": "E",
    "\U0001d60d": "F",
    "\U0001d60e": "G",
    "\U0001d60f": "H",
    "\U0001d610": "I",
    "\U0001d611": "J",
    "\U0001d612": "K",
    "\U0001d613": "L",
    "\U0001d614": "M",
    "\U0001d615": "N",
    "\U0001d616": "O",
    "\U0001d617": "P",
    "\U0001d618": "Q",
    "\U0001d619": "R",
    "\U0001d61a": "S",
    "\U0001d61b": "T",
    "\U0001d61c": "U",
    "\U0001d61d": "V",
    "\U0001d61e": "W",
    "\U0001d61f": "X",
    "\U0001d620": "Y",
    "\U0001d621": "Z",
    "\U0001d63c": "A",
    "\U0001d63d": "B",
    "\U0001d63e": "C",
    "\U0001d63f": "D",
    "\U0001d640": "E",
    "\U0001d641": "F",
    "\U0001d642": "G",
    "\U0001d643": "H",
    "\U0001d644": "I",
    "\U0001d645": "J",
    "\U0001d646": "K",
    "\U0001d647": "L",
    "\U0001d648": "M",
    "\U0001d649": "N",
    "\U0001d64a": "O",
    "\U0001d64b": "P",
    "\U0001d64c": "Q",
    "\U0001d64d": "R",
    "\U0001d64e": "S",
    "\U0001d64f": "T",
    "\U0001d650": "U",
    "\U0001d651": "V",
    "\U0001d652": "W",
    "\U0001d653": "X",
    "\U0001d654": "Y",
    "\U0001d655": "Z",
    "\U0001d49c": "A",
    "\U0001d49e": "C",
    "\U0001d49f": "D",
    "\U0001d4a2": "G",
    "\U0001d4a5": "J",
    "\U0001d4a6": "K",
    "\u2112": "L",
    "\U0001d4a9": "N",
    "\U0001d4aa": "O",
    "\U0001d4ab": "P",
    "\U0001d4ac": "Q",
    "\U0001d4ae": "S",
    "\U0001d4af": "T",
    "\U0001d4b0": "U",
    "\U0001d4b1": "V",
    "\U0001d4b2": "W",
    "\U0001d4b3": "X",
    "\U0001d4b4": "Y",
    "\U0001d4b5": "Z",
    "\U0001d4d0": "A",
    "\U0001d4d1": "B",
    "\U0001d4d2": "C",
    "\U0001d4d3": "D",
    "\U0001d4d4": "E",
    "\U0001d4d5": "F",
    "\U0001d4d6": "G",
    "\U0001d4d7": "H",
    "\U0001d4d8": "I",
    "\U0001d4d9": "J",
    "\U0001d4da": "K",
    "\U0001d4db": "L",
    "\U0001d4dc": "M",
    "\U0001d4dd": "N",
    "\U0001d4de": "O",
    "\U0001d4df": "P",
    "\U0001d4e0": "Q",
    "\U0001d4e1": "R",
    "\U0001d4e2": "S",
    "\U0001d4e3": "T",
    "\U0001d4e4": "U",
    "\U0001d4e5": "V",
    "\U0001d4e6": "W",
    "\U0001d4e7": "X",
    "\U0001d4e8": "Y",
    "\U0001d4e9": "Z",
    "\U0001d504": "A",
    "\U0001d505": "B",
    "\U0001d507": "D",
    "\U0001d508": "E",
    "\U0001d509": "F",
    "\U0001d50a": "G",
    "\U0001d50d": "J",
    "\U0001d50e": "K",
    "\U0001d50f": "L",
    "\U0001d510": "M",
    "\U0001d511": "N",
    "\U0001d512": "O",
    "\U0001d513": "P",
    "\U0001d514": "Q",
    "\U0001d516": "S",
    "\U0001d517": "T",
    "\U0001d518": "U",
    "\U0001d519": "V",
    "\U0001d51a": "W",
    "\U0001d51b": "X",
    "\U0001d51c": "Y",
    "\u2128": "Z",
    "\U0001d56c": "A",
    "\U0001d56d": "B",
    "\U0001d56e": "C",
    "\U0001d56f": "D",
    "\U0001d570": "E",
    "\U0001d571": "F",
    "\U0001d572": "G",
    "\U0001d573": "H",
    "\U0001d574": "I",
    "\U0001d575": "J",
    "\U0001d576": "K",
    "\U0001d577": "L",
    "\U0001d578": "M",
    "\U0001d579": "N",
    "\U0001d57a": "O",
    "\U0001d57b": "P",
    "\U0001d57c": "Q",
    "\U0001d57d": "R",
    "\U0001d57e": "S",
    "\U0001d57f": "T",
    "\U0001d580": "U",
    "\U0001d581": "V",
    "\U0001d582": "W",
    "\U0001d583": "X",
    "\U0001d584": "Y",
    "\U0001d585": "Z",
    "\U0001d670": "A",
    "\U0001d671": "B",
    "\U0001d672": "C",
    "\U0001d673": "D",
    "\U0001d674": "E",
    "\U0001d675": "F",
    "\U0001d676": "G",
    "\U0001d677": "H",
    "\U0001d678": "I",
    "\U0001d679": "J",
    "\U0001d67a": "K",
    "\U0001d67b": "L",
    "\U0001d67c": "M",
    "\U0001d67d": "N",
    "\U0001d67e": "O",
    "\U0001d67f": "P",
    "\U0001d680": "Q",
    "\U0001d681": "R",
    "\U0001d682": "S",
    "\U0001d683": "T",
    "\U0001d684": "U",
    "\U0001d685": "V",
    "\U0001d686": "W",
    "\U0001d687": "X",
    "\U0001d688": "Y",
    "\U0001d689": "Z",
    "\U0001d538": "A",
    "\U0001d539": "B",
    "\U0001d53b": "D",
    "\U0001d53c": "E",
    "\U0001d53d": "F",
    "\U0001d53e": "G",
    "\u210d": "H",
    "\U0001d540": "I",
    "\U0001d541": "J",
    "\U0001d542": "K",
    "\U0001d543": "L",
    "\U0001d544": "M",
    "\U0001d546": "O",
    "\u211d": "R",
    "\U0001d54a": "S",
    "\U0001d54b": "T",
    "\U0001d54c": "U",
    "\U0001d54d": "V",
    "\U0001d54e": "W",
    "\U0001d54f": "X",
    "\U0001d550": "Y",
    "\U0001d41a": "a",
    "\U0001d41b": "b",
    "\U0001d41c": "c",
    "\U0001d41d": "d",
    "\U0001d41e": "e",
    "\U0001d41f": "f",
    "\U0001d420": "g",
    "\U0001d421": "h",
    "\U0001d422": "i",
    "\U0001d423": "j",
    "\U0001d424": "k",
    "\U0001d425": "l",
    "\U0001d426": "m",
    "\U0001d427": "n",
    "\U0001d428": "o",
    "\U0001d429": "p",
    "\U0001d42a": "q",
    "\U0001d42b": "r",
    "\U0001d42c": "s",
    "\U0001d42d": "t",
    "\U0001d42e": "u",
    "\U0001d42f": "v",
    "\U0001d430": "w",
    "\U0001d431": "x",
    "\U0001d432": "y",
    "\U0001d433": "z",
    "\U0001d44e": "a",
    "\U0001d44f": "b",
    "\U0001d450": "c",
    "\U0001d451": "d",
    "\U0001d452": "e",
    "\U0001d453": "f",
    "\U0001d454": "g",
    "\U0001d456": "i",
    "\U0001d457": "j",
    "\U0001d458": "k",
    "\U0001d459": "l",
    "\U0001d45a": "m",
    "\U0001d45b": "n",
    "\U0001d45c": "o",
    "\U0001d45d": "p",
    "\U0001d45e": "q",
    "\U0001d45f": "r",
    "\U0001d460": "s",
    "\U0001d461": "t",
    "\U0001d462": "u",
    "\U0001d463": "v",
    "\U0001d464": "w",
    "\U0001d465": "x",
    "\U0001d466": "y",
    "\U0001d467": "z",
    "\U0001d482": "a",
    "\U0001d483": "b",
    "\U0001d484": "c",
    "\U0001d485": "d",
    "\U0001d486": "e",
    "\U0001d487": "f",
    "\U0001d488": "g",
    "\U0001d489": "h",
    "\U0001d48a": "i",
    "\U0001d48b": "j",
    "\U0001d48c": "k",
    "\U0001d48d": "l",
    "\U0001d48e": "m",
    "\U0001d48f": "n",
    "\U0001d490": "o",
    "\U0001d491": "p",
    "\U0001d492": "q",
    "\U0001d493": "r",
    "\U0001d494": "s",
    "\U0001d495": "t",
    "\U0001d496": "u",
    "\U0001d497": "v",
    "\U0001d498": "w",
    "\U0001d499": "x",
    "\U0001d49a": "y",
    "\U0001d49b": "z",
    "\U0001d5ba": "a",
    "\U0001d5bb": "b",
    "\U0001d5bc": "c",
    "\U0001d5bd": "d",
    "\U0001d5be": "e",
    "\U0001d5bf": "f",
    "\U0001d5c0": "g",
    "\U0001d5c1": "h",
    "\U0001d5c2": "i",
    "\U0001d5c3": "j",
    "\U0001d5c4": "k",
    "\U0001d5c5": "l",
    "\U0001d5c6": "m",
    "\U0001d5c7": "n",
    "\U0001d5c8": "o",
    "\U0001d5c9": "p",
    "\U0001d5ca": "q",
    "\U0001d5cb": "r",
    "\U0001d5cc": "s",
    "\U0001d5cd": "t",
    "\U0001d5ce": "u",
    "\U0001d5cf": "v",
    "\U0001d5d0": "w",
    "\U0001d5d1": "x",
    "\U0001d5d2": "y",
    "\U0001d5d3": "z",
    "\U0001d5ee": "a",
    "\U0001d5ef": "b",
    "\U0001d5f0": "c",
    "\U0001d5f1": "d",
    "\U0001d5f2": "e",
    "\U0001d5f3": "f",
    "\U0001d5f4": "g",
    "\U0001d5f5": "h",
    "\U0001d5f6": "i",
    "\U0001d5f7": "j",
    "\U0001d5f8": "k",
    "\U0001d5f9": "l",
    "\U0001d5fa": "m",
    "\U0001d5fb": "n",
    "\U0001d5fc": "o",
    "\U0001d5fd": "p",
    "\U0001d5fe": "q",
    "\U0001d5ff": "r",
    "\U0001d600": "s",
    "\U0001d601": "t",
    "\U0001d602": "u",
    "\U0001d603": "v",
    "\U0001d604": "w",
    "\U0001d605": "x",
    "\U0001d606": "y",
    "\U0001d607": "z",
    "\U0001d622": "a",
    "\U0001d623": "b",
    "\U0001d624": "c",
    "\U0001d625": "d",
    "\U0001d626": "e",
    "\U0001d627": "f",
    "\U0001d628": "g",
    "\U0001d629": "h",
    "\U0001d62a": "i",
    "\U0001d62b": "j",
    "\U0001d62c": "k",
    "\U0001d62d": "l",
    "\U0001d62e": "m",
    "\U0001d62f": "n",
    "\U0001d630": "o",
    "\U0001d631": "p",
    "\U0001d632": "q",
    "\U0001d633": "r",
    "\U0001d634": "s",
    "\U0001d635": "t",
    "\U0001d636": "u",
    "\U0001d637": "v",
    "\U0001d638": "w",
    "\U0001d639": "x",
    "\U0001d63a": "y",
    "\U0001d63b": "z",
    "\U0001d656": "a",
    "\U0001d657": "b",
    "\U0001d658": "c",
    "\U0001d659": "d",
    "\U0001d65a": "e",
    "\U0001d65b": "f",
    "\U0001d65c": "g",
    "\U0001d65d": "h",
    "\U0001d65e": "i",
    "\U0001d65f": "j",
    "\U0001d660": "k",
    "\U0001d661": "l",
    "\U0001d662": "m",
    "\U0001d663": "n",
    "\U0001d664": "o",
    "\U0001d665": "p",
    "\U0001d666": "q",
    "\U0001d667": "r",
    "\U0001d668": "s",
    "\U0001d669": "t",
    "\U0001d66a": "u",
    "\U0001d66b": "v",
    "\U0001d66c": "w",
    "\U0001d66d": "x",
    "\U0001d66e": "y",
    "\U0001d66f": "z",
    "\U0001d4b6": "a",
    "\U0001d4b7": "b",
    "\U0001d4b8": "c",
    "\U0001d4b9": "d",
    "\U0001d4bb": "f",
    "\U0001d4bd": "h",
    "\U0001d4be": "i",
    "\U0001d4bf": "j",
    "\U0001d4c0": "k",
    "\U0001d4c1": "l",
    "\U0001d4c2": "m",
    "\U0001d4c3": "n",
    "\U0001d4c5": "p",
    "\U0001d4c6": "q",
    "\U0001d4c7": "r",
    "\U0001d4c8": "s",
    "\U0001d4c9": "t",
    "\U0001d4ca": "u",
    "\U0001d4cb": "v",
    "\U0001d4cc": "w",
    "\U0001d4cd": "x",
    "\U0001d4ce": "y",
    "\U0001d4cf": "z",
    "\U0001d4ea": "a",
    "\U0001d4eb": "b",
    "\U0001d4ec": "c",
    "\U0001d4ed": "d",
    "\U0001d4ee": "e",
    "\U0001d4ef": "f",
    "\U0001d4f0": "g",
    "\U0001d4f1": "h",
    "\U0001d4f2": "i",
    "\U0001d4f3": "j",
    "\U0001d4f4": "k",
    "\U0001d4f5": "l",
    "\U0001d4f6": "m",
    "\U0001d4f7": "n",
    "\U0001d4f8": "o",
    "\U0001d4f9": "p",
    "\U0001d4fa": "q",
    "\U0001d4fb": "r",
    "\U0001d4fc": "s",
    "\U0001d4fd": "t",
    "\U0001d4fe": "u",
    "\U0001d4ff": "v",
    "\U0001d500": "w",
    "\U0001d501": "x",
    "\U0001d502": "y",
    "\U0001d503": "z",
    "\U0001d51e": "a",
    "\U0001d51f": "b",
    "\U0001d520": "c",
    "\U0001d521": "d",
    "\U0001d522": "e",
    "\U0001d523": "f",
    "\U0001d524": "g",
    "\U0001d525": "h",
    "\U0001d526": "i",
    "\U0001d527": "j",
    "\U0001d528": "k",
    "\U0001d529": "l",
    "\U0001d52a": "m",
    "\U0001d52b": "n",
    "\U0001d52c": "o",
    "\U0001d52d": "p",
    "\U0001d52e": "q",
    "\U0001d52f": "r",
    "\U0001d530": "s",
    "\U0001d531": "t",
    "\U0001d532": "u",
    "\U0001d533": "v",
    "\U0001d534": "w",
    "\U0001d535": "x",
    "\U0001d536": "y",
    "\U0001d537": "z",
    "\U0001d586": "a",
    "\U0001d587": "b",
    "\U0001d588": "c",
    "\U0001d589": "d",
    "\U0001d58a": "e",
    "\U0001d58b": "f",
    "\U0001d58c": "g",
    "\U0001d58d": "h",
    "\U0001d58e": "i",
    "\U0001d58f": "j",
    "\U0001d590": "k",
    "\U0001d591": "l",
    "\U0001d592": "m",
    "\U0001d593": "n",
    "\U0001d594": "o",
    "\U0001d595": "p",
    "\U0001d596": "q",
    "\U0001d597": "r",
    "\U0001d598": "s",
    "\U0001d599": "t",
    "\U0001d59a": "u",
    "\U0001d59b": "v",
    "\U0001d59c": "w",
    "\U0001d59d": "x",
    "\U0001d59e": "y",
    "\U0001d59f": "z",
    "\U0001d68a": "a",
    "\U0001d68b": "b",
    "\U0001d68c": "c",
    "\U0001d68d": "d",
    "\U0001d68e": "e",
    "\U0001d68f": "f",
    "\U0001d690": "g",
    "\U0001d691": "h",
    "\U0001d692": "i",
    "\U0001d693": "j",
    "\U0001d694": "k",
    "\U0001d695": "l",
    "\U0001d696": "m",
    "\U0001d697": "n",
    "\U0001d698": "o",
    "\U0001d699": "p",
    "\U0001d69a": "q",
    "\U0001d69b": "r",
    "\U0001d69c": "s",
    "\U0001d69d": "t",
    "\U0001d69e": "u",
    "\U0001d69f": "v",
    "\U0001d6a0": "w",
    "\U0001d6a1": "x",
    "\U0001d6a2": "y",
    "\U0001d6a3": "z",
    "\U0001d552": "a",
    "\U0001d553": "b",
    "\U0001d554": "c",
    "\U0001d555": "d",
    "\U0001d556": "e",
    "\U0001d557": "f",
    "\U0001d558": "g",
    "\U0001d559": "h",
    "\U0001d55a": "i",
    "\U0001d55b": "j",
    "\U0001d55c": "k",
    "\U0001d55d": "l",
    "\U0001d55e": "m",
    "\U0001d55f": "n",
    "\U0001d560": "o",
    "\U0001d561": "p",
    "\U0001d562": "q",
    "\U0001d563": "r",
    "\U0001d564": "s",
    "\U0001d565": "t",
    "\U0001d566": "u",
    "\U0001d567": "v",
    "\U0001d568": "w",
    "\U0001d569": "x",
    "\U0001d56a": "y",
    "\U0001d56b": "z",
    "\U0001d7ce": "0",
    "\U0001d7cf": "1",
    "\U0001d7d0": "2",
    "\U0001d7d1": "3",
    "\U0001d7d2": "4",
    "\U0001d7d3": "5",
    "\U0001d7d4": "6",
    "\U0001d7d5": "7",
    "\U0001d7d6": "8",
    "\U0001d7d7": "9",
    "\U0001d7d8": "0",
    "\U0001d7d9": "1",
    "\U0001d7da": "2",
    "\U0001d7db": "3",
    "\U0001d7dc": "4",
    "\U0001d7dd": "5",
    "\U0001d7de": "6",
    "\U0001d7df": "7",
    "\U0001d7e0": "8",
    "\U0001d7e1": "9",
    "\U0001d7e2": "0",
    "\U0001d7e3": "1",
    "\U0001d7e4": "2",
    "\U0001d7e5": "3",
    "\U0001d7e6": "4",
    "\U0001d7e7": "5",
    "\U0001d7e8": "6",
    "\U0001d7e9": "7",
    "\U0001d7ea": "8",
    "\U0001d7eb": "9",
    "\U0001d7ec": "0",
    "\U0001d7ed": "1",
    "\U0001d7ee": "2",
    "\U0001d7ef": "3",
    "\U0001d7f0": "4",
    "\U0001d7f1": "5",
    "\U0001d7f2": "6",
    "\U0001d7f3": "7",
    "\U0001d7f4": "8",
    "\U0001d7f5": "9",
    "\U0001d7f6": "0",
    "\U0001d7f7": "1",
    "\U0001d7f8": "2",
    "\U0001d7f9": "3",
    "\U0001d7fa": "4",
    "\U0001d7fb": "5",
    "\U0001d7fc": "6",
    "\U0001d7fd": "7",
    "\U0001d7fe": "8",
    "\U0001d7ff": "9",
}


class Transliterator:
    """Transliterator for mathematical_alphanumerics.

    Replace mathematical alphanumeric symbols with plain characters.
    """

    def __init__(self, **_options: Any) -> None:
        """Initialize the transliterator with options.

        :param _options: Configuration options (currently unused)
        """

    def __call__(self, input_chars: Iterable[Char]) -> Iterable[Char]:
        """Replace mathematical alphanumeric symbols with plain characters."""
        offset = 0

        for char in input_chars:
            replacement = MATHEMATICAL_ALPHANUMERICS_MAPPINGS.get(char.c)
            if replacement is not None:
                yield Char(c=replacement, offset=offset, source=char)
                offset += len(replacement)
            else:
                yield char.with_offset(offset)
                offset += len(char.c)

