"""Auto-generated radicals transliterator.

Replace Kangxi radicals with equivalent CJK ideographs.
"""
from collections.abc import Iterable
from typing import Any

from ..chars import Char

__all__ = ["Transliterator"]

# Generated mapping data
RADICALS_MAPPINGS = {
    "\u2f00": "\u4e00",
    "\u2f01": "\u4e28",
    "\u2f02": "\u4e36",
    "\u2f03": "\u4e3f",
    "\u2f04": "\u4e59",
    "\u2f05": "\u4e85",
    "\u2f06": "\u4e8c",
    "\u2f07": "\u4ea0",
    "\u2f08": "\u4eba",
    "\u2f09": "\u513f",
    "\u2f0a": "\u5165",
    "\u2f0b": "\u516b",
    "\u2f0c": "\u5182",
    "\u2f0d": "\u5196",
    "\u2f0e": "\u51ab",
    "\u2f0f": "\u51e0",
    "\u2f10": "\u51f5",
    "\u2f11": "\u5200",
    "\u2f12": "\u529b",
    "\u2f13": "\u52f9",
    "\u2f14": "\u5315",
    "\u2f15": "\u531a",
    "\u2f16": "\u5338",
    "\u2f17": "\u5341",
    "\u2f18": "\u535c",
    "\u2f19": "\u5369",
    "\u2f1a": "\u5382",
    "\u2f1b": "\u53b6",
    "\u2f1c": "\u53c8",
    "\u2f1d": "\u53e3",
    "\u2f1e": "\u56d7",
    "\u2f1f": "\u571f",
    "\u2f20": "\u58eb",
    "\u2f21": "\u5902",
    "\u2f22": "\u590a",
    "\u2f23": "\u5915",
    "\u2f24": "\u5927",
    "\u2f25": "\u5973",
    "\u2f26": "\u5b50",
    "\u2f27": "\u5b80",
    "\u2f28": "\u5bf8",
    "\u2f29": "\u5c0f",
    "\u2f2a": "\u5c22",
    "\u2f2b": "\u5c38",
    "\u2f2c": "\u5c6e",
    "\u2f2d": "\u5c71",
    "\u2f2e": "\u5ddb",
    "\u2f2f": "\u5de5",
    "\u2f30": "\u5df1",
    "\u2f31": "\u5dfe",
    "\u2f32": "\u5e72",
    "\u2f33": "\u5e7a",
    "\u2f34": "\u5e7f",
    "\u2f35": "\u5ef4",
    "\u2f36": "\u5efe",
    "\u2f37": "\u5f0b",
    "\u2f38": "\u5f13",
    "\u2f39": "\u5f50",
    "\u2f3a": "\u5f61",
    "\u2f3b": "\u5f73",
    "\u2f3c": "\u5fc3",
    "\u2f3d": "\u6208",
    "\u2f3e": "\u6236",
    "\u2f3f": "\u624b",
    "\u2f40": "\u652f",
    "\u2f41": "\u6534",
    "\u2f42": "\u6587",
    "\u2f43": "\u6597",
    "\u2f44": "\u65a4",
    "\u2f45": "\u65b9",
    "\u2f46": "\u65e0",
    "\u2f47": "\u65e5",
    "\u2f48": "\u66f0",
    "\u2f49": "\u6708",
    "\u2f4a": "\u6728",
    "\u2f4b": "\u6b20",
    "\u2f4c": "\u6b62",
    "\u2f4d": "\u6b79",
    "\u2f4e": "\u6bb3",
    "\u2f4f": "\u6bcb",
    "\u2f50": "\u6bd4",
    "\u2f51": "\u6bdb",
    "\u2f52": "\u6c0f",
    "\u2f53": "\u6c14",
    "\u2f54": "\u6c34",
    "\u2f55": "\u706b",
    "\u2f56": "\u722a",
    "\u2f57": "\u7236",
    "\u2f58": "\u723b",
    "\u2f59": "\u723f",
    "\u2f5a": "\u7247",
    "\u2f5b": "\u7259",
    "\u2f5c": "\u725b",
    "\u2f5d": "\u72ac",
    "\u2f5e": "\u7384",
    "\u2f5f": "\u7389",
    "\u2f60": "\u74dc",
    "\u2f61": "\u74e6",
    "\u2f62": "\u7518",
    "\u2f63": "\u751f",
    "\u2f64": "\u7528",
    "\u2f65": "\u7530",
    "\u2f66": "\u758b",
    "\u2f67": "\u7592",
    "\u2f68": "\u7676",
    "\u2f69": "\u767d",
    "\u2f6a": "\u76ae",
    "\u2f6b": "\u76bf",
    "\u2f6c": "\u76ee",
    "\u2f6d": "\u77db",
    "\u2f6e": "\u77e2",
    "\u2f6f": "\u77f3",
    "\u2f70": "\u793a",
    "\u2f71": "\u79b8",
    "\u2f72": "\u79be",
    "\u2f73": "\u7a74",
    "\u2f74": "\u7acb",
    "\u2f75": "\u7af9",
    "\u2f76": "\u7c73",
    "\u2f77": "\u7cf8",
    "\u2f78": "\u7f36",
    "\u2f79": "\u7f51",
    "\u2f7a": "\u7f8a",
    "\u2f7b": "\u7fbd",
    "\u2f7c": "\u8001",
    "\u2f7d": "\u800c",
    "\u2f7e": "\u8012",
    "\u2f7f": "\u8033",
    "\u2f80": "\u807f",
    "\u2f81": "\u8089",
    "\u2f82": "\u81e3",
    "\u2f83": "\u81ea",
    "\u2f84": "\u81f3",
    "\u2f85": "\u81fc",
    "\u2f86": "\u820c",
    "\u2f87": "\u821b",
    "\u2f88": "\u821f",
    "\u2f89": "\u826e",
    "\u2f8a": "\u8272",
    "\u2f8b": "\u8278",
    "\u2f8c": "\u864d",
    "\u2f8d": "\u866b",
    "\u2f8e": "\u8840",
    "\u2f8f": "\u884c",
    "\u2f90": "\u8863",
    "\u2f91": "\u897e",
    "\u2f92": "\u898b",
    "\u2f93": "\u89d2",
    "\u2f94": "\u8a00",
    "\u2f95": "\u8c37",
    "\u2f96": "\u8c46",
    "\u2f97": "\u8c55",
    "\u2f98": "\u8c78",
    "\u2f99": "\u8c9d",
    "\u2f9a": "\u8d64",
    "\u2f9b": "\u8d70",
    "\u2f9c": "\u8db3",
    "\u2f9d": "\u8eab",
    "\u2f9e": "\u8eca",
    "\u2f9f": "\u8f9b",
    "\u2fa0": "\u8fb0",
    "\u2fa1": "\u8fb5",
    "\u2fa2": "\u9091",
    "\u2fa3": "\u9149",
    "\u2fa4": "\u91c6",
    "\u2fa5": "\u91cc",
    "\u2fa6": "\u91d1",
    "\u2fa7": "\u9577",
    "\u2fa8": "\u9580",
    "\u2fa9": "\u961c",
    "\u2faa": "\u96b6",
    "\u2fab": "\u96b9",
    "\u2fac": "\u96e8",
    "\u2fad": "\u9751",
    "\u2fae": "\u975e",
    "\u2faf": "\u9762",
    "\u2fb0": "\u9769",
    "\u2fb1": "\u97cb",
    "\u2fb2": "\u97ed",
    "\u2fb3": "\u97f3",
    "\u2fb4": "\u9801",
    "\u2fb5": "\u98a8",
    "\u2fb6": "\u98db",
    "\u2fb7": "\u98df",
    "\u2fb8": "\u9996",
    "\u2fb9": "\u9999",
    "\u2fba": "\u99ac",
    "\u2fbb": "\u9aa8",
    "\u2fbc": "\u9ad8",
    "\u2fbd": "\u9adf",
    "\u2fbe": "\u9b25",
    "\u2fbf": "\u9b2f",
    "\u2fc0": "\u9b32",
    "\u2fc1": "\u9b3c",
    "\u2fc2": "\u9b5a",
    "\u2fc3": "\u9ce5",
    "\u2fc4": "\u9e75",
    "\u2fc5": "\u9e7f",
    "\u2fc6": "\u9ea5",
    "\u2fc7": "\u9ebb",
    "\u2fc8": "\u9ec3",
    "\u2fc9": "\u9ecd",
    "\u2fca": "\u9ed1",
    "\u2fcb": "\u9ef9",
    "\u2fcc": "\u9efd",
    "\u2fcd": "\u9f0e",
    "\u2fce": "\u9f13",
    "\u2fcf": "\u9f20",
    "\u2fd0": "\u9f3b",
    "\u2fd1": "\u9f4a",
    "\u2fd2": "\u9f52",
    "\u2fd3": "\u9f8d",
    "\u2fd4": "\u9f9c",
    "\u2fd5": "\u9fa0",
    "\u2e80": "\u51ab",
    "\u2e81": "\u5382",
    "\u2e82": "\u4e5b",
    "\u2e83": "\u4e5a",
    "\u2e84": "\u4e59",
    "\u2e85": "\u4ebb",
    "\u2e86": "\u5182",
    "\u2e89": "\u5202",
    "\u2e8a": "\u535c",
    "\u2e8b": "\u353e",
    "\u2e8e": "\u5140",
    "\u2e8f": "\u5c23",
    "\u2e90": "\u5c22",
    "\u2e92": "\u5df3",
    "\u2e93": "\u5e7a",
    "\u2e94": "\u5f51",
    "\u2e95": "\u5f50",
    "\u2e96": "\u5fc4",
    "\u2e97": "\u38fa",
    "\u2e98": "\u624c",
    "\u2e99": "\u6535",
    "\u2e9b": "\u65e1",
    "\u2e9d": "\u6708",
    "\u2e9e": "\u6b7a",
    "\u2e9f": "\u6bcd",
    "\u2ea0": "\u6c11",
    "\u2ea1": "\u6c35",
    "\u2ea2": "\u6c3a",
    "\u2ea3": "\u706c",
    "\u2ea5": "\u722b",
    "\u2ea6": "\u4e2c",
    "\u2ea8": "\u72ad",
    "\u2eab": "\u7f52",
    "\u2eac": "\u793a",
    "\u2ead": "\u793b",
    "\u2eaf": "\u7cf9",
    "\u2eb0": "\u7e9f",
    "\u2eb1": "\u7f53",
    "\u2eb3": "\u34c1",
    "\u2eb4": "\u34c1",
    "\u2eb9": "\u8002",
    "\u2eba": "\u8080",
    "\u2ebc": "\u6708",
    "\u2ebd": "\u81fc",
    "\u2ebe": "\u8279",
    "\u2ebf": "\u8279",
    "\u2ec0": "\u8279",
    "\u2ec1": "\u864e",
    "\u2ec2": "\u8864",
    "\u2ec3": "\u8980",
    "\u2ec4": "\u897f",
    "\u2ec5": "\u89c1",
    "\u2ec8": "\u8ba0",
    "\u2ec9": "\u8d1d",
    "\u2ecb": "\u8f66",
    "\u2ecd": "\u8fb6",
    "\u2ecf": "\u961d",
    "\u2ed0": "\u9485",
    "\u2ed1": "\u9577",
    "\u2ed2": "\u9578",
    "\u2ed3": "\u957f",
    "\u2ed6": "\u961d",
    "\u2ed8": "\u9752",
    "\u2ed9": "\u97e6",
    "\u2eda": "\u9875",
    "\u2edb": "\u98ce",
    "\u2edc": "\u98de",
    "\u2edd": "\u98df",
    "\u2edf": "\u98e0",
    "\u2ee0": "\u9963",
    "\u2ee2": "\u9a6c",
    "\u2ee3": "\u9aa8",
    "\u2ee4": "\u9b3c",
    "\u2ee5": "\u9c7c",
    "\u2ee6": "\u9e1f",
    "\u2ee7": "\u5364",
    "\u2ee8": "\u9ea6",
    "\u2ee9": "\u9ec4",
    "\u2eea": "\u9efe",
    "\u2eeb": "\u6589",
    "\u2eec": "\u9f50",
    "\u2eed": "\u6b6f",
    "\u2eee": "\u9f7f",
    "\u2eef": "\u7adc",
    "\u2ef0": "\u9f99",
    "\u2ef1": "\u9f9c",
    "\u2ef2": "\u4e80",
    "\u2ef3": "\u9f9f",
}


class Transliterator:
    """Transliterator for radicals.

    Replace Kangxi radicals with equivalent CJK ideographs.
    """

    def __init__(self, **_options: Any) -> None:
        """Initialize the transliterator with options.

        :param _options: Configuration options (currently unused)
        """

    def __call__(self, input_chars: Iterable[Char]) -> Iterable[Char]:
        """Replace Kangxi radicals with equivalent CJK ideographs."""
        offset = 0

        for char in input_chars:
            replacement = RADICALS_MAPPINGS.get(char.c)
            if replacement is not None:
                yield Char(c=replacement, offset=offset, source=char)
                offset += len(replacement)
            else:
                yield char.with_offset(offset)
                offset += len(char.c)

