# pyterrier-services

PyTerrier components for online retrieval services, including:

 - DBLP
 - Pinecone
 - Semantic Scholar
 - Google Web Search

More information can be found in the [documentation](https://pyterrier.readthedocs.io/en/latest/ext/pyterrier-services).

## Example: Retrieval from Semantic Scholar

[Semantic Scholar](https://www.semanticscholar.org/me/research) is a scientific literature
search engine provided by the [Allen Institute for AI](https://allenai.org/).

`SemanticScholarApi()` provides access to the [search API](https://www.semanticscholar.org/product/api).

Example:

```python
>>> from pyterrier_services import SemanticScholarApi
>>> service = SemanticScholarApi()
>>> retriever = service.retriever()
>>> retriever.search('PyTerrier')
# qid      query                                     docno  score  rank                                              title                                           abstract
#   1  pyterrier  7fa92ed08eee68a945884b8744e7db9887aed9d3      0     0  PyTerrier: Declarative Experimentation in Pyth...  PyTerrier is a Python-based retrieval framewor...
#   1  pyterrier  a6b1126e058262c57d36012d0fdedc2417ad04e1     -1     1  Declarative Experimentation in Information Ret...  The advent of deep machine learning platforms ...
#   1  pyterrier  833b453c621099bccca028752aaa74262123706a     -2     2  PyTerrier-based Research Data Recommendations ...  Research data is of high importance in scienti...
#   1  pyterrier  73feb5cfe491342d52d47e8817d113c072067306     -3     3      The Information Retrieval Experiment Platform  We integrate irdatasets, ir_measures, and PyTe...
#   1  pyterrier  90b8a1adae2761e48c87fdeb68a595dc11161970     -4     4  QPPTK@TIREx: Simplified Query Performance Pred...  We describe our software submission to the ECI...
#   1  pyterrier  6659b3daabfb7e8e6dd8c4f47e2a774816888a9d     -5     5  Retrieving Comparative Arguments using Ensembl...  In this paper, we present a submission to the ...
#   1  pyterrier  2e503f3c23384a2112c84986c0a38c9cf6bf2488     -6     6      The Information Retrieval Experiment Platform  In this extended abstract, 1 we present the In...
#   1  pyterrier  4f901502b389e16faaf26eef7c935ecd80700f3d     -7     7  The Information Retrieval Experiment Platform ...  We have built TIREx, the information retrieval...
#   1  pyterrier  12c9b48d013255248378f23b7078e1788b5b1ef6     -8     8  Axiomatic Retrieval Experimentation with ir_ax...  Axiomatic approaches to information retrieval ...
#   1  pyterrier  b7da554d9f1f51e13a852ab0270dcd0d824c52e8     -9     9                        A Python Interface to PISA!  PISA (Performant Indexes and Search for Academ...
#   1  pyterrier  e57c05d3eb9c2d32332dc539d32e78f2b1fb05a6    -10    10  University of Glasgow Terrier Team and UFMG at...  For TREC 2020, we explore different re-ranking...
#   1  pyterrier  81ec8a40deb82470438d978b013a0f6094ec8843    -11    11  IR From Bag-of-words to BERT and Beyond throug...  The task of adhoc search is undergoing a renai...
```
