# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_ecs20140526 import models as ecs_20140526_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'cn-hangzhou': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shanghai-finance-1': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shenzhen-finance-1': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-north-2-gov-1': 'ecs.aliyuncs.com',
            'ap-northeast-2-pop': 'ecs.aliyuncs.com',
            'cn-beijing-finance-pop': 'ecs.aliyuncs.com',
            'cn-beijing-gov-1': 'ecs.aliyuncs.com',
            'cn-beijing-nu16-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-edge-1': 'ecs.cn-qingdao-nebula.aliyuncs.com',
            'cn-fujian': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-haidian-cm12-c01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-bj-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-finance': 'ecs.aliyuncs.com',
            'cn-hangzhou-internal-prod-1': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-internal-test-1': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-internal-test-2': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-internal-test-3': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hangzhou-test-306': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-hongkong-finance-pop': 'ecs.aliyuncs.com',
            'cn-huhehaote-nebula-1': 'ecs.cn-qingdao-nebula.aliyuncs.com',
            'cn-shanghai-et15-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shanghai-et2-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shanghai-inner': 'ecs.aliyuncs.com',
            'cn-shanghai-internal-test-1': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shenzhen-inner': 'ecs.aliyuncs.com',
            'cn-shenzhen-st4-d01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-shenzhen-su18-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-wuhan': 'ecs.aliyuncs.com',
            'cn-yushanfang': 'ecs.aliyuncs.com',
            'cn-zhangbei': 'ecs.aliyuncs.com',
            'cn-zhangbei-na61-b01': 'ecs-cn-hangzhou.aliyuncs.com',
            'cn-zhangjiakou-na62-a01': 'ecs.cn-zhangjiakou.aliyuncs.com',
            'cn-zhengzhou-nebula-1': 'ecs.cn-qingdao-nebula.aliyuncs.com',
            'eu-west-1-oxs': 'ecs.cn-shenzhen-cloudstone.aliyuncs.com',
            'rus-west-1-pop': 'ecs.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('ecs', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def accept_inquired_system_event_with_options(
        self,
        request: ecs_20140526_models.AcceptInquiredSystemEventRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AcceptInquiredSystemEventResponse:
        """
        @summary dubbo
        
        @param request: AcceptInquiredSystemEventRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AcceptInquiredSystemEventResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.choice):
            query['Choice'] = request.choice
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AcceptInquiredSystemEvent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AcceptInquiredSystemEventResponse(),
            self.call_api(params, req, runtime)
        )

    async def accept_inquired_system_event_with_options_async(
        self,
        request: ecs_20140526_models.AcceptInquiredSystemEventRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AcceptInquiredSystemEventResponse:
        """
        @summary dubbo
        
        @param request: AcceptInquiredSystemEventRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AcceptInquiredSystemEventResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.choice):
            query['Choice'] = request.choice
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AcceptInquiredSystemEvent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AcceptInquiredSystemEventResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def accept_inquired_system_event(
        self,
        request: ecs_20140526_models.AcceptInquiredSystemEventRequest,
    ) -> ecs_20140526_models.AcceptInquiredSystemEventResponse:
        """
        @summary dubbo
        
        @param request: AcceptInquiredSystemEventRequest
        @return: AcceptInquiredSystemEventResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.accept_inquired_system_event_with_options(request, runtime)

    async def accept_inquired_system_event_async(
        self,
        request: ecs_20140526_models.AcceptInquiredSystemEventRequest,
    ) -> ecs_20140526_models.AcceptInquiredSystemEventResponse:
        """
        @summary dubbo
        
        @param request: AcceptInquiredSystemEventRequest
        @return: AcceptInquiredSystemEventResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.accept_inquired_system_event_with_options_async(request, runtime)

    def activate_router_interface_with_options(
        self,
        request: ecs_20140526_models.ActivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ActivateRouterInterfaceResponse:
        """
        @deprecated OpenAPI ActivateRouterInterface is deprecated, please use Vpc::2016-04-28::ActivateRouterInterface instead.
        
        @summary ActivateRouterInterface
        
        @param request: ActivateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ActivateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActivateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ActivateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def activate_router_interface_with_options_async(
        self,
        request: ecs_20140526_models.ActivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ActivateRouterInterfaceResponse:
        """
        @deprecated OpenAPI ActivateRouterInterface is deprecated, please use Vpc::2016-04-28::ActivateRouterInterface instead.
        
        @summary ActivateRouterInterface
        
        @param request: ActivateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ActivateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActivateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ActivateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def activate_router_interface(
        self,
        request: ecs_20140526_models.ActivateRouterInterfaceRequest,
    ) -> ecs_20140526_models.ActivateRouterInterfaceResponse:
        """
        @deprecated OpenAPI ActivateRouterInterface is deprecated, please use Vpc::2016-04-28::ActivateRouterInterface instead.
        
        @summary ActivateRouterInterface
        
        @param request: ActivateRouterInterfaceRequest
        @return: ActivateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.activate_router_interface_with_options(request, runtime)

    async def activate_router_interface_async(
        self,
        request: ecs_20140526_models.ActivateRouterInterfaceRequest,
    ) -> ecs_20140526_models.ActivateRouterInterfaceResponse:
        """
        @deprecated OpenAPI ActivateRouterInterface is deprecated, please use Vpc::2016-04-28::ActivateRouterInterface instead.
        
        @summary ActivateRouterInterface
        
        @param request: ActivateRouterInterfaceRequest
        @return: ActivateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.activate_router_interface_with_options_async(request, runtime)

    def add_bandwidth_package_ips_with_options(
        self,
        request: ecs_20140526_models.AddBandwidthPackageIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AddBandwidthPackageIpsResponse:
        """
        @deprecated OpenAPI AddBandwidthPackageIps is deprecated, please use Vpc::2016-04-28::AddBandwidthPackageIps instead.
        
        @summary AddBandwidthPackageIps
        
        @param request: AddBandwidthPackageIpsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddBandwidthPackageIpsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_count):
            query['IpCount'] = request.ip_count
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBandwidthPackageIps',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AddBandwidthPackageIpsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_bandwidth_package_ips_with_options_async(
        self,
        request: ecs_20140526_models.AddBandwidthPackageIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AddBandwidthPackageIpsResponse:
        """
        @deprecated OpenAPI AddBandwidthPackageIps is deprecated, please use Vpc::2016-04-28::AddBandwidthPackageIps instead.
        
        @summary AddBandwidthPackageIps
        
        @param request: AddBandwidthPackageIpsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddBandwidthPackageIpsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_count):
            query['IpCount'] = request.ip_count
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBandwidthPackageIps',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AddBandwidthPackageIpsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_bandwidth_package_ips(
        self,
        request: ecs_20140526_models.AddBandwidthPackageIpsRequest,
    ) -> ecs_20140526_models.AddBandwidthPackageIpsResponse:
        """
        @deprecated OpenAPI AddBandwidthPackageIps is deprecated, please use Vpc::2016-04-28::AddBandwidthPackageIps instead.
        
        @summary AddBandwidthPackageIps
        
        @param request: AddBandwidthPackageIpsRequest
        @return: AddBandwidthPackageIpsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.add_bandwidth_package_ips_with_options(request, runtime)

    async def add_bandwidth_package_ips_async(
        self,
        request: ecs_20140526_models.AddBandwidthPackageIpsRequest,
    ) -> ecs_20140526_models.AddBandwidthPackageIpsResponse:
        """
        @deprecated OpenAPI AddBandwidthPackageIps is deprecated, please use Vpc::2016-04-28::AddBandwidthPackageIps instead.
        
        @summary AddBandwidthPackageIps
        
        @param request: AddBandwidthPackageIpsRequest
        @return: AddBandwidthPackageIpsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_bandwidth_package_ips_with_options_async(request, runtime)

    def add_tags_with_options(
        self,
        request: ecs_20140526_models.AddTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AddTagsResponse:
        """
        @deprecated OpenAPI AddTags is deprecated, please use Ecs::2014-05-26::TagResources instead.
        
        @summary Adds tags to Elastic Compute Service (ECS) resources, or overwrites tags of ECS resources. You can add tags to ECS resources such as instances, disks, snapshots, images, and security groups for easy management.
        
        @description When you call this operation, take note of the following items:
        Up to 20 tags can be added to each ECS resource.
        `Tag.N.Key` must match `Tag.N.Value` based on the value of N.
        If you add a tag that has the same key (`Tag.N.Key`) as an existing tag on the specified resource, the new tag value (`Tag.N.Value`) overwrites the original tag value.
        
        @param request: AddTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddTagsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddTags',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AddTagsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_tags_with_options_async(
        self,
        request: ecs_20140526_models.AddTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AddTagsResponse:
        """
        @deprecated OpenAPI AddTags is deprecated, please use Ecs::2014-05-26::TagResources instead.
        
        @summary Adds tags to Elastic Compute Service (ECS) resources, or overwrites tags of ECS resources. You can add tags to ECS resources such as instances, disks, snapshots, images, and security groups for easy management.
        
        @description When you call this operation, take note of the following items:
        Up to 20 tags can be added to each ECS resource.
        `Tag.N.Key` must match `Tag.N.Value` based on the value of N.
        If you add a tag that has the same key (`Tag.N.Key`) as an existing tag on the specified resource, the new tag value (`Tag.N.Value`) overwrites the original tag value.
        
        @param request: AddTagsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddTagsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddTags',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AddTagsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_tags(
        self,
        request: ecs_20140526_models.AddTagsRequest,
    ) -> ecs_20140526_models.AddTagsResponse:
        """
        @deprecated OpenAPI AddTags is deprecated, please use Ecs::2014-05-26::TagResources instead.
        
        @summary Adds tags to Elastic Compute Service (ECS) resources, or overwrites tags of ECS resources. You can add tags to ECS resources such as instances, disks, snapshots, images, and security groups for easy management.
        
        @description When you call this operation, take note of the following items:
        Up to 20 tags can be added to each ECS resource.
        `Tag.N.Key` must match `Tag.N.Value` based on the value of N.
        If you add a tag that has the same key (`Tag.N.Key`) as an existing tag on the specified resource, the new tag value (`Tag.N.Value`) overwrites the original tag value.
        
        @param request: AddTagsRequest
        @return: AddTagsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.add_tags_with_options(request, runtime)

    async def add_tags_async(
        self,
        request: ecs_20140526_models.AddTagsRequest,
    ) -> ecs_20140526_models.AddTagsResponse:
        """
        @deprecated OpenAPI AddTags is deprecated, please use Ecs::2014-05-26::TagResources instead.
        
        @summary Adds tags to Elastic Compute Service (ECS) resources, or overwrites tags of ECS resources. You can add tags to ECS resources such as instances, disks, snapshots, images, and security groups for easy management.
        
        @description When you call this operation, take note of the following items:
        Up to 20 tags can be added to each ECS resource.
        `Tag.N.Key` must match `Tag.N.Value` based on the value of N.
        If you add a tag that has the same key (`Tag.N.Key`) as an existing tag on the specified resource, the new tag value (`Tag.N.Value`) overwrites the original tag value.
        
        @param request: AddTagsRequest
        @return: AddTagsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_tags_with_options_async(request, runtime)

    def allocate_dedicated_hosts_with_options(
        self,
        request: ecs_20140526_models.AllocateDedicatedHostsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocateDedicatedHostsResponse:
        """
        @summary Creates pay-as-you-go or subscription dedicated hosts. A dedicated host is a physical server dedicated to a single tenant. You can create Elastic Compute Service (ECS) instances on a dedicated host and view the attributes of a dedicated host.
        
        @description Before you create a dedicated host, you can call the [DescribeAvailableResource](https://help.aliyun.com/document_detail/66186.html) operation to query the resources available in a specific region or zone.
        We recommend that you understand the billing methods of resources before you create a dedicated host. You are charged for resources used by the created dedicated host. For more information, see [Billing overview](https://help.aliyun.com/document_detail/68978.html).
        You can create up to 100 pay-as-you-go or subscription dedicated hosts at a time.
        After a dedicated host is created, you can use the returned dedicated host ID as the value of a request parameter to call the [DescribeDedicatedHosts](https://help.aliyun.com/document_detail/134242.html) operation to query the state of the dedicated host.
        After you submit a request to create a dedicated host, an error is returned if a specific parameter is invalid or if the requested resources are insufficient. For more information about error causes, see the "Error codes" section of this topic.
        After a dedicated host is created, you can call the [ModifyInstanceDeployment](https://help.aliyun.com/document_detail/134248.html) operation to migrate ECS instances from a shared host to the dedicated host. You can also migrate ECS instances from another dedicated host to the created dedicated host.
        
        @param request: AllocateDedicatedHostsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateDedicatedHostsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.action_on_maintenance):
            query['ActionOnMaintenance'] = request.action_on_maintenance
        if not UtilClient.is_unset(request.auto_placement):
            query['AutoPlacement'] = request.auto_placement
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cpu_over_commit_ratio):
            query['CpuOverCommitRatio'] = request.cpu_over_commit_ratio
        if not UtilClient.is_unset(request.dedicated_host_cluster_id):
            query['DedicatedHostClusterId'] = request.dedicated_host_cluster_id
        if not UtilClient.is_unset(request.dedicated_host_name):
            query['DedicatedHostName'] = request.dedicated_host_name
        if not UtilClient.is_unset(request.dedicated_host_type):
            query['DedicatedHostType'] = request.dedicated_host_type
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.min_quantity):
            query['MinQuantity'] = request.min_quantity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.quantity):
            query['Quantity'] = request.quantity
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.network_attributes):
            query['NetworkAttributes'] = request.network_attributes
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateDedicatedHosts',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocateDedicatedHostsResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_dedicated_hosts_with_options_async(
        self,
        request: ecs_20140526_models.AllocateDedicatedHostsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocateDedicatedHostsResponse:
        """
        @summary Creates pay-as-you-go or subscription dedicated hosts. A dedicated host is a physical server dedicated to a single tenant. You can create Elastic Compute Service (ECS) instances on a dedicated host and view the attributes of a dedicated host.
        
        @description Before you create a dedicated host, you can call the [DescribeAvailableResource](https://help.aliyun.com/document_detail/66186.html) operation to query the resources available in a specific region or zone.
        We recommend that you understand the billing methods of resources before you create a dedicated host. You are charged for resources used by the created dedicated host. For more information, see [Billing overview](https://help.aliyun.com/document_detail/68978.html).
        You can create up to 100 pay-as-you-go or subscription dedicated hosts at a time.
        After a dedicated host is created, you can use the returned dedicated host ID as the value of a request parameter to call the [DescribeDedicatedHosts](https://help.aliyun.com/document_detail/134242.html) operation to query the state of the dedicated host.
        After you submit a request to create a dedicated host, an error is returned if a specific parameter is invalid or if the requested resources are insufficient. For more information about error causes, see the "Error codes" section of this topic.
        After a dedicated host is created, you can call the [ModifyInstanceDeployment](https://help.aliyun.com/document_detail/134248.html) operation to migrate ECS instances from a shared host to the dedicated host. You can also migrate ECS instances from another dedicated host to the created dedicated host.
        
        @param request: AllocateDedicatedHostsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateDedicatedHostsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.action_on_maintenance):
            query['ActionOnMaintenance'] = request.action_on_maintenance
        if not UtilClient.is_unset(request.auto_placement):
            query['AutoPlacement'] = request.auto_placement
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cpu_over_commit_ratio):
            query['CpuOverCommitRatio'] = request.cpu_over_commit_ratio
        if not UtilClient.is_unset(request.dedicated_host_cluster_id):
            query['DedicatedHostClusterId'] = request.dedicated_host_cluster_id
        if not UtilClient.is_unset(request.dedicated_host_name):
            query['DedicatedHostName'] = request.dedicated_host_name
        if not UtilClient.is_unset(request.dedicated_host_type):
            query['DedicatedHostType'] = request.dedicated_host_type
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.min_quantity):
            query['MinQuantity'] = request.min_quantity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.quantity):
            query['Quantity'] = request.quantity
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.network_attributes):
            query['NetworkAttributes'] = request.network_attributes
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateDedicatedHosts',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocateDedicatedHostsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_dedicated_hosts(
        self,
        request: ecs_20140526_models.AllocateDedicatedHostsRequest,
    ) -> ecs_20140526_models.AllocateDedicatedHostsResponse:
        """
        @summary Creates pay-as-you-go or subscription dedicated hosts. A dedicated host is a physical server dedicated to a single tenant. You can create Elastic Compute Service (ECS) instances on a dedicated host and view the attributes of a dedicated host.
        
        @description Before you create a dedicated host, you can call the [DescribeAvailableResource](https://help.aliyun.com/document_detail/66186.html) operation to query the resources available in a specific region or zone.
        We recommend that you understand the billing methods of resources before you create a dedicated host. You are charged for resources used by the created dedicated host. For more information, see [Billing overview](https://help.aliyun.com/document_detail/68978.html).
        You can create up to 100 pay-as-you-go or subscription dedicated hosts at a time.
        After a dedicated host is created, you can use the returned dedicated host ID as the value of a request parameter to call the [DescribeDedicatedHosts](https://help.aliyun.com/document_detail/134242.html) operation to query the state of the dedicated host.
        After you submit a request to create a dedicated host, an error is returned if a specific parameter is invalid or if the requested resources are insufficient. For more information about error causes, see the "Error codes" section of this topic.
        After a dedicated host is created, you can call the [ModifyInstanceDeployment](https://help.aliyun.com/document_detail/134248.html) operation to migrate ECS instances from a shared host to the dedicated host. You can also migrate ECS instances from another dedicated host to the created dedicated host.
        
        @param request: AllocateDedicatedHostsRequest
        @return: AllocateDedicatedHostsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_dedicated_hosts_with_options(request, runtime)

    async def allocate_dedicated_hosts_async(
        self,
        request: ecs_20140526_models.AllocateDedicatedHostsRequest,
    ) -> ecs_20140526_models.AllocateDedicatedHostsResponse:
        """
        @summary Creates pay-as-you-go or subscription dedicated hosts. A dedicated host is a physical server dedicated to a single tenant. You can create Elastic Compute Service (ECS) instances on a dedicated host and view the attributes of a dedicated host.
        
        @description Before you create a dedicated host, you can call the [DescribeAvailableResource](https://help.aliyun.com/document_detail/66186.html) operation to query the resources available in a specific region or zone.
        We recommend that you understand the billing methods of resources before you create a dedicated host. You are charged for resources used by the created dedicated host. For more information, see [Billing overview](https://help.aliyun.com/document_detail/68978.html).
        You can create up to 100 pay-as-you-go or subscription dedicated hosts at a time.
        After a dedicated host is created, you can use the returned dedicated host ID as the value of a request parameter to call the [DescribeDedicatedHosts](https://help.aliyun.com/document_detail/134242.html) operation to query the state of the dedicated host.
        After you submit a request to create a dedicated host, an error is returned if a specific parameter is invalid or if the requested resources are insufficient. For more information about error causes, see the "Error codes" section of this topic.
        After a dedicated host is created, you can call the [ModifyInstanceDeployment](https://help.aliyun.com/document_detail/134248.html) operation to migrate ECS instances from a shared host to the dedicated host. You can also migrate ECS instances from another dedicated host to the created dedicated host.
        
        @param request: AllocateDedicatedHostsRequest
        @return: AllocateDedicatedHostsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_dedicated_hosts_with_options_async(request, runtime)

    def allocate_eip_address_with_options(
        self,
        request: ecs_20140526_models.AllocateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocateEipAddressResponse:
        """
        @deprecated OpenAPI AllocateEipAddress is deprecated, please use Vpc::2016-04-28::AllocateEipAddress instead.
        
        @summary AllocateEipAddress
        
        @description > This operation has been upgraded. We recommend that you do not use it. For information about the new version of this operation, see [AllocateEipAddress](https://help.aliyun.com/document_detail/120192.html).
        
        @param request: AllocateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateEipAddressResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activity_id):
            query['ActivityId'] = request.activity_id
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocateEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_address_with_options_async(
        self,
        request: ecs_20140526_models.AllocateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocateEipAddressResponse:
        """
        @deprecated OpenAPI AllocateEipAddress is deprecated, please use Vpc::2016-04-28::AllocateEipAddress instead.
        
        @summary AllocateEipAddress
        
        @description > This operation has been upgraded. We recommend that you do not use it. For information about the new version of this operation, see [AllocateEipAddress](https://help.aliyun.com/document_detail/120192.html).
        
        @param request: AllocateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocateEipAddressResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activity_id):
            query['ActivityId'] = request.activity_id
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocateEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_address(
        self,
        request: ecs_20140526_models.AllocateEipAddressRequest,
    ) -> ecs_20140526_models.AllocateEipAddressResponse:
        """
        @deprecated OpenAPI AllocateEipAddress is deprecated, please use Vpc::2016-04-28::AllocateEipAddress instead.
        
        @summary AllocateEipAddress
        
        @description > This operation has been upgraded. We recommend that you do not use it. For information about the new version of this operation, see [AllocateEipAddress](https://help.aliyun.com/document_detail/120192.html).
        
        @param request: AllocateEipAddressRequest
        @return: AllocateEipAddressResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_address_with_options(request, runtime)

    async def allocate_eip_address_async(
        self,
        request: ecs_20140526_models.AllocateEipAddressRequest,
    ) -> ecs_20140526_models.AllocateEipAddressResponse:
        """
        @deprecated OpenAPI AllocateEipAddress is deprecated, please use Vpc::2016-04-28::AllocateEipAddress instead.
        
        @summary AllocateEipAddress
        
        @description > This operation has been upgraded. We recommend that you do not use it. For information about the new version of this operation, see [AllocateEipAddress](https://help.aliyun.com/document_detail/120192.html).
        
        @param request: AllocateEipAddressRequest
        @return: AllocateEipAddressResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_address_with_options_async(request, runtime)

    def allocate_public_ip_address_with_options(
        self,
        request: ecs_20140526_models.AllocatePublicIpAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocatePublicIpAddressResponse:
        """
        @summary Assigns a static public IP address (also called system-assigned public IP address or auto-assigned public IP address) to an Elastic Compute Service (ECS) instance.
        
        @description ### [](#)Precautions
        The ECS instance to which you want to assign a static public IP address must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If `OperationLocks` in the response of the DescribeInstances operation contains `"LockReason" : "security"` for an ECS instance, the instance is [locked for security reasons](https://help.aliyun.com/document_detail/25695.html) and cannot be assigned a static public IP address.
        When you call the AllocatePublicIpAddress operation for an ECS instance, make sure that the public bandwidth of the instance is greater than 0 Mbit/s. You can call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to change the public bandwidth.
        ### [](#)Considerations
        Only users in the whitelist can specify `IpAddress` in the AllocatePublicIpAddress operation. If the public bandwidth of your ECS instance is greater than 0 Mbit/s, you can specify the ID of the instance (`InstanceId`) to randomly assign a static public IP address to the instance. If the public bandwidth of your ECS instance is 0 Mbit/s, you must call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to increase the public bandwidth of the instance before you call the AllocatePublicIpAddress operation.
        You can assign only one static public IP address to an ECS instance. If the instance already has a static public IP address, the static public IP address is returned for the `IpAddress` response parameter.
        After you assign a static public IP address to an ECS instance, you must restart the instance ([RebootInstance](https://help.aliyun.com/document_detail/25502.html)) or start the instance ([StartInstance](https://help.aliyun.com/document_detail/25500.html)) for the public IP address to take effect.
        If an ECS instance resides in a virtual private cloud (VPC), you can assign a static public IP address to the instance or associate an elastic IP address (EIP) with the instance. For more information, see [AssociateEipAddress](https://help.aliyun.com/document_detail/2518064.html).
        
        @param request: AllocatePublicIpAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocatePublicIpAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocatePublicIpAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocatePublicIpAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_public_ip_address_with_options_async(
        self,
        request: ecs_20140526_models.AllocatePublicIpAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AllocatePublicIpAddressResponse:
        """
        @summary Assigns a static public IP address (also called system-assigned public IP address or auto-assigned public IP address) to an Elastic Compute Service (ECS) instance.
        
        @description ### [](#)Precautions
        The ECS instance to which you want to assign a static public IP address must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If `OperationLocks` in the response of the DescribeInstances operation contains `"LockReason" : "security"` for an ECS instance, the instance is [locked for security reasons](https://help.aliyun.com/document_detail/25695.html) and cannot be assigned a static public IP address.
        When you call the AllocatePublicIpAddress operation for an ECS instance, make sure that the public bandwidth of the instance is greater than 0 Mbit/s. You can call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to change the public bandwidth.
        ### [](#)Considerations
        Only users in the whitelist can specify `IpAddress` in the AllocatePublicIpAddress operation. If the public bandwidth of your ECS instance is greater than 0 Mbit/s, you can specify the ID of the instance (`InstanceId`) to randomly assign a static public IP address to the instance. If the public bandwidth of your ECS instance is 0 Mbit/s, you must call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to increase the public bandwidth of the instance before you call the AllocatePublicIpAddress operation.
        You can assign only one static public IP address to an ECS instance. If the instance already has a static public IP address, the static public IP address is returned for the `IpAddress` response parameter.
        After you assign a static public IP address to an ECS instance, you must restart the instance ([RebootInstance](https://help.aliyun.com/document_detail/25502.html)) or start the instance ([StartInstance](https://help.aliyun.com/document_detail/25500.html)) for the public IP address to take effect.
        If an ECS instance resides in a virtual private cloud (VPC), you can assign a static public IP address to the instance or associate an elastic IP address (EIP) with the instance. For more information, see [AssociateEipAddress](https://help.aliyun.com/document_detail/2518064.html).
        
        @param request: AllocatePublicIpAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AllocatePublicIpAddressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocatePublicIpAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AllocatePublicIpAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_public_ip_address(
        self,
        request: ecs_20140526_models.AllocatePublicIpAddressRequest,
    ) -> ecs_20140526_models.AllocatePublicIpAddressResponse:
        """
        @summary Assigns a static public IP address (also called system-assigned public IP address or auto-assigned public IP address) to an Elastic Compute Service (ECS) instance.
        
        @description ### [](#)Precautions
        The ECS instance to which you want to assign a static public IP address must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If `OperationLocks` in the response of the DescribeInstances operation contains `"LockReason" : "security"` for an ECS instance, the instance is [locked for security reasons](https://help.aliyun.com/document_detail/25695.html) and cannot be assigned a static public IP address.
        When you call the AllocatePublicIpAddress operation for an ECS instance, make sure that the public bandwidth of the instance is greater than 0 Mbit/s. You can call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to change the public bandwidth.
        ### [](#)Considerations
        Only users in the whitelist can specify `IpAddress` in the AllocatePublicIpAddress operation. If the public bandwidth of your ECS instance is greater than 0 Mbit/s, you can specify the ID of the instance (`InstanceId`) to randomly assign a static public IP address to the instance. If the public bandwidth of your ECS instance is 0 Mbit/s, you must call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to increase the public bandwidth of the instance before you call the AllocatePublicIpAddress operation.
        You can assign only one static public IP address to an ECS instance. If the instance already has a static public IP address, the static public IP address is returned for the `IpAddress` response parameter.
        After you assign a static public IP address to an ECS instance, you must restart the instance ([RebootInstance](https://help.aliyun.com/document_detail/25502.html)) or start the instance ([StartInstance](https://help.aliyun.com/document_detail/25500.html)) for the public IP address to take effect.
        If an ECS instance resides in a virtual private cloud (VPC), you can assign a static public IP address to the instance or associate an elastic IP address (EIP) with the instance. For more information, see [AssociateEipAddress](https://help.aliyun.com/document_detail/2518064.html).
        
        @param request: AllocatePublicIpAddressRequest
        @return: AllocatePublicIpAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.allocate_public_ip_address_with_options(request, runtime)

    async def allocate_public_ip_address_async(
        self,
        request: ecs_20140526_models.AllocatePublicIpAddressRequest,
    ) -> ecs_20140526_models.AllocatePublicIpAddressResponse:
        """
        @summary Assigns a static public IP address (also called system-assigned public IP address or auto-assigned public IP address) to an Elastic Compute Service (ECS) instance.
        
        @description ### [](#)Precautions
        The ECS instance to which you want to assign a static public IP address must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If `OperationLocks` in the response of the DescribeInstances operation contains `"LockReason" : "security"` for an ECS instance, the instance is [locked for security reasons](https://help.aliyun.com/document_detail/25695.html) and cannot be assigned a static public IP address.
        When you call the AllocatePublicIpAddress operation for an ECS instance, make sure that the public bandwidth of the instance is greater than 0 Mbit/s. You can call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to change the public bandwidth.
        ### [](#)Considerations
        Only users in the whitelist can specify `IpAddress` in the AllocatePublicIpAddress operation. If the public bandwidth of your ECS instance is greater than 0 Mbit/s, you can specify the ID of the instance (`InstanceId`) to randomly assign a static public IP address to the instance. If the public bandwidth of your ECS instance is 0 Mbit/s, you must call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to increase the public bandwidth of the instance before you call the AllocatePublicIpAddress operation.
        You can assign only one static public IP address to an ECS instance. If the instance already has a static public IP address, the static public IP address is returned for the `IpAddress` response parameter.
        After you assign a static public IP address to an ECS instance, you must restart the instance ([RebootInstance](https://help.aliyun.com/document_detail/25502.html)) or start the instance ([StartInstance](https://help.aliyun.com/document_detail/25500.html)) for the public IP address to take effect.
        If an ECS instance resides in a virtual private cloud (VPC), you can assign a static public IP address to the instance or associate an elastic IP address (EIP) with the instance. For more information, see [AssociateEipAddress](https://help.aliyun.com/document_detail/2518064.html).
        
        @param request: AllocatePublicIpAddressRequest
        @return: AllocatePublicIpAddressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.allocate_public_ip_address_with_options_async(request, runtime)

    def apply_auto_snapshot_policy_with_options(
        self,
        request: ecs_20140526_models.ApplyAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ApplyAutoSnapshotPolicyResponse:
        """
        @summary Applies an automatic snapshot policy to one or more cloud disks. You can call this operation to replace the automatic snapshot policy of a cloud disk.
        
        @description ## [](#)Usage notes
        When you call this operation, note that:
        You can apply only one automatic snapshot policy to each disk.
        You can apply a single automatic snapshot policy to multiple disks.
        Feature changes:
        By default, only one policy can be applied to a single disk. After the feature is upgraded, a maximum of 10 automatic snapshot policies can be applied to a single disk at the same time to meet the backup requirements of multiple scenarios.
        If you need to apply for a whitelist to upgrade the feature, [submit a ticket](https://smartservice.console.aliyun.com/service/create-ticket).
        After you upgrade the feature, take note of the following:
        Each cloud disk supports up to 10 automatic snapshot policies.
        If the target cloud disk already has an automatic snapshot policy applied, calling this operation will add to the existing policy rather than replace it.
        > To avoid unexpected fees, cancel the automatic snapshot policies that you no longer need.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['autoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.disk_ids):
            query['diskIds'] = request.disk_ids
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ApplyAutoSnapshotPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def apply_auto_snapshot_policy_with_options_async(
        self,
        request: ecs_20140526_models.ApplyAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ApplyAutoSnapshotPolicyResponse:
        """
        @summary Applies an automatic snapshot policy to one or more cloud disks. You can call this operation to replace the automatic snapshot policy of a cloud disk.
        
        @description ## [](#)Usage notes
        When you call this operation, note that:
        You can apply only one automatic snapshot policy to each disk.
        You can apply a single automatic snapshot policy to multiple disks.
        Feature changes:
        By default, only one policy can be applied to a single disk. After the feature is upgraded, a maximum of 10 automatic snapshot policies can be applied to a single disk at the same time to meet the backup requirements of multiple scenarios.
        If you need to apply for a whitelist to upgrade the feature, [submit a ticket](https://smartservice.console.aliyun.com/service/create-ticket).
        After you upgrade the feature, take note of the following:
        Each cloud disk supports up to 10 automatic snapshot policies.
        If the target cloud disk already has an automatic snapshot policy applied, calling this operation will add to the existing policy rather than replace it.
        > To avoid unexpected fees, cancel the automatic snapshot policies that you no longer need.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ApplyAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['autoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.disk_ids):
            query['diskIds'] = request.disk_ids
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ApplyAutoSnapshotPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def apply_auto_snapshot_policy(
        self,
        request: ecs_20140526_models.ApplyAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.ApplyAutoSnapshotPolicyResponse:
        """
        @summary Applies an automatic snapshot policy to one or more cloud disks. You can call this operation to replace the automatic snapshot policy of a cloud disk.
        
        @description ## [](#)Usage notes
        When you call this operation, note that:
        You can apply only one automatic snapshot policy to each disk.
        You can apply a single automatic snapshot policy to multiple disks.
        Feature changes:
        By default, only one policy can be applied to a single disk. After the feature is upgraded, a maximum of 10 automatic snapshot policies can be applied to a single disk at the same time to meet the backup requirements of multiple scenarios.
        If you need to apply for a whitelist to upgrade the feature, [submit a ticket](https://smartservice.console.aliyun.com/service/create-ticket).
        After you upgrade the feature, take note of the following:
        Each cloud disk supports up to 10 automatic snapshot policies.
        If the target cloud disk already has an automatic snapshot policy applied, calling this operation will add to the existing policy rather than replace it.
        > To avoid unexpected fees, cancel the automatic snapshot policies that you no longer need.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @return: ApplyAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.apply_auto_snapshot_policy_with_options(request, runtime)

    async def apply_auto_snapshot_policy_async(
        self,
        request: ecs_20140526_models.ApplyAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.ApplyAutoSnapshotPolicyResponse:
        """
        @summary Applies an automatic snapshot policy to one or more cloud disks. You can call this operation to replace the automatic snapshot policy of a cloud disk.
        
        @description ## [](#)Usage notes
        When you call this operation, note that:
        You can apply only one automatic snapshot policy to each disk.
        You can apply a single automatic snapshot policy to multiple disks.
        Feature changes:
        By default, only one policy can be applied to a single disk. After the feature is upgraded, a maximum of 10 automatic snapshot policies can be applied to a single disk at the same time to meet the backup requirements of multiple scenarios.
        If you need to apply for a whitelist to upgrade the feature, [submit a ticket](https://smartservice.console.aliyun.com/service/create-ticket).
        After you upgrade the feature, take note of the following:
        Each cloud disk supports up to 10 automatic snapshot policies.
        If the target cloud disk already has an automatic snapshot policy applied, calling this operation will add to the existing policy rather than replace it.
        > To avoid unexpected fees, cancel the automatic snapshot policies that you no longer need.
        
        @param request: ApplyAutoSnapshotPolicyRequest
        @return: ApplyAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.apply_auto_snapshot_policy_with_options_async(request, runtime)

    def assign_ipv_6addresses_with_options(
        self,
        request: ecs_20140526_models.AssignIpv6AddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssignIpv6AddressesResponse:
        """
        @summary Assigns one or more IPv6 addresses to an elastic network interface (ENI).
        
        @description ## [](#)Usage notes
        You can specify IPv6 addresses in the CIDR block of the vSwitch to which the ENI is connected. You can also specify the number of IPv6 addresses that the system assigns to the ENI. Take note of the following items:
        IPv6 must be enabled on the vSwitch to which the ENI is connected. For more information, see [Enable IPv6 for a vSwitch](https://help.aliyun.com/document_detail/98923.html).
        The ENI must be in the Available (Available) or InUse (InUse) state.
        If you want to assign IPv6 addresses to a primary ENI, make sure that the Elastic Compute Service (ECS) instance to which the ENI is attached is in the Running (Running) or Stopped (Stopped) state.
        The maximum number of IPv6 addresses that can be assigned to an ENI varies based on the instance type of the instance to which the ENI is attached.
        If the ENI is in the Available (Available) state, up to 10 IPv6 addresses can be assigned to the ENI.
        If the ENI is attached to an ECS instance, the maximum number of IPv6 addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        After the operation is called, you can obtain the IPv6 addresses that are assigned to the ENI from the response.
        
        @param request: AssignIpv6AddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssignIpv6AddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.ipv_6prefix):
            query['Ipv6Prefix'] = request.ipv_6prefix
        if not UtilClient.is_unset(request.ipv_6prefix_count):
            query['Ipv6PrefixCount'] = request.ipv_6prefix_count
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssignIpv6Addresses',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssignIpv6AddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def assign_ipv_6addresses_with_options_async(
        self,
        request: ecs_20140526_models.AssignIpv6AddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssignIpv6AddressesResponse:
        """
        @summary Assigns one or more IPv6 addresses to an elastic network interface (ENI).
        
        @description ## [](#)Usage notes
        You can specify IPv6 addresses in the CIDR block of the vSwitch to which the ENI is connected. You can also specify the number of IPv6 addresses that the system assigns to the ENI. Take note of the following items:
        IPv6 must be enabled on the vSwitch to which the ENI is connected. For more information, see [Enable IPv6 for a vSwitch](https://help.aliyun.com/document_detail/98923.html).
        The ENI must be in the Available (Available) or InUse (InUse) state.
        If you want to assign IPv6 addresses to a primary ENI, make sure that the Elastic Compute Service (ECS) instance to which the ENI is attached is in the Running (Running) or Stopped (Stopped) state.
        The maximum number of IPv6 addresses that can be assigned to an ENI varies based on the instance type of the instance to which the ENI is attached.
        If the ENI is in the Available (Available) state, up to 10 IPv6 addresses can be assigned to the ENI.
        If the ENI is attached to an ECS instance, the maximum number of IPv6 addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        After the operation is called, you can obtain the IPv6 addresses that are assigned to the ENI from the response.
        
        @param request: AssignIpv6AddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssignIpv6AddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.ipv_6prefix):
            query['Ipv6Prefix'] = request.ipv_6prefix
        if not UtilClient.is_unset(request.ipv_6prefix_count):
            query['Ipv6PrefixCount'] = request.ipv_6prefix_count
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssignIpv6Addresses',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssignIpv6AddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def assign_ipv_6addresses(
        self,
        request: ecs_20140526_models.AssignIpv6AddressesRequest,
    ) -> ecs_20140526_models.AssignIpv6AddressesResponse:
        """
        @summary Assigns one or more IPv6 addresses to an elastic network interface (ENI).
        
        @description ## [](#)Usage notes
        You can specify IPv6 addresses in the CIDR block of the vSwitch to which the ENI is connected. You can also specify the number of IPv6 addresses that the system assigns to the ENI. Take note of the following items:
        IPv6 must be enabled on the vSwitch to which the ENI is connected. For more information, see [Enable IPv6 for a vSwitch](https://help.aliyun.com/document_detail/98923.html).
        The ENI must be in the Available (Available) or InUse (InUse) state.
        If you want to assign IPv6 addresses to a primary ENI, make sure that the Elastic Compute Service (ECS) instance to which the ENI is attached is in the Running (Running) or Stopped (Stopped) state.
        The maximum number of IPv6 addresses that can be assigned to an ENI varies based on the instance type of the instance to which the ENI is attached.
        If the ENI is in the Available (Available) state, up to 10 IPv6 addresses can be assigned to the ENI.
        If the ENI is attached to an ECS instance, the maximum number of IPv6 addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        After the operation is called, you can obtain the IPv6 addresses that are assigned to the ENI from the response.
        
        @param request: AssignIpv6AddressesRequest
        @return: AssignIpv6AddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.assign_ipv_6addresses_with_options(request, runtime)

    async def assign_ipv_6addresses_async(
        self,
        request: ecs_20140526_models.AssignIpv6AddressesRequest,
    ) -> ecs_20140526_models.AssignIpv6AddressesResponse:
        """
        @summary Assigns one or more IPv6 addresses to an elastic network interface (ENI).
        
        @description ## [](#)Usage notes
        You can specify IPv6 addresses in the CIDR block of the vSwitch to which the ENI is connected. You can also specify the number of IPv6 addresses that the system assigns to the ENI. Take note of the following items:
        IPv6 must be enabled on the vSwitch to which the ENI is connected. For more information, see [Enable IPv6 for a vSwitch](https://help.aliyun.com/document_detail/98923.html).
        The ENI must be in the Available (Available) or InUse (InUse) state.
        If you want to assign IPv6 addresses to a primary ENI, make sure that the Elastic Compute Service (ECS) instance to which the ENI is attached is in the Running (Running) or Stopped (Stopped) state.
        The maximum number of IPv6 addresses that can be assigned to an ENI varies based on the instance type of the instance to which the ENI is attached.
        If the ENI is in the Available (Available) state, up to 10 IPv6 addresses can be assigned to the ENI.
        If the ENI is attached to an ECS instance, the maximum number of IPv6 addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        After the operation is called, you can obtain the IPv6 addresses that are assigned to the ENI from the response.
        
        @param request: AssignIpv6AddressesRequest
        @return: AssignIpv6AddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.assign_ipv_6addresses_with_options_async(request, runtime)

    def assign_private_ip_addresses_with_options(
        self,
        request: ecs_20140526_models.AssignPrivateIpAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssignPrivateIpAddressesResponse:
        """
        @summary Assigns secondary private IP addresses to an elastic network interface (ENI). You can specify available private IP addresses within the CIDR block of the vSwitch that is connected to the ENI. Alternatively, you can specify the number of private IP addresses that are automatically assigned from the CIDR block of the vSwitch to the ENI.
        
        @description ## [](#)Usage notes
        The ENI to which you want to assign IP prefixes must be in the Available (Available) or InUse (InUse) state.
        When you assign private IP addresses to a primary ENI, the Elastic Compute Service (ECS) instance to which the ENI is attached must be in the Running (Running) or Stopped (Stopped) state.
        When an ENI is in the Available state, you can assign up to 49 secondary private IP addresses to the ENI. When an ENI is attached to an instance, the number of secondary private IP addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        After the operation is called, you can obtain the assigned secondary private IP addresses from the response.
        
        @param request: AssignPrivateIpAddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssignPrivateIpAddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_4prefix):
            query['Ipv4Prefix'] = request.ipv_4prefix
        if not UtilClient.is_unset(request.ipv_4prefix_count):
            query['Ipv4PrefixCount'] = request.ipv_4prefix_count
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.secondary_private_ip_address_count):
            query['SecondaryPrivateIpAddressCount'] = request.secondary_private_ip_address_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssignPrivateIpAddresses',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssignPrivateIpAddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def assign_private_ip_addresses_with_options_async(
        self,
        request: ecs_20140526_models.AssignPrivateIpAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssignPrivateIpAddressesResponse:
        """
        @summary Assigns secondary private IP addresses to an elastic network interface (ENI). You can specify available private IP addresses within the CIDR block of the vSwitch that is connected to the ENI. Alternatively, you can specify the number of private IP addresses that are automatically assigned from the CIDR block of the vSwitch to the ENI.
        
        @description ## [](#)Usage notes
        The ENI to which you want to assign IP prefixes must be in the Available (Available) or InUse (InUse) state.
        When you assign private IP addresses to a primary ENI, the Elastic Compute Service (ECS) instance to which the ENI is attached must be in the Running (Running) or Stopped (Stopped) state.
        When an ENI is in the Available state, you can assign up to 49 secondary private IP addresses to the ENI. When an ENI is attached to an instance, the number of secondary private IP addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        After the operation is called, you can obtain the assigned secondary private IP addresses from the response.
        
        @param request: AssignPrivateIpAddressesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssignPrivateIpAddressesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_4prefix):
            query['Ipv4Prefix'] = request.ipv_4prefix
        if not UtilClient.is_unset(request.ipv_4prefix_count):
            query['Ipv4PrefixCount'] = request.ipv_4prefix_count
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.secondary_private_ip_address_count):
            query['SecondaryPrivateIpAddressCount'] = request.secondary_private_ip_address_count
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssignPrivateIpAddresses',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssignPrivateIpAddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def assign_private_ip_addresses(
        self,
        request: ecs_20140526_models.AssignPrivateIpAddressesRequest,
    ) -> ecs_20140526_models.AssignPrivateIpAddressesResponse:
        """
        @summary Assigns secondary private IP addresses to an elastic network interface (ENI). You can specify available private IP addresses within the CIDR block of the vSwitch that is connected to the ENI. Alternatively, you can specify the number of private IP addresses that are automatically assigned from the CIDR block of the vSwitch to the ENI.
        
        @description ## [](#)Usage notes
        The ENI to which you want to assign IP prefixes must be in the Available (Available) or InUse (InUse) state.
        When you assign private IP addresses to a primary ENI, the Elastic Compute Service (ECS) instance to which the ENI is attached must be in the Running (Running) or Stopped (Stopped) state.
        When an ENI is in the Available state, you can assign up to 49 secondary private IP addresses to the ENI. When an ENI is attached to an instance, the number of secondary private IP addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        After the operation is called, you can obtain the assigned secondary private IP addresses from the response.
        
        @param request: AssignPrivateIpAddressesRequest
        @return: AssignPrivateIpAddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.assign_private_ip_addresses_with_options(request, runtime)

    async def assign_private_ip_addresses_async(
        self,
        request: ecs_20140526_models.AssignPrivateIpAddressesRequest,
    ) -> ecs_20140526_models.AssignPrivateIpAddressesResponse:
        """
        @summary Assigns secondary private IP addresses to an elastic network interface (ENI). You can specify available private IP addresses within the CIDR block of the vSwitch that is connected to the ENI. Alternatively, you can specify the number of private IP addresses that are automatically assigned from the CIDR block of the vSwitch to the ENI.
        
        @description ## [](#)Usage notes
        The ENI to which you want to assign IP prefixes must be in the Available (Available) or InUse (InUse) state.
        When you assign private IP addresses to a primary ENI, the Elastic Compute Service (ECS) instance to which the ENI is attached must be in the Running (Running) or Stopped (Stopped) state.
        When an ENI is in the Available state, you can assign up to 49 secondary private IP addresses to the ENI. When an ENI is attached to an instance, the number of secondary private IP addresses that can be assigned to the ENI varies based on the instance type. For more information, see [Overview of instance families](https://help.aliyun.com/document_detail/25378.html).
        After the operation is called, you can obtain the assigned secondary private IP addresses from the response.
        
        @param request: AssignPrivateIpAddressesRequest
        @return: AssignPrivateIpAddressesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.assign_private_ip_addresses_with_options_async(request, runtime)

    def associate_eip_address_with_options(
        self,
        request: ecs_20140526_models.AssociateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssociateEipAddressResponse:
        """
        @deprecated OpenAPI AssociateEipAddress is deprecated, please use Vpc::2016-04-28::AssociateEipAddress instead.
        
        @summary AssociateEipAddress
        
        @param request: AssociateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateEipAddressResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEipAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssociateEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_eip_address_with_options_async(
        self,
        request: ecs_20140526_models.AssociateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssociateEipAddressResponse:
        """
        @deprecated OpenAPI AssociateEipAddress is deprecated, please use Vpc::2016-04-28::AssociateEipAddress instead.
        
        @summary AssociateEipAddress
        
        @param request: AssociateEipAddressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateEipAddressResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEipAddress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssociateEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_eip_address(
        self,
        request: ecs_20140526_models.AssociateEipAddressRequest,
    ) -> ecs_20140526_models.AssociateEipAddressResponse:
        """
        @deprecated OpenAPI AssociateEipAddress is deprecated, please use Vpc::2016-04-28::AssociateEipAddress instead.
        
        @summary AssociateEipAddress
        
        @param request: AssociateEipAddressRequest
        @return: AssociateEipAddressResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_eip_address_with_options(request, runtime)

    async def associate_eip_address_async(
        self,
        request: ecs_20140526_models.AssociateEipAddressRequest,
    ) -> ecs_20140526_models.AssociateEipAddressResponse:
        """
        @deprecated OpenAPI AssociateEipAddress is deprecated, please use Vpc::2016-04-28::AssociateEipAddress instead.
        
        @summary AssociateEipAddress
        
        @param request: AssociateEipAddressRequest
        @return: AssociateEipAddressResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_eip_address_with_options_async(request, runtime)

    def associate_ha_vip_with_options(
        self,
        request: ecs_20140526_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssociateHaVipResponse:
        """
        @deprecated OpenAPI AssociateHaVip is deprecated, please use Vpc::2016-04-28::AssociateHaVip instead.
        
        @summary AssociateHaVip
        
        @param request: AssociateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssociateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_ha_vip_with_options_async(
        self,
        request: ecs_20140526_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AssociateHaVipResponse:
        """
        @deprecated OpenAPI AssociateHaVip is deprecated, please use Vpc::2016-04-28::AssociateHaVip instead.
        
        @summary AssociateHaVip
        
        @param request: AssociateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AssociateHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AssociateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_ha_vip(
        self,
        request: ecs_20140526_models.AssociateHaVipRequest,
    ) -> ecs_20140526_models.AssociateHaVipResponse:
        """
        @deprecated OpenAPI AssociateHaVip is deprecated, please use Vpc::2016-04-28::AssociateHaVip instead.
        
        @summary AssociateHaVip
        
        @param request: AssociateHaVipRequest
        @return: AssociateHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.associate_ha_vip_with_options(request, runtime)

    async def associate_ha_vip_async(
        self,
        request: ecs_20140526_models.AssociateHaVipRequest,
    ) -> ecs_20140526_models.AssociateHaVipResponse:
        """
        @deprecated OpenAPI AssociateHaVip is deprecated, please use Vpc::2016-04-28::AssociateHaVip instead.
        
        @summary AssociateHaVip
        
        @param request: AssociateHaVipRequest
        @return: AssociateHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.associate_ha_vip_with_options_async(request, runtime)

    def attach_classic_link_vpc_with_options(
        self,
        request: ecs_20140526_models.AttachClassicLinkVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachClassicLinkVpcResponse:
        """
        @summary Links an instance that is deployed in the classic network to a virtual private cloud (VPC) by establishing a ClassicLink connection between the instance and the VPC. This way, the instance can communicate with cloud resources in the VPC over the internal network.
        
        @description When you call this operation, take note of the following items:
        The instance that you want to connect to a VPC must be in the **Running** or **Stopped** state.
        The ClassicLink feature must be enabled for the destination VPC. For more information, see [Create a ClassicLink connection](https://help.aliyun.com/document_detail/65413.html).
        The instance and the VPC must reside in the same region.
        
        @param request: AttachClassicLinkVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachClassicLinkVpcResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachClassicLinkVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachClassicLinkVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_classic_link_vpc_with_options_async(
        self,
        request: ecs_20140526_models.AttachClassicLinkVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachClassicLinkVpcResponse:
        """
        @summary Links an instance that is deployed in the classic network to a virtual private cloud (VPC) by establishing a ClassicLink connection between the instance and the VPC. This way, the instance can communicate with cloud resources in the VPC over the internal network.
        
        @description When you call this operation, take note of the following items:
        The instance that you want to connect to a VPC must be in the **Running** or **Stopped** state.
        The ClassicLink feature must be enabled for the destination VPC. For more information, see [Create a ClassicLink connection](https://help.aliyun.com/document_detail/65413.html).
        The instance and the VPC must reside in the same region.
        
        @param request: AttachClassicLinkVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachClassicLinkVpcResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachClassicLinkVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachClassicLinkVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_classic_link_vpc(
        self,
        request: ecs_20140526_models.AttachClassicLinkVpcRequest,
    ) -> ecs_20140526_models.AttachClassicLinkVpcResponse:
        """
        @summary Links an instance that is deployed in the classic network to a virtual private cloud (VPC) by establishing a ClassicLink connection between the instance and the VPC. This way, the instance can communicate with cloud resources in the VPC over the internal network.
        
        @description When you call this operation, take note of the following items:
        The instance that you want to connect to a VPC must be in the **Running** or **Stopped** state.
        The ClassicLink feature must be enabled for the destination VPC. For more information, see [Create a ClassicLink connection](https://help.aliyun.com/document_detail/65413.html).
        The instance and the VPC must reside in the same region.
        
        @param request: AttachClassicLinkVpcRequest
        @return: AttachClassicLinkVpcResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_classic_link_vpc_with_options(request, runtime)

    async def attach_classic_link_vpc_async(
        self,
        request: ecs_20140526_models.AttachClassicLinkVpcRequest,
    ) -> ecs_20140526_models.AttachClassicLinkVpcResponse:
        """
        @summary Links an instance that is deployed in the classic network to a virtual private cloud (VPC) by establishing a ClassicLink connection between the instance and the VPC. This way, the instance can communicate with cloud resources in the VPC over the internal network.
        
        @description When you call this operation, take note of the following items:
        The instance that you want to connect to a VPC must be in the **Running** or **Stopped** state.
        The ClassicLink feature must be enabled for the destination VPC. For more information, see [Create a ClassicLink connection](https://help.aliyun.com/document_detail/65413.html).
        The instance and the VPC must reside in the same region.
        
        @param request: AttachClassicLinkVpcRequest
        @return: AttachClassicLinkVpcResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_classic_link_vpc_with_options_async(request, runtime)

    def attach_disk_with_options(
        self,
        request: ecs_20140526_models.AttachDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachDiskResponse:
        """
        @summary Attaches a pay-as-you-go data disk or a system disk to an Elastic Compute Service (ECS) instance.
        
        @description Take note of the following items:
        The ECS instance and the disk must reside in the same zone.
        The disk must be in the **Unattached** (`Available`) state.
        When you attach the disk as a data disk to an ECS instance, take note of the following items:
        The ECS instance must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If the disk was separately purchased, the billing method of the disk must be pay-as-you-go.
        If the disk is a system disk that was detached from an ECS instance, no limits apply to the billing method of the disk.
        If the disk is an elastic ephemeral disk that was detached from an ECS instance, the disk can be attached only to the instance.
        When you attach the disk as the system disk to an ECS instance, take note of the following items:
        The ECS instance must be the original instance from which the system disk was detached.
        The ECS instance must be in the **Stopped** (`Stopped`) state.
        You must configure logon credentials for the ECS instance.
        The disk cannot be an elastic ephemeral disk.
        For more information about how to attach a system disk, see [Detach or attach a system disk](https://help.aliyun.com/document_detail/146752.html).
        If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query information about an ECS instance, the instance is locked for security reasons. No operations are allowed on the instance.
        
        @param request: AttachDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bootable):
            query['Bootable'] = request.bootable
        if not UtilClient.is_unset(request.delete_with_instance):
            query['DeleteWithInstance'] = request.delete_with_instance
        if not UtilClient.is_unset(request.device):
            query['Device'] = request.device
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachDiskResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_disk_with_options_async(
        self,
        request: ecs_20140526_models.AttachDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachDiskResponse:
        """
        @summary Attaches a pay-as-you-go data disk or a system disk to an Elastic Compute Service (ECS) instance.
        
        @description Take note of the following items:
        The ECS instance and the disk must reside in the same zone.
        The disk must be in the **Unattached** (`Available`) state.
        When you attach the disk as a data disk to an ECS instance, take note of the following items:
        The ECS instance must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If the disk was separately purchased, the billing method of the disk must be pay-as-you-go.
        If the disk is a system disk that was detached from an ECS instance, no limits apply to the billing method of the disk.
        If the disk is an elastic ephemeral disk that was detached from an ECS instance, the disk can be attached only to the instance.
        When you attach the disk as the system disk to an ECS instance, take note of the following items:
        The ECS instance must be the original instance from which the system disk was detached.
        The ECS instance must be in the **Stopped** (`Stopped`) state.
        You must configure logon credentials for the ECS instance.
        The disk cannot be an elastic ephemeral disk.
        For more information about how to attach a system disk, see [Detach or attach a system disk](https://help.aliyun.com/document_detail/146752.html).
        If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query information about an ECS instance, the instance is locked for security reasons. No operations are allowed on the instance.
        
        @param request: AttachDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bootable):
            query['Bootable'] = request.bootable
        if not UtilClient.is_unset(request.delete_with_instance):
            query['DeleteWithInstance'] = request.delete_with_instance
        if not UtilClient.is_unset(request.device):
            query['Device'] = request.device
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachDiskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_disk(
        self,
        request: ecs_20140526_models.AttachDiskRequest,
    ) -> ecs_20140526_models.AttachDiskResponse:
        """
        @summary Attaches a pay-as-you-go data disk or a system disk to an Elastic Compute Service (ECS) instance.
        
        @description Take note of the following items:
        The ECS instance and the disk must reside in the same zone.
        The disk must be in the **Unattached** (`Available`) state.
        When you attach the disk as a data disk to an ECS instance, take note of the following items:
        The ECS instance must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If the disk was separately purchased, the billing method of the disk must be pay-as-you-go.
        If the disk is a system disk that was detached from an ECS instance, no limits apply to the billing method of the disk.
        If the disk is an elastic ephemeral disk that was detached from an ECS instance, the disk can be attached only to the instance.
        When you attach the disk as the system disk to an ECS instance, take note of the following items:
        The ECS instance must be the original instance from which the system disk was detached.
        The ECS instance must be in the **Stopped** (`Stopped`) state.
        You must configure logon credentials for the ECS instance.
        The disk cannot be an elastic ephemeral disk.
        For more information about how to attach a system disk, see [Detach or attach a system disk](https://help.aliyun.com/document_detail/146752.html).
        If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query information about an ECS instance, the instance is locked for security reasons. No operations are allowed on the instance.
        
        @param request: AttachDiskRequest
        @return: AttachDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_disk_with_options(request, runtime)

    async def attach_disk_async(
        self,
        request: ecs_20140526_models.AttachDiskRequest,
    ) -> ecs_20140526_models.AttachDiskResponse:
        """
        @summary Attaches a pay-as-you-go data disk or a system disk to an Elastic Compute Service (ECS) instance.
        
        @description Take note of the following items:
        The ECS instance and the disk must reside in the same zone.
        The disk must be in the **Unattached** (`Available`) state.
        When you attach the disk as a data disk to an ECS instance, take note of the following items:
        The ECS instance must be in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If the disk was separately purchased, the billing method of the disk must be pay-as-you-go.
        If the disk is a system disk that was detached from an ECS instance, no limits apply to the billing method of the disk.
        If the disk is an elastic ephemeral disk that was detached from an ECS instance, the disk can be attached only to the instance.
        When you attach the disk as the system disk to an ECS instance, take note of the following items:
        The ECS instance must be the original instance from which the system disk was detached.
        The ECS instance must be in the **Stopped** (`Stopped`) state.
        You must configure logon credentials for the ECS instance.
        The disk cannot be an elastic ephemeral disk.
        For more information about how to attach a system disk, see [Detach or attach a system disk](https://help.aliyun.com/document_detail/146752.html).
        If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query information about an ECS instance, the instance is locked for security reasons. No operations are allowed on the instance.
        
        @param request: AttachDiskRequest
        @return: AttachDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_disk_with_options_async(request, runtime)

    def attach_instance_ram_role_with_options(
        self,
        request: ecs_20140526_models.AttachInstanceRamRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachInstanceRamRoleResponse:
        """
        @summary Attaches an instance Resource Access Management (RAM) role to Elastic Compute Service (ECS) instances.
        
        @description You can call the [DescribeInstanceRamRole](https://help.aliyun.com/document_detail/2679686.html) operation to query the [instance RAM roles](https://help.aliyun.com/document_detail/61175.html) that are attached to ECS instances.
        >  If an ECS instance already has an instance RAM role, an error is returned when you attach another instance RAM role to the instance.
        
        @param request: AttachInstanceRamRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachInstanceRamRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachInstanceRamRole',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachInstanceRamRoleResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_instance_ram_role_with_options_async(
        self,
        request: ecs_20140526_models.AttachInstanceRamRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachInstanceRamRoleResponse:
        """
        @summary Attaches an instance Resource Access Management (RAM) role to Elastic Compute Service (ECS) instances.
        
        @description You can call the [DescribeInstanceRamRole](https://help.aliyun.com/document_detail/2679686.html) operation to query the [instance RAM roles](https://help.aliyun.com/document_detail/61175.html) that are attached to ECS instances.
        >  If an ECS instance already has an instance RAM role, an error is returned when you attach another instance RAM role to the instance.
        
        @param request: AttachInstanceRamRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachInstanceRamRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachInstanceRamRole',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachInstanceRamRoleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_instance_ram_role(
        self,
        request: ecs_20140526_models.AttachInstanceRamRoleRequest,
    ) -> ecs_20140526_models.AttachInstanceRamRoleResponse:
        """
        @summary Attaches an instance Resource Access Management (RAM) role to Elastic Compute Service (ECS) instances.
        
        @description You can call the [DescribeInstanceRamRole](https://help.aliyun.com/document_detail/2679686.html) operation to query the [instance RAM roles](https://help.aliyun.com/document_detail/61175.html) that are attached to ECS instances.
        >  If an ECS instance already has an instance RAM role, an error is returned when you attach another instance RAM role to the instance.
        
        @param request: AttachInstanceRamRoleRequest
        @return: AttachInstanceRamRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_instance_ram_role_with_options(request, runtime)

    async def attach_instance_ram_role_async(
        self,
        request: ecs_20140526_models.AttachInstanceRamRoleRequest,
    ) -> ecs_20140526_models.AttachInstanceRamRoleResponse:
        """
        @summary Attaches an instance Resource Access Management (RAM) role to Elastic Compute Service (ECS) instances.
        
        @description You can call the [DescribeInstanceRamRole](https://help.aliyun.com/document_detail/2679686.html) operation to query the [instance RAM roles](https://help.aliyun.com/document_detail/61175.html) that are attached to ECS instances.
        >  If an ECS instance already has an instance RAM role, an error is returned when you attach another instance RAM role to the instance.
        
        @param request: AttachInstanceRamRoleRequest
        @return: AttachInstanceRamRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_instance_ram_role_with_options_async(request, runtime)

    def attach_key_pair_with_options(
        self,
        request: ecs_20140526_models.AttachKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachKeyPairResponse:
        """
        @summary Binds an SSH key pair to one or more Linux instances.
        
        @description Take note of the following items:
        SSH key pairs are not supported on Windows instances.
        If an SSH key pair is bound to an instance, authentication by using the username and password is disabled for the instance.
        If you bind an SSH key pair to an instance in the **running** state, you must call the [RebootInstance](https://help.aliyun.com/document_detail/25502.html) operation to restart the instance for the key pair to take effect.
        If you bind an SSH key pair to an instance in the **stopped** state, you must call the [StartInstance](https://help.aliyun.com/document_detail/25500.html) operation to start the instance for the key pair to take effect.
        If an instance is already bound to an SSH key pair, the new SSH key pair will replace the original one.
        
        @param request: AttachKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachKeyPair',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachKeyPairResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_key_pair_with_options_async(
        self,
        request: ecs_20140526_models.AttachKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachKeyPairResponse:
        """
        @summary Binds an SSH key pair to one or more Linux instances.
        
        @description Take note of the following items:
        SSH key pairs are not supported on Windows instances.
        If an SSH key pair is bound to an instance, authentication by using the username and password is disabled for the instance.
        If you bind an SSH key pair to an instance in the **running** state, you must call the [RebootInstance](https://help.aliyun.com/document_detail/25502.html) operation to restart the instance for the key pair to take effect.
        If you bind an SSH key pair to an instance in the **stopped** state, you must call the [StartInstance](https://help.aliyun.com/document_detail/25500.html) operation to start the instance for the key pair to take effect.
        If an instance is already bound to an SSH key pair, the new SSH key pair will replace the original one.
        
        @param request: AttachKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachKeyPair',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachKeyPairResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_key_pair(
        self,
        request: ecs_20140526_models.AttachKeyPairRequest,
    ) -> ecs_20140526_models.AttachKeyPairResponse:
        """
        @summary Binds an SSH key pair to one or more Linux instances.
        
        @description Take note of the following items:
        SSH key pairs are not supported on Windows instances.
        If an SSH key pair is bound to an instance, authentication by using the username and password is disabled for the instance.
        If you bind an SSH key pair to an instance in the **running** state, you must call the [RebootInstance](https://help.aliyun.com/document_detail/25502.html) operation to restart the instance for the key pair to take effect.
        If you bind an SSH key pair to an instance in the **stopped** state, you must call the [StartInstance](https://help.aliyun.com/document_detail/25500.html) operation to start the instance for the key pair to take effect.
        If an instance is already bound to an SSH key pair, the new SSH key pair will replace the original one.
        
        @param request: AttachKeyPairRequest
        @return: AttachKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_key_pair_with_options(request, runtime)

    async def attach_key_pair_async(
        self,
        request: ecs_20140526_models.AttachKeyPairRequest,
    ) -> ecs_20140526_models.AttachKeyPairResponse:
        """
        @summary Binds an SSH key pair to one or more Linux instances.
        
        @description Take note of the following items:
        SSH key pairs are not supported on Windows instances.
        If an SSH key pair is bound to an instance, authentication by using the username and password is disabled for the instance.
        If you bind an SSH key pair to an instance in the **running** state, you must call the [RebootInstance](https://help.aliyun.com/document_detail/25502.html) operation to restart the instance for the key pair to take effect.
        If you bind an SSH key pair to an instance in the **stopped** state, you must call the [StartInstance](https://help.aliyun.com/document_detail/25500.html) operation to start the instance for the key pair to take effect.
        If an instance is already bound to an SSH key pair, the new SSH key pair will replace the original one.
        
        @param request: AttachKeyPairRequest
        @return: AttachKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_key_pair_with_options_async(request, runtime)

    def attach_network_interface_with_options(
        self,
        request: ecs_20140526_models.AttachNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachNetworkInterfaceResponse:
        """
        @summary Attaches an elastic network interface (ENI) to an Elastic Compute Service (ECS) instance that resides in a virtual private cloud (VPC). When you call this operation, you can specify parameters, such as NetworkInterfaceId, InstanceId, and NetworkCardIndex, in the request.
        
        @description Take note of the following items:
        The ENI must be in the **Available** state. You can attach an ENI to only one instance that resides in the same zone and VPC as the ENI.
        The instance must be in the Running or Stopped state. When you attach ENIs to instances of specific instance types, make sure that the instances are in the Stopped state. For more information, see the "Instance types of the ECS instances that must be in the Stopped (Stopped) state" section in the [Bind an ENI](https://help.aliyun.com/document_detail/58503.html) topic.
        >If the last start time of the instance (including the start time of the instance if it is a new instance, the last restart time of the instance, and the last reactivation time of the instance) is before April 1st, 2018 and the instance is in the Running state, you must call the RebootInstance operation to restart the instance. If you do not call the RebootInstance operation to restart the instance, you cannot attach the ENI to the instance.
        You can attach multiple ENIs to one instance. For more information, see [ENI overview](https://help.aliyun.com/document_detail/58496.html).
        The vSwitch to which the ENI is connected must be in the same zone and VPC as the vSwitch to which the instance is connected.
        This operation is an asynchronous operation. After you call this operation to attach an ENI, you can view the status or events of the ENI to check whether the ENI is attached. The following figure shows the transitions between the statuses of the ENI.
        ![](https://static-aliyun-doc.oss-cn-hangzhou.aliyuncs.com/file-manage-files/en-US/20230223/vqky/AttachNetworkInterface.png)
        - If the ENI is in the Attaching state, the ENI attachment request is sent and the ENI is being attached to the specified instance.
        - If the ENI is in the InUse state, the ENI is attached to the specified instance.
        - If the ENI is in the Available state, the ENI failed to be attached.
        *For examples on how to call this operation, see** [Attach an ENI](https://help.aliyun.com/document_detail/471550.html).
        
        @param request: AttachNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_card_index):
            query['NetworkCardIndex'] = request.network_card_index
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.trunk_network_instance_id):
            query['TrunkNetworkInstanceId'] = request.trunk_network_instance_id
        if not UtilClient.is_unset(request.wait_for_network_configuration_ready):
            query['WaitForNetworkConfigurationReady'] = request.wait_for_network_configuration_ready
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachNetworkInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_network_interface_with_options_async(
        self,
        request: ecs_20140526_models.AttachNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AttachNetworkInterfaceResponse:
        """
        @summary Attaches an elastic network interface (ENI) to an Elastic Compute Service (ECS) instance that resides in a virtual private cloud (VPC). When you call this operation, you can specify parameters, such as NetworkInterfaceId, InstanceId, and NetworkCardIndex, in the request.
        
        @description Take note of the following items:
        The ENI must be in the **Available** state. You can attach an ENI to only one instance that resides in the same zone and VPC as the ENI.
        The instance must be in the Running or Stopped state. When you attach ENIs to instances of specific instance types, make sure that the instances are in the Stopped state. For more information, see the "Instance types of the ECS instances that must be in the Stopped (Stopped) state" section in the [Bind an ENI](https://help.aliyun.com/document_detail/58503.html) topic.
        >If the last start time of the instance (including the start time of the instance if it is a new instance, the last restart time of the instance, and the last reactivation time of the instance) is before April 1st, 2018 and the instance is in the Running state, you must call the RebootInstance operation to restart the instance. If you do not call the RebootInstance operation to restart the instance, you cannot attach the ENI to the instance.
        You can attach multiple ENIs to one instance. For more information, see [ENI overview](https://help.aliyun.com/document_detail/58496.html).
        The vSwitch to which the ENI is connected must be in the same zone and VPC as the vSwitch to which the instance is connected.
        This operation is an asynchronous operation. After you call this operation to attach an ENI, you can view the status or events of the ENI to check whether the ENI is attached. The following figure shows the transitions between the statuses of the ENI.
        ![](https://static-aliyun-doc.oss-cn-hangzhou.aliyuncs.com/file-manage-files/en-US/20230223/vqky/AttachNetworkInterface.png)
        - If the ENI is in the Attaching state, the ENI attachment request is sent and the ENI is being attached to the specified instance.
        - If the ENI is in the InUse state, the ENI is attached to the specified instance.
        - If the ENI is in the Available state, the ENI failed to be attached.
        *For examples on how to call this operation, see** [Attach an ENI](https://help.aliyun.com/document_detail/471550.html).
        
        @param request: AttachNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AttachNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.network_card_index):
            query['NetworkCardIndex'] = request.network_card_index
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.trunk_network_instance_id):
            query['TrunkNetworkInstanceId'] = request.trunk_network_instance_id
        if not UtilClient.is_unset(request.wait_for_network_configuration_ready):
            query['WaitForNetworkConfigurationReady'] = request.wait_for_network_configuration_ready
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AttachNetworkInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_network_interface(
        self,
        request: ecs_20140526_models.AttachNetworkInterfaceRequest,
    ) -> ecs_20140526_models.AttachNetworkInterfaceResponse:
        """
        @summary Attaches an elastic network interface (ENI) to an Elastic Compute Service (ECS) instance that resides in a virtual private cloud (VPC). When you call this operation, you can specify parameters, such as NetworkInterfaceId, InstanceId, and NetworkCardIndex, in the request.
        
        @description Take note of the following items:
        The ENI must be in the **Available** state. You can attach an ENI to only one instance that resides in the same zone and VPC as the ENI.
        The instance must be in the Running or Stopped state. When you attach ENIs to instances of specific instance types, make sure that the instances are in the Stopped state. For more information, see the "Instance types of the ECS instances that must be in the Stopped (Stopped) state" section in the [Bind an ENI](https://help.aliyun.com/document_detail/58503.html) topic.
        >If the last start time of the instance (including the start time of the instance if it is a new instance, the last restart time of the instance, and the last reactivation time of the instance) is before April 1st, 2018 and the instance is in the Running state, you must call the RebootInstance operation to restart the instance. If you do not call the RebootInstance operation to restart the instance, you cannot attach the ENI to the instance.
        You can attach multiple ENIs to one instance. For more information, see [ENI overview](https://help.aliyun.com/document_detail/58496.html).
        The vSwitch to which the ENI is connected must be in the same zone and VPC as the vSwitch to which the instance is connected.
        This operation is an asynchronous operation. After you call this operation to attach an ENI, you can view the status or events of the ENI to check whether the ENI is attached. The following figure shows the transitions between the statuses of the ENI.
        ![](https://static-aliyun-doc.oss-cn-hangzhou.aliyuncs.com/file-manage-files/en-US/20230223/vqky/AttachNetworkInterface.png)
        - If the ENI is in the Attaching state, the ENI attachment request is sent and the ENI is being attached to the specified instance.
        - If the ENI is in the InUse state, the ENI is attached to the specified instance.
        - If the ENI is in the Available state, the ENI failed to be attached.
        *For examples on how to call this operation, see** [Attach an ENI](https://help.aliyun.com/document_detail/471550.html).
        
        @param request: AttachNetworkInterfaceRequest
        @return: AttachNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.attach_network_interface_with_options(request, runtime)

    async def attach_network_interface_async(
        self,
        request: ecs_20140526_models.AttachNetworkInterfaceRequest,
    ) -> ecs_20140526_models.AttachNetworkInterfaceResponse:
        """
        @summary Attaches an elastic network interface (ENI) to an Elastic Compute Service (ECS) instance that resides in a virtual private cloud (VPC). When you call this operation, you can specify parameters, such as NetworkInterfaceId, InstanceId, and NetworkCardIndex, in the request.
        
        @description Take note of the following items:
        The ENI must be in the **Available** state. You can attach an ENI to only one instance that resides in the same zone and VPC as the ENI.
        The instance must be in the Running or Stopped state. When you attach ENIs to instances of specific instance types, make sure that the instances are in the Stopped state. For more information, see the "Instance types of the ECS instances that must be in the Stopped (Stopped) state" section in the [Bind an ENI](https://help.aliyun.com/document_detail/58503.html) topic.
        >If the last start time of the instance (including the start time of the instance if it is a new instance, the last restart time of the instance, and the last reactivation time of the instance) is before April 1st, 2018 and the instance is in the Running state, you must call the RebootInstance operation to restart the instance. If you do not call the RebootInstance operation to restart the instance, you cannot attach the ENI to the instance.
        You can attach multiple ENIs to one instance. For more information, see [ENI overview](https://help.aliyun.com/document_detail/58496.html).
        The vSwitch to which the ENI is connected must be in the same zone and VPC as the vSwitch to which the instance is connected.
        This operation is an asynchronous operation. After you call this operation to attach an ENI, you can view the status or events of the ENI to check whether the ENI is attached. The following figure shows the transitions between the statuses of the ENI.
        ![](https://static-aliyun-doc.oss-cn-hangzhou.aliyuncs.com/file-manage-files/en-US/20230223/vqky/AttachNetworkInterface.png)
        - If the ENI is in the Attaching state, the ENI attachment request is sent and the ENI is being attached to the specified instance.
        - If the ENI is in the InUse state, the ENI is attached to the specified instance.
        - If the ENI is in the Available state, the ENI failed to be attached.
        *For examples on how to call this operation, see** [Attach an ENI](https://help.aliyun.com/document_detail/471550.html).
        
        @param request: AttachNetworkInterfaceRequest
        @return: AttachNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.attach_network_interface_with_options_async(request, runtime)

    def authorize_security_group_with_options(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupResponse:
        """
        @summary Creates inbound security group rules in a security group. You can use the created rules to allow or deny inbound traffic from other objects to Elastic Compute Service (ECS) instances in the security group for fine-grained network access control.
        
        @description ### [](#)Precautions
        **Quantity limit**: The maximum number of inbound and outbound rules in all security groups associated with an elastic network interface (ENI) cannot exceed 1,000. For more information, see the [Security groups](~~25412#SecurityGroupQuota1~~) section of the "Limits and quotas on ECS" topic.
        **Rule priorities**: For inbound security group rules, the valid values of Priority range from 1 to 100. A smaller value indicates a higher priority. When multiple security group rules have the same priority, drop rules take precedence.
        ### [](#)Considerations
        If the security group rule that you call the AuthorizeSecurityGroup operation to create exists in the security group, the call is successful but no security group rule is created.
        ### [](#)Parameters that define a security group rule
        Define an inbound security group rule by configuring the following parameters together:
        Source: You can specify one parameter from SourceCidrIp (IPv4 address), Ipv6SourceCidrIp (IPv6 address), SourcetPrefixListId (prefix list ID), and SourceGroupId (source security group ID).
        PortRange: specifies the range of destination port numbers.
        IpProtocol: specifies the protocol.
        Policy: specifies the action.
        >  Advanced security groups do not support security group rules that reference security groups as authorization objects. Each basic security group can contain up to 20 security group rules that reference security groups as authorization objects.
        ### [](#)Sample requests
        Sample requests to create inbound security group rules that control access from different sources in a security group in the China (Hangzhou) region:
        Sample request to create an inbound security group rule that controls access from a specific CIDR block:
        "RegionId":"cn-hangzhou", // Specify the region.
        "SecurityGroupId":"sg-bp67acfmxazb4p***", // Specify the security group.
        "Permissions":[
        {
        "SourceCidrIp":"10.0.0.0/8", // Specify the source IPv4 CIDR block.
        "PortRange":"22/22", // Specify the port range.
        "IpProtocol":"TCP", // Specify the protocol.
        "Policy":"Accept" // Specify the action.
        }
        ]
        Sample request to create an inbound security group rule that controls access from a security group and an inbound security group rule that controls access from a prefix list:
        "RegionId":"cn-hangzhou",
        "SecurityGroupId":"sg-bp67acfmxazb4p***",
        "Permissions":[
        {
        "SourceGroupId":"sg-bp17vs63txqxbd***", // Specify the source security group.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        },{
        "SourcePrefixListId":"pl-x1j1k5ykzqlixdcy***", // Specify the source prefix list.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        }
        ]
        
        @param request: AuthorizeSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_cidr_ip):
            query['DestCidrIp'] = request.dest_cidr_ip
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.ipv_6dest_cidr_ip):
            query['Ipv6DestCidrIp'] = request.ipv_6dest_cidr_ip
        if not UtilClient.is_unset(request.ipv_6source_cidr_ip):
            query['Ipv6SourceCidrIp'] = request.ipv_6source_cidr_ip
        if not UtilClient.is_unset(request.nic_type):
            query['NicType'] = request.nic_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permissions):
            query['Permissions'] = request.permissions
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_cidr_ip):
            query['SourceCidrIp'] = request.source_cidr_ip
        if not UtilClient.is_unset(request.source_group_id):
            query['SourceGroupId'] = request.source_group_id
        if not UtilClient.is_unset(request.source_group_owner_account):
            query['SourceGroupOwnerAccount'] = request.source_group_owner_account
        if not UtilClient.is_unset(request.source_group_owner_id):
            query['SourceGroupOwnerId'] = request.source_group_owner_id
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        if not UtilClient.is_unset(request.source_prefix_list_id):
            query['SourcePrefixListId'] = request.source_prefix_list_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AuthorizeSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def authorize_security_group_with_options_async(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupResponse:
        """
        @summary Creates inbound security group rules in a security group. You can use the created rules to allow or deny inbound traffic from other objects to Elastic Compute Service (ECS) instances in the security group for fine-grained network access control.
        
        @description ### [](#)Precautions
        **Quantity limit**: The maximum number of inbound and outbound rules in all security groups associated with an elastic network interface (ENI) cannot exceed 1,000. For more information, see the [Security groups](~~25412#SecurityGroupQuota1~~) section of the "Limits and quotas on ECS" topic.
        **Rule priorities**: For inbound security group rules, the valid values of Priority range from 1 to 100. A smaller value indicates a higher priority. When multiple security group rules have the same priority, drop rules take precedence.
        ### [](#)Considerations
        If the security group rule that you call the AuthorizeSecurityGroup operation to create exists in the security group, the call is successful but no security group rule is created.
        ### [](#)Parameters that define a security group rule
        Define an inbound security group rule by configuring the following parameters together:
        Source: You can specify one parameter from SourceCidrIp (IPv4 address), Ipv6SourceCidrIp (IPv6 address), SourcetPrefixListId (prefix list ID), and SourceGroupId (source security group ID).
        PortRange: specifies the range of destination port numbers.
        IpProtocol: specifies the protocol.
        Policy: specifies the action.
        >  Advanced security groups do not support security group rules that reference security groups as authorization objects. Each basic security group can contain up to 20 security group rules that reference security groups as authorization objects.
        ### [](#)Sample requests
        Sample requests to create inbound security group rules that control access from different sources in a security group in the China (Hangzhou) region:
        Sample request to create an inbound security group rule that controls access from a specific CIDR block:
        "RegionId":"cn-hangzhou", // Specify the region.
        "SecurityGroupId":"sg-bp67acfmxazb4p***", // Specify the security group.
        "Permissions":[
        {
        "SourceCidrIp":"10.0.0.0/8", // Specify the source IPv4 CIDR block.
        "PortRange":"22/22", // Specify the port range.
        "IpProtocol":"TCP", // Specify the protocol.
        "Policy":"Accept" // Specify the action.
        }
        ]
        Sample request to create an inbound security group rule that controls access from a security group and an inbound security group rule that controls access from a prefix list:
        "RegionId":"cn-hangzhou",
        "SecurityGroupId":"sg-bp67acfmxazb4p***",
        "Permissions":[
        {
        "SourceGroupId":"sg-bp17vs63txqxbd***", // Specify the source security group.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        },{
        "SourcePrefixListId":"pl-x1j1k5ykzqlixdcy***", // Specify the source prefix list.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        }
        ]
        
        @param request: AuthorizeSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_cidr_ip):
            query['DestCidrIp'] = request.dest_cidr_ip
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.ipv_6dest_cidr_ip):
            query['Ipv6DestCidrIp'] = request.ipv_6dest_cidr_ip
        if not UtilClient.is_unset(request.ipv_6source_cidr_ip):
            query['Ipv6SourceCidrIp'] = request.ipv_6source_cidr_ip
        if not UtilClient.is_unset(request.nic_type):
            query['NicType'] = request.nic_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permissions):
            query['Permissions'] = request.permissions
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_cidr_ip):
            query['SourceCidrIp'] = request.source_cidr_ip
        if not UtilClient.is_unset(request.source_group_id):
            query['SourceGroupId'] = request.source_group_id
        if not UtilClient.is_unset(request.source_group_owner_account):
            query['SourceGroupOwnerAccount'] = request.source_group_owner_account
        if not UtilClient.is_unset(request.source_group_owner_id):
            query['SourceGroupOwnerId'] = request.source_group_owner_id
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        if not UtilClient.is_unset(request.source_prefix_list_id):
            query['SourcePrefixListId'] = request.source_prefix_list_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AuthorizeSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def authorize_security_group(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupRequest,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupResponse:
        """
        @summary Creates inbound security group rules in a security group. You can use the created rules to allow or deny inbound traffic from other objects to Elastic Compute Service (ECS) instances in the security group for fine-grained network access control.
        
        @description ### [](#)Precautions
        **Quantity limit**: The maximum number of inbound and outbound rules in all security groups associated with an elastic network interface (ENI) cannot exceed 1,000. For more information, see the [Security groups](~~25412#SecurityGroupQuota1~~) section of the "Limits and quotas on ECS" topic.
        **Rule priorities**: For inbound security group rules, the valid values of Priority range from 1 to 100. A smaller value indicates a higher priority. When multiple security group rules have the same priority, drop rules take precedence.
        ### [](#)Considerations
        If the security group rule that you call the AuthorizeSecurityGroup operation to create exists in the security group, the call is successful but no security group rule is created.
        ### [](#)Parameters that define a security group rule
        Define an inbound security group rule by configuring the following parameters together:
        Source: You can specify one parameter from SourceCidrIp (IPv4 address), Ipv6SourceCidrIp (IPv6 address), SourcetPrefixListId (prefix list ID), and SourceGroupId (source security group ID).
        PortRange: specifies the range of destination port numbers.
        IpProtocol: specifies the protocol.
        Policy: specifies the action.
        >  Advanced security groups do not support security group rules that reference security groups as authorization objects. Each basic security group can contain up to 20 security group rules that reference security groups as authorization objects.
        ### [](#)Sample requests
        Sample requests to create inbound security group rules that control access from different sources in a security group in the China (Hangzhou) region:
        Sample request to create an inbound security group rule that controls access from a specific CIDR block:
        "RegionId":"cn-hangzhou", // Specify the region.
        "SecurityGroupId":"sg-bp67acfmxazb4p***", // Specify the security group.
        "Permissions":[
        {
        "SourceCidrIp":"10.0.0.0/8", // Specify the source IPv4 CIDR block.
        "PortRange":"22/22", // Specify the port range.
        "IpProtocol":"TCP", // Specify the protocol.
        "Policy":"Accept" // Specify the action.
        }
        ]
        Sample request to create an inbound security group rule that controls access from a security group and an inbound security group rule that controls access from a prefix list:
        "RegionId":"cn-hangzhou",
        "SecurityGroupId":"sg-bp67acfmxazb4p***",
        "Permissions":[
        {
        "SourceGroupId":"sg-bp17vs63txqxbd***", // Specify the source security group.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        },{
        "SourcePrefixListId":"pl-x1j1k5ykzqlixdcy***", // Specify the source prefix list.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        }
        ]
        
        @param request: AuthorizeSecurityGroupRequest
        @return: AuthorizeSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.authorize_security_group_with_options(request, runtime)

    async def authorize_security_group_async(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupRequest,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupResponse:
        """
        @summary Creates inbound security group rules in a security group. You can use the created rules to allow or deny inbound traffic from other objects to Elastic Compute Service (ECS) instances in the security group for fine-grained network access control.
        
        @description ### [](#)Precautions
        **Quantity limit**: The maximum number of inbound and outbound rules in all security groups associated with an elastic network interface (ENI) cannot exceed 1,000. For more information, see the [Security groups](~~25412#SecurityGroupQuota1~~) section of the "Limits and quotas on ECS" topic.
        **Rule priorities**: For inbound security group rules, the valid values of Priority range from 1 to 100. A smaller value indicates a higher priority. When multiple security group rules have the same priority, drop rules take precedence.
        ### [](#)Considerations
        If the security group rule that you call the AuthorizeSecurityGroup operation to create exists in the security group, the call is successful but no security group rule is created.
        ### [](#)Parameters that define a security group rule
        Define an inbound security group rule by configuring the following parameters together:
        Source: You can specify one parameter from SourceCidrIp (IPv4 address), Ipv6SourceCidrIp (IPv6 address), SourcetPrefixListId (prefix list ID), and SourceGroupId (source security group ID).
        PortRange: specifies the range of destination port numbers.
        IpProtocol: specifies the protocol.
        Policy: specifies the action.
        >  Advanced security groups do not support security group rules that reference security groups as authorization objects. Each basic security group can contain up to 20 security group rules that reference security groups as authorization objects.
        ### [](#)Sample requests
        Sample requests to create inbound security group rules that control access from different sources in a security group in the China (Hangzhou) region:
        Sample request to create an inbound security group rule that controls access from a specific CIDR block:
        "RegionId":"cn-hangzhou", // Specify the region.
        "SecurityGroupId":"sg-bp67acfmxazb4p***", // Specify the security group.
        "Permissions":[
        {
        "SourceCidrIp":"10.0.0.0/8", // Specify the source IPv4 CIDR block.
        "PortRange":"22/22", // Specify the port range.
        "IpProtocol":"TCP", // Specify the protocol.
        "Policy":"Accept" // Specify the action.
        }
        ]
        Sample request to create an inbound security group rule that controls access from a security group and an inbound security group rule that controls access from a prefix list:
        "RegionId":"cn-hangzhou",
        "SecurityGroupId":"sg-bp67acfmxazb4p***",
        "Permissions":[
        {
        "SourceGroupId":"sg-bp17vs63txqxbd***", // Specify the source security group.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        },{
        "SourcePrefixListId":"pl-x1j1k5ykzqlixdcy***", // Specify the source prefix list.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        }
        ]
        
        @param request: AuthorizeSecurityGroupRequest
        @return: AuthorizeSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.authorize_security_group_with_options_async(request, runtime)

    def authorize_security_group_egress_with_options(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupEgressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupEgressResponse:
        """
        @summary Creates outbound rules in a security group. You can use the created rules to allow or deny outbound traffic from Elastic Compute Service (ECS) instances in the security group to other objects for fine-grained network access control.
        
        @description ### [](#)Precautions
        **Quantity limit**: The maximum number of inbound and outbound rules in all security groups associated with an elastic network interface (ENI) cannot exceed 1,000. For more information, see the [Security group limits](~~25412#SecurityGroupQuota1~~) section of the "Limits" topic.
        **Rule priorities**: For outbound security group rules, the valid values of Priority range from 1 to 100. A smaller value indicates a higher priority. When multiple security group rules have the same priority, drop rules take precedence.
        ### [](#)Considerations
        If the security group rule that you call the AuthorizeSecurityGroupEgress operation to create exists in the security group, the call is successful but no security group rule is created.
        ### [](#)Parameters that define a security group rule
        Define an outbound security group rule by configuring the following parameters together:
        One of the following parameters: DestCidrIp, Ipv6DestCidrIp, DestPrefixListId, and DestGroupId. DestCidrIp specifies the destination IPv4 CIDR block. Ipv6DestCidrIp specifies the destination IPv6 CIDR block. DestPrefixListId specifies the ID of the destination prefix list. DestGroupId specifies the destination security group.
        PortRange: specifies the range of destination port numbers.
        IpProtocol: specifies the protocol.
        Policy: specifies the action.
        >  Advanced security groups do not support security group rules that reference security groups as authorization objects. Each basic security group can contain up to 20 security group rules that reference security groups as authorization objects.
        ### [](#)Sample requests
        Sample requests to create outbound security group rules that control access to different destinations in a security group in the China (Hangzhou) region:
        Sample request to create an outbound security group rule that controls access to a specified CIDR block:
        "RegionId":"cn-hangzhou", // The region ID.
        "SecurityGroupId":"sg-bp17vs63txqxbds9**", // The ID of the source security group.
        "Permissions":[
        {
        "DestCidrIp":"10.0.0.0/8", // The destination IPv4 CIDR block.
        "PortRange":"-1/-1", // The range of destination port numbers.
        "IpProtocol":"ICMP", //T he protocol.       "Policy":"Accept" // Specify the action.
        }
        ]
        Sample request to create an outbound security group rule that controls access to a security group and an outbound security group rule that controls access to a prefix list:
        "RegionId":"cn-hangzhou",
        "SecurityGroupId":"sg-bp17vs63txqxbds9**",
        "Permissions":[
        {
        "DestGroupId":"sg-bp67acfmxazb4pi**", // The ID of the destination security group.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        },{
        "DestPrefixListId":"pl-x1j1k5ykzqlixdcy***", // The destination prefix list.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        }
        ]
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupEgressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_cidr_ip):
            query['DestCidrIp'] = request.dest_cidr_ip
        if not UtilClient.is_unset(request.dest_group_id):
            query['DestGroupId'] = request.dest_group_id
        if not UtilClient.is_unset(request.dest_group_owner_account):
            query['DestGroupOwnerAccount'] = request.dest_group_owner_account
        if not UtilClient.is_unset(request.dest_group_owner_id):
            query['DestGroupOwnerId'] = request.dest_group_owner_id
        if not UtilClient.is_unset(request.dest_prefix_list_id):
            query['DestPrefixListId'] = request.dest_prefix_list_id
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.ipv_6dest_cidr_ip):
            query['Ipv6DestCidrIp'] = request.ipv_6dest_cidr_ip
        if not UtilClient.is_unset(request.ipv_6source_cidr_ip):
            query['Ipv6SourceCidrIp'] = request.ipv_6source_cidr_ip
        if not UtilClient.is_unset(request.nic_type):
            query['NicType'] = request.nic_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permissions):
            query['Permissions'] = request.permissions
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_cidr_ip):
            query['SourceCidrIp'] = request.source_cidr_ip
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroupEgress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AuthorizeSecurityGroupEgressResponse(),
            self.call_api(params, req, runtime)
        )

    async def authorize_security_group_egress_with_options_async(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupEgressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupEgressResponse:
        """
        @summary Creates outbound rules in a security group. You can use the created rules to allow or deny outbound traffic from Elastic Compute Service (ECS) instances in the security group to other objects for fine-grained network access control.
        
        @description ### [](#)Precautions
        **Quantity limit**: The maximum number of inbound and outbound rules in all security groups associated with an elastic network interface (ENI) cannot exceed 1,000. For more information, see the [Security group limits](~~25412#SecurityGroupQuota1~~) section of the "Limits" topic.
        **Rule priorities**: For outbound security group rules, the valid values of Priority range from 1 to 100. A smaller value indicates a higher priority. When multiple security group rules have the same priority, drop rules take precedence.
        ### [](#)Considerations
        If the security group rule that you call the AuthorizeSecurityGroupEgress operation to create exists in the security group, the call is successful but no security group rule is created.
        ### [](#)Parameters that define a security group rule
        Define an outbound security group rule by configuring the following parameters together:
        One of the following parameters: DestCidrIp, Ipv6DestCidrIp, DestPrefixListId, and DestGroupId. DestCidrIp specifies the destination IPv4 CIDR block. Ipv6DestCidrIp specifies the destination IPv6 CIDR block. DestPrefixListId specifies the ID of the destination prefix list. DestGroupId specifies the destination security group.
        PortRange: specifies the range of destination port numbers.
        IpProtocol: specifies the protocol.
        Policy: specifies the action.
        >  Advanced security groups do not support security group rules that reference security groups as authorization objects. Each basic security group can contain up to 20 security group rules that reference security groups as authorization objects.
        ### [](#)Sample requests
        Sample requests to create outbound security group rules that control access to different destinations in a security group in the China (Hangzhou) region:
        Sample request to create an outbound security group rule that controls access to a specified CIDR block:
        "RegionId":"cn-hangzhou", // The region ID.
        "SecurityGroupId":"sg-bp17vs63txqxbds9**", // The ID of the source security group.
        "Permissions":[
        {
        "DestCidrIp":"10.0.0.0/8", // The destination IPv4 CIDR block.
        "PortRange":"-1/-1", // The range of destination port numbers.
        "IpProtocol":"ICMP", //T he protocol.       "Policy":"Accept" // Specify the action.
        }
        ]
        Sample request to create an outbound security group rule that controls access to a security group and an outbound security group rule that controls access to a prefix list:
        "RegionId":"cn-hangzhou",
        "SecurityGroupId":"sg-bp17vs63txqxbds9**",
        "Permissions":[
        {
        "DestGroupId":"sg-bp67acfmxazb4pi**", // The ID of the destination security group.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        },{
        "DestPrefixListId":"pl-x1j1k5ykzqlixdcy***", // The destination prefix list.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        }
        ]
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AuthorizeSecurityGroupEgressResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_cidr_ip):
            query['DestCidrIp'] = request.dest_cidr_ip
        if not UtilClient.is_unset(request.dest_group_id):
            query['DestGroupId'] = request.dest_group_id
        if not UtilClient.is_unset(request.dest_group_owner_account):
            query['DestGroupOwnerAccount'] = request.dest_group_owner_account
        if not UtilClient.is_unset(request.dest_group_owner_id):
            query['DestGroupOwnerId'] = request.dest_group_owner_id
        if not UtilClient.is_unset(request.dest_prefix_list_id):
            query['DestPrefixListId'] = request.dest_prefix_list_id
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.ipv_6dest_cidr_ip):
            query['Ipv6DestCidrIp'] = request.ipv_6dest_cidr_ip
        if not UtilClient.is_unset(request.ipv_6source_cidr_ip):
            query['Ipv6SourceCidrIp'] = request.ipv_6source_cidr_ip
        if not UtilClient.is_unset(request.nic_type):
            query['NicType'] = request.nic_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permissions):
            query['Permissions'] = request.permissions
        if not UtilClient.is_unset(request.policy):
            query['Policy'] = request.policy
        if not UtilClient.is_unset(request.port_range):
            query['PortRange'] = request.port_range
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.source_cidr_ip):
            query['SourceCidrIp'] = request.source_cidr_ip
        if not UtilClient.is_unset(request.source_port_range):
            query['SourcePortRange'] = request.source_port_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AuthorizeSecurityGroupEgress',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.AuthorizeSecurityGroupEgressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def authorize_security_group_egress(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupEgressRequest,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupEgressResponse:
        """
        @summary Creates outbound rules in a security group. You can use the created rules to allow or deny outbound traffic from Elastic Compute Service (ECS) instances in the security group to other objects for fine-grained network access control.
        
        @description ### [](#)Precautions
        **Quantity limit**: The maximum number of inbound and outbound rules in all security groups associated with an elastic network interface (ENI) cannot exceed 1,000. For more information, see the [Security group limits](~~25412#SecurityGroupQuota1~~) section of the "Limits" topic.
        **Rule priorities**: For outbound security group rules, the valid values of Priority range from 1 to 100. A smaller value indicates a higher priority. When multiple security group rules have the same priority, drop rules take precedence.
        ### [](#)Considerations
        If the security group rule that you call the AuthorizeSecurityGroupEgress operation to create exists in the security group, the call is successful but no security group rule is created.
        ### [](#)Parameters that define a security group rule
        Define an outbound security group rule by configuring the following parameters together:
        One of the following parameters: DestCidrIp, Ipv6DestCidrIp, DestPrefixListId, and DestGroupId. DestCidrIp specifies the destination IPv4 CIDR block. Ipv6DestCidrIp specifies the destination IPv6 CIDR block. DestPrefixListId specifies the ID of the destination prefix list. DestGroupId specifies the destination security group.
        PortRange: specifies the range of destination port numbers.
        IpProtocol: specifies the protocol.
        Policy: specifies the action.
        >  Advanced security groups do not support security group rules that reference security groups as authorization objects. Each basic security group can contain up to 20 security group rules that reference security groups as authorization objects.
        ### [](#)Sample requests
        Sample requests to create outbound security group rules that control access to different destinations in a security group in the China (Hangzhou) region:
        Sample request to create an outbound security group rule that controls access to a specified CIDR block:
        "RegionId":"cn-hangzhou", // The region ID.
        "SecurityGroupId":"sg-bp17vs63txqxbds9**", // The ID of the source security group.
        "Permissions":[
        {
        "DestCidrIp":"10.0.0.0/8", // The destination IPv4 CIDR block.
        "PortRange":"-1/-1", // The range of destination port numbers.
        "IpProtocol":"ICMP", //T he protocol.       "Policy":"Accept" // Specify the action.
        }
        ]
        Sample request to create an outbound security group rule that controls access to a security group and an outbound security group rule that controls access to a prefix list:
        "RegionId":"cn-hangzhou",
        "SecurityGroupId":"sg-bp17vs63txqxbds9**",
        "Permissions":[
        {
        "DestGroupId":"sg-bp67acfmxazb4pi**", // The ID of the destination security group.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        },{
        "DestPrefixListId":"pl-x1j1k5ykzqlixdcy***", // The destination prefix list.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        }
        ]
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @return: AuthorizeSecurityGroupEgressResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.authorize_security_group_egress_with_options(request, runtime)

    async def authorize_security_group_egress_async(
        self,
        request: ecs_20140526_models.AuthorizeSecurityGroupEgressRequest,
    ) -> ecs_20140526_models.AuthorizeSecurityGroupEgressResponse:
        """
        @summary Creates outbound rules in a security group. You can use the created rules to allow or deny outbound traffic from Elastic Compute Service (ECS) instances in the security group to other objects for fine-grained network access control.
        
        @description ### [](#)Precautions
        **Quantity limit**: The maximum number of inbound and outbound rules in all security groups associated with an elastic network interface (ENI) cannot exceed 1,000. For more information, see the [Security group limits](~~25412#SecurityGroupQuota1~~) section of the "Limits" topic.
        **Rule priorities**: For outbound security group rules, the valid values of Priority range from 1 to 100. A smaller value indicates a higher priority. When multiple security group rules have the same priority, drop rules take precedence.
        ### [](#)Considerations
        If the security group rule that you call the AuthorizeSecurityGroupEgress operation to create exists in the security group, the call is successful but no security group rule is created.
        ### [](#)Parameters that define a security group rule
        Define an outbound security group rule by configuring the following parameters together:
        One of the following parameters: DestCidrIp, Ipv6DestCidrIp, DestPrefixListId, and DestGroupId. DestCidrIp specifies the destination IPv4 CIDR block. Ipv6DestCidrIp specifies the destination IPv6 CIDR block. DestPrefixListId specifies the ID of the destination prefix list. DestGroupId specifies the destination security group.
        PortRange: specifies the range of destination port numbers.
        IpProtocol: specifies the protocol.
        Policy: specifies the action.
        >  Advanced security groups do not support security group rules that reference security groups as authorization objects. Each basic security group can contain up to 20 security group rules that reference security groups as authorization objects.
        ### [](#)Sample requests
        Sample requests to create outbound security group rules that control access to different destinations in a security group in the China (Hangzhou) region:
        Sample request to create an outbound security group rule that controls access to a specified CIDR block:
        "RegionId":"cn-hangzhou", // The region ID.
        "SecurityGroupId":"sg-bp17vs63txqxbds9**", // The ID of the source security group.
        "Permissions":[
        {
        "DestCidrIp":"10.0.0.0/8", // The destination IPv4 CIDR block.
        "PortRange":"-1/-1", // The range of destination port numbers.
        "IpProtocol":"ICMP", //T he protocol.       "Policy":"Accept" // Specify the action.
        }
        ]
        Sample request to create an outbound security group rule that controls access to a security group and an outbound security group rule that controls access to a prefix list:
        "RegionId":"cn-hangzhou",
        "SecurityGroupId":"sg-bp17vs63txqxbds9**",
        "Permissions":[
        {
        "DestGroupId":"sg-bp67acfmxazb4pi**", // The ID of the destination security group.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        },{
        "DestPrefixListId":"pl-x1j1k5ykzqlixdcy***", // The destination prefix list.
        "PortRange":"22/22",
        "IpProtocol":"TCP",
        "Policy":"Drop"
        }
        ]
        
        @param request: AuthorizeSecurityGroupEgressRequest
        @return: AuthorizeSecurityGroupEgressResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.authorize_security_group_egress_with_options_async(request, runtime)

    def cancel_auto_snapshot_policy_with_options(
        self,
        request: ecs_20140526_models.CancelAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelAutoSnapshotPolicyResponse:
        """
        @summary Disables automatic snapshot policies for one or more disks.
        
        @param request: CancelAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['autoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.disk_ids):
            query['diskIds'] = request.disk_ids
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelAutoSnapshotPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_auto_snapshot_policy_with_options_async(
        self,
        request: ecs_20140526_models.CancelAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelAutoSnapshotPolicyResponse:
        """
        @summary Disables automatic snapshot policies for one or more disks.
        
        @param request: CancelAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['autoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.disk_ids):
            query['diskIds'] = request.disk_ids
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelAutoSnapshotPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_auto_snapshot_policy(
        self,
        request: ecs_20140526_models.CancelAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.CancelAutoSnapshotPolicyResponse:
        """
        @summary Disables automatic snapshot policies for one or more disks.
        
        @param request: CancelAutoSnapshotPolicyRequest
        @return: CancelAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_auto_snapshot_policy_with_options(request, runtime)

    async def cancel_auto_snapshot_policy_async(
        self,
        request: ecs_20140526_models.CancelAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.CancelAutoSnapshotPolicyResponse:
        """
        @summary Disables automatic snapshot policies for one or more disks.
        
        @param request: CancelAutoSnapshotPolicyRequest
        @return: CancelAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_auto_snapshot_policy_with_options_async(request, runtime)

    def cancel_copy_image_with_options(
        self,
        request: ecs_20140526_models.CancelCopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelCopyImageResponse:
        """
        @summary Cancels an ongoing image copy task.
        
        @description When you call this operation, take note of the following items:
        After you cancel an image copy task, the image copy created in the destination region is deleted, and the copied image remains unchanged.
        If the image copy task is complete, the CancelCopyImage operation fails, and an error is returned.
        
        @param request: CancelCopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCopyImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelCopyImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_copy_image_with_options_async(
        self,
        request: ecs_20140526_models.CancelCopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelCopyImageResponse:
        """
        @summary Cancels an ongoing image copy task.
        
        @description When you call this operation, take note of the following items:
        After you cancel an image copy task, the image copy created in the destination region is deleted, and the copied image remains unchanged.
        If the image copy task is complete, the CancelCopyImage operation fails, and an error is returned.
        
        @param request: CancelCopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelCopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCopyImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelCopyImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_copy_image(
        self,
        request: ecs_20140526_models.CancelCopyImageRequest,
    ) -> ecs_20140526_models.CancelCopyImageResponse:
        """
        @summary Cancels an ongoing image copy task.
        
        @description When you call this operation, take note of the following items:
        After you cancel an image copy task, the image copy created in the destination region is deleted, and the copied image remains unchanged.
        If the image copy task is complete, the CancelCopyImage operation fails, and an error is returned.
        
        @param request: CancelCopyImageRequest
        @return: CancelCopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_copy_image_with_options(request, runtime)

    async def cancel_copy_image_async(
        self,
        request: ecs_20140526_models.CancelCopyImageRequest,
    ) -> ecs_20140526_models.CancelCopyImageResponse:
        """
        @summary Cancels an ongoing image copy task.
        
        @description When you call this operation, take note of the following items:
        After you cancel an image copy task, the image copy created in the destination region is deleted, and the copied image remains unchanged.
        If the image copy task is complete, the CancelCopyImage operation fails, and an error is returned.
        
        @param request: CancelCopyImageRequest
        @return: CancelCopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_copy_image_with_options_async(request, runtime)

    def cancel_image_pipeline_execution_with_options(
        self,
        request: ecs_20140526_models.CancelImagePipelineExecutionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelImagePipelineExecutionResponse:
        """
        @summary Cancels an image building task.
        
        @description Before you call the CancelImagePipelineExecution operation, make sure that the image building task to be canceled is in the BUILDING, PREPARING, or REPAIRING state.
        
        @param request: CancelImagePipelineExecutionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelImagePipelineExecutionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.execution_id):
            query['ExecutionId'] = request.execution_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.template_tag):
            query['TemplateTag'] = request.template_tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelImagePipelineExecution',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelImagePipelineExecutionResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_image_pipeline_execution_with_options_async(
        self,
        request: ecs_20140526_models.CancelImagePipelineExecutionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelImagePipelineExecutionResponse:
        """
        @summary Cancels an image building task.
        
        @description Before you call the CancelImagePipelineExecution operation, make sure that the image building task to be canceled is in the BUILDING, PREPARING, or REPAIRING state.
        
        @param request: CancelImagePipelineExecutionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelImagePipelineExecutionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.execution_id):
            query['ExecutionId'] = request.execution_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.template_tag):
            query['TemplateTag'] = request.template_tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelImagePipelineExecution',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelImagePipelineExecutionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_image_pipeline_execution(
        self,
        request: ecs_20140526_models.CancelImagePipelineExecutionRequest,
    ) -> ecs_20140526_models.CancelImagePipelineExecutionResponse:
        """
        @summary Cancels an image building task.
        
        @description Before you call the CancelImagePipelineExecution operation, make sure that the image building task to be canceled is in the BUILDING, PREPARING, or REPAIRING state.
        
        @param request: CancelImagePipelineExecutionRequest
        @return: CancelImagePipelineExecutionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_image_pipeline_execution_with_options(request, runtime)

    async def cancel_image_pipeline_execution_async(
        self,
        request: ecs_20140526_models.CancelImagePipelineExecutionRequest,
    ) -> ecs_20140526_models.CancelImagePipelineExecutionResponse:
        """
        @summary Cancels an image building task.
        
        @description Before you call the CancelImagePipelineExecution operation, make sure that the image building task to be canceled is in the BUILDING, PREPARING, or REPAIRING state.
        
        @param request: CancelImagePipelineExecutionRequest
        @return: CancelImagePipelineExecutionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_image_pipeline_execution_with_options_async(request, runtime)

    def cancel_physical_connection_with_options(
        self,
        request: ecs_20140526_models.CancelPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelPhysicalConnectionResponse:
        """
        @deprecated OpenAPI CancelPhysicalConnection is deprecated, please use Vpc::2016-04-28::CancelPhysicalConnection instead.
        
        @summary CancelPhysicalConnection
        
        @param request: CancelPhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelPhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelPhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_physical_connection_with_options_async(
        self,
        request: ecs_20140526_models.CancelPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelPhysicalConnectionResponse:
        """
        @deprecated OpenAPI CancelPhysicalConnection is deprecated, please use Vpc::2016-04-28::CancelPhysicalConnection instead.
        
        @summary CancelPhysicalConnection
        
        @param request: CancelPhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelPhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelPhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_physical_connection(
        self,
        request: ecs_20140526_models.CancelPhysicalConnectionRequest,
    ) -> ecs_20140526_models.CancelPhysicalConnectionResponse:
        """
        @deprecated OpenAPI CancelPhysicalConnection is deprecated, please use Vpc::2016-04-28::CancelPhysicalConnection instead.
        
        @summary CancelPhysicalConnection
        
        @param request: CancelPhysicalConnectionRequest
        @return: CancelPhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_physical_connection_with_options(request, runtime)

    async def cancel_physical_connection_async(
        self,
        request: ecs_20140526_models.CancelPhysicalConnectionRequest,
    ) -> ecs_20140526_models.CancelPhysicalConnectionResponse:
        """
        @deprecated OpenAPI CancelPhysicalConnection is deprecated, please use Vpc::2016-04-28::CancelPhysicalConnection instead.
        
        @summary CancelPhysicalConnection
        
        @param request: CancelPhysicalConnectionRequest
        @return: CancelPhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_physical_connection_with_options_async(request, runtime)

    def cancel_simulated_system_events_with_options(
        self,
        request: ecs_20140526_models.CancelSimulatedSystemEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelSimulatedSystemEventsResponse:
        """
        @summary Cancels simulated system events that are in the Scheduled or Executing state. After you cancel a simulated system event, the simulated event enters the Canceled state.
        
        @param request: CancelSimulatedSystemEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelSimulatedSystemEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelSimulatedSystemEvents',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelSimulatedSystemEventsResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_simulated_system_events_with_options_async(
        self,
        request: ecs_20140526_models.CancelSimulatedSystemEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelSimulatedSystemEventsResponse:
        """
        @summary Cancels simulated system events that are in the Scheduled or Executing state. After you cancel a simulated system event, the simulated event enters the Canceled state.
        
        @param request: CancelSimulatedSystemEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelSimulatedSystemEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelSimulatedSystemEvents',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelSimulatedSystemEventsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_simulated_system_events(
        self,
        request: ecs_20140526_models.CancelSimulatedSystemEventsRequest,
    ) -> ecs_20140526_models.CancelSimulatedSystemEventsResponse:
        """
        @summary Cancels simulated system events that are in the Scheduled or Executing state. After you cancel a simulated system event, the simulated event enters the Canceled state.
        
        @param request: CancelSimulatedSystemEventsRequest
        @return: CancelSimulatedSystemEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_simulated_system_events_with_options(request, runtime)

    async def cancel_simulated_system_events_async(
        self,
        request: ecs_20140526_models.CancelSimulatedSystemEventsRequest,
    ) -> ecs_20140526_models.CancelSimulatedSystemEventsResponse:
        """
        @summary Cancels simulated system events that are in the Scheduled or Executing state. After you cancel a simulated system event, the simulated event enters the Canceled state.
        
        @param request: CancelSimulatedSystemEventsRequest
        @return: CancelSimulatedSystemEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_simulated_system_events_with_options_async(request, runtime)

    def cancel_task_with_options(
        self,
        request: ecs_20140526_models.CancelTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelTaskResponse:
        """
        @summary Cancels a running task. You can cancel the running tasks generated by the ImportImage or ExportImage operation.
        
        @param request: CancelTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelTask',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_task_with_options_async(
        self,
        request: ecs_20140526_models.CancelTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CancelTaskResponse:
        """
        @summary Cancels a running task. You can cancel the running tasks generated by the ImportImage or ExportImage operation.
        
        @param request: CancelTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CancelTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelTask',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CancelTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_task(
        self,
        request: ecs_20140526_models.CancelTaskRequest,
    ) -> ecs_20140526_models.CancelTaskResponse:
        """
        @summary Cancels a running task. You can cancel the running tasks generated by the ImportImage or ExportImage operation.
        
        @param request: CancelTaskRequest
        @return: CancelTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.cancel_task_with_options(request, runtime)

    async def cancel_task_async(
        self,
        request: ecs_20140526_models.CancelTaskRequest,
    ) -> ecs_20140526_models.CancelTaskResponse:
        """
        @summary Cancels a running task. You can cancel the running tasks generated by the ImportImage or ExportImage operation.
        
        @param request: CancelTaskRequest
        @return: CancelTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.cancel_task_with_options_async(request, runtime)

    def connect_router_interface_with_options(
        self,
        request: ecs_20140526_models.ConnectRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ConnectRouterInterfaceResponse:
        """
        @deprecated OpenAPI ConnectRouterInterface is deprecated, please use Vpc::2016-04-28::ConnectRouterInterface instead.
        
        @summary ConnectRouterInterface
        
        @param request: ConnectRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConnectRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConnectRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ConnectRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def connect_router_interface_with_options_async(
        self,
        request: ecs_20140526_models.ConnectRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ConnectRouterInterfaceResponse:
        """
        @deprecated OpenAPI ConnectRouterInterface is deprecated, please use Vpc::2016-04-28::ConnectRouterInterface instead.
        
        @summary ConnectRouterInterface
        
        @param request: ConnectRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConnectRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConnectRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ConnectRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def connect_router_interface(
        self,
        request: ecs_20140526_models.ConnectRouterInterfaceRequest,
    ) -> ecs_20140526_models.ConnectRouterInterfaceResponse:
        """
        @deprecated OpenAPI ConnectRouterInterface is deprecated, please use Vpc::2016-04-28::ConnectRouterInterface instead.
        
        @summary ConnectRouterInterface
        
        @param request: ConnectRouterInterfaceRequest
        @return: ConnectRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.connect_router_interface_with_options(request, runtime)

    async def connect_router_interface_async(
        self,
        request: ecs_20140526_models.ConnectRouterInterfaceRequest,
    ) -> ecs_20140526_models.ConnectRouterInterfaceResponse:
        """
        @deprecated OpenAPI ConnectRouterInterface is deprecated, please use Vpc::2016-04-28::ConnectRouterInterface instead.
        
        @summary ConnectRouterInterface
        
        @param request: ConnectRouterInterfaceRequest
        @return: ConnectRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.connect_router_interface_with_options_async(request, runtime)

    def convert_nat_public_ip_to_eip_with_options(
        self,
        request: ecs_20140526_models.ConvertNatPublicIpToEipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ConvertNatPublicIpToEipResponse:
        """
        @summary Converts the static public IP address of an Elastic Compute Service (ECS) instance that resides in a virtual private cloud (VPC) into an elastic IP address (EIP). Static public IP addresses are the public IP addresses that are automatically assigned to ECS instances.
        
        @description ## [](#)Usage notes
        After a public IP address is converted into an EIP, the EIP is billed separately. Make sure that you fully understand the billing methods of EIPs. For more information, see [Billing overview](https://help.aliyun.com/document_detail/122035.html).
        When you call this operation, make sure that the ECS instance meets the following requirements:
        The instance is in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        The instance has no EIPs associated.
        The instance has no configuration change tasks that have not taken effect.
        The public bandwidth of the instance is not 0 Mbit/s.
        If the instance is a subscription instance, the billing method for network usage of the instance must be `pay-by-traffic`. The public IP address of a subscription instance that uses the `pay-by-bandwidth` billing method for network usage cannot be converted into an EIP. This requirement does not apply to pay-as-you-go instances. For more information, see [Change the billing method for network usage](https://help.aliyun.com/document_detail/178883.html).
        If the instance is a subscription instance that resides in a VPC, the instance does not expire within 24 hours.
        
        @param request: ConvertNatPublicIpToEipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConvertNatPublicIpToEipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConvertNatPublicIpToEip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ConvertNatPublicIpToEipResponse(),
            self.call_api(params, req, runtime)
        )

    async def convert_nat_public_ip_to_eip_with_options_async(
        self,
        request: ecs_20140526_models.ConvertNatPublicIpToEipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.ConvertNatPublicIpToEipResponse:
        """
        @summary Converts the static public IP address of an Elastic Compute Service (ECS) instance that resides in a virtual private cloud (VPC) into an elastic IP address (EIP). Static public IP addresses are the public IP addresses that are automatically assigned to ECS instances.
        
        @description ## [](#)Usage notes
        After a public IP address is converted into an EIP, the EIP is billed separately. Make sure that you fully understand the billing methods of EIPs. For more information, see [Billing overview](https://help.aliyun.com/document_detail/122035.html).
        When you call this operation, make sure that the ECS instance meets the following requirements:
        The instance is in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        The instance has no EIPs associated.
        The instance has no configuration change tasks that have not taken effect.
        The public bandwidth of the instance is not 0 Mbit/s.
        If the instance is a subscription instance, the billing method for network usage of the instance must be `pay-by-traffic`. The public IP address of a subscription instance that uses the `pay-by-bandwidth` billing method for network usage cannot be converted into an EIP. This requirement does not apply to pay-as-you-go instances. For more information, see [Change the billing method for network usage](https://help.aliyun.com/document_detail/178883.html).
        If the instance is a subscription instance that resides in a VPC, the instance does not expire within 24 hours.
        
        @param request: ConvertNatPublicIpToEipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ConvertNatPublicIpToEipResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConvertNatPublicIpToEip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.ConvertNatPublicIpToEipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def convert_nat_public_ip_to_eip(
        self,
        request: ecs_20140526_models.ConvertNatPublicIpToEipRequest,
    ) -> ecs_20140526_models.ConvertNatPublicIpToEipResponse:
        """
        @summary Converts the static public IP address of an Elastic Compute Service (ECS) instance that resides in a virtual private cloud (VPC) into an elastic IP address (EIP). Static public IP addresses are the public IP addresses that are automatically assigned to ECS instances.
        
        @description ## [](#)Usage notes
        After a public IP address is converted into an EIP, the EIP is billed separately. Make sure that you fully understand the billing methods of EIPs. For more information, see [Billing overview](https://help.aliyun.com/document_detail/122035.html).
        When you call this operation, make sure that the ECS instance meets the following requirements:
        The instance is in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        The instance has no EIPs associated.
        The instance has no configuration change tasks that have not taken effect.
        The public bandwidth of the instance is not 0 Mbit/s.
        If the instance is a subscription instance, the billing method for network usage of the instance must be `pay-by-traffic`. The public IP address of a subscription instance that uses the `pay-by-bandwidth` billing method for network usage cannot be converted into an EIP. This requirement does not apply to pay-as-you-go instances. For more information, see [Change the billing method for network usage](https://help.aliyun.com/document_detail/178883.html).
        If the instance is a subscription instance that resides in a VPC, the instance does not expire within 24 hours.
        
        @param request: ConvertNatPublicIpToEipRequest
        @return: ConvertNatPublicIpToEipResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.convert_nat_public_ip_to_eip_with_options(request, runtime)

    async def convert_nat_public_ip_to_eip_async(
        self,
        request: ecs_20140526_models.ConvertNatPublicIpToEipRequest,
    ) -> ecs_20140526_models.ConvertNatPublicIpToEipResponse:
        """
        @summary Converts the static public IP address of an Elastic Compute Service (ECS) instance that resides in a virtual private cloud (VPC) into an elastic IP address (EIP). Static public IP addresses are the public IP addresses that are automatically assigned to ECS instances.
        
        @description ## [](#)Usage notes
        After a public IP address is converted into an EIP, the EIP is billed separately. Make sure that you fully understand the billing methods of EIPs. For more information, see [Billing overview](https://help.aliyun.com/document_detail/122035.html).
        When you call this operation, make sure that the ECS instance meets the following requirements:
        The instance is in the **Stopped** (`Stopped`) or **Running** (`Running`) state.
        The instance has no EIPs associated.
        The instance has no configuration change tasks that have not taken effect.
        The public bandwidth of the instance is not 0 Mbit/s.
        If the instance is a subscription instance, the billing method for network usage of the instance must be `pay-by-traffic`. The public IP address of a subscription instance that uses the `pay-by-bandwidth` billing method for network usage cannot be converted into an EIP. This requirement does not apply to pay-as-you-go instances. For more information, see [Change the billing method for network usage](https://help.aliyun.com/document_detail/178883.html).
        If the instance is a subscription instance that resides in a VPC, the instance does not expire within 24 hours.
        
        @param request: ConvertNatPublicIpToEipRequest
        @return: ConvertNatPublicIpToEipResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.convert_nat_public_ip_to_eip_with_options_async(request, runtime)

    def copy_image_with_options(
        self,
        request: ecs_20140526_models.CopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CopyImageResponse:
        """
        @summary Copies a custom image from one region to another region. You can copy custom images to deploy or copy Elastic Compute Service (ECS) instances across regions.
        
        @description ## [](#)Usage notes
        After you copy a custom image to the destination region, you can use the image copy (new image) to create ECS instances by calling the RunInstances operation or replace the system disks of instances by calling the ReplaceSystemDisk operation in the destination region.
        Take note of the following items:
        Only custom images that are in the `Available` state can be copied.
        Custom images that belong to your Alibaba Cloud account can be copied across regions. Images that are shared with you by others can be copied only within the regions where the images reside.
        When an image is being copied, the new image cannot be deleted by calling the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation. However, you can cancel the ongoing image copy task by calling the [CancelCopyImage](https://help.aliyun.com/document_detail/25539.html) operation.
        A region supports only up to five concurrent image copy tasks. Excess image copy tasks are queued for execution.
        You can configure `ResourceGroupId` to specify the resource group to which to assign the new image. If you do not configure `ResourceGroupId`, the new image is assigned to the default resource group.
        
        @param request: CopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.destination_description):
            query['DestinationDescription'] = request.destination_description
        if not UtilClient.is_unset(request.destination_image_name):
            query['DestinationImageName'] = request.destination_image_name
        if not UtilClient.is_unset(request.destination_region_id):
            query['DestinationRegionId'] = request.destination_region_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.encrypt_algorithm):
            query['EncryptAlgorithm'] = request.encrypt_algorithm
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CopyImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_image_with_options_async(
        self,
        request: ecs_20140526_models.CopyImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CopyImageResponse:
        """
        @summary Copies a custom image from one region to another region. You can copy custom images to deploy or copy Elastic Compute Service (ECS) instances across regions.
        
        @description ## [](#)Usage notes
        After you copy a custom image to the destination region, you can use the image copy (new image) to create ECS instances by calling the RunInstances operation or replace the system disks of instances by calling the ReplaceSystemDisk operation in the destination region.
        Take note of the following items:
        Only custom images that are in the `Available` state can be copied.
        Custom images that belong to your Alibaba Cloud account can be copied across regions. Images that are shared with you by others can be copied only within the regions where the images reside.
        When an image is being copied, the new image cannot be deleted by calling the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation. However, you can cancel the ongoing image copy task by calling the [CancelCopyImage](https://help.aliyun.com/document_detail/25539.html) operation.
        A region supports only up to five concurrent image copy tasks. Excess image copy tasks are queued for execution.
        You can configure `ResourceGroupId` to specify the resource group to which to assign the new image. If you do not configure `ResourceGroupId`, the new image is assigned to the default resource group.
        
        @param request: CopyImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopyImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.destination_description):
            query['DestinationDescription'] = request.destination_description
        if not UtilClient.is_unset(request.destination_image_name):
            query['DestinationImageName'] = request.destination_image_name
        if not UtilClient.is_unset(request.destination_region_id):
            query['DestinationRegionId'] = request.destination_region_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.encrypt_algorithm):
            query['EncryptAlgorithm'] = request.encrypt_algorithm
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CopyImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_image(
        self,
        request: ecs_20140526_models.CopyImageRequest,
    ) -> ecs_20140526_models.CopyImageResponse:
        """
        @summary Copies a custom image from one region to another region. You can copy custom images to deploy or copy Elastic Compute Service (ECS) instances across regions.
        
        @description ## [](#)Usage notes
        After you copy a custom image to the destination region, you can use the image copy (new image) to create ECS instances by calling the RunInstances operation or replace the system disks of instances by calling the ReplaceSystemDisk operation in the destination region.
        Take note of the following items:
        Only custom images that are in the `Available` state can be copied.
        Custom images that belong to your Alibaba Cloud account can be copied across regions. Images that are shared with you by others can be copied only within the regions where the images reside.
        When an image is being copied, the new image cannot be deleted by calling the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation. However, you can cancel the ongoing image copy task by calling the [CancelCopyImage](https://help.aliyun.com/document_detail/25539.html) operation.
        A region supports only up to five concurrent image copy tasks. Excess image copy tasks are queued for execution.
        You can configure `ResourceGroupId` to specify the resource group to which to assign the new image. If you do not configure `ResourceGroupId`, the new image is assigned to the default resource group.
        
        @param request: CopyImageRequest
        @return: CopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_image_with_options(request, runtime)

    async def copy_image_async(
        self,
        request: ecs_20140526_models.CopyImageRequest,
    ) -> ecs_20140526_models.CopyImageResponse:
        """
        @summary Copies a custom image from one region to another region. You can copy custom images to deploy or copy Elastic Compute Service (ECS) instances across regions.
        
        @description ## [](#)Usage notes
        After you copy a custom image to the destination region, you can use the image copy (new image) to create ECS instances by calling the RunInstances operation or replace the system disks of instances by calling the ReplaceSystemDisk operation in the destination region.
        Take note of the following items:
        Only custom images that are in the `Available` state can be copied.
        Custom images that belong to your Alibaba Cloud account can be copied across regions. Images that are shared with you by others can be copied only within the regions where the images reside.
        When an image is being copied, the new image cannot be deleted by calling the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation. However, you can cancel the ongoing image copy task by calling the [CancelCopyImage](https://help.aliyun.com/document_detail/25539.html) operation.
        A region supports only up to five concurrent image copy tasks. Excess image copy tasks are queued for execution.
        You can configure `ResourceGroupId` to specify the resource group to which to assign the new image. If you do not configure `ResourceGroupId`, the new image is assigned to the default resource group.
        
        @param request: CopyImageRequest
        @return: CopyImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_image_with_options_async(request, runtime)

    def copy_snapshot_with_options(
        self,
        request: ecs_20140526_models.CopySnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CopySnapshotResponse:
        """
        @summary Copies a standard or encrypted snapshot from one region to another.
        
        @description When you call this operation, take note of the following item:
        New snapshots (snapshot copies) cannot be used to roll back the disks for which source snapshots (copied snapshots) were created.
        Local snapshots cannot be copied.
        
        @param request: CopySnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopySnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.destination_region_id):
            query['DestinationRegionId'] = request.destination_region_id
        if not UtilClient.is_unset(request.destination_snapshot_description):
            query['DestinationSnapshotDescription'] = request.destination_snapshot_description
        if not UtilClient.is_unset(request.destination_snapshot_name):
            query['DestinationSnapshotName'] = request.destination_snapshot_name
        if not UtilClient.is_unset(request.destination_storage_location_arn):
            query['DestinationStorageLocationArn'] = request.destination_storage_location_arn
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopySnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CopySnapshotResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_snapshot_with_options_async(
        self,
        request: ecs_20140526_models.CopySnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CopySnapshotResponse:
        """
        @summary Copies a standard or encrypted snapshot from one region to another.
        
        @description When you call this operation, take note of the following item:
        New snapshots (snapshot copies) cannot be used to roll back the disks for which source snapshots (copied snapshots) were created.
        Local snapshots cannot be copied.
        
        @param request: CopySnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CopySnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.destination_region_id):
            query['DestinationRegionId'] = request.destination_region_id
        if not UtilClient.is_unset(request.destination_snapshot_description):
            query['DestinationSnapshotDescription'] = request.destination_snapshot_description
        if not UtilClient.is_unset(request.destination_snapshot_name):
            query['DestinationSnapshotName'] = request.destination_snapshot_name
        if not UtilClient.is_unset(request.destination_storage_location_arn):
            query['DestinationStorageLocationArn'] = request.destination_storage_location_arn
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopySnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CopySnapshotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_snapshot(
        self,
        request: ecs_20140526_models.CopySnapshotRequest,
    ) -> ecs_20140526_models.CopySnapshotResponse:
        """
        @summary Copies a standard or encrypted snapshot from one region to another.
        
        @description When you call this operation, take note of the following item:
        New snapshots (snapshot copies) cannot be used to roll back the disks for which source snapshots (copied snapshots) were created.
        Local snapshots cannot be copied.
        
        @param request: CopySnapshotRequest
        @return: CopySnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.copy_snapshot_with_options(request, runtime)

    async def copy_snapshot_async(
        self,
        request: ecs_20140526_models.CopySnapshotRequest,
    ) -> ecs_20140526_models.CopySnapshotResponse:
        """
        @summary Copies a standard or encrypted snapshot from one region to another.
        
        @description When you call this operation, take note of the following item:
        New snapshots (snapshot copies) cannot be used to roll back the disks for which source snapshots (copied snapshots) were created.
        Local snapshots cannot be copied.
        
        @param request: CopySnapshotRequest
        @return: CopySnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.copy_snapshot_with_options_async(request, runtime)

    def create_activation_with_options(
        self,
        request: ecs_20140526_models.CreateActivationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateActivationResponse:
        """
        @summary Creates an activation code. The activation code is used to register servers that are not provided by Alibaba Cloud as Alibaba Cloud managed instances.
        
        @description ## [](#)Usage notes
        After you use an activation code to register a server that is not provided by Alibaba Cloud as an Alibaba Cloud managed instance, you can use various online services of Alibaba Cloud, such as Cloud Assistant, CloudOps Orchestration Service (OOS), and Apsara Devops, on the managed instance.
        If a server is not provided by Alibaba Cloud, you can register the server as an Alibaba Cloud managed instance only if the server has Internet connectivity and runs one of the following operating systems:
        Alibaba Cloud Linux 2, Alibaba Cloud Linux 3, or later
        CentOS 6, CentOS 7, CentOS 8, or later
        Debian 8, Debian 9, Debian 10, or later
        Ubuntu 12, Ubuntu 14, Ubuntu 16, Ubuntu 18, or later
        CoreOS
        OpenSUSE
        Red Hat 5, Red Hat 6, Red Hat 7, or later
        SUSE Linux Enterprise Server 11, SUSE Linux Enterprise Server 12, SUSE Linux Enterprise Server 15, or later
        Windows Server 2012, Windows Server 2016, Windows Server 2019, or later
        You can have up to 5,000 activation codes per Alibaba Cloud region. When the number of activation codes exceeds 1,000, the usage of the activation codes must be greater than 50% before you can create additional activation codes.
        >  To obtain the usage of activation codes, go to the *ECS Cloud Assistant** page in the Elastic Compute Service (ECS) console, click the **Manage Instances** tab, and then click **Register Instance**.
        
        @param request: CreateActivationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateActivationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_count):
            query['InstanceCount'] = request.instance_count
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.ip_address_range):
            query['IpAddressRange'] = request.ip_address_range
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.time_to_live_in_hours):
            query['TimeToLiveInHours'] = request.time_to_live_in_hours
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateActivation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateActivationResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_activation_with_options_async(
        self,
        request: ecs_20140526_models.CreateActivationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateActivationResponse:
        """
        @summary Creates an activation code. The activation code is used to register servers that are not provided by Alibaba Cloud as Alibaba Cloud managed instances.
        
        @description ## [](#)Usage notes
        After you use an activation code to register a server that is not provided by Alibaba Cloud as an Alibaba Cloud managed instance, you can use various online services of Alibaba Cloud, such as Cloud Assistant, CloudOps Orchestration Service (OOS), and Apsara Devops, on the managed instance.
        If a server is not provided by Alibaba Cloud, you can register the server as an Alibaba Cloud managed instance only if the server has Internet connectivity and runs one of the following operating systems:
        Alibaba Cloud Linux 2, Alibaba Cloud Linux 3, or later
        CentOS 6, CentOS 7, CentOS 8, or later
        Debian 8, Debian 9, Debian 10, or later
        Ubuntu 12, Ubuntu 14, Ubuntu 16, Ubuntu 18, or later
        CoreOS
        OpenSUSE
        Red Hat 5, Red Hat 6, Red Hat 7, or later
        SUSE Linux Enterprise Server 11, SUSE Linux Enterprise Server 12, SUSE Linux Enterprise Server 15, or later
        Windows Server 2012, Windows Server 2016, Windows Server 2019, or later
        You can have up to 5,000 activation codes per Alibaba Cloud region. When the number of activation codes exceeds 1,000, the usage of the activation codes must be greater than 50% before you can create additional activation codes.
        >  To obtain the usage of activation codes, go to the *ECS Cloud Assistant** page in the Elastic Compute Service (ECS) console, click the **Manage Instances** tab, and then click **Register Instance**.
        
        @param request: CreateActivationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateActivationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_count):
            query['InstanceCount'] = request.instance_count
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.ip_address_range):
            query['IpAddressRange'] = request.ip_address_range
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.time_to_live_in_hours):
            query['TimeToLiveInHours'] = request.time_to_live_in_hours
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateActivation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateActivationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_activation(
        self,
        request: ecs_20140526_models.CreateActivationRequest,
    ) -> ecs_20140526_models.CreateActivationResponse:
        """
        @summary Creates an activation code. The activation code is used to register servers that are not provided by Alibaba Cloud as Alibaba Cloud managed instances.
        
        @description ## [](#)Usage notes
        After you use an activation code to register a server that is not provided by Alibaba Cloud as an Alibaba Cloud managed instance, you can use various online services of Alibaba Cloud, such as Cloud Assistant, CloudOps Orchestration Service (OOS), and Apsara Devops, on the managed instance.
        If a server is not provided by Alibaba Cloud, you can register the server as an Alibaba Cloud managed instance only if the server has Internet connectivity and runs one of the following operating systems:
        Alibaba Cloud Linux 2, Alibaba Cloud Linux 3, or later
        CentOS 6, CentOS 7, CentOS 8, or later
        Debian 8, Debian 9, Debian 10, or later
        Ubuntu 12, Ubuntu 14, Ubuntu 16, Ubuntu 18, or later
        CoreOS
        OpenSUSE
        Red Hat 5, Red Hat 6, Red Hat 7, or later
        SUSE Linux Enterprise Server 11, SUSE Linux Enterprise Server 12, SUSE Linux Enterprise Server 15, or later
        Windows Server 2012, Windows Server 2016, Windows Server 2019, or later
        You can have up to 5,000 activation codes per Alibaba Cloud region. When the number of activation codes exceeds 1,000, the usage of the activation codes must be greater than 50% before you can create additional activation codes.
        >  To obtain the usage of activation codes, go to the *ECS Cloud Assistant** page in the Elastic Compute Service (ECS) console, click the **Manage Instances** tab, and then click **Register Instance**.
        
        @param request: CreateActivationRequest
        @return: CreateActivationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_activation_with_options(request, runtime)

    async def create_activation_async(
        self,
        request: ecs_20140526_models.CreateActivationRequest,
    ) -> ecs_20140526_models.CreateActivationResponse:
        """
        @summary Creates an activation code. The activation code is used to register servers that are not provided by Alibaba Cloud as Alibaba Cloud managed instances.
        
        @description ## [](#)Usage notes
        After you use an activation code to register a server that is not provided by Alibaba Cloud as an Alibaba Cloud managed instance, you can use various online services of Alibaba Cloud, such as Cloud Assistant, CloudOps Orchestration Service (OOS), and Apsara Devops, on the managed instance.
        If a server is not provided by Alibaba Cloud, you can register the server as an Alibaba Cloud managed instance only if the server has Internet connectivity and runs one of the following operating systems:
        Alibaba Cloud Linux 2, Alibaba Cloud Linux 3, or later
        CentOS 6, CentOS 7, CentOS 8, or later
        Debian 8, Debian 9, Debian 10, or later
        Ubuntu 12, Ubuntu 14, Ubuntu 16, Ubuntu 18, or later
        CoreOS
        OpenSUSE
        Red Hat 5, Red Hat 6, Red Hat 7, or later
        SUSE Linux Enterprise Server 11, SUSE Linux Enterprise Server 12, SUSE Linux Enterprise Server 15, or later
        Windows Server 2012, Windows Server 2016, Windows Server 2019, or later
        You can have up to 5,000 activation codes per Alibaba Cloud region. When the number of activation codes exceeds 1,000, the usage of the activation codes must be greater than 50% before you can create additional activation codes.
        >  To obtain the usage of activation codes, go to the *ECS Cloud Assistant** page in the Elastic Compute Service (ECS) console, click the **Manage Instances** tab, and then click **Register Instance**.
        
        @param request: CreateActivationRequest
        @return: CreateActivationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_activation_with_options_async(request, runtime)

    def create_auto_provisioning_group_with_options(
        self,
        tmp_req: ecs_20140526_models.CreateAutoProvisioningGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateAutoProvisioningGroupResponse:
        """
        @summary Creates an auto provisioning group.
        
        @description ## [](#)Usage notes
        Auto Provisioning is a service that allows quick deployment of an instance cluster that consists of spot instances and pay-as-you-go instances. Auto Provisioning supports push-button deployment of instance clusters across different billing methods, instance families, and zones. For more information, see [Use auto provisioning group-related API operations to create multiple ECS instances at the same time](https://help.aliyun.com/document_detail/200772.html).
        Auto Provisioning uses auto provisioning groups to schedule and maintain computing resources. You can use auto provisioning groups to obtain a steady supply of computing resources. This helps reduce the impact on compute capacity when spot instances are reclaimed.
        Auto Provisioning is provided free of charge. However, you are charged for instance resources that are created in auto provisioning groups. For more information, see [Overview of spot instances](https://help.aliyun.com/document_detail/52088.html) and [Pay-as-you-go](https://help.aliyun.com/document_detail/40653.html).
        When you specify both a launch template (`LaunchTemplateId`) and extended configurations (`LaunchConfiguration.*` parameters), LaunchTemplateId takes precedence.
        
        @param tmp_req: CreateAutoProvisioningGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAutoProvisioningGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ecs_20140526_models.CreateAutoProvisioningGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.resource_pool_options):
            request.resource_pool_options_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.resource_pool_options, 'ResourcePoolOptions', 'json')
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_name):
            query['AutoProvisioningGroupName'] = request.auto_provisioning_group_name
        if not UtilClient.is_unset(request.auto_provisioning_group_type):
            query['AutoProvisioningGroupType'] = request.auto_provisioning_group_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.data_disk_config):
            query['DataDiskConfig'] = request.data_disk_config
        if not UtilClient.is_unset(request.default_target_capacity_type):
            query['DefaultTargetCapacityType'] = request.default_target_capacity_type
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.excess_capacity_termination_policy):
            query['ExcessCapacityTerminationPolicy'] = request.excess_capacity_termination_policy
        if not UtilClient.is_unset(request.hibernation_options_configured):
            query['HibernationOptionsConfigured'] = request.hibernation_options_configured
        if not UtilClient.is_unset(request.launch_template_config):
            query['LaunchTemplateConfig'] = request.launch_template_config
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_version):
            query['LaunchTemplateVersion'] = request.launch_template_version
        if not UtilClient.is_unset(request.max_spot_price):
            query['MaxSpotPrice'] = request.max_spot_price
        if not UtilClient.is_unset(request.min_target_capacity):
            query['MinTargetCapacity'] = request.min_target_capacity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_as_you_go_allocation_strategy):
            query['PayAsYouGoAllocationStrategy'] = request.pay_as_you_go_allocation_strategy
        if not UtilClient.is_unset(request.pay_as_you_go_target_capacity):
            query['PayAsYouGoTargetCapacity'] = request.pay_as_you_go_target_capacity
        if not UtilClient.is_unset(request.pre_paid_options):
            query['PrePaidOptions'] = request.pre_paid_options
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_pool_options_shrink):
            query['ResourcePoolOptions'] = request.resource_pool_options_shrink
        if not UtilClient.is_unset(request.spot_allocation_strategy):
            query['SpotAllocationStrategy'] = request.spot_allocation_strategy
        if not UtilClient.is_unset(request.spot_instance_interruption_behavior):
            query['SpotInstanceInterruptionBehavior'] = request.spot_instance_interruption_behavior
        if not UtilClient.is_unset(request.spot_instance_pools_to_use_count):
            query['SpotInstancePoolsToUseCount'] = request.spot_instance_pools_to_use_count
        if not UtilClient.is_unset(request.spot_target_capacity):
            query['SpotTargetCapacity'] = request.spot_target_capacity
        if not UtilClient.is_unset(request.system_disk_config):
            query['SystemDiskConfig'] = request.system_disk_config
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.terminate_instances):
            query['TerminateInstances'] = request.terminate_instances
        if not UtilClient.is_unset(request.terminate_instances_with_expiration):
            query['TerminateInstancesWithExpiration'] = request.terminate_instances_with_expiration
        if not UtilClient.is_unset(request.total_target_capacity):
            query['TotalTargetCapacity'] = request.total_target_capacity
        if not UtilClient.is_unset(request.valid_from):
            query['ValidFrom'] = request.valid_from
        if not UtilClient.is_unset(request.valid_until):
            query['ValidUntil'] = request.valid_until
        if not UtilClient.is_unset(request.launch_configuration):
            query['LaunchConfiguration'] = request.launch_configuration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAutoProvisioningGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateAutoProvisioningGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_auto_provisioning_group_with_options_async(
        self,
        tmp_req: ecs_20140526_models.CreateAutoProvisioningGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateAutoProvisioningGroupResponse:
        """
        @summary Creates an auto provisioning group.
        
        @description ## [](#)Usage notes
        Auto Provisioning is a service that allows quick deployment of an instance cluster that consists of spot instances and pay-as-you-go instances. Auto Provisioning supports push-button deployment of instance clusters across different billing methods, instance families, and zones. For more information, see [Use auto provisioning group-related API operations to create multiple ECS instances at the same time](https://help.aliyun.com/document_detail/200772.html).
        Auto Provisioning uses auto provisioning groups to schedule and maintain computing resources. You can use auto provisioning groups to obtain a steady supply of computing resources. This helps reduce the impact on compute capacity when spot instances are reclaimed.
        Auto Provisioning is provided free of charge. However, you are charged for instance resources that are created in auto provisioning groups. For more information, see [Overview of spot instances](https://help.aliyun.com/document_detail/52088.html) and [Pay-as-you-go](https://help.aliyun.com/document_detail/40653.html).
        When you specify both a launch template (`LaunchTemplateId`) and extended configurations (`LaunchConfiguration.*` parameters), LaunchTemplateId takes precedence.
        
        @param tmp_req: CreateAutoProvisioningGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAutoProvisioningGroupResponse
        """
        UtilClient.validate_model(tmp_req)
        request = ecs_20140526_models.CreateAutoProvisioningGroupShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.resource_pool_options):
            request.resource_pool_options_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.resource_pool_options, 'ResourcePoolOptions', 'json')
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_name):
            query['AutoProvisioningGroupName'] = request.auto_provisioning_group_name
        if not UtilClient.is_unset(request.auto_provisioning_group_type):
            query['AutoProvisioningGroupType'] = request.auto_provisioning_group_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.data_disk_config):
            query['DataDiskConfig'] = request.data_disk_config
        if not UtilClient.is_unset(request.default_target_capacity_type):
            query['DefaultTargetCapacityType'] = request.default_target_capacity_type
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.excess_capacity_termination_policy):
            query['ExcessCapacityTerminationPolicy'] = request.excess_capacity_termination_policy
        if not UtilClient.is_unset(request.hibernation_options_configured):
            query['HibernationOptionsConfigured'] = request.hibernation_options_configured
        if not UtilClient.is_unset(request.launch_template_config):
            query['LaunchTemplateConfig'] = request.launch_template_config
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_version):
            query['LaunchTemplateVersion'] = request.launch_template_version
        if not UtilClient.is_unset(request.max_spot_price):
            query['MaxSpotPrice'] = request.max_spot_price
        if not UtilClient.is_unset(request.min_target_capacity):
            query['MinTargetCapacity'] = request.min_target_capacity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_as_you_go_allocation_strategy):
            query['PayAsYouGoAllocationStrategy'] = request.pay_as_you_go_allocation_strategy
        if not UtilClient.is_unset(request.pay_as_you_go_target_capacity):
            query['PayAsYouGoTargetCapacity'] = request.pay_as_you_go_target_capacity
        if not UtilClient.is_unset(request.pre_paid_options):
            query['PrePaidOptions'] = request.pre_paid_options
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_pool_options_shrink):
            query['ResourcePoolOptions'] = request.resource_pool_options_shrink
        if not UtilClient.is_unset(request.spot_allocation_strategy):
            query['SpotAllocationStrategy'] = request.spot_allocation_strategy
        if not UtilClient.is_unset(request.spot_instance_interruption_behavior):
            query['SpotInstanceInterruptionBehavior'] = request.spot_instance_interruption_behavior
        if not UtilClient.is_unset(request.spot_instance_pools_to_use_count):
            query['SpotInstancePoolsToUseCount'] = request.spot_instance_pools_to_use_count
        if not UtilClient.is_unset(request.spot_target_capacity):
            query['SpotTargetCapacity'] = request.spot_target_capacity
        if not UtilClient.is_unset(request.system_disk_config):
            query['SystemDiskConfig'] = request.system_disk_config
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.terminate_instances):
            query['TerminateInstances'] = request.terminate_instances
        if not UtilClient.is_unset(request.terminate_instances_with_expiration):
            query['TerminateInstancesWithExpiration'] = request.terminate_instances_with_expiration
        if not UtilClient.is_unset(request.total_target_capacity):
            query['TotalTargetCapacity'] = request.total_target_capacity
        if not UtilClient.is_unset(request.valid_from):
            query['ValidFrom'] = request.valid_from
        if not UtilClient.is_unset(request.valid_until):
            query['ValidUntil'] = request.valid_until
        if not UtilClient.is_unset(request.launch_configuration):
            query['LaunchConfiguration'] = request.launch_configuration
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAutoProvisioningGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateAutoProvisioningGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_auto_provisioning_group(
        self,
        request: ecs_20140526_models.CreateAutoProvisioningGroupRequest,
    ) -> ecs_20140526_models.CreateAutoProvisioningGroupResponse:
        """
        @summary Creates an auto provisioning group.
        
        @description ## [](#)Usage notes
        Auto Provisioning is a service that allows quick deployment of an instance cluster that consists of spot instances and pay-as-you-go instances. Auto Provisioning supports push-button deployment of instance clusters across different billing methods, instance families, and zones. For more information, see [Use auto provisioning group-related API operations to create multiple ECS instances at the same time](https://help.aliyun.com/document_detail/200772.html).
        Auto Provisioning uses auto provisioning groups to schedule and maintain computing resources. You can use auto provisioning groups to obtain a steady supply of computing resources. This helps reduce the impact on compute capacity when spot instances are reclaimed.
        Auto Provisioning is provided free of charge. However, you are charged for instance resources that are created in auto provisioning groups. For more information, see [Overview of spot instances](https://help.aliyun.com/document_detail/52088.html) and [Pay-as-you-go](https://help.aliyun.com/document_detail/40653.html).
        When you specify both a launch template (`LaunchTemplateId`) and extended configurations (`LaunchConfiguration.*` parameters), LaunchTemplateId takes precedence.
        
        @param request: CreateAutoProvisioningGroupRequest
        @return: CreateAutoProvisioningGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_auto_provisioning_group_with_options(request, runtime)

    async def create_auto_provisioning_group_async(
        self,
        request: ecs_20140526_models.CreateAutoProvisioningGroupRequest,
    ) -> ecs_20140526_models.CreateAutoProvisioningGroupResponse:
        """
        @summary Creates an auto provisioning group.
        
        @description ## [](#)Usage notes
        Auto Provisioning is a service that allows quick deployment of an instance cluster that consists of spot instances and pay-as-you-go instances. Auto Provisioning supports push-button deployment of instance clusters across different billing methods, instance families, and zones. For more information, see [Use auto provisioning group-related API operations to create multiple ECS instances at the same time](https://help.aliyun.com/document_detail/200772.html).
        Auto Provisioning uses auto provisioning groups to schedule and maintain computing resources. You can use auto provisioning groups to obtain a steady supply of computing resources. This helps reduce the impact on compute capacity when spot instances are reclaimed.
        Auto Provisioning is provided free of charge. However, you are charged for instance resources that are created in auto provisioning groups. For more information, see [Overview of spot instances](https://help.aliyun.com/document_detail/52088.html) and [Pay-as-you-go](https://help.aliyun.com/document_detail/40653.html).
        When you specify both a launch template (`LaunchTemplateId`) and extended configurations (`LaunchConfiguration.*` parameters), LaunchTemplateId takes precedence.
        
        @param request: CreateAutoProvisioningGroupRequest
        @return: CreateAutoProvisioningGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_auto_provisioning_group_with_options_async(request, runtime)

    def create_auto_snapshot_policy_with_options(
        self,
        request: ecs_20140526_models.CreateAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateAutoSnapshotPolicyResponse:
        """
        @summary Creates an automatic snapshot policy in a specific region. You can specify the schedule on which to create automatic snapshots, the retention period of the automatic snapshots, and whether to enable cross-region replication for the snapshots in the automatic snapshot policy. The automatic snapshot policy can be applied to create snapshots for system disks or data disks to back up disk data.
        
        @description Before you call this operation, learn about how to [create an automatic snapshot policy](https://help.aliyun.com/document_detail/127767.html).
        Take note of the following items:
        You can create up to 100 automatic snapshot policies per region for a single Alibaba Cloud account. If the maximum number of automatic snapshots for a disk is reached and a new snapshot creation task is created, the system deletes the oldest automatic snapshot of the disk.
        If the instance to which a disk is attached is being stopped or restarted, the system cannot create snapshots for the disk based on the associated automatic snapshot policy.
        If cross-region snapshot replication is enabled and no encryption parameters are configured, encrypted snapshots are copied to the destination region and snapshot copies are encrypted by using the service key of the destination region. For more information about the limits on cross-region snapshot replication, see [Copy a snapshot](https://help.aliyun.com/document_detail/159441.html).
        After the automatic snapshot policy is created, call the [ApplyAutoSnapshotPolicy](https://help.aliyun.com/document_detail/25531.html) operation to apply the policy to disks. If you want to modify the automatic snapshot policy, call the [ModifyAutoSnapshotPolicyEx](https://help.aliyun.com/document_detail/25529.html) operation.
        
        @param request: CreateAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.copied_snapshots_retention_days):
            query['CopiedSnapshotsRetentionDays'] = request.copied_snapshots_retention_days
        if not UtilClient.is_unset(request.copy_encryption_configuration):
            query['CopyEncryptionConfiguration'] = request.copy_encryption_configuration
        if not UtilClient.is_unset(request.enable_cross_region_copy):
            query['EnableCrossRegionCopy'] = request.enable_cross_region_copy
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.target_copy_regions):
            query['TargetCopyRegions'] = request.target_copy_regions
        if not UtilClient.is_unset(request.auto_snapshot_policy_name):
            query['autoSnapshotPolicyName'] = request.auto_snapshot_policy_name
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_weekdays):
            query['repeatWeekdays'] = request.repeat_weekdays
        if not UtilClient.is_unset(request.retention_days):
            query['retentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.time_points):
            query['timePoints'] = request.time_points
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateAutoSnapshotPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_auto_snapshot_policy_with_options_async(
        self,
        request: ecs_20140526_models.CreateAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateAutoSnapshotPolicyResponse:
        """
        @summary Creates an automatic snapshot policy in a specific region. You can specify the schedule on which to create automatic snapshots, the retention period of the automatic snapshots, and whether to enable cross-region replication for the snapshots in the automatic snapshot policy. The automatic snapshot policy can be applied to create snapshots for system disks or data disks to back up disk data.
        
        @description Before you call this operation, learn about how to [create an automatic snapshot policy](https://help.aliyun.com/document_detail/127767.html).
        Take note of the following items:
        You can create up to 100 automatic snapshot policies per region for a single Alibaba Cloud account. If the maximum number of automatic snapshots for a disk is reached and a new snapshot creation task is created, the system deletes the oldest automatic snapshot of the disk.
        If the instance to which a disk is attached is being stopped or restarted, the system cannot create snapshots for the disk based on the associated automatic snapshot policy.
        If cross-region snapshot replication is enabled and no encryption parameters are configured, encrypted snapshots are copied to the destination region and snapshot copies are encrypted by using the service key of the destination region. For more information about the limits on cross-region snapshot replication, see [Copy a snapshot](https://help.aliyun.com/document_detail/159441.html).
        After the automatic snapshot policy is created, call the [ApplyAutoSnapshotPolicy](https://help.aliyun.com/document_detail/25531.html) operation to apply the policy to disks. If you want to modify the automatic snapshot policy, call the [ModifyAutoSnapshotPolicyEx](https://help.aliyun.com/document_detail/25529.html) operation.
        
        @param request: CreateAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.copied_snapshots_retention_days):
            query['CopiedSnapshotsRetentionDays'] = request.copied_snapshots_retention_days
        if not UtilClient.is_unset(request.copy_encryption_configuration):
            query['CopyEncryptionConfiguration'] = request.copy_encryption_configuration
        if not UtilClient.is_unset(request.enable_cross_region_copy):
            query['EnableCrossRegionCopy'] = request.enable_cross_region_copy
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.target_copy_regions):
            query['TargetCopyRegions'] = request.target_copy_regions
        if not UtilClient.is_unset(request.auto_snapshot_policy_name):
            query['autoSnapshotPolicyName'] = request.auto_snapshot_policy_name
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        if not UtilClient.is_unset(request.repeat_weekdays):
            query['repeatWeekdays'] = request.repeat_weekdays
        if not UtilClient.is_unset(request.retention_days):
            query['retentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.time_points):
            query['timePoints'] = request.time_points
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateAutoSnapshotPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_auto_snapshot_policy(
        self,
        request: ecs_20140526_models.CreateAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.CreateAutoSnapshotPolicyResponse:
        """
        @summary Creates an automatic snapshot policy in a specific region. You can specify the schedule on which to create automatic snapshots, the retention period of the automatic snapshots, and whether to enable cross-region replication for the snapshots in the automatic snapshot policy. The automatic snapshot policy can be applied to create snapshots for system disks or data disks to back up disk data.
        
        @description Before you call this operation, learn about how to [create an automatic snapshot policy](https://help.aliyun.com/document_detail/127767.html).
        Take note of the following items:
        You can create up to 100 automatic snapshot policies per region for a single Alibaba Cloud account. If the maximum number of automatic snapshots for a disk is reached and a new snapshot creation task is created, the system deletes the oldest automatic snapshot of the disk.
        If the instance to which a disk is attached is being stopped or restarted, the system cannot create snapshots for the disk based on the associated automatic snapshot policy.
        If cross-region snapshot replication is enabled and no encryption parameters are configured, encrypted snapshots are copied to the destination region and snapshot copies are encrypted by using the service key of the destination region. For more information about the limits on cross-region snapshot replication, see [Copy a snapshot](https://help.aliyun.com/document_detail/159441.html).
        After the automatic snapshot policy is created, call the [ApplyAutoSnapshotPolicy](https://help.aliyun.com/document_detail/25531.html) operation to apply the policy to disks. If you want to modify the automatic snapshot policy, call the [ModifyAutoSnapshotPolicyEx](https://help.aliyun.com/document_detail/25529.html) operation.
        
        @param request: CreateAutoSnapshotPolicyRequest
        @return: CreateAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_auto_snapshot_policy_with_options(request, runtime)

    async def create_auto_snapshot_policy_async(
        self,
        request: ecs_20140526_models.CreateAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.CreateAutoSnapshotPolicyResponse:
        """
        @summary Creates an automatic snapshot policy in a specific region. You can specify the schedule on which to create automatic snapshots, the retention period of the automatic snapshots, and whether to enable cross-region replication for the snapshots in the automatic snapshot policy. The automatic snapshot policy can be applied to create snapshots for system disks or data disks to back up disk data.
        
        @description Before you call this operation, learn about how to [create an automatic snapshot policy](https://help.aliyun.com/document_detail/127767.html).
        Take note of the following items:
        You can create up to 100 automatic snapshot policies per region for a single Alibaba Cloud account. If the maximum number of automatic snapshots for a disk is reached and a new snapshot creation task is created, the system deletes the oldest automatic snapshot of the disk.
        If the instance to which a disk is attached is being stopped or restarted, the system cannot create snapshots for the disk based on the associated automatic snapshot policy.
        If cross-region snapshot replication is enabled and no encryption parameters are configured, encrypted snapshots are copied to the destination region and snapshot copies are encrypted by using the service key of the destination region. For more information about the limits on cross-region snapshot replication, see [Copy a snapshot](https://help.aliyun.com/document_detail/159441.html).
        After the automatic snapshot policy is created, call the [ApplyAutoSnapshotPolicy](https://help.aliyun.com/document_detail/25531.html) operation to apply the policy to disks. If you want to modify the automatic snapshot policy, call the [ModifyAutoSnapshotPolicyEx](https://help.aliyun.com/document_detail/25529.html) operation.
        
        @param request: CreateAutoSnapshotPolicyRequest
        @return: CreateAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_auto_snapshot_policy_with_options_async(request, runtime)

    def create_capacity_reservation_with_options(
        self,
        request: ecs_20140526_models.CreateCapacityReservationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateCapacityReservationResponse:
        """
        @summary Creates a capacity reservation.
        
        @description When you create a capacity reservation, you can specify attributes such as a zone and an instance type. The system uses a private pool to reserve resources that match the specified attributes. For more information, see [Overview of Immediate Capacity Reservation](https://help.aliyun.com/document_detail/193633.html).
        Currently, only immediate capacity reservations are supported. Immediate capacity reservations take effect immediately after you purchase them. After you purchase an immediate capacity reservation, you are charged for the specified instance type based on the pay-as-you-go billing method regardless of whether you use the capacity reservation to create pay-as-you-go instances. Billing stops when you manually release the capacity reservation or when the capacity reservation expires and is automatically released.
        You can call the [CreateInstance](https://help.aliyun.com/document_detail/25499.html) or [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to specify private pool attributes when you create instances. To modify the attributes of a private pool, you can call the [ModifyInstanceAttachmentAttributes](https://help.aliyun.com/document_detail/190006.html) operation. If an instance matches a private pool associated with a capacity reservation, you are charged based on the configurations of the instance such as the instance type, disks, and public bandwidth.
        Before you use a private pool associated with a capacity reservation to create pay-as-you-go instances, you are charged only for the specified instance type.
        You can apply savings plans or regional reserved instances to offset hourly billing of unused immediate capacity reservations, and hourly fees of the instances that match the immediate capacity reservations. However, you cannot use zonal reserved instances to offset the hourly fees. We recommend that you purchase reserved instances or savings plans before you purchase immediate capacity reservations. This way, you can access resources free of charge within the coverage of the reserved instances or savings plans.
        > You can call the CreateCapacityReservation operation to create only immediate capacity reservations. You can create immediate or scheduled capacity reservations in the Elastic Compute Service (ECS) console. For more information, see [Overview](~~193626#section-oil-qh5-xvx~~).
        
        @param request: CreateCapacityReservationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCapacityReservationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_time_type):
            query['EndTimeType'] = request.end_time_type
        if not UtilClient.is_unset(request.instance_amount):
            query['InstanceAmount'] = request.instance_amount
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCapacityReservation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateCapacityReservationResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_capacity_reservation_with_options_async(
        self,
        request: ecs_20140526_models.CreateCapacityReservationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateCapacityReservationResponse:
        """
        @summary Creates a capacity reservation.
        
        @description When you create a capacity reservation, you can specify attributes such as a zone and an instance type. The system uses a private pool to reserve resources that match the specified attributes. For more information, see [Overview of Immediate Capacity Reservation](https://help.aliyun.com/document_detail/193633.html).
        Currently, only immediate capacity reservations are supported. Immediate capacity reservations take effect immediately after you purchase them. After you purchase an immediate capacity reservation, you are charged for the specified instance type based on the pay-as-you-go billing method regardless of whether you use the capacity reservation to create pay-as-you-go instances. Billing stops when you manually release the capacity reservation or when the capacity reservation expires and is automatically released.
        You can call the [CreateInstance](https://help.aliyun.com/document_detail/25499.html) or [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to specify private pool attributes when you create instances. To modify the attributes of a private pool, you can call the [ModifyInstanceAttachmentAttributes](https://help.aliyun.com/document_detail/190006.html) operation. If an instance matches a private pool associated with a capacity reservation, you are charged based on the configurations of the instance such as the instance type, disks, and public bandwidth.
        Before you use a private pool associated with a capacity reservation to create pay-as-you-go instances, you are charged only for the specified instance type.
        You can apply savings plans or regional reserved instances to offset hourly billing of unused immediate capacity reservations, and hourly fees of the instances that match the immediate capacity reservations. However, you cannot use zonal reserved instances to offset the hourly fees. We recommend that you purchase reserved instances or savings plans before you purchase immediate capacity reservations. This way, you can access resources free of charge within the coverage of the reserved instances or savings plans.
        > You can call the CreateCapacityReservation operation to create only immediate capacity reservations. You can create immediate or scheduled capacity reservations in the Elastic Compute Service (ECS) console. For more information, see [Overview](~~193626#section-oil-qh5-xvx~~).
        
        @param request: CreateCapacityReservationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCapacityReservationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.end_time_type):
            query['EndTimeType'] = request.end_time_type
        if not UtilClient.is_unset(request.instance_amount):
            query['InstanceAmount'] = request.instance_amount
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCapacityReservation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateCapacityReservationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_capacity_reservation(
        self,
        request: ecs_20140526_models.CreateCapacityReservationRequest,
    ) -> ecs_20140526_models.CreateCapacityReservationResponse:
        """
        @summary Creates a capacity reservation.
        
        @description When you create a capacity reservation, you can specify attributes such as a zone and an instance type. The system uses a private pool to reserve resources that match the specified attributes. For more information, see [Overview of Immediate Capacity Reservation](https://help.aliyun.com/document_detail/193633.html).
        Currently, only immediate capacity reservations are supported. Immediate capacity reservations take effect immediately after you purchase them. After you purchase an immediate capacity reservation, you are charged for the specified instance type based on the pay-as-you-go billing method regardless of whether you use the capacity reservation to create pay-as-you-go instances. Billing stops when you manually release the capacity reservation or when the capacity reservation expires and is automatically released.
        You can call the [CreateInstance](https://help.aliyun.com/document_detail/25499.html) or [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to specify private pool attributes when you create instances. To modify the attributes of a private pool, you can call the [ModifyInstanceAttachmentAttributes](https://help.aliyun.com/document_detail/190006.html) operation. If an instance matches a private pool associated with a capacity reservation, you are charged based on the configurations of the instance such as the instance type, disks, and public bandwidth.
        Before you use a private pool associated with a capacity reservation to create pay-as-you-go instances, you are charged only for the specified instance type.
        You can apply savings plans or regional reserved instances to offset hourly billing of unused immediate capacity reservations, and hourly fees of the instances that match the immediate capacity reservations. However, you cannot use zonal reserved instances to offset the hourly fees. We recommend that you purchase reserved instances or savings plans before you purchase immediate capacity reservations. This way, you can access resources free of charge within the coverage of the reserved instances or savings plans.
        > You can call the CreateCapacityReservation operation to create only immediate capacity reservations. You can create immediate or scheduled capacity reservations in the Elastic Compute Service (ECS) console. For more information, see [Overview](~~193626#section-oil-qh5-xvx~~).
        
        @param request: CreateCapacityReservationRequest
        @return: CreateCapacityReservationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_capacity_reservation_with_options(request, runtime)

    async def create_capacity_reservation_async(
        self,
        request: ecs_20140526_models.CreateCapacityReservationRequest,
    ) -> ecs_20140526_models.CreateCapacityReservationResponse:
        """
        @summary Creates a capacity reservation.
        
        @description When you create a capacity reservation, you can specify attributes such as a zone and an instance type. The system uses a private pool to reserve resources that match the specified attributes. For more information, see [Overview of Immediate Capacity Reservation](https://help.aliyun.com/document_detail/193633.html).
        Currently, only immediate capacity reservations are supported. Immediate capacity reservations take effect immediately after you purchase them. After you purchase an immediate capacity reservation, you are charged for the specified instance type based on the pay-as-you-go billing method regardless of whether you use the capacity reservation to create pay-as-you-go instances. Billing stops when you manually release the capacity reservation or when the capacity reservation expires and is automatically released.
        You can call the [CreateInstance](https://help.aliyun.com/document_detail/25499.html) or [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to specify private pool attributes when you create instances. To modify the attributes of a private pool, you can call the [ModifyInstanceAttachmentAttributes](https://help.aliyun.com/document_detail/190006.html) operation. If an instance matches a private pool associated with a capacity reservation, you are charged based on the configurations of the instance such as the instance type, disks, and public bandwidth.
        Before you use a private pool associated with a capacity reservation to create pay-as-you-go instances, you are charged only for the specified instance type.
        You can apply savings plans or regional reserved instances to offset hourly billing of unused immediate capacity reservations, and hourly fees of the instances that match the immediate capacity reservations. However, you cannot use zonal reserved instances to offset the hourly fees. We recommend that you purchase reserved instances or savings plans before you purchase immediate capacity reservations. This way, you can access resources free of charge within the coverage of the reserved instances or savings plans.
        > You can call the CreateCapacityReservation operation to create only immediate capacity reservations. You can create immediate or scheduled capacity reservations in the Elastic Compute Service (ECS) console. For more information, see [Overview](~~193626#section-oil-qh5-xvx~~).
        
        @param request: CreateCapacityReservationRequest
        @return: CreateCapacityReservationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_capacity_reservation_with_options_async(request, runtime)

    def create_command_with_options(
        self,
        request: ecs_20140526_models.CreateCommandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateCommandResponse:
        """
        @summary Creates a Cloud Assistant command, which can be a Shell, PowerShell, or batch command.
        
        @description ## [](#)Usage notes
        You can create commands of the following types:
        Batch commands (RunBatScript), applicable to Windows instances
        PowerShell commands (RunPowerShellScript), applicable to Windows instances
        Shell commands (RunShellScript), applicable to Linux instances
        You can specify the Timeout parameter to set the maximum timeout period for executions of a command on Elastic Compute Service (ECS) instances. If an execution times out, [Cloud Assistant Agent](https://help.aliyun.com/document_detail/64921.html) forcefully terminates the command process by canceling the process ID (PID) of the command.
        For a one-time task, when the execution times out, the state of the command ([InvokeRecordStatus](https://help.aliyun.com/document_detail/64845.html)) becomes Failed.
        For a scheduled task, take note of the following items:
        The timeout period takes effect on each execution.
        When an execution times out, the state ([InvokeRecordStatus](https://help.aliyun.com/document_detail/64845.html)) of the command becomes Failed.
        The timeout of one execution does not affect the subsequent executions.
        You can retain up to 500 to 50,000 Cloud Assistant commands in each region. You can also apply for a quota increase. For information about how to query and increase quotas, see [Manage quotas](https://help.aliyun.com/document_detail/184116.html).
        You can use WorkingDir to specify the execution directory of a Cloud Assistant command. For Linux instances, the default execution directory of Cloud Assistant commands is the home directory of the root user, which is `/root`. For Windows instances, the default execution directory of Cloud Assistant commands is the directory where the Cloud Assistant Agent process resides, such as `C:\\Windows\\System32`.
        You can enable the custom parameter feature for a Cloud Assistant command by setting EnableParameter to true. When you set CommandContent, you can define custom parameters in the {{parameter}} format. Then, when the [InvokeCommand](https://help.aliyun.com/document_detail/64841.html) operation is called, the key-value pairs of custom parameters are passed in. For example, if a command is `echo {{name}}`, the Parameters parameter can be used to pass in the `<name, Jack>` key-value pair when the InvokeCommand operation is called. The name key of the custom parameter is automatically replaced by the paired Jack value to generate a new command. As a result, the `echo Jack` command is run.
        
        @param request: CreateCommandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCommandResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_content):
            query['CommandContent'] = request.command_content
        if not UtilClient.is_unset(request.content_encoding):
            query['ContentEncoding'] = request.content_encoding
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_parameter):
            query['EnableParameter'] = request.enable_parameter
        if not UtilClient.is_unset(request.launcher):
            query['Launcher'] = request.launcher
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.timeout):
            query['Timeout'] = request.timeout
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.working_dir):
            query['WorkingDir'] = request.working_dir
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCommand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateCommandResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_command_with_options_async(
        self,
        request: ecs_20140526_models.CreateCommandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateCommandResponse:
        """
        @summary Creates a Cloud Assistant command, which can be a Shell, PowerShell, or batch command.
        
        @description ## [](#)Usage notes
        You can create commands of the following types:
        Batch commands (RunBatScript), applicable to Windows instances
        PowerShell commands (RunPowerShellScript), applicable to Windows instances
        Shell commands (RunShellScript), applicable to Linux instances
        You can specify the Timeout parameter to set the maximum timeout period for executions of a command on Elastic Compute Service (ECS) instances. If an execution times out, [Cloud Assistant Agent](https://help.aliyun.com/document_detail/64921.html) forcefully terminates the command process by canceling the process ID (PID) of the command.
        For a one-time task, when the execution times out, the state of the command ([InvokeRecordStatus](https://help.aliyun.com/document_detail/64845.html)) becomes Failed.
        For a scheduled task, take note of the following items:
        The timeout period takes effect on each execution.
        When an execution times out, the state ([InvokeRecordStatus](https://help.aliyun.com/document_detail/64845.html)) of the command becomes Failed.
        The timeout of one execution does not affect the subsequent executions.
        You can retain up to 500 to 50,000 Cloud Assistant commands in each region. You can also apply for a quota increase. For information about how to query and increase quotas, see [Manage quotas](https://help.aliyun.com/document_detail/184116.html).
        You can use WorkingDir to specify the execution directory of a Cloud Assistant command. For Linux instances, the default execution directory of Cloud Assistant commands is the home directory of the root user, which is `/root`. For Windows instances, the default execution directory of Cloud Assistant commands is the directory where the Cloud Assistant Agent process resides, such as `C:\\Windows\\System32`.
        You can enable the custom parameter feature for a Cloud Assistant command by setting EnableParameter to true. When you set CommandContent, you can define custom parameters in the {{parameter}} format. Then, when the [InvokeCommand](https://help.aliyun.com/document_detail/64841.html) operation is called, the key-value pairs of custom parameters are passed in. For example, if a command is `echo {{name}}`, the Parameters parameter can be used to pass in the `<name, Jack>` key-value pair when the InvokeCommand operation is called. The name key of the custom parameter is automatically replaced by the paired Jack value to generate a new command. As a result, the `echo Jack` command is run.
        
        @param request: CreateCommandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateCommandResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_content):
            query['CommandContent'] = request.command_content
        if not UtilClient.is_unset(request.content_encoding):
            query['ContentEncoding'] = request.content_encoding
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_parameter):
            query['EnableParameter'] = request.enable_parameter
        if not UtilClient.is_unset(request.launcher):
            query['Launcher'] = request.launcher
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.timeout):
            query['Timeout'] = request.timeout
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.working_dir):
            query['WorkingDir'] = request.working_dir
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCommand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateCommandResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_command(
        self,
        request: ecs_20140526_models.CreateCommandRequest,
    ) -> ecs_20140526_models.CreateCommandResponse:
        """
        @summary Creates a Cloud Assistant command, which can be a Shell, PowerShell, or batch command.
        
        @description ## [](#)Usage notes
        You can create commands of the following types:
        Batch commands (RunBatScript), applicable to Windows instances
        PowerShell commands (RunPowerShellScript), applicable to Windows instances
        Shell commands (RunShellScript), applicable to Linux instances
        You can specify the Timeout parameter to set the maximum timeout period for executions of a command on Elastic Compute Service (ECS) instances. If an execution times out, [Cloud Assistant Agent](https://help.aliyun.com/document_detail/64921.html) forcefully terminates the command process by canceling the process ID (PID) of the command.
        For a one-time task, when the execution times out, the state of the command ([InvokeRecordStatus](https://help.aliyun.com/document_detail/64845.html)) becomes Failed.
        For a scheduled task, take note of the following items:
        The timeout period takes effect on each execution.
        When an execution times out, the state ([InvokeRecordStatus](https://help.aliyun.com/document_detail/64845.html)) of the command becomes Failed.
        The timeout of one execution does not affect the subsequent executions.
        You can retain up to 500 to 50,000 Cloud Assistant commands in each region. You can also apply for a quota increase. For information about how to query and increase quotas, see [Manage quotas](https://help.aliyun.com/document_detail/184116.html).
        You can use WorkingDir to specify the execution directory of a Cloud Assistant command. For Linux instances, the default execution directory of Cloud Assistant commands is the home directory of the root user, which is `/root`. For Windows instances, the default execution directory of Cloud Assistant commands is the directory where the Cloud Assistant Agent process resides, such as `C:\\Windows\\System32`.
        You can enable the custom parameter feature for a Cloud Assistant command by setting EnableParameter to true. When you set CommandContent, you can define custom parameters in the {{parameter}} format. Then, when the [InvokeCommand](https://help.aliyun.com/document_detail/64841.html) operation is called, the key-value pairs of custom parameters are passed in. For example, if a command is `echo {{name}}`, the Parameters parameter can be used to pass in the `<name, Jack>` key-value pair when the InvokeCommand operation is called. The name key of the custom parameter is automatically replaced by the paired Jack value to generate a new command. As a result, the `echo Jack` command is run.
        
        @param request: CreateCommandRequest
        @return: CreateCommandResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_command_with_options(request, runtime)

    async def create_command_async(
        self,
        request: ecs_20140526_models.CreateCommandRequest,
    ) -> ecs_20140526_models.CreateCommandResponse:
        """
        @summary Creates a Cloud Assistant command, which can be a Shell, PowerShell, or batch command.
        
        @description ## [](#)Usage notes
        You can create commands of the following types:
        Batch commands (RunBatScript), applicable to Windows instances
        PowerShell commands (RunPowerShellScript), applicable to Windows instances
        Shell commands (RunShellScript), applicable to Linux instances
        You can specify the Timeout parameter to set the maximum timeout period for executions of a command on Elastic Compute Service (ECS) instances. If an execution times out, [Cloud Assistant Agent](https://help.aliyun.com/document_detail/64921.html) forcefully terminates the command process by canceling the process ID (PID) of the command.
        For a one-time task, when the execution times out, the state of the command ([InvokeRecordStatus](https://help.aliyun.com/document_detail/64845.html)) becomes Failed.
        For a scheduled task, take note of the following items:
        The timeout period takes effect on each execution.
        When an execution times out, the state ([InvokeRecordStatus](https://help.aliyun.com/document_detail/64845.html)) of the command becomes Failed.
        The timeout of one execution does not affect the subsequent executions.
        You can retain up to 500 to 50,000 Cloud Assistant commands in each region. You can also apply for a quota increase. For information about how to query and increase quotas, see [Manage quotas](https://help.aliyun.com/document_detail/184116.html).
        You can use WorkingDir to specify the execution directory of a Cloud Assistant command. For Linux instances, the default execution directory of Cloud Assistant commands is the home directory of the root user, which is `/root`. For Windows instances, the default execution directory of Cloud Assistant commands is the directory where the Cloud Assistant Agent process resides, such as `C:\\Windows\\System32`.
        You can enable the custom parameter feature for a Cloud Assistant command by setting EnableParameter to true. When you set CommandContent, you can define custom parameters in the {{parameter}} format. Then, when the [InvokeCommand](https://help.aliyun.com/document_detail/64841.html) operation is called, the key-value pairs of custom parameters are passed in. For example, if a command is `echo {{name}}`, the Parameters parameter can be used to pass in the `<name, Jack>` key-value pair when the InvokeCommand operation is called. The name key of the custom parameter is automatically replaced by the paired Jack value to generate a new command. As a result, the `echo Jack` command is run.
        
        @param request: CreateCommandRequest
        @return: CreateCommandResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_command_with_options_async(request, runtime)

    def create_dedicated_host_cluster_with_options(
        self,
        request: ecs_20140526_models.CreateDedicatedHostClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDedicatedHostClusterResponse:
        """
        @summary Creates a dedicated host group.
        
        @param request: CreateDedicatedHostClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDedicatedHostClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_name):
            query['DedicatedHostClusterName'] = request.dedicated_host_cluster_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDedicatedHostCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDedicatedHostClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dedicated_host_cluster_with_options_async(
        self,
        request: ecs_20140526_models.CreateDedicatedHostClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDedicatedHostClusterResponse:
        """
        @summary Creates a dedicated host group.
        
        @param request: CreateDedicatedHostClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDedicatedHostClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_name):
            query['DedicatedHostClusterName'] = request.dedicated_host_cluster_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDedicatedHostCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDedicatedHostClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dedicated_host_cluster(
        self,
        request: ecs_20140526_models.CreateDedicatedHostClusterRequest,
    ) -> ecs_20140526_models.CreateDedicatedHostClusterResponse:
        """
        @summary Creates a dedicated host group.
        
        @param request: CreateDedicatedHostClusterRequest
        @return: CreateDedicatedHostClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_dedicated_host_cluster_with_options(request, runtime)

    async def create_dedicated_host_cluster_async(
        self,
        request: ecs_20140526_models.CreateDedicatedHostClusterRequest,
    ) -> ecs_20140526_models.CreateDedicatedHostClusterResponse:
        """
        @summary Creates a dedicated host group.
        
        @param request: CreateDedicatedHostClusterRequest
        @return: CreateDedicatedHostClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_dedicated_host_cluster_with_options_async(request, runtime)

    def create_deployment_set_with_options(
        self,
        request: ecs_20140526_models.CreateDeploymentSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDeploymentSetResponse:
        """
        @summary Creates a deployment set in a region.
        
        @param request: CreateDeploymentSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDeploymentSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.deployment_set_name):
            query['DeploymentSetName'] = request.deployment_set_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.granularity):
            query['Granularity'] = request.granularity
        if not UtilClient.is_unset(request.group_count):
            query['GroupCount'] = request.group_count
        if not UtilClient.is_unset(request.on_unable_to_redeploy_failed_instance):
            query['OnUnableToRedeployFailedInstance'] = request.on_unable_to_redeploy_failed_instance
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDeploymentSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDeploymentSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_deployment_set_with_options_async(
        self,
        request: ecs_20140526_models.CreateDeploymentSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDeploymentSetResponse:
        """
        @summary Creates a deployment set in a region.
        
        @param request: CreateDeploymentSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDeploymentSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.deployment_set_name):
            query['DeploymentSetName'] = request.deployment_set_name
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.granularity):
            query['Granularity'] = request.granularity
        if not UtilClient.is_unset(request.group_count):
            query['GroupCount'] = request.group_count
        if not UtilClient.is_unset(request.on_unable_to_redeploy_failed_instance):
            query['OnUnableToRedeployFailedInstance'] = request.on_unable_to_redeploy_failed_instance
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.strategy):
            query['Strategy'] = request.strategy
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDeploymentSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDeploymentSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_deployment_set(
        self,
        request: ecs_20140526_models.CreateDeploymentSetRequest,
    ) -> ecs_20140526_models.CreateDeploymentSetResponse:
        """
        @summary Creates a deployment set in a region.
        
        @param request: CreateDeploymentSetRequest
        @return: CreateDeploymentSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_deployment_set_with_options(request, runtime)

    async def create_deployment_set_async(
        self,
        request: ecs_20140526_models.CreateDeploymentSetRequest,
    ) -> ecs_20140526_models.CreateDeploymentSetResponse:
        """
        @summary Creates a deployment set in a region.
        
        @param request: CreateDeploymentSetRequest
        @return: CreateDeploymentSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_deployment_set_with_options_async(request, runtime)

    def create_diagnostic_metric_set_with_options(
        self,
        request: ecs_20140526_models.CreateDiagnosticMetricSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiagnosticMetricSetResponse:
        """
        @summary Creates a diagnostic metric set. You can group diagnostic metrics into diagnostic metric sets.
        
        @param request: CreateDiagnosticMetricSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiagnosticMetricSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.metric_ids):
            query['MetricIds'] = request.metric_ids
        if not UtilClient.is_unset(request.metric_set_name):
            query['MetricSetName'] = request.metric_set_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDiagnosticMetricSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiagnosticMetricSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_diagnostic_metric_set_with_options_async(
        self,
        request: ecs_20140526_models.CreateDiagnosticMetricSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiagnosticMetricSetResponse:
        """
        @summary Creates a diagnostic metric set. You can group diagnostic metrics into diagnostic metric sets.
        
        @param request: CreateDiagnosticMetricSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiagnosticMetricSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.metric_ids):
            query['MetricIds'] = request.metric_ids
        if not UtilClient.is_unset(request.metric_set_name):
            query['MetricSetName'] = request.metric_set_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDiagnosticMetricSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiagnosticMetricSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_diagnostic_metric_set(
        self,
        request: ecs_20140526_models.CreateDiagnosticMetricSetRequest,
    ) -> ecs_20140526_models.CreateDiagnosticMetricSetResponse:
        """
        @summary Creates a diagnostic metric set. You can group diagnostic metrics into diagnostic metric sets.
        
        @param request: CreateDiagnosticMetricSetRequest
        @return: CreateDiagnosticMetricSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_diagnostic_metric_set_with_options(request, runtime)

    async def create_diagnostic_metric_set_async(
        self,
        request: ecs_20140526_models.CreateDiagnosticMetricSetRequest,
    ) -> ecs_20140526_models.CreateDiagnosticMetricSetResponse:
        """
        @summary Creates a diagnostic metric set. You can group diagnostic metrics into diagnostic metric sets.
        
        @param request: CreateDiagnosticMetricSetRequest
        @return: CreateDiagnosticMetricSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_diagnostic_metric_set_with_options_async(request, runtime)

    def create_diagnostic_report_with_options(
        self,
        request: ecs_20140526_models.CreateDiagnosticReportRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiagnosticReportResponse:
        """
        @summary Creates a diagnostic report for a resource. When you call this operation, you can configure the MetricSetId parameter to create a diagnostic report based on the specified diagnostic metric set. Then, you can call the DescribeDiagnosticReportAttributes operation based on the returned diagnostic report ID to view the details of the diagnostic report.
        
        @param request: CreateDiagnosticReportRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiagnosticReportResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.metric_set_id):
            query['MetricSetId'] = request.metric_set_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDiagnosticReport',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiagnosticReportResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_diagnostic_report_with_options_async(
        self,
        request: ecs_20140526_models.CreateDiagnosticReportRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiagnosticReportResponse:
        """
        @summary Creates a diagnostic report for a resource. When you call this operation, you can configure the MetricSetId parameter to create a diagnostic report based on the specified diagnostic metric set. Then, you can call the DescribeDiagnosticReportAttributes operation based on the returned diagnostic report ID to view the details of the diagnostic report.
        
        @param request: CreateDiagnosticReportRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiagnosticReportResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.metric_set_id):
            query['MetricSetId'] = request.metric_set_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDiagnosticReport',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiagnosticReportResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_diagnostic_report(
        self,
        request: ecs_20140526_models.CreateDiagnosticReportRequest,
    ) -> ecs_20140526_models.CreateDiagnosticReportResponse:
        """
        @summary Creates a diagnostic report for a resource. When you call this operation, you can configure the MetricSetId parameter to create a diagnostic report based on the specified diagnostic metric set. Then, you can call the DescribeDiagnosticReportAttributes operation based on the returned diagnostic report ID to view the details of the diagnostic report.
        
        @param request: CreateDiagnosticReportRequest
        @return: CreateDiagnosticReportResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_diagnostic_report_with_options(request, runtime)

    async def create_diagnostic_report_async(
        self,
        request: ecs_20140526_models.CreateDiagnosticReportRequest,
    ) -> ecs_20140526_models.CreateDiagnosticReportResponse:
        """
        @summary Creates a diagnostic report for a resource. When you call this operation, you can configure the MetricSetId parameter to create a diagnostic report based on the specified diagnostic metric set. Then, you can call the DescribeDiagnosticReportAttributes operation based on the returned diagnostic report ID to view the details of the diagnostic report.
        
        @param request: CreateDiagnosticReportRequest
        @return: CreateDiagnosticReportResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_diagnostic_report_with_options_async(request, runtime)

    def create_disk_with_options(
        self,
        request: ecs_20140526_models.CreateDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiskResponse:
        """
        @summary Creates a pay-as-you-go or subscription data disk.
        
        @description    You can enable the multi-attach (`MultiAttach`) feature when you create a disk. Before you enable the multi-attach feature, we recommend that you familiarize yourself with the feature and the limits on the feature. For more information, see [NVMe protocol](https://help.aliyun.com/document_detail/256487.html) and [Use the multi-attach feature to attach a cloud disk to multiple ECS instances](https://help.aliyun.com/document_detail/262105.html).
        You can create disks of the following disk categories: basic disks, ultra disks, standard SSDs, Enterprise SSDs (ESSDs), ESSD Entry disks, Regional ESSDs, ESSD AutoPL disks, standard elastic ephemeral disks, and premium elastic ephemeral disks.
        Before you can create a disk, you must complete real-name verification. Complete real-name verification on the [Real-name Verification](https://account.console.aliyun.com/#/auth/home) page in the Alibaba Cloud Management Console.
        When you create disks, you may be charged for the resources used. We recommend that you familiarize yourself with the billing methods of Elastic Compute Service (ECS) resources before you create a disk. For more information, see [Billing overview](https://help.aliyun.com/document_detail/25398.html).
        When you call this operation to create a disk, specific parameters are automatically specified.
        `DeleteAutoSnapshot` is automatically set to `true` when a disk is created. This indicates that the automatic snapshots of the disk are deleted when the disk is released. You can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) operation to query the DeleteAutoSnapshot value for the disk and call the [ModifyDiskAttribute](https://help.aliyun.com/document_detail/25517.html) operation to change the DeleteAutoSnapshot value for the disk.
        If you do not specify a performance level when you create an ESSD, the performance level of the ESSD is automatically set to PL1. To change the performance level of the ESSD, you can call the [ModifyDiskSpec](https://help.aliyun.com/document_detail/123780.html) operation.
        `Portable` is automatically set to `true` when a disk is created, which indicates that the disk is a pay-as-you-go disk.
        
        @param request: CreateDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.advanced_features):
            query['AdvancedFeatures'] = request.advanced_features
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.bursting_enabled):
            query['BurstingEnabled'] = request.bursting_enabled
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_category):
            query['DiskCategory'] = request.disk_category
        if not UtilClient.is_unset(request.disk_name):
            query['DiskName'] = request.disk_name
        if not UtilClient.is_unset(request.encrypt_algorithm):
            query['EncryptAlgorithm'] = request.encrypt_algorithm
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.multi_attach):
            query['MultiAttach'] = request.multi_attach
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.performance_level):
            query['PerformanceLevel'] = request.performance_level
        if not UtilClient.is_unset(request.provisioned_iops):
            query['ProvisionedIops'] = request.provisioned_iops
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.size):
            query['Size'] = request.size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.storage_cluster_id):
            query['StorageClusterId'] = request.storage_cluster_id
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        if not UtilClient.is_unset(request.storage_set_partition_number):
            query['StorageSetPartitionNumber'] = request.storage_set_partition_number
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_disk_with_options_async(
        self,
        request: ecs_20140526_models.CreateDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateDiskResponse:
        """
        @summary Creates a pay-as-you-go or subscription data disk.
        
        @description    You can enable the multi-attach (`MultiAttach`) feature when you create a disk. Before you enable the multi-attach feature, we recommend that you familiarize yourself with the feature and the limits on the feature. For more information, see [NVMe protocol](https://help.aliyun.com/document_detail/256487.html) and [Use the multi-attach feature to attach a cloud disk to multiple ECS instances](https://help.aliyun.com/document_detail/262105.html).
        You can create disks of the following disk categories: basic disks, ultra disks, standard SSDs, Enterprise SSDs (ESSDs), ESSD Entry disks, Regional ESSDs, ESSD AutoPL disks, standard elastic ephemeral disks, and premium elastic ephemeral disks.
        Before you can create a disk, you must complete real-name verification. Complete real-name verification on the [Real-name Verification](https://account.console.aliyun.com/#/auth/home) page in the Alibaba Cloud Management Console.
        When you create disks, you may be charged for the resources used. We recommend that you familiarize yourself with the billing methods of Elastic Compute Service (ECS) resources before you create a disk. For more information, see [Billing overview](https://help.aliyun.com/document_detail/25398.html).
        When you call this operation to create a disk, specific parameters are automatically specified.
        `DeleteAutoSnapshot` is automatically set to `true` when a disk is created. This indicates that the automatic snapshots of the disk are deleted when the disk is released. You can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) operation to query the DeleteAutoSnapshot value for the disk and call the [ModifyDiskAttribute](https://help.aliyun.com/document_detail/25517.html) operation to change the DeleteAutoSnapshot value for the disk.
        If you do not specify a performance level when you create an ESSD, the performance level of the ESSD is automatically set to PL1. To change the performance level of the ESSD, you can call the [ModifyDiskSpec](https://help.aliyun.com/document_detail/123780.html) operation.
        `Portable` is automatically set to `true` when a disk is created, which indicates that the disk is a pay-as-you-go disk.
        
        @param request: CreateDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.advanced_features):
            query['AdvancedFeatures'] = request.advanced_features
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.bursting_enabled):
            query['BurstingEnabled'] = request.bursting_enabled
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_category):
            query['DiskCategory'] = request.disk_category
        if not UtilClient.is_unset(request.disk_name):
            query['DiskName'] = request.disk_name
        if not UtilClient.is_unset(request.encrypt_algorithm):
            query['EncryptAlgorithm'] = request.encrypt_algorithm
        if not UtilClient.is_unset(request.encrypted):
            query['Encrypted'] = request.encrypted
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.kmskey_id):
            query['KMSKeyId'] = request.kmskey_id
        if not UtilClient.is_unset(request.multi_attach):
            query['MultiAttach'] = request.multi_attach
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.performance_level):
            query['PerformanceLevel'] = request.performance_level
        if not UtilClient.is_unset(request.provisioned_iops):
            query['ProvisionedIops'] = request.provisioned_iops
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.size):
            query['Size'] = request.size
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.storage_cluster_id):
            query['StorageClusterId'] = request.storage_cluster_id
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        if not UtilClient.is_unset(request.storage_set_partition_number):
            query['StorageSetPartitionNumber'] = request.storage_set_partition_number
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateDiskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_disk(
        self,
        request: ecs_20140526_models.CreateDiskRequest,
    ) -> ecs_20140526_models.CreateDiskResponse:
        """
        @summary Creates a pay-as-you-go or subscription data disk.
        
        @description    You can enable the multi-attach (`MultiAttach`) feature when you create a disk. Before you enable the multi-attach feature, we recommend that you familiarize yourself with the feature and the limits on the feature. For more information, see [NVMe protocol](https://help.aliyun.com/document_detail/256487.html) and [Use the multi-attach feature to attach a cloud disk to multiple ECS instances](https://help.aliyun.com/document_detail/262105.html).
        You can create disks of the following disk categories: basic disks, ultra disks, standard SSDs, Enterprise SSDs (ESSDs), ESSD Entry disks, Regional ESSDs, ESSD AutoPL disks, standard elastic ephemeral disks, and premium elastic ephemeral disks.
        Before you can create a disk, you must complete real-name verification. Complete real-name verification on the [Real-name Verification](https://account.console.aliyun.com/#/auth/home) page in the Alibaba Cloud Management Console.
        When you create disks, you may be charged for the resources used. We recommend that you familiarize yourself with the billing methods of Elastic Compute Service (ECS) resources before you create a disk. For more information, see [Billing overview](https://help.aliyun.com/document_detail/25398.html).
        When you call this operation to create a disk, specific parameters are automatically specified.
        `DeleteAutoSnapshot` is automatically set to `true` when a disk is created. This indicates that the automatic snapshots of the disk are deleted when the disk is released. You can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) operation to query the DeleteAutoSnapshot value for the disk and call the [ModifyDiskAttribute](https://help.aliyun.com/document_detail/25517.html) operation to change the DeleteAutoSnapshot value for the disk.
        If you do not specify a performance level when you create an ESSD, the performance level of the ESSD is automatically set to PL1. To change the performance level of the ESSD, you can call the [ModifyDiskSpec](https://help.aliyun.com/document_detail/123780.html) operation.
        `Portable` is automatically set to `true` when a disk is created, which indicates that the disk is a pay-as-you-go disk.
        
        @param request: CreateDiskRequest
        @return: CreateDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_disk_with_options(request, runtime)

    async def create_disk_async(
        self,
        request: ecs_20140526_models.CreateDiskRequest,
    ) -> ecs_20140526_models.CreateDiskResponse:
        """
        @summary Creates a pay-as-you-go or subscription data disk.
        
        @description    You can enable the multi-attach (`MultiAttach`) feature when you create a disk. Before you enable the multi-attach feature, we recommend that you familiarize yourself with the feature and the limits on the feature. For more information, see [NVMe protocol](https://help.aliyun.com/document_detail/256487.html) and [Use the multi-attach feature to attach a cloud disk to multiple ECS instances](https://help.aliyun.com/document_detail/262105.html).
        You can create disks of the following disk categories: basic disks, ultra disks, standard SSDs, Enterprise SSDs (ESSDs), ESSD Entry disks, Regional ESSDs, ESSD AutoPL disks, standard elastic ephemeral disks, and premium elastic ephemeral disks.
        Before you can create a disk, you must complete real-name verification. Complete real-name verification on the [Real-name Verification](https://account.console.aliyun.com/#/auth/home) page in the Alibaba Cloud Management Console.
        When you create disks, you may be charged for the resources used. We recommend that you familiarize yourself with the billing methods of Elastic Compute Service (ECS) resources before you create a disk. For more information, see [Billing overview](https://help.aliyun.com/document_detail/25398.html).
        When you call this operation to create a disk, specific parameters are automatically specified.
        `DeleteAutoSnapshot` is automatically set to `true` when a disk is created. This indicates that the automatic snapshots of the disk are deleted when the disk is released. You can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) operation to query the DeleteAutoSnapshot value for the disk and call the [ModifyDiskAttribute](https://help.aliyun.com/document_detail/25517.html) operation to change the DeleteAutoSnapshot value for the disk.
        If you do not specify a performance level when you create an ESSD, the performance level of the ESSD is automatically set to PL1. To change the performance level of the ESSD, you can call the [ModifyDiskSpec](https://help.aliyun.com/document_detail/123780.html) operation.
        `Portable` is automatically set to `true` when a disk is created, which indicates that the disk is a pay-as-you-go disk.
        
        @param request: CreateDiskRequest
        @return: CreateDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_disk_with_options_async(request, runtime)

    def create_elasticity_assurance_with_options(
        self,
        request: ecs_20140526_models.CreateElasticityAssuranceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateElasticityAssuranceResponse:
        """
        @summary Creates an elasticity assurance in a region. When you call this operation, you can specify parameters, such as ZoneId, InstanceType, Period, PeriodUnit, and AutoRenew, in the request.
        
        @description Elasticity Assurance provides a new method to purchase and use guaranteed resources in a flexible manner. Elasticity Assurance is a resource reservation service that provides assured access to resources for pay-as-you-go Elastic Compute Service (ECS) instances. For more information, see [Overview of Elasticity Assurance](https://help.aliyun.com/document_detail/193630.html).
        After you purchase an elasticity assurance, you cannot request a refund for the elasticity assurance. For information about the billing of elasticity assurances, see [Resource assurance](https://help.aliyun.com/document_detail/432502.html).
        Elasticity assurances can be used to create only pay-as-you-go ECS instances.
        Elasticity assurances only support the unlimited mode. You can set `AssuranceTimes` only to `Unlimited`. Elasticity assurances in unlimited mode can be used for an unlimited number of times within their terms. Elasticity assurances in unlimited mode take effect immediately after creation.
        
        @param request: CreateElasticityAssuranceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateElasticityAssuranceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assurance_times):
            query['AssuranceTimes'] = request.assurance_times
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_amount):
            query['InstanceAmount'] = request.instance_amount
        if not UtilClient.is_unset(request.instance_cpu_core_count):
            query['InstanceCpuCoreCount'] = request.instance_cpu_core_count
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.recurrence_rules):
            query['RecurrenceRules'] = request.recurrence_rules
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateElasticityAssurance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateElasticityAssuranceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_elasticity_assurance_with_options_async(
        self,
        request: ecs_20140526_models.CreateElasticityAssuranceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateElasticityAssuranceResponse:
        """
        @summary Creates an elasticity assurance in a region. When you call this operation, you can specify parameters, such as ZoneId, InstanceType, Period, PeriodUnit, and AutoRenew, in the request.
        
        @description Elasticity Assurance provides a new method to purchase and use guaranteed resources in a flexible manner. Elasticity Assurance is a resource reservation service that provides assured access to resources for pay-as-you-go Elastic Compute Service (ECS) instances. For more information, see [Overview of Elasticity Assurance](https://help.aliyun.com/document_detail/193630.html).
        After you purchase an elasticity assurance, you cannot request a refund for the elasticity assurance. For information about the billing of elasticity assurances, see [Resource assurance](https://help.aliyun.com/document_detail/432502.html).
        Elasticity assurances can be used to create only pay-as-you-go ECS instances.
        Elasticity assurances only support the unlimited mode. You can set `AssuranceTimes` only to `Unlimited`. Elasticity assurances in unlimited mode can be used for an unlimited number of times within their terms. Elasticity assurances in unlimited mode take effect immediately after creation.
        
        @param request: CreateElasticityAssuranceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateElasticityAssuranceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assurance_times):
            query['AssuranceTimes'] = request.assurance_times
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_amount):
            query['InstanceAmount'] = request.instance_amount
        if not UtilClient.is_unset(request.instance_cpu_core_count):
            query['InstanceCpuCoreCount'] = request.instance_cpu_core_count
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.recurrence_rules):
            query['RecurrenceRules'] = request.recurrence_rules
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateElasticityAssurance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateElasticityAssuranceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_elasticity_assurance(
        self,
        request: ecs_20140526_models.CreateElasticityAssuranceRequest,
    ) -> ecs_20140526_models.CreateElasticityAssuranceResponse:
        """
        @summary Creates an elasticity assurance in a region. When you call this operation, you can specify parameters, such as ZoneId, InstanceType, Period, PeriodUnit, and AutoRenew, in the request.
        
        @description Elasticity Assurance provides a new method to purchase and use guaranteed resources in a flexible manner. Elasticity Assurance is a resource reservation service that provides assured access to resources for pay-as-you-go Elastic Compute Service (ECS) instances. For more information, see [Overview of Elasticity Assurance](https://help.aliyun.com/document_detail/193630.html).
        After you purchase an elasticity assurance, you cannot request a refund for the elasticity assurance. For information about the billing of elasticity assurances, see [Resource assurance](https://help.aliyun.com/document_detail/432502.html).
        Elasticity assurances can be used to create only pay-as-you-go ECS instances.
        Elasticity assurances only support the unlimited mode. You can set `AssuranceTimes` only to `Unlimited`. Elasticity assurances in unlimited mode can be used for an unlimited number of times within their terms. Elasticity assurances in unlimited mode take effect immediately after creation.
        
        @param request: CreateElasticityAssuranceRequest
        @return: CreateElasticityAssuranceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_elasticity_assurance_with_options(request, runtime)

    async def create_elasticity_assurance_async(
        self,
        request: ecs_20140526_models.CreateElasticityAssuranceRequest,
    ) -> ecs_20140526_models.CreateElasticityAssuranceResponse:
        """
        @summary Creates an elasticity assurance in a region. When you call this operation, you can specify parameters, such as ZoneId, InstanceType, Period, PeriodUnit, and AutoRenew, in the request.
        
        @description Elasticity Assurance provides a new method to purchase and use guaranteed resources in a flexible manner. Elasticity Assurance is a resource reservation service that provides assured access to resources for pay-as-you-go Elastic Compute Service (ECS) instances. For more information, see [Overview of Elasticity Assurance](https://help.aliyun.com/document_detail/193630.html).
        After you purchase an elasticity assurance, you cannot request a refund for the elasticity assurance. For information about the billing of elasticity assurances, see [Resource assurance](https://help.aliyun.com/document_detail/432502.html).
        Elasticity assurances can be used to create only pay-as-you-go ECS instances.
        Elasticity assurances only support the unlimited mode. You can set `AssuranceTimes` only to `Unlimited`. Elasticity assurances in unlimited mode can be used for an unlimited number of times within their terms. Elasticity assurances in unlimited mode take effect immediately after creation.
        
        @param request: CreateElasticityAssuranceRequest
        @return: CreateElasticityAssuranceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_elasticity_assurance_with_options_async(request, runtime)

    def create_forward_entry_with_options(
        self,
        request: ecs_20140526_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateForwardEntryResponse:
        """
        @deprecated OpenAPI CreateForwardEntry is deprecated, please use Vpc::2016-04-28::CreateForwardEntry instead.
        
        @summary CreateForwardEntry
        
        @param request: CreateForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateForwardEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_forward_entry_with_options_async(
        self,
        request: ecs_20140526_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateForwardEntryResponse:
        """
        @deprecated OpenAPI CreateForwardEntry is deprecated, please use Vpc::2016-04-28::CreateForwardEntry instead.
        
        @summary CreateForwardEntry
        
        @param request: CreateForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateForwardEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_forward_entry(
        self,
        request: ecs_20140526_models.CreateForwardEntryRequest,
    ) -> ecs_20140526_models.CreateForwardEntryResponse:
        """
        @deprecated OpenAPI CreateForwardEntry is deprecated, please use Vpc::2016-04-28::CreateForwardEntry instead.
        
        @summary CreateForwardEntry
        
        @param request: CreateForwardEntryRequest
        @return: CreateForwardEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_forward_entry_with_options(request, runtime)

    async def create_forward_entry_async(
        self,
        request: ecs_20140526_models.CreateForwardEntryRequest,
    ) -> ecs_20140526_models.CreateForwardEntryResponse:
        """
        @deprecated OpenAPI CreateForwardEntry is deprecated, please use Vpc::2016-04-28::CreateForwardEntry instead.
        
        @summary CreateForwardEntry
        
        @param request: CreateForwardEntryRequest
        @return: CreateForwardEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_forward_entry_with_options_async(request, runtime)

    def create_ha_vip_with_options(
        self,
        request: ecs_20140526_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateHaVipResponse:
        """
        @deprecated OpenAPI CreateHaVip is deprecated, please use Vpc::2016-04-28::CreateHaVip instead.
        
        @summary CreateHaVip
        
        @param request: CreateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ha_vip_with_options_async(
        self,
        request: ecs_20140526_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateHaVipResponse:
        """
        @deprecated OpenAPI CreateHaVip is deprecated, please use Vpc::2016-04-28::CreateHaVip instead.
        
        @summary CreateHaVip
        
        @param request: CreateHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ha_vip(
        self,
        request: ecs_20140526_models.CreateHaVipRequest,
    ) -> ecs_20140526_models.CreateHaVipResponse:
        """
        @deprecated OpenAPI CreateHaVip is deprecated, please use Vpc::2016-04-28::CreateHaVip instead.
        
        @summary CreateHaVip
        
        @param request: CreateHaVipRequest
        @return: CreateHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ha_vip_with_options(request, runtime)

    async def create_ha_vip_async(
        self,
        request: ecs_20140526_models.CreateHaVipRequest,
    ) -> ecs_20140526_models.CreateHaVipResponse:
        """
        @deprecated OpenAPI CreateHaVip is deprecated, please use Vpc::2016-04-28::CreateHaVip instead.
        
        @summary CreateHaVip
        
        @param request: CreateHaVipRequest
        @return: CreateHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ha_vip_with_options_async(request, runtime)

    def create_hpc_cluster_with_options(
        self,
        request: ecs_20140526_models.CreateHpcClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateHpcClusterResponse:
        """
        @summary Creates a high performance computing (HPC) cluster.
        
        @param request: CreateHpcClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHpcClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHpcCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateHpcClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_hpc_cluster_with_options_async(
        self,
        request: ecs_20140526_models.CreateHpcClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateHpcClusterResponse:
        """
        @summary Creates a high performance computing (HPC) cluster.
        
        @param request: CreateHpcClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateHpcClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHpcCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateHpcClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_hpc_cluster(
        self,
        request: ecs_20140526_models.CreateHpcClusterRequest,
    ) -> ecs_20140526_models.CreateHpcClusterResponse:
        """
        @summary Creates a high performance computing (HPC) cluster.
        
        @param request: CreateHpcClusterRequest
        @return: CreateHpcClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_hpc_cluster_with_options(request, runtime)

    async def create_hpc_cluster_async(
        self,
        request: ecs_20140526_models.CreateHpcClusterRequest,
    ) -> ecs_20140526_models.CreateHpcClusterResponse:
        """
        @summary Creates a high performance computing (HPC) cluster.
        
        @param request: CreateHpcClusterRequest
        @return: CreateHpcClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_hpc_cluster_with_options_async(request, runtime)

    def create_image_with_options(
        self,
        request: ecs_20140526_models.CreateImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImageResponse:
        """
        @summary Creates a custom image. After you call this operation to create a custom image, you can call the RunInstances operation to create Elastic Compute Service (ECS) instances from the custom image or call the ReplaceSystemDisk operation to replace system disks by using the custom image.
        
        @description ### [](#)Considerations
        This operation is an asynchronous operation. After a request to create a custom image is sent, an image ID is returned but the creation of the custom image is in progress. You can call the [DescribeImage](https://help.aliyun.com/document_detail/2679797.html) operation to query the status of the custom image. When the status of the custom image is `Available` in the response, the image is created and available. For more information, see [Overview of custom images](https://help.aliyun.com/document_detail/172789.html).
        If the response contains {"OperationLocks": {"LockReason" : "security"}} when you query information about an ECS instance, the instance is locked for security reasons, and you cannot create a custom image from the instance.
        To optimize the image, we recommend that you specify `DetectionStrategy` when you create a custom image. For information about the image check feature, see [Overview](https://help.aliyun.com/document_detail/439819.html).
        You can call the CreateImage operation to create a custom image by using one of the following methods. The following request parameters are prioritized in descending order: InstanceId, DiskDeviceMapping, and SnapshotId. If your request contains two or more of these parameters, the custom image is created based on the parameter that has a higher priority.
        **Create a custom image from an instance**. Specify an instance ID (`InstanceId`).
        The ECS instance must be in the Running (`Running`) or Stopped (`Stopped`) state.
        After the CreateImage operation is called, a snapshot is created for each cloud disk of the instance.
        *\
        *Note** When you create a custom image from a running ECS instance, cache data may not be written to disks. In this case, the data of the custom image may be slightly different from the data of the instance. Before you create a custom image from the instance, we recommend that you stop the instance by calling the StopInstancesoperation.
        **Create a custom image from a snapshot. The specified snapshot must be created after July 15, 2013.**\
        **Create a custom image from a system disk snapshot of an ECS instance**. You need to only specify the ID of the system disk snapshot by using `SnapshotId`.
        **Create a custom image from a system disk snapshot and data disk snapshots of an ECS instance**. You need to establish data association between the disks by specifying `DiskDeviceMapping`.
        You can specify only one snapshot to create the system disk in the custom image.
        You can specify up to 16 snapshots to use to create data disks in the custom image. If you do not specify `DiskDeviceMapping.N.SnapshotId`, an empty data disk with the default capacity is created.
        >  When an ECS instance is released, the system disk of the instance is converted to a pay-as-you-go data disk. You cannot create a custom image from the snapshot of this disk. You must create a custom image from the snapshot of this disk before the instance is released.
        
        @param request: CreateImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.boot_mode):
            query['BootMode'] = request.boot_mode
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.detection_strategy):
            query['DetectionStrategy'] = request.detection_strategy
        if not UtilClient.is_unset(request.disk_device_mapping):
            query['DiskDeviceMapping'] = request.disk_device_mapping
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.features):
            query['Features'] = request.features
        if not UtilClient.is_unset(request.image_family):
            query['ImageFamily'] = request.image_family
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.image_version):
            query['ImageVersion'] = request.image_version
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_image_with_options_async(
        self,
        request: ecs_20140526_models.CreateImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImageResponse:
        """
        @summary Creates a custom image. After you call this operation to create a custom image, you can call the RunInstances operation to create Elastic Compute Service (ECS) instances from the custom image or call the ReplaceSystemDisk operation to replace system disks by using the custom image.
        
        @description ### [](#)Considerations
        This operation is an asynchronous operation. After a request to create a custom image is sent, an image ID is returned but the creation of the custom image is in progress. You can call the [DescribeImage](https://help.aliyun.com/document_detail/2679797.html) operation to query the status of the custom image. When the status of the custom image is `Available` in the response, the image is created and available. For more information, see [Overview of custom images](https://help.aliyun.com/document_detail/172789.html).
        If the response contains {"OperationLocks": {"LockReason" : "security"}} when you query information about an ECS instance, the instance is locked for security reasons, and you cannot create a custom image from the instance.
        To optimize the image, we recommend that you specify `DetectionStrategy` when you create a custom image. For information about the image check feature, see [Overview](https://help.aliyun.com/document_detail/439819.html).
        You can call the CreateImage operation to create a custom image by using one of the following methods. The following request parameters are prioritized in descending order: InstanceId, DiskDeviceMapping, and SnapshotId. If your request contains two or more of these parameters, the custom image is created based on the parameter that has a higher priority.
        **Create a custom image from an instance**. Specify an instance ID (`InstanceId`).
        The ECS instance must be in the Running (`Running`) or Stopped (`Stopped`) state.
        After the CreateImage operation is called, a snapshot is created for each cloud disk of the instance.
        *\
        *Note** When you create a custom image from a running ECS instance, cache data may not be written to disks. In this case, the data of the custom image may be slightly different from the data of the instance. Before you create a custom image from the instance, we recommend that you stop the instance by calling the StopInstancesoperation.
        **Create a custom image from a snapshot. The specified snapshot must be created after July 15, 2013.**\
        **Create a custom image from a system disk snapshot of an ECS instance**. You need to only specify the ID of the system disk snapshot by using `SnapshotId`.
        **Create a custom image from a system disk snapshot and data disk snapshots of an ECS instance**. You need to establish data association between the disks by specifying `DiskDeviceMapping`.
        You can specify only one snapshot to create the system disk in the custom image.
        You can specify up to 16 snapshots to use to create data disks in the custom image. If you do not specify `DiskDeviceMapping.N.SnapshotId`, an empty data disk with the default capacity is created.
        >  When an ECS instance is released, the system disk of the instance is converted to a pay-as-you-go data disk. You cannot create a custom image from the snapshot of this disk. You must create a custom image from the snapshot of this disk before the instance is released.
        
        @param request: CreateImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.architecture):
            query['Architecture'] = request.architecture
        if not UtilClient.is_unset(request.boot_mode):
            query['BootMode'] = request.boot_mode
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.detection_strategy):
            query['DetectionStrategy'] = request.detection_strategy
        if not UtilClient.is_unset(request.disk_device_mapping):
            query['DiskDeviceMapping'] = request.disk_device_mapping
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.features):
            query['Features'] = request.features
        if not UtilClient.is_unset(request.image_family):
            query['ImageFamily'] = request.image_family
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.image_version):
            query['ImageVersion'] = request.image_version
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_image(
        self,
        request: ecs_20140526_models.CreateImageRequest,
    ) -> ecs_20140526_models.CreateImageResponse:
        """
        @summary Creates a custom image. After you call this operation to create a custom image, you can call the RunInstances operation to create Elastic Compute Service (ECS) instances from the custom image or call the ReplaceSystemDisk operation to replace system disks by using the custom image.
        
        @description ### [](#)Considerations
        This operation is an asynchronous operation. After a request to create a custom image is sent, an image ID is returned but the creation of the custom image is in progress. You can call the [DescribeImage](https://help.aliyun.com/document_detail/2679797.html) operation to query the status of the custom image. When the status of the custom image is `Available` in the response, the image is created and available. For more information, see [Overview of custom images](https://help.aliyun.com/document_detail/172789.html).
        If the response contains {"OperationLocks": {"LockReason" : "security"}} when you query information about an ECS instance, the instance is locked for security reasons, and you cannot create a custom image from the instance.
        To optimize the image, we recommend that you specify `DetectionStrategy` when you create a custom image. For information about the image check feature, see [Overview](https://help.aliyun.com/document_detail/439819.html).
        You can call the CreateImage operation to create a custom image by using one of the following methods. The following request parameters are prioritized in descending order: InstanceId, DiskDeviceMapping, and SnapshotId. If your request contains two or more of these parameters, the custom image is created based on the parameter that has a higher priority.
        **Create a custom image from an instance**. Specify an instance ID (`InstanceId`).
        The ECS instance must be in the Running (`Running`) or Stopped (`Stopped`) state.
        After the CreateImage operation is called, a snapshot is created for each cloud disk of the instance.
        *\
        *Note** When you create a custom image from a running ECS instance, cache data may not be written to disks. In this case, the data of the custom image may be slightly different from the data of the instance. Before you create a custom image from the instance, we recommend that you stop the instance by calling the StopInstancesoperation.
        **Create a custom image from a snapshot. The specified snapshot must be created after July 15, 2013.**\
        **Create a custom image from a system disk snapshot of an ECS instance**. You need to only specify the ID of the system disk snapshot by using `SnapshotId`.
        **Create a custom image from a system disk snapshot and data disk snapshots of an ECS instance**. You need to establish data association between the disks by specifying `DiskDeviceMapping`.
        You can specify only one snapshot to create the system disk in the custom image.
        You can specify up to 16 snapshots to use to create data disks in the custom image. If you do not specify `DiskDeviceMapping.N.SnapshotId`, an empty data disk with the default capacity is created.
        >  When an ECS instance is released, the system disk of the instance is converted to a pay-as-you-go data disk. You cannot create a custom image from the snapshot of this disk. You must create a custom image from the snapshot of this disk before the instance is released.
        
        @param request: CreateImageRequest
        @return: CreateImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_image_with_options(request, runtime)

    async def create_image_async(
        self,
        request: ecs_20140526_models.CreateImageRequest,
    ) -> ecs_20140526_models.CreateImageResponse:
        """
        @summary Creates a custom image. After you call this operation to create a custom image, you can call the RunInstances operation to create Elastic Compute Service (ECS) instances from the custom image or call the ReplaceSystemDisk operation to replace system disks by using the custom image.
        
        @description ### [](#)Considerations
        This operation is an asynchronous operation. After a request to create a custom image is sent, an image ID is returned but the creation of the custom image is in progress. You can call the [DescribeImage](https://help.aliyun.com/document_detail/2679797.html) operation to query the status of the custom image. When the status of the custom image is `Available` in the response, the image is created and available. For more information, see [Overview of custom images](https://help.aliyun.com/document_detail/172789.html).
        If the response contains {"OperationLocks": {"LockReason" : "security"}} when you query information about an ECS instance, the instance is locked for security reasons, and you cannot create a custom image from the instance.
        To optimize the image, we recommend that you specify `DetectionStrategy` when you create a custom image. For information about the image check feature, see [Overview](https://help.aliyun.com/document_detail/439819.html).
        You can call the CreateImage operation to create a custom image by using one of the following methods. The following request parameters are prioritized in descending order: InstanceId, DiskDeviceMapping, and SnapshotId. If your request contains two or more of these parameters, the custom image is created based on the parameter that has a higher priority.
        **Create a custom image from an instance**. Specify an instance ID (`InstanceId`).
        The ECS instance must be in the Running (`Running`) or Stopped (`Stopped`) state.
        After the CreateImage operation is called, a snapshot is created for each cloud disk of the instance.
        *\
        *Note** When you create a custom image from a running ECS instance, cache data may not be written to disks. In this case, the data of the custom image may be slightly different from the data of the instance. Before you create a custom image from the instance, we recommend that you stop the instance by calling the StopInstancesoperation.
        **Create a custom image from a snapshot. The specified snapshot must be created after July 15, 2013.**\
        **Create a custom image from a system disk snapshot of an ECS instance**. You need to only specify the ID of the system disk snapshot by using `SnapshotId`.
        **Create a custom image from a system disk snapshot and data disk snapshots of an ECS instance**. You need to establish data association between the disks by specifying `DiskDeviceMapping`.
        You can specify only one snapshot to create the system disk in the custom image.
        You can specify up to 16 snapshots to use to create data disks in the custom image. If you do not specify `DiskDeviceMapping.N.SnapshotId`, an empty data disk with the default capacity is created.
        >  When an ECS instance is released, the system disk of the instance is converted to a pay-as-you-go data disk. You cannot create a custom image from the snapshot of this disk. You must create a custom image from the snapshot of this disk before the instance is released.
        
        @param request: CreateImageRequest
        @return: CreateImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_image_with_options_async(request, runtime)

    def create_image_component_with_options(
        self,
        request: ecs_20140526_models.CreateImageComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImageComponentResponse:
        """
        @summary Creates an image component. Image components are used to store the builder template commands that are commonly used when you create images.
        
        @description ## [](#)Usage notes
        Take note of the following items:
        You can create only custom image components.
        Each version number of an image component must be unique. When you add a version of an image component to an image template, you can specify the component by its name and version number.
        The content size of an image component cannot exceed 16 KB. For information about the commands supported by Image Builder, see [Commands supported by Image Builder](https://help.aliyun.com/document_detail/200206.html).
        For more information, see [Image Builder](https://help.aliyun.com/document_detail/197410.html).
        
        @param request: CreateImageComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.component_type):
            query['ComponentType'] = request.component_type
        if not UtilClient.is_unset(request.component_version):
            query['ComponentVersion'] = request.component_version
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_type):
            query['SystemType'] = request.system_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImageComponent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImageComponentResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_image_component_with_options_async(
        self,
        request: ecs_20140526_models.CreateImageComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImageComponentResponse:
        """
        @summary Creates an image component. Image components are used to store the builder template commands that are commonly used when you create images.
        
        @description ## [](#)Usage notes
        Take note of the following items:
        You can create only custom image components.
        Each version number of an image component must be unique. When you add a version of an image component to an image template, you can specify the component by its name and version number.
        The content size of an image component cannot exceed 16 KB. For information about the commands supported by Image Builder, see [Commands supported by Image Builder](https://help.aliyun.com/document_detail/200206.html).
        For more information, see [Image Builder](https://help.aliyun.com/document_detail/197410.html).
        
        @param request: CreateImageComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImageComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.component_type):
            query['ComponentType'] = request.component_type
        if not UtilClient.is_unset(request.component_version):
            query['ComponentVersion'] = request.component_version
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_type):
            query['SystemType'] = request.system_type
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImageComponent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImageComponentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_image_component(
        self,
        request: ecs_20140526_models.CreateImageComponentRequest,
    ) -> ecs_20140526_models.CreateImageComponentResponse:
        """
        @summary Creates an image component. Image components are used to store the builder template commands that are commonly used when you create images.
        
        @description ## [](#)Usage notes
        Take note of the following items:
        You can create only custom image components.
        Each version number of an image component must be unique. When you add a version of an image component to an image template, you can specify the component by its name and version number.
        The content size of an image component cannot exceed 16 KB. For information about the commands supported by Image Builder, see [Commands supported by Image Builder](https://help.aliyun.com/document_detail/200206.html).
        For more information, see [Image Builder](https://help.aliyun.com/document_detail/197410.html).
        
        @param request: CreateImageComponentRequest
        @return: CreateImageComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_image_component_with_options(request, runtime)

    async def create_image_component_async(
        self,
        request: ecs_20140526_models.CreateImageComponentRequest,
    ) -> ecs_20140526_models.CreateImageComponentResponse:
        """
        @summary Creates an image component. Image components are used to store the builder template commands that are commonly used when you create images.
        
        @description ## [](#)Usage notes
        Take note of the following items:
        You can create only custom image components.
        Each version number of an image component must be unique. When you add a version of an image component to an image template, you can specify the component by its name and version number.
        The content size of an image component cannot exceed 16 KB. For information about the commands supported by Image Builder, see [Commands supported by Image Builder](https://help.aliyun.com/document_detail/200206.html).
        For more information, see [Image Builder](https://help.aliyun.com/document_detail/197410.html).
        
        @param request: CreateImageComponentRequest
        @return: CreateImageComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_image_component_with_options_async(request, runtime)

    def create_image_pipeline_with_options(
        self,
        request: ecs_20140526_models.CreateImagePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImagePipelineResponse:
        """
        @summary Creates an image template. Image templates can be used to create images.
        
        @description ## [](#)Usage notes
        You can use image templates to customize image content and create images across regions and accounts. Take note of the following items:
        You can create only custom image templates.
        You can specify only a public image, a custom image, a shared image, or an image family as the source image when you create an image template.
        When you use an image template to create an image, multiple intermediate instances are created. You are charged for the intermediate instances on a pay-as-you-go basis. For more information, see [Pay-as-you-go](https://help.aliyun.com/document_detail/40653.html).
        When you use `BuildContent` to specify the build content in an image template, take note of the following items:
        The `FROM` command is deprecated. Regardless of whether you specify the `FROM` command in `BuildContent`, the system uses the source image specified by `BaseImageType` and `BaseImage`. BaseImageType specifies the type of the source image and BaseImage specifies the source image.
        The size of BuildContent cannot exceed 16 KB. For information about the commands supported by Image Builder, see [Commands supported by Image Builder](https://help.aliyun.com/document_detail/200206.html).
        For more information, see [Image Builder](https://help.aliyun.com/document_detail/197410.html).
        
        @param request: CreateImagePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImagePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.add_account):
            query['AddAccount'] = request.add_account
        if not UtilClient.is_unset(request.advanced_options):
            query['AdvancedOptions'] = request.advanced_options
        if not UtilClient.is_unset(request.base_image):
            query['BaseImage'] = request.base_image
        if not UtilClient.is_unset(request.base_image_type):
            query['BaseImageType'] = request.base_image_type
        if not UtilClient.is_unset(request.build_content):
            query['BuildContent'] = request.build_content
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.delete_instance_on_failure):
            query['DeleteInstanceOnFailure'] = request.delete_instance_on_failure
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.image_family):
            query['ImageFamily'] = request.image_family
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.image_options):
            query['ImageOptions'] = request.image_options
        if not UtilClient.is_unset(request.import_image_options):
            query['ImportImageOptions'] = request.import_image_options
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.nvme_support):
            query['NvmeSupport'] = request.nvme_support
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repair_mode):
            query['RepairMode'] = request.repair_mode
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.test_content):
            query['TestContent'] = request.test_content
        if not UtilClient.is_unset(request.to_region_id):
            query['ToRegionId'] = request.to_region_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImagePipeline',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImagePipelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_image_pipeline_with_options_async(
        self,
        request: ecs_20140526_models.CreateImagePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateImagePipelineResponse:
        """
        @summary Creates an image template. Image templates can be used to create images.
        
        @description ## [](#)Usage notes
        You can use image templates to customize image content and create images across regions and accounts. Take note of the following items:
        You can create only custom image templates.
        You can specify only a public image, a custom image, a shared image, or an image family as the source image when you create an image template.
        When you use an image template to create an image, multiple intermediate instances are created. You are charged for the intermediate instances on a pay-as-you-go basis. For more information, see [Pay-as-you-go](https://help.aliyun.com/document_detail/40653.html).
        When you use `BuildContent` to specify the build content in an image template, take note of the following items:
        The `FROM` command is deprecated. Regardless of whether you specify the `FROM` command in `BuildContent`, the system uses the source image specified by `BaseImageType` and `BaseImage`. BaseImageType specifies the type of the source image and BaseImage specifies the source image.
        The size of BuildContent cannot exceed 16 KB. For information about the commands supported by Image Builder, see [Commands supported by Image Builder](https://help.aliyun.com/document_detail/200206.html).
        For more information, see [Image Builder](https://help.aliyun.com/document_detail/197410.html).
        
        @param request: CreateImagePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateImagePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.add_account):
            query['AddAccount'] = request.add_account
        if not UtilClient.is_unset(request.advanced_options):
            query['AdvancedOptions'] = request.advanced_options
        if not UtilClient.is_unset(request.base_image):
            query['BaseImage'] = request.base_image
        if not UtilClient.is_unset(request.base_image_type):
            query['BaseImageType'] = request.base_image_type
        if not UtilClient.is_unset(request.build_content):
            query['BuildContent'] = request.build_content
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.delete_instance_on_failure):
            query['DeleteInstanceOnFailure'] = request.delete_instance_on_failure
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.image_family):
            query['ImageFamily'] = request.image_family
        if not UtilClient.is_unset(request.image_name):
            query['ImageName'] = request.image_name
        if not UtilClient.is_unset(request.image_options):
            query['ImageOptions'] = request.image_options
        if not UtilClient.is_unset(request.import_image_options):
            query['ImportImageOptions'] = request.import_image_options
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.nvme_support):
            query['NvmeSupport'] = request.nvme_support
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repair_mode):
            query['RepairMode'] = request.repair_mode
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.system_disk_size):
            query['SystemDiskSize'] = request.system_disk_size
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.test_content):
            query['TestContent'] = request.test_content
        if not UtilClient.is_unset(request.to_region_id):
            query['ToRegionId'] = request.to_region_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateImagePipeline',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateImagePipelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_image_pipeline(
        self,
        request: ecs_20140526_models.CreateImagePipelineRequest,
    ) -> ecs_20140526_models.CreateImagePipelineResponse:
        """
        @summary Creates an image template. Image templates can be used to create images.
        
        @description ## [](#)Usage notes
        You can use image templates to customize image content and create images across regions and accounts. Take note of the following items:
        You can create only custom image templates.
        You can specify only a public image, a custom image, a shared image, or an image family as the source image when you create an image template.
        When you use an image template to create an image, multiple intermediate instances are created. You are charged for the intermediate instances on a pay-as-you-go basis. For more information, see [Pay-as-you-go](https://help.aliyun.com/document_detail/40653.html).
        When you use `BuildContent` to specify the build content in an image template, take note of the following items:
        The `FROM` command is deprecated. Regardless of whether you specify the `FROM` command in `BuildContent`, the system uses the source image specified by `BaseImageType` and `BaseImage`. BaseImageType specifies the type of the source image and BaseImage specifies the source image.
        The size of BuildContent cannot exceed 16 KB. For information about the commands supported by Image Builder, see [Commands supported by Image Builder](https://help.aliyun.com/document_detail/200206.html).
        For more information, see [Image Builder](https://help.aliyun.com/document_detail/197410.html).
        
        @param request: CreateImagePipelineRequest
        @return: CreateImagePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_image_pipeline_with_options(request, runtime)

    async def create_image_pipeline_async(
        self,
        request: ecs_20140526_models.CreateImagePipelineRequest,
    ) -> ecs_20140526_models.CreateImagePipelineResponse:
        """
        @summary Creates an image template. Image templates can be used to create images.
        
        @description ## [](#)Usage notes
        You can use image templates to customize image content and create images across regions and accounts. Take note of the following items:
        You can create only custom image templates.
        You can specify only a public image, a custom image, a shared image, or an image family as the source image when you create an image template.
        When you use an image template to create an image, multiple intermediate instances are created. You are charged for the intermediate instances on a pay-as-you-go basis. For more information, see [Pay-as-you-go](https://help.aliyun.com/document_detail/40653.html).
        When you use `BuildContent` to specify the build content in an image template, take note of the following items:
        The `FROM` command is deprecated. Regardless of whether you specify the `FROM` command in `BuildContent`, the system uses the source image specified by `BaseImageType` and `BaseImage`. BaseImageType specifies the type of the source image and BaseImage specifies the source image.
        The size of BuildContent cannot exceed 16 KB. For information about the commands supported by Image Builder, see [Commands supported by Image Builder](https://help.aliyun.com/document_detail/200206.html).
        For more information, see [Image Builder](https://help.aliyun.com/document_detail/197410.html).
        
        @param request: CreateImagePipelineRequest
        @return: CreateImagePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_image_pipeline_with_options_async(request, runtime)

    def create_instance_with_options(
        self,
        request: ecs_20140526_models.CreateInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateInstanceResponse:
        """
        @summary Creates a subscription or pay-as-you-go Elastic Compute Service (ECS) instance. When you call this operation, you can specify different parameters to create instances based on your business requirements.
        
        @description >  This operation is no longer iterated or updated. We recommend that you call the [RunInstances](https://help.aliyun.com/document_detail/2679677.html) operation instead.
        *Before you call this operation, familiarize yourself with the billing rules and [pricing](https://www.alibabacloud.com/zh/pricing-calculator#/commodity/vm_intl) of ECS resources.**\
        This operation is an asynchronous operation. After a request to create an ECS instance is sent, an ECS instance ID is immediately returned but the instance may be still being created. You can call the [DescribeInstanceStatus](https://help.aliyun.com/document_detail/2679688.html) operation to query the status of the instance. If the status of the instance is `Stopped` in the DescribeInstanceStatus response, the instance is created. In this case, you can call the [StartInstance](https://help.aliyun.com/document_detail/2679679.html) operation to start the instance.
        ### [](#)Prerequisites
        Make sure that you are familiar with the ECS billing methods because you may be charged for the resources that are used by the instance. For more information, see [Billing overview](https://help.aliyun.com/document_detail/25398.html).
        Make sure that the number of ECS instances you create or the number of vCPUs on ECS instances of all instance types you create does not exceed the corresponding quota. Go to the [Quota Center](https://quotas.console.aliyun.com/products/ecs/quotas) to view the quotas.
        Before you create ECS instances of the Virtual Private Cloud (VPC) type in a region, create a VPC in the region. For more information, see [Create a VPC](https://help.aliyun.com/document_detail/65430.html).
        ### [](#)Considerations
        If you create a subscription instance (`PrePaid`), available coupons in your account are automatically used.
        If you want to create instances with 512 MiB of memory, you cannot use Windows Server images except for Windows Server Semi-Annual Channel images. If you want to create instances with 4 GiB or more of memory, you cannot use 32-bit OS image.
        If you call the CreateInstance operation to create an instance, no public IP address is automatically assigned to the instance. If the InternetMaxBandwidthOut value of the instance is greater than 0 Mbit/s, call the [AllocatePublicIpAddress](https://help.aliyun.com/document_detail/25544.html) operation to assign a public IP address to the instance. If the InternetMaxBandwidthOut value of the instance is 0 Mbit/s, call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to set InternetMaxBandwidthOut to a value greater than 0 Mbit/s and then call the [AllocatePublicIpAddress](https://help.aliyun.com/document_detail/25544.html) operation to assign a public IP address to the instance.
        >  For the limits on the sum of maximum public bandwidths of ECS instances that use the pay-by-bandwidth billing method for network usage per region per Alibaba Cloud account, see the [Public bandwidth limits](~~25412#BandwidthQuota~~) section of the "Limits" topic.
        ### [](#)Suggestions
        **Instance type selection**: See [Overview of instance families](https://help.aliyun.com/document_detail/25378.html) or call the [DescribeInstanceTypes](https://help.aliyun.com/document_detail/25620.html) operation to query the performance data of instance types, or see [Instance type selection](https://help.aliyun.com/document_detail/58291.html) to learn about how to select instance types.
        **Query of available resources**: Call the [DescribeAvailableResource](https://help.aliyun.com/document_detail/66186.html) operation to query resources available in a specific region or zone.
        **User data**: If the instance type supports [user data](https://help.aliyun.com/document_detail/49121.html), you can use UserData to pass in user data. We recommend that you do not pass in confidential information, such as passwords or private keys, in plaintext as user data. This is because the system does not encrypt `UserData` values when API requests are sent. If you must pass in confidential information as user data, we recommend that you encrypt and encode the information in Base64 before you pass in the information. Then, decode and decrypt the information within the instance for subsequent use.
        
        @param request: CreateInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.affinity):
            query['Affinity'] = request.affinity
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.credit_specification):
            query['CreditSpecification'] = request.credit_specification
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.dedicated_host_id):
            query['DedicatedHostId'] = request.dedicated_host_id
        if not UtilClient.is_unset(request.deletion_protection):
            query['DeletionProtection'] = request.deletion_protection
        if not UtilClient.is_unset(request.deployment_set_group_no):
            query['DeploymentSetGroupNo'] = request.deployment_set_group_no
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.hpc_cluster_id):
            query['HpcClusterId'] = request.hpc_cluster_id
        if not UtilClient.is_unset(request.http_endpoint):
            query['HttpEndpoint'] = request.http_endpoint
        if not UtilClient.is_unset(request.http_put_response_hop_limit):
            query['HttpPutResponseHopLimit'] = request.http_put_response_hop_limit
        if not UtilClient.is_unset(request.http_tokens):
            query['HttpTokens'] = request.http_tokens
        if not UtilClient.is_unset(request.image_family):
            query['ImageFamily'] = request.image_family
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.inner_ip_address):
            query['InnerIpAddress'] = request.inner_ip_address
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.node_controller_id):
            query['NodeControllerId'] = request.node_controller_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_interruption_behavior):
            query['SpotInterruptionBehavior'] = request.spot_interruption_behavior
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        if not UtilClient.is_unset(request.storage_set_partition_number):
            query['StorageSetPartitionNumber'] = request.storage_set_partition_number
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.tenancy):
            query['Tenancy'] = request.tenancy
        if not UtilClient.is_unset(request.use_additional_service):
            query['UseAdditionalService'] = request.use_additional_service
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.hibernation_options):
            query['HibernationOptions'] = request.hibernation_options
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_instance_with_options_async(
        self,
        request: ecs_20140526_models.CreateInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateInstanceResponse:
        """
        @summary Creates a subscription or pay-as-you-go Elastic Compute Service (ECS) instance. When you call this operation, you can specify different parameters to create instances based on your business requirements.
        
        @description >  This operation is no longer iterated or updated. We recommend that you call the [RunInstances](https://help.aliyun.com/document_detail/2679677.html) operation instead.
        *Before you call this operation, familiarize yourself with the billing rules and [pricing](https://www.alibabacloud.com/zh/pricing-calculator#/commodity/vm_intl) of ECS resources.**\
        This operation is an asynchronous operation. After a request to create an ECS instance is sent, an ECS instance ID is immediately returned but the instance may be still being created. You can call the [DescribeInstanceStatus](https://help.aliyun.com/document_detail/2679688.html) operation to query the status of the instance. If the status of the instance is `Stopped` in the DescribeInstanceStatus response, the instance is created. In this case, you can call the [StartInstance](https://help.aliyun.com/document_detail/2679679.html) operation to start the instance.
        ### [](#)Prerequisites
        Make sure that you are familiar with the ECS billing methods because you may be charged for the resources that are used by the instance. For more information, see [Billing overview](https://help.aliyun.com/document_detail/25398.html).
        Make sure that the number of ECS instances you create or the number of vCPUs on ECS instances of all instance types you create does not exceed the corresponding quota. Go to the [Quota Center](https://quotas.console.aliyun.com/products/ecs/quotas) to view the quotas.
        Before you create ECS instances of the Virtual Private Cloud (VPC) type in a region, create a VPC in the region. For more information, see [Create a VPC](https://help.aliyun.com/document_detail/65430.html).
        ### [](#)Considerations
        If you create a subscription instance (`PrePaid`), available coupons in your account are automatically used.
        If you want to create instances with 512 MiB of memory, you cannot use Windows Server images except for Windows Server Semi-Annual Channel images. If you want to create instances with 4 GiB or more of memory, you cannot use 32-bit OS image.
        If you call the CreateInstance operation to create an instance, no public IP address is automatically assigned to the instance. If the InternetMaxBandwidthOut value of the instance is greater than 0 Mbit/s, call the [AllocatePublicIpAddress](https://help.aliyun.com/document_detail/25544.html) operation to assign a public IP address to the instance. If the InternetMaxBandwidthOut value of the instance is 0 Mbit/s, call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to set InternetMaxBandwidthOut to a value greater than 0 Mbit/s and then call the [AllocatePublicIpAddress](https://help.aliyun.com/document_detail/25544.html) operation to assign a public IP address to the instance.
        >  For the limits on the sum of maximum public bandwidths of ECS instances that use the pay-by-bandwidth billing method for network usage per region per Alibaba Cloud account, see the [Public bandwidth limits](~~25412#BandwidthQuota~~) section of the "Limits" topic.
        ### [](#)Suggestions
        **Instance type selection**: See [Overview of instance families](https://help.aliyun.com/document_detail/25378.html) or call the [DescribeInstanceTypes](https://help.aliyun.com/document_detail/25620.html) operation to query the performance data of instance types, or see [Instance type selection](https://help.aliyun.com/document_detail/58291.html) to learn about how to select instance types.
        **Query of available resources**: Call the [DescribeAvailableResource](https://help.aliyun.com/document_detail/66186.html) operation to query resources available in a specific region or zone.
        **User data**: If the instance type supports [user data](https://help.aliyun.com/document_detail/49121.html), you can use UserData to pass in user data. We recommend that you do not pass in confidential information, such as passwords or private keys, in plaintext as user data. This is because the system does not encrypt `UserData` values when API requests are sent. If you must pass in confidential information as user data, we recommend that you encrypt and encode the information in Base64 before you pass in the information. Then, decode and decrypt the information within the instance for subsequent use.
        
        @param request: CreateInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.affinity):
            query['Affinity'] = request.affinity
        if not UtilClient.is_unset(request.arn):
            query['Arn'] = request.arn
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.credit_specification):
            query['CreditSpecification'] = request.credit_specification
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.dedicated_host_id):
            query['DedicatedHostId'] = request.dedicated_host_id
        if not UtilClient.is_unset(request.deletion_protection):
            query['DeletionProtection'] = request.deletion_protection
        if not UtilClient.is_unset(request.deployment_set_group_no):
            query['DeploymentSetGroupNo'] = request.deployment_set_group_no
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.hpc_cluster_id):
            query['HpcClusterId'] = request.hpc_cluster_id
        if not UtilClient.is_unset(request.http_endpoint):
            query['HttpEndpoint'] = request.http_endpoint
        if not UtilClient.is_unset(request.http_put_response_hop_limit):
            query['HttpPutResponseHopLimit'] = request.http_put_response_hop_limit
        if not UtilClient.is_unset(request.http_tokens):
            query['HttpTokens'] = request.http_tokens
        if not UtilClient.is_unset(request.image_family):
            query['ImageFamily'] = request.image_family
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.inner_ip_address):
            query['InnerIpAddress'] = request.inner_ip_address
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.node_controller_id):
            query['NodeControllerId'] = request.node_controller_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password):
            query['Password'] = request.password
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_interruption_behavior):
            query['SpotInterruptionBehavior'] = request.spot_interruption_behavior
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        if not UtilClient.is_unset(request.storage_set_partition_number):
            query['StorageSetPartitionNumber'] = request.storage_set_partition_number
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.tenancy):
            query['Tenancy'] = request.tenancy
        if not UtilClient.is_unset(request.use_additional_service):
            query['UseAdditionalService'] = request.use_additional_service
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.hibernation_options):
            query['HibernationOptions'] = request.hibernation_options
        if not UtilClient.is_unset(request.private_pool_options):
            query['PrivatePoolOptions'] = request.private_pool_options
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_instance(
        self,
        request: ecs_20140526_models.CreateInstanceRequest,
    ) -> ecs_20140526_models.CreateInstanceResponse:
        """
        @summary Creates a subscription or pay-as-you-go Elastic Compute Service (ECS) instance. When you call this operation, you can specify different parameters to create instances based on your business requirements.
        
        @description >  This operation is no longer iterated or updated. We recommend that you call the [RunInstances](https://help.aliyun.com/document_detail/2679677.html) operation instead.
        *Before you call this operation, familiarize yourself with the billing rules and [pricing](https://www.alibabacloud.com/zh/pricing-calculator#/commodity/vm_intl) of ECS resources.**\
        This operation is an asynchronous operation. After a request to create an ECS instance is sent, an ECS instance ID is immediately returned but the instance may be still being created. You can call the [DescribeInstanceStatus](https://help.aliyun.com/document_detail/2679688.html) operation to query the status of the instance. If the status of the instance is `Stopped` in the DescribeInstanceStatus response, the instance is created. In this case, you can call the [StartInstance](https://help.aliyun.com/document_detail/2679679.html) operation to start the instance.
        ### [](#)Prerequisites
        Make sure that you are familiar with the ECS billing methods because you may be charged for the resources that are used by the instance. For more information, see [Billing overview](https://help.aliyun.com/document_detail/25398.html).
        Make sure that the number of ECS instances you create or the number of vCPUs on ECS instances of all instance types you create does not exceed the corresponding quota. Go to the [Quota Center](https://quotas.console.aliyun.com/products/ecs/quotas) to view the quotas.
        Before you create ECS instances of the Virtual Private Cloud (VPC) type in a region, create a VPC in the region. For more information, see [Create a VPC](https://help.aliyun.com/document_detail/65430.html).
        ### [](#)Considerations
        If you create a subscription instance (`PrePaid`), available coupons in your account are automatically used.
        If you want to create instances with 512 MiB of memory, you cannot use Windows Server images except for Windows Server Semi-Annual Channel images. If you want to create instances with 4 GiB or more of memory, you cannot use 32-bit OS image.
        If you call the CreateInstance operation to create an instance, no public IP address is automatically assigned to the instance. If the InternetMaxBandwidthOut value of the instance is greater than 0 Mbit/s, call the [AllocatePublicIpAddress](https://help.aliyun.com/document_detail/25544.html) operation to assign a public IP address to the instance. If the InternetMaxBandwidthOut value of the instance is 0 Mbit/s, call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to set InternetMaxBandwidthOut to a value greater than 0 Mbit/s and then call the [AllocatePublicIpAddress](https://help.aliyun.com/document_detail/25544.html) operation to assign a public IP address to the instance.
        >  For the limits on the sum of maximum public bandwidths of ECS instances that use the pay-by-bandwidth billing method for network usage per region per Alibaba Cloud account, see the [Public bandwidth limits](~~25412#BandwidthQuota~~) section of the "Limits" topic.
        ### [](#)Suggestions
        **Instance type selection**: See [Overview of instance families](https://help.aliyun.com/document_detail/25378.html) or call the [DescribeInstanceTypes](https://help.aliyun.com/document_detail/25620.html) operation to query the performance data of instance types, or see [Instance type selection](https://help.aliyun.com/document_detail/58291.html) to learn about how to select instance types.
        **Query of available resources**: Call the [DescribeAvailableResource](https://help.aliyun.com/document_detail/66186.html) operation to query resources available in a specific region or zone.
        **User data**: If the instance type supports [user data](https://help.aliyun.com/document_detail/49121.html), you can use UserData to pass in user data. We recommend that you do not pass in confidential information, such as passwords or private keys, in plaintext as user data. This is because the system does not encrypt `UserData` values when API requests are sent. If you must pass in confidential information as user data, we recommend that you encrypt and encode the information in Base64 before you pass in the information. Then, decode and decrypt the information within the instance for subsequent use.
        
        @param request: CreateInstanceRequest
        @return: CreateInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_instance_with_options(request, runtime)

    async def create_instance_async(
        self,
        request: ecs_20140526_models.CreateInstanceRequest,
    ) -> ecs_20140526_models.CreateInstanceResponse:
        """
        @summary Creates a subscription or pay-as-you-go Elastic Compute Service (ECS) instance. When you call this operation, you can specify different parameters to create instances based on your business requirements.
        
        @description >  This operation is no longer iterated or updated. We recommend that you call the [RunInstances](https://help.aliyun.com/document_detail/2679677.html) operation instead.
        *Before you call this operation, familiarize yourself with the billing rules and [pricing](https://www.alibabacloud.com/zh/pricing-calculator#/commodity/vm_intl) of ECS resources.**\
        This operation is an asynchronous operation. After a request to create an ECS instance is sent, an ECS instance ID is immediately returned but the instance may be still being created. You can call the [DescribeInstanceStatus](https://help.aliyun.com/document_detail/2679688.html) operation to query the status of the instance. If the status of the instance is `Stopped` in the DescribeInstanceStatus response, the instance is created. In this case, you can call the [StartInstance](https://help.aliyun.com/document_detail/2679679.html) operation to start the instance.
        ### [](#)Prerequisites
        Make sure that you are familiar with the ECS billing methods because you may be charged for the resources that are used by the instance. For more information, see [Billing overview](https://help.aliyun.com/document_detail/25398.html).
        Make sure that the number of ECS instances you create or the number of vCPUs on ECS instances of all instance types you create does not exceed the corresponding quota. Go to the [Quota Center](https://quotas.console.aliyun.com/products/ecs/quotas) to view the quotas.
        Before you create ECS instances of the Virtual Private Cloud (VPC) type in a region, create a VPC in the region. For more information, see [Create a VPC](https://help.aliyun.com/document_detail/65430.html).
        ### [](#)Considerations
        If you create a subscription instance (`PrePaid`), available coupons in your account are automatically used.
        If you want to create instances with 512 MiB of memory, you cannot use Windows Server images except for Windows Server Semi-Annual Channel images. If you want to create instances with 4 GiB or more of memory, you cannot use 32-bit OS image.
        If you call the CreateInstance operation to create an instance, no public IP address is automatically assigned to the instance. If the InternetMaxBandwidthOut value of the instance is greater than 0 Mbit/s, call the [AllocatePublicIpAddress](https://help.aliyun.com/document_detail/25544.html) operation to assign a public IP address to the instance. If the InternetMaxBandwidthOut value of the instance is 0 Mbit/s, call the [ModifyInstanceNetworkSpec](https://help.aliyun.com/document_detail/2679879.html) operation to set InternetMaxBandwidthOut to a value greater than 0 Mbit/s and then call the [AllocatePublicIpAddress](https://help.aliyun.com/document_detail/25544.html) operation to assign a public IP address to the instance.
        >  For the limits on the sum of maximum public bandwidths of ECS instances that use the pay-by-bandwidth billing method for network usage per region per Alibaba Cloud account, see the [Public bandwidth limits](~~25412#BandwidthQuota~~) section of the "Limits" topic.
        ### [](#)Suggestions
        **Instance type selection**: See [Overview of instance families](https://help.aliyun.com/document_detail/25378.html) or call the [DescribeInstanceTypes](https://help.aliyun.com/document_detail/25620.html) operation to query the performance data of instance types, or see [Instance type selection](https://help.aliyun.com/document_detail/58291.html) to learn about how to select instance types.
        **Query of available resources**: Call the [DescribeAvailableResource](https://help.aliyun.com/document_detail/66186.html) operation to query resources available in a specific region or zone.
        **User data**: If the instance type supports [user data](https://help.aliyun.com/document_detail/49121.html), you can use UserData to pass in user data. We recommend that you do not pass in confidential information, such as passwords or private keys, in plaintext as user data. This is because the system does not encrypt `UserData` values when API requests are sent. If you must pass in confidential information as user data, we recommend that you encrypt and encode the information in Base64 before you pass in the information. Then, decode and decrypt the information within the instance for subsequent use.
        
        @param request: CreateInstanceRequest
        @return: CreateInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_instance_with_options_async(request, runtime)

    def create_key_pair_with_options(
        self,
        request: ecs_20140526_models.CreateKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateKeyPairResponse:
        """
        @summary Creates an SSH key pair. The system stores the public key and returns the unencrypted private key. The private key is encoded with PEM in the PKCS#8 format. You must properly store the private key and ensure its confidentiality.
        
        @description In addition to calling the CreateKeyPair operation to create a key pair, you can use a third-party tool to create a key pair and then call the [ImportKeyPair](https://help.aliyun.com/document_detail/51774.html) operation to upload the key pair to an Alibaba Cloud region.
        Up to 500 key pairs can be created in each region. For more information, see the "SSH key pair limits" section in [Limits](https://help.aliyun.com/document_detail/25412.html).
        
        @param request: CreateKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateKeyPair',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateKeyPairResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_key_pair_with_options_async(
        self,
        request: ecs_20140526_models.CreateKeyPairRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateKeyPairResponse:
        """
        @summary Creates an SSH key pair. The system stores the public key and returns the unencrypted private key. The private key is encoded with PEM in the PKCS#8 format. You must properly store the private key and ensure its confidentiality.
        
        @description In addition to calling the CreateKeyPair operation to create a key pair, you can use a third-party tool to create a key pair and then call the [ImportKeyPair](https://help.aliyun.com/document_detail/51774.html) operation to upload the key pair to an Alibaba Cloud region.
        Up to 500 key pairs can be created in each region. For more information, see the "SSH key pair limits" section in [Limits](https://help.aliyun.com/document_detail/25412.html).
        
        @param request: CreateKeyPairRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateKeyPairResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateKeyPair',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateKeyPairResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_key_pair(
        self,
        request: ecs_20140526_models.CreateKeyPairRequest,
    ) -> ecs_20140526_models.CreateKeyPairResponse:
        """
        @summary Creates an SSH key pair. The system stores the public key and returns the unencrypted private key. The private key is encoded with PEM in the PKCS#8 format. You must properly store the private key and ensure its confidentiality.
        
        @description In addition to calling the CreateKeyPair operation to create a key pair, you can use a third-party tool to create a key pair and then call the [ImportKeyPair](https://help.aliyun.com/document_detail/51774.html) operation to upload the key pair to an Alibaba Cloud region.
        Up to 500 key pairs can be created in each region. For more information, see the "SSH key pair limits" section in [Limits](https://help.aliyun.com/document_detail/25412.html).
        
        @param request: CreateKeyPairRequest
        @return: CreateKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_key_pair_with_options(request, runtime)

    async def create_key_pair_async(
        self,
        request: ecs_20140526_models.CreateKeyPairRequest,
    ) -> ecs_20140526_models.CreateKeyPairResponse:
        """
        @summary Creates an SSH key pair. The system stores the public key and returns the unencrypted private key. The private key is encoded with PEM in the PKCS#8 format. You must properly store the private key and ensure its confidentiality.
        
        @description In addition to calling the CreateKeyPair operation to create a key pair, you can use a third-party tool to create a key pair and then call the [ImportKeyPair](https://help.aliyun.com/document_detail/51774.html) operation to upload the key pair to an Alibaba Cloud region.
        Up to 500 key pairs can be created in each region. For more information, see the "SSH key pair limits" section in [Limits](https://help.aliyun.com/document_detail/25412.html).
        
        @param request: CreateKeyPairRequest
        @return: CreateKeyPairResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_key_pair_with_options_async(request, runtime)

    def create_launch_template_with_options(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateLaunchTemplateResponse:
        """
        @summary Creates a launch template. A launch template eliminates the need to configure a large number of parameters every time you create an Elastic Compute Service (ECS) instance.
        
        @description After you create a launch template by calling the CreateLaunchTemplate operation, a default version that has a version number of 1 is automatically generated for the launch template. You can call the `CreateLaunchTemplateVersion` operation to create additional versions for the launch template. Version numbers start from 1 and increment by 1. If you specify a launch template but do not specify a launch template version number when you call the [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to create instances, the default version of the launch template is used.
        Launch templates contain preset configurations that are used to create instances, such as the region ID, image ID, instance type, security group ID, and public bandwidth settings. If a specific parameter is not included in a launch template, you need to manually specify the parameter when you use the launch template to create instances.
        Take note of the following items:
        You can retain up to 30 launch templates in each region in your Alibaba Cloud account. Each launch template can have up to 30 versions.
        Most parameters in launch templates are optional. When you create a launch template, ECS does not verify the existence or validity of specified parameter values. The parameter values are verified only when you use the launch template to create instances.
        If you configured a specific parameter in a launch template, you cannot filter out the parameter when you call the [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to create instances from the launch template. For example, if you set `HostName` to LocalHost in a launch template but do not specify `HostName` when you call the `RunInstances` operation to create instances from the launch template, the hostname of the created instances is `LocalHost`. If you want to overwrite `LocalHost`, which is the value of HostName in the launch template, you can set `HostName` to MyHost or a different value when you call the `RunInstances` operation.
        
        @param request: CreateLaunchTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLaunchTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.credit_specification):
            query['CreditSpecification'] = request.credit_specification
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.deletion_protection):
            query['DeletionProtection'] = request.deletion_protection
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_vm_os_config):
            query['EnableVmOsConfig'] = request.enable_vm_os_config
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.http_endpoint):
            query['HttpEndpoint'] = request.http_endpoint
        if not UtilClient.is_unset(request.http_put_response_hop_limit):
            query['HttpPutResponseHopLimit'] = request.http_put_response_hop_limit
        if not UtilClient.is_unset(request.http_tokens):
            query['HttpTokens'] = request.http_tokens
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_options):
            query['ImageOptions'] = request.image_options
        if not UtilClient.is_unset(request.image_owner_alias):
            query['ImageOwnerAlias'] = request.image_owner_alias
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.network_interface):
            query['NetworkInterface'] = request.network_interface
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.security_options):
            query['SecurityOptions'] = request.security_options
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.template_resource_group_id):
            query['TemplateResourceGroupId'] = request.template_resource_group_id
        if not UtilClient.is_unset(request.template_tag):
            query['TemplateTag'] = request.template_tag
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.version_description):
            query['VersionDescription'] = request.version_description
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLaunchTemplate',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateLaunchTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_launch_template_with_options_async(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateLaunchTemplateResponse:
        """
        @summary Creates a launch template. A launch template eliminates the need to configure a large number of parameters every time you create an Elastic Compute Service (ECS) instance.
        
        @description After you create a launch template by calling the CreateLaunchTemplate operation, a default version that has a version number of 1 is automatically generated for the launch template. You can call the `CreateLaunchTemplateVersion` operation to create additional versions for the launch template. Version numbers start from 1 and increment by 1. If you specify a launch template but do not specify a launch template version number when you call the [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to create instances, the default version of the launch template is used.
        Launch templates contain preset configurations that are used to create instances, such as the region ID, image ID, instance type, security group ID, and public bandwidth settings. If a specific parameter is not included in a launch template, you need to manually specify the parameter when you use the launch template to create instances.
        Take note of the following items:
        You can retain up to 30 launch templates in each region in your Alibaba Cloud account. Each launch template can have up to 30 versions.
        Most parameters in launch templates are optional. When you create a launch template, ECS does not verify the existence or validity of specified parameter values. The parameter values are verified only when you use the launch template to create instances.
        If you configured a specific parameter in a launch template, you cannot filter out the parameter when you call the [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to create instances from the launch template. For example, if you set `HostName` to LocalHost in a launch template but do not specify `HostName` when you call the `RunInstances` operation to create instances from the launch template, the hostname of the created instances is `LocalHost`. If you want to overwrite `LocalHost`, which is the value of HostName in the launch template, you can set `HostName` to MyHost or a different value when you call the `RunInstances` operation.
        
        @param request: CreateLaunchTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLaunchTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.credit_specification):
            query['CreditSpecification'] = request.credit_specification
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.deletion_protection):
            query['DeletionProtection'] = request.deletion_protection
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_vm_os_config):
            query['EnableVmOsConfig'] = request.enable_vm_os_config
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.http_endpoint):
            query['HttpEndpoint'] = request.http_endpoint
        if not UtilClient.is_unset(request.http_put_response_hop_limit):
            query['HttpPutResponseHopLimit'] = request.http_put_response_hop_limit
        if not UtilClient.is_unset(request.http_tokens):
            query['HttpTokens'] = request.http_tokens
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_options):
            query['ImageOptions'] = request.image_options
        if not UtilClient.is_unset(request.image_owner_alias):
            query['ImageOwnerAlias'] = request.image_owner_alias
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.network_interface):
            query['NetworkInterface'] = request.network_interface
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.security_options):
            query['SecurityOptions'] = request.security_options
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.template_resource_group_id):
            query['TemplateResourceGroupId'] = request.template_resource_group_id
        if not UtilClient.is_unset(request.template_tag):
            query['TemplateTag'] = request.template_tag
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.version_description):
            query['VersionDescription'] = request.version_description
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLaunchTemplate',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateLaunchTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_launch_template(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateRequest,
    ) -> ecs_20140526_models.CreateLaunchTemplateResponse:
        """
        @summary Creates a launch template. A launch template eliminates the need to configure a large number of parameters every time you create an Elastic Compute Service (ECS) instance.
        
        @description After you create a launch template by calling the CreateLaunchTemplate operation, a default version that has a version number of 1 is automatically generated for the launch template. You can call the `CreateLaunchTemplateVersion` operation to create additional versions for the launch template. Version numbers start from 1 and increment by 1. If you specify a launch template but do not specify a launch template version number when you call the [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to create instances, the default version of the launch template is used.
        Launch templates contain preset configurations that are used to create instances, such as the region ID, image ID, instance type, security group ID, and public bandwidth settings. If a specific parameter is not included in a launch template, you need to manually specify the parameter when you use the launch template to create instances.
        Take note of the following items:
        You can retain up to 30 launch templates in each region in your Alibaba Cloud account. Each launch template can have up to 30 versions.
        Most parameters in launch templates are optional. When you create a launch template, ECS does not verify the existence or validity of specified parameter values. The parameter values are verified only when you use the launch template to create instances.
        If you configured a specific parameter in a launch template, you cannot filter out the parameter when you call the [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to create instances from the launch template. For example, if you set `HostName` to LocalHost in a launch template but do not specify `HostName` when you call the `RunInstances` operation to create instances from the launch template, the hostname of the created instances is `LocalHost`. If you want to overwrite `LocalHost`, which is the value of HostName in the launch template, you can set `HostName` to MyHost or a different value when you call the `RunInstances` operation.
        
        @param request: CreateLaunchTemplateRequest
        @return: CreateLaunchTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_launch_template_with_options(request, runtime)

    async def create_launch_template_async(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateRequest,
    ) -> ecs_20140526_models.CreateLaunchTemplateResponse:
        """
        @summary Creates a launch template. A launch template eliminates the need to configure a large number of parameters every time you create an Elastic Compute Service (ECS) instance.
        
        @description After you create a launch template by calling the CreateLaunchTemplate operation, a default version that has a version number of 1 is automatically generated for the launch template. You can call the `CreateLaunchTemplateVersion` operation to create additional versions for the launch template. Version numbers start from 1 and increment by 1. If you specify a launch template but do not specify a launch template version number when you call the [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to create instances, the default version of the launch template is used.
        Launch templates contain preset configurations that are used to create instances, such as the region ID, image ID, instance type, security group ID, and public bandwidth settings. If a specific parameter is not included in a launch template, you need to manually specify the parameter when you use the launch template to create instances.
        Take note of the following items:
        You can retain up to 30 launch templates in each region in your Alibaba Cloud account. Each launch template can have up to 30 versions.
        Most parameters in launch templates are optional. When you create a launch template, ECS does not verify the existence or validity of specified parameter values. The parameter values are verified only when you use the launch template to create instances.
        If you configured a specific parameter in a launch template, you cannot filter out the parameter when you call the [RunInstances](https://help.aliyun.com/document_detail/63440.html) operation to create instances from the launch template. For example, if you set `HostName` to LocalHost in a launch template but do not specify `HostName` when you call the `RunInstances` operation to create instances from the launch template, the hostname of the created instances is `LocalHost`. If you want to overwrite `LocalHost`, which is the value of HostName in the launch template, you can set `HostName` to MyHost or a different value when you call the `RunInstances` operation.
        
        @param request: CreateLaunchTemplateRequest
        @return: CreateLaunchTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_launch_template_with_options_async(request, runtime)

    def create_launch_template_version_with_options(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateLaunchTemplateVersionResponse:
        """
        @summary Creates a version for a launch template. You can use the created version to create Elastic Compute Service (ECS) instances, scaling groups, or auto provisioning groups.
        
        @description ## [](#)Usage notes
        If you want to modify the parameters of a launch template version, you can create another version with different parameter settings for the launch template. You can create up to 30 versions for each launch template.
        
        @param request: CreateLaunchTemplateVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLaunchTemplateVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.credit_specification):
            query['CreditSpecification'] = request.credit_specification
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.deletion_protection):
            query['DeletionProtection'] = request.deletion_protection
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_vm_os_config):
            query['EnableVmOsConfig'] = request.enable_vm_os_config
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.http_endpoint):
            query['HttpEndpoint'] = request.http_endpoint
        if not UtilClient.is_unset(request.http_put_response_hop_limit):
            query['HttpPutResponseHopLimit'] = request.http_put_response_hop_limit
        if not UtilClient.is_unset(request.http_tokens):
            query['HttpTokens'] = request.http_tokens
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_options):
            query['ImageOptions'] = request.image_options
        if not UtilClient.is_unset(request.image_owner_alias):
            query['ImageOwnerAlias'] = request.image_owner_alias
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.network_interface):
            query['NetworkInterface'] = request.network_interface
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.security_options):
            query['SecurityOptions'] = request.security_options
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.version_description):
            query['VersionDescription'] = request.version_description
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLaunchTemplateVersion',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateLaunchTemplateVersionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_launch_template_version_with_options_async(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateLaunchTemplateVersionResponse:
        """
        @summary Creates a version for a launch template. You can use the created version to create Elastic Compute Service (ECS) instances, scaling groups, or auto provisioning groups.
        
        @description ## [](#)Usage notes
        If you want to modify the parameters of a launch template version, you can create another version with different parameter settings for the launch template. You can create up to 30 versions for each launch template.
        
        @param request: CreateLaunchTemplateVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateLaunchTemplateVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_release_time):
            query['AutoReleaseTime'] = request.auto_release_time
        if not UtilClient.is_unset(request.auto_renew):
            query['AutoRenew'] = request.auto_renew
        if not UtilClient.is_unset(request.auto_renew_period):
            query['AutoRenewPeriod'] = request.auto_renew_period
        if not UtilClient.is_unset(request.credit_specification):
            query['CreditSpecification'] = request.credit_specification
        if not UtilClient.is_unset(request.data_disk):
            query['DataDisk'] = request.data_disk
        if not UtilClient.is_unset(request.deletion_protection):
            query['DeletionProtection'] = request.deletion_protection
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_vm_os_config):
            query['EnableVmOsConfig'] = request.enable_vm_os_config
        if not UtilClient.is_unset(request.host_name):
            query['HostName'] = request.host_name
        if not UtilClient.is_unset(request.http_endpoint):
            query['HttpEndpoint'] = request.http_endpoint
        if not UtilClient.is_unset(request.http_put_response_hop_limit):
            query['HttpPutResponseHopLimit'] = request.http_put_response_hop_limit
        if not UtilClient.is_unset(request.http_tokens):
            query['HttpTokens'] = request.http_tokens
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.image_options):
            query['ImageOptions'] = request.image_options
        if not UtilClient.is_unset(request.image_owner_alias):
            query['ImageOwnerAlias'] = request.image_owner_alias
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.internet_max_bandwidth_in):
            query['InternetMaxBandwidthIn'] = request.internet_max_bandwidth_in
        if not UtilClient.is_unset(request.internet_max_bandwidth_out):
            query['InternetMaxBandwidthOut'] = request.internet_max_bandwidth_out
        if not UtilClient.is_unset(request.io_optimized):
            query['IoOptimized'] = request.io_optimized
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.key_pair_name):
            query['KeyPairName'] = request.key_pair_name
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.network_interface):
            query['NetworkInterface'] = request.network_interface
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.password_inherit):
            query['PasswordInherit'] = request.password_inherit
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.ram_role_name):
            query['RamRoleName'] = request.ram_role_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_enhancement_strategy):
            query['SecurityEnhancementStrategy'] = request.security_enhancement_strategy
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.security_options):
            query['SecurityOptions'] = request.security_options
        if not UtilClient.is_unset(request.spot_duration):
            query['SpotDuration'] = request.spot_duration
        if not UtilClient.is_unset(request.spot_price_limit):
            query['SpotPriceLimit'] = request.spot_price_limit
        if not UtilClient.is_unset(request.spot_strategy):
            query['SpotStrategy'] = request.spot_strategy
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.user_data):
            query['UserData'] = request.user_data
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.version_description):
            query['VersionDescription'] = request.version_description
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        if not UtilClient.is_unset(request.system_disk):
            query['SystemDisk'] = request.system_disk
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateLaunchTemplateVersion',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateLaunchTemplateVersionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_launch_template_version(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateVersionRequest,
    ) -> ecs_20140526_models.CreateLaunchTemplateVersionResponse:
        """
        @summary Creates a version for a launch template. You can use the created version to create Elastic Compute Service (ECS) instances, scaling groups, or auto provisioning groups.
        
        @description ## [](#)Usage notes
        If you want to modify the parameters of a launch template version, you can create another version with different parameter settings for the launch template. You can create up to 30 versions for each launch template.
        
        @param request: CreateLaunchTemplateVersionRequest
        @return: CreateLaunchTemplateVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_launch_template_version_with_options(request, runtime)

    async def create_launch_template_version_async(
        self,
        request: ecs_20140526_models.CreateLaunchTemplateVersionRequest,
    ) -> ecs_20140526_models.CreateLaunchTemplateVersionResponse:
        """
        @summary Creates a version for a launch template. You can use the created version to create Elastic Compute Service (ECS) instances, scaling groups, or auto provisioning groups.
        
        @description ## [](#)Usage notes
        If you want to modify the parameters of a launch template version, you can create another version with different parameter settings for the launch template. You can create up to 30 versions for each launch template.
        
        @param request: CreateLaunchTemplateVersionRequest
        @return: CreateLaunchTemplateVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_launch_template_version_with_options_async(request, runtime)

    def create_nat_gateway_with_options(
        self,
        request: ecs_20140526_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNatGatewayResponse:
        """
        @deprecated OpenAPI CreateNatGateway is deprecated, please use Vpc::2016-04-28::CreateNatGateway instead.
        
        @summary CreateNatGateway
        
        @param request: CreateNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatGatewayResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package):
            query['BandwidthPackage'] = request.bandwidth_package
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_gateway_with_options_async(
        self,
        request: ecs_20140526_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNatGatewayResponse:
        """
        @deprecated OpenAPI CreateNatGateway is deprecated, please use Vpc::2016-04-28::CreateNatGateway instead.
        
        @summary CreateNatGateway
        
        @param request: CreateNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatGatewayResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package):
            query['BandwidthPackage'] = request.bandwidth_package
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_gateway(
        self,
        request: ecs_20140526_models.CreateNatGatewayRequest,
    ) -> ecs_20140526_models.CreateNatGatewayResponse:
        """
        @deprecated OpenAPI CreateNatGateway is deprecated, please use Vpc::2016-04-28::CreateNatGateway instead.
        
        @summary CreateNatGateway
        
        @param request: CreateNatGatewayRequest
        @return: CreateNatGatewayResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nat_gateway_with_options(request, runtime)

    async def create_nat_gateway_async(
        self,
        request: ecs_20140526_models.CreateNatGatewayRequest,
    ) -> ecs_20140526_models.CreateNatGatewayResponse:
        """
        @deprecated OpenAPI CreateNatGateway is deprecated, please use Vpc::2016-04-28::CreateNatGateway instead.
        
        @summary CreateNatGateway
        
        @param request: CreateNatGatewayRequest
        @return: CreateNatGatewayResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_gateway_with_options_async(request, runtime)

    def create_network_interface_with_options(
        self,
        request: ecs_20140526_models.CreateNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNetworkInterfaceResponse:
        """
        @summary Creates an elastic network interface (ENI). You can specify an IP address as the primary private IP address of the ENI.
        
        @description Take note of the following items:
        This operation is a synchronous operation. After an ENI is created, the ENI immediately enters the Available (`Available`) state and can be attached to an Elastic Compute Service (ECS) instance.
        If `NetworkInterfaceId` is empty in the response, no ENI is created. Recall the operation to create an ENI.
        An ENI can be attached only to a single ECS instance that resides in a virtual private cloud (VPC).
        When an ENI is detached from an ECS instance and attached to another ECS instance, the attributes of the ENI remain unchanged and network traffic is redirected to the new instance.
        When you call this operation to create an ENI, you can assign up to 49 secondary private IP addresses to the ENI.
        If you want to assign IPv6 addresses when you create an ENI, make sure that IPv6 is enabled for the vSwitch with which you want to associate the ENI. For more information, see [What is an IPv6 gateway?](https://help.aliyun.com/document_detail/98896.html)
        A limit is imposed on the number of ENIs that can be created per Alibaba Cloud region per account. You can view the quota limit in the ECS console. For more information, see [Manage ECS quotas](https://help.aliyun.com/document_detail/184115.html).
        ### [](#)Sample requests
        *Create an ENI**\
        RegionId:  cn-hangzhou,   // Specify the China (Hangzhou) region.SecurityGroupId:  sg-bp10jztp6b0sdsyl***,   // Specify the ID of the security group in which to create the ENI.VSwitchId:  vsw-bp19wo63nleroq22g****,   // Specify the ID of the vSwitch to which to connect the ENI.
        *Create an ENI and specify an IP address as the primary private IP address of the ENI**\
        RegionId:  cn-hangzhou,   // Specify the China (Hangzhou) region.SecurityGroupId:  sg-bp10jztp6b0sdsyl***,   // Specify the ID of the security group in which to create the ENI.VSwitchId:  vsw-bp19wo63nleroq22g****,   // Specify the ID of the vSwitch to which to connect the ENI.PrimaryIpAddress:  192.168.0.*,   // Specify an IP address as the primary private IP address of the ENI.
        
        @param request: CreateNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.connection_tracking_configuration):
            query['ConnectionTrackingConfiguration'] = request.connection_tracking_configuration
        if not UtilClient.is_unset(request.delete_on_release):
            query['DeleteOnRelease'] = request.delete_on_release
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enhanced_network):
            query['EnhancedNetwork'] = request.enhanced_network
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.ipv_4prefix):
            query['Ipv4Prefix'] = request.ipv_4prefix
        if not UtilClient.is_unset(request.ipv_4prefix_count):
            query['Ipv4PrefixCount'] = request.ipv_4prefix_count
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.ipv_6prefix):
            query['Ipv6Prefix'] = request.ipv_6prefix
        if not UtilClient.is_unset(request.ipv_6prefix_count):
            query['Ipv6PrefixCount'] = request.ipv_6prefix_count
        if not UtilClient.is_unset(request.network_interface_name):
            query['NetworkInterfaceName'] = request.network_interface_name
        if not UtilClient.is_unset(request.network_interface_traffic_config):
            query['NetworkInterfaceTrafficConfig'] = request.network_interface_traffic_config
        if not UtilClient.is_unset(request.network_interface_traffic_mode):
            query['NetworkInterfaceTrafficMode'] = request.network_interface_traffic_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.primary_ip_address):
            query['PrimaryIpAddress'] = request.primary_ip_address
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.queue_number):
            query['QueueNumber'] = request.queue_number
        if not UtilClient.is_unset(request.queue_pair_number):
            query['QueuePairNumber'] = request.queue_pair_number
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rx_queue_size):
            query['RxQueueSize'] = request.rx_queue_size
        if not UtilClient.is_unset(request.secondary_private_ip_address_count):
            query['SecondaryPrivateIpAddressCount'] = request.secondary_private_ip_address_count
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.source_dest_check):
            query['SourceDestCheck'] = request.source_dest_check
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.tx_queue_size):
            query['TxQueueSize'] = request.tx_queue_size
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.visible):
            query['Visible'] = request.visible
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNetworkInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_interface_with_options_async(
        self,
        request: ecs_20140526_models.CreateNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNetworkInterfaceResponse:
        """
        @summary Creates an elastic network interface (ENI). You can specify an IP address as the primary private IP address of the ENI.
        
        @description Take note of the following items:
        This operation is a synchronous operation. After an ENI is created, the ENI immediately enters the Available (`Available`) state and can be attached to an Elastic Compute Service (ECS) instance.
        If `NetworkInterfaceId` is empty in the response, no ENI is created. Recall the operation to create an ENI.
        An ENI can be attached only to a single ECS instance that resides in a virtual private cloud (VPC).
        When an ENI is detached from an ECS instance and attached to another ECS instance, the attributes of the ENI remain unchanged and network traffic is redirected to the new instance.
        When you call this operation to create an ENI, you can assign up to 49 secondary private IP addresses to the ENI.
        If you want to assign IPv6 addresses when you create an ENI, make sure that IPv6 is enabled for the vSwitch with which you want to associate the ENI. For more information, see [What is an IPv6 gateway?](https://help.aliyun.com/document_detail/98896.html)
        A limit is imposed on the number of ENIs that can be created per Alibaba Cloud region per account. You can view the quota limit in the ECS console. For more information, see [Manage ECS quotas](https://help.aliyun.com/document_detail/184115.html).
        ### [](#)Sample requests
        *Create an ENI**\
        RegionId:  cn-hangzhou,   // Specify the China (Hangzhou) region.SecurityGroupId:  sg-bp10jztp6b0sdsyl***,   // Specify the ID of the security group in which to create the ENI.VSwitchId:  vsw-bp19wo63nleroq22g****,   // Specify the ID of the vSwitch to which to connect the ENI.
        *Create an ENI and specify an IP address as the primary private IP address of the ENI**\
        RegionId:  cn-hangzhou,   // Specify the China (Hangzhou) region.SecurityGroupId:  sg-bp10jztp6b0sdsyl***,   // Specify the ID of the security group in which to create the ENI.VSwitchId:  vsw-bp19wo63nleroq22g****,   // Specify the ID of the vSwitch to which to connect the ENI.PrimaryIpAddress:  192.168.0.*,   // Specify an IP address as the primary private IP address of the ENI.
        
        @param request: CreateNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_type):
            query['BusinessType'] = request.business_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.connection_tracking_configuration):
            query['ConnectionTrackingConfiguration'] = request.connection_tracking_configuration
        if not UtilClient.is_unset(request.delete_on_release):
            query['DeleteOnRelease'] = request.delete_on_release
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enhanced_network):
            query['EnhancedNetwork'] = request.enhanced_network
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.ipv_4prefix):
            query['Ipv4Prefix'] = request.ipv_4prefix
        if not UtilClient.is_unset(request.ipv_4prefix_count):
            query['Ipv4PrefixCount'] = request.ipv_4prefix_count
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.ipv_6address_count):
            query['Ipv6AddressCount'] = request.ipv_6address_count
        if not UtilClient.is_unset(request.ipv_6prefix):
            query['Ipv6Prefix'] = request.ipv_6prefix
        if not UtilClient.is_unset(request.ipv_6prefix_count):
            query['Ipv6PrefixCount'] = request.ipv_6prefix_count
        if not UtilClient.is_unset(request.network_interface_name):
            query['NetworkInterfaceName'] = request.network_interface_name
        if not UtilClient.is_unset(request.network_interface_traffic_config):
            query['NetworkInterfaceTrafficConfig'] = request.network_interface_traffic_config
        if not UtilClient.is_unset(request.network_interface_traffic_mode):
            query['NetworkInterfaceTrafficMode'] = request.network_interface_traffic_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.primary_ip_address):
            query['PrimaryIpAddress'] = request.primary_ip_address
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.queue_number):
            query['QueueNumber'] = request.queue_number
        if not UtilClient.is_unset(request.queue_pair_number):
            query['QueuePairNumber'] = request.queue_pair_number
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rx_queue_size):
            query['RxQueueSize'] = request.rx_queue_size
        if not UtilClient.is_unset(request.secondary_private_ip_address_count):
            query['SecondaryPrivateIpAddressCount'] = request.secondary_private_ip_address_count
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        if not UtilClient.is_unset(request.security_group_ids):
            query['SecurityGroupIds'] = request.security_group_ids
        if not UtilClient.is_unset(request.source_dest_check):
            query['SourceDestCheck'] = request.source_dest_check
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.tx_queue_size):
            query['TxQueueSize'] = request.tx_queue_size
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.visible):
            query['Visible'] = request.visible
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNetworkInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_interface(
        self,
        request: ecs_20140526_models.CreateNetworkInterfaceRequest,
    ) -> ecs_20140526_models.CreateNetworkInterfaceResponse:
        """
        @summary Creates an elastic network interface (ENI). You can specify an IP address as the primary private IP address of the ENI.
        
        @description Take note of the following items:
        This operation is a synchronous operation. After an ENI is created, the ENI immediately enters the Available (`Available`) state and can be attached to an Elastic Compute Service (ECS) instance.
        If `NetworkInterfaceId` is empty in the response, no ENI is created. Recall the operation to create an ENI.
        An ENI can be attached only to a single ECS instance that resides in a virtual private cloud (VPC).
        When an ENI is detached from an ECS instance and attached to another ECS instance, the attributes of the ENI remain unchanged and network traffic is redirected to the new instance.
        When you call this operation to create an ENI, you can assign up to 49 secondary private IP addresses to the ENI.
        If you want to assign IPv6 addresses when you create an ENI, make sure that IPv6 is enabled for the vSwitch with which you want to associate the ENI. For more information, see [What is an IPv6 gateway?](https://help.aliyun.com/document_detail/98896.html)
        A limit is imposed on the number of ENIs that can be created per Alibaba Cloud region per account. You can view the quota limit in the ECS console. For more information, see [Manage ECS quotas](https://help.aliyun.com/document_detail/184115.html).
        ### [](#)Sample requests
        *Create an ENI**\
        RegionId:  cn-hangzhou,   // Specify the China (Hangzhou) region.SecurityGroupId:  sg-bp10jztp6b0sdsyl***,   // Specify the ID of the security group in which to create the ENI.VSwitchId:  vsw-bp19wo63nleroq22g****,   // Specify the ID of the vSwitch to which to connect the ENI.
        *Create an ENI and specify an IP address as the primary private IP address of the ENI**\
        RegionId:  cn-hangzhou,   // Specify the China (Hangzhou) region.SecurityGroupId:  sg-bp10jztp6b0sdsyl***,   // Specify the ID of the security group in which to create the ENI.VSwitchId:  vsw-bp19wo63nleroq22g****,   // Specify the ID of the vSwitch to which to connect the ENI.PrimaryIpAddress:  192.168.0.*,   // Specify an IP address as the primary private IP address of the ENI.
        
        @param request: CreateNetworkInterfaceRequest
        @return: CreateNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_network_interface_with_options(request, runtime)

    async def create_network_interface_async(
        self,
        request: ecs_20140526_models.CreateNetworkInterfaceRequest,
    ) -> ecs_20140526_models.CreateNetworkInterfaceResponse:
        """
        @summary Creates an elastic network interface (ENI). You can specify an IP address as the primary private IP address of the ENI.
        
        @description Take note of the following items:
        This operation is a synchronous operation. After an ENI is created, the ENI immediately enters the Available (`Available`) state and can be attached to an Elastic Compute Service (ECS) instance.
        If `NetworkInterfaceId` is empty in the response, no ENI is created. Recall the operation to create an ENI.
        An ENI can be attached only to a single ECS instance that resides in a virtual private cloud (VPC).
        When an ENI is detached from an ECS instance and attached to another ECS instance, the attributes of the ENI remain unchanged and network traffic is redirected to the new instance.
        When you call this operation to create an ENI, you can assign up to 49 secondary private IP addresses to the ENI.
        If you want to assign IPv6 addresses when you create an ENI, make sure that IPv6 is enabled for the vSwitch with which you want to associate the ENI. For more information, see [What is an IPv6 gateway?](https://help.aliyun.com/document_detail/98896.html)
        A limit is imposed on the number of ENIs that can be created per Alibaba Cloud region per account. You can view the quota limit in the ECS console. For more information, see [Manage ECS quotas](https://help.aliyun.com/document_detail/184115.html).
        ### [](#)Sample requests
        *Create an ENI**\
        RegionId:  cn-hangzhou,   // Specify the China (Hangzhou) region.SecurityGroupId:  sg-bp10jztp6b0sdsyl***,   // Specify the ID of the security group in which to create the ENI.VSwitchId:  vsw-bp19wo63nleroq22g****,   // Specify the ID of the vSwitch to which to connect the ENI.
        *Create an ENI and specify an IP address as the primary private IP address of the ENI**\
        RegionId:  cn-hangzhou,   // Specify the China (Hangzhou) region.SecurityGroupId:  sg-bp10jztp6b0sdsyl***,   // Specify the ID of the security group in which to create the ENI.VSwitchId:  vsw-bp19wo63nleroq22g****,   // Specify the ID of the vSwitch to which to connect the ENI.PrimaryIpAddress:  192.168.0.*,   // Specify an IP address as the primary private IP address of the ENI.
        
        @param request: CreateNetworkInterfaceRequest
        @return: CreateNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_network_interface_with_options_async(request, runtime)

    def create_network_interface_permission_with_options(
        self,
        request: ecs_20140526_models.CreateNetworkInterfacePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNetworkInterfacePermissionResponse:
        """
        @summary Grants a permission on an elastic network interface (ENI) to an Alibaba Cloud partner (a certified ISV) or an individual user.
        
        @description Before you call this operation, submit a ticket to apply for using this operation.
        
        @param request: CreateNetworkInterfacePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkInterfacePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_id):
            query['AccountId'] = request.account_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permission):
            query['Permission'] = request.permission
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkInterfacePermission',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNetworkInterfacePermissionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_interface_permission_with_options_async(
        self,
        request: ecs_20140526_models.CreateNetworkInterfacePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateNetworkInterfacePermissionResponse:
        """
        @summary Grants a permission on an elastic network interface (ENI) to an Alibaba Cloud partner (a certified ISV) or an individual user.
        
        @description Before you call this operation, submit a ticket to apply for using this operation.
        
        @param request: CreateNetworkInterfacePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNetworkInterfacePermissionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.account_id):
            query['AccountId'] = request.account_id
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.permission):
            query['Permission'] = request.permission
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkInterfacePermission',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateNetworkInterfacePermissionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_interface_permission(
        self,
        request: ecs_20140526_models.CreateNetworkInterfacePermissionRequest,
    ) -> ecs_20140526_models.CreateNetworkInterfacePermissionResponse:
        """
        @summary Grants a permission on an elastic network interface (ENI) to an Alibaba Cloud partner (a certified ISV) or an individual user.
        
        @description Before you call this operation, submit a ticket to apply for using this operation.
        
        @param request: CreateNetworkInterfacePermissionRequest
        @return: CreateNetworkInterfacePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_network_interface_permission_with_options(request, runtime)

    async def create_network_interface_permission_async(
        self,
        request: ecs_20140526_models.CreateNetworkInterfacePermissionRequest,
    ) -> ecs_20140526_models.CreateNetworkInterfacePermissionResponse:
        """
        @summary Grants a permission on an elastic network interface (ENI) to an Alibaba Cloud partner (a certified ISV) or an individual user.
        
        @description Before you call this operation, submit a ticket to apply for using this operation.
        
        @param request: CreateNetworkInterfacePermissionRequest
        @return: CreateNetworkInterfacePermissionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_network_interface_permission_with_options_async(request, runtime)

    def create_physical_connection_with_options(
        self,
        request: ecs_20140526_models.CreatePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreatePhysicalConnectionResponse:
        """
        @deprecated OpenAPI CreatePhysicalConnection is deprecated, please use Vpc::2016-04-28::CreatePhysicalConnection instead.
        
        @summary CreatePhysicalConnection
        
        @param request: CreatePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.bandwidth):
            query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreatePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_with_options_async(
        self,
        request: ecs_20140526_models.CreatePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreatePhysicalConnectionResponse:
        """
        @deprecated OpenAPI CreatePhysicalConnection is deprecated, please use Vpc::2016-04-28::CreatePhysicalConnection instead.
        
        @summary CreatePhysicalConnection
        
        @param request: CreatePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.bandwidth):
            query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreatePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection(
        self,
        request: ecs_20140526_models.CreatePhysicalConnectionRequest,
    ) -> ecs_20140526_models.CreatePhysicalConnectionResponse:
        """
        @deprecated OpenAPI CreatePhysicalConnection is deprecated, please use Vpc::2016-04-28::CreatePhysicalConnection instead.
        
        @summary CreatePhysicalConnection
        
        @param request: CreatePhysicalConnectionRequest
        @return: CreatePhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_with_options(request, runtime)

    async def create_physical_connection_async(
        self,
        request: ecs_20140526_models.CreatePhysicalConnectionRequest,
    ) -> ecs_20140526_models.CreatePhysicalConnectionResponse:
        """
        @deprecated OpenAPI CreatePhysicalConnection is deprecated, please use Vpc::2016-04-28::CreatePhysicalConnection instead.
        
        @summary CreatePhysicalConnection
        
        @param request: CreatePhysicalConnectionRequest
        @return: CreatePhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_with_options_async(request, runtime)

    def create_port_range_list_with_options(
        self,
        request: ecs_20140526_models.CreatePortRangeListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreatePortRangeListResponse:
        """
        @summary Creates a port list. You can associate a port list with resources, such as security groups.
        
        @param request: CreatePortRangeListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePortRangeListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.entry):
            query['Entry'] = request.entry
        if not UtilClient.is_unset(request.max_entries):
            query['MaxEntries'] = request.max_entries
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_range_list_name):
            query['PortRangeListName'] = request.port_range_list_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePortRangeList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreatePortRangeListResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_port_range_list_with_options_async(
        self,
        request: ecs_20140526_models.CreatePortRangeListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreatePortRangeListResponse:
        """
        @summary Creates a port list. You can associate a port list with resources, such as security groups.
        
        @param request: CreatePortRangeListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePortRangeListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.entry):
            query['Entry'] = request.entry
        if not UtilClient.is_unset(request.max_entries):
            query['MaxEntries'] = request.max_entries
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_range_list_name):
            query['PortRangeListName'] = request.port_range_list_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePortRangeList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreatePortRangeListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_port_range_list(
        self,
        request: ecs_20140526_models.CreatePortRangeListRequest,
    ) -> ecs_20140526_models.CreatePortRangeListResponse:
        """
        @summary Creates a port list. You can associate a port list with resources, such as security groups.
        
        @param request: CreatePortRangeListRequest
        @return: CreatePortRangeListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_port_range_list_with_options(request, runtime)

    async def create_port_range_list_async(
        self,
        request: ecs_20140526_models.CreatePortRangeListRequest,
    ) -> ecs_20140526_models.CreatePortRangeListResponse:
        """
        @summary Creates a port list. You can associate a port list with resources, such as security groups.
        
        @param request: CreatePortRangeListRequest
        @return: CreatePortRangeListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_port_range_list_with_options_async(request, runtime)

    def create_prefix_list_with_options(
        self,
        request: ecs_20140526_models.CreatePrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreatePrefixListResponse:
        """
        @summary Creates a prefix list.
        
        @description ## [](#)Usage notes
        A prefix list is a collection of network prefixes (CIDR blocks) and can be referenced to configure network rules for other resources. For more information, see [Overview](https://help.aliyun.com/document_detail/206223.html).
        When you create a prefix list, take note of the following items:
        You must specify an IP address family (IPv4 or IPv6) for the prefix list, and cannot change the IP address family after the prefix list is created. You cannot combine IPv4 and IPv6 CIDR blocks in a single prefix list.
        You must specify the maximum number of entries that the prefix list can contain. You cannot modify the maximum number of entries after the prefix list is created.
        You can specify entries for the prefix list. Each entry consists of a CIDR block and the description for the CIDR block. The total number of entries cannot exceed the maximum number of entries that you specified.
        For more information about the limits on prefix lists and other resources, see [Limits](https://help.aliyun.com/document_detail/25412.html).
        You can create Resource Access Management (RAM) users and grant them minimum permissions. This eliminates the need to share the AccessKey pair of your Alibaba Cloud account with other users and reduces security risks for your enterprises. For information about how to grant permissions on prefix lists to RAM users, see [Grant a RAM user permissions on prefix lists](https://help.aliyun.com/document_detail/206175.html)
        
        @param request: CreatePrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.address_family):
            query['AddressFamily'] = request.address_family
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.entry):
            query['Entry'] = request.entry
        if not UtilClient.is_unset(request.max_entries):
            query['MaxEntries'] = request.max_entries
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_name):
            query['PrefixListName'] = request.prefix_list_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePrefixList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreatePrefixListResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_prefix_list_with_options_async(
        self,
        request: ecs_20140526_models.CreatePrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreatePrefixListResponse:
        """
        @summary Creates a prefix list.
        
        @description ## [](#)Usage notes
        A prefix list is a collection of network prefixes (CIDR blocks) and can be referenced to configure network rules for other resources. For more information, see [Overview](https://help.aliyun.com/document_detail/206223.html).
        When you create a prefix list, take note of the following items:
        You must specify an IP address family (IPv4 or IPv6) for the prefix list, and cannot change the IP address family after the prefix list is created. You cannot combine IPv4 and IPv6 CIDR blocks in a single prefix list.
        You must specify the maximum number of entries that the prefix list can contain. You cannot modify the maximum number of entries after the prefix list is created.
        You can specify entries for the prefix list. Each entry consists of a CIDR block and the description for the CIDR block. The total number of entries cannot exceed the maximum number of entries that you specified.
        For more information about the limits on prefix lists and other resources, see [Limits](https://help.aliyun.com/document_detail/25412.html).
        You can create Resource Access Management (RAM) users and grant them minimum permissions. This eliminates the need to share the AccessKey pair of your Alibaba Cloud account with other users and reduces security risks for your enterprises. For information about how to grant permissions on prefix lists to RAM users, see [Grant a RAM user permissions on prefix lists](https://help.aliyun.com/document_detail/206175.html)
        
        @param request: CreatePrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.address_family):
            query['AddressFamily'] = request.address_family
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.entry):
            query['Entry'] = request.entry
        if not UtilClient.is_unset(request.max_entries):
            query['MaxEntries'] = request.max_entries
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_name):
            query['PrefixListName'] = request.prefix_list_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePrefixList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreatePrefixListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_prefix_list(
        self,
        request: ecs_20140526_models.CreatePrefixListRequest,
    ) -> ecs_20140526_models.CreatePrefixListResponse:
        """
        @summary Creates a prefix list.
        
        @description ## [](#)Usage notes
        A prefix list is a collection of network prefixes (CIDR blocks) and can be referenced to configure network rules for other resources. For more information, see [Overview](https://help.aliyun.com/document_detail/206223.html).
        When you create a prefix list, take note of the following items:
        You must specify an IP address family (IPv4 or IPv6) for the prefix list, and cannot change the IP address family after the prefix list is created. You cannot combine IPv4 and IPv6 CIDR blocks in a single prefix list.
        You must specify the maximum number of entries that the prefix list can contain. You cannot modify the maximum number of entries after the prefix list is created.
        You can specify entries for the prefix list. Each entry consists of a CIDR block and the description for the CIDR block. The total number of entries cannot exceed the maximum number of entries that you specified.
        For more information about the limits on prefix lists and other resources, see [Limits](https://help.aliyun.com/document_detail/25412.html).
        You can create Resource Access Management (RAM) users and grant them minimum permissions. This eliminates the need to share the AccessKey pair of your Alibaba Cloud account with other users and reduces security risks for your enterprises. For information about how to grant permissions on prefix lists to RAM users, see [Grant a RAM user permissions on prefix lists](https://help.aliyun.com/document_detail/206175.html)
        
        @param request: CreatePrefixListRequest
        @return: CreatePrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_prefix_list_with_options(request, runtime)

    async def create_prefix_list_async(
        self,
        request: ecs_20140526_models.CreatePrefixListRequest,
    ) -> ecs_20140526_models.CreatePrefixListResponse:
        """
        @summary Creates a prefix list.
        
        @description ## [](#)Usage notes
        A prefix list is a collection of network prefixes (CIDR blocks) and can be referenced to configure network rules for other resources. For more information, see [Overview](https://help.aliyun.com/document_detail/206223.html).
        When you create a prefix list, take note of the following items:
        You must specify an IP address family (IPv4 or IPv6) for the prefix list, and cannot change the IP address family after the prefix list is created. You cannot combine IPv4 and IPv6 CIDR blocks in a single prefix list.
        You must specify the maximum number of entries that the prefix list can contain. You cannot modify the maximum number of entries after the prefix list is created.
        You can specify entries for the prefix list. Each entry consists of a CIDR block and the description for the CIDR block. The total number of entries cannot exceed the maximum number of entries that you specified.
        For more information about the limits on prefix lists and other resources, see [Limits](https://help.aliyun.com/document_detail/25412.html).
        You can create Resource Access Management (RAM) users and grant them minimum permissions. This eliminates the need to share the AccessKey pair of your Alibaba Cloud account with other users and reduces security risks for your enterprises. For information about how to grant permissions on prefix lists to RAM users, see [Grant a RAM user permissions on prefix lists](https://help.aliyun.com/document_detail/206175.html)
        
        @param request: CreatePrefixListRequest
        @return: CreatePrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_prefix_list_with_options_async(request, runtime)

    def create_route_entry_with_options(
        self,
        request: ecs_20140526_models.CreateRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateRouteEntryResponse:
        """
        @deprecated OpenAPI CreateRouteEntry is deprecated, please use Vpc::2016-04-28::CreateRouteEntry instead.
        
        @summary CreateRouteEntry
        
        @param request: CreateRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouteEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_route_entry_with_options_async(
        self,
        request: ecs_20140526_models.CreateRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateRouteEntryResponse:
        """
        @deprecated OpenAPI CreateRouteEntry is deprecated, please use Vpc::2016-04-28::CreateRouteEntry instead.
        
        @summary CreateRouteEntry
        
        @param request: CreateRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouteEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_route_entry(
        self,
        request: ecs_20140526_models.CreateRouteEntryRequest,
    ) -> ecs_20140526_models.CreateRouteEntryResponse:
        """
        @deprecated OpenAPI CreateRouteEntry is deprecated, please use Vpc::2016-04-28::CreateRouteEntry instead.
        
        @summary CreateRouteEntry
        
        @param request: CreateRouteEntryRequest
        @return: CreateRouteEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_route_entry_with_options(request, runtime)

    async def create_route_entry_async(
        self,
        request: ecs_20140526_models.CreateRouteEntryRequest,
    ) -> ecs_20140526_models.CreateRouteEntryResponse:
        """
        @deprecated OpenAPI CreateRouteEntry is deprecated, please use Vpc::2016-04-28::CreateRouteEntry instead.
        
        @summary CreateRouteEntry
        
        @param request: CreateRouteEntryRequest
        @return: CreateRouteEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_route_entry_with_options_async(request, runtime)

    def create_router_interface_with_options(
        self,
        request: ecs_20140526_models.CreateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateRouterInterfaceResponse:
        """
        @deprecated OpenAPI CreateRouterInterface is deprecated, please use Vpc::2016-04-28::CreateRouterInterface instead.
        
        @summary CreateRouterInterface
        
        @param request: CreateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.health_check_source_ip):
            query['HealthCheckSourceIp'] = request.health_check_source_ip
        if not UtilClient.is_unset(request.health_check_target_ip):
            query['HealthCheckTargetIp'] = request.health_check_target_ip
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.opposite_access_point_id):
            query['OppositeAccessPointId'] = request.opposite_access_point_id
        if not UtilClient.is_unset(request.opposite_interface_id):
            query['OppositeInterfaceId'] = request.opposite_interface_id
        if not UtilClient.is_unset(request.opposite_interface_owner_id):
            query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        if not UtilClient.is_unset(request.opposite_region_id):
            query['OppositeRegionId'] = request.opposite_region_id
        if not UtilClient.is_unset(request.opposite_router_id):
            query['OppositeRouterId'] = request.opposite_router_id
        if not UtilClient.is_unset(request.opposite_router_type):
            query['OppositeRouterType'] = request.opposite_router_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role):
            query['Role'] = request.role
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_router_interface_with_options_async(
        self,
        request: ecs_20140526_models.CreateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateRouterInterfaceResponse:
        """
        @deprecated OpenAPI CreateRouterInterface is deprecated, please use Vpc::2016-04-28::CreateRouterInterface instead.
        
        @summary CreateRouterInterface
        
        @param request: CreateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.health_check_source_ip):
            query['HealthCheckSourceIp'] = request.health_check_source_ip
        if not UtilClient.is_unset(request.health_check_target_ip):
            query['HealthCheckTargetIp'] = request.health_check_target_ip
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.opposite_access_point_id):
            query['OppositeAccessPointId'] = request.opposite_access_point_id
        if not UtilClient.is_unset(request.opposite_interface_id):
            query['OppositeInterfaceId'] = request.opposite_interface_id
        if not UtilClient.is_unset(request.opposite_interface_owner_id):
            query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        if not UtilClient.is_unset(request.opposite_region_id):
            query['OppositeRegionId'] = request.opposite_region_id
        if not UtilClient.is_unset(request.opposite_router_id):
            query['OppositeRouterId'] = request.opposite_router_id
        if not UtilClient.is_unset(request.opposite_router_type):
            query['OppositeRouterType'] = request.opposite_router_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role):
            query['Role'] = request.role
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_router_interface(
        self,
        request: ecs_20140526_models.CreateRouterInterfaceRequest,
    ) -> ecs_20140526_models.CreateRouterInterfaceResponse:
        """
        @deprecated OpenAPI CreateRouterInterface is deprecated, please use Vpc::2016-04-28::CreateRouterInterface instead.
        
        @summary CreateRouterInterface
        
        @param request: CreateRouterInterfaceRequest
        @return: CreateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_router_interface_with_options(request, runtime)

    async def create_router_interface_async(
        self,
        request: ecs_20140526_models.CreateRouterInterfaceRequest,
    ) -> ecs_20140526_models.CreateRouterInterfaceResponse:
        """
        @deprecated OpenAPI CreateRouterInterface is deprecated, please use Vpc::2016-04-28::CreateRouterInterface instead.
        
        @summary CreateRouterInterface
        
        @param request: CreateRouterInterfaceRequest
        @return: CreateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_router_interface_with_options_async(request, runtime)

    def create_savings_plan_with_options(
        self,
        request: ecs_20140526_models.CreateSavingsPlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSavingsPlanResponse:
        """
        @summary 购买节省计划并预付费换购按量付费
        
        @param request: CreateSavingsPlanRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSavingsPlanResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.committed_amount):
            query['CommittedAmount'] = request.committed_amount
        if not UtilClient.is_unset(request.instance_type_family):
            query['InstanceTypeFamily'] = request.instance_type_family
        if not UtilClient.is_unset(request.instance_type_family_group):
            query['InstanceTypeFamilyGroup'] = request.instance_type_family_group
        if not UtilClient.is_unset(request.offering_type):
            query['OfferingType'] = request.offering_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.plan_type):
            query['PlanType'] = request.plan_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSavingsPlan',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSavingsPlanResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_savings_plan_with_options_async(
        self,
        request: ecs_20140526_models.CreateSavingsPlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSavingsPlanResponse:
        """
        @summary 购买节省计划并预付费换购按量付费
        
        @param request: CreateSavingsPlanRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSavingsPlanResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.committed_amount):
            query['CommittedAmount'] = request.committed_amount
        if not UtilClient.is_unset(request.instance_type_family):
            query['InstanceTypeFamily'] = request.instance_type_family
        if not UtilClient.is_unset(request.instance_type_family_group):
            query['InstanceTypeFamilyGroup'] = request.instance_type_family_group
        if not UtilClient.is_unset(request.offering_type):
            query['OfferingType'] = request.offering_type
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.plan_type):
            query['PlanType'] = request.plan_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSavingsPlan',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSavingsPlanResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_savings_plan(
        self,
        request: ecs_20140526_models.CreateSavingsPlanRequest,
    ) -> ecs_20140526_models.CreateSavingsPlanResponse:
        """
        @summary 购买节省计划并预付费换购按量付费
        
        @param request: CreateSavingsPlanRequest
        @return: CreateSavingsPlanResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_savings_plan_with_options(request, runtime)

    async def create_savings_plan_async(
        self,
        request: ecs_20140526_models.CreateSavingsPlanRequest,
    ) -> ecs_20140526_models.CreateSavingsPlanResponse:
        """
        @summary 购买节省计划并预付费换购按量付费
        
        @param request: CreateSavingsPlanRequest
        @return: CreateSavingsPlanResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_savings_plan_with_options_async(request, runtime)

    def create_security_group_with_options(
        self,
        request: ecs_20140526_models.CreateSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSecurityGroupResponse:
        """
        @summary Creates a security group.
        
        @description    By default, the internal access control policy (InnerAccessPolicy) of the basic security group that you create by calling this operation is internal interconnectivity (**Accept**). You can call the [ModifySecurityGroupPolicy](https://help.aliyun.com/document_detail/2679846.html) operation to change the value of InnerAccessPolicy for the basic security group.
        By default, the internal access control policy (InnerAccessPolicy) of the advanced security group that you create by calling this operation is internal isolation (**Drop**). The InnerAccessPolicy value of the advanced security group cannot be changed.
        You can create a limited number of security groups per region. You can create at least 100 security groups per region. For more information, see the [Security group limits](~~25412#SecurityGroupQuota1~~) section in the "Limits" topic.
        To create a security group of the Virtual Private Cloud (VPC) type, you must specify VpcId.
        
        @param request: CreateSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_name):
            query['SecurityGroupName'] = request.security_group_name
        if not UtilClient.is_unset(request.security_group_type):
            query['SecurityGroupType'] = request.security_group_type
        if not UtilClient.is_unset(request.service_managed):
            query['ServiceManaged'] = request.service_managed
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_security_group_with_options_async(
        self,
        request: ecs_20140526_models.CreateSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSecurityGroupResponse:
        """
        @summary Creates a security group.
        
        @description    By default, the internal access control policy (InnerAccessPolicy) of the basic security group that you create by calling this operation is internal interconnectivity (**Accept**). You can call the [ModifySecurityGroupPolicy](https://help.aliyun.com/document_detail/2679846.html) operation to change the value of InnerAccessPolicy for the basic security group.
        By default, the internal access control policy (InnerAccessPolicy) of the advanced security group that you create by calling this operation is internal isolation (**Drop**). The InnerAccessPolicy value of the advanced security group cannot be changed.
        You can create a limited number of security groups per region. You can create at least 100 security groups per region. For more information, see the [Security group limits](~~25412#SecurityGroupQuota1~~) section in the "Limits" topic.
        To create a security group of the Virtual Private Cloud (VPC) type, you must specify VpcId.
        
        @param request: CreateSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_name):
            query['SecurityGroupName'] = request.security_group_name
        if not UtilClient.is_unset(request.security_group_type):
            query['SecurityGroupType'] = request.security_group_type
        if not UtilClient.is_unset(request.service_managed):
            query['ServiceManaged'] = request.service_managed
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_security_group(
        self,
        request: ecs_20140526_models.CreateSecurityGroupRequest,
    ) -> ecs_20140526_models.CreateSecurityGroupResponse:
        """
        @summary Creates a security group.
        
        @description    By default, the internal access control policy (InnerAccessPolicy) of the basic security group that you create by calling this operation is internal interconnectivity (**Accept**). You can call the [ModifySecurityGroupPolicy](https://help.aliyun.com/document_detail/2679846.html) operation to change the value of InnerAccessPolicy for the basic security group.
        By default, the internal access control policy (InnerAccessPolicy) of the advanced security group that you create by calling this operation is internal isolation (**Drop**). The InnerAccessPolicy value of the advanced security group cannot be changed.
        You can create a limited number of security groups per region. You can create at least 100 security groups per region. For more information, see the [Security group limits](~~25412#SecurityGroupQuota1~~) section in the "Limits" topic.
        To create a security group of the Virtual Private Cloud (VPC) type, you must specify VpcId.
        
        @param request: CreateSecurityGroupRequest
        @return: CreateSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_security_group_with_options(request, runtime)

    async def create_security_group_async(
        self,
        request: ecs_20140526_models.CreateSecurityGroupRequest,
    ) -> ecs_20140526_models.CreateSecurityGroupResponse:
        """
        @summary Creates a security group.
        
        @description    By default, the internal access control policy (InnerAccessPolicy) of the basic security group that you create by calling this operation is internal interconnectivity (**Accept**). You can call the [ModifySecurityGroupPolicy](https://help.aliyun.com/document_detail/2679846.html) operation to change the value of InnerAccessPolicy for the basic security group.
        By default, the internal access control policy (InnerAccessPolicy) of the advanced security group that you create by calling this operation is internal isolation (**Drop**). The InnerAccessPolicy value of the advanced security group cannot be changed.
        You can create a limited number of security groups per region. You can create at least 100 security groups per region. For more information, see the [Security group limits](~~25412#SecurityGroupQuota1~~) section in the "Limits" topic.
        To create a security group of the Virtual Private Cloud (VPC) type, you must specify VpcId.
        
        @param request: CreateSecurityGroupRequest
        @return: CreateSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_security_group_with_options_async(request, runtime)

    def create_simulated_system_events_with_options(
        self,
        request: ecs_20140526_models.CreateSimulatedSystemEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSimulatedSystemEventsResponse:
        """
        @summary Schedules simulated system events of Elastic Compute Service (ECS) instances. The simulated system events do not actually occur on or affect ECS instances.
        
        @description You can use the ECS console, call [ECS API](https://help.aliyun.com/document_detail/63962.html) operations, or use CloudMonitor to view the scheduled simulated system events.
        The following descriptions provide the lifecycle of a simulated system event:
        Scheduled: The state of the simulated system event is automatically changed to Scheduled after it is scheduled.
        Executed: The state of the simulated system event is automatically changed to Executed at the time specified by the NotBefore parameter if no manual intervention is involved.
        Canceled: The state of the simulated system event is changed to Canceled if you cancel the event by calling the [CancelSimulatedSystemEvents](https://help.aliyun.com/document_detail/88808.html) operation.
        Avoided: The state of the simulated system event generated from maintenance-triggered instance restart can be changed to Avoided if you restart the instance before the scheduled time of the simulated system event. The maintenance-triggered instance restart is indicated by the SystemMaintenance.Reboot value. For more information, see [RebootInstance](https://help.aliyun.com/document_detail/25502.html).
        
        @param request: CreateSimulatedSystemEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSimulatedSystemEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.not_before):
            query['NotBefore'] = request.not_before
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSimulatedSystemEvents',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSimulatedSystemEventsResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_simulated_system_events_with_options_async(
        self,
        request: ecs_20140526_models.CreateSimulatedSystemEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSimulatedSystemEventsResponse:
        """
        @summary Schedules simulated system events of Elastic Compute Service (ECS) instances. The simulated system events do not actually occur on or affect ECS instances.
        
        @description You can use the ECS console, call [ECS API](https://help.aliyun.com/document_detail/63962.html) operations, or use CloudMonitor to view the scheduled simulated system events.
        The following descriptions provide the lifecycle of a simulated system event:
        Scheduled: The state of the simulated system event is automatically changed to Scheduled after it is scheduled.
        Executed: The state of the simulated system event is automatically changed to Executed at the time specified by the NotBefore parameter if no manual intervention is involved.
        Canceled: The state of the simulated system event is changed to Canceled if you cancel the event by calling the [CancelSimulatedSystemEvents](https://help.aliyun.com/document_detail/88808.html) operation.
        Avoided: The state of the simulated system event generated from maintenance-triggered instance restart can be changed to Avoided if you restart the instance before the scheduled time of the simulated system event. The maintenance-triggered instance restart is indicated by the SystemMaintenance.Reboot value. For more information, see [RebootInstance](https://help.aliyun.com/document_detail/25502.html).
        
        @param request: CreateSimulatedSystemEventsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSimulatedSystemEventsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.not_before):
            query['NotBefore'] = request.not_before
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSimulatedSystemEvents',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSimulatedSystemEventsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_simulated_system_events(
        self,
        request: ecs_20140526_models.CreateSimulatedSystemEventsRequest,
    ) -> ecs_20140526_models.CreateSimulatedSystemEventsResponse:
        """
        @summary Schedules simulated system events of Elastic Compute Service (ECS) instances. The simulated system events do not actually occur on or affect ECS instances.
        
        @description You can use the ECS console, call [ECS API](https://help.aliyun.com/document_detail/63962.html) operations, or use CloudMonitor to view the scheduled simulated system events.
        The following descriptions provide the lifecycle of a simulated system event:
        Scheduled: The state of the simulated system event is automatically changed to Scheduled after it is scheduled.
        Executed: The state of the simulated system event is automatically changed to Executed at the time specified by the NotBefore parameter if no manual intervention is involved.
        Canceled: The state of the simulated system event is changed to Canceled if you cancel the event by calling the [CancelSimulatedSystemEvents](https://help.aliyun.com/document_detail/88808.html) operation.
        Avoided: The state of the simulated system event generated from maintenance-triggered instance restart can be changed to Avoided if you restart the instance before the scheduled time of the simulated system event. The maintenance-triggered instance restart is indicated by the SystemMaintenance.Reboot value. For more information, see [RebootInstance](https://help.aliyun.com/document_detail/25502.html).
        
        @param request: CreateSimulatedSystemEventsRequest
        @return: CreateSimulatedSystemEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_simulated_system_events_with_options(request, runtime)

    async def create_simulated_system_events_async(
        self,
        request: ecs_20140526_models.CreateSimulatedSystemEventsRequest,
    ) -> ecs_20140526_models.CreateSimulatedSystemEventsResponse:
        """
        @summary Schedules simulated system events of Elastic Compute Service (ECS) instances. The simulated system events do not actually occur on or affect ECS instances.
        
        @description You can use the ECS console, call [ECS API](https://help.aliyun.com/document_detail/63962.html) operations, or use CloudMonitor to view the scheduled simulated system events.
        The following descriptions provide the lifecycle of a simulated system event:
        Scheduled: The state of the simulated system event is automatically changed to Scheduled after it is scheduled.
        Executed: The state of the simulated system event is automatically changed to Executed at the time specified by the NotBefore parameter if no manual intervention is involved.
        Canceled: The state of the simulated system event is changed to Canceled if you cancel the event by calling the [CancelSimulatedSystemEvents](https://help.aliyun.com/document_detail/88808.html) operation.
        Avoided: The state of the simulated system event generated from maintenance-triggered instance restart can be changed to Avoided if you restart the instance before the scheduled time of the simulated system event. The maintenance-triggered instance restart is indicated by the SystemMaintenance.Reboot value. For more information, see [RebootInstance](https://help.aliyun.com/document_detail/25502.html).
        
        @param request: CreateSimulatedSystemEventsRequest
        @return: CreateSimulatedSystemEventsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_simulated_system_events_with_options_async(request, runtime)

    def create_snapshot_with_options(
        self,
        request: ecs_20140526_models.CreateSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSnapshotResponse:
        """
        @summary Creates a snapshot for a cloud disk.
        
        @description The local snapshot feature is replaced by the instant access feature. Take note of the following items:
        If you have used the local snapshot feature before December 14, 2020, you can use `Category`.
        If you have not used the local snapshot feature before December 14, 2020, new snapshots of your Enterprise SSD (ESSD) series disks are instantly available after creation without the need for additional configurations, regardless of whether the snapshots are manually or automatically created. ESSD-series disks include ESSDs, ESSD AutoPL disks, ESSD Entry disks, and Regional ESSDs. InstantAccess, InstantAccessRetentionDays, and DisableInstantAccess that are related to the instant access feature no longer take effect in API operations. Available is added to the DescribeSnapshots and DescribeSnapshotGroups operations to indicate whether snapshots are available.
        Prerequisites:
        Elastic Compute Service (ECS) Snapshot is activated. For more information, see [Activate ECS Snapshot](https://help.aliyun.com/document_detail/108381.html).
        The disk for which you want to create a snapshot is in the **In_use** or **Available** state. Take note of the following items:
        If the disk is in the **In_use** state, make sure that the ECS instance to which the disk is attached is in the **Running** or **Stopped** state.
        If the disk is in the **Available** state, make sure that the disk was attached to an ECS instance. Snapshots cannot be created for disks that have never been attached to an ECS instance.
        When you use a disk to create a dynamic extended volume or a RAID array, we recommend that you create a snapshot-consistent group and enable the application-consistent snapshot feature to back up data. When a business system involves multiple disks, you can create a snapshot-consistent group to ensure a consistent write order and the crash consistency of business system data. For more information, see [Create a snapshot-consistent group](https://help.aliyun.com/document_detail/199625.html) and [Create application-consistent snapshots](https://help.aliyun.com/document_detail/208589.html).
        When you create a snapshot, take note of the following items:
        We recommend that you create snapshots during off-peak hours because snapshot creation degrades disk I/O performance by up to 10% and slows down data reads and writes.
        If a snapshot is being created, you cannot use this snapshot to create a custom image by calling the [CreateImage](https://help.aliyun.com/document_detail/25535.html) operation.
        If operations are performed on the disk and incremental data is generated when a snapshot is being created, the incremental data is not included in the snapshot.
        When a snapshot is being created for a disk that is attached to an ECS instance, do not perform operations that change the status of the instance, such as stopping or restarting the instance. Otherwise, the snapshot may fail to be created.
        You cannot resize a disk for which a snapshot is being created. Wait until the snapshot is created before you resize the disk.
        You can create snapshots for a disk that is in the **Expired** (`Expired`) state. If the release time scheduled for a disk arrives while a snapshot is being created for the disk, the snapshot is in the **Creating** (`Creating`) state and is deleted when the disk is released.
        After you create snapshots, you are charged snapshot storage fees per region based on the total size of the snapshots that are stored in the region. For more information, see [Snapshots](https://help.aliyun.com/document_detail/56159.html).
        In the following scenarios, you cannot create snapshots for a disk:
        The number of manual snapshots of the disk has reached 256.
        A snapshot is being created for the disk.
        If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query information about an ECS instance, the instance is locked for security reasons and no operations are allowed on the instance.
        
        @param request: CreateSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.instant_access):
            query['InstantAccess'] = request.instant_access
        if not UtilClient.is_unset(request.instant_access_retention_days):
            query['InstantAccessRetentionDays'] = request.instant_access_retention_days
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSnapshotResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_snapshot_with_options_async(
        self,
        request: ecs_20140526_models.CreateSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSnapshotResponse:
        """
        @summary Creates a snapshot for a cloud disk.
        
        @description The local snapshot feature is replaced by the instant access feature. Take note of the following items:
        If you have used the local snapshot feature before December 14, 2020, you can use `Category`.
        If you have not used the local snapshot feature before December 14, 2020, new snapshots of your Enterprise SSD (ESSD) series disks are instantly available after creation without the need for additional configurations, regardless of whether the snapshots are manually or automatically created. ESSD-series disks include ESSDs, ESSD AutoPL disks, ESSD Entry disks, and Regional ESSDs. InstantAccess, InstantAccessRetentionDays, and DisableInstantAccess that are related to the instant access feature no longer take effect in API operations. Available is added to the DescribeSnapshots and DescribeSnapshotGroups operations to indicate whether snapshots are available.
        Prerequisites:
        Elastic Compute Service (ECS) Snapshot is activated. For more information, see [Activate ECS Snapshot](https://help.aliyun.com/document_detail/108381.html).
        The disk for which you want to create a snapshot is in the **In_use** or **Available** state. Take note of the following items:
        If the disk is in the **In_use** state, make sure that the ECS instance to which the disk is attached is in the **Running** or **Stopped** state.
        If the disk is in the **Available** state, make sure that the disk was attached to an ECS instance. Snapshots cannot be created for disks that have never been attached to an ECS instance.
        When you use a disk to create a dynamic extended volume or a RAID array, we recommend that you create a snapshot-consistent group and enable the application-consistent snapshot feature to back up data. When a business system involves multiple disks, you can create a snapshot-consistent group to ensure a consistent write order and the crash consistency of business system data. For more information, see [Create a snapshot-consistent group](https://help.aliyun.com/document_detail/199625.html) and [Create application-consistent snapshots](https://help.aliyun.com/document_detail/208589.html).
        When you create a snapshot, take note of the following items:
        We recommend that you create snapshots during off-peak hours because snapshot creation degrades disk I/O performance by up to 10% and slows down data reads and writes.
        If a snapshot is being created, you cannot use this snapshot to create a custom image by calling the [CreateImage](https://help.aliyun.com/document_detail/25535.html) operation.
        If operations are performed on the disk and incremental data is generated when a snapshot is being created, the incremental data is not included in the snapshot.
        When a snapshot is being created for a disk that is attached to an ECS instance, do not perform operations that change the status of the instance, such as stopping or restarting the instance. Otherwise, the snapshot may fail to be created.
        You cannot resize a disk for which a snapshot is being created. Wait until the snapshot is created before you resize the disk.
        You can create snapshots for a disk that is in the **Expired** (`Expired`) state. If the release time scheduled for a disk arrives while a snapshot is being created for the disk, the snapshot is in the **Creating** (`Creating`) state and is deleted when the disk is released.
        After you create snapshots, you are charged snapshot storage fees per region based on the total size of the snapshots that are stored in the region. For more information, see [Snapshots](https://help.aliyun.com/document_detail/56159.html).
        In the following scenarios, you cannot create snapshots for a disk:
        The number of manual snapshots of the disk has reached 256.
        A snapshot is being created for the disk.
        If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query information about an ECS instance, the instance is locked for security reasons and no operations are allowed on the instance.
        
        @param request: CreateSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category):
            query['Category'] = request.category
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.instant_access):
            query['InstantAccess'] = request.instant_access
        if not UtilClient.is_unset(request.instant_access_retention_days):
            query['InstantAccessRetentionDays'] = request.instant_access_retention_days
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.retention_days):
            query['RetentionDays'] = request.retention_days
        if not UtilClient.is_unset(request.snapshot_name):
            query['SnapshotName'] = request.snapshot_name
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSnapshotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_snapshot(
        self,
        request: ecs_20140526_models.CreateSnapshotRequest,
    ) -> ecs_20140526_models.CreateSnapshotResponse:
        """
        @summary Creates a snapshot for a cloud disk.
        
        @description The local snapshot feature is replaced by the instant access feature. Take note of the following items:
        If you have used the local snapshot feature before December 14, 2020, you can use `Category`.
        If you have not used the local snapshot feature before December 14, 2020, new snapshots of your Enterprise SSD (ESSD) series disks are instantly available after creation without the need for additional configurations, regardless of whether the snapshots are manually or automatically created. ESSD-series disks include ESSDs, ESSD AutoPL disks, ESSD Entry disks, and Regional ESSDs. InstantAccess, InstantAccessRetentionDays, and DisableInstantAccess that are related to the instant access feature no longer take effect in API operations. Available is added to the DescribeSnapshots and DescribeSnapshotGroups operations to indicate whether snapshots are available.
        Prerequisites:
        Elastic Compute Service (ECS) Snapshot is activated. For more information, see [Activate ECS Snapshot](https://help.aliyun.com/document_detail/108381.html).
        The disk for which you want to create a snapshot is in the **In_use** or **Available** state. Take note of the following items:
        If the disk is in the **In_use** state, make sure that the ECS instance to which the disk is attached is in the **Running** or **Stopped** state.
        If the disk is in the **Available** state, make sure that the disk was attached to an ECS instance. Snapshots cannot be created for disks that have never been attached to an ECS instance.
        When you use a disk to create a dynamic extended volume or a RAID array, we recommend that you create a snapshot-consistent group and enable the application-consistent snapshot feature to back up data. When a business system involves multiple disks, you can create a snapshot-consistent group to ensure a consistent write order and the crash consistency of business system data. For more information, see [Create a snapshot-consistent group](https://help.aliyun.com/document_detail/199625.html) and [Create application-consistent snapshots](https://help.aliyun.com/document_detail/208589.html).
        When you create a snapshot, take note of the following items:
        We recommend that you create snapshots during off-peak hours because snapshot creation degrades disk I/O performance by up to 10% and slows down data reads and writes.
        If a snapshot is being created, you cannot use this snapshot to create a custom image by calling the [CreateImage](https://help.aliyun.com/document_detail/25535.html) operation.
        If operations are performed on the disk and incremental data is generated when a snapshot is being created, the incremental data is not included in the snapshot.
        When a snapshot is being created for a disk that is attached to an ECS instance, do not perform operations that change the status of the instance, such as stopping or restarting the instance. Otherwise, the snapshot may fail to be created.
        You cannot resize a disk for which a snapshot is being created. Wait until the snapshot is created before you resize the disk.
        You can create snapshots for a disk that is in the **Expired** (`Expired`) state. If the release time scheduled for a disk arrives while a snapshot is being created for the disk, the snapshot is in the **Creating** (`Creating`) state and is deleted when the disk is released.
        After you create snapshots, you are charged snapshot storage fees per region based on the total size of the snapshots that are stored in the region. For more information, see [Snapshots](https://help.aliyun.com/document_detail/56159.html).
        In the following scenarios, you cannot create snapshots for a disk:
        The number of manual snapshots of the disk has reached 256.
        A snapshot is being created for the disk.
        If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query information about an ECS instance, the instance is locked for security reasons and no operations are allowed on the instance.
        
        @param request: CreateSnapshotRequest
        @return: CreateSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_snapshot_with_options(request, runtime)

    async def create_snapshot_async(
        self,
        request: ecs_20140526_models.CreateSnapshotRequest,
    ) -> ecs_20140526_models.CreateSnapshotResponse:
        """
        @summary Creates a snapshot for a cloud disk.
        
        @description The local snapshot feature is replaced by the instant access feature. Take note of the following items:
        If you have used the local snapshot feature before December 14, 2020, you can use `Category`.
        If you have not used the local snapshot feature before December 14, 2020, new snapshots of your Enterprise SSD (ESSD) series disks are instantly available after creation without the need for additional configurations, regardless of whether the snapshots are manually or automatically created. ESSD-series disks include ESSDs, ESSD AutoPL disks, ESSD Entry disks, and Regional ESSDs. InstantAccess, InstantAccessRetentionDays, and DisableInstantAccess that are related to the instant access feature no longer take effect in API operations. Available is added to the DescribeSnapshots and DescribeSnapshotGroups operations to indicate whether snapshots are available.
        Prerequisites:
        Elastic Compute Service (ECS) Snapshot is activated. For more information, see [Activate ECS Snapshot](https://help.aliyun.com/document_detail/108381.html).
        The disk for which you want to create a snapshot is in the **In_use** or **Available** state. Take note of the following items:
        If the disk is in the **In_use** state, make sure that the ECS instance to which the disk is attached is in the **Running** or **Stopped** state.
        If the disk is in the **Available** state, make sure that the disk was attached to an ECS instance. Snapshots cannot be created for disks that have never been attached to an ECS instance.
        When you use a disk to create a dynamic extended volume or a RAID array, we recommend that you create a snapshot-consistent group and enable the application-consistent snapshot feature to back up data. When a business system involves multiple disks, you can create a snapshot-consistent group to ensure a consistent write order and the crash consistency of business system data. For more information, see [Create a snapshot-consistent group](https://help.aliyun.com/document_detail/199625.html) and [Create application-consistent snapshots](https://help.aliyun.com/document_detail/208589.html).
        When you create a snapshot, take note of the following items:
        We recommend that you create snapshots during off-peak hours because snapshot creation degrades disk I/O performance by up to 10% and slows down data reads and writes.
        If a snapshot is being created, you cannot use this snapshot to create a custom image by calling the [CreateImage](https://help.aliyun.com/document_detail/25535.html) operation.
        If operations are performed on the disk and incremental data is generated when a snapshot is being created, the incremental data is not included in the snapshot.
        When a snapshot is being created for a disk that is attached to an ECS instance, do not perform operations that change the status of the instance, such as stopping or restarting the instance. Otherwise, the snapshot may fail to be created.
        You cannot resize a disk for which a snapshot is being created. Wait until the snapshot is created before you resize the disk.
        You can create snapshots for a disk that is in the **Expired** (`Expired`) state. If the release time scheduled for a disk arrives while a snapshot is being created for the disk, the snapshot is in the **Creating** (`Creating`) state and is deleted when the disk is released.
        After you create snapshots, you are charged snapshot storage fees per region based on the total size of the snapshots that are stored in the region. For more information, see [Snapshots](https://help.aliyun.com/document_detail/56159.html).
        In the following scenarios, you cannot create snapshots for a disk:
        The number of manual snapshots of the disk has reached 256.
        A snapshot is being created for the disk.
        If the response contains `{"OperationLocks": {"LockReason" : "security"}}` when you query information about an ECS instance, the instance is locked for security reasons and no operations are allowed on the instance.
        
        @param request: CreateSnapshotRequest
        @return: CreateSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_snapshot_with_options_async(request, runtime)

    def create_snapshot_group_with_options(
        self,
        request: ecs_20140526_models.CreateSnapshotGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSnapshotGroupResponse:
        """
        @summary Creates a snapshot-consistent group for the disks of an Elastic Compute Service (ECS) instance. A snapshot-consistent group contains snapshots of one or more disks.
        
        @description You can specify `InstanceId` to create a snapshot-consistent group for disks on a specific ECS instance. You can also specify `DiskId.N` to create a snapshot-consistent group for multiple disks on multiple ECS instances within the same zone.
        >  You cannot specify both `DiskId.N` and `ExcludeDiskId.N` in the same request. If you specify `InstanceId`, you can use `DiskId.N` to specify only disks on the specified ECS instance and cannot use DiskId.N to specify disks across ECS instances.
        Take note of the following items:
        The disks for which you want to create a snapshot must be in the **In Use** (`In_use`) or **Unattached** (`Available`) state.
        If a disk is in the **In Use** (`In_use`) state, make sure that the ECS instance to which the disk is attached is in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If a disk is in the **Unattached** (`Available`) state, make sure that the disk has been attached to ECS instances. Snapshots cannot be created for disks that have never been attached to an ECS instance.
        Snapshot-consistent groups can be used to create snapshots only for Enterprise SSDs (ESSDs), ESSD AutoPL disks, and ESSD Entry disks.
        A snapshot-consistent group can contain snapshots of up to 16 disks, including system disks and data disks, and cannot exceed 32 TiB in size.
        Snapshots that you created are stored indefinitely until you delete the snapshots. We recommend that you delete unnecessary snapshots on a regular basis to prevent excess snapshot storage fees.
        Snapshot-consistent groups cannot be created for disks for which multi-attach feature is enabled. If disks for which the multi-attach feature is enabled are attached to an ECS instance, you must specify the `ExcludeDiskId.N` parameter to exclude the disks.
        For more information about the snapshot-consistent group feature, see [Create a snapshot-consistent group](https://help.aliyun.com/document_detail/199625.html).
        
        @param request: CreateSnapshotGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.exclude_disk_id):
            query['ExcludeDiskId'] = request.exclude_disk_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instant_access):
            query['InstantAccess'] = request.instant_access
        if not UtilClient.is_unset(request.instant_access_retention_days):
            query['InstantAccessRetentionDays'] = request.instant_access_retention_days
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshotGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSnapshotGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_snapshot_group_with_options_async(
        self,
        request: ecs_20140526_models.CreateSnapshotGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateSnapshotGroupResponse:
        """
        @summary Creates a snapshot-consistent group for the disks of an Elastic Compute Service (ECS) instance. A snapshot-consistent group contains snapshots of one or more disks.
        
        @description You can specify `InstanceId` to create a snapshot-consistent group for disks on a specific ECS instance. You can also specify `DiskId.N` to create a snapshot-consistent group for multiple disks on multiple ECS instances within the same zone.
        >  You cannot specify both `DiskId.N` and `ExcludeDiskId.N` in the same request. If you specify `InstanceId`, you can use `DiskId.N` to specify only disks on the specified ECS instance and cannot use DiskId.N to specify disks across ECS instances.
        Take note of the following items:
        The disks for which you want to create a snapshot must be in the **In Use** (`In_use`) or **Unattached** (`Available`) state.
        If a disk is in the **In Use** (`In_use`) state, make sure that the ECS instance to which the disk is attached is in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If a disk is in the **Unattached** (`Available`) state, make sure that the disk has been attached to ECS instances. Snapshots cannot be created for disks that have never been attached to an ECS instance.
        Snapshot-consistent groups can be used to create snapshots only for Enterprise SSDs (ESSDs), ESSD AutoPL disks, and ESSD Entry disks.
        A snapshot-consistent group can contain snapshots of up to 16 disks, including system disks and data disks, and cannot exceed 32 TiB in size.
        Snapshots that you created are stored indefinitely until you delete the snapshots. We recommend that you delete unnecessary snapshots on a regular basis to prevent excess snapshot storage fees.
        Snapshot-consistent groups cannot be created for disks for which multi-attach feature is enabled. If disks for which the multi-attach feature is enabled are attached to an ECS instance, you must specify the `ExcludeDiskId.N` parameter to exclude the disks.
        For more information about the snapshot-consistent group feature, see [Create a snapshot-consistent group](https://help.aliyun.com/document_detail/199625.html).
        
        @param request: CreateSnapshotGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSnapshotGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.exclude_disk_id):
            query['ExcludeDiskId'] = request.exclude_disk_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instant_access):
            query['InstantAccess'] = request.instant_access
        if not UtilClient.is_unset(request.instant_access_retention_days):
            query['InstantAccessRetentionDays'] = request.instant_access_retention_days
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_location_arn):
            query['StorageLocationArn'] = request.storage_location_arn
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnapshotGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateSnapshotGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_snapshot_group(
        self,
        request: ecs_20140526_models.CreateSnapshotGroupRequest,
    ) -> ecs_20140526_models.CreateSnapshotGroupResponse:
        """
        @summary Creates a snapshot-consistent group for the disks of an Elastic Compute Service (ECS) instance. A snapshot-consistent group contains snapshots of one or more disks.
        
        @description You can specify `InstanceId` to create a snapshot-consistent group for disks on a specific ECS instance. You can also specify `DiskId.N` to create a snapshot-consistent group for multiple disks on multiple ECS instances within the same zone.
        >  You cannot specify both `DiskId.N` and `ExcludeDiskId.N` in the same request. If you specify `InstanceId`, you can use `DiskId.N` to specify only disks on the specified ECS instance and cannot use DiskId.N to specify disks across ECS instances.
        Take note of the following items:
        The disks for which you want to create a snapshot must be in the **In Use** (`In_use`) or **Unattached** (`Available`) state.
        If a disk is in the **In Use** (`In_use`) state, make sure that the ECS instance to which the disk is attached is in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If a disk is in the **Unattached** (`Available`) state, make sure that the disk has been attached to ECS instances. Snapshots cannot be created for disks that have never been attached to an ECS instance.
        Snapshot-consistent groups can be used to create snapshots only for Enterprise SSDs (ESSDs), ESSD AutoPL disks, and ESSD Entry disks.
        A snapshot-consistent group can contain snapshots of up to 16 disks, including system disks and data disks, and cannot exceed 32 TiB in size.
        Snapshots that you created are stored indefinitely until you delete the snapshots. We recommend that you delete unnecessary snapshots on a regular basis to prevent excess snapshot storage fees.
        Snapshot-consistent groups cannot be created for disks for which multi-attach feature is enabled. If disks for which the multi-attach feature is enabled are attached to an ECS instance, you must specify the `ExcludeDiskId.N` parameter to exclude the disks.
        For more information about the snapshot-consistent group feature, see [Create a snapshot-consistent group](https://help.aliyun.com/document_detail/199625.html).
        
        @param request: CreateSnapshotGroupRequest
        @return: CreateSnapshotGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_snapshot_group_with_options(request, runtime)

    async def create_snapshot_group_async(
        self,
        request: ecs_20140526_models.CreateSnapshotGroupRequest,
    ) -> ecs_20140526_models.CreateSnapshotGroupResponse:
        """
        @summary Creates a snapshot-consistent group for the disks of an Elastic Compute Service (ECS) instance. A snapshot-consistent group contains snapshots of one or more disks.
        
        @description You can specify `InstanceId` to create a snapshot-consistent group for disks on a specific ECS instance. You can also specify `DiskId.N` to create a snapshot-consistent group for multiple disks on multiple ECS instances within the same zone.
        >  You cannot specify both `DiskId.N` and `ExcludeDiskId.N` in the same request. If you specify `InstanceId`, you can use `DiskId.N` to specify only disks on the specified ECS instance and cannot use DiskId.N to specify disks across ECS instances.
        Take note of the following items:
        The disks for which you want to create a snapshot must be in the **In Use** (`In_use`) or **Unattached** (`Available`) state.
        If a disk is in the **In Use** (`In_use`) state, make sure that the ECS instance to which the disk is attached is in the **Running** (`Running`) or **Stopped** (`Stopped`) state.
        If a disk is in the **Unattached** (`Available`) state, make sure that the disk has been attached to ECS instances. Snapshots cannot be created for disks that have never been attached to an ECS instance.
        Snapshot-consistent groups can be used to create snapshots only for Enterprise SSDs (ESSDs), ESSD AutoPL disks, and ESSD Entry disks.
        A snapshot-consistent group can contain snapshots of up to 16 disks, including system disks and data disks, and cannot exceed 32 TiB in size.
        Snapshots that you created are stored indefinitely until you delete the snapshots. We recommend that you delete unnecessary snapshots on a regular basis to prevent excess snapshot storage fees.
        Snapshot-consistent groups cannot be created for disks for which multi-attach feature is enabled. If disks for which the multi-attach feature is enabled are attached to an ECS instance, you must specify the `ExcludeDiskId.N` parameter to exclude the disks.
        For more information about the snapshot-consistent group feature, see [Create a snapshot-consistent group](https://help.aliyun.com/document_detail/199625.html).
        
        @param request: CreateSnapshotGroupRequest
        @return: CreateSnapshotGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_snapshot_group_with_options_async(request, runtime)

    def create_storage_set_with_options(
        self,
        request: ecs_20140526_models.CreateStorageSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateStorageSetResponse:
        """
        @summary (Beta) Creates a storage set in a zone of a region.
        
        @description A storage set can distribute disks or Shared Block Storage devices to different locations. You can specify the number of partitions in a storage set. A larger number of partitions indicate more discrete distribution of disks or Shared Block Storage devices.
        When you call this operation, take note of the following items:
        The number of storage sets that you can create in a region is limited. You can call the [DescribeAccountAttributes](https://help.aliyun.com/document_detail/73772.html) operation to query the limit.
        The number of partitions in a zone is limited. You can call the [DescribeAccountAttributes](https://help.aliyun.com/document_detail/73772.html) operation to query the limit.
        
        @param request: CreateStorageSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStorageSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.max_partition_number):
            query['MaxPartitionNumber'] = request.max_partition_number
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_set_name):
            query['StorageSetName'] = request.storage_set_name
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStorageSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateStorageSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_storage_set_with_options_async(
        self,
        request: ecs_20140526_models.CreateStorageSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateStorageSetResponse:
        """
        @summary (Beta) Creates a storage set in a zone of a region.
        
        @description A storage set can distribute disks or Shared Block Storage devices to different locations. You can specify the number of partitions in a storage set. A larger number of partitions indicate more discrete distribution of disks or Shared Block Storage devices.
        When you call this operation, take note of the following items:
        The number of storage sets that you can create in a region is limited. You can call the [DescribeAccountAttributes](https://help.aliyun.com/document_detail/73772.html) operation to query the limit.
        The number of partitions in a zone is limited. You can call the [DescribeAccountAttributes](https://help.aliyun.com/document_detail/73772.html) operation to query the limit.
        
        @param request: CreateStorageSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateStorageSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.max_partition_number):
            query['MaxPartitionNumber'] = request.max_partition_number
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_set_name):
            query['StorageSetName'] = request.storage_set_name
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateStorageSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateStorageSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_storage_set(
        self,
        request: ecs_20140526_models.CreateStorageSetRequest,
    ) -> ecs_20140526_models.CreateStorageSetResponse:
        """
        @summary (Beta) Creates a storage set in a zone of a region.
        
        @description A storage set can distribute disks or Shared Block Storage devices to different locations. You can specify the number of partitions in a storage set. A larger number of partitions indicate more discrete distribution of disks or Shared Block Storage devices.
        When you call this operation, take note of the following items:
        The number of storage sets that you can create in a region is limited. You can call the [DescribeAccountAttributes](https://help.aliyun.com/document_detail/73772.html) operation to query the limit.
        The number of partitions in a zone is limited. You can call the [DescribeAccountAttributes](https://help.aliyun.com/document_detail/73772.html) operation to query the limit.
        
        @param request: CreateStorageSetRequest
        @return: CreateStorageSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_storage_set_with_options(request, runtime)

    async def create_storage_set_async(
        self,
        request: ecs_20140526_models.CreateStorageSetRequest,
    ) -> ecs_20140526_models.CreateStorageSetResponse:
        """
        @summary (Beta) Creates a storage set in a zone of a region.
        
        @description A storage set can distribute disks or Shared Block Storage devices to different locations. You can specify the number of partitions in a storage set. A larger number of partitions indicate more discrete distribution of disks or Shared Block Storage devices.
        When you call this operation, take note of the following items:
        The number of storage sets that you can create in a region is limited. You can call the [DescribeAccountAttributes](https://help.aliyun.com/document_detail/73772.html) operation to query the limit.
        The number of partitions in a zone is limited. You can call the [DescribeAccountAttributes](https://help.aliyun.com/document_detail/73772.html) operation to query the limit.
        
        @param request: CreateStorageSetRequest
        @return: CreateStorageSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_storage_set_with_options_async(request, runtime)

    def create_vswitch_with_options(
        self,
        request: ecs_20140526_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVSwitchResponse:
        """
        @deprecated OpenAPI CreateVSwitch is deprecated, please use Vpc::2016-04-28::CreateVSwitch instead.
        
        @summary CreateVSwitch
        
        @param request: CreateVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVSwitchResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vswitch_with_options_async(
        self,
        request: ecs_20140526_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVSwitchResponse:
        """
        @deprecated OpenAPI CreateVSwitch is deprecated, please use Vpc::2016-04-28::CreateVSwitch instead.
        
        @summary CreateVSwitch
        
        @param request: CreateVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVSwitchResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vswitch(
        self,
        request: ecs_20140526_models.CreateVSwitchRequest,
    ) -> ecs_20140526_models.CreateVSwitchResponse:
        """
        @deprecated OpenAPI CreateVSwitch is deprecated, please use Vpc::2016-04-28::CreateVSwitch instead.
        
        @summary CreateVSwitch
        
        @param request: CreateVSwitchRequest
        @return: CreateVSwitchResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vswitch_with_options(request, runtime)

    async def create_vswitch_async(
        self,
        request: ecs_20140526_models.CreateVSwitchRequest,
    ) -> ecs_20140526_models.CreateVSwitchResponse:
        """
        @deprecated OpenAPI CreateVSwitch is deprecated, please use Vpc::2016-04-28::CreateVSwitch instead.
        
        @summary CreateVSwitch
        
        @param request: CreateVSwitchRequest
        @return: CreateVSwitchResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vswitch_with_options_async(request, runtime)

    def create_virtual_border_router_with_options(
        self,
        request: ecs_20140526_models.CreateVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVirtualBorderRouterResponse:
        """
        @deprecated OpenAPI CreateVirtualBorderRouter is deprecated, please use Vpc::2016-04-28::CreateVirtualBorderRouter instead.
        
        @summary CreateVirtualBorderRouter
        
        @param request: CreateVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVirtualBorderRouterResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vbr_owner_id):
            query['VbrOwnerId'] = request.vbr_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualBorderRouter',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_virtual_border_router_with_options_async(
        self,
        request: ecs_20140526_models.CreateVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVirtualBorderRouterResponse:
        """
        @deprecated OpenAPI CreateVirtualBorderRouter is deprecated, please use Vpc::2016-04-28::CreateVirtualBorderRouter instead.
        
        @summary CreateVirtualBorderRouter
        
        @param request: CreateVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVirtualBorderRouterResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vbr_owner_id):
            query['VbrOwnerId'] = request.vbr_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualBorderRouter',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_virtual_border_router(
        self,
        request: ecs_20140526_models.CreateVirtualBorderRouterRequest,
    ) -> ecs_20140526_models.CreateVirtualBorderRouterResponse:
        """
        @deprecated OpenAPI CreateVirtualBorderRouter is deprecated, please use Vpc::2016-04-28::CreateVirtualBorderRouter instead.
        
        @summary CreateVirtualBorderRouter
        
        @param request: CreateVirtualBorderRouterRequest
        @return: CreateVirtualBorderRouterResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_virtual_border_router_with_options(request, runtime)

    async def create_virtual_border_router_async(
        self,
        request: ecs_20140526_models.CreateVirtualBorderRouterRequest,
    ) -> ecs_20140526_models.CreateVirtualBorderRouterResponse:
        """
        @deprecated OpenAPI CreateVirtualBorderRouter is deprecated, please use Vpc::2016-04-28::CreateVirtualBorderRouter instead.
        
        @summary CreateVirtualBorderRouter
        
        @param request: CreateVirtualBorderRouterRequest
        @return: CreateVirtualBorderRouterResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_virtual_border_router_with_options_async(request, runtime)

    def create_vpc_with_options(
        self,
        request: ecs_20140526_models.CreateVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVpcResponse:
        """
        @deprecated OpenAPI CreateVpc is deprecated, please use Vpc::2016-04-28::CreateVpc instead.
        
        @summary CreateVpc
        
        @param request: CreateVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_with_options_async(
        self,
        request: ecs_20140526_models.CreateVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.CreateVpcResponse:
        """
        @deprecated OpenAPI CreateVpc is deprecated, please use Vpc::2016-04-28::CreateVpc instead.
        
        @summary CreateVpc
        
        @param request: CreateVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.CreateVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc(
        self,
        request: ecs_20140526_models.CreateVpcRequest,
    ) -> ecs_20140526_models.CreateVpcResponse:
        """
        @deprecated OpenAPI CreateVpc is deprecated, please use Vpc::2016-04-28::CreateVpc instead.
        
        @summary CreateVpc
        
        @param request: CreateVpcRequest
        @return: CreateVpcResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_with_options(request, runtime)

    async def create_vpc_async(
        self,
        request: ecs_20140526_models.CreateVpcRequest,
    ) -> ecs_20140526_models.CreateVpcResponse:
        """
        @deprecated OpenAPI CreateVpc is deprecated, please use Vpc::2016-04-28::CreateVpc instead.
        
        @summary CreateVpc
        
        @param request: CreateVpcRequest
        @return: CreateVpcResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_with_options_async(request, runtime)

    def deactivate_router_interface_with_options(
        self,
        request: ecs_20140526_models.DeactivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeactivateRouterInterfaceResponse:
        """
        @deprecated OpenAPI DeactivateRouterInterface is deprecated, please use Vpc::2016-04-28::DeactivateRouterInterface instead.
        
        @summary DeactivateRouterInterface
        
        @param request: DeactivateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeactivateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactivateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeactivateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def deactivate_router_interface_with_options_async(
        self,
        request: ecs_20140526_models.DeactivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeactivateRouterInterfaceResponse:
        """
        @deprecated OpenAPI DeactivateRouterInterface is deprecated, please use Vpc::2016-04-28::DeactivateRouterInterface instead.
        
        @summary DeactivateRouterInterface
        
        @param request: DeactivateRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeactivateRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactivateRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeactivateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deactivate_router_interface(
        self,
        request: ecs_20140526_models.DeactivateRouterInterfaceRequest,
    ) -> ecs_20140526_models.DeactivateRouterInterfaceResponse:
        """
        @deprecated OpenAPI DeactivateRouterInterface is deprecated, please use Vpc::2016-04-28::DeactivateRouterInterface instead.
        
        @summary DeactivateRouterInterface
        
        @param request: DeactivateRouterInterfaceRequest
        @return: DeactivateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.deactivate_router_interface_with_options(request, runtime)

    async def deactivate_router_interface_async(
        self,
        request: ecs_20140526_models.DeactivateRouterInterfaceRequest,
    ) -> ecs_20140526_models.DeactivateRouterInterfaceResponse:
        """
        @deprecated OpenAPI DeactivateRouterInterface is deprecated, please use Vpc::2016-04-28::DeactivateRouterInterface instead.
        
        @summary DeactivateRouterInterface
        
        @param request: DeactivateRouterInterfaceRequest
        @return: DeactivateRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.deactivate_router_interface_with_options_async(request, runtime)

    def delete_activation_with_options(
        self,
        request: ecs_20140526_models.DeleteActivationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteActivationResponse:
        """
        @summary Deletes an unused activation code.
        
        @description ## [](#)Usage notes
        Before you call this operation to delete an activation code, make sure that no managed instances are registered with the activation code.
        
        @param request: DeleteActivationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteActivationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activation_id):
            query['ActivationId'] = request.activation_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteActivation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteActivationResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_activation_with_options_async(
        self,
        request: ecs_20140526_models.DeleteActivationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteActivationResponse:
        """
        @summary Deletes an unused activation code.
        
        @description ## [](#)Usage notes
        Before you call this operation to delete an activation code, make sure that no managed instances are registered with the activation code.
        
        @param request: DeleteActivationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteActivationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activation_id):
            query['ActivationId'] = request.activation_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteActivation',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteActivationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_activation(
        self,
        request: ecs_20140526_models.DeleteActivationRequest,
    ) -> ecs_20140526_models.DeleteActivationResponse:
        """
        @summary Deletes an unused activation code.
        
        @description ## [](#)Usage notes
        Before you call this operation to delete an activation code, make sure that no managed instances are registered with the activation code.
        
        @param request: DeleteActivationRequest
        @return: DeleteActivationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_activation_with_options(request, runtime)

    async def delete_activation_async(
        self,
        request: ecs_20140526_models.DeleteActivationRequest,
    ) -> ecs_20140526_models.DeleteActivationResponse:
        """
        @summary Deletes an unused activation code.
        
        @description ## [](#)Usage notes
        Before you call this operation to delete an activation code, make sure that no managed instances are registered with the activation code.
        
        @param request: DeleteActivationRequest
        @return: DeleteActivationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_activation_with_options_async(request, runtime)

    def delete_auto_provisioning_group_with_options(
        self,
        request: ecs_20140526_models.DeleteAutoProvisioningGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteAutoProvisioningGroupResponse:
        """
        @summary Deletes an auto provisioning group. When you call this operation, you can specify AutoProvisioningGroupId and TerminateInstances in the request.
        
        @param request: DeleteAutoProvisioningGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAutoProvisioningGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_id):
            query['AutoProvisioningGroupId'] = request.auto_provisioning_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_instances):
            query['TerminateInstances'] = request.terminate_instances
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoProvisioningGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteAutoProvisioningGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_auto_provisioning_group_with_options_async(
        self,
        request: ecs_20140526_models.DeleteAutoProvisioningGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteAutoProvisioningGroupResponse:
        """
        @summary Deletes an auto provisioning group. When you call this operation, you can specify AutoProvisioningGroupId and TerminateInstances in the request.
        
        @param request: DeleteAutoProvisioningGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAutoProvisioningGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_provisioning_group_id):
            query['AutoProvisioningGroupId'] = request.auto_provisioning_group_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_instances):
            query['TerminateInstances'] = request.terminate_instances
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoProvisioningGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteAutoProvisioningGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_auto_provisioning_group(
        self,
        request: ecs_20140526_models.DeleteAutoProvisioningGroupRequest,
    ) -> ecs_20140526_models.DeleteAutoProvisioningGroupResponse:
        """
        @summary Deletes an auto provisioning group. When you call this operation, you can specify AutoProvisioningGroupId and TerminateInstances in the request.
        
        @param request: DeleteAutoProvisioningGroupRequest
        @return: DeleteAutoProvisioningGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_auto_provisioning_group_with_options(request, runtime)

    async def delete_auto_provisioning_group_async(
        self,
        request: ecs_20140526_models.DeleteAutoProvisioningGroupRequest,
    ) -> ecs_20140526_models.DeleteAutoProvisioningGroupResponse:
        """
        @summary Deletes an auto provisioning group. When you call this operation, you can specify AutoProvisioningGroupId and TerminateInstances in the request.
        
        @param request: DeleteAutoProvisioningGroupRequest
        @return: DeleteAutoProvisioningGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_auto_provisioning_group_with_options_async(request, runtime)

    def delete_auto_snapshot_policy_with_options(
        self,
        request: ecs_20140526_models.DeleteAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteAutoSnapshotPolicyResponse:
        """
        @summary Deletes an automatic snapshot policy. After you delete an automatic snapshot policy, the policy is no longer applied to the disks on which it previously took effect.
        
        @param request: DeleteAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['autoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteAutoSnapshotPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_auto_snapshot_policy_with_options_async(
        self,
        request: ecs_20140526_models.DeleteAutoSnapshotPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteAutoSnapshotPolicyResponse:
        """
        @summary Deletes an automatic snapshot policy. After you delete an automatic snapshot policy, the policy is no longer applied to the disks on which it previously took effect.
        
        @param request: DeleteAutoSnapshotPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAutoSnapshotPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.auto_snapshot_policy_id):
            query['autoSnapshotPolicyId'] = request.auto_snapshot_policy_id
        if not UtilClient.is_unset(request.region_id):
            query['regionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAutoSnapshotPolicy',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteAutoSnapshotPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_auto_snapshot_policy(
        self,
        request: ecs_20140526_models.DeleteAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.DeleteAutoSnapshotPolicyResponse:
        """
        @summary Deletes an automatic snapshot policy. After you delete an automatic snapshot policy, the policy is no longer applied to the disks on which it previously took effect.
        
        @param request: DeleteAutoSnapshotPolicyRequest
        @return: DeleteAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_auto_snapshot_policy_with_options(request, runtime)

    async def delete_auto_snapshot_policy_async(
        self,
        request: ecs_20140526_models.DeleteAutoSnapshotPolicyRequest,
    ) -> ecs_20140526_models.DeleteAutoSnapshotPolicyResponse:
        """
        @summary Deletes an automatic snapshot policy. After you delete an automatic snapshot policy, the policy is no longer applied to the disks on which it previously took effect.
        
        @param request: DeleteAutoSnapshotPolicyRequest
        @return: DeleteAutoSnapshotPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_auto_snapshot_policy_with_options_async(request, runtime)

    def delete_bandwidth_package_with_options(
        self,
        request: ecs_20140526_models.DeleteBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteBandwidthPackageResponse:
        """
        @deprecated OpenAPI DeleteBandwidthPackage is deprecated, please use Vpc::2016-04-28::DeleteBandwidthPackage instead.
        
        @summary DeleteBandwidthPackage
        
        @param request: DeleteBandwidthPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBandwidthPackageResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBandwidthPackage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bandwidth_package_with_options_async(
        self,
        request: ecs_20140526_models.DeleteBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteBandwidthPackageResponse:
        """
        @deprecated OpenAPI DeleteBandwidthPackage is deprecated, please use Vpc::2016-04-28::DeleteBandwidthPackage instead.
        
        @summary DeleteBandwidthPackage
        
        @param request: DeleteBandwidthPackageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteBandwidthPackageResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBandwidthPackage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bandwidth_package(
        self,
        request: ecs_20140526_models.DeleteBandwidthPackageRequest,
    ) -> ecs_20140526_models.DeleteBandwidthPackageResponse:
        """
        @deprecated OpenAPI DeleteBandwidthPackage is deprecated, please use Vpc::2016-04-28::DeleteBandwidthPackage instead.
        
        @summary DeleteBandwidthPackage
        
        @param request: DeleteBandwidthPackageRequest
        @return: DeleteBandwidthPackageResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_bandwidth_package_with_options(request, runtime)

    async def delete_bandwidth_package_async(
        self,
        request: ecs_20140526_models.DeleteBandwidthPackageRequest,
    ) -> ecs_20140526_models.DeleteBandwidthPackageResponse:
        """
        @deprecated OpenAPI DeleteBandwidthPackage is deprecated, please use Vpc::2016-04-28::DeleteBandwidthPackage instead.
        
        @summary DeleteBandwidthPackage
        
        @param request: DeleteBandwidthPackageRequest
        @return: DeleteBandwidthPackageResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_bandwidth_package_with_options_async(request, runtime)

    def delete_command_with_options(
        self,
        request: ecs_20140526_models.DeleteCommandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteCommandResponse:
        """
        @summary Deletes a Cloud Assistant command in a region. This operation cannot delete Cloud Assistant commands that are being run.
        
        @param request: DeleteCommandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCommandResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_id):
            query['CommandId'] = request.command_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCommand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteCommandResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_command_with_options_async(
        self,
        request: ecs_20140526_models.DeleteCommandRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteCommandResponse:
        """
        @summary Deletes a Cloud Assistant command in a region. This operation cannot delete Cloud Assistant commands that are being run.
        
        @param request: DeleteCommandRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteCommandResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.command_id):
            query['CommandId'] = request.command_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCommand',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteCommandResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_command(
        self,
        request: ecs_20140526_models.DeleteCommandRequest,
    ) -> ecs_20140526_models.DeleteCommandResponse:
        """
        @summary Deletes a Cloud Assistant command in a region. This operation cannot delete Cloud Assistant commands that are being run.
        
        @param request: DeleteCommandRequest
        @return: DeleteCommandResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_command_with_options(request, runtime)

    async def delete_command_async(
        self,
        request: ecs_20140526_models.DeleteCommandRequest,
    ) -> ecs_20140526_models.DeleteCommandResponse:
        """
        @summary Deletes a Cloud Assistant command in a region. This operation cannot delete Cloud Assistant commands that are being run.
        
        @param request: DeleteCommandRequest
        @return: DeleteCommandResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_command_with_options_async(request, runtime)

    def delete_dedicated_host_cluster_with_options(
        self,
        request: ecs_20140526_models.DeleteDedicatedHostClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDedicatedHostClusterResponse:
        """
        @summary Deletes a dedicated host group. Before you call the API operation, you must migrate the dedicated hosts in the host group to another host group.
        
        @param request: DeleteDedicatedHostClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDedicatedHostClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_id):
            query['DedicatedHostClusterId'] = request.dedicated_host_cluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDedicatedHostCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDedicatedHostClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dedicated_host_cluster_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDedicatedHostClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDedicatedHostClusterResponse:
        """
        @summary Deletes a dedicated host group. Before you call the API operation, you must migrate the dedicated hosts in the host group to another host group.
        
        @param request: DeleteDedicatedHostClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDedicatedHostClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dedicated_host_cluster_id):
            query['DedicatedHostClusterId'] = request.dedicated_host_cluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDedicatedHostCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDedicatedHostClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dedicated_host_cluster(
        self,
        request: ecs_20140526_models.DeleteDedicatedHostClusterRequest,
    ) -> ecs_20140526_models.DeleteDedicatedHostClusterResponse:
        """
        @summary Deletes a dedicated host group. Before you call the API operation, you must migrate the dedicated hosts in the host group to another host group.
        
        @param request: DeleteDedicatedHostClusterRequest
        @return: DeleteDedicatedHostClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dedicated_host_cluster_with_options(request, runtime)

    async def delete_dedicated_host_cluster_async(
        self,
        request: ecs_20140526_models.DeleteDedicatedHostClusterRequest,
    ) -> ecs_20140526_models.DeleteDedicatedHostClusterResponse:
        """
        @summary Deletes a dedicated host group. Before you call the API operation, you must migrate the dedicated hosts in the host group to another host group.
        
        @param request: DeleteDedicatedHostClusterRequest
        @return: DeleteDedicatedHostClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dedicated_host_cluster_with_options_async(request, runtime)

    def delete_deployment_set_with_options(
        self,
        request: ecs_20140526_models.DeleteDeploymentSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDeploymentSetResponse:
        """
        @summary Deletes a deployment set.
        
        @description Before you delete a deployment set, make sure that no instances exist in the deployment set. If instances exist in the deployment set, move the instances to a different deployment set or release the instances before you delete the deployment set. For more information, see [Change the deployment set of an instance](https://help.aliyun.com/document_detail/108407.html) and [Release an ECS instance](https://help.aliyun.com/document_detail/25442.html).
        
        @param request: DeleteDeploymentSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDeploymentSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDeploymentSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDeploymentSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_deployment_set_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDeploymentSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDeploymentSetResponse:
        """
        @summary Deletes a deployment set.
        
        @description Before you delete a deployment set, make sure that no instances exist in the deployment set. If instances exist in the deployment set, move the instances to a different deployment set or release the instances before you delete the deployment set. For more information, see [Change the deployment set of an instance](https://help.aliyun.com/document_detail/108407.html) and [Release an ECS instance](https://help.aliyun.com/document_detail/25442.html).
        
        @param request: DeleteDeploymentSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDeploymentSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.deployment_set_id):
            query['DeploymentSetId'] = request.deployment_set_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDeploymentSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDeploymentSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_deployment_set(
        self,
        request: ecs_20140526_models.DeleteDeploymentSetRequest,
    ) -> ecs_20140526_models.DeleteDeploymentSetResponse:
        """
        @summary Deletes a deployment set.
        
        @description Before you delete a deployment set, make sure that no instances exist in the deployment set. If instances exist in the deployment set, move the instances to a different deployment set or release the instances before you delete the deployment set. For more information, see [Change the deployment set of an instance](https://help.aliyun.com/document_detail/108407.html) and [Release an ECS instance](https://help.aliyun.com/document_detail/25442.html).
        
        @param request: DeleteDeploymentSetRequest
        @return: DeleteDeploymentSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_deployment_set_with_options(request, runtime)

    async def delete_deployment_set_async(
        self,
        request: ecs_20140526_models.DeleteDeploymentSetRequest,
    ) -> ecs_20140526_models.DeleteDeploymentSetResponse:
        """
        @summary Deletes a deployment set.
        
        @description Before you delete a deployment set, make sure that no instances exist in the deployment set. If instances exist in the deployment set, move the instances to a different deployment set or release the instances before you delete the deployment set. For more information, see [Change the deployment set of an instance](https://help.aliyun.com/document_detail/108407.html) and [Release an ECS instance](https://help.aliyun.com/document_detail/25442.html).
        
        @param request: DeleteDeploymentSetRequest
        @return: DeleteDeploymentSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_deployment_set_with_options_async(request, runtime)

    def delete_diagnostic_metric_sets_with_options(
        self,
        request: ecs_20140526_models.DeleteDiagnosticMetricSetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiagnosticMetricSetsResponse:
        """
        @summary Deletes diagnostic metric sets.
        
        @param request: DeleteDiagnosticMetricSetsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiagnosticMetricSetsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.metric_set_ids):
            query['MetricSetIds'] = request.metric_set_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDiagnosticMetricSets',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiagnosticMetricSetsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_diagnostic_metric_sets_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDiagnosticMetricSetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiagnosticMetricSetsResponse:
        """
        @summary Deletes diagnostic metric sets.
        
        @param request: DeleteDiagnosticMetricSetsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiagnosticMetricSetsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.metric_set_ids):
            query['MetricSetIds'] = request.metric_set_ids
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDiagnosticMetricSets',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiagnosticMetricSetsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_diagnostic_metric_sets(
        self,
        request: ecs_20140526_models.DeleteDiagnosticMetricSetsRequest,
    ) -> ecs_20140526_models.DeleteDiagnosticMetricSetsResponse:
        """
        @summary Deletes diagnostic metric sets.
        
        @param request: DeleteDiagnosticMetricSetsRequest
        @return: DeleteDiagnosticMetricSetsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_diagnostic_metric_sets_with_options(request, runtime)

    async def delete_diagnostic_metric_sets_async(
        self,
        request: ecs_20140526_models.DeleteDiagnosticMetricSetsRequest,
    ) -> ecs_20140526_models.DeleteDiagnosticMetricSetsResponse:
        """
        @summary Deletes diagnostic metric sets.
        
        @param request: DeleteDiagnosticMetricSetsRequest
        @return: DeleteDiagnosticMetricSetsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_diagnostic_metric_sets_with_options_async(request, runtime)

    def delete_diagnostic_reports_with_options(
        self,
        request: ecs_20140526_models.DeleteDiagnosticReportsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiagnosticReportsResponse:
        """
        @summary Deletes diagnostic reports.
        
        @description You can call this operation to delete the diagnostic reports that are no longer needed.
        
        @param request: DeleteDiagnosticReportsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiagnosticReportsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.report_ids):
            query['ReportIds'] = request.report_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDiagnosticReports',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiagnosticReportsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_diagnostic_reports_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDiagnosticReportsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiagnosticReportsResponse:
        """
        @summary Deletes diagnostic reports.
        
        @description You can call this operation to delete the diagnostic reports that are no longer needed.
        
        @param request: DeleteDiagnosticReportsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiagnosticReportsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.report_ids):
            query['ReportIds'] = request.report_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDiagnosticReports',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiagnosticReportsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_diagnostic_reports(
        self,
        request: ecs_20140526_models.DeleteDiagnosticReportsRequest,
    ) -> ecs_20140526_models.DeleteDiagnosticReportsResponse:
        """
        @summary Deletes diagnostic reports.
        
        @description You can call this operation to delete the diagnostic reports that are no longer needed.
        
        @param request: DeleteDiagnosticReportsRequest
        @return: DeleteDiagnosticReportsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_diagnostic_reports_with_options(request, runtime)

    async def delete_diagnostic_reports_async(
        self,
        request: ecs_20140526_models.DeleteDiagnosticReportsRequest,
    ) -> ecs_20140526_models.DeleteDiagnosticReportsResponse:
        """
        @summary Deletes diagnostic reports.
        
        @description You can call this operation to delete the diagnostic reports that are no longer needed.
        
        @param request: DeleteDiagnosticReportsRequest
        @return: DeleteDiagnosticReportsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_diagnostic_reports_with_options_async(request, runtime)

    def delete_disk_with_options(
        self,
        request: ecs_20140526_models.DeleteDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiskResponse:
        """
        @summary Deletes a pay-as-you-go data disk. The data disk can be a basic disk, an ultra disk, a standard SSD, or an Enterprise SSD (ESSD).
        
        @description When you call this operation, take note of the following items:
        Manual snapshots of the disk are retained.
        You can call the [ModifyDiskAttribute](https://help.aliyun.com/document_detail/25517.html) operation to configure whether to retain automatic snapshots of the disk or release the snapshots along with the disk. We recommend that you delete the snapshots that are no longer needed to maintain a sufficient quota for new automatic snapshots.
        The disk must be in the Unattached (Available) state.
        If the specified DiskId parameter does not exist, the request is ignored.
        
        @param request: DeleteDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiskResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_disk_with_options_async(
        self,
        request: ecs_20140526_models.DeleteDiskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteDiskResponse:
        """
        @summary Deletes a pay-as-you-go data disk. The data disk can be a basic disk, an ultra disk, a standard SSD, or an Enterprise SSD (ESSD).
        
        @description When you call this operation, take note of the following items:
        Manual snapshots of the disk are retained.
        You can call the [ModifyDiskAttribute](https://help.aliyun.com/document_detail/25517.html) operation to configure whether to retain automatic snapshots of the disk or release the snapshots along with the disk. We recommend that you delete the snapshots that are no longer needed to maintain a sufficient quota for new automatic snapshots.
        The disk must be in the Unattached (Available) state.
        If the specified DiskId parameter does not exist, the request is ignored.
        
        @param request: DeleteDiskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDiskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.disk_id):
            query['DiskId'] = request.disk_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDisk',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteDiskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_disk(
        self,
        request: ecs_20140526_models.DeleteDiskRequest,
    ) -> ecs_20140526_models.DeleteDiskResponse:
        """
        @summary Deletes a pay-as-you-go data disk. The data disk can be a basic disk, an ultra disk, a standard SSD, or an Enterprise SSD (ESSD).
        
        @description When you call this operation, take note of the following items:
        Manual snapshots of the disk are retained.
        You can call the [ModifyDiskAttribute](https://help.aliyun.com/document_detail/25517.html) operation to configure whether to retain automatic snapshots of the disk or release the snapshots along with the disk. We recommend that you delete the snapshots that are no longer needed to maintain a sufficient quota for new automatic snapshots.
        The disk must be in the Unattached (Available) state.
        If the specified DiskId parameter does not exist, the request is ignored.
        
        @param request: DeleteDiskRequest
        @return: DeleteDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_disk_with_options(request, runtime)

    async def delete_disk_async(
        self,
        request: ecs_20140526_models.DeleteDiskRequest,
    ) -> ecs_20140526_models.DeleteDiskResponse:
        """
        @summary Deletes a pay-as-you-go data disk. The data disk can be a basic disk, an ultra disk, a standard SSD, or an Enterprise SSD (ESSD).
        
        @description When you call this operation, take note of the following items:
        Manual snapshots of the disk are retained.
        You can call the [ModifyDiskAttribute](https://help.aliyun.com/document_detail/25517.html) operation to configure whether to retain automatic snapshots of the disk or release the snapshots along with the disk. We recommend that you delete the snapshots that are no longer needed to maintain a sufficient quota for new automatic snapshots.
        The disk must be in the Unattached (Available) state.
        If the specified DiskId parameter does not exist, the request is ignored.
        
        @param request: DeleteDiskRequest
        @return: DeleteDiskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_disk_with_options_async(request, runtime)

    def delete_forward_entry_with_options(
        self,
        request: ecs_20140526_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteForwardEntryResponse:
        """
        @deprecated OpenAPI DeleteForwardEntry is deprecated, please use Vpc::2016-04-28::DeleteForwardEntry instead.
        
        @summary DeleteForwardEntry
        
        @param request: DeleteForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteForwardEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_forward_entry_with_options_async(
        self,
        request: ecs_20140526_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteForwardEntryResponse:
        """
        @deprecated OpenAPI DeleteForwardEntry is deprecated, please use Vpc::2016-04-28::DeleteForwardEntry instead.
        
        @summary DeleteForwardEntry
        
        @param request: DeleteForwardEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteForwardEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_forward_entry(
        self,
        request: ecs_20140526_models.DeleteForwardEntryRequest,
    ) -> ecs_20140526_models.DeleteForwardEntryResponse:
        """
        @deprecated OpenAPI DeleteForwardEntry is deprecated, please use Vpc::2016-04-28::DeleteForwardEntry instead.
        
        @summary DeleteForwardEntry
        
        @param request: DeleteForwardEntryRequest
        @return: DeleteForwardEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_forward_entry_with_options(request, runtime)

    async def delete_forward_entry_async(
        self,
        request: ecs_20140526_models.DeleteForwardEntryRequest,
    ) -> ecs_20140526_models.DeleteForwardEntryResponse:
        """
        @deprecated OpenAPI DeleteForwardEntry is deprecated, please use Vpc::2016-04-28::DeleteForwardEntry instead.
        
        @summary DeleteForwardEntry
        
        @param request: DeleteForwardEntryRequest
        @return: DeleteForwardEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_forward_entry_with_options_async(request, runtime)

    def delete_ha_vip_with_options(
        self,
        request: ecs_20140526_models.DeleteHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteHaVipResponse:
        """
        @deprecated OpenAPI DeleteHaVip is deprecated, please use Vpc::2016-04-28::DeleteHaVip instead.
        
        @summary DeleteHaVip
        
        @param request: DeleteHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ha_vip_with_options_async(
        self,
        request: ecs_20140526_models.DeleteHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteHaVipResponse:
        """
        @deprecated OpenAPI DeleteHaVip is deprecated, please use Vpc::2016-04-28::DeleteHaVip instead.
        
        @summary DeleteHaVip
        
        @param request: DeleteHaVipRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHaVipResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHaVip',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ha_vip(
        self,
        request: ecs_20140526_models.DeleteHaVipRequest,
    ) -> ecs_20140526_models.DeleteHaVipResponse:
        """
        @deprecated OpenAPI DeleteHaVip is deprecated, please use Vpc::2016-04-28::DeleteHaVip instead.
        
        @summary DeleteHaVip
        
        @param request: DeleteHaVipRequest
        @return: DeleteHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ha_vip_with_options(request, runtime)

    async def delete_ha_vip_async(
        self,
        request: ecs_20140526_models.DeleteHaVipRequest,
    ) -> ecs_20140526_models.DeleteHaVipResponse:
        """
        @deprecated OpenAPI DeleteHaVip is deprecated, please use Vpc::2016-04-28::DeleteHaVip instead.
        
        @summary DeleteHaVip
        
        @param request: DeleteHaVipRequest
        @return: DeleteHaVipResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ha_vip_with_options_async(request, runtime)

    def delete_hpc_cluster_with_options(
        self,
        request: ecs_20140526_models.DeleteHpcClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteHpcClusterResponse:
        """
        @summary Deletes a high performance computing (HPC) cluster.
        
        @param request: DeleteHpcClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHpcClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.hpc_cluster_id):
            query['HpcClusterId'] = request.hpc_cluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHpcCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteHpcClusterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_hpc_cluster_with_options_async(
        self,
        request: ecs_20140526_models.DeleteHpcClusterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteHpcClusterResponse:
        """
        @summary Deletes a high performance computing (HPC) cluster.
        
        @param request: DeleteHpcClusterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteHpcClusterResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.hpc_cluster_id):
            query['HpcClusterId'] = request.hpc_cluster_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHpcCluster',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteHpcClusterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_hpc_cluster(
        self,
        request: ecs_20140526_models.DeleteHpcClusterRequest,
    ) -> ecs_20140526_models.DeleteHpcClusterResponse:
        """
        @summary Deletes a high performance computing (HPC) cluster.
        
        @param request: DeleteHpcClusterRequest
        @return: DeleteHpcClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_hpc_cluster_with_options(request, runtime)

    async def delete_hpc_cluster_async(
        self,
        request: ecs_20140526_models.DeleteHpcClusterRequest,
    ) -> ecs_20140526_models.DeleteHpcClusterResponse:
        """
        @summary Deletes a high performance computing (HPC) cluster.
        
        @param request: DeleteHpcClusterRequest
        @return: DeleteHpcClusterResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_hpc_cluster_with_options_async(request, runtime)

    def delete_image_with_options(
        self,
        request: ecs_20140526_models.DeleteImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImageResponse:
        """
        @summary Deletes a custom image. When you call this operation, you can specify ImageId and Force in the request.
        
        @description For information about scenarios in which you cannot delete a custom image and the considerations related to custom image deletion, see [Delete a custom image](https://help.aliyun.com/document_detail/25466.html).
        
        @param request: DeleteImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_image_with_options_async(
        self,
        request: ecs_20140526_models.DeleteImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImageResponse:
        """
        @summary Deletes a custom image. When you call this operation, you can specify ImageId and Force in the request.
        
        @description For information about scenarios in which you cannot delete a custom image and the considerations related to custom image deletion, see [Delete a custom image](https://help.aliyun.com/document_detail/25466.html).
        
        @param request: DeleteImageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.image_id):
            query['ImageId'] = request.image_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImage',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_image(
        self,
        request: ecs_20140526_models.DeleteImageRequest,
    ) -> ecs_20140526_models.DeleteImageResponse:
        """
        @summary Deletes a custom image. When you call this operation, you can specify ImageId and Force in the request.
        
        @description For information about scenarios in which you cannot delete a custom image and the considerations related to custom image deletion, see [Delete a custom image](https://help.aliyun.com/document_detail/25466.html).
        
        @param request: DeleteImageRequest
        @return: DeleteImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_image_with_options(request, runtime)

    async def delete_image_async(
        self,
        request: ecs_20140526_models.DeleteImageRequest,
    ) -> ecs_20140526_models.DeleteImageResponse:
        """
        @summary Deletes a custom image. When you call this operation, you can specify ImageId and Force in the request.
        
        @description For information about scenarios in which you cannot delete a custom image and the considerations related to custom image deletion, see [Delete a custom image](https://help.aliyun.com/document_detail/25466.html).
        
        @param request: DeleteImageRequest
        @return: DeleteImageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_image_with_options_async(request, runtime)

    def delete_image_component_with_options(
        self,
        request: ecs_20140526_models.DeleteImageComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImageComponentResponse:
        """
        @summary Deletes an image component. You can specify RegionId and ImageComponentId in the request.
        
        @description    Only custom image components can be deleted.
        When you delete a component, make sure that the component is not used in the template. Otherwise, the component fails to be deleted.
        
        @param request: DeleteImageComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_component_id):
            query['ImageComponentId'] = request.image_component_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImageComponent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImageComponentResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_image_component_with_options_async(
        self,
        request: ecs_20140526_models.DeleteImageComponentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImageComponentResponse:
        """
        @summary Deletes an image component. You can specify RegionId and ImageComponentId in the request.
        
        @description    Only custom image components can be deleted.
        When you delete a component, make sure that the component is not used in the template. Otherwise, the component fails to be deleted.
        
        @param request: DeleteImageComponentRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImageComponentResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_component_id):
            query['ImageComponentId'] = request.image_component_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImageComponent',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImageComponentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_image_component(
        self,
        request: ecs_20140526_models.DeleteImageComponentRequest,
    ) -> ecs_20140526_models.DeleteImageComponentResponse:
        """
        @summary Deletes an image component. You can specify RegionId and ImageComponentId in the request.
        
        @description    Only custom image components can be deleted.
        When you delete a component, make sure that the component is not used in the template. Otherwise, the component fails to be deleted.
        
        @param request: DeleteImageComponentRequest
        @return: DeleteImageComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_image_component_with_options(request, runtime)

    async def delete_image_component_async(
        self,
        request: ecs_20140526_models.DeleteImageComponentRequest,
    ) -> ecs_20140526_models.DeleteImageComponentResponse:
        """
        @summary Deletes an image component. You can specify RegionId and ImageComponentId in the request.
        
        @description    Only custom image components can be deleted.
        When you delete a component, make sure that the component is not used in the template. Otherwise, the component fails to be deleted.
        
        @param request: DeleteImageComponentRequest
        @return: DeleteImageComponentResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_image_component_with_options_async(request, runtime)

    def delete_image_pipeline_with_options(
        self,
        request: ecs_20140526_models.DeleteImagePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImagePipelineResponse:
        """
        @summary Deletes an image template.
        
        @description If an ongoing image building task is associated with an image template, you cannot delete the image template. You can delete the image template only if the image building task reaches the SUCCESS, FAILED, TEST_FAILED, PARTITION_SUCCESS, or CANCELLED state. You can call the DescribeImagePipelineExecutions operation to query the details of an image building task.
        
        @param request: DeleteImagePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImagePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_pipeline_id):
            query['ImagePipelineId'] = request.image_pipeline_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImagePipeline',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImagePipelineResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_image_pipeline_with_options_async(
        self,
        request: ecs_20140526_models.DeleteImagePipelineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteImagePipelineResponse:
        """
        @summary Deletes an image template.
        
        @description If an ongoing image building task is associated with an image template, you cannot delete the image template. You can delete the image template only if the image building task reaches the SUCCESS, FAILED, TEST_FAILED, PARTITION_SUCCESS, or CANCELLED state. You can call the DescribeImagePipelineExecutions operation to query the details of an image building task.
        
        @param request: DeleteImagePipelineRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteImagePipelineResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_pipeline_id):
            query['ImagePipelineId'] = request.image_pipeline_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteImagePipeline',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteImagePipelineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_image_pipeline(
        self,
        request: ecs_20140526_models.DeleteImagePipelineRequest,
    ) -> ecs_20140526_models.DeleteImagePipelineResponse:
        """
        @summary Deletes an image template.
        
        @description If an ongoing image building task is associated with an image template, you cannot delete the image template. You can delete the image template only if the image building task reaches the SUCCESS, FAILED, TEST_FAILED, PARTITION_SUCCESS, or CANCELLED state. You can call the DescribeImagePipelineExecutions operation to query the details of an image building task.
        
        @param request: DeleteImagePipelineRequest
        @return: DeleteImagePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_image_pipeline_with_options(request, runtime)

    async def delete_image_pipeline_async(
        self,
        request: ecs_20140526_models.DeleteImagePipelineRequest,
    ) -> ecs_20140526_models.DeleteImagePipelineResponse:
        """
        @summary Deletes an image template.
        
        @description If an ongoing image building task is associated with an image template, you cannot delete the image template. You can delete the image template only if the image building task reaches the SUCCESS, FAILED, TEST_FAILED, PARTITION_SUCCESS, or CANCELLED state. You can call the DescribeImagePipelineExecutions operation to query the details of an image building task.
        
        @param request: DeleteImagePipelineRequest
        @return: DeleteImagePipelineResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_image_pipeline_with_options_async(request, runtime)

    def delete_instance_with_options(
        self,
        request: ecs_20140526_models.DeleteInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteInstanceResponse:
        """
        @summary Deletes or releases a pay-as-you-go Elastic Compute Service (ECS) instance or an expired subscription ECS instance. You can configure parameters to specify whether to release the disks attached to the instance or retain the disks as pay-as-you-go disks.
        
        @description *\
        *Warning** After you release an instance, the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        After you release an instance, manual snapshots of the cloud disks attached to the instance are retained and continue to be billed. You can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/2679824.html) operation to delete the snapshots.
        After you release an instance, whether the cloud disks attached to the instance and the automatic snapshots of the disks are released is determined by the disk attributes. Before you release an instance, you can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) and [ModifyDiskAttribute](https://help.aliyun.com/document_detail/2679770.html) operations to query and modify disk attributes.
        The cloud disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks after the instance is released. The cloud disks for which DeleteWithInstance is set to true are released along with the instance.
        If `DeleteAutoSnapshot` is set to false for a cloud disk attached to the instance, the automatic snapshots of the cloud disk are retained when the instance is released. If DeleteAutoSnapshot is set to true for the cloud disk, the automatic snapshots of the disk are released along with the instance.
        Elastic IP addresses (EIPs) are not released together with instances. You can call the [ReleaseEipAddress](https://help.aliyun.com/document_detail/448702.html) operation to release EIPs.
        *\
        *Note** When you release an instance that is locked for security reasons, the cloud disks attached to the instance are released even if DeleteWithInstance is set to false.
        
        @param request: DeleteInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.force_stop):
            query['ForceStop'] = request.force_stop
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_subscription):
            query['TerminateSubscription'] = request.terminate_subscription
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_instance_with_options_async(
        self,
        request: ecs_20140526_models.DeleteInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteInstanceResponse:
        """
        @summary Deletes or releases a pay-as-you-go Elastic Compute Service (ECS) instance or an expired subscription ECS instance. You can configure parameters to specify whether to release the disks attached to the instance or retain the disks as pay-as-you-go disks.
        
        @description *\
        *Warning** After you release an instance, the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        After you release an instance, manual snapshots of the cloud disks attached to the instance are retained and continue to be billed. You can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/2679824.html) operation to delete the snapshots.
        After you release an instance, whether the cloud disks attached to the instance and the automatic snapshots of the disks are released is determined by the disk attributes. Before you release an instance, you can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) and [ModifyDiskAttribute](https://help.aliyun.com/document_detail/2679770.html) operations to query and modify disk attributes.
        The cloud disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks after the instance is released. The cloud disks for which DeleteWithInstance is set to true are released along with the instance.
        If `DeleteAutoSnapshot` is set to false for a cloud disk attached to the instance, the automatic snapshots of the cloud disk are retained when the instance is released. If DeleteAutoSnapshot is set to true for the cloud disk, the automatic snapshots of the disk are released along with the instance.
        Elastic IP addresses (EIPs) are not released together with instances. You can call the [ReleaseEipAddress](https://help.aliyun.com/document_detail/448702.html) operation to release EIPs.
        *\
        *Note** When you release an instance that is locked for security reasons, the cloud disks attached to the instance are released even if DeleteWithInstance is set to false.
        
        @param request: DeleteInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.force_stop):
            query['ForceStop'] = request.force_stop
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_subscription):
            query['TerminateSubscription'] = request.terminate_subscription
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_instance(
        self,
        request: ecs_20140526_models.DeleteInstanceRequest,
    ) -> ecs_20140526_models.DeleteInstanceResponse:
        """
        @summary Deletes or releases a pay-as-you-go Elastic Compute Service (ECS) instance or an expired subscription ECS instance. You can configure parameters to specify whether to release the disks attached to the instance or retain the disks as pay-as-you-go disks.
        
        @description *\
        *Warning** After you release an instance, the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        After you release an instance, manual snapshots of the cloud disks attached to the instance are retained and continue to be billed. You can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/2679824.html) operation to delete the snapshots.
        After you release an instance, whether the cloud disks attached to the instance and the automatic snapshots of the disks are released is determined by the disk attributes. Before you release an instance, you can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) and [ModifyDiskAttribute](https://help.aliyun.com/document_detail/2679770.html) operations to query and modify disk attributes.
        The cloud disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks after the instance is released. The cloud disks for which DeleteWithInstance is set to true are released along with the instance.
        If `DeleteAutoSnapshot` is set to false for a cloud disk attached to the instance, the automatic snapshots of the cloud disk are retained when the instance is released. If DeleteAutoSnapshot is set to true for the cloud disk, the automatic snapshots of the disk are released along with the instance.
        Elastic IP addresses (EIPs) are not released together with instances. You can call the [ReleaseEipAddress](https://help.aliyun.com/document_detail/448702.html) operation to release EIPs.
        *\
        *Note** When you release an instance that is locked for security reasons, the cloud disks attached to the instance are released even if DeleteWithInstance is set to false.
        
        @param request: DeleteInstanceRequest
        @return: DeleteInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_instance_with_options(request, runtime)

    async def delete_instance_async(
        self,
        request: ecs_20140526_models.DeleteInstanceRequest,
    ) -> ecs_20140526_models.DeleteInstanceResponse:
        """
        @summary Deletes or releases a pay-as-you-go Elastic Compute Service (ECS) instance or an expired subscription ECS instance. You can configure parameters to specify whether to release the disks attached to the instance or retain the disks as pay-as-you-go disks.
        
        @description *\
        *Warning** After you release an instance, the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        After you release an instance, manual snapshots of the cloud disks attached to the instance are retained and continue to be billed. You can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/2679824.html) operation to delete the snapshots.
        After you release an instance, whether the cloud disks attached to the instance and the automatic snapshots of the disks are released is determined by the disk attributes. Before you release an instance, you can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) and [ModifyDiskAttribute](https://help.aliyun.com/document_detail/2679770.html) operations to query and modify disk attributes.
        The cloud disks for which `DeleteWithInstance` is set to false are retained as pay-as-you-go disks after the instance is released. The cloud disks for which DeleteWithInstance is set to true are released along with the instance.
        If `DeleteAutoSnapshot` is set to false for a cloud disk attached to the instance, the automatic snapshots of the cloud disk are retained when the instance is released. If DeleteAutoSnapshot is set to true for the cloud disk, the automatic snapshots of the disk are released along with the instance.
        Elastic IP addresses (EIPs) are not released together with instances. You can call the [ReleaseEipAddress](https://help.aliyun.com/document_detail/448702.html) operation to release EIPs.
        *\
        *Note** When you release an instance that is locked for security reasons, the cloud disks attached to the instance are released even if DeleteWithInstance is set to false.
        
        @param request: DeleteInstanceRequest
        @return: DeleteInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_instance_with_options_async(request, runtime)

    def delete_instances_with_options(
        self,
        request: ecs_20140526_models.DeleteInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteInstancesResponse:
        """
        @summary Releases multiple pay-as-you-go Elastic Compute Service (ECS) instances or expired subscription ECS instances at a time. You can configure parameters to specify whether to release the disks attached to the instances or retain the disks as pay-as-you-go disks.
        
        @description >Warning: After you release an instance, the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        After you release an instance, manual snapshots of the cloud disks attached to the instance are retained and continue to be billed. You can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/2679824.html) operation to delete the snapshots.
        After you release an instance, whether the cloud disks attached to the instance and the automatic snapshots of the disks are released is determined by the disk attributes. Before you release an instance, you can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) and [ModifyDiskAttribute](https://help.aliyun.com/document_detail/2679770.html) operations to query and modify disk attributes.
        If `DeleteWithInstance` is set to false for a cloud disk attached to the instance, the cloud disk is changed to a pay-as-you-go disk and retained after the instance is released. If DeleteWithInstance is set to true for the cloud disk, the disk is released together with the instance.
        If `DeleteAutoSnapshot` is set to false for a cloud disk attached to the instance, the automatic snapshots of the disk are retained when the instance is released. If DeleteAutoSnapshot is set to true for the cloud disk, the automatic snapshots of the disk are released together with the instance.
        Elastic IP addresses (EIPs) are not released together with instances. You can call the [ReleaseEipAddress](https://help.aliyun.com/document_detail/448702.html) operation to release EIPs.
        > When you release an instance that is locked for security reasons, the cloud disks attached to the instance are released together with the instance even if DeleteWithInstance is set to false for the disks.
        
        @param request: DeleteInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.force_stop):
            query['ForceStop'] = request.force_stop
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_subscription):
            query['TerminateSubscription'] = request.terminate_subscription
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstances',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_instances_with_options_async(
        self,
        request: ecs_20140526_models.DeleteInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteInstancesResponse:
        """
        @summary Releases multiple pay-as-you-go Elastic Compute Service (ECS) instances or expired subscription ECS instances at a time. You can configure parameters to specify whether to release the disks attached to the instances or retain the disks as pay-as-you-go disks.
        
        @description >Warning: After you release an instance, the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        After you release an instance, manual snapshots of the cloud disks attached to the instance are retained and continue to be billed. You can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/2679824.html) operation to delete the snapshots.
        After you release an instance, whether the cloud disks attached to the instance and the automatic snapshots of the disks are released is determined by the disk attributes. Before you release an instance, you can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) and [ModifyDiskAttribute](https://help.aliyun.com/document_detail/2679770.html) operations to query and modify disk attributes.
        If `DeleteWithInstance` is set to false for a cloud disk attached to the instance, the cloud disk is changed to a pay-as-you-go disk and retained after the instance is released. If DeleteWithInstance is set to true for the cloud disk, the disk is released together with the instance.
        If `DeleteAutoSnapshot` is set to false for a cloud disk attached to the instance, the automatic snapshots of the disk are retained when the instance is released. If DeleteAutoSnapshot is set to true for the cloud disk, the automatic snapshots of the disk are released together with the instance.
        Elastic IP addresses (EIPs) are not released together with instances. You can call the [ReleaseEipAddress](https://help.aliyun.com/document_detail/448702.html) operation to release EIPs.
        > When you release an instance that is locked for security reasons, the cloud disks attached to the instance are released together with the instance even if DeleteWithInstance is set to false for the disks.
        
        @param request: DeleteInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.force_stop):
            query['ForceStop'] = request.force_stop
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.terminate_subscription):
            query['TerminateSubscription'] = request.terminate_subscription
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstances',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_instances(
        self,
        request: ecs_20140526_models.DeleteInstancesRequest,
    ) -> ecs_20140526_models.DeleteInstancesResponse:
        """
        @summary Releases multiple pay-as-you-go Elastic Compute Service (ECS) instances or expired subscription ECS instances at a time. You can configure parameters to specify whether to release the disks attached to the instances or retain the disks as pay-as-you-go disks.
        
        @description >Warning: After you release an instance, the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        After you release an instance, manual snapshots of the cloud disks attached to the instance are retained and continue to be billed. You can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/2679824.html) operation to delete the snapshots.
        After you release an instance, whether the cloud disks attached to the instance and the automatic snapshots of the disks are released is determined by the disk attributes. Before you release an instance, you can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) and [ModifyDiskAttribute](https://help.aliyun.com/document_detail/2679770.html) operations to query and modify disk attributes.
        If `DeleteWithInstance` is set to false for a cloud disk attached to the instance, the cloud disk is changed to a pay-as-you-go disk and retained after the instance is released. If DeleteWithInstance is set to true for the cloud disk, the disk is released together with the instance.
        If `DeleteAutoSnapshot` is set to false for a cloud disk attached to the instance, the automatic snapshots of the disk are retained when the instance is released. If DeleteAutoSnapshot is set to true for the cloud disk, the automatic snapshots of the disk are released together with the instance.
        Elastic IP addresses (EIPs) are not released together with instances. You can call the [ReleaseEipAddress](https://help.aliyun.com/document_detail/448702.html) operation to release EIPs.
        > When you release an instance that is locked for security reasons, the cloud disks attached to the instance are released together with the instance even if DeleteWithInstance is set to false for the disks.
        
        @param request: DeleteInstancesRequest
        @return: DeleteInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_instances_with_options(request, runtime)

    async def delete_instances_async(
        self,
        request: ecs_20140526_models.DeleteInstancesRequest,
    ) -> ecs_20140526_models.DeleteInstancesResponse:
        """
        @summary Releases multiple pay-as-you-go Elastic Compute Service (ECS) instances or expired subscription ECS instances at a time. You can configure parameters to specify whether to release the disks attached to the instances or retain the disks as pay-as-you-go disks.
        
        @description >Warning: After you release an instance, the physical resources used by the instance are recycled. Relevant data is erased and cannot be restored.
        After you release an instance, manual snapshots of the cloud disks attached to the instance are retained and continue to be billed. You can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/2679824.html) operation to delete the snapshots.
        After you release an instance, whether the cloud disks attached to the instance and the automatic snapshots of the disks are released is determined by the disk attributes. Before you release an instance, you can call the [DescribeDisks](https://help.aliyun.com/document_detail/2679767.html) and [ModifyDiskAttribute](https://help.aliyun.com/document_detail/2679770.html) operations to query and modify disk attributes.
        If `DeleteWithInstance` is set to false for a cloud disk attached to the instance, the cloud disk is changed to a pay-as-you-go disk and retained after the instance is released. If DeleteWithInstance is set to true for the cloud disk, the disk is released together with the instance.
        If `DeleteAutoSnapshot` is set to false for a cloud disk attached to the instance, the automatic snapshots of the disk are retained when the instance is released. If DeleteAutoSnapshot is set to true for the cloud disk, the automatic snapshots of the disk are released together with the instance.
        Elastic IP addresses (EIPs) are not released together with instances. You can call the [ReleaseEipAddress](https://help.aliyun.com/document_detail/448702.html) operation to release EIPs.
        > When you release an instance that is locked for security reasons, the cloud disks attached to the instance are released together with the instance even if DeleteWithInstance is set to false for the disks.
        
        @param request: DeleteInstancesRequest
        @return: DeleteInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_instances_with_options_async(request, runtime)

    def delete_key_pairs_with_options(
        self,
        request: ecs_20140526_models.DeleteKeyPairsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteKeyPairsResponse:
        """
        @summary Deletes one or more SSH key pairs.
        
        @description When you call this operation, take note of the following items:
        After an SSH key pair is deleted, you cannot query the SSH key pair by calling the [DescribeKeyPairs](https://help.aliyun.com/document_detail/51773.html) operation.
        If an SSH key pair is bound to one or more Elastic Compute Service (ECS) instances, the SSH key pair cannot be deleted.
        
        @param request: DeleteKeyPairsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteKeyPairsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_names):
            query['KeyPairNames'] = request.key_pair_names
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteKeyPairs',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteKeyPairsResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_key_pairs_with_options_async(
        self,
        request: ecs_20140526_models.DeleteKeyPairsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteKeyPairsResponse:
        """
        @summary Deletes one or more SSH key pairs.
        
        @description When you call this operation, take note of the following items:
        After an SSH key pair is deleted, you cannot query the SSH key pair by calling the [DescribeKeyPairs](https://help.aliyun.com/document_detail/51773.html) operation.
        If an SSH key pair is bound to one or more Elastic Compute Service (ECS) instances, the SSH key pair cannot be deleted.
        
        @param request: DeleteKeyPairsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteKeyPairsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.key_pair_names):
            query['KeyPairNames'] = request.key_pair_names
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteKeyPairs',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteKeyPairsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_key_pairs(
        self,
        request: ecs_20140526_models.DeleteKeyPairsRequest,
    ) -> ecs_20140526_models.DeleteKeyPairsResponse:
        """
        @summary Deletes one or more SSH key pairs.
        
        @description When you call this operation, take note of the following items:
        After an SSH key pair is deleted, you cannot query the SSH key pair by calling the [DescribeKeyPairs](https://help.aliyun.com/document_detail/51773.html) operation.
        If an SSH key pair is bound to one or more Elastic Compute Service (ECS) instances, the SSH key pair cannot be deleted.
        
        @param request: DeleteKeyPairsRequest
        @return: DeleteKeyPairsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_key_pairs_with_options(request, runtime)

    async def delete_key_pairs_async(
        self,
        request: ecs_20140526_models.DeleteKeyPairsRequest,
    ) -> ecs_20140526_models.DeleteKeyPairsResponse:
        """
        @summary Deletes one or more SSH key pairs.
        
        @description When you call this operation, take note of the following items:
        After an SSH key pair is deleted, you cannot query the SSH key pair by calling the [DescribeKeyPairs](https://help.aliyun.com/document_detail/51773.html) operation.
        If an SSH key pair is bound to one or more Elastic Compute Service (ECS) instances, the SSH key pair cannot be deleted.
        
        @param request: DeleteKeyPairsRequest
        @return: DeleteKeyPairsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_key_pairs_with_options_async(request, runtime)

    def delete_launch_template_with_options(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteLaunchTemplateResponse:
        """
        @summary Deletes a launch template. You can use the LaunchTemplateId or LaunchTemplateName parameter to specify the launch template that you want to delete from the specified region.
        
        @description Take note of the following items:
        After you delete a launch template, Elastic Compute Service (ECS) instances created based on the launch template are not affected.
        After you delete a launch template, all versions of the launch template are deleted and cannot be restored. If you want to delete only a specific version of the launch template, call the [DeleteLaunchTemplateVersion](https://help.aliyun.com/document_detail/2679735.html) operation.
        
        @param request: DeleteLaunchTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLaunchTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLaunchTemplate',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteLaunchTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_launch_template_with_options_async(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteLaunchTemplateResponse:
        """
        @summary Deletes a launch template. You can use the LaunchTemplateId or LaunchTemplateName parameter to specify the launch template that you want to delete from the specified region.
        
        @description Take note of the following items:
        After you delete a launch template, Elastic Compute Service (ECS) instances created based on the launch template are not affected.
        After you delete a launch template, all versions of the launch template are deleted and cannot be restored. If you want to delete only a specific version of the launch template, call the [DeleteLaunchTemplateVersion](https://help.aliyun.com/document_detail/2679735.html) operation.
        
        @param request: DeleteLaunchTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLaunchTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLaunchTemplate',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteLaunchTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_launch_template(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateRequest,
    ) -> ecs_20140526_models.DeleteLaunchTemplateResponse:
        """
        @summary Deletes a launch template. You can use the LaunchTemplateId or LaunchTemplateName parameter to specify the launch template that you want to delete from the specified region.
        
        @description Take note of the following items:
        After you delete a launch template, Elastic Compute Service (ECS) instances created based on the launch template are not affected.
        After you delete a launch template, all versions of the launch template are deleted and cannot be restored. If you want to delete only a specific version of the launch template, call the [DeleteLaunchTemplateVersion](https://help.aliyun.com/document_detail/2679735.html) operation.
        
        @param request: DeleteLaunchTemplateRequest
        @return: DeleteLaunchTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_launch_template_with_options(request, runtime)

    async def delete_launch_template_async(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateRequest,
    ) -> ecs_20140526_models.DeleteLaunchTemplateResponse:
        """
        @summary Deletes a launch template. You can use the LaunchTemplateId or LaunchTemplateName parameter to specify the launch template that you want to delete from the specified region.
        
        @description Take note of the following items:
        After you delete a launch template, Elastic Compute Service (ECS) instances created based on the launch template are not affected.
        After you delete a launch template, all versions of the launch template are deleted and cannot be restored. If you want to delete only a specific version of the launch template, call the [DeleteLaunchTemplateVersion](https://help.aliyun.com/document_detail/2679735.html) operation.
        
        @param request: DeleteLaunchTemplateRequest
        @return: DeleteLaunchTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_launch_template_with_options_async(request, runtime)

    def delete_launch_template_version_with_options(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteLaunchTemplateVersionResponse:
        """
        @summary Deletes versions of a launch template. When you call this operation, you can specify parameters, such as LaunchTemplateId and DeleteVersion, in the request.
        
        @description Take note of the following items:
        You cannot delete the default version of a launch template by calling this operation. To delete the default version of a launch template, you must delete the launch template.
        If the version of a launch template that you want to delete is the default version, call the [ModifyLaunchTemplateDefaultVersion](https://help.aliyun.com/document_detail/2679734.html) operation or go to the **Launch Templates** page in the Elastic Compute Service (ECS) console to change the default version to a different version, and then delete the original default version.
        After you delete a version of a launch template, the ECS instances that were created based on the version are not affected.
        
        @param request: DeleteLaunchTemplateVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLaunchTemplateVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_version):
            query['DeleteVersion'] = request.delete_version
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLaunchTemplateVersion',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteLaunchTemplateVersionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_launch_template_version_with_options_async(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteLaunchTemplateVersionResponse:
        """
        @summary Deletes versions of a launch template. When you call this operation, you can specify parameters, such as LaunchTemplateId and DeleteVersion, in the request.
        
        @description Take note of the following items:
        You cannot delete the default version of a launch template by calling this operation. To delete the default version of a launch template, you must delete the launch template.
        If the version of a launch template that you want to delete is the default version, call the [ModifyLaunchTemplateDefaultVersion](https://help.aliyun.com/document_detail/2679734.html) operation or go to the **Launch Templates** page in the Elastic Compute Service (ECS) console to change the default version to a different version, and then delete the original default version.
        After you delete a version of a launch template, the ECS instances that were created based on the version are not affected.
        
        @param request: DeleteLaunchTemplateVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteLaunchTemplateVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.delete_version):
            query['DeleteVersion'] = request.delete_version
        if not UtilClient.is_unset(request.launch_template_id):
            query['LaunchTemplateId'] = request.launch_template_id
        if not UtilClient.is_unset(request.launch_template_name):
            query['LaunchTemplateName'] = request.launch_template_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLaunchTemplateVersion',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteLaunchTemplateVersionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_launch_template_version(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateVersionRequest,
    ) -> ecs_20140526_models.DeleteLaunchTemplateVersionResponse:
        """
        @summary Deletes versions of a launch template. When you call this operation, you can specify parameters, such as LaunchTemplateId and DeleteVersion, in the request.
        
        @description Take note of the following items:
        You cannot delete the default version of a launch template by calling this operation. To delete the default version of a launch template, you must delete the launch template.
        If the version of a launch template that you want to delete is the default version, call the [ModifyLaunchTemplateDefaultVersion](https://help.aliyun.com/document_detail/2679734.html) operation or go to the **Launch Templates** page in the Elastic Compute Service (ECS) console to change the default version to a different version, and then delete the original default version.
        After you delete a version of a launch template, the ECS instances that were created based on the version are not affected.
        
        @param request: DeleteLaunchTemplateVersionRequest
        @return: DeleteLaunchTemplateVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_launch_template_version_with_options(request, runtime)

    async def delete_launch_template_version_async(
        self,
        request: ecs_20140526_models.DeleteLaunchTemplateVersionRequest,
    ) -> ecs_20140526_models.DeleteLaunchTemplateVersionResponse:
        """
        @summary Deletes versions of a launch template. When you call this operation, you can specify parameters, such as LaunchTemplateId and DeleteVersion, in the request.
        
        @description Take note of the following items:
        You cannot delete the default version of a launch template by calling this operation. To delete the default version of a launch template, you must delete the launch template.
        If the version of a launch template that you want to delete is the default version, call the [ModifyLaunchTemplateDefaultVersion](https://help.aliyun.com/document_detail/2679734.html) operation or go to the **Launch Templates** page in the Elastic Compute Service (ECS) console to change the default version to a different version, and then delete the original default version.
        After you delete a version of a launch template, the ECS instances that were created based on the version are not affected.
        
        @param request: DeleteLaunchTemplateVersionRequest
        @return: DeleteLaunchTemplateVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_launch_template_version_with_options_async(request, runtime)

    def delete_nat_gateway_with_options(
        self,
        request: ecs_20140526_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNatGatewayResponse:
        """
        @deprecated OpenAPI DeleteNatGateway is deprecated, please use Vpc::2016-04-28::DeleteNatGateway instead.
        
        @summary DeleteNatGateway
        
        @param request: DeleteNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatGatewayResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_gateway_with_options_async(
        self,
        request: ecs_20140526_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNatGatewayResponse:
        """
        @deprecated OpenAPI DeleteNatGateway is deprecated, please use Vpc::2016-04-28::DeleteNatGateway instead.
        
        @summary DeleteNatGateway
        
        @param request: DeleteNatGatewayRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatGatewayResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_gateway(
        self,
        request: ecs_20140526_models.DeleteNatGatewayRequest,
    ) -> ecs_20140526_models.DeleteNatGatewayResponse:
        """
        @deprecated OpenAPI DeleteNatGateway is deprecated, please use Vpc::2016-04-28::DeleteNatGateway instead.
        
        @summary DeleteNatGateway
        
        @param request: DeleteNatGatewayRequest
        @return: DeleteNatGatewayResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_gateway_with_options(request, runtime)

    async def delete_nat_gateway_async(
        self,
        request: ecs_20140526_models.DeleteNatGatewayRequest,
    ) -> ecs_20140526_models.DeleteNatGatewayResponse:
        """
        @deprecated OpenAPI DeleteNatGateway is deprecated, please use Vpc::2016-04-28::DeleteNatGateway instead.
        
        @summary DeleteNatGateway
        
        @param request: DeleteNatGatewayRequest
        @return: DeleteNatGatewayResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_gateway_with_options_async(request, runtime)

    def delete_network_interface_with_options(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNetworkInterfaceResponse:
        """
        @summary Deletes an elastic network interface (ENI) in a region. DeleteNetworkInterface is an asynchronous operation.
        
        @description Take note of the following items:
        The ENI to be deleted must be in the Available state.
        If the ENI to be deleted is attached to an Elastic Compute Service (ECS) instance, you must detach the ENI from the instance before you can delete the ENI. To detach the ENI, you can call the [DetachNetworkInterface](https://help.aliyun.com/document_detail/58514.html) operation.
        After an ENI is deleted, the following situations occur:
        All private IP addresses (including primary and secondary private IP addresses) of the ENI are automatically released.
        The ENI is automatically removed from all security groups.
        The DeleteNetworkInterface operation is an asynchronous operation. After this operation is called to delete an ENI, you can check the status or events of the ENI to determine whether the ENI is deleted. The following figure shows the transitions between the states of the ENI.
        ![](https://static-aliyun-doc.oss-cn-hangzhou.aliyuncs.com/file-manage-files/en-US/20230223/krcd/DeleteNetworkInterface.png)
        If the ENI is in the Deleting state, the ENI deletion request is sent and the ENI is being deleted.
        If the ENI is not found, the ENI is deleted.
        If the ENI is stuck in the Deleting state, the ENI fails to be deleted. You can re-initiate the request to delete the ENI.
        For information about examples on how to call the DeleteNetworkInterface operation, see [Delete an ENI](https://help.aliyun.com/document_detail/471553.html).
        
        @param request: DeleteNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNetworkInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_interface_with_options_async(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNetworkInterfaceResponse:
        """
        @summary Deletes an elastic network interface (ENI) in a region. DeleteNetworkInterface is an asynchronous operation.
        
        @description Take note of the following items:
        The ENI to be deleted must be in the Available state.
        If the ENI to be deleted is attached to an Elastic Compute Service (ECS) instance, you must detach the ENI from the instance before you can delete the ENI. To detach the ENI, you can call the [DetachNetworkInterface](https://help.aliyun.com/document_detail/58514.html) operation.
        After an ENI is deleted, the following situations occur:
        All private IP addresses (including primary and secondary private IP addresses) of the ENI are automatically released.
        The ENI is automatically removed from all security groups.
        The DeleteNetworkInterface operation is an asynchronous operation. After this operation is called to delete an ENI, you can check the status or events of the ENI to determine whether the ENI is deleted. The following figure shows the transitions between the states of the ENI.
        ![](https://static-aliyun-doc.oss-cn-hangzhou.aliyuncs.com/file-manage-files/en-US/20230223/krcd/DeleteNetworkInterface.png)
        If the ENI is in the Deleting state, the ENI deletion request is sent and the ENI is being deleted.
        If the ENI is not found, the ENI is deleted.
        If the ENI is stuck in the Deleting state, the ENI fails to be deleted. You can re-initiate the request to delete the ENI.
        For information about examples on how to call the DeleteNetworkInterface operation, see [Delete an ENI](https://help.aliyun.com/document_detail/471553.html).
        
        @param request: DeleteNetworkInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkInterfaceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNetworkInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_interface(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfaceRequest,
    ) -> ecs_20140526_models.DeleteNetworkInterfaceResponse:
        """
        @summary Deletes an elastic network interface (ENI) in a region. DeleteNetworkInterface is an asynchronous operation.
        
        @description Take note of the following items:
        The ENI to be deleted must be in the Available state.
        If the ENI to be deleted is attached to an Elastic Compute Service (ECS) instance, you must detach the ENI from the instance before you can delete the ENI. To detach the ENI, you can call the [DetachNetworkInterface](https://help.aliyun.com/document_detail/58514.html) operation.
        After an ENI is deleted, the following situations occur:
        All private IP addresses (including primary and secondary private IP addresses) of the ENI are automatically released.
        The ENI is automatically removed from all security groups.
        The DeleteNetworkInterface operation is an asynchronous operation. After this operation is called to delete an ENI, you can check the status or events of the ENI to determine whether the ENI is deleted. The following figure shows the transitions between the states of the ENI.
        ![](https://static-aliyun-doc.oss-cn-hangzhou.aliyuncs.com/file-manage-files/en-US/20230223/krcd/DeleteNetworkInterface.png)
        If the ENI is in the Deleting state, the ENI deletion request is sent and the ENI is being deleted.
        If the ENI is not found, the ENI is deleted.
        If the ENI is stuck in the Deleting state, the ENI fails to be deleted. You can re-initiate the request to delete the ENI.
        For information about examples on how to call the DeleteNetworkInterface operation, see [Delete an ENI](https://help.aliyun.com/document_detail/471553.html).
        
        @param request: DeleteNetworkInterfaceRequest
        @return: DeleteNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_interface_with_options(request, runtime)

    async def delete_network_interface_async(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfaceRequest,
    ) -> ecs_20140526_models.DeleteNetworkInterfaceResponse:
        """
        @summary Deletes an elastic network interface (ENI) in a region. DeleteNetworkInterface is an asynchronous operation.
        
        @description Take note of the following items:
        The ENI to be deleted must be in the Available state.
        If the ENI to be deleted is attached to an Elastic Compute Service (ECS) instance, you must detach the ENI from the instance before you can delete the ENI. To detach the ENI, you can call the [DetachNetworkInterface](https://help.aliyun.com/document_detail/58514.html) operation.
        After an ENI is deleted, the following situations occur:
        All private IP addresses (including primary and secondary private IP addresses) of the ENI are automatically released.
        The ENI is automatically removed from all security groups.
        The DeleteNetworkInterface operation is an asynchronous operation. After this operation is called to delete an ENI, you can check the status or events of the ENI to determine whether the ENI is deleted. The following figure shows the transitions between the states of the ENI.
        ![](https://static-aliyun-doc.oss-cn-hangzhou.aliyuncs.com/file-manage-files/en-US/20230223/krcd/DeleteNetworkInterface.png)
        If the ENI is in the Deleting state, the ENI deletion request is sent and the ENI is being deleted.
        If the ENI is not found, the ENI is deleted.
        If the ENI is stuck in the Deleting state, the ENI fails to be deleted. You can re-initiate the request to delete the ENI.
        For information about examples on how to call the DeleteNetworkInterface operation, see [Delete an ENI](https://help.aliyun.com/document_detail/471553.html).
        
        @param request: DeleteNetworkInterfaceRequest
        @return: DeleteNetworkInterfaceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_interface_with_options_async(request, runtime)

    def delete_network_interface_permission_with_options(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfacePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNetworkInterfacePermissionResponse:
        """
        @deprecated OpenAPI DeleteNetworkInterfacePermission is deprecated, please use Ecs::2014-05-26::DeleteNetworkInterface instead.
        
        @summary 删除操作弹性网卡的权限
        
        @param request: DeleteNetworkInterfacePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkInterfacePermissionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.network_interface_permission_id):
            query['NetworkInterfacePermissionId'] = request.network_interface_permission_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkInterfacePermission',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNetworkInterfacePermissionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_interface_permission_with_options_async(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfacePermissionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteNetworkInterfacePermissionResponse:
        """
        @deprecated OpenAPI DeleteNetworkInterfacePermission is deprecated, please use Ecs::2014-05-26::DeleteNetworkInterface instead.
        
        @summary 删除操作弹性网卡的权限
        
        @param request: DeleteNetworkInterfacePermissionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNetworkInterfacePermissionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.network_interface_permission_id):
            query['NetworkInterfacePermissionId'] = request.network_interface_permission_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkInterfacePermission',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteNetworkInterfacePermissionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_interface_permission(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfacePermissionRequest,
    ) -> ecs_20140526_models.DeleteNetworkInterfacePermissionResponse:
        """
        @deprecated OpenAPI DeleteNetworkInterfacePermission is deprecated, please use Ecs::2014-05-26::DeleteNetworkInterface instead.
        
        @summary 删除操作弹性网卡的权限
        
        @param request: DeleteNetworkInterfacePermissionRequest
        @return: DeleteNetworkInterfacePermissionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_network_interface_permission_with_options(request, runtime)

    async def delete_network_interface_permission_async(
        self,
        request: ecs_20140526_models.DeleteNetworkInterfacePermissionRequest,
    ) -> ecs_20140526_models.DeleteNetworkInterfacePermissionResponse:
        """
        @deprecated OpenAPI DeleteNetworkInterfacePermission is deprecated, please use Ecs::2014-05-26::DeleteNetworkInterface instead.
        
        @summary 删除操作弹性网卡的权限
        
        @param request: DeleteNetworkInterfacePermissionRequest
        @return: DeleteNetworkInterfacePermissionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_interface_permission_with_options_async(request, runtime)

    def delete_physical_connection_with_options(
        self,
        request: ecs_20140526_models.DeletePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeletePhysicalConnectionResponse:
        """
        @deprecated OpenAPI DeletePhysicalConnection is deprecated, please use Vpc::2016-04-28::DeletePhysicalConnection instead.
        
        @summary DeletePhysicalConnection
        
        @param request: DeletePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeletePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_physical_connection_with_options_async(
        self,
        request: ecs_20140526_models.DeletePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeletePhysicalConnectionResponse:
        """
        @deprecated OpenAPI DeletePhysicalConnection is deprecated, please use Vpc::2016-04-28::DeletePhysicalConnection instead.
        
        @summary DeletePhysicalConnection
        
        @param request: DeletePhysicalConnectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePhysicalConnectionResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePhysicalConnection',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeletePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_physical_connection(
        self,
        request: ecs_20140526_models.DeletePhysicalConnectionRequest,
    ) -> ecs_20140526_models.DeletePhysicalConnectionResponse:
        """
        @deprecated OpenAPI DeletePhysicalConnection is deprecated, please use Vpc::2016-04-28::DeletePhysicalConnection instead.
        
        @summary DeletePhysicalConnection
        
        @param request: DeletePhysicalConnectionRequest
        @return: DeletePhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_physical_connection_with_options(request, runtime)

    async def delete_physical_connection_async(
        self,
        request: ecs_20140526_models.DeletePhysicalConnectionRequest,
    ) -> ecs_20140526_models.DeletePhysicalConnectionResponse:
        """
        @deprecated OpenAPI DeletePhysicalConnection is deprecated, please use Vpc::2016-04-28::DeletePhysicalConnection instead.
        
        @summary DeletePhysicalConnection
        
        @param request: DeletePhysicalConnectionRequest
        @return: DeletePhysicalConnectionResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_physical_connection_with_options_async(request, runtime)

    def delete_port_range_list_with_options(
        self,
        request: ecs_20140526_models.DeletePortRangeListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeletePortRangeListResponse:
        """
        @summary Deletes a port list and all entries in the port list.
        
        @param request: DeletePortRangeListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePortRangeListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_range_list_id):
            query['PortRangeListId'] = request.port_range_list_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePortRangeList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeletePortRangeListResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_port_range_list_with_options_async(
        self,
        request: ecs_20140526_models.DeletePortRangeListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeletePortRangeListResponse:
        """
        @summary Deletes a port list and all entries in the port list.
        
        @param request: DeletePortRangeListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePortRangeListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_range_list_id):
            query['PortRangeListId'] = request.port_range_list_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePortRangeList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeletePortRangeListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_port_range_list(
        self,
        request: ecs_20140526_models.DeletePortRangeListRequest,
    ) -> ecs_20140526_models.DeletePortRangeListResponse:
        """
        @summary Deletes a port list and all entries in the port list.
        
        @param request: DeletePortRangeListRequest
        @return: DeletePortRangeListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_port_range_list_with_options(request, runtime)

    async def delete_port_range_list_async(
        self,
        request: ecs_20140526_models.DeletePortRangeListRequest,
    ) -> ecs_20140526_models.DeletePortRangeListResponse:
        """
        @summary Deletes a port list and all entries in the port list.
        
        @param request: DeletePortRangeListRequest
        @return: DeletePortRangeListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_port_range_list_with_options_async(request, runtime)

    def delete_prefix_list_with_options(
        self,
        request: ecs_20140526_models.DeletePrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeletePrefixListResponse:
        """
        @summary Deletes a prefix list and all entries in the prefix list.
        
        @description If a prefix list is associated with resources, you cannot delete the prefix list. You must disassociate the prefix list from the resources before you delete the prefix list. You can call the [DescribePrefixListAssociations](https://help.aliyun.com/document_detail/204724.html) operation to query resources that are associated with a specific prefix list.
        
        @param request: DeletePrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_id):
            query['PrefixListId'] = request.prefix_list_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrefixList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeletePrefixListResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_prefix_list_with_options_async(
        self,
        request: ecs_20140526_models.DeletePrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeletePrefixListResponse:
        """
        @summary Deletes a prefix list and all entries in the prefix list.
        
        @description If a prefix list is associated with resources, you cannot delete the prefix list. You must disassociate the prefix list from the resources before you delete the prefix list. You can call the [DescribePrefixListAssociations](https://help.aliyun.com/document_detail/204724.html) operation to query resources that are associated with a specific prefix list.
        
        @param request: DeletePrefixListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrefixListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_id):
            query['PrefixListId'] = request.prefix_list_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrefixList',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeletePrefixListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_prefix_list(
        self,
        request: ecs_20140526_models.DeletePrefixListRequest,
    ) -> ecs_20140526_models.DeletePrefixListResponse:
        """
        @summary Deletes a prefix list and all entries in the prefix list.
        
        @description If a prefix list is associated with resources, you cannot delete the prefix list. You must disassociate the prefix list from the resources before you delete the prefix list. You can call the [DescribePrefixListAssociations](https://help.aliyun.com/document_detail/204724.html) operation to query resources that are associated with a specific prefix list.
        
        @param request: DeletePrefixListRequest
        @return: DeletePrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_prefix_list_with_options(request, runtime)

    async def delete_prefix_list_async(
        self,
        request: ecs_20140526_models.DeletePrefixListRequest,
    ) -> ecs_20140526_models.DeletePrefixListResponse:
        """
        @summary Deletes a prefix list and all entries in the prefix list.
        
        @description If a prefix list is associated with resources, you cannot delete the prefix list. You must disassociate the prefix list from the resources before you delete the prefix list. You can call the [DescribePrefixListAssociations](https://help.aliyun.com/document_detail/204724.html) operation to query resources that are associated with a specific prefix list.
        
        @param request: DeletePrefixListRequest
        @return: DeletePrefixListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_prefix_list_with_options_async(request, runtime)

    def delete_route_entry_with_options(
        self,
        request: ecs_20140526_models.DeleteRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteRouteEntryResponse:
        """
        @deprecated OpenAPI DeleteRouteEntry is deprecated, please use Vpc::2016-04-28::DeleteRouteEntry instead.
        
        @summary DeleteRouteEntry
        
        @param request: DeleteRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouteEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_route_entry_with_options_async(
        self,
        request: ecs_20140526_models.DeleteRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteRouteEntryResponse:
        """
        @deprecated OpenAPI DeleteRouteEntry is deprecated, please use Vpc::2016-04-28::DeleteRouteEntry instead.
        
        @summary DeleteRouteEntry
        
        @param request: DeleteRouteEntryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouteEntryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntry',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_route_entry(
        self,
        request: ecs_20140526_models.DeleteRouteEntryRequest,
    ) -> ecs_20140526_models.DeleteRouteEntryResponse:
        """
        @deprecated OpenAPI DeleteRouteEntry is deprecated, please use Vpc::2016-04-28::DeleteRouteEntry instead.
        
        @summary DeleteRouteEntry
        
        @param request: DeleteRouteEntryRequest
        @return: DeleteRouteEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_route_entry_with_options(request, runtime)

    async def delete_route_entry_async(
        self,
        request: ecs_20140526_models.DeleteRouteEntryRequest,
    ) -> ecs_20140526_models.DeleteRouteEntryResponse:
        """
        @deprecated OpenAPI DeleteRouteEntry is deprecated, please use Vpc::2016-04-28::DeleteRouteEntry instead.
        
        @summary DeleteRouteEntry
        
        @param request: DeleteRouteEntryRequest
        @return: DeleteRouteEntryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_route_entry_with_options_async(request, runtime)

    def delete_router_interface_with_options(
        self,
        request: ecs_20140526_models.DeleteRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteRouterInterfaceResponse:
        """
        @deprecated OpenAPI DeleteRouterInterface is deprecated, please use Vpc::2016-04-28::DeleteRouterInterface instead.
        
        @summary DeleteRouterInterface
        
        @param request: DeleteRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_router_interface_with_options_async(
        self,
        request: ecs_20140526_models.DeleteRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteRouterInterfaceResponse:
        """
        @deprecated OpenAPI DeleteRouterInterface is deprecated, please use Vpc::2016-04-28::DeleteRouterInterface instead.
        
        @summary DeleteRouterInterface
        
        @param request: DeleteRouterInterfaceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteRouterInterfaceResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouterInterface',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_router_interface(
        self,
        request: ecs_20140526_models.DeleteRouterInterfaceRequest,
    ) -> ecs_20140526_models.DeleteRouterInterfaceResponse:
        """
        @deprecated OpenAPI DeleteRouterInterface is deprecated, please use Vpc::2016-04-28::DeleteRouterInterface instead.
        
        @summary DeleteRouterInterface
        
        @param request: DeleteRouterInterfaceRequest
        @return: DeleteRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_router_interface_with_options(request, runtime)

    async def delete_router_interface_async(
        self,
        request: ecs_20140526_models.DeleteRouterInterfaceRequest,
    ) -> ecs_20140526_models.DeleteRouterInterfaceResponse:
        """
        @deprecated OpenAPI DeleteRouterInterface is deprecated, please use Vpc::2016-04-28::DeleteRouterInterface instead.
        
        @summary DeleteRouterInterface
        
        @param request: DeleteRouterInterfaceRequest
        @return: DeleteRouterInterfaceResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_router_interface_with_options_async(request, runtime)

    def delete_security_group_with_options(
        self,
        request: ecs_20140526_models.DeleteSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSecurityGroupResponse:
        """
        @summary Deletes a security group and all security group rules in the security group.
        
        @description    Make sure that no Elastic Compute Service (ECS) instances exist in the security group. You can query instances by calling the [DescribeInstances](https://help.aliyun.com/document_detail/2679689.html) operation.
        Make sure that no elastic network interfaces (ENIs) exist in the security group. You can query ENIs by calling the [DescribeNetworkInterfaces](https://help.aliyun.com/document_detail/2679884.html) operation.
        Make sure that the security group that you want to delete is not referenced by rules of other security groups. You can query the associations by calling the [DescribeSecurityGroupReferences](https://help.aliyun.com/document_detail/57320.html) operation.
        If the `InvalidOperation.DeletionProtection` error code is returned when you call the DeleteSecurityGroup operation to delete a security group, the deletion protection feature is enabled for the security group. When you create a Container Service for Kubernetes (ACK) cluster, the deletion protection feature is enabled for an associated security group to prevent accidental deletion. You cannot manually disable the deletion protection feature for the security group. The deletion protection feature can be automatically disabled only after the ACK cluster is deleted. For more information, see the [Disable deletion protection for a security group](https://help.aliyun.com/document_detail/353191.html) section of the "Configure and manage security groups for an ACK cluster" topic.
        
        @param request: DeleteSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSecurityGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_security_group_with_options_async(
        self,
        request: ecs_20140526_models.DeleteSecurityGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSecurityGroupResponse:
        """
        @summary Deletes a security group and all security group rules in the security group.
        
        @description    Make sure that no Elastic Compute Service (ECS) instances exist in the security group. You can query instances by calling the [DescribeInstances](https://help.aliyun.com/document_detail/2679689.html) operation.
        Make sure that no elastic network interfaces (ENIs) exist in the security group. You can query ENIs by calling the [DescribeNetworkInterfaces](https://help.aliyun.com/document_detail/2679884.html) operation.
        Make sure that the security group that you want to delete is not referenced by rules of other security groups. You can query the associations by calling the [DescribeSecurityGroupReferences](https://help.aliyun.com/document_detail/57320.html) operation.
        If the `InvalidOperation.DeletionProtection` error code is returned when you call the DeleteSecurityGroup operation to delete a security group, the deletion protection feature is enabled for the security group. When you create a Container Service for Kubernetes (ACK) cluster, the deletion protection feature is enabled for an associated security group to prevent accidental deletion. You cannot manually disable the deletion protection feature for the security group. The deletion protection feature can be automatically disabled only after the ACK cluster is deleted. For more information, see the [Disable deletion protection for a security group](https://help.aliyun.com/document_detail/353191.html) section of the "Configure and manage security groups for an ACK cluster" topic.
        
        @param request: DeleteSecurityGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_group_id):
            query['SecurityGroupId'] = request.security_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSecurityGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_security_group(
        self,
        request: ecs_20140526_models.DeleteSecurityGroupRequest,
    ) -> ecs_20140526_models.DeleteSecurityGroupResponse:
        """
        @summary Deletes a security group and all security group rules in the security group.
        
        @description    Make sure that no Elastic Compute Service (ECS) instances exist in the security group. You can query instances by calling the [DescribeInstances](https://help.aliyun.com/document_detail/2679689.html) operation.
        Make sure that no elastic network interfaces (ENIs) exist in the security group. You can query ENIs by calling the [DescribeNetworkInterfaces](https://help.aliyun.com/document_detail/2679884.html) operation.
        Make sure that the security group that you want to delete is not referenced by rules of other security groups. You can query the associations by calling the [DescribeSecurityGroupReferences](https://help.aliyun.com/document_detail/57320.html) operation.
        If the `InvalidOperation.DeletionProtection` error code is returned when you call the DeleteSecurityGroup operation to delete a security group, the deletion protection feature is enabled for the security group. When you create a Container Service for Kubernetes (ACK) cluster, the deletion protection feature is enabled for an associated security group to prevent accidental deletion. You cannot manually disable the deletion protection feature for the security group. The deletion protection feature can be automatically disabled only after the ACK cluster is deleted. For more information, see the [Disable deletion protection for a security group](https://help.aliyun.com/document_detail/353191.html) section of the "Configure and manage security groups for an ACK cluster" topic.
        
        @param request: DeleteSecurityGroupRequest
        @return: DeleteSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_security_group_with_options(request, runtime)

    async def delete_security_group_async(
        self,
        request: ecs_20140526_models.DeleteSecurityGroupRequest,
    ) -> ecs_20140526_models.DeleteSecurityGroupResponse:
        """
        @summary Deletes a security group and all security group rules in the security group.
        
        @description    Make sure that no Elastic Compute Service (ECS) instances exist in the security group. You can query instances by calling the [DescribeInstances](https://help.aliyun.com/document_detail/2679689.html) operation.
        Make sure that no elastic network interfaces (ENIs) exist in the security group. You can query ENIs by calling the [DescribeNetworkInterfaces](https://help.aliyun.com/document_detail/2679884.html) operation.
        Make sure that the security group that you want to delete is not referenced by rules of other security groups. You can query the associations by calling the [DescribeSecurityGroupReferences](https://help.aliyun.com/document_detail/57320.html) operation.
        If the `InvalidOperation.DeletionProtection` error code is returned when you call the DeleteSecurityGroup operation to delete a security group, the deletion protection feature is enabled for the security group. When you create a Container Service for Kubernetes (ACK) cluster, the deletion protection feature is enabled for an associated security group to prevent accidental deletion. You cannot manually disable the deletion protection feature for the security group. The deletion protection feature can be automatically disabled only after the ACK cluster is deleted. For more information, see the [Disable deletion protection for a security group](https://help.aliyun.com/document_detail/353191.html) section of the "Configure and manage security groups for an ACK cluster" topic.
        
        @param request: DeleteSecurityGroupRequest
        @return: DeleteSecurityGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_security_group_with_options_async(request, runtime)

    def delete_snapshot_with_options(
        self,
        request: ecs_20140526_models.DeleteSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSnapshotResponse:
        """
        @summary Deletes a specified snapshot. If you call this operation to delete a snapshot that is being created, the associated snapshot creation task is also canceled.
        
        @description Take note of the following items:
        If the snapshot does not exist, the request is ignored.
        If the snapshot has been used to create custom images, the snapshot cannot be deleted. You need to call the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation to delete the custom images before you can delete the snapshot.
        If the snapshot has been used to create disks and `Force` is not specified or is set to `false`, the snapshot cannot be deleted directly. If you want to delete the snapshot, set `Force` to true to forcibly delete the snapshot. The disks created from the snapshot cannot be re-initialized after the snapshot is forcibly deleted.
        
        @param request: DeleteSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSnapshotResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snapshot_with_options_async(
        self,
        request: ecs_20140526_models.DeleteSnapshotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSnapshotResponse:
        """
        @summary Deletes a specified snapshot. If you call this operation to delete a snapshot that is being created, the associated snapshot creation task is also canceled.
        
        @description Take note of the following items:
        If the snapshot does not exist, the request is ignored.
        If the snapshot has been used to create custom images, the snapshot cannot be deleted. You need to call the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation to delete the custom images before you can delete the snapshot.
        If the snapshot has been used to create disks and `Force` is not specified or is set to `false`, the snapshot cannot be deleted directly. If you want to delete the snapshot, set `Force` to true to forcibly delete the snapshot. The disks created from the snapshot cannot be re-initialized after the snapshot is forcibly deleted.
        
        @param request: DeleteSnapshotRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshot',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSnapshotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snapshot(
        self,
        request: ecs_20140526_models.DeleteSnapshotRequest,
    ) -> ecs_20140526_models.DeleteSnapshotResponse:
        """
        @summary Deletes a specified snapshot. If you call this operation to delete a snapshot that is being created, the associated snapshot creation task is also canceled.
        
        @description Take note of the following items:
        If the snapshot does not exist, the request is ignored.
        If the snapshot has been used to create custom images, the snapshot cannot be deleted. You need to call the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation to delete the custom images before you can delete the snapshot.
        If the snapshot has been used to create disks and `Force` is not specified or is set to `false`, the snapshot cannot be deleted directly. If you want to delete the snapshot, set `Force` to true to forcibly delete the snapshot. The disks created from the snapshot cannot be re-initialized after the snapshot is forcibly deleted.
        
        @param request: DeleteSnapshotRequest
        @return: DeleteSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snapshot_with_options(request, runtime)

    async def delete_snapshot_async(
        self,
        request: ecs_20140526_models.DeleteSnapshotRequest,
    ) -> ecs_20140526_models.DeleteSnapshotResponse:
        """
        @summary Deletes a specified snapshot. If you call this operation to delete a snapshot that is being created, the associated snapshot creation task is also canceled.
        
        @description Take note of the following items:
        If the snapshot does not exist, the request is ignored.
        If the snapshot has been used to create custom images, the snapshot cannot be deleted. You need to call the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation to delete the custom images before you can delete the snapshot.
        If the snapshot has been used to create disks and `Force` is not specified or is set to `false`, the snapshot cannot be deleted directly. If you want to delete the snapshot, set `Force` to true to forcibly delete the snapshot. The disks created from the snapshot cannot be re-initialized after the snapshot is forcibly deleted.
        
        @param request: DeleteSnapshotRequest
        @return: DeleteSnapshotResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snapshot_with_options_async(request, runtime)

    def delete_snapshot_group_with_options(
        self,
        request: ecs_20140526_models.DeleteSnapshotGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSnapshotGroupResponse:
        """
        @summary Deletes snapshot-consistent groups.
        
        @description If a disk snapshot that is contained in a snapshot-consistent group has been used to create a custom image, the disk snapshot is retained after the snapshot-consistent group is deleted. Before you can delete the disk snapshot, you must call the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation to delete the custom image. Then, you can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/25525.html) operation to delete the disk snapshot.
        
        @param request: DeleteSnapshotGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_group_id):
            query['SnapshotGroupId'] = request.snapshot_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshotGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSnapshotGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snapshot_group_with_options_async(
        self,
        request: ecs_20140526_models.DeleteSnapshotGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteSnapshotGroupResponse:
        """
        @summary Deletes snapshot-consistent groups.
        
        @description If a disk snapshot that is contained in a snapshot-consistent group has been used to create a custom image, the disk snapshot is retained after the snapshot-consistent group is deleted. Before you can delete the disk snapshot, you must call the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation to delete the custom image. Then, you can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/25525.html) operation to delete the disk snapshot.
        
        @param request: DeleteSnapshotGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSnapshotGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snapshot_group_id):
            query['SnapshotGroupId'] = request.snapshot_group_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnapshotGroup',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteSnapshotGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snapshot_group(
        self,
        request: ecs_20140526_models.DeleteSnapshotGroupRequest,
    ) -> ecs_20140526_models.DeleteSnapshotGroupResponse:
        """
        @summary Deletes snapshot-consistent groups.
        
        @description If a disk snapshot that is contained in a snapshot-consistent group has been used to create a custom image, the disk snapshot is retained after the snapshot-consistent group is deleted. Before you can delete the disk snapshot, you must call the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation to delete the custom image. Then, you can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/25525.html) operation to delete the disk snapshot.
        
        @param request: DeleteSnapshotGroupRequest
        @return: DeleteSnapshotGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_snapshot_group_with_options(request, runtime)

    async def delete_snapshot_group_async(
        self,
        request: ecs_20140526_models.DeleteSnapshotGroupRequest,
    ) -> ecs_20140526_models.DeleteSnapshotGroupResponse:
        """
        @summary Deletes snapshot-consistent groups.
        
        @description If a disk snapshot that is contained in a snapshot-consistent group has been used to create a custom image, the disk snapshot is retained after the snapshot-consistent group is deleted. Before you can delete the disk snapshot, you must call the [DeleteImage](https://help.aliyun.com/document_detail/25537.html) operation to delete the custom image. Then, you can call the [DeleteSnapshot](https://help.aliyun.com/document_detail/25525.html) operation to delete the disk snapshot.
        
        @param request: DeleteSnapshotGroupRequest
        @return: DeleteSnapshotGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_snapshot_group_with_options_async(request, runtime)

    def delete_storage_set_with_options(
        self,
        request: ecs_20140526_models.DeleteStorageSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteStorageSetResponse:
        """
        @summary (Beta) Deletes an empty storage set. The storage set that you want to delete must be empty and do not contain disks or Shared Block Storage devices.
        
        @param request: DeleteStorageSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStorageSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStorageSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteStorageSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_storage_set_with_options_async(
        self,
        request: ecs_20140526_models.DeleteStorageSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteStorageSetResponse:
        """
        @summary (Beta) Deletes an empty storage set. The storage set that you want to delete must be empty and do not contain disks or Shared Block Storage devices.
        
        @param request: DeleteStorageSetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteStorageSetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.storage_set_id):
            query['StorageSetId'] = request.storage_set_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStorageSet',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteStorageSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_storage_set(
        self,
        request: ecs_20140526_models.DeleteStorageSetRequest,
    ) -> ecs_20140526_models.DeleteStorageSetResponse:
        """
        @summary (Beta) Deletes an empty storage set. The storage set that you want to delete must be empty and do not contain disks or Shared Block Storage devices.
        
        @param request: DeleteStorageSetRequest
        @return: DeleteStorageSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_storage_set_with_options(request, runtime)

    async def delete_storage_set_async(
        self,
        request: ecs_20140526_models.DeleteStorageSetRequest,
    ) -> ecs_20140526_models.DeleteStorageSetResponse:
        """
        @summary (Beta) Deletes an empty storage set. The storage set that you want to delete must be empty and do not contain disks or Shared Block Storage devices.
        
        @param request: DeleteStorageSetRequest
        @return: DeleteStorageSetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_storage_set_with_options_async(request, runtime)

    def delete_vswitch_with_options(
        self,
        request: ecs_20140526_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVSwitchResponse:
        """
        @deprecated OpenAPI DeleteVSwitch is deprecated, please use Vpc::2016-04-28::DeleteVSwitch instead.
        
        @summary DeleteVSwitch
        
        @param request: DeleteVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVSwitchResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vswitch_with_options_async(
        self,
        request: ecs_20140526_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVSwitchResponse:
        """
        @deprecated OpenAPI DeleteVSwitch is deprecated, please use Vpc::2016-04-28::DeleteVSwitch instead.
        
        @summary DeleteVSwitch
        
        @param request: DeleteVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVSwitchResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vswitch(
        self,
        request: ecs_20140526_models.DeleteVSwitchRequest,
    ) -> ecs_20140526_models.DeleteVSwitchResponse:
        """
        @deprecated OpenAPI DeleteVSwitch is deprecated, please use Vpc::2016-04-28::DeleteVSwitch instead.
        
        @summary DeleteVSwitch
        
        @param request: DeleteVSwitchRequest
        @return: DeleteVSwitchResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vswitch_with_options(request, runtime)

    async def delete_vswitch_async(
        self,
        request: ecs_20140526_models.DeleteVSwitchRequest,
    ) -> ecs_20140526_models.DeleteVSwitchResponse:
        """
        @deprecated OpenAPI DeleteVSwitch is deprecated, please use Vpc::2016-04-28::DeleteVSwitch instead.
        
        @summary DeleteVSwitch
        
        @param request: DeleteVSwitchRequest
        @return: DeleteVSwitchResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vswitch_with_options_async(request, runtime)

    def delete_virtual_border_router_with_options(
        self,
        request: ecs_20140526_models.DeleteVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVirtualBorderRouterResponse:
        """
        @deprecated OpenAPI DeleteVirtualBorderRouter is deprecated, please use Vpc::2016-04-28::DeleteVirtualBorderRouter instead.
        
        @summary DeleteVirtualBorderRouter
        
        @param request: DeleteVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVirtualBorderRouterResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVirtualBorderRouter',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_virtual_border_router_with_options_async(
        self,
        request: ecs_20140526_models.DeleteVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVirtualBorderRouterResponse:
        """
        @deprecated OpenAPI DeleteVirtualBorderRouter is deprecated, please use Vpc::2016-04-28::DeleteVirtualBorderRouter instead.
        
        @summary DeleteVirtualBorderRouter
        
        @param request: DeleteVirtualBorderRouterRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVirtualBorderRouterResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVirtualBorderRouter',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_virtual_border_router(
        self,
        request: ecs_20140526_models.DeleteVirtualBorderRouterRequest,
    ) -> ecs_20140526_models.DeleteVirtualBorderRouterResponse:
        """
        @deprecated OpenAPI DeleteVirtualBorderRouter is deprecated, please use Vpc::2016-04-28::DeleteVirtualBorderRouter instead.
        
        @summary DeleteVirtualBorderRouter
        
        @param request: DeleteVirtualBorderRouterRequest
        @return: DeleteVirtualBorderRouterResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_virtual_border_router_with_options(request, runtime)

    async def delete_virtual_border_router_async(
        self,
        request: ecs_20140526_models.DeleteVirtualBorderRouterRequest,
    ) -> ecs_20140526_models.DeleteVirtualBorderRouterResponse:
        """
        @deprecated OpenAPI DeleteVirtualBorderRouter is deprecated, please use Vpc::2016-04-28::DeleteVirtualBorderRouter instead.
        
        @summary DeleteVirtualBorderRouter
        
        @param request: DeleteVirtualBorderRouterRequest
        @return: DeleteVirtualBorderRouterResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_virtual_border_router_with_options_async(request, runtime)

    def delete_vpc_with_options(
        self,
        request: ecs_20140526_models.DeleteVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVpcResponse:
        """
        @deprecated OpenAPI DeleteVpc is deprecated, please use Vpc::2016-04-28::DeleteVpc instead.
        
        @summary 删除VPC
        
        @param request: DeleteVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_with_options_async(
        self,
        request: ecs_20140526_models.DeleteVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeleteVpcResponse:
        """
        @deprecated OpenAPI DeleteVpc is deprecated, please use Vpc::2016-04-28::DeleteVpc instead.
        
        @summary 删除VPC
        
        @param request: DeleteVpcRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpc',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeleteVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc(
        self,
        request: ecs_20140526_models.DeleteVpcRequest,
    ) -> ecs_20140526_models.DeleteVpcResponse:
        """
        @deprecated OpenAPI DeleteVpc is deprecated, please use Vpc::2016-04-28::DeleteVpc instead.
        
        @summary 删除VPC
        
        @param request: DeleteVpcRequest
        @return: DeleteVpcResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_with_options(request, runtime)

    async def delete_vpc_async(
        self,
        request: ecs_20140526_models.DeleteVpcRequest,
    ) -> ecs_20140526_models.DeleteVpcResponse:
        """
        @deprecated OpenAPI DeleteVpc is deprecated, please use Vpc::2016-04-28::DeleteVpc instead.
        
        @summary 删除VPC
        
        @param request: DeleteVpcRequest
        @return: DeleteVpcResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_with_options_async(request, runtime)

    def deregister_managed_instance_with_options(
        self,
        request: ecs_20140526_models.DeregisterManagedInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeregisterManagedInstanceResponse:
        """
        @summary Deregisters a managed instance. After you deregister the managed instance, you can no longer use Cloud Assistant to send commands or files to the instance.
        
        @param request: DeregisterManagedInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeregisterManagedInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeregisterManagedInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeregisterManagedInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def deregister_managed_instance_with_options_async(
        self,
        request: ecs_20140526_models.DeregisterManagedInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DeregisterManagedInstanceResponse:
        """
        @summary Deregisters a managed instance. After you deregister the managed instance, you can no longer use Cloud Assistant to send commands or files to the instance.
        
        @param request: DeregisterManagedInstanceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeregisterManagedInstanceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeregisterManagedInstance',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DeregisterManagedInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deregister_managed_instance(
        self,
        request: ecs_20140526_models.DeregisterManagedInstanceRequest,
    ) -> ecs_20140526_models.DeregisterManagedInstanceResponse:
        """
        @summary Deregisters a managed instance. After you deregister the managed instance, you can no longer use Cloud Assistant to send commands or files to the instance.
        
        @param request: DeregisterManagedInstanceRequest
        @return: DeregisterManagedInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.deregister_managed_instance_with_options(request, runtime)

    async def deregister_managed_instance_async(
        self,
        request: ecs_20140526_models.DeregisterManagedInstanceRequest,
    ) -> ecs_20140526_models.DeregisterManagedInstanceResponse:
        """
        @summary Deregisters a managed instance. After you deregister the managed instance, you can no longer use Cloud Assistant to send commands or files to the instance.
        
        @param request: DeregisterManagedInstanceRequest
        @return: DeregisterManagedInstanceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.deregister_managed_instance_with_options_async(request, runtime)

    def describe_access_points_with_options(
        self,
        request: ecs_20140526_models.DescribeAccessPointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAccessPointsResponse:
        """
        @deprecated OpenAPI DescribeAccessPoints is deprecated, please use Vpc::2016-04-28::DescribeAccessPoints instead.
        
        @summary DescribeAccessPoints
        
        @param request: DescribeAccessPointsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessPointsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessPoints',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAccessPointsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_points_with_options_async(
        self,
        request: ecs_20140526_models.DescribeAccessPointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAccessPointsResponse:
        """
        @deprecated OpenAPI DescribeAccessPoints is deprecated, please use Vpc::2016-04-28::DescribeAccessPoints instead.
        
        @summary DescribeAccessPoints
        
        @param request: DescribeAccessPointsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessPointsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessPoints',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAccessPointsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_points(
        self,
        request: ecs_20140526_models.DescribeAccessPointsRequest,
    ) -> ecs_20140526_models.DescribeAccessPointsResponse:
        """
        @deprecated OpenAPI DescribeAccessPoints is deprecated, please use Vpc::2016-04-28::DescribeAccessPoints instead.
        
        @summary DescribeAccessPoints
        
        @param request: DescribeAccessPointsRequest
        @return: DescribeAccessPointsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_access_points_with_options(request, runtime)

    async def describe_access_points_async(
        self,
        request: ecs_20140526_models.DescribeAccessPointsRequest,
    ) -> ecs_20140526_models.DescribeAccessPointsResponse:
        """
        @deprecated OpenAPI DescribeAccessPoints is deprecated, please use Vpc::2016-04-28::DescribeAccessPoints instead.
        
        @summary DescribeAccessPoints
        
        @param request: DescribeAccessPointsRequest
        @return: DescribeAccessPointsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_points_with_options_async(request, runtime)

    def describe_account_attributes_with_options(
        self,
        request: ecs_20140526_models.DescribeAccountAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAccountAttributesResponse:
        """
        @summary Queries the quotas of Elastic Compute Service (ECS) resources that you can create in an Alibaba Cloud region. For a specific region, you can query the maximum numbers of security groups, elastic network interfaces (ENIs), vCPUs for pay-as-you-go instances, vCPUs for spot instances, and dedicated hosts that you can create and the capacity quotas for pay-as-you-go disks that you can create. You can also query information such as network types or whether an account has completed the account verification.
        
        @description After you [create](https://account.alibabacloud.com/register/intl_register.htm) an Alibaba Cloud account, you can create a specific number of ECS instances in different regions within the account. For more information, see [Limits](https://help.aliyun.com/document_detail/25412.html).
        You can apply for a quota increase in the [Quota Center console](https://quotas.console.aliyun.com/products).
        
        @param request: DescribeAccountAttributesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccountAttributesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attribute_name):
            query['AttributeName'] = request.attribute_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccountAttributes',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAccountAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_account_attributes_with_options_async(
        self,
        request: ecs_20140526_models.DescribeAccountAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeAccountAttributesResponse:
        """
        @summary Queries the quotas of Elastic Compute Service (ECS) resources that you can create in an Alibaba Cloud region. For a specific region, you can query the maximum numbers of security groups, elastic network interfaces (ENIs), vCPUs for pay-as-you-go instances, vCPUs for spot instances, and dedicated hosts that you can create and the capacity quotas for pay-as-you-go disks that you can create. You can also query information such as network types or whether an account has completed the account verification.
        
        @description After you [create](https://account.alibabacloud.com/register/intl_register.htm) an Alibaba Cloud account, you can create a specific number of ECS instances in different regions within the account. For more information, see [Limits](https://help.aliyun.com/document_detail/25412.html).
        You can apply for a quota increase in the [Quota Center console](https://quotas.console.aliyun.com/products).
        
        @param request: DescribeAccountAttributesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccountAttributesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attribute_name):
            query['AttributeName'] = request.attribute_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccountAttributes',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeAccountAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_account_attributes(
        self,
        request: ecs_20140526_models.DescribeAccountAttributesRequest,
    ) -> ecs_20140526_models.DescribeAccountAttributesResponse:
        """
        @summary Queries the quotas of Elastic Compute Service (ECS) resources that you can create in an Alibaba Cloud region. For a specific region, you can query the maximum numbers of security groups, elastic network interfaces (ENIs), vCPUs for pay-as-you-go instances, vCPUs for spot instances, and dedicated hosts that you can create and the capacity quotas for pay-as-you-go disks that you can create. You can also query information such as network types or whether an account has completed the account verification.
        
        @description After you [create](https://account.alibabacloud.com/register/intl_register.htm) an Alibaba Cloud account, you can create a specific number of ECS instances in different regions within the account. For more information, see [Limits](https://help.aliyun.com/document_detail/25412.html).
        You can apply for a quota increase in the [Quota Center console](https://quotas.console.aliyun.com/products).
        
        @param request: DescribeAccountAttributesRequest
        @return: DescribeAccountAttributesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_account_attributes_with_options(request, runtime)

    async def describe_account_attributes_async(
        self,
        request: ecs_20140526_models.DescribeAccountAttributesRequest,
    ) -> ecs_20140526_models.DescribeAccountAttributesResponse:
        """
        @summary Queries the quotas of Elastic Compute Service (ECS) resources that you can create in an Alibaba Cloud region. For a specific region, you can query the maximum numbers of security groups, elastic network interfaces (ENIs), vCPUs for pay-as-you-go instances, vCPUs for spot instances, and dedicated hosts that you can create and the capacity quotas for pay-as-you-go disks that you can create. You can also query information such as network types or whether an account has completed the account verification.
        
        @description After you [create](https://account.alibabacloud.com/register/intl_register.htm) an Alibaba Cloud account, you can create a specific number of ECS instances in different regions within the account. For more information, see [Limits](https://help.aliyun.com/document_detail/25412.html).
        You can apply for a quota increase in the [Quota Center console](https://quotas.console.aliyun.com/products).
        
        @param request: DescribeAccountAttributesRequest
        @return: DescribeAccountAttributesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_account_attributes_with_options_async(request, runtime)

    def describe_activations_with_options(
        self,
        request: ecs_20140526_models.DescribeActivationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeActivationsResponse:
        """
        @summary Queries existing activation codes and their usage information.
        
        @description ## [](#)Usage notes
        You can use one of the following methods to check the responses:
        Method 1: During a paged query, when you call the DescribeActivations operation to retrieve the first page of results, use `MaxResults` to specify the maximum number of entries to return in the call. The return value of `NextToken` is a pagination token, which you can use in the next request to retrieve a new page of results. When you call the DescribeActivations operation to retrieve a new page of results, set `NextToken` to the `NextToken` value returned in the previous call and set `MaxResults` to specify the maximum number of entries to return in this call.
        Method 2: Use `PageSize` to specify the number of entries to return on each page, and then use `PageNumber` to specify the number of the page to return. You can use only one of the preceding methods. If you specify `MaxResults` or `NextToken`, the `PageSize` and `PageNumber` request parameters do not take effect and the `TotalCount` response parameter is invalid.
        
        @param request: DescribeActivationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActivationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activation_id):
            query['ActivationId'] = request.activation_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActivations',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeActivationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_activations_with_options_async(
        self,
        request: ecs_20140526_models.DescribeActivationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> ecs_20140526_models.DescribeActivationsResponse:
        """
        @summary Queries existing activation codes and their usage information.
        
        @description ## [](#)Usage notes
        You can use one of the following methods to check the responses:
        Method 1: During a paged query, when you call the DescribeActivations operation to retrieve the first page of results, use `MaxResults` to specify the maximum number of entries to return in the call. The return value of `NextToken` is a pagination token, which you can use in the next request to retrieve a new page of results. When you call the DescribeActivations operation to retrieve a new page of results, set `NextToken` to the `NextToken` value returned in the previous call and set `MaxResults` to specify the maximum number of entries to return in this call.
        Method 2: Use `PageSize` to specify the number of entries to return on each page, and then use `PageNumber` to specify the number of the page to return. You can use only one of the preceding methods. If you specify `MaxResults` or `NextToken`, the `PageSize` and `PageNumber` request parameters do not take effect and the `TotalCount` response parameter is invalid.
        
        @param request: DescribeActivationsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeActivationsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activation_id):
            query['ActivationId'] = request.activation_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.max_results):
            query['MaxResults'] = request.max_results
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeActivations',
            version='2014-05-26',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            ecs_20140526_models.DescribeActivationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_activations(
        self,
        request: ecs_20140526_models.DescribeActivationsRequest,
    ) -> ecs_20140526_models.DescribeActivationsResponse:
        """
        @summary Queries existing activation codes and thei