'''
Coin flip simulation.
you can flip a coin to get heads or tails.
and flip multiple coins at once.

by aiwonderland
Date: 2025-09-27



'''

import random

class Coin:
    def __init__(self,coinnumber):
        '''Initialize a coin with two sides: "Heads" and "Tails".'''
        self.sides = ["Heads", "Tails"]
        self.coin_number = coinnumber
        if not isinstance(coinnumber, int) or coinnumber <= 0:
            raise ValueError("Number of coins must be a positive integer.")
        
    
    def flip(self, times=1):
        '''
        Flip the coin a specified number of times.
        times: int - number of flips (default is 1)
        Returns a list of results.
        '''
        if not isinstance(times, int) or times <= 0:
            raise ValueError("Number of flips must be a positive integer.")

        results = []
        for _ in range(self.coin_number):
            results.append([random.choice(self.sides) for _ in range(times)])
        return results
    
    def __repr__(self):
        '''
        Return a formal string representation of the coin.
        '''
        return f"Coin(coin_number={self.coin_number})"

    def __str__(self):
        '''
        Return a string representation of the coin.
        '''
        return f"Coin with {self.coin_number} sides: {self.sides}"


# ==========================================================================================
# Test the Coin class

def test():
    coin1 = Coin(1)
    print(coin1.flip(5))  # Flip one coin 5 times

    coin2 = Coin(3)
    print(coin2.flip(4))  # Flip three coins 4 times each

if __name__ == "__main__":
    test()
