# Generated by Django 4.2.14 on 2024-08-14 14:20

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import openedx_learning.lib.fields
import openedx_learning.lib.validators


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('oel_collections', '0001_initial'),
    ]

    operations = [
        migrations.RemoveField(
            model_name='collection',
            name='name',
        ),
        migrations.AddField(
            model_name='collection',
            name='created_by',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='collection',
            name='title',
            field=openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, default='Collection', help_text='The title of the collection.', max_length=500),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name='collection',
            name='created',
            field=models.DateTimeField(auto_now_add=True, validators=[openedx_learning.lib.validators.validate_utc_datetime]),
        ),
        migrations.AlterField(
            model_name='collection',
            name='description',
            field=openedx_learning.lib.fields.MultiCollationTextField(blank=True, db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, default='', help_text='Provides extra information for the user about this collection.', max_length=10000),
        ),
        migrations.AlterField(
            model_name='collection',
            name='modified',
            field=models.DateTimeField(auto_now=True, validators=[openedx_learning.lib.validators.validate_utc_datetime]),
        ),
        migrations.AddIndex(
            model_name='collection',
            index=models.Index(fields=['learning_package', 'title'], name='oel_collect_learnin_dfaf89_idx'),
        ),
    ]
