# Generated by Django 3.2.23 on 2024-02-06 03:23

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models

import openedx_learning.lib.fields
import openedx_learning.lib.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('oel_publishing', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Content',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('size', models.PositiveBigIntegerField(validators=[django.core.validators.MaxValueValidator(50000000)])),
                ('hash_digest', models.CharField(editable=False, max_length=40)),
                ('has_file', models.BooleanField()),
                ('text', openedx_learning.lib.fields.MultiCollationTextField(blank=True, db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, max_length=50000, null=True)),
                ('created', models.DateTimeField(validators=[openedx_learning.lib.validators.validate_utc_datetime])),
            ],
            options={
                'verbose_name': 'Content',
                'verbose_name_plural': 'Contents',
            },
        ),
        migrations.CreateModel(
            name='MediaType',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('type', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, max_length=127)),
                ('sub_type', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, max_length=127)),
                ('suffix', openedx_learning.lib.fields.MultiCollationCharField(blank=True, db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, max_length=127)),
            ],
        ),
        migrations.AddConstraint(
            model_name='mediatype',
            constraint=models.UniqueConstraint(fields=('type', 'sub_type', 'suffix'), name='oel_contents_uniq_t_st_sfx'),
        ),
        migrations.AddField(
            model_name='content',
            name='learning_package',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oel_publishing.learningpackage'),
        ),
        migrations.AddField(
            model_name='content',
            name='media_type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='oel_contents.mediatype'),
        ),
        migrations.AddIndex(
            model_name='content',
            index=models.Index(fields=['learning_package', '-size'], name='oel_content_idx_lp_rsize'),
        ),
        migrations.AddConstraint(
            model_name='content',
            constraint=models.UniqueConstraint(fields=('learning_package', 'media_type', 'hash_digest'), name='oel_content_uniq_lc_media_type_hash_digest'),
        ),
    ]
