# Generated by Django 3.2.23 on 2024-02-06 00:36

import uuid

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import openedx_learning.lib.fields
import openedx_learning.lib.validators


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='LearningPackage',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True, verbose_name='UUID')),
                ('key', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_bin', 'sqlite': 'BINARY'}, max_length=500)),
                ('title', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, max_length=500)),
                ('description', openedx_learning.lib.fields.MultiCollationTextField(blank=True, db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, default='', max_length=10000)),
                ('created', models.DateTimeField(validators=[openedx_learning.lib.validators.validate_utc_datetime])),
                ('updated', models.DateTimeField(validators=[openedx_learning.lib.validators.validate_utc_datetime])),
            ],
            options={
                'verbose_name': 'Learning Package',
                'verbose_name_plural': 'Learning Packages',
            },
        ),
        migrations.CreateModel(
            name='PublishableEntity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True, verbose_name='UUID')),
                ('key', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_bin', 'sqlite': 'BINARY'}, max_length=500)),
                ('created', models.DateTimeField(validators=[openedx_learning.lib.validators.validate_utc_datetime])),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('learning_package', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='publishable_entities', to='oel_publishing.learningpackage')),
            ],
            options={
                'verbose_name': 'Publishable Entity',
                'verbose_name_plural': 'Publishable Entities',
            },
        ),
        migrations.CreateModel(
            name='PublishableEntityVersion',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True, verbose_name='UUID')),
                ('title', openedx_learning.lib.fields.MultiCollationCharField(blank=True, db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, default='', max_length=500)),
                ('version_num', models.PositiveIntegerField(validators=[django.core.validators.MinValueValidator(1)])),
                ('created', models.DateTimeField(validators=[openedx_learning.lib.validators.validate_utc_datetime])),
                ('created_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
                ('entity', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='versions', to='oel_publishing.publishableentity')),
            ],
            options={
                'verbose_name': 'Publishable Entity Version',
                'verbose_name_plural': 'Publishable Entity Versions',
            },
        ),
        migrations.CreateModel(
            name='PublishLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, unique=True, verbose_name='UUID')),
                ('message', openedx_learning.lib.fields.MultiCollationCharField(blank=True, db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, default='', max_length=500)),
                ('published_at', models.DateTimeField(validators=[openedx_learning.lib.validators.validate_utc_datetime])),
                ('learning_package', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='oel_publishing.learningpackage')),
                ('published_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Publish Log',
                'verbose_name_plural': 'Publish Logs',
            },
        ),
        migrations.CreateModel(
            name='Draft',
            fields=[
                ('entity', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='oel_publishing.publishableentity')),
            ],
        ),
        migrations.CreateModel(
            name='Published',
            fields=[
                ('entity', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, primary_key=True, serialize=False, to='oel_publishing.publishableentity')),
            ],
            options={
                'verbose_name': 'Published Entity',
                'verbose_name_plural': 'Published Entities',
            },
        ),
        migrations.CreateModel(
            name='PublishLogRecord',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('entity', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='oel_publishing.publishableentity')),
                ('new_version', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.RESTRICT, to='oel_publishing.publishableentityversion')),
                ('old_version', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.RESTRICT, related_name='+', to='oel_publishing.publishableentityversion')),
                ('publish_log', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='records', to='oel_publishing.publishlog')),
            ],
            options={
                'verbose_name': 'Publish Log Record',
                'verbose_name_plural': 'Publish Log Records',
            },
        ),
        migrations.AddConstraint(
            model_name='learningpackage',
            constraint=models.UniqueConstraint(fields=('key',), name='oel_publishing_lp_uniq_key'),
        ),
        migrations.AddIndex(
            model_name='publishlogrecord',
            index=models.Index(fields=['entity', '-publish_log'], name='oel_plr_idx_entity_rplr'),
        ),
        migrations.AddConstraint(
            model_name='publishlogrecord',
            constraint=models.UniqueConstraint(fields=('publish_log', 'entity'), name='oel_plr_uniq_pl_publishable'),
        ),
        migrations.AddField(
            model_name='published',
            name='publish_log_record',
            field=models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, to='oel_publishing.publishlogrecord'),
        ),
        migrations.AddField(
            model_name='published',
            name='version',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.RESTRICT, to='oel_publishing.publishableentityversion'),
        ),
        migrations.AddIndex(
            model_name='publishableentityversion',
            index=models.Index(fields=['entity', '-created'], name='oel_pv_idx_entity_rcreated'),
        ),
        migrations.AddIndex(
            model_name='publishableentityversion',
            index=models.Index(fields=['title'], name='oel_pv_idx_title'),
        ),
        migrations.AddConstraint(
            model_name='publishableentityversion',
            constraint=models.UniqueConstraint(fields=('entity', 'version_num'), name='oel_pv_uniq_entity_version_num'),
        ),
        migrations.AddIndex(
            model_name='publishableentity',
            index=models.Index(fields=['key'], name='oel_pub_ent_idx_key'),
        ),
        migrations.AddIndex(
            model_name='publishableentity',
            index=models.Index(fields=['learning_package', '-created'], name='oel_pub_ent_idx_lp_rcreated'),
        ),
        migrations.AddConstraint(
            model_name='publishableentity',
            constraint=models.UniqueConstraint(fields=('learning_package', 'key'), name='oel_pub_ent_uniq_lp_key'),
        ),
        migrations.AddField(
            model_name='draft',
            name='version',
            field=models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.RESTRICT, to='oel_publishing.publishableentityversion'),
        ),
    ]
