# Generated by Django 3.2.19 on 2023-10-09 22:46

import django.db.models.deletion
from django.db import migrations, models

import openedx_learning.lib.fields
import openedx_tagging.core.tagging.models.import_export


class Migration(migrations.Migration):

    replaces = [
        ('oel_tagging', '0001_initial'),
        ('oel_tagging', '0002_auto_20230718_2026'),
        ('oel_tagging', '0003_auto_20230721_1238'),
        ('oel_tagging', '0004_auto_20230723_2001'),
        ('oel_tagging', '0005_language_taxonomy'),
        ('oel_tagging', '0006_alter_objecttag_unique_together'),
        ('oel_tagging', '0006_auto_20230802_1631'),
        ('oel_tagging', '0007_tag_import_task_log_null_fix'),
        ('oel_tagging', '0008_taxonomy_description_not_null'),
        ('oel_tagging', '0009_alter_objecttag_object_id'),
        ('oel_tagging', '0010_cleanups'),
        ('oel_tagging', '0011_remove_required'),
    ]

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Taxonomy',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('name', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, db_index=True, help_text='User-facing label used when applying tags from this taxonomy to Open edX objects.', max_length=255)),
                ('description', openedx_learning.lib.fields.MultiCollationTextField(blank=True, help_text='Provides extra information for the user when applying tags from this taxonomy to an object.')),
                ('enabled', models.BooleanField(default=True, help_text='Only enabled taxonomies will be shown to authors.')),
                ('allow_multiple', models.BooleanField(default=True, help_text='Indicates that multiple tags from this taxonomy may be added to an object.')),
                ('allow_free_text', models.BooleanField(default=False, help_text='Indicates that tags in this taxonomy need not be predefined; authors may enter their own tag values.')),
                ('visible_to_authors', models.BooleanField(default=True, editable=False, help_text='Indicates whether this taxonomy should be visible to object authors.')),
                ('_taxonomy_class', models.CharField(help_text='Taxonomy subclass used to instantiate this instance; must be a fully-qualified module and class name. If the module/class cannot be imported, an error is logged and the base Taxonomy class is used instead.', max_length=255, null=True)),
            ],
            options={
                'verbose_name_plural': 'Taxonomies',
            },
        ),
        migrations.CreateModel(
            name='TagImportTask',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('log', models.TextField(blank=True, default=None, help_text='Action execution logs')),
                ('status', models.CharField(choices=[(openedx_tagging.core.tagging.models.import_export.TagImportTaskState['LOADING_DATA'], 'loading_data'), (openedx_tagging.core.tagging.models.import_export.TagImportTaskState['PLANNING'], 'planning'), (openedx_tagging.core.tagging.models.import_export.TagImportTaskState['EXECUTING'], 'executing'), (openedx_tagging.core.tagging.models.import_export.TagImportTaskState['SUCCESS'], 'success'), (openedx_tagging.core.tagging.models.import_export.TagImportTaskState['ERROR'], 'error')], help_text='Task status', max_length=20)),
                ('creation_date', models.DateTimeField(auto_now_add=True)),
                ('taxonomy', models.ForeignKey(help_text='Taxonomy associated with this import', on_delete=django.db.models.deletion.CASCADE, to='oel_tagging.taxonomy')),
            ],
        ),
        migrations.CreateModel(
            name='Tag',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('value', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, help_text="Content of a given tag, occupying the 'value' part of the key:value pair.", max_length=500)),
                ('external_id', openedx_learning.lib.fields.MultiCollationCharField(blank=True, db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, help_text='Used to link an Open edX Tag with a tag in an externally-defined taxonomy.', max_length=255, null=True)),
                ('parent', models.ForeignKey(default=None, help_text='Tag that lives one level up from the current tag, forming a hierarchy.', null=True, on_delete=django.db.models.deletion.CASCADE, related_name='children', to='oel_tagging.tag')),
                ('taxonomy', models.ForeignKey(default=None, help_text='Namespace and rules for using a given set of tags.', null=True, on_delete=django.db.models.deletion.CASCADE, to='oel_tagging.taxonomy')),
            ],
        ),
        migrations.CreateModel(
            name='ObjectTag',
            fields=[
                ('id', models.BigAutoField(primary_key=True, serialize=False)),
                ('object_id', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_bin', 'sqlite': 'BINARY'}, db_index=True, editable=False, help_text='Identifier for the object being tagged', max_length=255)),
                ('_name', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, help_text='User-facing label used for this tag, stored in case taxonomy is (or becomes) null. If the taxonomy field is set, then taxonomy.name takes precedence over this field.', max_length=255)),
                ('_value', openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, help_text='User-facing value used for this tag, stored in case tag is null, e.g if taxonomy is free text, or if it becomes null (e.g. if the Tag is deleted). If the tag field is set, then tag.value takes precedence over this field.', max_length=500)),
                ('tag', models.ForeignKey(blank=True, default=None, help_text="Tag associated with this object tag. Provides the tag's 'value' if set.", null=True, on_delete=django.db.models.deletion.SET_NULL, to='oel_tagging.tag')),
                ('taxonomy', models.ForeignKey(default=None, help_text="Taxonomy that this object tag belongs to. Used for validating the tag and provides the tag's 'name' if set.", null=True, on_delete=django.db.models.deletion.SET_NULL, to='oel_tagging.taxonomy')),
            ],
        ),
        migrations.CreateModel(
            name='SystemDefinedTaxonomy',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('oel_tagging.taxonomy',),
        ),
        migrations.AddIndex(
            model_name='tagimporttask',
            index=models.Index(fields=['taxonomy', '-creation_date'], name='oel_tagging_taxonom_5e948c_idx'),
        ),
        migrations.AddIndex(
            model_name='tag',
            index=models.Index(fields=['taxonomy', 'value'], name='oel_tagging_taxonom_89e779_idx'),
        ),
        migrations.AddIndex(
            model_name='tag',
            index=models.Index(fields=['taxonomy', 'external_id'], name='oel_tagging_taxonom_44e355_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='tag',
            unique_together={('taxonomy', 'external_id'), ('taxonomy', 'value')},
        ),
        migrations.AddIndex(
            model_name='objecttag',
            index=models.Index(fields=['taxonomy', 'object_id'], name='oel_tagging_taxonom_aa24e6_idx'),
        ),
        migrations.AddIndex(
            model_name='objecttag',
            index=models.Index(fields=['taxonomy', '_value'], name='oel_tagging_taxonom_3668ec_idx'),
        ),
        migrations.AlterUniqueTogether(
            name='objecttag',
            unique_together={('object_id', 'taxonomy', '_value'), ('object_id', 'taxonomy', 'tag_id')},
        ),
        migrations.CreateModel(
            name='LanguageTaxonomy',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('oel_tagging.systemdefinedtaxonomy',),
        ),
        migrations.CreateModel(
            name='ModelSystemDefinedTaxonomy',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('oel_tagging.systemdefinedtaxonomy',),
        ),
        migrations.CreateModel(
            name='UserSystemDefinedTaxonomy',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('oel_tagging.modelsystemdefinedtaxonomy',),
        ),
    ]
