# Generated by Django 3.2.22 on 2024-03-22 19:47

import django.db.models.deletion
from django.db import migrations, models

import openedx_learning.lib.fields


def migrate_export_id(apps, schema_editor):
    ObjectTag = apps.get_model("oel_tagging", "ObjectTag")
    for object_tag in ObjectTag.objects.all():
        if object_tag.taxonomy:
            object_tag.export_id = object_tag.taxonomy.export_id
            object_tag.save(update_fields=["_export_id"])


def reverse_export_id(apps, schema_editor):
    pass


def migrate_language_export_id(apps, schema_editor):
    Taxonomy = apps.get_model("oel_tagging", "Taxonomy")
    language_taxonomy = Taxonomy.objects.get(id=-1)
    language_taxonomy.export_id = 'languages-v1'
    language_taxonomy.save(update_fields=["export_id"])


def reverse_language_export_id(apps, schema_editor):
    """
    Return to old export_id
    """
    Taxonomy = apps.get_model("oel_tagging", "Taxonomy")
    language_taxonomy = Taxonomy.objects.get(id=-1)
    language_taxonomy.export_id = '-1-languages'
    language_taxonomy.save(update_fields=["export_id"])


class Migration(migrations.Migration):

    dependencies = [
        ('oel_tagging', '0015_taxonomy_export_id'),
    ]

    operations = [
        migrations.RenameField(
            model_name='objecttag',
            old_name='_name',
            new_name='_export_id',
        ),
        migrations.RunPython(migrate_export_id, reverse_export_id),
        migrations.AlterField(
            model_name='objecttag',
            name='taxonomy',
            field=models.ForeignKey(blank=True, default=None, help_text="Taxonomy that this object tag belongs to. Used for validating the tag and provides the tag's 'name' if set.", null=True, on_delete=django.db.models.deletion.SET_NULL, to='oel_tagging.taxonomy'),
        ),
        migrations.AlterField(
            model_name='objecttag',
            name='_export_id',
            field=openedx_learning.lib.fields.MultiCollationCharField(db_collations={'mysql': 'utf8mb4_unicode_ci', 'sqlite': 'NOCASE'}, help_text='User-facing label used for this tag, stored in case taxonomy is (or becomes) null. If the taxonomy field is set, then taxonomy.export_id takes precedence over this field.', max_length=255),
        ),
        migrations.RunPython(migrate_language_export_id, reverse_language_export_id),
    ]
