import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AgentPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/agent_pool#name AgentPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/agent_pool#organization AgentPool#organization}
    */
    readonly organization: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/agent_pool tfe_agent_pool}
*/
export declare class AgentPool extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/agent_pool tfe_agent_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AgentPoolConfig
    */
    constructor(scope: Construct, id: string, config: AgentPoolConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
