import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AgentTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/agent_token#agent_pool_id AgentToken#agent_pool_id}
    */
    readonly agentPoolId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/r/agent_token#description AgentToken#description}
    */
    readonly description: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/r/agent_token tfe_agent_token}
*/
export declare class AgentToken extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/r/agent_token tfe_agent_token} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AgentTokenConfig
    */
    constructor(scope: Construct, id: string, config: AgentTokenConfig);
    private _agentPoolId?;
    get agentPoolId(): string;
    set agentPoolId(value: string);
    get agentPoolIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    get id(): string;
    get token(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
