import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataTfeAgentPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/agent_pool#name DataTfeAgentPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/tfe/d/agent_pool#organization DataTfeAgentPool#organization}
    */
    readonly organization: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/tfe/d/agent_pool tfe_agent_pool}
*/
export declare class DataTfeAgentPool extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/tfe/d/agent_pool tfe_agent_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataTfeAgentPoolConfig
    */
    constructor(scope: Construct, id: string, config: DataTfeAgentPoolConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
